with IppoLego ; use IppoLego ;
--
-- Cet acteur contient des fonctions de déplacement du robot de plus haut niveau.
--
package IppoHelper is
   
   -- Représente un vecteur
   type T_Vecteur is record
      DX : Integer ;
      DY : Integer ;
   end record ;
   
   
   -- Additionne une position et un vecteur
   function Add (Pos : T_Position ; Vec : T_Vecteur) return T_Position ;
   
      
   -- Calcule le vecteur correspondant au déplacement entre deux intersections voisines
   --   lorsque le robot a l'angle indiqué.
   -- L'angle doit être assez proche de 45, -45, 135, -135   (modulo 360)
   function Calcule_Vecteur (Angle_Robot : Float) return T_Vecteur ;
   
   
   -- Rotation du robot, en mettant à jour une variable angulaire (in out)
   -- L'angle actuel sera toujours dans [0, 360[
   procedure Pivoter (Angle_Actuel : in out Float ; Num : Integer ; Angle : Float) ;
   
   
   -- Aide le robot à s'approcher d'une cible
   -- Arguments : la position du robot et son angle de rotation
   --             la position de la cible, qui doit être différente de celle du robot.
   -- Renvoie   : l'angle dont il faut faire pivoter le robot
   --             cette fonction suit toujours les lignes noires et ne fera jamais sortir le robot du damier
   function Angle_Cible (Angle_Actuel : Float ; Position : T_Position ; Cible : T_Position) return Float ;
   
   -- Renvoie un nombre aléatoire dans l'intervalle [0 ; N]
   function Aleatoire (N : Integer) return Integer ;
   
   -- Racine carrée
   function SQRT (X : Float) return Float ;
   
   

   
end IppoHelper ;



