--
-- Pilotage des robots
--
package IppoLego is
   
   -- Position d'une case sur le damier
   type T_Position is record
      X : Integer ;
      Y : Integer ;
   end record ;
   
   -- Au début, le damier est vide. 
   -- Cette fonction ajoute un nouveau robot et renvoie son numéro d'identifiant.
   -- Les robots sont automatiquement numérotés à partir de 1.
   -- L'angle indique comment le robot est orienté au départ. (0 = vers la droite, 90 = vers le haut)
   function Nouveau_Robot (Pos : T_Position ; Angle : Float) return Integer ;
   
   -- Renvoie le nombre de robots présents sur le damier
   function Nb_Robots return Integer ;
         
   -- Fait rouler le robot tout droit (dans sa direction actuelle), en suivant une ligne noire.
   -- L'action se termine lorsque le robot a dépassé la prochaine intersection.
   -- En raison de son élan, le robot aura sensiblement dépassé l'intersection.
   procedure Franchir_Intersection (Num : Integer) ;
   
   -- Idem, mais s'arrête précisément sur la prochaine intersection.
   -- La position du robot sera au milieu de la case.
   procedure Arreter_A_Intersection (Num : Integer) ;
   
   -- Pivoter de l'angle relatif indiqué (positif = vers la gauche).
   procedure Pivoter (Num : Integer ; Angle : Float) ;
   
   -- Prend le pion situé sous le robot (nécessite que le robot soit bien positionné sur le milieu de l'intersection)
   procedure Prendre_Pion (Num : Integer) ;
   
   -- Pose le pion transporté par le robot (nécessite que le robot soit bien positionné ...)
   procedure Pose_Pion (Num : Integer) ;
   
   -- Attend que l'utilisateur appuie sur "entrée"
   procedure Attendre_Entree ;
   
   
   -- Résultat renvoyé par Lire\_RFID
   type T_RFID_Result is record
      -- Present indique si un signal RFID a été détecté
      Present : Boolean ;
      
      -- Si un signal a été détecté, ID reçoit la valeur du signal
      -- Sinon, ID peut valoir n'importe quoi
      ID : Integer ;
   end record ;
   
   -- Interroge le capteur RFID pour détecter la présence d'un pion
   function Lire_RFID (Num : Integer) return T_RFID_Result ;
   
   
   --
   -- Ces procédures sont utilisées seulement par le simulateur.
   --
   
   -- Indique au simulateur qu'un pion se trouve dans la case indiquée
   -- Il faut fournir l'identifiant RFID du pion, et le chemin complet vers l'image pour représenter le pion à l'écran.
   -- "pion-noir.png" et "pion-blanc.png" existent déjà.
   -- Cette procédure est utilisée au début du programme pour initialiser le plateau.
   procedure Place_Pion (RFID : Integer ; Pos : T_Position ; Image : String) ;
   
   -- Debug : demande au simulateur de vérifier si le robot est bien placé à cet endroit.
   -- Si ce n'est pas le cas, une erreur est levée.
   procedure Verif_Position (Num : Integer ; Pos : T_Position) ;
   
end IppoLego ;

