--
-- Pilotage des robots
--
package KakoRobot is

   -- Renvoie le nombre de robots de la grille
   -- Les robots sont numérotés de 1 à N.
   function Nombre_Robots return Integer ;


   -- Attend que l'utilisateur appuie sur "entrée"
   -- (L'utilisation de cette procédure est purement facultatif)
   procedure Attendre_Entree ;


   -- Liste des directions
   Nord      : constant Character := 'N' ;
   Est       : constant Character := 'E' ;
   Sud       : constant Character := 'S' ;
   Ouest     : constant Character := 'O' ;

   -- Déplace le robot NUMERO d'une case dans la direction indiquée
   procedure Deplacer (Numero : Integer ; Dir : Character) ;


   -- Liste des objets
   Rien      : constant Integer := 0 ;
   Bombe     : constant Integer := 1 ;
   Cible     : constant Integer := 2 ;
   Robot     : constant Integer := 3 ;
   -- Dehors signifie que la case est en dehors des limites du plateau
   Dehors    : constant Integer := 4 ;

   -- Cette fonction renvoie le contenu de la case située
   -- dans la direction indiquée (pour le robot NUMERO)
   -- L'entier retourné vaut 0, 1, 2, 3, ou 4, selon les codes ci-dessus.
   function Scanner (Numero : Integer ; Dir : Character) return Integer ;



   Etat_HS    : constant Integer := 0 ;
   Etat_Pret  : constant Integer := 1 ;
   Etat_Gagne : constant Integer := 2 ;

   -- Indique dans quel état est le robot NUMERO
   --    0 signifie que le robot est hors-service
   --    1 signifie que le robot est en état de marche
   --    2 signifie que le robot a atteint son but
   function Etat (Numero : Integer) return Integer ;


   -- Renvoie la quantité d'énergie restant du robot NUMERO
   function Energie (Numero : Integer) return Integer ;



   -- Coordonnées sur le plateau
   -- (0,0) est situé en haut à gauche
   -- Les Y sont donc croissant vers le bas !
   type T_Coords is record
      X : Integer ;
      Y : Integer ;
   end record ;

   -- Renvoie les coordonnées du robot indiqué
   function Loc_Robot (Numero : Integer) return T_Coords ;

   -- Renvoie les coordonnées d'une cible du plateau
   function Loc_Cible return T_Coords ;

   -- Fonction racine carrée
   function SQRT (X : Float) return Float ;


end KakoRobot ;
