with GAda.Core ;
with Gada.Text_IO ;

package body Villes is
   
   package Txt renames Gada.Text_IO ;
   
   -- Compte les appels pour prévenir les boucles infinies.
   Nb_Appels : Integer := 0 ;

   Max_Appels : constant Integer := 2000000 ;
   
   procedure Compte_Appel is
   begin
      Nb_Appels := Nb_Appels + 1 ;
      if Nb_Appels > Max_Appels then
         raise Gada.Core.Boucle_Infinie ;
      end if ;
   end Compte_Appel ;

   type T_Info is record
      V1 : Integer ;
      V2 : access String ;
      V3 : Integer ;
      V4 : Integer ;
      V5 : Integer ;
      V6 : Integer ;
      V7 : Float ;
      V8 : Float ;
      V9 : Float ;
      V10 : Integer ;
      V11 : Integer ;
   end record ;

   type T_Objects is array(Integer range 1..7463) of T_Info ;

   Objects : T_Objects := ( 
(31,new String'("Lunax"),31350,60,56,11,5.1,0.683333,43.3333,217,298),
(31,new String'("Fontenilles"),31470,4505,2920,222,20.22,1.2,43.55,174,280),
(31,new String'("Arbon"),31160,92,76,20,4.47,0.75,43.0,468,896),
(31,new String'("Loudet"),31580,206,218,40,5.13,0.566667,43.15,447,525),
(31,new String'("Castillon-de-Larboust"),31110,65,83,3,20.67,0.533333,42.8,877,3110),
(31,new String'("Saint-Aventin"),31110,87,96,5,17.4,0.55,42.8167,679,2676),
(31,new String'("Gensac-sur-Garonne"),31310,346,264,34,10.14,1.13333,43.2167,215,380),
(31,new String'("Pin-Balma"),31130,887,655,133,6.63,1.53333,43.6333,144,231),
(31,new String'("Ausseing"),31260,72,61,12,5.88,1.01667,43.15,339,613),
(31,new String'("Ségreville"),31460,213,144,42,4.97,1.73333,43.5,180,272),
(31,new String'("Tarabel"),31570,355,373,47,7.42,1.66667,43.5167,168,252),
(31,new String'("Seilh"),31840,3065,2086,497,6.16,1.35,43.7,112,145),
(31,new String'("Roques"),31120,3850,2988,413,9.3,1.375,43.5083,148,164),
(31,new String'("Bragayrac"),31470,272,250,32,8.25,1.06667,43.4833,204,326),
(31,new String'("Boudrac"),31580,131,122,11,11.64,0.55,43.2,379,564),
(31,new String'("Esténos"),31440,185,167,54,3.41,0.633333,42.95,466,1467),
(31,new String'("Mirepoix-sur-Tarn"),31340,701,537,128,5.46,1.58333,43.8167,85,221),
(31,new String'("Juzes"),31540,80,84,21,3.75,1.8,43.45,195,251),
(31,new String'("Salies-du-Salat"),31260,1998,1946,293,6.81,0.95,43.1167,281,428),
(31,new String'("Soueich"),31160,542,502,47,11.33,0.783333,43.05,360,700),
(31,new String'("Beauzelle"),31700,5179,5375,1171,4.42,1.36667,43.6667,115,145),
(31,new String'("Sauveterre-de-Comminges"),31510,720,720,23,30.52,0.667778,43.0334,407,1031),
(31,new String'("Portet-de-Luchon"),31110,28,32,6,4.11,0.5,42.8,1229,1928),
(31,new String'("Gragnague"),31380,1772,1437,135,13.04,1.58333,43.6833,136,233),
(31,new String'("Lacaugne"),31390,198,168,32,6.06,1.26667,43.2833,223,333),
(31,new String'("Lestelle-de-Saint-Martory"),31360,445,378,47,9.4,0.916667,43.1333,284,410),
(31,new String'("Saint-Gaudens"),31800,11248,10837,411,27.35,0.733333,43.1167,338,558),
(31,new String'("Lacroix-Falgarde"),31120,2028,1485,333,6.09,1.41667,43.5,146,254),
(31,new String'("Lez"),31440,62,67,23,2.6,0.7,42.9167,499,1180),
(31,new String'("Vigoulet-Auzil"),31320,944,989,272,3.46,1.46667,43.5,169,262),
(31,new String'("Cazères"),31220,4667,3258,238,19.55,1.08333,43.2167,215,362),
(31,new String'("Empeaux"),31470,234,165,51,4.56,1.08333,43.5333,171,311),
(31,new String'("Le Cuing"),31210,424,351,32,13.05,0.6,43.15,412,517),
(31,new String'("Le Fauga"),31410,1776,1100,199,8.92,1.28333,43.4,165,282),
(31,new String'("Saint-Julia"),31540,369,333,32,11.46,1.9,43.4833,200,301),
(31,new String'("Roquettes"),31120,3612,3291,1075,3.36,1.35,43.5,148,163),
(31,new String'("Lagrâce-Dieu"),31190,478,269,56,8.52,1.4,43.3333,181,321),
(31,new String'("Saint-Marcel-Paulel"),31590,449,401,63,7.1,1.6,43.6667,143,230),
(31,new String'("Lilhac"),31230,132,90,18,7.3,0.816667,43.2833,280,381),
(31,new String'("Léguevin"),31490,8475,6177,346,24.45,1.25,43.6,164,237),
(31,new String'("Sengouagnet"),31160,222,219,11,18.6,0.783333,42.9833,467,1908),
(31,new String'("Colomiers"),31770,35186,28538,1689,20.83,1.35,43.6167,145,191),
(31,new String'("Castagnède"),31260,176,184,53,3.32,0.966667,43.05,312,442),
(31,new String'("Péchabou"),31320,2011,1303,563,3.57,1.5,43.5,148,261),
(31,new String'("Fos"),31440,252,273,13,18.17,0.733333,42.8667,520,2024),
(31,new String'("Fabas"),31230,213,214,11,18.68,0.894722,43.3142,256,357),
(31,new String'("Pouy-de-Touges"),31430,363,222,26,13.79,1.03333,43.35,232,368),
(31,new String'("Chaum"),31440,214,193,37,5.7,0.65,42.9333,468,1680),
(31,new String'("Francazal"),31260,20,16,3,5.46,1.03333,43.0167,371,1254),
(31,new String'("Cardeilhac"),31350,256,230,13,18.41,0.683333,43.2,335,488),
(31,new String'("Mondavezan"),31220,787,643,37,21.09,1.03333,43.2333,252,374),
(31,new String'("Monestrol"),31560,60,55,11,5.23,1.66667,43.3333,209,302),
(31,new String'("Barbazan"),31510,447,381,73,6.05,0.633333,43.0333,439,890),
(31,new String'("Montjoire"),31380,1201,1021,59,20.29,1.53333,43.7833,114,235),
(31,new String'("Figarol"),31260,276,236,23,11.6,0.9,43.0833,295,425),
(31,new String'("Montauban-de-Luchon"),31110,465,459,77,6.02,0.616667,42.8,617,1902),
(31,new String'("Montgiscard"),31450,2068,1945,157,13.16,1.58333,43.45,153,274),
(31,new String'("Muret"),31600,23864,20742,412,57.84,1.35,43.4667,152,305),
(31,new String'("Terrebasse"),31420,139,121,14,9.56,0.966667,43.25,261,380),
(31,new String'("Montesquieu-Lauragais"),31450,917,854,37,24.75,1.63333,43.4167,158,274),
(31,new String'("Daux"),31700,1920,1256,113,16.88,1.25,43.7,119,193),
(31,new String'("La Magdelaine-sur-Tarn"),31340,1006,610,147,6.82,1.55,43.8167,85,122),
(31,new String'("Cabanac-Cazaux"),31160,122,108,32,3.81,0.75,43.0333,380,788),
(31,new String'("Saint-Lys"),31470,8537,5472,400,21.3,1.2,43.5167,175,220),
(31,new String'("Aurin"),31570,330,245,44,7.49,1.66667,43.5333,167,265),
(31,new String'("Vieille-Toulouse"),31320,1120,890,202,5.53,1.45,43.5167,141,266),
(31,new String'("Ramonville-Saint-Agne"),31520,11994,11647,1856,6.46,1.46667,43.55,143,252),
(31,new String'("Mauvezin"),31230,83,48,17,4.76,0.924444,43.3864,192,316),
(31,new String'("Le Pin-Murelet"),31370,184,151,15,12.04,1.01667,43.4,207,352),
(31,new String'("Ore"),31510,119,109,41,2.86,0.65,42.9667,453,724),
(31,new String'("Saint-Lary-Boujean"),31350,131,116,15,8.39,0.735833,43.2289,315,431),
(31,new String'("Anan"),31230,222,230,16,13.43,0.833333,43.35,199,327),
(31,new String'("Miremont"),31190,2086,1446,93,22.4,1.41667,43.3667,167,291),
(31,new String'("Caubous"),31110,6,12,1,3.78,0.522222,42.8509,1199,1918),
(31,new String'("Francon"),31420,210,168,22,9.54,0.966667,43.2667,255,365),
(31,new String'("Ausson"),31210,530,542,120,4.39,0.6,43.0833,399,466),
(31,new String'("Boussens"),31360,1088,834,251,4.33,0.966667,43.1833,257,403),
(31,new String'("Sarrecave"),31350,78,61,31,2.49,0.583333,43.2167,339,470),
(31,new String'("Gaillac-Toulza"),31550,1216,912,30,40.4,1.46667,43.25,206,360),
(31,new String'("His"),31260,232,179,45,5.05,0.966667,43.0667,298,425),
(31,new String'("Le Born"),31340,431,261,39,10.85,1.55,43.8833,120,215),
(31,new String'("Villariès"),31380,816,592,111,7.33,1.5,43.7167,127,203),
(31,new String'("Menville"),31530,574,405,113,5.07,1.2,43.6833,122,225),
(31,new String'("Saint-Martory"),31360,876,877,105,8.3,0.933333,43.15,269,485),
(31,new String'("Mérenvielle"),31530,472,400,45,10.45,1.16667,43.6333,149,286),
(31,new String'("Binos"),31440,35,18,17,1.96,0.616667,42.9,669,1606),
(31,new String'("Antichan-de-Frontignes"),31510,82,84,19,4.27,0.666667,42.9667,533,1655),
(31,new String'("Gratentour"),31150,3545,3034,866,4.09,1.43333,43.7167,123,194),
(31,new String'("Garin"),31110,133,102,23,5.62,0.516667,42.8167,1027,2003),
(31,new String'("Couladère"),31220,443,350,203,2.18,1.1,43.2,225,306),
(31,new String'("Le Faget"),31460,366,280,32,11.31,1.83333,43.5667,170,275),
(31,new String'("Cornebarrieu"),31700,5724,4693,306,18.7,1.33333,43.65,130,188),
(31,new String'("Tourreilles"),31210,376,358,30,12.33,0.551944,43.1128,413,553),
(31,new String'("Mervilla"),31320,266,172,96,2.76,1.46667,43.5167,185,275),
(31,new String'("Savarthès"),31800,154,122,50,3.05,0.8,43.1167,337,440),
(31,new String'("Trébons-sur-la-Grasse"),31290,417,320,38,10.87,1.73333,43.45,175,272),
(31,new String'("Roumens"),31540,249,201,69,3.57,1.93333,43.4667,193,273),
(31,new String'("Gauré"),31590,492,494,36,13.47,1.61667,43.6167,164,243),
(31,new String'("Cessales"),31290,127,130,38,3.34,1.73333,43.45,186,262),
(31,new String'("Le Grès"),31480,340,223,41,8.13,1.1,43.7333,169,284),
(31,new String'("Francarville"),31460,175,154,25,7.0,1.75,43.6,161,256),
(31,new String'("Pradère-les-Bourguets"),31530,224,252,45,4.89,1.16667,43.65,128,160),
(31,new String'("Vernet"),31810,2080,1895,197,10.53,1.43167,43.4328,157,174),
(31,new String'("Fenouillet"),31150,5166,4030,543,9.51,1.4,43.6833,115,129),
(31,new String'("Saiguède"),31470,742,524,62,11.86,1.15,43.5333,208,312),
(31,new String'("Mauvaisin"),31190,223,252,20,11.05,1.55,43.35,196,301),
(31,new String'("Ayguesvives"),31450,2373,1813,181,13.11,1.6,43.4333,156,271),
(31,new String'("Castanet-Tolosan"),31320,11033,10394,1342,8.22,1.5,43.5167,145,281),
(31,new String'("Mauressac"),31190,437,240,96,4.52,1.43333,43.3167,191,312),
(31,new String'("Nénigan"),31350,60,55,25,2.38,0.7,43.35,213,297),
(31,new String'("Montastruc-Savès"),31370,64,76,11,5.75,1.01667,43.35,237,346),
(31,new String'("Tournefeuille"),31170,25340,22745,1394,18.17,1.35,43.5833,146,190),
(31,new String'("Saint-Ferréol-de-Comminges"),31350,53,53,9,5.88,0.733333,43.3333,213,335),
(31,new String'("Salles-sur-Garonne"),31390,516,300,90,5.68,1.18333,43.2667,205,229),
(31,new String'("Saint-Élix-le-Château"),31430,728,543,69,10.52,1.13333,43.2667,222,244),
(31,new String'("Labruyère-Dorsa"),31190,248,143,113,2.19,1.48333,43.4,184,252),
(31,new String'("Cintegabelle"),31550,2625,2353,49,52.92,1.53333,43.3167,185,302),
(31,new String'("Rieumes"),31370,3384,2604,109,30.9,1.11667,43.4167,214,332),
(31,new String'("Salerm"),31230,55,55,9,5.87,0.833333,43.3,256,377),
(31,new String'("Caraman"),31460,2357,1948,78,30.19,1.76667,43.5333,175,294),
(31,new String'("Labastide-Saint-Sernin"),31620,1799,1328,361,4.97,1.46667,43.7333,126,184),
(31,new String'("Garde"),31290,328,239,28,11.69,1.71667,43.3417,185,292),
(31,new String'("Tour"),31310,80,103,12,6.24,1.28333,43.2,242,383),
(31,new String'("Lourde"),31510,98,88,79,1.24,0.666667,42.9833,533,860),
(31,new String'("Saint-Julien-sur-Garonne"),31220,516,341,63,8.15,1.16667,43.2333,205,241),
(31,new String'("Aspret-Sarrat"),31800,153,97,40,3.82,0.716667,43.0667,388,568),
(31,new String'("Aulon"),31420,360,347,24,14.9,0.833333,43.1833,312,483),
(31,new String'("Montclar-de-Comminges"),31220,75,69,11,6.45,1.01667,43.1667,311,570),
(31,new String'("Saint-Geniès-Bellevue"),31180,2164,1789,572,3.78,1.48333,43.6833,142,214),
(31,new String'("Montgaillard-de-Salies"),31260,97,105,16,6.04,0.933333,43.0667,307,424),
(31,new String'("Bagiry"),31510,83,77,29,2.78,0.633333,42.9833,449,1002),
(31,new String'("Loubens-Lauragais"),31460,417,323,64,6.47,1.78333,43.5833,164,245),
(31,new String'("Saint-Pierre"),31590,252,209,53,4.74,1.65028,43.6314,150,232),
(31,new String'("Folcarde"),31290,126,86,54,2.33,1.8,43.4,205,271),
(31,new String'("Portet-sur-Garonne"),31120,9435,8737,582,16.19,1.41667,43.5167,142,235),
(31,new String'("Lherm"),31600,3417,2565,125,27.26,1.22195,43.43,187,240),
(31,new String'("Montlaur"),31450,1213,890,126,9.61,1.57111,43.4884,149,227),
(31,new String'("Riolas"),31230,52,42,18,2.86,0.916667,43.35,239,352),
(31,new String'("Pouze"),31450,97,89,25,3.82,1.53333,43.4333,199,273),
(31,new String'("Carbonne"),31390,5205,3708,195,26.59,1.23333,43.3,183,332),
(31,new String'("Frontignan-Savès"),31230,60,49,21,2.81,0.916667,43.4,192,316),
(31,new String'("Bourg-d'Oueil"),31110,8,10,0,9.52,0.5,42.8667,1274,2150),
(31,new String'("Saint-Christaud"),31310,260,228,23,10.87,1.13333,43.1833,225,394),
(31,new String'("Castelginest"),31780,8745,7745,1078,8.11,1.43333,43.7,122,193),
(31,new String'("Estadens"),31160,511,428,29,17.47,0.85,43.0333,396,805),
(31,new String'("Espanès"),31450,262,232,74,3.53,1.48333,43.45,199,281),
(31,new String'("Rieux-Volvestre"),31310,2486,1900,76,32.38,1.2,43.25,195,343),
(31,new String'("Moustajon"),31110,169,181,73,2.3,0.6,42.8167,605,1708),
(31,new String'("Ganties"),31160,301,247,25,12.03,0.833333,43.0667,355,501),
(31,new String'("Goyrans"),31120,911,808,158,5.75,1.43333,43.4833,147,274),
(31,new String'("Encausse-les-Thermes"),31160,659,590,80,8.15,0.75,43.05,356,690),
(31,new String'("Lavelanet-de-Comminges"),31220,558,482,41,13.54,1.11667,43.25,232,253),
(31,new String'("Labroquère"),31510,315,269,72,4.37,0.6,43.0333,422,690),
(31,new String'("Longages"),31410,2650,1900,123,21.42,1.25,43.3667,190,220),
(31,new String'("Saint-Pé-d'Ardet"),31510,126,115,36,3.47,0.666667,42.9833,575,1001),
(31,new String'("Saint-Sulpice-sur-Lèze"),31410,1845,1640,132,13.97,1.33333,43.3333,190,321),
(31,new String'("Bretx"),31530,568,357,67,8.41,1.21667,43.7,130,216),
(31,new String'("Montastruc-de-Salies"),31160,272,292,16,16.12,0.9,43.0333,327,811),
(31,new String'("La Salvetat-Saint-Gilles"),31880,6911,5786,1201,5.75,1.27139,43.5762,166,197),
(31,new String'("Saint-Araille"),31430,138,125,21,6.54,0.983333,43.35,238,340),
(31,new String'("Albiac"),31460,202,156,42,4.71,1.78056,43.552,175,263),
(31,new String'("Sarremezan"),31350,98,69,23,4.25,0.666667,43.2,299,427),
(31,new String'("Baziège"),31450,3189,2204,161,19.72,1.61667,43.45,156,253),
(31,new String'("Laffite-Toupière"),31360,85,70,17,4.84,0.905556,43.1645,289,482),
(31,new String'("Villefranche-de-Lauragais"),31290,4106,3348,396,10.35,1.73333,43.4,168,256),
(31,new String'("Mondonville"),31700,4236,1897,356,11.89,1.28333,43.6667,145,193),
(31,new String'("Mirambeau"),31230,53,51,13,3.96,0.883333,43.4,183,300),
(31,new String'("Azas"),31380,571,400,44,12.83,1.66667,43.7167,133,233),
(31,new String'("Ambax"),31230,70,72,11,5.95,0.933333,43.3667,203,348),
(31,new String'("Bellegarde-Sainte-Marie"),31530,205,176,17,11.66,1.11361,43.6717,139,285),
(31,new String'("Lafitte-Vigordane"),31390,1059,653,93,11.38,1.16306,43.2998,214,236),
(31,new String'("Labastide-Beauvoir"),31450,1080,669,105,10.2,1.66667,43.4833,179,264),
(31,new String'("Labarthe-Inard"),31800,875,778,87,9.97,0.85,43.1167,308,374),
(31,new String'("Lescuns"),31220,57,42,18,3.01,1.01667,43.25,256,376),
(31,new String'("Villeneuve-de-Rivière"),31800,1607,1361,118,13.57,0.666667,43.1333,365,496),
(31,new String'("Cuguron"),31210,195,176,27,7.07,0.55,43.1,454,568),
(31,new String'("Montréjeau"),31210,2781,2577,338,8.21,0.583333,43.0833,409,543),
(31,new String'("Noueilles"),31450,335,234,60,5.51,1.53333,43.4167,185,266),
(31,new String'("Chein-Dessus"),31160,194,184,15,12.69,0.883333,43.0167,378,1353),
(31,new String'("Mailholas"),31310,40,39,13,2.94,1.26667,43.25,230,342),
(31,new String'("Izaut-de-l'Hôtel"),31160,293,306,30,9.68,0.75,43.0167,397,800),
(31,new String'("Mons"),31280,1455,1084,198,7.32,1.57445,43.6109,151,233),
(31,new String'("Villemur-sur-Tarn"),31340,5654,4934,121,46.57,1.51667,43.8667,85,218),
(31,new String'("Roquefort-sur-Garonne"),31360,783,715,57,13.56,0.966667,43.1667,257,561),
(31,new String'("Cox"),31480,342,267,84,4.07,1.05,43.7667,179,296),
(31,new String'("Larcan"),31800,181,156,26,6.96,0.716667,43.1833,349,450),
(31,new String'("Bouloc"),31620,4134,2930,222,18.55,1.41667,43.7833,127,226),
(31,new String'("Marignac"),31440,530,507,40,12.95,0.658333,42.9142,475,2160),
(31,new String'("Saint-Paul-sur-Save"),31530,1314,664,259,5.07,1.22583,43.6984,117,173),
(31,new String'("Pibrac"),31820,8091,7440,312,25.86,1.3,43.6167,145,237),
(31,new String'("Belberaud"),31450,1273,1124,170,7.47,1.58333,43.5,148,243),
(31,new String'("Blagnac"),31700,21710,20590,1286,16.88,1.4,43.6333,119,153),
(31,new String'("Bélesta-en-Lauragais"),31540,112,84,20,5.59,1.81667,43.4333,209,300),
(31,new String'("Cadours"),31480,1068,694,100,10.58,1.05,43.7333,147,242),
(31,new String'("Belbèze-de-Lauragais"),31450,104,101,28,3.71,1.55,43.4333,190,275),
(31,new String'("Fronsac"),31440,202,216,48,4.15,0.65,42.95,461,1680),
(31,new String'("Bessières"),31660,3253,2224,195,16.68,1.61667,43.8,85,194),
(31,new String'("Castillon-de-Saint-Martory"),31360,338,259,30,10.98,0.866667,43.1333,283,488),
(31,new String'("Pins-Justaret"),31860,4454,3917,987,4.51,1.38333,43.4798,146,167),
(31,new String'("Saint-Michel"),31220,330,231,21,15.53,1.08333,43.1667,267,543),
(31,new String'("Laréole"),31480,140,122,15,8.88,1.03333,43.7333,135,272),
(31,new String'("Saint-Félix-Lauragais"),31540,1336,1305,25,51.88,1.9,43.45,178,341),
(31,new String'("Mondilhan"),31350,91,80,9,10.02,0.7,43.2833,244,390),
(31,new String'("Lavernose-Lacasse"),31410,2699,1944,151,17.83,1.26028,43.3962,181,210),
(31,new String'("Toulouse"),31000,441802,390301,3734,118.3,1.43333,43.6,115,263),
(31,new String'("Rieumajou"),31290,137,87,36,3.77,1.78333,43.4167,205,282),
(31,new String'("Frouzins"),31270,7902,5938,998,7.91,1.31667,43.5167,157,176),
(31,new String'("Montgeard"),31560,441,322,47,9.32,1.61667,43.3333,195,290),
(31,new String'("Bouzin"),31420,81,70,18,4.27,0.883333,43.1833,312,446),
(31,new String'("Montgaillard-Lauragais"),31290,633,546,56,11.12,1.7,43.4333,164,259),
(31,new String'("Lieoux"),31800,118,0,20,5.83,0.766667,43.15,359,449),
(31,new String'("Cazac"),31230,84,81,13,6.23,0.944167,43.347,246,356),
(31,new String'("Salles-et-Pratviel"),31110,140,118,66,2.12,0.6,42.8333,591,982),
(31,new String'("L'Isle-en-Dodon"),31230,1984,1901,87,22.58,0.85,43.3833,187,326),
(31,new String'("Villaudric"),31620,1398,1112,114,12.16,1.43333,43.8333,112,156),
(31,new String'("Sabonnères"),31370,294,218,23,12.3,1.06667,43.4667,196,331),
(31,new String'("Bourg-Saint-Bernard"),31570,903,774,54,16.6,1.73333,43.6,156,253),
(31,new String'("Vallègue"),31290,530,382,126,4.18,1.75,43.4167,197,261),
(31,new String'("Deyme"),31450,855,835,121,7.05,1.53333,43.4833,148,275),
(31,new String'("Plagnole"),31370,266,268,36,7.24,1.06667,43.4167,228,347),
(31,new String'("Villematier"),31340,1022,863,68,14.96,1.5,43.8333,85,156),
(31,new String'("Savères"),31370,205,158,19,10.71,1.11667,43.3667,220,337),
(31,new String'("Villeneuve-lès-Bouloc"),31620,1025,950,80,12.66,1.41667,43.7667,113,217),
(31,new String'("Beaupuy"),31850,1275,1082,218,5.84,1.0,43.65,152,221),
(31,new String'("Caragoudes"),31460,233,212,28,8.31,1.7,43.5,175,263),
(31,new String'("Cépet"),31620,1606,1311,225,7.11,1.43333,43.75,123,185),
(31,new String'("Montesquieu-Guittaut"),31230,155,123,15,10.06,0.766667,43.3333,219,325),
(31,new String'("Auzeville-Tolosane"),31320,3552,2199,533,6.66,1.48333,43.5333,142,272),
(31,new String'("Beauteville"),31290,185,104,41,4.49,1.73333,43.35,181,293),
(31,new String'("Montaut"),31410,510,440,28,17.88,1.26667,43.35,175,301),
(31,new String'("Saint-Marcet"),31800,411,393,29,14.06,0.75,43.2,323,464),
(31,new String'("Auterive"),31190,9107,6526,249,36.54,1.48333,43.35,165,292),
(31,new String'("Marliac"),31550,122,108,16,7.2,1.46667,43.2333,250,369),
(31,new String'("Blajan"),31350,493,440,38,12.68,0.65,43.2667,277,430),
(31,new String'("Palaminy"),31220,801,630,71,11.13,1.06667,43.2,235,460),
(31,new String'("Alan"),31420,306,301,27,11.29,0.95,43.2167,271,520),
(31,new String'("Saint-Plancard"),31580,374,371,23,16.09,0.566667,43.1667,349,530),
(31,new String'("Canens"),31310,57,69,11,4.84,1.33333,43.2167,240,361),
(31,new String'("Cassagne"),31260,645,622,58,10.97,0.983333,43.1167,278,470),
(31,new String'("Arguenos"),31160,53,57,4,11.09,0.716667,42.9667,517,1895),
(31,new String'("Saint-Béat"),31440,393,364,53,7.37,0.7,42.9167,476,1760),
(31,new String'("Lasserre"),31530,932,644,98,9.51,1.16861,43.6389,145,253),
(31,new String'("Burgalays"),31440,131,115,25,5.05,0.633333,42.8833,519,1731),
(31,new String'("Lanta"),31570,1715,1174,56,30.12,1.66667,43.5667,159,275),
(31,new String'("Verfeil"),31590,3146,2505,76,41.23,1.66083,43.6575,146,273),
(31,new String'("Cazaril-Tambourès"),31580,73,99,10,6.93,0.533333,43.1833,378,525),
(31,new String'("Vallesvilles"),31570,376,291,46,8.16,1.63333,43.6,174,254),
(31,new String'("Razecueillé"),31160,34,37,5,6.5,0.8,42.9667,516,1538),
(31,new String'("Merville"),31330,4783,2799,155,30.68,1.31667,43.7333,105,179),
(31,new String'("Urau"),31260,148,136,8,18.45,0.95,43.0167,359,1260),
(31,new String'("Montaigut-sur-Save"),31530,1569,1206,124,12.65,1.25,43.7,116,194),
(31,new String'("Castelgaillard"),31230,58,66,8,6.82,0.9,43.35,206,351),
(31,new String'("Saint-Pierre-de-Lages"),31570,770,378,106,7.2,1.61667,43.5667,165,251),
(31,new String'("Saint-Mamet"),31110,574,499,51,11.16,0.6,42.7833,630,1975),
(31,new String'("Corronsac"),31450,712,447,112,6.34,1.5,43.4667,186,281),
(31,new String'("Mondouzil"),31850,239,218,58,4.09,1.56667,43.6333,155,231),
(31,new String'("Beaufort"),31370,353,247,41,8.51,1.11667,43.4667,236,323),
(31,new String'("Escalquens"),31750,5932,5476,704,8.42,1.56667,43.5167,146,232),
(31,new String'("Valentine"),31800,916,894,114,8.03,0.716667,43.1,356,546),
(31,new String'("Lécussan"),31580,289,212,38,7.43,0.5,43.15,413,581),
(31,new String'("Baren"),31440,5,8,1,3.06,0.616667,42.8667,680,1892),
(31,new String'("Herran"),31160,68,80,4,15.37,0.916667,42.9667,520,1574),
(31,new String'("Goudex"),31230,40,43,15,2.61,0.95,43.3667,214,350),
(31,new String'("Bezins-Garraux"),31440,51,39,6,7.71,0.7,42.9333,568,1788),
(31,new String'("Boussan"),31420,214,190,17,12.45,0.9,43.2333,280,466),
(31,new String'("Le Castéra"),31530,787,596,47,16.71,1.15,43.6833,125,284),
(31,new String'("Auriac-sur-Vendinelle"),31460,996,957,32,30.71,1.81667,43.5167,183,270),
(31,new String'("Juzet-de-Luchon"),31110,389,365,57,6.8,0.616667,42.8167,608,2000),
(31,new String'("Seysses"),31600,7839,5745,310,25.26,1.31667,43.5,160,182),
(31,new String'("Montgaillard-sur-Save"),31350,78,66,18,4.13,0.733333,43.25,255,363),
(31,new String'("Lauzerville"),31650,1291,873,373,3.46,1.56667,43.55,149,225),
(31,new String'("Gibel"),31560,308,261,15,19.4,1.66667,43.3,215,343),
(31,new String'("Samouillan"),31420,126,108,23,5.33,0.95,43.2667,265,365),
(31,new String'("Rebigue"),31320,524,445,101,5.16,1.48333,43.4833,182,281),
(31,new String'("Lodes"),31800,279,255,20,13.74,0.683333,43.1667,367,493),
(31,new String'("Lagardelle-sur-Lèze"),31870,2441,2185,177,13.78,1.38333,43.4167,167,217),
(31,new String'("Ciadoux"),31350,264,186,27,9.73,0.733333,43.2667,252,382),
(31,new String'("Villenouvelle"),31290,1324,940,166,7.95,1.65,43.4333,158,241),
(31,new String'("Castéra-Vignoles"),31350,63,54,15,4.19,0.783333,43.2833,254,376),
(31,new String'("Saint-Élix-Séglan"),31420,41,47,14,2.86,0.866667,43.2,313,401),
(31,new String'("Saint-Rustice"),31620,436,425,184,2.36,1.31667,43.8,107,217),
(31,new String'("Vignaux"),31480,121,100,29,4.04,1.06667,43.6833,156,244),
(31,new String'("Caujac"),31190,777,439,71,10.82,1.46667,43.3,197,334),
(31,new String'("Puydaniel"),31190,408,318,55,7.38,1.43333,43.3333,187,322),
(31,new String'("Prunet"),31460,144,134,30,4.66,1.73333,43.5667,190,275),
(31,new String'("Saint-Paul-d'Oueil"),31110,50,49,6,7.46,0.55,42.8333,1031,1988),
(31,new String'("Aussonne"),31840,6357,4223,461,13.76,1.31667,43.6833,119,171),
(31,new String'("Saint-Germier"),31290,103,86,27,3.74,1.73333,43.475,188,271),
(31,new String'("Huos"),31210,465,452,113,4.09,0.6,43.0667,416,702),
(31,new String'("Miramont-de-Comminges"),31800,793,785,98,8.09,0.75,43.0833,338,564),
(31,new String'("Goutevernisse"),31310,159,77,33,4.69,1.18333,43.2167,223,326),
(31,new String'("Saint-Hilaire"),31410,1078,707,170,6.33,1.26667,43.4167,175,198),
(31,new String'("Villeneuve-Tolosane"),31270,8637,8254,1700,5.08,1.33333,43.5167,153,173),
(31,new String'("Puysségur"),31480,129,70,23,5.44,1.06667,43.75,170,292),
(31,new String'("Brignemont"),31480,390,317,17,21.96,0.983333,43.7833,136,286),
(31,new String'("Venerque"),31810,2612,2327,179,14.57,1.45,43.4333,157,272),
(31,new String'("Bonrepos-Riquet"),31590,241,247,42,5.69,1.61667,43.6833,142,253),
(31,new String'("Ponlat-Taillebourg"),31210,557,458,64,8.6,0.583333,43.1,395,528),
(31,new String'("Saint-Jean"),31240,10259,8365,1727,5.94,1.5,43.6667,145,211),
(31,new String'("Saint-Pé-Delbosc"),31350,138,121,25,5.51,0.683333,43.2667,255,347),
(31,new String'("Proupiary"),31360,69,55,13,4.95,0.866667,43.15,340,483),
(31,new String'("Luscan"),31510,69,54,20,3.33,0.616667,43.0,443,941),
(31,new String'("Saint-Loup-Cammas"),31140,1801,1735,493,3.65,1.48333,43.7,140,215),
(31,new String'("Pointis-de-Rivière"),31210,847,790,128,6.58,0.616667,43.0833,379,422),
(31,new String'("Drémil-Lafage"),31280,2473,2578,197,12.49,1.6,43.6,162,244),
(31,new String'("Couret"),31160,187,194,43,4.34,0.816667,43.05,370,602),
(31,new String'("Aucamville"),31140,8049,5532,2032,3.96,1.43056,43.6687,125,135),
(31,new String'("Sédeilhac"),31580,55,69,8,6.16,0.566667,43.15,397,553),
(31,new String'("Calmont"),31560,2177,1609,54,40.27,1.63333,43.2833,206,324),
(31,new String'("Gourdan-Polignan"),31210,1359,1193,258,5.26,0.583333,43.0667,411,635),
(31,new String'("Signac"),31440,49,58,13,3.51,0.633333,42.9,490,1644),
(31,new String'("Péguilhan"),31350,251,220,13,18.48,0.7,43.3167,218,345),
(31,new String'("Gémil"),31380,273,196,97,2.81,1.6,43.7333,130,200),
(31,new String'("Avignonet-Lauragais"),31290,1323,1070,32,40.66,1.78889,43.3659,176,274),
(31,new String'("Cabanac-Séguenville"),31480,172,128,16,10.18,1.03333,43.8,177,284),
(31,new String'("Peyssies"),31390,465,364,72,6.37,1.17722,43.3212,208,229),
(31,new String'("Montberon"),31140,2768,2340,435,6.35,1.48333,43.7167,128,193),
(31,new String'("Labastidette"),31600,2146,1334,342,6.27,1.26667,43.45,186,219),
(31,new String'("Montclar-Lauragais"),31290,197,139,54,3.62,1.71667,43.3667,177,267),
(31,new String'("Saint-Sauveur"),31790,1746,1309,248,7.04,1.40056,43.7487,112,175),
(31,new String'("L'Union"),31240,11868,12139,1753,6.77,1.48333,43.6667,132,196),
(31,new String'("Odars"),31450,738,580,110,6.65,1.6,43.5167,158,243),
(31,new String'("Montrabé"),31850,3585,3202,685,5.23,1.51667,43.65,143,211),
(31,new String'("Portet-d'Aspet"),31160,71,67,5,13.93,0.866667,42.9333,680,1574),
(31,new String'("Toutens"),31460,211,142,43,4.86,1.75,43.4833,206,283),
(31,new String'("Drudas"),31480,181,171,16,11.17,1.11667,43.75,157,274),
(31,new String'("Saint-Jory"),31790,5082,4067,266,19.1,1.38333,43.7333,105,125),
(31,new String'("Castelnau-d'Estrétefonds"),31620,5600,2810,197,28.32,1.36667,43.7833,105,224),
(31,new String'("Lux"),31290,358,171,47,7.59,1.78333,43.4333,195,272),
(31,new String'("Sode"),31110,25,19,4,5.53,0.616667,42.8167,760,2019),
(31,new String'("Saint-Orens-de-Gameville"),31650,10918,10997,835,13.06,1.53333,43.55,144,219),
(31,new String'("Antignac"),31110,108,104,18,5.8,0.6,42.8333,589,1846),
(31,new String'("Trébons-de-Luchon"),31110,8,10,9,0.83,0.566667,42.8,720,1447),
(31,new String'("Varennes"),31450,256,198,55,4.61,1.68806,43.477,196,273),
(31,new String'("Fonsorbes"),31470,11111,6909,583,19.03,1.23333,43.5333,169,213),
(31,new String'("Mauran"),31220,178,119,34,5.09,1.03333,43.1833,236,520),
(31,new String'("Labège"),31670,3861,3149,504,7.65,1.53333,43.5333,141,202),
(31,new String'("Lahitère"),31310,52,38,13,3.9,1.2,43.1333,340,506),
(31,new String'("Saint-Thomas"),31470,565,473,40,14.01,1.08333,43.5167,185,315),
(31,new String'("Larroque"),31580,309,337,15,19.83,0.609722,43.1956,304,488),
(31,new String'("Roquesérière"),31380,702,615,65,10.64,1.63333,43.7333,128,232),
(31,new String'("Gagnac-sur-Garonne"),31150,2952,1634,680,4.34,1.36667,43.7,113,123),
(31,new String'("Caignac"),31560,293,188,31,9.36,1.7,43.3167,203,310),
(31,new String'("Pompertuzat"),31450,2023,1209,371,5.44,1.51667,43.5,147,272),
(31,new String'("Martisserre"),31230,60,56,9,6.17,0.883333,43.3833,210,326),
(31,new String'("Donneville"),31450,1033,777,386,2.67,1.55,43.4667,153,236),
(31,new String'("Peyrissas"),31420,94,82,12,7.82,0.9,43.2833,270,374),
(31,new String'("Thil"),31530,1140,833,48,23.68,1.16667,43.7167,149,275),
(31,new String'("Mane"),31260,988,1025,149,6.59,0.95,43.0833,294,414),
(31,new String'("Fourquevaux"),31450,752,717,74,10.03,1.61667,43.5,165,256),
(31,new String'("Lespugue"),31350,74,83,15,4.91,0.666667,43.2333,281,446),
(31,new String'("Bérat"),31370,2747,1408,112,24.46,1.18333,43.3833,202,265),
(31,new String'("Poucharramet"),31370,837,680,37,22.53,1.18333,43.4167,196,260),
(31,new String'("Maureville"),31460,301,265,30,9.9,1.7,43.5167,175,276),
(31,new String'("Bax"),31310,83,81,13,5.99,1.26667,43.2333,243,371),
(31,new String'("Arnaud-Guilhem"),31360,215,168,27,7.7,0.9,43.1333,279,463),
(31,new String'("Charlas"),31350,224,189,19,11.32,0.7,43.2333,267,447),
(31,new String'("Cugnaux"),31270,15807,12981,1214,13.01,1.36667,43.5333,150,170),
(31,new String'("Castelbiague"),31160,223,209,38,5.84,0.916667,43.0333,334,702),
(31,new String'("Maurens"),31540,203,169,30,6.6,1.79167,43.4667,209,271),
(31,new String'("Lalouret-Laffiteau"),31800,140,108,25,5.39,0.703889,43.1845,356,464),
(31,new String'("Mascarville"),31460,183,139,34,5.27,1.75,43.55,175,281),
(31,new String'("Rieucazé"),31800,46,37,22,2.03,0.75,43.0833,347,561),
(31,new String'("Boulogne-sur-Gesse"),31350,1612,1432,65,24.73,0.644722,43.2895,243,388),
(31,new String'("Latoue"),31800,323,285,18,17.62,0.783333,43.1667,333,488),
(31,new String'("Gardouch"),31290,1312,995,80,16.31,1.68333,43.3833,168,259),
(31,new String'("Clermont-le-Fort"),31810,532,463,52,10.04,1.43333,43.45,152,282),
(31,new String'("Agassac"),31230,117,121,12,9.58,0.883333,43.3667,197,336),
(31,new String'("Préserville"),31570,648,360,53,12.19,1.61667,43.5167,158,232),
(31,new String'("Montgras"),31370,92,46,23,3.99,1.06667,43.45,229,331),
(31,new String'("Frontignan-de-Comminges"),31510,68,73,26,2.53,0.65,42.9667,468,1565),
(31,new String'("Forgues"),31370,189,152,36,5.24,1.05,43.4333,203,328),
(31,new String'("Eoux"),31420,119,121,12,9.17,0.9,43.2667,272,374),
(31,new String'("Ondes"),31330,740,684,112,6.57,1.3,43.7833,102,111),
(31,new String'("Marsoulas"),31260,131,137,54,2.4,1.0,43.1,292,422),
(31,new String'("Nogaret"),31540,70,78,17,4.0,1.93333,43.5,188,273),
(31,new String'("Saint-Médard"),31360,210,235,39,5.32,0.834722,43.1284,322,441),
(31,new String'("Le Cabanial"),31460,338,246,39,8.47,1.86667,43.5167,192,280),
(31,new String'("Labastide-Paumès"),31230,142,127,17,8.04,0.933333,43.3333,247,345),
(31,new String'("Auragne"),31190,401,312,29,13.63,1.5,43.3833,183,292),
(31,new String'("Mancioux"),31360,423,345,58,7.22,0.95,43.15,274,485),
(31,new String'("Coueilles"),31230,87,100,13,6.45,0.883333,43.35,211,351),
(31,new String'("Layrac-sur-Tarn"),31340,329,264,45,7.25,1.56667,43.8333,86,223),
(31,new String'("Saint-Frajou"),31230,197,173,11,16.61,0.85,43.3333,222,350),
(31,new String'("Cambernard"),31470,429,340,50,8.48,1.2,43.4833,192,230),
(31,new String'("Nailloux"),31560,3076,1237,165,18.55,1.63333,43.3667,190,292),
(31,new String'("Boutx"),31440,274,260,5,47.28,0.716667,42.9167,560,1850),
(31,new String'("Valcabrère"),31510,152,139,94,1.61,0.566667,43.0333,424,471),
(31,new String'("Sepx"),31360,208,152,16,12.37,0.85,43.15,360,489),
(31,new String'("Polastron"),31430,58,64,12,4.78,0.956667,43.3237,248,351),
(31,new String'("Mayrègne"),31110,27,33,5,5.19,0.55,42.8333,1120,1914),
(31,new String'("Latrape"),31310,344,296,18,19.08,1.26667,43.25,227,369),
(31,new String'("Esparron"),31420,61,36,11,5.53,0.816667,43.2667,293,374),
(31,new String'("Puymaurin"),31230,300,298,13,22.24,0.766667,43.3667,197,312),
(31,new String'("Brax"),31490,2531,2017,572,4.42,1.25,43.6167,165,240),
(31,new String'("Estancarbon"),31800,579,530,92,6.23,0.783333,43.1,325,392),
(31,new String'("Montespan"),31260,438,423,34,12.57,0.866667,43.0833,298,522),
(31,new String'("Beauville"),31460,136,106,22,6.06,1.76667,43.4667,195,291),
(31,new String'("Beauchalot"),31360,492,392,77,6.33,0.866667,43.1,295,410),
(31,new String'("Fustignac"),31430,76,54,19,3.96,0.983333,43.3,262,371),
(31,new String'("Balesta"),31580,177,149,24,7.16,0.566667,43.2,355,498),
(31,new String'("Montoulieu-Saint-Bernard"),31420,187,153,38,4.83,0.916667,43.2333,276,467),
(31,new String'("Saint-Cézert"),31330,369,413,41,8.94,1.21667,43.7833,125,173),
(31,new String'("Bachas"),31420,59,75,22,2.62,0.933333,43.25,272,364),
(31,new String'("Monès"),31370,69,50,27,2.52,1.03333,43.4167,203,336),
(31,new String'("Seilhan"),31510,201,187,42,4.68,0.566667,43.05,417,702),
(31,new String'("Esperce"),31190,237,210,14,16.42,1.4,43.3,216,334),
(31,new String'("La Salvetat-Lauragais"),31460,137,97,37,3.66,1.8,43.5333,177,255),
(31,new String'("Lussan-Adeilhac"),31430,229,191,18,12.62,0.95,43.3167,263,374),
(31,new String'("Seyre"),31560,102,76,26,3.89,1.66667,43.3667,185,262),
(31,new String'("Saint-Rome"),31290,57,68,15,3.63,1.67695,43.4148,163,174),
(31,new String'("Pechbusque"),31320,837,707,266,3.14,1.46667,43.5167,148,274),
(31,new String'("Saint-Jean-Lherm"),31380,377,303,47,7.92,1.61667,43.7,146,251),
(31,new String'("Lapeyrère"),31310,72,61,11,6.3,1.31472,43.2064,271,394),
(31,new String'("Cazeaux-de-Larboust"),31110,93,82,4,19.14,0.533333,42.8,914,3110),
(31,new String'("Balma"),31130,13474,11944,812,16.59,1.5,43.6167,135,218),
(31,new String'("Ardiège"),31210,400,325,106,3.76,0.65,43.0667,405,710),
(31,new String'("Sainte-Foy-d'Aigrefeuille"),31570,1979,1628,204,9.68,1.61667,43.55,152,240),
(31,new String'("Capens"),31410,559,285,82,6.77,1.25,43.3333,174,290),
(31,new String'("Lautignac"),31370,286,220,16,17.77,1.06667,43.3833,231,351),
(31,new String'("Lavalette"),31590,622,602,45,13.75,1.6,43.6333,155,233),
(31,new String'("Saccourvielle"),31110,13,14,3,3.41,0.566667,42.8167,833,1781),
(31,new String'("Aspet"),31160,950,927,36,26.37,0.8,43.0167,399,1240),
(31,new String'("Cassagnabère-Tournas"),31420,432,389,17,25.24,0.8,43.2333,286,422),
(31,new String'("Bois-de-la-Pierre"),31390,417,313,56,7.42,1.15,43.35,216,266),
(31,new String'("Montégut-Lauragais"),31540,469,360,60,7.72,1.93333,43.4833,188,258),
(31,new String'("Boissède"),31230,83,71,21,3.84,0.816667,43.4,186,252),
(31,new String'("Malvezie"),31510,124,110,14,8.52,0.683333,43.0,493,896),
(31,new String'("Lahage"),31370,228,262,29,7.65,1.06667,43.4333,223,333),
(31,new String'("Saint-André"),31420,213,180,11,18.69,0.852222,43.2734,282,380),
(31,new String'("Gouzens"),31310,95,61,16,5.7,1.18333,43.1833,260,422),
(31,new String'("Gratens"),31430,699,444,46,15.15,1.11667,43.3167,221,344),
(31,new String'("Le Fréchet"),31360,114,103,27,4.21,0.933333,43.1833,318,485),
(31,new String'("Montbernard"),31230,215,214,11,18.31,0.766667,43.3,224,373),
(31,new String'("Plagne"),31220,89,88,21,4.15,1.05,43.15,316,590),
(31,new String'("Melles"),31440,113,104,2,45.32,0.766667,42.8667,548,2626),
(31,new String'("Montberaud"),31220,210,167,13,15.87,1.15,43.15,265,474),
(31,new String'("Oô"),31110,111,109,3,32.53,0.5,42.8,954,3215),
(31,new String'("Montgazin"),31410,165,151,23,6.89,1.28333,43.3,205,292),
(31,new String'("Mazères-sur-Salat"),31260,593,592,88,6.68,0.973333,43.1334,265,375),
(31,new String'("Saint-Alban"),31140,5634,5192,1322,4.26,1.41667,43.7,121,133),
(31,new String'("Bordes-de-Rivière"),31210,496,359,58,8.52,0.633333,43.1,379,516),
(31,new String'("Launaguet"),31140,7149,5086,1018,7.02,1.45,43.6833,126,203),
(31,new String'("Rouède"),31160,289,236,46,6.2,0.9,43.05,356,489),
(31,new String'("Plaisance-du-Touch"),31830,16091,14150,606,26.53,1.3,43.5667,157,200),
(31,new String'("Saux-et-Pomarède"),31800,270,251,21,12.52,0.716667,43.15,369,497),
(31,new String'("Launac"),31330,1267,963,56,22.32,1.18333,43.75,139,253),
(31,new String'("Auzas"),31360,193,133,24,7.89,0.883333,43.1667,288,474),
(31,new String'("Franquevielle"),31210,361,333,33,10.88,0.533333,43.1333,437,565),
(31,new String'("Peyrouzet"),31420,93,79,19,4.88,0.833333,43.2,302,403),
(31,new String'("Bazus"),31380,577,534,63,9.13,1.51667,43.7333,128,216),
(31,new String'("Mourvilles-Basses"),31460,72,60,15,4.58,1.7,43.4833,187,273),
(31,new String'("Cier-de-Luchon"),31110,239,222,22,10.59,0.6,42.85,582,1988),
(31,new String'("Lamasquère"),31600,1322,872,216,6.11,1.26667,43.4833,180,187),
(31,new String'("Rouffiac-Tolosan"),31180,1732,1405,370,4.67,1.51667,43.6667,154,234),
(31,new String'("Juzet-d'Izaut"),31160,204,193,12,15.74,0.75,42.9833,466,1908),
(31,new String'("Cazaux-Layrisse"),31440,65,86,23,2.76,0.6,42.8667,589,1776),
(31,new String'("Villate"),31860,801,588,440,1.82,1.37945,43.47,161,172),
(31,new String'("Cathervielle"),31110,33,30,8,3.7,0.516667,42.8167,1152,1918),
(31,new String'("Escoulis"),31260,84,81,18,4.64,1.03056,43.1117,298,410),
(31,new String'("Benque"),31420,163,154,14,11.3,0.916667,43.2667,266,373),
(31,new String'("Massabrac"),31310,78,72,19,4.0,1.35,43.2333,217,315),
(31,new String'("Noé"),31410,2627,2077,272,9.65,1.26667,43.35,175,280),
(31,new String'("Aigrefeuille"),31280,1077,577,233,4.62,1.6,43.5667,151,230),
(31,new String'("Garidech"),31380,1591,952,223,7.11,1.56667,43.7167,132,214),
(31,new String'("Cirès"),31110,13,8,2,5.11,0.516667,42.85,1235,1971),
(31,new String'("Pechbonnieu"),31140,3940,2997,523,7.52,1.46667,43.7,140,208),
(31,new String'("Vaudreuille"),31250,351,261,31,11.3,1.98333,43.4167,223,575),
(31,new String'("Lapeyrouse-Fossat"),31180,2686,2055,283,9.49,1.51667,43.7,132,215),
(31,new String'("Quint-Fonsegrives"),31130,4850,4474,657,7.38,1.52611,43.5848,141,234),
(31,new String'("Cazaunous"),31160,62,47,13,4.66,0.733333,42.9833,474,920),
(31,new String'("Auribail"),31190,228,162,25,8.94,1.38333,43.35,209,312),
(31,new String'("Escanecrabe"),31350,232,240,14,16.07,0.75,43.2833,240,376),
(31,new String'("Grépiac"),31190,990,789,121,8.18,1.43333,43.4,163,243),
(31,new String'("Cazeneuve-Montaut"),31420,70,54,15,4.59,0.866667,43.1833,312,422),
(31,new String'("Vieillevigne"),31290,305,174,97,3.14,1.65,43.4,164,247),
(31,new String'("Montmaurin"),31350,226,196,26,8.45,0.633333,43.2167,284,430),
(31,new String'("Revel"),31250,9361,8023,265,35.31,2.0,43.4667,179,381),
(31,new String'("Castelnau-Picampeau"),31430,198,165,17,11.3,1.01667,43.3,252,381),
(31,new String'("Saussens"),31460,238,144,78,3.02,1.71667,43.5833,160,254),
(31,new String'("Auzielle"),31650,1284,1556,279,4.59,1.56667,43.55,154,234),
(31,new String'("Bruguières"),31150,4967,3862,550,9.03,1.41667,43.7333,116,175),
(31,new String'("Galié"),31510,87,78,30,2.86,0.633333,42.9833,443,946),
(31,new String'("Labarthe-Rivière"),31800,1363,1151,99,13.65,0.666667,43.0833,373,710),
(31,new String'("Castagnac"),31310,301,204,27,10.77,1.35,43.2333,217,363),
(31,new String'("Larra"),31330,1432,1133,87,16.36,1.23111,43.7389,110,181),
(31,new String'("Labarthe-sur-Lèze"),31860,4871,4637,467,10.43,1.4,43.45,151,173),
(31,new String'("Buzet-sur-Tarn"),31660,2351,1411,77,30.19,1.65,43.7833,95,247),
(31,new String'("Martres-Tolosane"),31220,2231,1684,94,23.52,1.0,43.2,236,488),
(31,new String'("Fougaron"),31160,96,73,10,9.14,0.933333,42.9833,473,1416),
(31,new String'("Bachos"),31440,27,38,10,2.67,0.616667,42.8833,520,1600),
(31,new String'("Touille"),31260,258,203,39,6.49,0.966667,43.0833,293,443),
(31,new String'("Cambiac"),31460,227,170,29,7.74,1.78333,43.4833,195,261),
(31,new String'("Paulhac"),31380,1128,913,80,14.03,1.56667,43.7167,110,225),
(31,new String'("Saleich"),31260,370,361,25,14.29,0.966667,43.0167,326,1166),
(31,new String'("Belbèze-en-Comminges"),31260,105,116,10,9.56,1.01667,43.1333,320,601),
(31,new String'("Lespinasse"),31150,2526,1863,595,4.24,1.38333,43.7167,117,127),
(31,new String'("Lévignac"),31530,2018,1628,165,12.22,1.19528,43.6669,123,235),
(31,new String'("Moncaup"),31160,32,26,4,7.14,0.7,42.9833,508,1788),
(31,new String'("Marignac-Laspeyres"),31220,196,113,15,12.41,0.95,43.2167,285,530),
(31,new String'("Saman"),31350,159,142,28,5.54,0.716667,43.2333,266,391),
(31,new String'("Martres-de-Rivière"),31210,386,307,107,3.59,0.65,43.0833,391,569),
(31,new String'("Montsaunès"),31260,415,379,45,9.12,0.933333,43.1167,285,411),
(31,new String'("Bagnères-de-Luchon"),31110,2593,2903,49,52.8,0.6,42.7833,611,2737),
(31,new String'("Montbrun-Lauragais"),31450,548,485,50,10.92,1.53333,43.45,175,284),
(31,new String'("Cazaril-Laspènes"),31110,23,19,9,2.37,0.583333,42.8,672,1560),
(31,new String'("Poubeau"),31110,73,53,17,4.21,0.5,42.8167,1181,1974),
(31,new String'("Cier-de-Rivière"),31510,261,250,28,9.26,0.633333,43.0667,412,719),
(31,new String'("Argut-Dessous"),31440,30,33,11,2.7,0.716667,42.8833,513,1090),
(31,new String'("Lespiteau"),31160,75,68,41,1.81,0.766667,43.0667,352,486),
(31,new String'("Jurvielle"),31110,23,17,3,5.79,0.483333,42.8167,1240,2093),
(31,new String'("Milhas"),31160,175,140,8,19.68,0.8,42.9833,466,1608),
(31,new String'("Arlos"),31440,95,90,10,9.41,0.7,42.9,509,2165),
(31,new String'("Benque-Dessous-et-Dessus"),31110,25,19,6,3.72,0.554722,42.8153,800,1805),
(31,new String'("Sajas"),31370,104,82,20,5.0,1.01667,43.3667,248,345),
(31,new String'("Artigue"),31110,35,34,3,9.72,0.616667,42.8333,840,2081),
(31,new String'("Gouaux-de-Luchon"),31110,46,44,3,14.49,0.616667,42.85,680,2193),
(31,new String'("Gouaux-de-Larboust"),31110,53,65,4,10.67,0.483333,42.8,1120,2370),
(31,new String'("Guran"),31440,50,44,9,5.28,0.616667,42.8833,551,1740),
(31,new String'("Billière"),31110,23,25,10,2.18,0.533333,42.8167,1021,1806),
(31,new String'("Le Plan"),31220,494,316,61,8.02,1.11667,43.1667,246,480),
(31,new String'("Montégut-Bourjac"),31430,119,109,21,5.52,0.983333,43.2833,258,365),
(31,new String'("Clarac"),31210,558,507,117,4.74,0.625833,43.0964,387,515),
(31,new String'("Sainte-Foy-de-Peyrolières"),31470,2001,1436,52,38.02,1.15,43.5,188,319),
(31,new String'("Montbrun-Bocage"),31310,469,374,15,30.61,1.26667,43.1333,259,523),
(31,new String'("Bellesserre"),31480,86,50,25,3.39,1.11667,43.7833,174,274),
(31,new String'("Saint-Clar-de-Rivière"),31600,1174,874,116,10.07,1.21667,43.4667,181,228),
(31,new String'("Nizan-Gesse"),31350,92,83,10,8.64,0.6,43.2333,320,476),
(31,new String'("Mourvilles-Hautes"),31540,173,167,26,6.59,1.81667,43.4167,223,311),
(31,new String'("Beaumont-sur-Lèze"),31870,1523,1414,57,26.31,1.36667,43.3833,174,311),
(31,new String'("Eup"),31440,143,147,64,2.22,0.683333,42.9333,471,1259),
(31,new String'("Saint-Laurent"),31230,168,157,20,8.39,0.8,43.3167,211,341),
(31,new String'("Gargas"),31620,635,520,87,7.28,1.46667,43.7167,126,196),
(31,new String'("Sénarens"),31430,119,101,17,6.93,0.966667,43.35,244,345),
(31,new String'("Mauzac"),31410,1111,684,119,9.27,1.26667,43.3833,165,285),
(31,new String'("Labastide-Clermont"),31370,695,416,47,14.58,1.11667,43.35,222,349),
(31,new String'("Saint-Bertrand-de-Comminges"),31510,256,237,22,11.17,0.583333,43.0167,421,1016),
(31,new String'("Payssous"),31510,92,80,22,4.08,0.716667,43.0333,388,790),
(31,new String'("Le Fousseret"),31430,1714,1439,44,38.31,1.06667,43.2833,238,372),
(31,new String'("Montoussin"),31430,122,91,25,4.83,1.01667,43.2667,254,360),
(31,new String'("Montesquieu-Volvestre"),31310,2997,2319,50,59.82,1.23333,43.2167,208,523),
(31,new String'("Le Burgaud"),31330,710,481,29,24.18,1.1625,43.7948,143,253),
(31,new String'("Saint-Loup-en-Comminges"),31350,38,40,8,4.73,0.566667,43.25,325,466),
(31,new String'("Aurignac"),31420,1179,980,65,17.95,0.883333,43.2167,295,511),
(31,new String'("Arbas"),31160,241,186,32,7.32,0.9,43.0,392,840),
(31,new String'("Mont-de-Galié"),31510,37,36,15,2.42,0.65,42.9833,560,1006),
(31,new String'("Régades"),31800,132,113,36,3.62,0.716667,43.05,377,630),
(31,new String'("Falga"),31540,110,79,20,5.38,1.86667,43.4833,209,286),
(31,new String'("Vacquiers"),31340,1312,1032,66,19.61,1.48333,43.7667,110,225),
(31,new String'("Pelleport"),31480,515,344,49,10.38,1.13333,43.7333,157,275),
(31,new String'("Grenade"),31330,8074,5760,218,37.01,1.29361,43.7722,97,167),
(31,new String'("Bondigoux"),31340,463,322,62,7.46,1.55,43.8333,86,201),
(31,new String'("Fronton"),31620,5594,3889,122,45.79,1.4,43.85,101,198),
(31,new String'("Caubiac"),31480,296,194,37,7.99,1.08333,43.7167,178,275),
(31,new String'("Sainte-Livrade"),31530,283,246,45,6.16,1.1,43.65,132,200),
(31,new String'("Montastruc-la-Conseillère"),31380,3149,2487,203,15.49,1.6,43.7167,143,242),
(31,new String'("Lagraulet-Saint-Nicolas"),31480,244,145,15,16.11,1.08333,43.7833,168,287),
(31,new String'("Vaux"),31540,278,224,26,10.41,1.83333,43.45,209,291),
(31,new String'("Renneville"),31290,506,334,60,8.42,1.71667,43.3833,172,273),
(31,new String'("Pinsaguel"),31120,2611,2464,502,5.2,1.38333,43.5167,144,160),
(31,new String'("Gensac-de-Boulogne"),31350,102,141,9,10.96,0.583333,43.25,289,438),
(31,new String'("Cierp-Gaud"),31440,849,865,61,13.9,0.638611,42.9156,460,1840),
(31,new String'("Marignac-Lasclares"),31430,410,294,40,10.01,1.1,43.3,231,310),
(31,new String'("Lège"),31440,41,39,15,2.72,0.616667,42.8667,560,1740),
(31,new String'("Vendine"),31460,248,169,86,2.87,1.76667,43.5833,161,194),
(31,new String'("Saubens"),31600,1913,1302,319,5.99,1.33333,43.4833,147,195),
(31,new String'("Saint-Ignan"),31800,267,250,49,5.35,0.7,43.15,377,484),
(31,new String'("Landorthe"),31800,946,779,98,9.65,0.783333,43.1333,343,463),
(31,new String'("Génos"),31510,96,75,27,3.47,0.666667,43.0,517,922),
(31,new String'("Villeneuve-Lécussan"),31580,545,493,33,16.1,0.516667,43.15,420,587),
(31,new String'("Saint-Vincent"),31290,178,99,57,3.07,1.75806,43.4398,193,243),
(31,new String'("Fonbeauzard"),31140,2764,2599,2093,1.32,1.45,43.6833,127,135),
(31,new String'("Eaunes"),31600,5390,3388,360,14.95,1.35,43.4167,168,290),
(31,new String'("Montpitol"),31380,399,332,66,5.96,1.63333,43.7,155,233),
(31,new String'("Aureville"),31320,731,540,107,6.8,1.45,43.4833,169,282),
(31,new String'("Pointis-Inard"),31800,829,741,56,14.66,0.816667,43.0833,319,489),
(31,new String'("Mauremont"),31290,318,222,56,5.63,1.68333,43.45,184,269),
(31,new String'("Marquefave"),31390,1031,858,54,18.92,1.23333,43.3167,175,323),
(31,new String'("Molas"),31230,162,146,15,10.43,0.783333,43.4,192,301),
(31,new String'("Garac"),31480,170,157,28,6.05,1.1,43.7,150,274),
(31,new String'("Flourens"),31130,1791,1794,183,9.74,1.56667,43.6,152,243),
(31,new String'("Castelmaurou"),31180,3751,3257,223,16.77,1.53139,43.6767,132,231),
(31,new String'("Bonrepos-sur-Aussonnelle"),31470,850,579,83,10.17,1.15,43.55,206,312),
(31,new String'("Casties-Labrande"),31430,108,97,12,8.7,1.0,43.3333,241,342),
(31,new String'("Aignes"),31550,234,193,10,21.81,1.6,43.3167,198,323),
(31,new String'("Grazac"),31190,508,442,70,7.17,1.45528,43.3117,194,333),
(31,new String'("Sana"),31220,221,175,80,2.74,1.01667,43.2333,271,376),
(31,new String'("Saint-Léon"),31560,1133,749,46,24.21,1.56667,43.4,185,291),
(31,new String'("Issus"),31450,444,291,62,7.11,1.5,43.4167,178,247),
(32,new String'("Mont-d'Astarac"),32140,96,102,11,8.05,0.566667,43.3333,234,386),
(32,new String'("Sabazan"),32290,134,135,16,8.26,0.05,43.7,102,210),
(32,new String'("Terraube"),32700,393,382,15,25.14,0.55,43.9167,85,227),
(32,new String'("La Romieu"),32480,558,528,20,27.48,0.5,43.9833,104,217),
(32,new String'("Aurensan"),32400,129,129,20,6.33,-0.203611,43.6181,94,228),
(32,new String'("Monguilhem"),32240,285,303,49,5.71,-0.183333,43.85,67,107),
(32,new String'("Tirent-Pontéjac"),32450,86,70,11,7.55,0.8,43.55,157,255),
(32,new String'("Gondrin"),32330,1161,989,33,34.76,0.25,43.8833,80,181),
(32,new String'("Samaran"),32140,87,94,10,8.61,0.516667,43.3833,218,333),
(32,new String'("Betcave-Aguin"),32420,96,80,9,10.19,0.683333,43.4333,213,314),
(32,new String'("Mouchan"),32330,433,365,33,13.11,0.283333,43.9,77,185),
(32,new String'("Riguepeu"),32320,207,214,9,21.52,0.35,43.65,123,241),
(32,new String'("Bezolles"),32310,139,156,12,11.13,0.35,43.6333,93,222),
(32,new String'("Lagraulet-du-Gers"),32330,458,382,16,27.22,0.216667,43.9,85,186),
(32,new String'("Dému"),32190,324,340,11,28.89,0.166667,43.75,137,232),
(32,new String'("Eauze"),32800,4092,3888,58,69.86,0.1,43.8667,106,193),
(32,new String'("Bazian"),32320,109,102,8,12.71,0.316667,43.6667,126,234),
(32,new String'("Cassaigne"),32100,218,186,25,8.58,0.316667,43.9,74,168),
(32,new String'("Durban"),32260,144,162,8,17.4,0.6,43.5333,155,270),
(32,new String'("Moncassin"),32300,134,119,9,13.93,0.5,43.45,179,283),
(32,new String'("Clermont-Pouyguillès"),32300,165,158,12,12.71,0.533333,43.4667,181,281),
(32,new String'("Termes-d'Armagnac"),32400,188,215,18,10.05,-0.0105556,43.6709,111,206),
(32,new String'("Meilhan"),32420,87,80,12,6.82,0.683333,43.4167,215,329),
(32,new String'("Loussous-Débat"),32290,49,56,9,5.07,0.066667,43.65,119,185),
(32,new String'("Crastes"),32270,242,206,12,19.25,0.733333,43.7333,131,272),
(32,new String'("Bonas"),32410,135,122,13,10.1,0.416667,43.7833,96,195),
(32,new String'("Saint-Germier"),32200,201,117,28,7.05,0.950833,43.667,145,213),
(32,new String'("Bourrouillan"),32370,147,174,16,8.7,-0.016667,43.8,102,182),
(32,new String'("Plieux"),32340,165,176,13,12.27,0.733333,43.95,82,187),
(32,new String'("Callian"),32190,50,50,6,7.91,0.283333,43.6333,137,227),
(32,new String'("Lauraët"),32330,250,207,19,12.71,0.233333,43.9167,88,177),
(32,new String'("Sainte-Gemme"),32120,129,105,12,10.22,0.8,43.7833,121,194),
(32,new String'("Miramont-d'Astarac"),32300,361,345,24,14.73,0.483333,43.55,150,273),
(32,new String'("Saramon"),32450,856,673,65,13.03,0.766667,43.5333,166,266),
(32,new String'("Saint-Georges"),32430,174,153,10,15.82,0.935833,43.7278,120,212),
(32,new String'("Avezan"),32380,75,84,13,5.66,0.8,43.8667,96,200),
(32,new String'("Le Brouilh-Monbert"),32350,236,212,18,12.96,0.393889,43.667,115,246),
(32,new String'("Belloc-Saint-Clamens"),32300,138,147,13,10.49,0.433333,43.45,159,272),
(32,new String'("Couloumé-Mondebat"),32160,201,249,8,22.85,0.1,43.6333,122,245),
(32,new String'("Sérempuy"),32120,37,29,11,3.27,0.75,43.8333,126,189),
(32,new String'("Viella"),32400,532,559,24,22.02,-0.14,43.5987,109,250),
(32,new String'("Lamaguère"),32260,58,68,8,6.49,0.666667,43.5,191,297),
(32,new String'("Mascaras"),32230,61,52,10,5.95,0.233333,43.55,173,283),
(32,new String'("Ségoufielle"),32600,990,653,188,5.24,1.13333,43.6333,134,213),
(32,new String'("Cabas-Loumassès"),32140,51,50,12,4.11,0.6,43.3667,245,312),
(32,new String'("Haget"),32730,312,293,34,9.1,0.166667,43.4167,162,270),
(32,new String'("Castex-d'Armagnac"),32240,100,111,8,12.26,-0.166944,43.8695,65,124),
(32,new String'("Lombez"),32220,1911,1403,97,19.55,0.916667,43.4833,162,286),
(32,new String'("Mourède"),32190,84,69,17,4.88,0.283333,43.7833,99,166),
(32,new String'("Saint-Soulan"),32220,146,134,11,12.31,0.85,43.5,174,302),
(32,new String'("Loubédat"),32110,125,129,13,9.46,0.016667,43.7333,101,186),
(32,new String'("Ardizas"),32430,198,122,23,8.52,1.0,43.7167,135,215),
(32,new String'("Armous-et-Cau"),32230,95,93,10,9.33,0.166667,43.5667,152,279),
(32,new String'("Lagarde-Hachan"),32300,155,131,18,8.57,0.5,43.4167,202,285),
(32,new String'("Labéjan"),32300,325,259,17,18.71,0.5,43.5333,156,273),
(32,new String'("Pouy-Loubrin"),32260,106,88,10,9.64,0.618056,43.4662,180,298),
(32,new String'("Laveraët"),32230,121,104,10,11.86,0.216667,43.5333,154,280),
(32,new String'("Sainte-Marie"),32200,388,248,17,22.45,0.874722,43.6606,135,231),
(32,new String'("Saint-Arroman"),32300,135,126,11,11.97,0.533333,43.4333,192,304),
(32,new String'("Galiax"),32160,179,193,29,6.05,0.016667,43.6167,123,142),
(32,new String'("Larroque-sur-l'Osse"),32100,226,226,14,15.07,0.274444,43.9712,70,171),
(32,new String'("Arblade-le-Bas"),32720,148,109,19,7.67,-0.166667,43.7167,91,187),
(32,new String'("Mauroux"),32380,143,113,14,9.96,0.810278,43.912,105,256),
(32,new String'("Sarrant"),32120,371,339,18,19.81,0.916667,43.7667,115,192),
(32,new String'("Brugnens"),32500,251,250,18,13.45,0.733333,43.85,97,200),
(32,new String'("Saint-Martin-Gimois"),32450,87,74,13,6.68,0.816667,43.5167,180,295),
(32,new String'("Flamarens"),32340,122,146,8,14.36,0.8,44.0167,77,212),
(32,new String'("Homps"),32120,103,86,11,9.24,0.866667,43.8167,105,193),
(32,new String'("Gée-Rivière"),32720,49,49,17,2.74,-0.183333,43.6667,83,92),
(32,new String'("Sadeillan"),32170,83,79,14,5.92,0.35,43.4,210,325),
(32,new String'("Pessan"),32550,700,636,26,26.87,0.633333,43.6167,153,292),
(32,new String'("Malabat"),32730,97,87,17,5.4,0.183333,43.4333,162,296),
(32,new String'("Lamothe-Goas"),32500,67,64,9,7.18,0.55,43.8667,87,155),
(32,new String'("Pallanne"),32230,69,66,13,5.18,0.25,43.5167,165,266),
(32,new String'("Aignan"),32290,775,844,24,32.16,0.083333,43.7,107,222),
(32,new String'("Ponsan-Soubiran"),32300,123,117,17,6.87,0.483333,43.35,227,370),
(32,new String'("Nougaroulet"),32270,352,288,22,15.79,0.733333,43.7,136,231),
(32,new String'("Montadet"),32220,82,72,16,5.11,0.916667,43.4333,174,304),
(32,new String'("Peyrusse-Grande"),32320,162,209,6,25.5,0.214167,43.6323,151,269),
(32,new String'("Marciac"),32230,1239,1160,60,20.6,0.166667,43.5333,142,247),
(32,new String'("Samatan"),32130,2324,1830,69,33.53,0.933333,43.5,155,252),
(32,new String'("Panassac"),32140,276,280,30,9.17,0.566667,43.3833,209,317),
(32,new String'("Lourties-Monbrun"),32140,137,108,14,9.5,0.566667,43.45,192,301),
(32,new String'("Saint-Élix-Theux"),32300,117,110,13,8.37,0.466667,43.4333,193,302),
(32,new String'("Pauilhac"),32500,613,477,24,25.27,0.6,43.8667,79,161),
(32,new String'("Ordan-Larroque"),32350,932,773,21,42.64,0.483333,43.7,135,273),
(32,new String'("Pouy-Roquelaure"),32480,139,137,12,11.04,0.533333,44.0333,96,216),
(32,new String'("Maravat"),32120,43,49,6,6.46,0.766667,43.75,138,242),
(32,new String'("Puylausic"),32220,188,157,19,9.84,0.933333,43.45,171,295),
(32,new String'("Magnas"),32380,74,48,23,3.19,0.733333,43.8833,124,207),
(32,new String'("Castéron"),32380,63,58,5,11.08,0.866667,43.8833,165,267),
(32,new String'("L'Isle-Bouzon"),32380,243,249,15,15.95,0.733333,43.9167,85,206),
(32,new String'("Urdens"),32500,246,180,31,7.77,0.7,43.85,87,202),
(32,new String'("Mérens"),32360,63,51,15,4.18,0.516667,43.75,126,244),
(32,new String'("Mormès"),32240,124,124,13,9.05,-0.15,43.7833,76,128),
(32,new String'("Savignac-Mona"),32130,148,140,21,6.87,1.0,43.4833,169,261),
(32,new String'("Sion"),32110,120,111,17,7.05,0.00888889,43.7333,92,166),
(32,new String'("Castelnau-d'Auzan"),32440,1067,1037,24,43.79,0.083333,43.95,82,186),
(32,new String'("Maulichères"),32400,173,185,27,6.18,-0.083333,43.6833,103,176),
(32,new String'("Tasque"),32160,266,216,26,10.02,0.016667,43.65,115,190),
(32,new String'("Castelnau-d'Anglès"),32320,93,90,7,11.94,0.3,43.6167,142,242),
(32,new String'("Bassoues"),32320,353,376,10,32.29,0.25,43.5833,150,287),
(32,new String'("Biran"),32350,399,341,10,36.86,0.416667,43.7,105,253),
(32,new String'("Marambat"),32190,436,327,44,9.7,0.3,43.7667,103,224),
(32,new String'("Maurens"),32200,301,208,23,13.03,0.916389,43.595,166,256),
(32,new String'("Monblanc"),32130,368,286,28,12.93,0.983333,43.4667,162,306),
(32,new String'("Polastron"),32130,260,188,17,15.21,0.844722,43.5312,171,286),
(32,new String'("Saint-Mont"),32400,303,322,24,12.59,-0.15,43.65,89,165),
(32,new String'("Peyrusse-Massas"),32360,106,82,16,6.49,0.566667,43.7333,123,250),
(32,new String'("Saint-Christaud"),32320,75,90,6,11.0,0.266667,43.5333,169,291),
(32,new String'("Bouzon-Gellenave"),32290,192,167,18,10.29,0.016667,43.7,101,200),
(32,new String'("Lalanne"),32500,116,92,20,5.55,0.684167,43.7973,90,144),
(32,new String'("L'Isle-Jourdain"),32600,7336,5557,104,70.48,1.08333,43.6167,136,304),
(32,new String'("Tournan"),32420,198,178,15,12.56,0.783333,43.4333,184,305),
(32,new String'("Clermont-Savès"),32600,249,164,48,5.1,1.01667,43.6167,154,216),
(32,new String'("La Sauvetat"),32500,356,335,12,27.71,0.533333,43.8667,95,242),
(32,new String'("Lahitte"),32810,257,184,51,5.03,0.666667,43.6667,148,240),
(32,new String'("Sainte-Aurence-Cazaux"),32300,124,121,12,9.54,0.433333,43.3667,194,319),
(32,new String'("Haulies"),32550,136,81,13,10.13,0.666667,43.5667,177,292),
(32,new String'("Corneillan"),32400,139,147,16,8.47,-0.183333,43.65,85,160),
(32,new String'("Beccas"),32730,94,83,27,3.38,0.15,43.4333,159,275),
(32,new String'("Séailles"),32190,67,64,8,8.11,0.116667,43.7333,126,212),
(32,new String'("Montpezat"),32220,241,194,15,15.64,0.966667,43.4,198,346),
(32,new String'("Vic-Fezensac"),32190,3645,3614,67,53.94,0.3,43.7667,102,231),
(32,new String'("Manas-Bastanous"),32170,89,105,11,7.54,0.366667,43.3667,204,318),
(32,new String'("Betplan"),32730,113,136,20,5.46,0.2,43.4167,168,315),
(32,new String'("Castex"),32170,94,88,17,5.38,0.316667,43.3833,217,323),
(32,new String'("Saint-Lary"),32360,261,194,26,9.67,0.5,43.7167,156,260),
(32,new String'("Barcelonne-du-Gers"),32720,1304,1303,64,20.29,-0.233333,43.7,76,161),
(32,new String'("Saint-Sauvy"),32270,367,331,20,17.58,0.833333,43.7,132,220),
(32,new String'("Pessoulens"),32380,159,159,12,12.63,0.9,43.85,115,262),
(32,new String'("Juillac"),32230,126,121,16,7.49,0.133333,43.55,136,226),
(32,new String'("Lamazère"),32300,140,132,18,7.47,0.45,43.5667,141,243),
(32,new String'("Pouylebon"),32320,163,155,11,14.38,0.3,43.55,164,266),
(32,new String'("Bédéchan"),32450,134,104,17,7.84,0.8,43.5833,157,262),
(32,new String'("Barran"),32350,723,670,13,52.82,0.45,43.6167,121,283),
(32,new String'("Ornézan"),32260,240,236,19,12.13,0.6,43.5167,165,282),
(32,new String'("Aurimont"),32450,214,133,26,8.07,0.833333,43.5833,157,235),
(32,new String'("Castelnau-d'Arbieu"),32500,211,187,12,16.34,0.7,43.8833,79,231),
(32,new String'("Loubersan"),32300,179,168,16,10.77,0.516667,43.5,171,272),
(32,new String'("Monbardon"),32420,94,88,14,6.41,0.683333,43.3833,216,316),
(32,new String'("Saint-Puy"),32310,586,602,15,36.88,0.466667,43.8833,87,220),
(32,new String'("Gimbrède"),32340,336,288,13,24.98,0.716667,44.0333,72,221),
(32,new String'("Pouydraguin"),32290,145,136,14,9.71,0.033333,43.65,113,222),
(32,new String'("Viozan"),32300,110,114,16,6.76,0.5,43.4,192,285),
(32,new String'("Cézan"),32410,172,150,14,12.22,0.5,43.8167,125,231),
(32,new String'("Cadeillan"),32220,73,72,17,4.26,0.85,43.4167,177,247),
(32,new String'("Caussens"),32100,593,549,44,13.27,0.433333,43.95,102,205),
(32,new String'("Sainte-Christie"),32390,566,419,57,9.91,0.633333,43.75,100,178),
(32,new String'("Lelin-Lapujolle"),32400,233,207,17,13.56,-0.15,43.7167,96,188),
(32,new String'("Ladevèze-Ville"),32230,268,249,29,9.09,0.066667,43.55,143,254),
(32,new String'("Traversères"),32450,79,63,7,10.46,0.65,43.5333,175,291),
(32,new String'("Labarrère"),32250,216,250,16,12.99,0.141667,43.9583,77,181),
(32,new String'("Seissan"),32260,1080,997,58,18.56,0.6,43.5,168,283),
(32,new String'("Caillavet"),32190,189,164,12,14.58,0.333333,43.7167,110,225),
(32,new String'("Cazaubon"),32150,1707,1546,30,55.64,-0.066667,43.9333,92,183),
(32,new String'("Sémézies-Cachan"),32450,74,75,10,6.95,0.733333,43.5167,177,281),
(32,new String'("Pompiac"),32130,182,144,17,10.12,1.01667,43.5167,151,256),
(32,new String'("Taybosc"),32120,59,56,10,5.87,0.766667,43.75,158,224),
(32,new String'("Belmont"),32190,152,151,10,15.1,0.25,43.7,130,212),
(32,new String'("Roques"),32310,113,122,13,8.48,0.283333,43.85,91,195),
(32,new String'("Puységur"),32390,76,80,10,7.26,0.6,43.7833,100,191),
(32,new String'("Ayzieu"),32800,155,147,11,13.84,-0.016667,43.8333,102,175),
(32,new String'("Luppé-Violles"),32110,146,126,19,7.57,-0.133333,43.7333,96,166),
(32,new String'("Saint-Orens-Pouy-Petit"),32100,149,141,13,11.31,0.433333,43.9167,97,225),
(32,new String'("Saint-Germé"),32400,499,443,52,9.55,-0.15,43.6833,89,110),
(32,new String'("Lannemaignan"),32240,103,104,12,8.58,-0.2,43.9,59,117),
(32,new String'("Cuélas"),32300,107,106,16,6.55,0.45,43.35,208,296),
(32,new String'("Auradé"),32600,628,388,29,21.32,1.06667,43.5667,143,311),
(32,new String'("Lannux"),32400,225,199,17,12.83,-0.216667,43.65,82,223),
(32,new String'("Noulens"),32800,98,105,17,5.74,0.166667,43.8,132,196),
(32,new String'("Préchac"),32390,165,153,12,12.79,0.566667,43.7833,114,218),
(32,new String'("Mirepoix"),32390,211,171,29,7.25,0.666667,43.7333,115,201),
(32,new String'("Gazax-et-Baccarisse"),32230,85,99,8,9.45,0.183333,43.6167,154,276),
(32,new String'("Rozès"),32190,128,109,11,10.74,0.366667,43.8,94,214),
(32,new String'("Tudelle"),32190,62,63,12,5.16,0.283333,43.6833,127,228),
(32,new String'("Montréal"),32250,1231,1238,19,63.05,0.2,43.95,73,183),
(32,new String'("Blousson-Sérian"),32230,55,50,10,5.27,0.2,43.4667,185,298),
(32,new String'("Tillac"),32170,254,295,20,12.47,0.283333,43.4667,170,264),
(32,new String'("Panjas"),32110,380,398,18,20.01,-0.083333,43.8167,74,184),
(32,new String'("Montégut"),32550,558,392,48,11.42,0.645833,43.6523,135,257),
(32,new String'("Sauviac"),32300,108,134,16,6.48,0.45,43.4,184,282),
(32,new String'("Monbrun"),32600,341,214,31,10.8,1.03333,43.6667,158,225),
(32,new String'("Saint-Arailles"),32350,144,116,10,13.2,0.35,43.6333,136,236),
(32,new String'("Auch"),32810,21576,21911,297,72.48,0.583333,43.65,115,281),
(32,new String'("Condom"),32100,7012,7256,72,97.37,0.366667,43.9667,62,190),
(32,new String'("Cravencères"),32110,105,118,11,9.09,0.033333,43.75,97,180),
(32,new String'("Orbessan"),32260,255,210,30,8.24,0.6,43.5333,152,273),
(32,new String'("Bétous"),32110,97,74,18,5.13,0.016667,43.7,99,187),
(32,new String'("Esclassan-Labastide"),32140,355,285,29,11.93,0.533333,43.4167,204,324),
(32,new String'("Gaudonville"),32380,122,103,16,7.39,0.85,43.8833,121,265),
(32,new String'("Estang"),32240,630,646,27,22.51,-0.1,43.8667,82,157),
(32,new String'("Sabaillan"),32420,156,153,13,11.21,0.816667,43.45,179,307),
(32,new String'("Mansencôme"),32310,66,73,16,4.05,0.333333,43.8667,112,201),
(32,new String'("Giscaro"),32200,82,67,15,5.4,0.916667,43.6167,175,251),
(32,new String'("Berdoues"),32300,452,356,25,17.65,0.416667,43.4833,152,272),
(32,new String'("Cazaux-Savès"),32130,274,138,48,5.62,0.966667,43.5333,150,241),
(32,new String'("Bellegarde"),32140,172,136,11,14.39,0.623611,43.4248,212,315),
(32,new String'("Monfort"),32120,480,424,21,22.49,0.833333,43.8,105,194),
(32,new String'("Mongausy"),32220,77,64,10,7.41,0.8,43.5,177,305),
(32,new String'("Saint-Justin"),32230,157,139,11,13.18,0.15,43.4833,146,266),
(32,new String'("Laguian-Mazous"),32170,278,303,27,9.98,0.258056,43.42,199,347),
(32,new String'("Mirande"),32300,3685,3564,157,23.42,0.416667,43.5167,139,268),
(32,new String'("Maumusson-Laguian"),32400,153,165,16,9.3,-0.1,43.6167,112,184),
(32,new String'("Peyrusse-Vieille"),32230,70,78,6,11.05,0.183333,43.6333,141,255),
(32,new String'("Ligardes"),32480,227,250,20,11.3,0.5,44.0333,77,182),
(32,new String'("Ayguetinte"),32410,185,152,29,6.31,0.427222,43.8342,96,203),
(32,new String'("Izotges"),32400,90,74,30,2.94,-0.016667,43.65,110,119),
(32,new String'("Manciet"),32370,812,767,19,42.11,0.05,43.8167,105,212),
(32,new String'("Ansan"),32270,96,63,12,7.76,0.783333,43.7,138,212),
(32,new String'("Moncorneil-Grazan"),32260,147,104,20,7.09,0.666667,43.45,204,314),
(32,new String'("Pergain-Taillac"),32700,331,285,17,19.38,0.6,44.05,57,187),
(32,new String'("Catonvielle"),32200,101,62,32,3.07,0.966667,43.65,153,213),
(32,new String'("Garde"),32700,115,131,12,8.85,0.555833,43.9642,72,184),
(32,new String'("Cannet"),32400,55,55,11,4.81,-0.05,43.6167,114,231),
(32,new String'("Larroque-Engalin"),32480,50,59,8,6.16,0.616667,43.9833,72,203),
(32,new String'("Saint-André"),32200,99,76,17,5.58,0.856389,43.5625,175,246),
(32,new String'("Preignan"),32810,1248,962,116,10.67,0.633333,43.7167,112,197),
(32,new String'("Marseillan"),32170,92,68,21,4.34,0.316667,43.4833,179,273),
(32,new String'("Saint-Blancard"),32140,336,257,22,14.87,0.646667,43.3442,227,357),
(32,new String'("Castillon-Savès"),32490,289,204,24,11.96,0.983333,43.5667,147,246),
(32,new String'("Castelnau-sur-l'Auvignon"),32100,170,163,16,10.22,0.457222,43.9717,98,209),
(32,new String'("Beaumarchés"),32160,682,589,21,32.47,0.083333,43.5833,129,246),
(32,new String'("Roquelaure"),32810,580,453,27,21.23,0.566667,43.7167,106,239),
(32,new String'("Courties"),32230,45,49,7,6.02,0.15,43.5667,145,260),
(32,new String'("Troncens"),32230,185,199,14,12.97,0.216667,43.4667,182,342),
(32,new String'("Tachoires"),32260,102,102,10,9.61,0.666667,43.4667,197,304),
(32,new String'("Touget"),32430,519,320,29,17.72,0.916667,43.7,130,215),
(32,new String'("Berrac"),32480,108,90,13,7.99,0.616667,44.0167,73,207),
(32,new String'("Beaupuy"),32600,198,104,30,6.54,1.005,43.6442,156,229),
(32,new String'("Fourcès"),32250,279,277,11,23.72,0.216667,43.9833,64,180),
(32,new String'("Plaisance"),32160,1458,1520,106,13.71,0.05,43.6,122,186),
(32,new String'("Bazugues"),32170,67,55,12,5.36,0.35,43.45,195,301),
(32,new String'("Lussan"),32270,244,192,19,12.83,0.733333,43.6333,147,264),
(32,new String'("Marsolan"),32700,461,387,17,26.14,0.55,43.95,87,214),
(32,new String'("Montaut"),32300,114,117,13,8.48,0.419444,43.3942,180,262),
(32,new String'("Arblade-le-Haut"),32110,285,275,23,12.2,-0.066667,43.75,87,177),
(32,new String'("Riscle"),32400,1727,1694,54,31.74,-0.083333,43.6667,96,206),
(32,new String'("Laymont"),32220,201,216,18,11.05,0.983333,43.4167,190,315),
(32,new String'("Mansempuy"),32120,82,53,12,6.33,0.816667,43.7333,137,202),
(32,new String'("Sainte-Radegonde"),32500,184,170,18,9.82,0.583333,43.8333,97,181),
(32,new String'("Avéron-Bergelle"),32290,154,176,10,14.7,0.066667,43.75,109,196),
(32,new String'("Bajonnette"),32120,105,92,14,7.48,0.783333,43.8,134,212),
(32,new String'("Aubiet"),32270,1114,1002,28,38.96,0.8,43.65,138,233),
(32,new String'("Saint-Lizier-du-Planté"),32220,121,112,11,10.49,0.95,43.4167,181,301),
(32,new String'("Aussos"),32140,62,77,7,7.86,0.65,43.3833,232,346),
(32,new String'("Lectoure"),32700,3785,3941,44,84.93,0.616667,43.9333,68,223),
(32,new String'("Seysses-Savès"),32130,260,242,19,13.26,1.05,43.5,165,268),
(32,new String'("Labastide-Savès"),32130,134,117,37,3.62,0.983333,43.5167,153,220),
(32,new String'("Saint-Aunix-Lengros"),32160,153,117,28,5.36,0.05,43.5833,131,202),
(32,new String'("Saint-Maur"),32300,124,111,8,13.84,0.343056,43.4778,170,290),
(32,new String'("Lartigue"),32450,155,164,10,14.89,0.716667,43.5333,170,296),
(32,new String'("L'Isle-Arné"),32270,139,82,19,6.97,0.766667,43.6167,149,234),
(32,new String'("Idrac-Respaillès"),32300,212,203,16,13.03,0.45,43.5167,155,266),
(32,new String'("Saint-Médard"),32300,325,293,19,17.07,0.466667,43.4833,165,281),
(32,new String'("Castelnavet"),32290,141,155,7,18.06,0.133333,43.6667,125,245),
(32,new String'("Peyrecave"),32340,76,82,14,5.07,0.833333,44.0,73,147),
(32,new String'("Sauvimont"),32220,71,39,20,3.44,0.966667,43.45,170,271),
(32,new String'("Saint-Paul-de-Baïse"),32190,106,100,10,10.1,0.366667,43.7667,96,208),
(32,new String'("Pébées"),32130,94,67,23,4.05,1.03333,43.45,200,315),
(32,new String'("Cazaux-Villecomtal"),32230,91,83,22,4.13,0.166667,43.45,157,275),
(32,new String'("Masseube"),32140,1604,1396,76,21.03,0.583333,43.4333,188,306),
(32,new String'("Estampes"),32170,169,171,15,10.82,0.283333,43.4,203,339),
(32,new String'("Laas"),32170,287,237,26,10.94,0.3,43.4667,176,286),
(32,new String'("Saint-Cricq"),32430,262,121,87,3.01,1.0,43.7,145,212),
(32,new String'("Cologne"),32430,850,516,130,6.52,0.983333,43.7167,134,214),
(32,new String'("Margouët-Meymes"),32290,195,174,11,17.69,0.1,43.7167,130,221),
(32,new String'("Montégut-Savès"),32220,71,68,19,3.69,0.95,43.4333,175,271),
(32,new String'("Aux-Aussat"),32170,260,201,20,12.61,0.266667,43.4333,189,342),
(32,new String'("Lasséran"),32550,355,257,23,15.06,0.533333,43.5833,144,262),
(32,new String'("Leboulin"),32810,309,285,34,8.91,0.666667,43.6667,124,258),
(32,new String'("Miélan"),32170,1215,1259,55,21.88,0.316667,43.4333,187,303),
(32,new String'("Bars"),32300,129,139,12,10.61,0.3,43.5167,170,271),
(32,new String'("Mouchès"),32300,73,73,23,3.07,0.416667,43.5667,137,231),
(32,new String'("Antras"),32360,56,58,8,6.59,0.45,43.7333,125,251),
(32,new String'("Castéra-Lectourois"),32700,305,296,16,18.86,0.616667,43.9833,64,203),
(32,new String'("Saint-Antonin"),32120,145,130,12,11.19,0.816667,43.7167,125,203),
(32,new String'("Fustérouau"),32400,130,114,16,7.85,0.016667,43.6833,103,196),
(32,new String'("Louslitges"),32230,81,83,6,12.03,0.166667,43.6,145,270),
(32,new String'("Endoufielle"),32600,568,445,33,17.1,1.02333,43.5512,146,235),
(32,new String'("Saint-Ost"),32300,80,86,11,6.84,0.466667,43.3833,197,287),
(32,new String'("Fleurance"),32500,6339,6279,146,43.32,0.666667,43.8333,83,181),
(32,new String'("Thoux"),32430,229,163,37,6.12,0.983333,43.6833,147,214),
(32,new String'("Labarthète"),32400,147,139,13,11.09,-0.166667,43.6333,99,233),
(32,new String'("Tourdun"),32230,96,105,13,6.95,0.15,43.55,141,240),
(32,new String'("Caupenne-d'Armagnac"),32110,428,377,19,21.65,-0.066667,43.7833,77,151),
(32,new String'("Aujan-Mournède"),32300,94,107,11,8.46,0.516667,43.3833,217,370),
(32,new String'("Monferran-Savès"),32490,705,674,28,24.68,0.983333,43.6,155,241),
(32,new String'("Beaumont"),32100,141,112,18,7.56,0.266667,43.9333,76,152),
(32,new String'("Lagardère"),32310,68,54,13,4.95,0.316667,43.8333,118,222),
(32,new String'("Mauléon-d'Armagnac"),32240,289,306,8,35.13,-0.15,43.9,68,153),
(32,new String'("Sarraguzan"),32170,97,84,11,8.64,0.333333,43.35,234,378),
(32,new String'("Roquepine"),32100,61,46,16,3.77,0.466667,43.9167,128,231),
(32,new String'("Saint-Mézard"),32700,214,202,14,15.11,0.633333,44.0333,62,222),
(32,new String'("Blaziert"),32100,136,124,12,10.97,0.483333,43.9333,111,222),
(32,new String'("Auterive"),32550,537,508,49,10.79,0.614167,43.5828,141,285),
(32,new String'("Sarragachies"),32400,254,265,19,12.83,-0.05,43.6833,106,177),
(32,new String'("Pis"),32500,94,80,17,5.36,0.716667,43.7833,117,194),
(32,new String'("Puycasquier"),32120,444,424,22,20.14,0.766667,43.75,146,264),
(32,new String'("Jegun"),32360,1137,968,28,39.25,0.466667,43.7667,105,242),
(32,new String'("Labrihe"),32120,203,150,21,9.44,0.883333,43.7667,115,184),
(32,new String'("Saint-Élix"),32450,193,122,23,8.17,0.766667,43.4833,177,291),
(32,new String'("Goutz"),32500,186,163,21,8.46,0.733333,43.7833,127,203),
(32,new String'("Cadeilhan"),32380,132,100,15,8.43,0.783333,43.8333,122,194),
(32,new String'("Lalanne-Arqué"),32140,136,161,12,11.15,0.633333,43.3333,243,367),
(32,new String'("Valence-sur-Baïse"),32310,1185,1147,42,27.6,0.383333,43.8833,75,201),
(32,new String'("Lasseube-Propre"),32550,337,236,23,14.57,0.583333,43.5833,145,251),
(32,new String'("Labarthe"),32260,169,141,26,6.46,0.58,43.4748,180,261),
(32,new String'("Marguestau"),32150,71,59,22,3.21,-0.033333,43.8833,101,148),
(32,new String'("Sainte-Mère"),32700,204,182,21,9.43,0.7,44.0,95,189),
(32,new String'("Mont-de-Marrast"),32170,107,102,15,7.0,0.366667,43.3833,191,304),
(32,new String'("Nogaro"),32110,1980,1881,179,11.06,-0.033333,43.7667,89,148),
(32,new String'("Cahuzac-sur-Adour"),32400,239,171,36,6.62,-0.0233333,43.6389,112,141),
(32,new String'("Gaujac"),32220,64,37,12,5.01,0.833333,43.4833,204,311),
(32,new String'("Lavardens"),32360,407,376,13,30.55,0.516667,43.7667,126,245),
(32,new String'("Goux"),32400,84,84,15,5.36,-0.033333,43.6167,122,226),
(32,new String'("Saint-Orens"),32120,84,75,19,4.34,0.9,43.7167,124,213),
(32,new String'("Ramouzens"),32800,145,175,8,16.67,0.183333,43.8,132,215),
(32,new String'("Saint-Martin-de-Goyne"),32480,130,109,23,5.6,0.633333,44.0,66,186),
(32,new String'("Monferran-Plavès"),32260,128,111,11,11.07,0.65,43.4833,190,294),
(32,new String'("Montaut-les-Créneaux"),32810,646,619,24,26.23,0.657778,43.6939,114,264),
(32,new String'("Simorre"),32420,690,698,19,35.85,0.733333,43.45,182,321),
(32,new String'("Cazaux-d'Anglès"),32190,133,116,10,12.6,0.266667,43.6667,130,234),
(32,new String'("Blanquefort"),32270,54,44,16,3.33,0.816667,43.6833,137,183),
(32,new String'("Lupiac"),32290,308,312,8,34.5,0.183333,43.6833,141,247),
(32,new String'("Sainte-Anne"),32430,116,57,17,6.74,0.966667,43.7333,125,192),
(32,new String'("Gimont"),32200,2815,2741,102,27.58,0.883333,43.6333,144,232),
(32,new String'("Duffort"),32170,136,141,13,9.84,0.416667,43.35,215,331),
(32,new String'("Boucagnères"),32550,135,141,21,6.16,0.6,43.5667,150,273),
(32,new String'("Roquefort"),32390,274,231,38,7.21,0.6,43.7667,103,182),
(32,new String'("Saint-Jean-le-Comtal"),32550,387,349,22,17.15,0.516667,43.5833,145,271),
(32,new String'("Caumont"),32400,129,103,18,7.15,-0.104167,43.6914,98,193),
(32,new String'("Scieurac-et-Flourès"),32230,49,50,9,5.38,0.205278,43.5592,157,276),
(32,new String'("Bascous"),32190,153,153,14,10.22,0.15,43.7833,138,212),
(32,new String'("Tarsac"),32400,169,161,37,4.51,-0.116667,43.6667,95,109),
(32,new String'("Sansan"),32260,97,89,26,3.7,0.6075,43.5303,159,240),
(32,new String'("Razengues"),32600,189,104,43,4.35,1.0,43.65,178,231),
(32,new String'("Monclar"),32150,199,135,19,10.12,-0.1,43.9167,92,149),
(32,new String'("Gazaupouy"),32480,285,297,13,20.94,0.45,44.0167,83,220),
(32,new String'("Toujouse"),32240,206,139,14,14.5,-0.183333,43.8333,70,137),
(32,new String'("Saint-Martin"),32300,453,420,49,9.07,0.366667,43.5,159,263),
(32,new String'("Saint-Clar"),32380,1003,869,56,17.91,0.766667,43.9,93,193),
(32,new String'("Noilhan"),32130,320,247,17,18.03,0.933333,43.5333,155,256),
(32,new String'("Boulaur"),32450,161,128,17,9.03,0.783333,43.55,162,285),
(32,new String'("Escornebœuf"),32200,502,497,19,25.45,0.9,43.65,135,232),
(32,new String'("Pujaudran"),32600,1372,899,78,17.41,1.16667,43.5833,194,305),
(32,new String'("Tieste-Uragnoux"),32160,129,121,21,6.1,0.033333,43.55,144,224),
(32,new String'("Garravet"),32220,142,121,15,9.09,0.9,43.4167,183,310),
(32,new String'("Faget-Abbatial"),32450,228,211,13,17.46,0.7,43.5,182,303),
(32,new String'("Sirac"),32430,142,101,17,8.0,0.95,43.7167,137,215),
(32,new String'("Céran"),32500,181,148,16,10.74,0.683333,43.8167,89,181),
(32,new String'("Monties"),32420,70,108,6,10.55,0.676389,43.39,218,335),
(32,new String'("Castéra-Verduzan"),32410,949,830,47,19.82,0.433333,43.8167,97,221),
(32,new String'("Saint-Avit-Frandat"),32700,99,85,13,7.55,0.7,43.9833,96,195),
(32,new String'("Chélan"),32140,190,184,14,13.49,0.55,43.35,222,341),
(32,new String'("Montégut-Arros"),32730,289,286,18,15.29,0.216667,43.3833,170,334),
(32,new String'("Gaujan"),32420,105,107,9,10.82,0.716667,43.4,208,329),
(32,new String'("Castillon-Debats"),32190,328,301,9,35.05,0.2,43.7167,117,227),
(32,new String'("Saint-Léonard"),32380,175,142,13,13.11,0.766667,43.85,96,192),
(32,new String'("Villecomtal-sur-Arros"),32730,847,744,75,11.17,0.199444,43.4017,168,315),
(32,new String'("Tournecoupe"),32380,283,267,14,18.95,0.816667,43.8667,97,221),
(32,new String'("Duran"),32810,813,665,123,6.59,0.55,43.6667,137,256),
(32,new String'("Castet-Arrouy"),32340,191,148,23,8.04,0.716667,43.9833,87,180),
(32,new String'("Préchac-sur-Adour"),32160,212,215,48,4.37,-0.00305556,43.6,126,142),
(32,new String'("Béraut"),32100,340,319,27,12.43,0.4,43.9167,82,207),
(32,new String'("Justian"),32190,99,93,15,6.3,0.3,43.8,95,221),
(32,new String'("Perchède"),32460,86,74,16,5.25,-0.133333,43.7667,81,131),
(32,new String'("Saint-Antoine"),32340,204,177,20,9.8,0.85,44.0333,64,198),
(32,new String'("Castin"),32810,290,261,25,11.22,0.533333,43.7,148,266),
(32,new String'("Castelnau-Barbarens"),32450,497,451,11,42.37,0.733333,43.5833,157,291),
(32,new String'("Roquebrune"),32190,196,188,10,18.41,0.3,43.7167,115,215),
(32,new String'("Bernède"),32400,216,204,26,8.18,-0.216667,43.6667,80,168),
(32,new String'("Laujuzan"),32110,246,225,21,11.34,-0.116667,43.8,74,138),
(32,new String'("Miramont-Latour"),32390,153,136,15,9.77,0.683333,43.7667,105,202),
(32,new String'("Roquelaure-Saint-Aubin"),32430,126,59,29,4.21,0.983333,43.6667,160,211),
(32,new String'("Bivès"),32380,135,130,13,9.93,0.816667,43.8333,107,192),
(32,new String'("Solomiac"),32120,461,362,33,13.8,0.883333,43.8,115,202),
(32,new String'("Préneron"),32190,144,142,16,8.63,0.266667,43.7167,115,201),
(32,new String'("Larroque-Saint-Sernin"),32410,165,182,9,17.96,0.483333,43.8167,95,232),
(32,new String'("Monlaur-Bernet"),32140,187,161,15,12.21,0.516667,43.35,237,376),
(32,new String'("Vergoignan"),32720,297,250,28,10.44,-0.2,43.7167,91,153),
(32,new String'("Bretagne-d'Armagnac"),32800,398,345,32,12.35,0.15,43.8833,113,185),
(32,new String'("Sorbets"),32110,210,194,22,9.21,-0.016667,43.7167,98,159),
(32,new String'("Saint-Créac"),32380,102,100,12,8.37,0.801667,43.9217,90,252),
(32,new String'("Sainte-Dode"),32170,223,237,11,18.84,0.366667,43.4167,179,340),
(32,new String'("Lahas"),32130,166,154,11,14.54,0.9,43.5667,166,281),
(32,new String'("Ségos"),32400,248,232,28,8.67,-0.25,43.6333,91,184),
(32,new String'("Lasserade"),32160,204,226,15,12.76,0.066667,43.6333,120,204),
(32,new String'("Villefranche"),32420,164,138,12,12.62,0.716667,43.4167,202,311),
(32,new String'("Montesquiou"),32320,600,570,12,46.8,0.333333,43.5833,145,256),
(32,new String'("Espaon"),32220,195,146,21,8.89,0.866667,43.4167,172,299),
(32,new String'("Armentieux"),32230,87,76,18,4.83,0.1,43.5167,141,221),
(32,new String'("Monlezun"),32230,198,189,11,17.35,0.216667,43.5,155,260),
(32,new String'("Monclar-sur-Losse"),32300,115,102,10,10.47,0.333333,43.5333,164,267),
(32,new String'("Tourrenquets"),32390,122,115,17,7.12,0.683333,43.75,135,224),
(32,new String'("Sembouès"),32230,66,56,24,2.65,0.166667,43.4667,157,272),
(32,new String'("Marsan"),32270,438,430,29,14.93,0.716667,43.6667,158,256),
(32,new String'("Saint-Michel"),32300,266,242,16,16.56,0.415,43.4289,168,286),
(32,new String'("Lias-d'Armagnac"),32240,197,183,16,11.92,-0.066667,43.8667,92,186),
(32,new String'("Monpardiac"),32170,43,35,12,3.5,0.25,43.4667,193,284),
(32,new String'("Saint-Pierre-d'Aubézies"),32290,78,74,9,8.42,0.166111,43.6434,131,245),
(32,new String'("Bézéril"),32130,116,92,12,9.65,0.9,43.55,172,272),
(32,new String'("Mas-d'Auvignon"),32700,170,170,12,13.74,0.5,43.8833,97,233),
(32,new String'("Lannepax"),32190,563,568,18,30.84,0.233333,43.8,107,217),
(32,new String'("Mauvezin"),32120,1947,1647,60,32.18,0.878056,43.7306,115,202),
(32,new String'("Augnax"),32120,88,57,22,4.0,0.783333,43.7167,150,213),
(32,new String'("Castillon-Massas"),32360,249,197,25,9.59,0.533333,43.7167,136,264),
(32,new String'("Saint-Griède"),32110,130,128,17,7.52,-0.1,43.7333,95,163),
(32,new String'("Marestaing"),32490,247,172,29,8.46,1.01667,43.5833,144,223),
(32,new String'("Ladevèze-Rivière"),32230,217,223,16,13.54,0.083333,43.55,134,220),
(32,new String'("Verlus"),32400,98,97,15,6.19,-0.2,43.6,98,236),
(32,new String'("Juilles"),32200,225,180,16,13.86,0.833333,43.6,145,234),
(32,new String'("Réjaumont"),32390,208,175,15,13.6,0.55,43.8167,118,242),
(32,new String'("Lanne-Soubiran"),32110,123,90,18,6.67,-0.1,43.7333,92,152),
(32,new String'("Larée"),32150,240,238,18,12.87,-0.05,43.9,98,153),
(32,new String'("Montestruc-sur-Gers"),32390,707,598,43,16.31,0.633333,43.8,91,180),
(32,new String'("Jû-Belloc"),32160,317,305,31,10.01,0.005,43.5833,131,202),
(32,new String'("Larressingle"),32100,211,200,24,8.55,0.3,43.9333,75,177),
(32,new String'("Beaucaire"),32410,286,277,17,16.14,0.383333,43.8333,85,208),
(32,new String'("Saint-Jean-Poutge"),32190,316,238,29,10.8,0.383333,43.7333,105,225),
(32,new String'("Maupas"),32240,192,212,19,9.85,-0.15,43.85,70,136),
(32,new String'("Le Houga"),32460,1180,1099,37,31.51,-0.183333,43.7667,87,153),
(32,new String'("Frégouville"),32490,325,201,26,12.32,0.95,43.6,159,252),
(32,new String'("Courrensan"),32330,391,375,15,25.16,0.233333,43.85,95,178),
(32,new String'("Estipouy"),32300,198,196,16,11.69,0.383333,43.55,139,256),
(32,new String'("Espas"),32370,116,124,7,15.13,0.066667,43.7667,119,221),
(32,new String'("Saint-Loube"),32220,97,62,15,6.09,0.991667,43.4395,183,305),
(32,new String'("Bézues-Bajon"),32140,209,183,16,12.86,0.616667,43.3833,220,314),
(32,new String'("Saint-Martin-d'Armagnac"),32110,227,202,21,10.8,-0.066667,43.7167,97,175),
(32,new String'("Encausse"),32430,386,270,24,15.65,1.03333,43.7,163,240),
(32,new String'("Montamat"),32220,121,92,18,6.6,0.85,43.4833,185,306),
(32,new String'("Barcugnan"),32170,120,143,13,9.11,0.4,43.3833,190,311),
(32,new String'("Manent-Montané"),32140,93,106,12,7.45,0.583333,43.3333,257,360),
(32,new String'("Pavie"),32550,2399,2220,97,24.67,0.6,43.6167,132,260),
(32,new String'("Sarcos"),32420,75,57,11,6.41,0.683333,43.3833,225,346),
(32,new String'("Gavarret-sur-Aulouste"),32390,130,128,15,8.38,0.652222,43.7717,94,201),
(32,new String'("Salles-d'Armagnac"),32370,118,105,19,6.08,-0.033333,43.8,82,184),
(32,new String'("Projan"),32400,156,142,13,11.78,-0.233333,43.6,92,231),
(32,new String'("Campagne-d'Armagnac"),32800,199,167,36,5.49,-0.00111111,43.85,104,155),
(32,new String'("Réans"),32800,251,257,20,12.31,0.033333,43.85,108,186),
(32,new String'("Ponsampère"),32300,108,118,12,8.9,0.383333,43.45,176,295),
(32,new String'("Ricourt"),32230,73,66,9,7.87,0.183333,43.4833,162,270),
(32,new String'("Saint-Caprais"),32200,135,102,17,7.89,0.787222,43.5939,155,237),
(32,new String'("Mirannes"),32350,70,74,8,7.89,0.383333,43.6167,123,233),
(32,new String'("Estramiac"),32380,134,132,13,9.69,0.866667,43.8333,106,212),
(32,new String'("Pellefigue"),32420,125,102,9,12.81,0.8,43.4667,182,308),
(32,new String'("Sainte-Christie-d'Armagnac"),32370,366,338,16,22.5,-0.016667,43.7667,85,175),
(32,new String'("Avensac"),32120,61,48,12,4.8,0.9,43.8333,111,207),
(32,new String'("L'Isle-de-Noé"),32300,549,443,21,25.66,0.416667,43.6,125,283),
(32,new String'("Lias"),32600,512,315,47,10.67,1.13333,43.5667,172,305),
(32,new String'("Montiron"),32200,123,131,11,10.54,0.85,43.5833,146,253),
(32,new String'("Maignaut-Tauzia"),32310,220,181,19,11.14,0.406389,43.8895,75,193),
(32,new String'("Monlezun-d'Armagnac"),32240,198,205,30,6.48,-0.15,43.8167,70,126),
(32,new String'("Sère"),32140,92,98,10,8.64,0.633333,43.4167,221,326),
(32,new String'("Arrouède"),32140,90,78,14,6.33,0.583333,43.35,222,327),
(32,new String'("Saint-Brès"),32120,85,88,14,5.89,0.766667,43.7833,138,210),
(32,new String'("Urgosse"),32110,238,230,35,6.7,-0.016667,43.7333,91,160),
(32,new String'("Sauveterre"),32220,231,229,14,16.45,0.857222,43.4564,170,311),
(32,new String'("Nizas"),32130,159,78,38,4.16,1.0,43.5,158,266),
(32,new String'("Sempesserre"),32700,305,311,14,20.99,0.65,44.0167,57,210),
(32,new String'("Magnan"),32110,231,196,20,11.3,-0.116667,43.75,81,136),
(32,new String'("Miradoux"),32340,533,497,15,34.58,0.766667,44.0,79,227),
(32,new String'("Cazeneuve"),32800,144,127,17,8.31,0.166667,43.8667,103,177),
(33,new String'("Saint-Jean-d'Illac"),33127,6966,5214,57,120.58,-0.783333,44.8167,34,61),
(33,new String'("Guîtres"),33230,1667,1475,332,5.02,-0.183333,45.0333,2,70),
(33,new String'("Canéjan"),33610,5109,5121,425,12.0,-0.654722,44.7631,23,56),
(33,new String'("Le Bouscat"),33110,23095,22457,4374,5.28,-0.616667,44.8667,2,27),
(33,new String'("Casseuil"),33190,383,367,60,6.34,-0.116667,44.5833,8,122),
(33,new String'("Génissac"),33420,1835,1319,140,13.04,-0.25,44.85,2,77),
(33,new String'("Libourne"),33500,23624,21764,1145,20.63,-0.233333,44.9167,2,28),
(33,new String'("Le Barp"),33114,4557,3241,42,107.32,-0.766667,44.6167,40,84),
(33,new String'("Virsac"),33240,992,900,275,3.6,-0.45,45.0333,33,56),
(33,new String'("Lavazan"),33690,228,179,25,8.97,-0.1,44.3833,87,143),
(33,new String'("Flaujagues"),33350,544,490,69,7.8,0.05,44.8333,2,84),
(33,new String'("Salaunes"),33160,779,574,18,42.64,-0.833333,44.9333,41,51),
(33,new String'("Origne"),33113,176,126,6,27.19,-0.516667,44.5,38,76),
(33,new String'("Saint-Christophe-des-Bardes"),33330,500,515,65,7.69,-0.1,44.8833,25,97),
(33,new String'("Bonzac"),33910,762,623,101,7.49,-0.216667,45.0,1,74),
(33,new String'("Petit-Palais-et-Cornemps"),33570,706,551,49,14.32,-0.066667,44.9833,16,85),
(33,new String'("Soussac"),33790,179,159,27,6.61,0.016667,44.7333,63,125),
(33,new String'("Cérons"),33720,1855,1347,236,7.83,-0.333333,44.6333,0,27),
(33,new String'("Beautiran"),33640,2180,2039,343,6.35,-0.45,44.7,3,22),
(33,new String'("Salignac"),33240,1443,1133,110,13.04,-0.366667,45.0167,13,64),
(33,new String'("Périssac"),33240,1079,875,88,12.16,-0.316667,45.0167,7,59),
(33,new String'("Mérignas"),33350,290,277,30,9.56,-0.083333,44.7833,9,96),
(33,new String'("Daignac"),33420,480,406,83,5.73,-0.25,44.8,16,86),
(33,new String'("Saint-Hilaire-de-la-Noaille"),33190,377,305,32,11.45,0.00166667,44.6012,39,130),
(33,new String'("Floirac"),33270,16202,16156,1868,8.67,-0.533333,44.8333,3,79),
(33,new String'("Prignac-et-Marcamps"),33710,1368,1288,141,9.66,-0.493333,45.0325,2,42),
(33,new String'("Baron"),33750,1076,867,104,10.34,-0.316667,44.8167,29,108),
(33,new String'("Mazères"),33210,669,547,50,13.14,-0.266667,44.5,19,124),
(33,new String'("Langon"),33210,7391,6168,539,13.71,-0.25,44.55,0,73),
(33,new String'("Saint-Seurin-de-Cursac"),33390,707,761,299,2.36,-0.633333,45.15,7,55),
(33,new String'("Saint-Laurent-Médoc"),33112,4221,3364,30,136.55,-0.821944,45.1503,4,41),
(33,new String'("Ambès"),33810,2894,2823,100,28.85,-0.533333,45.0167,0,8),
(33,new String'("La Sauve"),33670,1417,1216,76,18.64,-0.311944,44.7695,52,118),
(33,new String'("Saint-Hippolyte"),33330,162,209,36,4.45,-0.1,44.8833,9,101),
(33,new String'("Saint-Martin-de-Lerm"),33540,140,122,19,7.02,-0.033333,44.6333,13,96),
(33,new String'("Plassac"),33390,868,914,121,7.12,-0.65,45.1,0,79),
(33,new String'("Villenave-de-Rions"),33550,315,274,123,2.56,-0.333333,44.6833,14,103),
(33,new String'("Puynormand"),33660,312,247,40,7.64,-0.000555556,44.9833,32,117),
(33,new String'("Montussan"),33450,2778,2208,334,8.3,-0.416667,44.8833,7,88),
(33,new String'("Billaux"),33500,1097,816,175,6.26,-0.233333,44.95,2,16),
(33,new String'("Coutures"),33580,92,65,27,3.4,0.0286111,44.6448,17,105),
(33,new String'("Saint-Germain-de-la-Rivière"),33240,367,339,85,4.28,-0.333333,44.95,1,80),
(33,new String'("Saint-Émilion"),33330,1984,2345,73,27.02,-0.15,44.8833,3,107),
(33,new String'("Espiet"),33420,716,532,105,6.79,-0.266667,44.8,14,75),
(33,new String'("Blasimon"),33540,872,711,29,29.76,-0.066667,44.75,22,130),
(33,new String'("Eyrans"),33390,705,580,164,4.28,-0.616667,45.1833,1,27),
(33,new String'("Saint-Genès-de-Lombaud"),33670,308,250,50,6.14,-0.383333,44.75,22,99),
(33,new String'("Fronsac"),33126,1077,1044,70,15.29,-0.266667,44.9167,1,84),
(33,new String'("Martillac"),33650,2487,2017,145,17.09,-0.516667,44.7,8,59),
(33,new String'("Cazats"),33430,294,224,39,7.48,-0.216667,44.4833,38,124),
(33,new String'("Escoussans"),33760,295,244,57,5.11,-0.266667,44.6833,23,97),
(33,new String'("Camps-sur-l'Isle"),33660,541,388,179,3.02,-0.0316667,45.0156,11,24),
(33,new String'("Maransin"),33230,1055,869,35,29.94,-0.266667,45.0833,18,101),
(33,new String'("Marcenais"),33620,709,596,78,9.04,-0.333333,45.0667,16,65),
(33,new String'("Gradignan"),33170,23063,22180,1462,15.77,-0.616667,44.7667,10,51),
(33,new String'("Lussac"),33570,1308,1332,55,23.43,-0.1,44.95,22,84),
(33,new String'("Vertheuil"),33180,1226,1068,55,21.94,-0.834167,45.2503,5,35),
(33,new String'("Barde"),33460,628,634,131,4.76,-0.633333,45.0167,2,17),
(33,new String'("Tizac-de-Curton"),33420,287,296,72,3.97,-0.25,44.8167,9,77),
(33,new String'("Lamothe-Landerron"),33190,1122,1042,122,9.18,0.066667,44.55,15,106),
(33,new String'("Saint-Pierre-de-Mons"),33210,1077,814,116,9.27,-0.216667,44.55,2,55),
(33,new String'("Pompignac"),33370,2649,2527,227,11.62,-0.433333,44.85,17,89),
(33,new String'("Fours"),33390,283,279,60,4.64,-0.633333,45.1667,0,33),
(33,new String'("Sainte-Colombe"),33350,467,350,115,4.06,-0.0619444,44.8789,24,96),
(33,new String'("Sauveterre-de-Guyenne"),33540,1811,1793,57,31.75,-0.083333,44.7,38,107),
(33,new String'("Sainte-Foy-la-Longue"),33490,135,115,14,9.37,-0.15,44.6,40,113),
(33,new String'("Bieujac"),33210,504,416,72,6.97,-0.166667,44.55,13,58),
(33,new String'("Bagas"),33190,274,173,75,3.63,-0.05,44.6167,11,86),
(33,new String'("Blaignac"),33190,263,221,82,3.18,-0.05,44.55,12,63),
(33,new String'("Saint-Antoine-du-Queyret"),33790,85,77,12,6.85,0.016667,44.7667,40,122),
(33,new String'("Fargues"),33210,1604,1216,104,15.41,-0.275,44.5333,18,88),
(33,new String'("Lugasson"),33760,269,237,42,6.32,-0.166667,44.75,17,90),
(33,new String'("Bommes"),33210,476,436,82,5.8,-0.366667,44.5333,10,75),
(33,new String'("Saint-Pierre-de-Bat"),33760,314,271,35,8.95,-0.233333,44.6667,38,101),
(33,new String'("Saint-Estèphe"),33180,1660,1795,70,23.54,-0.771944,45.2592,0,31),
(33,new String'("Ladaux"),33760,204,186,47,4.29,-0.233333,44.7,33,87),
(33,new String'("Grignols"),33690,1124,1058,49,22.7,-0.041667,44.3917,49,166),
(33,new String'("Saint-Vivien-de-Blaye"),33920,350,321,61,5.69,-0.5,45.1,8,51),
(33,new String'("Saint-Symphorien"),33113,1742,1397,16,106.29,-0.483333,44.4333,45,86),
(33,new String'("Bourdelles"),33190,115,107,16,7.06,0.000277778,44.55,7,40),
(33,new String'("La Réole"),33190,4230,4193,337,12.53,-0.033333,44.5833,5,133),
(33,new String'("Caumont"),33540,158,122,20,7.58,-0.00472222,44.6833,37,108),
(33,new String'("Mongauzy"),33190,582,570,85,6.84,0.033333,44.5667,13,110),
(33,new String'("Branne"),33420,1294,949,536,2.41,-0.183333,44.8333,2,81),
(33,new String'("Saint-Léon"),33670,330,242,73,4.49,-0.266667,44.7667,45,117),
(33,new String'("Puybarban"),33190,413,309,74,5.58,-0.066667,44.55,12,65),
(33,new String'("Saint-Seurin-sur-l'Isle"),33660,3053,2376,345,8.83,-0.00166667,45.0167,12,75),
(33,new String'("Coutras"),33230,8045,7027,238,33.69,-0.133333,45.0333,4,74),
(33,new String'("Lugaignac"),33420,394,300,107,3.66,-0.183333,44.8167,10,89),
(33,new String'("Monprimblanc"),33410,278,276,55,4.97,-0.266667,44.6167,24,116),
(33,new String'("Coimères"),33210,866,657,67,12.91,-0.216667,44.5,40,122),
(33,new String'("Francs"),33570,212,178,32,6.59,-0.00611111,44.95,28,96),
(33,new String'("Saint-Genès-de-Castillon"),33350,395,389,58,6.8,-0.066667,44.9,32,98),
(33,new String'("Belin-Béliet"),33830,4379,2757,28,156.03,-0.79,44.4975,11,84),
(33,new String'("Porchères"),33660,902,726,68,13.19,0.016667,45.0333,12,85),
(33,new String'("Saint-Étienne-de-Lisse"),33330,279,355,39,7.09,-0.1,44.8833,11,91),
(33,new String'("Neuffons"),33580,169,122,36,4.67,0.016667,44.65,12,98),
(33,new String'("Loupiac-de-la-Réole"),33190,471,335,88,5.32,-0.05,44.55,13,65),
(33,new String'("Saint-Trojan"),33710,323,318,105,3.05,-0.566667,45.0833,39,92),
(33,new String'("Comps"),33710,480,389,289,1.66,-0.583333,45.0667,28,82),
(33,new String'("Cénac"),33360,1843,1806,245,7.5,-0.45,44.7833,7,82),
(33,new String'("Léogeats"),33210,720,547,36,19.61,-0.366667,44.5167,15,102),
(33,new String'("Noaillan"),33730,1564,1016,49,31.8,-0.366667,44.4833,17,99),
(33,new String'("Saint-Pey-d'Armens"),33330,261,276,62,4.2,-0.113333,44.8556,6,16),
(33,new String'("Biganos"),33380,9672,6954,183,52.73,-0.983333,44.65,0,45),
(33,new String'("Saint-Macaire"),33490,1995,1541,1114,1.79,-0.216667,44.5667,0,30),
(33,new String'("Cézac"),33620,2337,1764,121,19.16,-0.416667,45.1,2,76),
(33,new String'("Virelade"),33720,922,747,68,13.41,-0.383333,44.65,4,31),
(33,new String'("Vayres"),33870,3429,2625,237,14.46,-0.316667,44.9,2,39),
(33,new String'("Bouliac"),33270,3106,3244,415,7.48,-0.516667,44.8167,4,84),
(33,new String'("Vignonet"),33330,541,534,130,4.15,-0.166667,44.85,3,13),
(33,new String'("Valeyrac"),33340,525,418,38,13.49,-0.9,45.4,0,18),
(33,new String'("Bordeaux"),33000,239157,215374,4845,49.36,-0.566667,44.8333,1,42),
(33,new String'("Berthez"),33124,221,166,36,6.03,-0.133333,44.4833,29,115),
(33,new String'("Cubzac-les-Ponts"),33240,2067,1787,231,8.92,-0.45,44.9667,1,42),
(33,new String'("Saint-Côme"),33430,296,249,49,5.96,-0.180833,44.4259,42,124),
(33,new String'("Villegouge"),33141,1237,1093,89,13.84,-0.3,44.9667,11,81),
(33,new String'("Saint-André-et-Appelles"),33220,689,687,67,10.25,0.2,44.8,7,114),
(33,new String'("Civrac-de-Blaye"),33920,791,668,59,13.25,-0.45,45.1167,8,51),
(33,new String'("Baurech"),33880,749,692,97,7.68,-0.45,44.7167,2,97),
(33,new String'("Saint-Laurent-du-Bois"),33540,239,219,32,7.41,-0.133333,44.6333,37,97),
(33,new String'("Artigues-de-Lussac"),33570,1051,971,103,10.16,-0.15,44.9667,18,66),
(33,new String'("Arveyres"),33500,1886,1625,109,17.27,-0.283333,44.8833,1,41),
(33,new String'("Queyrac"),33340,1388,1164,45,30.73,-0.983333,45.3667,3,13),
(33,new String'("Mombrier"),33710,362,343,85,4.25,-0.533333,45.0667,17,83),
(33,new String'("Illats"),33720,1280,1161,43,29.24,-0.366667,44.6,3,61),
(33,new String'("Néac"),33500,389,403,56,6.88,-0.183333,44.9333,10,54),
(33,new String'("Escaudes"),33840,150,167,5,25.77,-0.2,44.3,60,107),
(33,new String'("Salles-de-Castillon"),33350,390,370,36,10.81,-0.00111111,44.9,18,100),
(33,new String'("Saint-Christoly-Médoc"),33340,284,323,37,7.55,-0.833333,45.35,1,16),
(33,new String'("Bonnetan"),33370,806,734,187,4.29,-0.416667,44.8167,34,100),
(33,new String'("Campugnan"),33390,467,407,74,6.23,-0.566667,45.1833,14,43),
(33,new String'("Jau-Dignac-et-Loirac"),33590,1051,867,25,41.23,-0.95581,45.4076,0,14),
(33,new String'("Prignac-en-Médoc"),33340,232,163,31,7.44,-0.916667,45.3333,7,33),
(33,new String'("Arsac"),33460,3146,2820,96,32.6,-0.683333,45.0,5,41),
(33,new String'("Jugazan"),33420,282,221,50,5.53,-0.166667,44.7833,8,98),
(33,new String'("Margaux"),33460,1506,1344,204,7.36,-0.666667,45.05,1,23),
(33,new String'("Pompéjac"),33730,240,230,24,9.74,-0.266667,44.4,36,105),
(33,new String'("Marcheprime"),33380,4301,3486,175,24.56,-0.85,44.6833,34,62),
(33,new String'("Aillas"),33124,761,672,21,35.13,-0.066667,44.4667,29,138),
(33,new String'("Loupiac"),33410,1099,939,114,9.57,-0.298056,44.6278,3,108),
(33,new String'("Bègles"),33130,24913,22538,2501,9.96,-0.533333,44.8,3,18),
(33,new String'("Gajac"),33430,388,323,31,12.28,-0.133333,44.4333,36,144),
(33,new String'("Nérigean"),33750,859,908,86,9.98,-0.283333,44.8333,8,76),
(33,new String'("Langoiran"),33550,2230,1992,219,10.14,-0.383333,44.7,2,101),
(33,new String'("Cubnezais"),33620,1324,1049,128,10.3,-0.408333,45.075,11,61),
(33,new String'("Croignon"),33750,499,382,108,4.62,-0.333333,44.8167,26,103),
(33,new String'("Lansac"),33710,689,640,114,6.0,-0.533333,45.0667,7,68),
(33,new String'("Saint-Philippe-du-Seignal"),33220,461,395,136,3.38,0.233333,44.8167,20,113),
(33,new String'("Préchac"),33730,1038,1017,16,63.87,-0.35,44.4,26,93),
(33,new String'("Villandraut"),33730,969,816,77,12.58,-0.366667,44.4667,20,54),
(33,new String'("Saint-Martin-du-Bois"),33910,821,589,83,9.8,-0.266667,45.0333,5,81),
(33,new String'("Verdelais"),33490,919,869,193,4.75,-0.25,44.5833,2,103),
(33,new String'("Macau"),33460,3486,2884,178,19.56,-0.616667,45.0167,0,26),
(33,new String'("Parempuyre"),33290,7978,6620,365,21.8,-0.583333,44.95,0,15),
(33,new String'("Daubèze"),33540,152,138,26,5.63,-0.15,44.7,43,94),
(33,new String'("Béguey"),33410,1128,914,356,3.16,-0.333333,44.6333,2,90),
(33,new String'("Cauvignac"),33690,151,107,27,5.51,-0.066667,44.4167,59,152),
(33,new String'("Audenge"),33980,6052,3943,73,82.09,-1.0,44.6833,0,59),
(33,new String'("Sigalens"),33690,356,238,19,18.33,-0.05,44.45,33,136),
(33,new String'("Landerrouet-sur-Ségur"),33540,115,108,36,3.14,-0.0227778,44.6537,14,82),
(33,new String'("Marimbault"),33430,163,96,24,6.71,-0.266667,44.4,88,123),
(33,new String'("Castelnau-de-Médoc"),33480,3728,3165,155,23.92,-0.8,45.0333,14,47),
(33,new String'("Saint-Selve"),33650,2095,1638,118,17.74,-0.483333,44.6667,7,63),
(33,new String'("La Roquille"),33220,309,312,47,6.51,0.233333,44.7833,62,125),
(33,new String'("Saint-Léger-de-Balson"),33113,317,247,8,38.04,-0.466667,44.4333,27,71),
(33,new String'("Saint-Sauveur-de-Puynormand"),33660,407,361,73,5.57,-0.033333,45.0,19,93),
(33,new String'("Bayon-sur-Gironde"),33710,727,748,127,5.7,-0.600556,45.0542,0,82),
(33,new String'("Bassens"),33530,6899,6972,671,10.28,-0.516667,44.9,2,56),
(33,new String'("Budos"),33720,706,630,33,21.1,-0.383333,44.5333,12,70),
(33,new String'("Pondaurat"),33190,430,356,49,8.74,-0.083333,44.55,11,67),
(33,new String'("Saint-Genès-de-Blaye"),33390,469,396,63,7.41,-0.633333,45.1667,0,34),
(33,new String'("Gornac"),33540,385,368,46,8.35,-0.183333,44.6667,54,113),
(33,new String'("Sauviac"),33430,334,246,29,11.15,-0.183333,44.4,55,127),
(33,new String'("Montignac"),33760,141,110,21,6.48,-0.216667,44.7,49,105),
(33,new String'("Cessac"),33760,187,169,51,3.65,-0.183333,44.7333,21,77),
(33,new String'("Saint-Magne"),33125,990,814,11,82.66,-0.666667,44.5333,50,81),
(33,new String'("Saint-Aubin-de-Médoc"),33160,6186,4985,178,34.72,-0.716667,44.75,23,51),
(33,new String'("Carcans"),33121,2190,1549,12,175.4,-1.05,45.0833,0,65),
(33,new String'("Le Haillan"),33185,8933,8134,964,9.26,-0.683333,44.8667,8,47),
(33,new String'("Pineuilh"),33220,4417,3641,254,17.36,0.216667,44.8167,7,125),
(33,new String'("Goualade"),33840,87,77,5,17.0,-0.15,44.3,74,143),
(33,new String'("Aubiac"),33430,242,259,43,5.62,-0.25,44.4833,46,123),
(33,new String'("Cantois"),33760,227,173,28,8.0,-0.233333,44.6833,44,106),
(33,new String'("Masseilles"),33690,127,120,18,6.72,-0.05,44.4,60,152),
(33,new String'("Lèves-et-Thoumeyragues"),33220,548,543,35,15.58,0.174722,44.7931,30,126),
(33,new String'("Lestiac-sur-Garonne"),33550,620,585,208,2.98,-0.383333,44.6833,3,96),
(33,new String'("Lesparre-Médoc"),33340,5581,4856,150,36.97,-0.933333,45.3,7,34),
(33,new String'("Saint-Laurent-du-Plan"),33190,86,71,35,2.39,-0.116667,44.6167,19,82),
(33,new String'("Saint-Ciers-sur-Gironde"),33820,3085,3098,80,38.34,-0.616667,45.3,0,57),
(33,new String'("Bellefond"),33760,225,202,70,3.19,-0.183333,44.7667,12,73),
(33,new String'("Quinsac"),33360,2048,1768,251,8.14,-0.5,44.75,2,86),
(33,new String'("Aubie-et-Espessas"),33240,1195,950,158,7.55,-0.4,45.0167,14,56),
(33,new String'("Blaye"),33390,4802,4668,747,6.42,-0.662222,45.1278,0,41),
(33,new String'("Bégadan"),33340,909,879,41,22.15,-0.9,45.35,0,18),
(33,new String'("Pellegrue"),33790,991,977,25,38.18,0.083333,44.75,33,132),
(33,new String'("Saint-Médard-d'Eyrans"),33650,2802,2277,220,12.72,-0.516667,44.7167,3,51),
(33,new String'("Gironde-sur-Dropt"),33190,1141,1108,129,8.84,-0.0894444,44.5837,8,93),
(33,new String'("Saint-Girons-d'Aiguevives"),33920,956,791,80,11.94,-0.533333,45.15,24,81),
(33,new String'("Tauriac"),33710,1301,1294,123,10.51,-0.483333,45.05,1,46),
(33,new String'("La Teste-de-Buch"),33260,24591,22976,136,180.2,-1.13704,44.6343,0,101),
(33,new String'("Castelviel"),33540,186,185,23,8.02,-0.166667,44.6667,53,121),
(33,new String'("Mauriac"),33540,270,225,26,10.02,-0.033333,44.75,37,112),
(33,new String'("Cabanac-et-Villagrains"),33650,2121,1436,30,69.0,-0.55,44.6,22,77),
(33,new String'("Yvrac"),33370,2534,2160,298,8.48,-0.466667,44.8833,24,88),
(33,new String'("Eysines"),33320,19571,18411,1629,12.01,-0.65,44.8833,3,45),
(33,new String'("Saint-Avit-Saint-Nazaire"),33220,1514,1381,81,18.61,0.2575,44.8503,6,38),
(33,new String'("Birac"),33430,229,181,22,10.17,-0.133333,44.4167,48,135),
(33,new String'("Gans"),33430,188,158,26,7.01,-0.15,44.45,35,134),
(33,new String'("Loubens"),33190,309,310,52,5.89,-0.033333,44.6167,13,94),
(33,new String'("Saint-Morillon"),33650,1493,1082,73,20.4,-0.516667,44.65,15,67),
(33,new String'("Gours"),33660,437,373,55,7.89,0.033333,45.0,17,82),
(33,new String'("Saint-Androny"),33390,572,564,49,11.65,-0.65,45.1833,0,36),
(33,new String'("Brannens"),33124,224,173,37,6.04,-0.166667,44.5333,15,65),
(33,new String'("Anglade"),33390,896,769,64,13.82,-0.633333,45.2167,1,32),
(33,new String'("Lamarque"),33460,1188,955,133,8.91,-0.7,45.1,0,19),
(33,new String'("Pauillac"),33250,5075,5177,223,22.74,-0.75,45.2,0,29),
(33,new String'("Bazas"),33430,4715,4352,126,37.29,-0.216667,44.4333,34,123),
(33,new String'("Donnezac"),33860,849,778,23,35.75,-0.45,45.25,23,82),
(33,new String'("Saint-Ciers-d'Abzac"),33910,1385,1070,118,11.71,-0.266667,45.0333,6,67),
(33,new String'("Arcachon"),33120,10975,11459,1451,7.56,-1.16355,44.6589,0,45),
(33,new String'("Saint-Caprais-de-Blaye"),33820,536,405,103,5.17,-0.566667,45.2833,15,59),
(33,new String'("Pomerol"),33500,715,850,114,6.24,-0.2,44.9333,7,39),
(33,new String'("Camiran"),33190,435,442,74,5.8,-0.066667,44.6167,11,83),
(33,new String'("Mazion"),33390,515,402,138,3.71,-0.616667,45.1667,9,34),
(33,new String'("Saint-Savin"),33920,2834,2080,83,33.87,-0.448611,45.1387,19,93),
(33,new String'("Bourg"),33710,2197,2118,208,10.54,-0.557222,45.04,1,81),
(33,new String'("Landiras"),33720,2096,1505,35,59.75,-0.416667,44.5667,13,83),
(33,new String'("Talais"),33590,662,550,43,15.27,-1.05833,45.475,0,16),
(33,new String'("Saugon"),33920,405,328,26,15.5,-0.5,45.1833,17,66),
(33,new String'("Saint-Michel-de-Fronsac"),33126,538,592,97,5.49,-0.316667,44.9333,1,79),
(33,new String'("Saint-Martial"),33490,208,170,27,7.47,-0.183333,44.6167,47,112),
(33,new String'("Fargues-Saint-Hilaire"),33370,2711,2249,386,7.02,-0.45,44.8167,17,88),
(33,new String'("Cadillac"),33410,2520,2365,463,5.44,-0.316667,44.6333,3,92),
(33,new String'("Gujan-Mestras"),33470,19305,14963,357,53.99,-1.06667,44.6333,0,28),
(33,new String'("Abzac"),33230,1790,1598,133,13.44,-0.133333,45.0167,5,65),
(33,new String'("Cardan"),33410,439,373,103,4.25,-0.333333,44.6833,43,117),
(33,new String'("Saint-Antoine-sur-l'Isle"),33660,535,435,51,10.4,0.05,45.0333,15,113),
(33,new String'("Sainte-Gemme"),33580,243,187,25,9.55,0.083333,44.6167,30,116),
(33,new String'("Sablons"),33910,1295,1181,109,11.84,-0.183333,45.0333,1,16),
(33,new String'("Saint-Loubès"),33450,8004,7089,319,25.07,-0.433333,44.9167,1,57),
(33,new String'("Vensac"),33590,880,694,25,34.0,-1.04167,45.4,0,30),
(33,new String'("Saint-Sulpice-et-Cameyrac"),33450,4339,3914,288,15.04,-0.4,44.9167,3,64),
(33,new String'("Andernos-les-Bains"),33510,11127,9256,556,20.01,-1.1,44.7429,1,30),
(33,new String'("Saint-Médard-en-Jalles"),33160,27719,25590,325,85.28,-0.733333,44.9,9,48),
(33,new String'("Captieux"),33840,1425,1505,11,119.33,-0.25,44.2833,69,136),
(33,new String'("Riocaud"),33220,197,179,18,10.4,0.2,44.7667,60,130),
(33,new String'("Saint-Christophe-de-Double"),33230,663,578,18,36.13,0.0158333,45.0806,24,108),
(33,new String'("Saint-Michel-de-Lapujade"),33190,193,221,25,7.47,0.0705556,44.5817,24,122),
(33,new String'("Cars"),33390,1160,1189,104,11.1,-0.616667,45.1333,17,71),
(33,new String'("Saucats"),33650,2136,1663,23,89.15,-0.6,44.65,24,70),
(33,new String'("Toulenne"),33210,2582,1991,392,6.58,-0.266667,44.55,1,34),
(33,new String'("La Lande-de-Fronsac"),33240,2393,1867,280,8.53,-0.383333,44.9833,6,49),
(33,new String'("Saint-Laurent-d'Arce"),33240,1362,1057,168,8.07,-0.466667,45.0333,3,46),
(33,new String'("Saint-Seurin-de-Cadourne"),33180,714,767,45,15.77,-0.783333,45.2833,1,23),
(33,new String'("Martres"),33760,132,105,43,3.03,-0.183333,44.7,38,79),
(33,new String'("Pleine-Selve"),33820,220,192,52,4.23,-0.575833,45.3275,29,90),
(33,new String'("Chamadelle"),33230,677,559,44,15.35,-0.066667,45.1,7,87),
(33,new String'("Marcillac"),33860,1168,995,36,32.23,-0.516667,45.2667,7,82),
(33,new String'("Cleyrac"),33540,158,149,26,6.07,-0.033333,44.7167,53,106),
(33,new String'("Cartelègue"),33390,1104,872,96,11.45,-0.583333,45.1833,4,39),
(33,new String'("Le Teich"),33470,6586,4820,75,87.08,-1.01667,44.6333,0,35),
(33,new String'("Blanquefort"),33290,14779,13902,438,33.72,-0.633333,44.9167,0,39),
(33,new String'("Saint-Caprais-de-Bordeaux"),33880,2717,2535,264,10.26,-0.45,44.75,25,97),
(33,new String'("Naujac-sur-Mer"),33990,844,631,8,98.55,-1.03333,45.25,0,61),
(33,new String'("Soulac-sur-Mer"),33780,2645,2729,91,28.89,-1.11667,45.5083,0,25),
(33,new String'("Camarsac"),33750,936,770,174,5.35,-0.366667,44.8333,24,99),
(33,new String'("Saint-Germain-du-Puch"),33750,2105,1982,178,11.76,-0.316667,44.85,11,71),
(33,new String'("Artigues-près-Bordeaux"),33370,7245,5984,995,7.28,-0.516667,44.85,30,81),
(33,new String'("Bellebat"),33760,241,143,49,4.87,-0.216667,44.7333,51,117),
(33,new String'("Saint-Sauveur"),33250,1262,1188,57,21.89,-0.835,45.2023,5,33),
(33,new String'("Arès"),33740,5576,4669,115,48.25,-1.1394,44.7671,0,37),
(33,new String'("Tresses"),33370,4155,3597,360,11.54,-0.466667,44.85,27,88),
(33,new String'("Ordonnac"),33340,461,405,45,10.21,-0.833333,45.3,2,35),
(33,new String'("Saint-Palais"),33820,486,420,49,9.76,-0.589722,45.3139,7,91),
(33,new String'("Margueron"),33220,385,400,28,13.57,0.25,44.7667,49,132),
(33,new String'("Saint-Yzan-de-Soudiac"),33920,2186,1531,196,11.14,-0.416667,45.1333,35,92),
(33,new String'("Grézillac"),33420,715,610,91,7.79,-0.216667,44.8167,3,83),
(33,new String'("Le Verdon-sur-Mer"),33123,1356,1273,79,17.09,-1.06667,45.5417,0,36),
(33,new String'("Tabanac"),33550,1056,974,132,8.0,-0.416667,44.7167,3,94),
(33,new String'("Saint-Vincent-de-Pertignas"),33420,364,369,47,7.61,-0.116667,44.8,2,88),
(33,new String'("Lagorce"),33230,1660,1294,58,28.47,-0.133333,45.0667,5,91),
(33,new String'("Saint-Germain-d'Esteuil"),33340,1187,1086,26,44.71,-0.866667,45.2833,3,32),
(33,new String'("Saint-Michel-de-Castelnau"),33840,241,216,5,42.61,-0.116667,44.2833,78,147),
(33,new String'("Haux"),33550,795,732,77,10.21,-0.383333,44.7333,11,101),
(33,new String'("Baigneaux"),33760,347,245,43,7.93,-0.183333,44.7167,32,90),
(33,new String'("Bruges"),33520,14903,10613,1048,14.22,-0.616667,44.8833,1,31),
(33,new String'("Saint-Quentin-de-Caplong"),33220,248,276,22,11.27,0.15,44.7833,18,111),
(33,new String'("Générac"),33920,575,493,60,9.44,-0.55,45.1833,19,50),
(33,new String'("Civrac-en-Médoc"),33340,584,502,31,18.35,-0.9,45.3333,6,22),
(33,new String'("Cantenac"),33460,1310,1177,91,14.26,-0.65,45.0333,1,22),
(33,new String'("Fossès-et-Baleyssac"),33190,183,158,19,9.4,0.05,44.5833,33,113),
(33,new String'("Saint-Mariens"),33620,1510,1178,125,12.0,-0.416667,45.1167,29,98),
(33,new String'("Sallebœuf"),33370,2223,1928,150,14.8,-0.4,44.8333,21,97),
(33,new String'("Saint-Martin-de-Laye"),33910,501,386,52,9.56,-0.216667,45.0333,4,81),
(33,new String'("Romagne"),33760,427,277,82,5.15,-0.183333,44.7667,20,87),
(33,new String'("Rimons"),33580,203,190,14,14.38,0.016667,44.6667,29,106),
(33,new String'("Dardenac"),33420,93,59,62,1.5,-0.233333,44.7833,33,86),
(33,new String'("Donzac"),33410,148,124,33,4.41,-0.266667,44.65,35,121),
(33,new String'("Saint-Quentin-de-Baron"),33750,1934,958,222,8.69,-0.283333,44.8167,10,80),
(33,new String'("Camiac-et-Saint-Denis"),33420,378,253,57,6.6,-0.266667,44.8,28,114),
(33,new String'("Lignan-de-Bazas"),33430,307,243,27,11.1,-0.283333,44.4333,77,123),
(33,new String'("Barie"),33190,281,211,52,5.33,-0.116667,44.5667,7,18),
(33,new String'("Pujols"),33350,574,608,77,7.4,-0.033333,44.8,9,98),
(33,new String'("Castillon-de-Castets"),33210,302,216,67,4.47,-0.116667,44.55,12,56),
(33,new String'("Cours-de-Monségur"),33580,279,249,28,9.64,0.133333,44.65,24,121),
(33,new String'("Saint-Louis-de-Montferrand"),33440,2034,1863,188,10.8,-0.533333,44.95,1,5),
(33,new String'("Moulon"),33420,968,928,73,13.25,-0.220556,44.8473,2,76),
(33,new String'("Le Pian-Médoc"),33290,5570,5375,184,30.12,-0.633333,44.9667,5,37),
(33,new String'("Vérac"),33240,820,715,95,8.59,-0.333333,44.9833,11,69),
(33,new String'("Pessac-sur-Dordogne"),33890,476,466,61,7.78,0.083333,44.8167,3,106),
(33,new String'("Saint-Genès-de-Fronsac"),33240,717,575,103,6.96,-0.366667,45.0333,24,64),
(33,new String'("Frontenac"),33760,727,650,50,14.4,-0.15,44.75,24,105),
(33,new String'("Fontet"),33190,795,731,103,7.67,-0.033333,44.55,5,63),
(33,new String'("Saint-Sulpice-de-Pommiers"),33540,226,228,23,9.82,-0.116667,44.6667,33,101),
(33,new String'("Hostens"),33125,1337,741,23,57.64,-0.633333,44.5,49,100),
(33,new String'("Coirac"),33540,212,179,36,5.76,-0.166667,44.6833,48,91),
(33,new String'("Mesterrieux"),33540,202,179,56,3.59,-0.016667,44.6333,12,86),
(33,new String'("Teuillac"),33710,778,667,108,7.15,-0.533333,45.0833,22,86),
(33,new String'("Caudrot"),33490,1134,932,185,6.12,-0.15,44.5667,6,111),
(33,new String'("Tayac"),33570,144,131,19,7.22,-0.01,44.9525,37,87),
(33,new String'("Mouillac"),33240,99,103,52,1.87,-0.35,45.0167,27,64),
(33,new String'("Carignan-de-Bordeaux"),33360,3689,3095,420,8.78,-0.474722,44.815,10,86),
(33,new String'("Le Tuzan"),33125,225,161,12,18.0,-0.6,44.45,66,87),
(33,new String'("Martignas-sur-Jalle"),33127,7227,5581,273,26.39,-0.766667,44.8333,22,46),
(33,new String'("Grayan-et-l'Hôpital"),33590,1258,728,27,45.4,-1.08333,45.4417,0,35),
(33,new String'("Faleyras"),33760,397,310,38,10.44,-0.216667,44.7667,26,102),
(33,new String'("Cours-les-Bains"),33690,217,158,20,10.43,-0.016667,44.3833,85,167),
(33,new String'("Gabarnac"),33410,322,265,61,5.21,-0.283333,44.6167,24,120),
(33,new String'("Cissac-Médoc"),33250,1772,1535,75,23.62,-0.833333,45.2167,5,33),
(33,new String'("Lartigue"),33840,51,44,3,13.64,-0.1,44.25,91,127),
(33,new String'("Vendays-Montalivet"),33930,2384,1827,23,101.46,-1.05833,45.3583,0,57),
(33,new String'("Saint-Michel-de-Rieufret"),33720,547,498,28,18.94,-0.433333,44.6167,19,66),
(33,new String'("Blaignan"),33340,240,239,35,6.83,-0.883333,45.3167,7,34),
(33,new String'("Saint-Loubert"),33210,185,129,87,2.11,-0.183333,44.55,10,46),
(33,new String'("Lugon-et-l'Île-du-Carnay"),33240,1128,999,103,10.94,-0.340833,44.9578,1,72),
(33,new String'("Saint-André-du-Bois"),33490,403,389,40,10.0,-0.2,44.6,33,117),
(33,new String'("Isle-Saint-Georges"),33640,536,522,123,4.35,-0.483333,44.7167,2,5),
(33,new String'("Pugnac"),33710,2034,1892,150,13.53,-0.483333,45.0833,3,52),
(33,new String'("Saint-Gervais"),33240,1568,1219,281,5.58,-0.45,45.0167,3,50),
(33,new String'("Gauriaguet"),33240,1166,943,217,5.37,-0.4,45.0333,23,54),
(33,new String'("Noaillac"),33190,390,291,49,7.94,-0.0111111,44.5167,22,70),
(33,new String'("Saint-Jean-de-Blaignac"),33420,404,401,72,5.58,-0.133333,44.8167,3,93),
(33,new String'("Taillecavat"),33580,308,263,32,9.49,0.166667,44.6333,28,101),
(33,new String'("Omet"),33410,262,226,100,2.62,-0.283333,44.65,20,102),
(33,new String'("Hourtin"),33990,3235,2325,16,190.5,-1.06667,45.2,0,64),
(33,new String'("Le Nizan"),33430,411,349,27,15.21,-0.266667,44.4833,41,115),
(33,new String'("Saint-Médard-de-Guizières"),33230,2390,2107,230,10.37,-0.05,45.0167,8,67),
(33,new String'("Braud-et-Saint-Louis"),33820,1385,1305,28,49.24,-0.616667,45.25,0,29),
(33,new String'("Avensan"),33480,2222,1752,42,52.24,-0.75,45.0333,4,51),
(33,new String'("Tizac-de-Lapouyade"),33620,490,438,52,9.4,-0.3,45.0667,15,79),
(33,new String'("Peujard"),33240,1760,1397,160,10.98,-0.45,45.0333,10,54),
(33,new String'("Arcins"),33460,433,309,63,6.77,-0.716667,45.0667,1,18),
(33,new String'("Eynesse"),33220,583,478,76,7.59,0.15,44.8167,8,111),
(33,new String'("Lacanau"),33680,4428,3129,20,214.02,-1.079,44.9833,0,66),
(33,new String'("Lormont"),33310,19799,21340,2690,7.36,-0.533333,44.8667,2,63),
(33,new String'("Savignac-de-l'Isle"),33910,510,476,114,4.47,-0.235278,44.99,2,60),
(33,new String'("Bayas"),33230,454,420,41,10.82,-0.2,45.0667,8,81),
(33,new String'("Juillac"),33890,261,205,44,5.86,0.04,44.8112,2,108),
(33,new String'("Carbon-Blanc"),33560,6885,6620,1783,3.86,-0.5,44.8833,10,55),
(33,new String'("Rauzan"),33420,1161,1037,178,6.5,-0.116667,44.7833,5,100),
(33,new String'("Uzeste"),33730,449,416,17,26.05,-0.316667,44.45,24,104),
(33,new String'("Villenave-d'Ornon"),33140,28420,27489,1336,21.26,-0.55,44.7667,3,41),
(33,new String'("Saint-Laurent-des-Combes"),33330,279,347,72,3.86,-0.133333,44.8833,9,107),
(33,new String'("Dieulivol"),33580,288,263,27,10.47,0.116667,44.6667,22,111),
(33,new String'("Saint-Philippe-d'Aiguille"),33350,415,424,70,5.87,-0.033333,44.9167,38,117),
(33,new String'("Arbis"),33760,285,243,32,8.74,-0.25,44.6667,23,107),
(33,new String'("Capian"),33550,647,624,35,18.23,-0.333333,44.7,17,115),
(33,new String'("Saint-Maixant"),33490,1566,1277,203,7.68,-0.266667,44.5667,0,98),
(33,new String'("Roquebrune"),33580,242,217,37,6.52,0.033333,44.6167,14,108),
(33,new String'("Preignac"),33210,2166,2025,163,13.26,-0.3,44.5833,2,59),
(33,new String'("Esseintes"),33190,269,218,52,5.1,-0.066667,44.6,11,94),
(33,new String'("Labescau"),33690,105,97,17,5.99,-0.083333,44.45,63,141),
(33,new String'("La Brède"),33650,3825,3129,164,23.28,-0.528611,44.6814,9,61),
(33,new String'("Cudos"),33430,842,557,24,34.21,-0.216667,44.3833,60,133),
(33,new String'("Mios"),33380,7219,4625,52,137.41,-0.933333,44.6,4,65),
(33,new String'("Cestas"),33610,16353,16936,164,99.57,-0.683333,44.7333,33,67),
(33,new String'("Samonac"),33710,426,378,109,3.9,-0.55,45.0667,17,88),
(33,new String'("Bernos-Beaulac"),33430,1152,1075,31,36.8,-0.258333,44.38,46,122),
(33,new String'("Hure"),33190,497,438,70,7.09,0.016667,44.55,12,63),
(33,new String'("Églisottes-et-Chalaures"),33230,2167,1883,126,17.16,-0.0375,45.0998,10,103),
(33,new String'("Savignac"),33124,600,493,35,17.02,-0.108889,44.5228,27,106),
(33,new String'("Listrac-Médoc"),33480,2404,1858,38,61.9,-0.8,45.0833,9,44),
(33,new String'("Le Pout"),33670,464,340,118,3.93,-0.366667,44.8,35,106),
(33,new String'("Saint-Romain-la-Virvée"),33240,787,755,100,7.82,-0.4,44.9667,2,63),
(33,new String'("Gensac"),33890,860,800,91,9.38,0.083333,44.8,15,115),
(33,new String'("Ambarès-et-Lagrave"),33440,13270,11204,535,24.76,-0.486667,44.9248,0,34),
(33,new String'("Doulezon"),33350,265,230,36,7.36,-0.00555556,44.7833,26,112),
(33,new String'("Latresne"),33360,3277,3195,315,10.39,-0.483333,44.7833,2,72),
(33,new String'("Castres-Gironde"),33640,2108,1512,302,6.97,-0.45,44.6833,3,32),
(33,new String'("Saint-Exupéry"),33190,159,119,37,4.19,-0.1,44.6167,17,83),
(33,new String'("Saint-Christoly-de-Blaye"),33920,1947,1774,69,28.06,-0.483333,45.1333,9,78),
(33,new String'("Sauternes"),33210,732,587,64,11.32,-0.333333,44.5333,13,89),
(33,new String'("Saint-Pardon-de-Conques"),33210,540,393,80,6.68,-0.183333,44.55,0,54),
(33,new String'("Guillos"),33720,412,356,18,22.67,-0.516667,44.55,65,82),
(33,new String'("Le Fieu"),33230,488,373,33,14.67,-0.0336111,45.0595,24,91),
(33,new String'("Marsas"),33620,1092,864,134,8.13,-0.383333,45.0667,27,71),
(33,new String'("Tarnès"),33240,266,254,183,1.45,-0.35,44.9667,4,34),
(33,new String'("Sainte-Foy-la-Grande"),33220,2474,2785,4850,0.51,0.216667,44.8333,7,20),
(33,new String'("Loupes"),33370,655,442,134,4.87,-0.4,44.8,45,105),
(33,new String'("Ruch"),33350,563,504,38,14.49,-0.033333,44.7667,17,110),
(33,new String'("Laroque"),33410,272,230,91,2.97,-0.3,44.65,13,107),
(33,new String'("Coubeyrac"),33890,105,106,18,5.61,0.066667,44.7833,22,113),
(33,new String'("Massugas"),33790,279,258,19,14.41,0.1,44.7667,30,118),
(33,new String'("Saint-Hilaire-du-Bois"),33540,85,92,18,4.5,-0.083333,44.65,34,103),
(33,new String'("Sainte-Eulalie"),33560,4632,4189,511,9.06,-0.483333,44.9167,10,60),
(33,new String'("Saint-Félix-de-Foncaude"),33540,293,256,28,10.33,-0.116667,44.65,25,86),
(33,new String'("Listrac-de-Durèze"),33790,176,113,33,5.31,0.05,44.7667,36,115),
(33,new String'("Montagoudin"),33190,164,145,49,3.34,0.000277778,44.5667,14,111),
(33,new String'("Landerrouat"),33790,182,161,36,4.99,0.15898,44.742,68,126),
(33,new String'("Targon"),33760,1851,1686,71,25.88,-0.266667,44.7333,37,118),
(33,new String'("Léognan"),33850,9309,8267,224,41.43,-0.6,44.7333,13,62),
(33,new String'("Madirac"),33670,184,156,98,1.86,-0.416667,44.7667,37,92),
(33,new String'("Ayguemorte-les-Graves"),33640,933,904,147,6.33,-0.483333,44.7,4,34),
(33,new String'("Talence"),33400,40600,37228,4862,8.35,-0.6,44.8167,9,31),
(33,new String'("Lucmau"),33840,215,209,3,66.73,-0.308333,44.3417,48,126),
(33,new String'("Sadirac"),33670,3501,3026,183,19.11,-0.416667,44.7833,31,112),
(33,new String'("Pessac"),33600,58025,56151,1494,38.82,-0.616667,44.8,12,56),
(33,new String'("Lalande-de-Pomerol"),33500,672,612,81,8.25,-0.209167,44.9556,5,37),
(33,new String'("Marions"),33690,187,171,11,16.32,-0.083333,44.3667,93,146),
(33,new String'("Reignac"),33860,1441,1197,38,37.43,-0.5,45.2333,7,65),
(33,new String'("Castelmoron-d'Albret"),33540,56,62,1400,0.04,-0.016667,44.6667,37,61),
(33,new String'("Saint-Paul"),33390,956,860,87,10.87,-0.6,45.15,17,46),
(33,new String'("Lanton"),33138,6196,4960,45,136.19,-1.03333,44.7,1,54),
(33,new String'("Villeneuve"),33710,391,364,84,4.63,-0.627778,45.0837,1,51),
(33,new String'("Giscos"),33840,202,171,6,32.06,-0.166667,44.2833,75,128),
(33,new String'("Saint-Seurin-de-Bourg"),33710,331,353,134,2.47,-0.566667,45.05,0,86),
(33,new String'("Louchats"),33125,709,540,18,39.24,-0.583333,44.5167,57,86),
(33,new String'("Asques"),33240,490,473,78,6.28,-0.416667,44.95,1,32),
(33,new String'("Izon"),33450,5370,3958,344,15.59,-0.366667,44.9167,1,21),
(33,new String'("Castillon-la-Bataille"),33350,3045,3115,536,5.68,-0.033333,44.85,2,104),
(33,new String'("Roaillan"),33210,1318,842,114,11.48,-0.283333,44.5,17,106),
(33,new String'("Sainte-Terre"),33350,1834,1635,131,13.93,-0.116667,44.8333,2,16),
(33,new String'("Sainte-Croix-du-Mont"),33410,899,842,100,8.98,-0.283333,44.5833,1,118),
(33,new String'("Mérignac"),33700,66142,61990,1373,48.17,-0.633333,44.8333,12,53),
(33,new String'("Pujols-sur-Ciron"),33210,755,721,100,7.53,-0.35,44.5667,8,24),
(33,new String'("Caplong"),33220,225,204,24,9.27,0.15,44.7833,43,118),
(33,new String'("Saint-Vivien-de-Monségur"),33580,385,370,24,15.83,0.116667,44.6167,41,131),
(33,new String'("Saint-Pey-de-Castets"),33350,634,628,57,11.07,-0.066667,44.8167,1,96),
(33,new String'("Saint-Vivien-de-Médoc"),33590,1615,1365,54,29.4,-1.03333,45.4333,0,12),
(33,new String'("Naujan-et-Postiac"),33420,494,501,44,11.1,-0.183333,44.7833,6,91),
(33,new String'("Ligueux"),33220,168,155,33,5.05,0.269444,44.7859,32,125),
(33,new String'("Cazaugitat"),33790,250,223,17,14.35,0.016667,44.7167,45,141),
(33,new String'("Cazalis"),33113,231,179,4,46.81,-0.38,44.342,79,130),
(33,new String'("Saint-Germain-de-Grave"),33490,144,155,23,6.16,-0.221389,44.6256,37,119),
(33,new String'("Cabara"),33420,396,337,115,3.42,-0.166667,44.8167,2,63),
(33,new String'("Bassanne"),33190,91,87,35,2.54,-0.1,44.55,11,45),
(33,new String'("Castets-en-Dorthe"),33210,1211,1123,139,8.69,-0.15,44.5667,6,56),
(33,new String'("Sendets"),33690,328,255,39,8.36,-0.0886111,44.4228,78,144),
(33,new String'("Bourideys"),33113,91,84,1,48.44,-0.45,44.3833,62,101),
(33,new String'("Gaillan-en-Médoc"),33340,2034,1916,48,42.02,-0.95,45.3167,7,20),
(33,new String'("Sillas"),33690,113,105,14,7.63,-0.066667,44.3667,104,141),
(33,new String'("Soussans"),33460,1544,1340,113,13.55,-0.683333,45.05,1,21),
(33,new String'("Soulignac"),33760,450,424,39,11.49,-0.283333,44.6833,34,111),
(33,new String'("Saint-Aignan"),33126,230,252,83,2.75,-0.3,44.95,28,88),
(33,new String'("Puisseguin"),33570,861,926,49,17.25,-0.066667,44.9333,38,108),
(33,new String'("Camblanes-et-Meynac"),33360,2661,2089,306,8.68,-0.5,44.7667,2,80),
(33,new String'("Saint-Yzans-de-Médoc"),33340,397,471,34,11.54,-0.816667,45.3167,1,14),
(33,new String'("Mourens"),33410,387,358,36,10.63,-0.2,44.65,47,116),
(33,new String'("Lugos"),33830,840,559,13,62.14,-0.883333,44.4833,11,49),
(33,new String'("Saint-Genis-du-Bois"),33760,99,75,42,2.34,-0.183333,44.7,42,85),
(33,new String'("Le Taillan-Médoc"),33320,9099,7884,600,15.16,-0.666667,44.9,4,39),
(33,new String'("Saint-Julien-Beychevelle"),33250,679,796,41,16.3,-0.740556,45.1648,0,28),
(33,new String'("Cursan"),33670,504,437,83,6.07,-0.316667,44.8,41,109),
(33,new String'("Cussac-Fort-Médoc"),33460,2000,1352,111,18.01,-0.730833,45.1142,0,29),
(33,new String'("Semens"),33490,207,170,56,3.67,-0.233333,44.6333,33,121),
(33,new String'("Lapouyade"),33620,469,429,18,25.8,-0.283333,45.0833,30,103),
(33,new String'("Lignan-de-Bordeaux"),33360,704,676,78,8.94,-0.433333,44.7833,17,95),
(33,new String'("Gauriac"),33710,853,825,153,5.54,-0.616667,45.0667,0,66),
(33,new String'("Monségur"),33580,1525,1431,153,9.91,0.0808333,44.6503,17,111),
(33,new String'("Cavignac"),33620,1605,1192,242,6.63,-0.383333,45.1,22,77),
(33,new String'("Cadarsac"),33750,300,246,131,2.28,-0.283333,44.85,2,53),
(33,new String'("Moulis-en-Médoc"),33480,1810,1367,88,20.56,-0.766667,45.0667,6,42),
(33,new String'("Cambes"),33880,1346,1145,252,5.34,-0.45,44.7333,2,86),
(33,new String'("Beychac-et-Caillau"),33750,1983,1786,126,15.62,-0.4,44.8833,10,84),
(33,new String'("Saint-Avit-de-Soulège"),33220,75,93,26,2.84,0.125,44.8083,9,99),
(33,new String'("Créon"),33670,4246,2856,529,8.02,-0.35,44.7833,51,109),
(33,new String'("Lerm-et-Musset"),33840,469,400,12,36.87,-0.15,44.3333,64,137),
(33,new String'("Morizès"),33190,532,508,90,5.87,-0.083333,44.6,10,77),
(33,new String'("Paillet"),33550,1193,989,481,2.48,-0.366667,44.6833,4,92),
(33,new String'("Couquèques"),33340,252,209,39,6.33,-0.85,45.35,3,13),
(33,new String'("Saillans"),33141,375,363,60,6.22,-0.266667,44.9667,2,80),
(33,new String'("Floudès"),33190,103,116,27,3.7,-0.066667,44.5667,8,16),
(33,new String'("Sainte-Florence"),33350,126,129,39,3.21,-0.1,44.8,3,82),
(33,new String'("Saint-Martin-Lacaussade"),33390,1018,856,258,3.94,-0.65,45.15,2,39),
(33,new String'("Belvès-de-Castillon"),33350,326,341,49,6.61,-0.016667,44.8667,13,102),
(33,new String'("Berson"),33390,1766,1519,98,17.98,-0.583333,45.1167,12,91),
(33,new String'("Civrac-sur-Dordogne"),33350,233,225,120,1.94,-0.0813889,44.8298,2,10),
(33,new String'("Galgon"),33133,2836,2434,186,15.18,-0.2725,44.9912,2,56),
(33,new String'("Le Tourne"),33550,763,695,301,2.53,-0.4,44.7167,3,82),
(33,new String'("Sainte-Hélène"),33480,2648,1781,20,127.87,-0.883333,44.9667,28,47),
(33,new String'("Cenon"),33150,22242,21283,4029,5.52,-0.533333,44.85,3,75),
(33,new String'("La Rivière"),33126,343,322,106,3.22,-0.316667,44.9333,2,78),
(33,new String'("Mouliets-et-Villemartin"),33350,1094,1009,68,15.91,-0.016667,44.8333,2,93),
(33,new String'("Le Porge"),33680,2488,1504,16,149.03,-1.091,44.8667,0,50),
(33,new String'("Blésignac"),33670,310,249,124,2.5,-0.25,44.7667,33,80),
(33,new String'("Saint-Magne-de-Castillon"),33350,1864,1754,134,13.87,-0.066667,44.8667,1,96),
(33,new String'("Saint-Cibard"),33570,220,192,62,3.54,-0.016667,44.9333,38,108),
(33,new String'("Saint-Aubin-de-Branne"),33420,360,283,65,5.52,-0.166667,44.8,2,88),
(33,new String'("Courpiac"),33760,106,101,47,2.21,-0.183333,44.75,17,72),
(33,new String'("Le Puy"),33580,378,291,46,8.15,0.0730556,44.6612,18,115),
(33,new String'("Saint-Martin-de-Sescas"),33490,524,471,63,8.19,-0.166667,44.5667,5,114),
(33,new String'("Salles"),33770,6158,4489,44,137.98,-0.869444,44.552,7,76),
(33,new String'("Lados"),33124,148,116,22,6.49,-0.15,44.4667,35,130),
(33,new String'("Auros"),33124,916,663,59,15.32,-0.15,44.5,24,113),
(33,new String'("Auriolles"),33790,129,117,18,7.03,0.05,44.7333,41,116),
(33,new String'("Saumos"),33680,556,339,9,57.65,-0.983333,44.9167,21,41),
(33,new String'("Saint-Ferme"),33580,364,338,18,20.09,0.066667,44.6833,30,126),
(33,new String'("Gardegan-et-Tourtirac"),33350,306,282,31,9.58,-0.016667,44.9,12,107),
(33,new String'("Saint-Vincent-de-Paul"),33440,1050,1056,75,13.88,-0.483333,44.9667,1,8),
(33,new String'("Rions"),33410,1581,1441,148,10.65,-0.35,44.65,2,117),
(33,new String'("Arbanats"),33640,1083,821,142,7.6,-0.4,44.6667,2,34),
(33,new String'("Saint-Sulpice-de-Faleyrens"),33330,1485,1572,81,18.17,-0.183333,44.8667,1,20),
(33,new String'("Saint-Brice"),33540,303,297,52,5.76,-0.15,44.6833,48,102),
(33,new String'("Cadillac-en-Fronsadais"),33240,1156,885,303,3.81,-0.366667,44.9667,1,62),
(33,new String'("Bossugan"),33350,47,55,19,2.42,-0.05,44.7833,13,90),
(33,new String'("Saint-Sulpice-de-Guilleragues"),33580,217,227,31,6.89,0.05,44.6292,18,102),
(33,new String'("Saint-Sève"),33190,213,193,44,4.8,-0.033333,44.5833,29,122),
(33,new String'("Le Pian-sur-Garonne"),33490,745,610,117,6.35,-0.216667,44.5833,2,116),
(33,new String'("Lège-Cap-Ferret"),33950,7714,6304,82,93.62,0.853612,44.7931,0,43),
(33,new String'("Saint-Ciers-de-Canesse"),33710,789,718,116,6.8,-0.6,45.0833,5,87),
(33,new String'("Guillac"),33420,183,156,59,3.06,-0.2,44.8,25,87),
(33,new String'("Saint-Aubin-de-Blaye"),33820,783,687,67,11.54,-0.566667,45.2667,2,37),
(33,new String'("Saint-André-de-Cubzac"),33240,9594,7235,414,23.15,-0.441667,44.9917,2,73),
(33,new String'("Saint-Pierre-d'Aurillac"),33490,1313,1088,201,6.52,-0.183333,44.5667,0,115),
(33,new String'("Saint-Martin-du-Puy"),33540,200,228,21,9.1,-0.033333,44.6667,27,98),
(33,new String'("Balizac"),33730,451,318,10,41.78,-0.433333,44.4833,18,64),
(33,new String'("Étauliers"),33820,1660,1394,127,12.98,-0.566667,45.2167,1,23),
(33,new String'("Portets"),33640,2407,1999,155,15.49,-0.416667,44.7,2,37),
(33,new String'("Barsac"),33720,2141,1949,147,14.48,-0.316667,44.6167,3,21),
(33,new String'("Le Temple"),33680,524,498,7,71.83,-0.983333,44.8833,29,47),
(33,new String'("Podensac"),33720,2645,2266,317,8.34,-0.35,44.65,2,25),
(33,new String'("Laruscade"),33620,2358,1703,50,46.76,-0.333333,45.1167,18,106),
(33,new String'("Brach"),33480,501,235,17,28.61,-0.933333,45.05,27,39),
(33,new String'("Ludon-Médoc"),33290,4160,3326,222,18.69,-0.6,44.9833,0,16),
(33,new String'("Saint-Denis-de-Pile"),33910,5170,4080,182,28.27,-0.2,45.0,2,49),
(33,new String'("Sainte-Radegonde"),33350,459,438,36,12.48,-0.025,44.8417,9,118),
(33,new String'("Montagne"),33570,1619,1585,60,26.66,-0.133333,44.9333,18,97),
(33,new String'("Peintures"),33230,1587,1194,120,13.13,-0.1,45.0667,5,31),
(33,new String'("Brouqueyran"),33124,207,148,36,5.66,-0.183333,44.4833,30,114),
(33,new String'("Saint-Antoine"),33240,409,285,2044,0.2,-0.416667,45.0167,36,47),
(33,new String'("Cadaujac"),33140,4816,4404,314,15.33,-0.533333,44.75,3,36),
(34,new String'("Mauguio"),34130,16307,14846,329,49.56,4.01667,43.6167,0,51),
(34,new String'("Saint-Jean-de-Fos"),34150,1533,1162,108,14.19,3.55,43.7,30,528),
(34,new String'("Pérols"),34470,8509,7738,1415,6.01,3.95,43.5667,0,12),
(34,new String'("Félines-Minervois"),34210,428,389,14,29.87,2.6,43.3333,143,922),
(34,new String'("Montady"),34310,3959,2534,397,9.95,3.11667,43.3333,10,113),
(34,new String'("Olargues"),34390,627,571,33,18.6,2.91667,43.55,148,760),
(34,new String'("Lunas"),34650,651,639,14,44.89,3.2,43.7,234,768),
(34,new String'("Beaufort"),34210,189,155,31,6.09,2.76667,43.3,53,220),
(34,new String'("Bessan"),34550,4585,4027,165,27.65,3.41667,43.3667,0,84),
(34,new String'("Villetelle"),34400,1399,923,263,5.31,4.15,43.7333,10,67),
(34,new String'("Saint-Sériès"),34400,887,583,194,4.56,4.1,43.7333,14,68),
(34,new String'("Soubès"),34700,889,710,71,12.35,3.35,43.7667,190,733),
(34,new String'("Castelnau-le-Lez"),34170,14948,14208,1337,11.18,3.9,43.6333,19,93),
(34,new String'("Saint-Félix-de-Lodez"),34725,1142,739,260,4.38,3.45,43.65,69,132),
(34,new String'("Plans"),34700,292,265,16,18.12,3.28333,43.75,186,845),
(34,new String'("Valmascle"),34800,46,41,6,6.99,3.3,43.6,190,448),
(34,new String'("Fabrègues"),34690,6236,5901,198,31.46,3.76667,43.55,7,220),
(34,new String'("Baillargues"),34670,6206,5836,808,7.68,4.01667,43.6667,13,57),
(34,new String'("Ganges"),34190,4083,3503,570,7.16,3.7,43.9333,138,540),
(34,new String'("Tressan"),34230,539,402,137,3.92,3.5,43.5667,17,100),
(34,new String'("Ceyras"),34800,1100,725,158,6.96,3.45834,43.6442,39,152),
(34,new String'("Montoulieu"),34190,153,115,9,16.1,3.8,43.9333,159,522),
(34,new String'("Alignan-du-Vent"),34290,1575,1135,91,17.3,3.35,43.4667,32,120),
(34,new String'("Vieussan"),34390,274,217,9,28.26,2.98333,43.5333,84,733),
(34,new String'("Ferrières-les-Verreries"),34190,63,38,3,17.42,3.8,43.8833,206,421),
(34,new String'("Florensac"),34510,4882,3863,136,35.71,3.45,43.3833,1,90),
(34,new String'("Usclas-du-Bosc"),34700,126,67,27,4.51,3.4,43.7167,160,445),
(34,new String'("Villeveyrac"),34560,3164,2208,85,37.12,3.6,43.5,12,255),
(34,new String'("Campagne"),34160,271,235,55,4.84,4.03333,43.7833,35,86),
(34,new String'("Boisseron"),34160,1719,1150,230,7.46,4.08333,43.75,19,77),
(34,new String'("Balaruc-le-Vieux"),34540,2069,1796,349,5.92,3.68333,43.45,0,196),
(34,new String'("Saint-Étienne-de-Gourgas"),34700,450,309,23,19.43,3.38333,43.7667,240,762),
(34,new String'("Riols"),34220,750,690,13,56.02,2.78333,43.5,253,1060),
(34,new String'("Combaillaux"),34980,1430,1285,157,9.06,3.75,43.6667,64,275),
(34,new String'("Marsillargues"),34590,6088,5327,142,42.71,4.18333,43.6667,0,11),
(34,new String'("Viols-en-Laval"),34380,210,177,13,16.03,3.72556,43.7525,186,320),
(34,new String'("Péret"),34800,887,560,80,10.97,3.41667,43.5833,74,334),
(34,new String'("Saint-Vincent-de-Barbeyrargues"),34730,689,569,307,2.24,3.87723,43.7062,65,161),
(34,new String'("Ceilhes-et-Rocozels"),34260,307,256,11,27.82,3.1,43.8,426,821),
(34,new String'("Valros"),34290,1330,1133,201,6.61,3.36667,43.4167,24,99),
(34,new String'("Avène"),34260,305,276,4,62.65,3.1,43.75,294,978),
(34,new String'("Galargues"),34160,651,519,56,11.43,4.01667,43.7667,29,257),
(34,new String'("Beaulieu"),34160,1698,1399,219,7.73,4.01667,43.7333,47,105),
(34,new String'("La Vacquerie-et-Saint-Martin-de-Castries"),34520,152,118,3,43.05,3.45,43.7833,573,822),
(34,new String'("Montblanc"),34290,2594,2137,96,26.94,3.36667,43.4,8,68),
(34,new String'("Viols-le-Fort"),34380,1157,851,69,16.73,3.7,43.75,157,535),
(34,new String'("Saussines"),34160,951,776,151,6.28,4.05723,43.7634,24,76),
(34,new String'("Bédarieux"),34600,6453,5966,231,27.82,3.15,43.6167,184,520),
(34,new String'("Montferrier-sur-Lez"),34980,3385,3295,439,7.7,3.85,43.6667,36,149),
(34,new String'("Brignac"),34800,714,346,153,4.65,3.46667,43.6167,21,69),
(34,new String'("Saint-Paul-et-Valmalle"),34570,1020,756,80,12.72,3.66667,43.6333,110,341),
(34,new String'("Murviel-lès-Béziers"),34490,2840,2390,87,32.36,3.14417,43.4406,19,220),
(34,new String'("La Livinière"),34210,546,589,17,31.56,2.63333,43.3167,90,598),
(34,new String'("Lavalette"),34700,57,37,6,8.54,3.26667,43.7,201,685),
(34,new String'("Restinclières"),34160,1554,1162,237,6.53,4.03333,43.7167,47,101),
(34,new String'("Autignac"),34480,852,730,73,11.55,3.16667,43.5,79,205),
(34,new String'("Puéchabon"),34150,458,347,14,31.26,3.61667,43.7167,54,483),
(34,new String'("Fontès"),34320,955,788,53,17.7,3.36667,43.5333,38,235),
(34,new String'("Fos"),34320,120,96,18,6.58,3.25,43.5667,171,464),
(34,new String'("Prémian"),34390,544,406,32,16.69,2.83333,43.5333,218,1111),
(34,new String'("Sauteyrargues"),34270,354,299,27,12.76,3.91667,43.8333,104,290),
(34,new String'("Camplong"),34260,241,187,18,13.25,3.13333,43.6667,264,882),
(34,new String'("Mourèze"),34800,175,131,13,13.44,3.36667,43.6167,160,537),
(34,new String'("Aigues-Vives"),34210,429,352,33,12.81,2.81667,43.3333,90,251),
(34,new String'("Roujan"),34320,1931,1476,113,17.02,3.3,43.5167,49,246),
(34,new String'("Lattes"),34970,15927,13760,572,27.83,3.9,43.5667,0,25),
(34,new String'("Oupia"),34210,285,209,31,9.04,2.76667,43.2833,50,295),
(34,new String'("Brenas"),34650,47,25,4,10.59,3.25,43.65,188,625),
(34,new String'("Espondeilhan"),34290,970,625,190,5.08,3.26667,43.4333,60,123),
(34,new String'("Vendémian"),34230,1065,793,63,16.89,3.56667,43.5833,57,282),
(34,new String'("Mons"),34390,581,507,26,22.32,2.95556,43.5714,117,1054),
(34,new String'("Faugères"),34600,551,435,21,26.06,3.18333,43.5667,170,544),
(34,new String'("Saint-Chinian"),34360,1829,1776,78,23.29,2.95,43.4167,101,631),
(34,new String'("Caussiniojouls"),34600,128,118,12,10.5,3.15,43.55,178,547),
(34,new String'("Bassan"),34290,1667,1454,245,6.79,3.25,43.4,53,102),
(34,new String'("Saint-Aunès"),34130,3041,2825,246,12.32,3.96667,43.6333,13,60),
(34,new String'("Lignan-sur-Orb"),34490,2897,2838,849,3.41,3.18333,43.3833,9,86),
(34,new String'("Saint-Georges-d'Orques"),34680,5343,4395,573,9.31,3.78333,43.6167,45,183),
(34,new String'("Minerve"),34210,130,111,4,27.89,2.75,43.35,137,604),
(34,new String'("Hérépian"),34600,1474,1367,168,8.77,3.11667,43.6,178,520),
(34,new String'("Quarante"),34310,1609,1449,53,30.05,2.96667,43.35,21,227),
(34,new String'("Tourbes"),34120,1521,1276,95,15.96,3.38333,43.45,11,103),
(34,new String'("Neffiès"),34320,993,699,90,10.92,3.33333,43.5333,74,327),
(34,new String'("Puilacher"),34230,364,156,135,2.68,3.5,43.5667,27,99),
(34,new String'("Lunel-Viel"),34400,3706,3176,309,11.97,4.08333,43.6833,6,50),
(34,new String'("Laurens"),34480,1436,936,87,16.39,3.2,43.5167,117,228),
(34,new String'("Montouliers"),34310,238,201,30,7.7,2.9,43.3333,43,223),
(34,new String'("Lézignan-la-Cèbe"),34120,1429,1017,233,6.13,3.43333,43.5,7,91),
(34,new String'("Cruzy"),34310,971,833,37,25.85,2.95,43.35,21,263),
(34,new String'("Cassagnoles"),34210,92,78,3,24.54,2.61667,43.3833,280,1005),
(34,new String'("La Salvetat-sur-Agout"),34330,1178,1122,13,87.55,2.70334,43.6009,663,1087),
(34,new String'("Saint-Michel"),34520,57,44,2,25.4,3.38333,43.85,647,861),
(34,new String'("Agde"),34300,24567,20066,483,50.81,3.46667,43.3167,0,110),
(34,new String'("Vic-la-Gardiole"),34110,2855,2460,154,18.49,3.8,43.4833,0,216),
(34,new String'("Cessenon-sur-Orb"),34460,2066,1734,55,37.29,3.05139,43.45,29,254),
(34,new String'("Ferrals-les-Montagnes"),34210,144,141,5,25.78,2.63333,43.4,358,887),
(34,new String'("Roqueredonde"),34650,245,138,10,22.71,3.21667,43.8,453,853),
(34,new String'("Béziers"),34500,70955,69359,743,95.48,3.25,43.35,4,120),
(34,new String'("Saint-Félix-de-l'Héras"),34520,35,29,2,12.92,3.3,43.8333,600,824),
(34,new String'("Salasc"),34800,276,189,30,9.0,3.31667,43.6167,136,489),
(34,new String'("Puisserguier"),34620,2853,2483,100,28.27,3.03333,43.3667,39,205),
(34,new String'("Causses-et-Veyran"),34490,633,546,35,17.65,3.08333,43.4667,33,403),
(34,new String'("Puimisson"),34480,1003,790,157,6.38,3.2,43.4333,65,137),
(34,new String'("Balaruc-les-Bains"),34540,6868,5683,793,8.66,3.66667,43.4333,0,169),
(34,new String'("Saint-Christol"),34400,1441,1216,127,11.29,4.08333,43.7333,24,92),
(34,new String'("Ferrières-Poussarou"),34360,66,49,2,26.01,2.88333,43.4833,203,728),
(34,new String'("Le Triadou"),34270,403,326,63,6.3,3.86667,43.7333,63,142),
(34,new String'("Corneilhan"),34490,1596,1537,112,14.23,3.18333,43.4,27,133),
(34,new String'("Mérifons"),34800,48,26,7,6.74,3.28333,43.6333,157,452),
(34,new String'("Thézan-lès-Béziers"),34490,2667,2076,195,13.65,3.16667,43.4167,15,132),
(34,new String'("Lansargues"),34130,2744,2491,149,18.39,4.06667,43.65,0,16),
(34,new String'("Joncels"),34650,294,227,6,46.24,3.18333,43.7333,290,835),
(34,new String'("Canet"),34800,3315,1601,452,7.33,3.5,43.6,23,57),
(34,new String'("Pomérols"),34810,2177,1691,197,11.01,3.5,43.4,1,68),
(34,new String'("Cazouls-d'Hérault"),34120,329,272,74,4.39,3.46667,43.4833,9,31),
(34,new String'("Saint-Pons-de-Thomières"),34220,2062,2288,50,40.99,2.76028,43.4887,273,1026),
(34,new String'("Saussan"),34570,1482,1444,411,3.6,3.8,43.5833,13,53),
(34,new String'("Mèze"),34140,10523,7636,304,34.59,3.6,43.4167,0,75),
(34,new String'("Cabrières"),34800,478,338,16,29.02,3.36667,43.5833,76,481),
(34,new String'("Azillanet"),34210,420,372,29,14.4,2.75,43.3167,62,279),
(34,new String'("Gabian"),34320,820,661,51,15.96,3.26667,43.5,82,260),
(34,new String'("Olmet-et-Villecun"),34700,146,113,15,9.55,3.31667,43.7167,120,600),
(34,new String'("Sète"),34200,42774,39579,1766,24.21,3.68333,43.4,0,176),
(34,new String'("Capestang"),34310,3033,3006,76,39.56,3.03333,43.3333,0,120),
(34,new String'("Saint-Guilhem-le-Désert"),34150,269,245,6,38.64,3.55,43.7333,54,812),
(34,new String'("Le Soulié"),34330,114,121,2,40.44,2.71667,43.55,816,1069),
(34,new String'("Agonès"),34190,241,179,57,4.16,3.75,43.9167,119,323),
(34,new String'("Pégairolles-de-Buèges"),34380,49,54,3,13.35,3.58333,43.8,160,780),
(34,new String'("Pardailhan"),34360,184,160,4,41.18,2.85,43.45,275,820),
(34,new String'("Magalas"),34480,2977,1824,143,20.76,3.21667,43.4667,77,201),
(34,new String'("Vacquières"),34270,427,291,28,14.74,3.94445,43.8439,85,206),
(34,new String'("Saint-Thibéry"),34630,2344,2204,126,18.47,3.41667,43.4,0,80),
(34,new String'("Servian"),34290,4193,3352,103,40.61,3.3,43.4167,19,103),
(34,new String'("Poilhes"),34310,554,508,93,5.95,3.08333,43.3167,0,115),
(34,new String'("Saint-André-de-Buèges"),34190,55,58,3,15.26,3.66306,43.8487,119,940),
(34,new String'("Castanet-le-Haut"),34610,187,167,6,27.55,2.96667,43.6667,389,1124),
(34,new String'("Saint-Hilaire-de-Beauvoir"),34160,365,273,77,4.69,4.01667,43.75,39,86),
(34,new String'("Pézènes-les-Mines"),34600,244,172,9,26.87,3.25,43.5833,194,501),
(34,new String'("Pailhès"),34490,470,467,78,6.0,3.18333,43.4333,58,147),
(34,new String'("Bélarga"),34230,445,259,107,4.13,3.48333,43.55,17,84),
(34,new String'("Saint-Julien"),34390,207,191,10,19.25,2.91667,43.5667,148,1090),
(34,new String'("Poujols"),34700,152,125,53,2.86,3.33333,43.7667,192,652),
(34,new String'("Saint-Jean-de-Védas"),34430,8716,8041,676,12.89,3.83333,43.5833,4,65),
(34,new String'("Liausson"),34800,156,110,19,7.95,3.38333,43.6333,135,537),
(34,new String'("Saint-Nazaire-de-Ladarez"),34490,343,332,12,28.27,3.08333,43.5,110,690),
(34,new String'("Combes"),34240,329,267,29,10.97,3.06667,43.6,200,783),
(34,new String'("Saint-Bauzille-de-Montmel"),34160,940,733,43,21.52,3.95,43.7667,62,320),
(34,new String'("Roquessels"),34320,123,123,13,8.98,3.21667,43.55,138,440),
(34,new String'("Saint-Guiraud"),34725,211,185,34,6.07,3.45,43.6833,69,289),
(34,new String'("Adissan"),34230,966,732,216,4.46,3.43333,43.5333,30,105),
(34,new String'("Celles"),34800,23,20,3,7.56,3.35,43.6667,89,350),
(34,new String'("Lieuran-lès-Béziers"),34290,1362,929,160,8.51,3.23333,43.4167,46,103),
(34,new String'("Saint-Pargoire"),34230,2053,1358,86,23.77,3.51667,43.5333,18,221),
(34,new String'("Pégairolles-de-l'Escalette"),34700,145,137,4,32.13,3.32278,43.8028,223,822),
(34,new String'("Murviel-lès-Montpellier"),34570,1911,1208,189,10.11,3.73333,43.6167,66,236),
(34,new String'("Lodève"),34700,7512,6905,324,23.17,3.31667,43.7167,117,700),
(34,new String'("Laroque"),34190,1479,1130,223,6.63,3.73333,43.9167,124,490),
(34,new String'("Saint-Jean-de-Buèges"),34380,206,184,12,16.9,3.61667,43.8333,144,806),
(34,new String'("Saint-Étienne-d'Albagnan"),34390,301,271,13,22.7,2.85,43.5333,207,1102),
(34,new String'("Nissan-lez-Enserune"),34440,3652,2906,122,29.74,3.13333,43.2833,0,122),
(34,new String'("Vérargues"),34400,709,446,128,5.51,4.1,43.7167,15,65),
(34,new String'("Villemagne-l'Argentière"),34600,424,430,52,8.06,3.11945,43.6178,187,481),
(34,new String'("Pinet"),34850,1402,990,158,8.83,3.51667,43.4,5,68),
(34,new String'("Saint-Clément-de-Rivière"),34980,4987,4579,391,12.73,3.84639,43.6837,46,146),
(34,new String'("Rosis"),34610,304,262,5,52.91,3.0,43.6167,272,1123),
(34,new String'("Aires"),34600,572,546,27,20.54,3.11667,43.5833,149,640),
(34,new String'("Margon"),34320,550,244,123,4.47,3.31667,43.4833,57,125),
(34,new String'("Jacou"),34830,4902,4752,1429,3.43,3.9,43.6667,45,85),
(34,new String'("Clapiers"),34830,5200,4627,676,7.69,3.88333,43.65,25,126),
(34,new String'("Pierrerue"),34360,287,264,24,11.7,2.96667,43.4333,90,683),
(34,new String'("Saint-Étienne-Estréchoux"),34260,244,261,68,3.58,3.08333,43.6667,255,594),
(34,new String'("Paulhan"),34230,3648,2663,323,11.26,3.45,43.5333,18,83),
(34,new String'("Vendres"),34350,2199,1553,58,37.8,3.21667,43.2667,0,64),
(34,new String'("Graissessac"),34260,708,633,70,10.03,3.08333,43.6667,270,1001),
(34,new String'("Nébian"),34800,1233,1023,125,9.79,3.43333,43.6,39,289),
(34,new String'("Notre-Dame-de-Londres"),34380,479,398,17,28.15,3.78333,43.8167,126,426),
(34,new String'("Pézenas"),34120,8251,7464,279,29.56,3.41667,43.45,3,96),
(34,new String'("Siran"),34210,683,568,32,21.25,2.66667,43.3167,77,491),
(34,new String'("Villespassans"),34360,147,128,10,14.07,2.9,43.3833,138,321),
(34,new String'("Saint-Bauzille-de-la-Sylve"),34230,830,723,96,8.63,3.55,43.6167,68,247),
(34,new String'("Gignac"),34150,5447,3955,182,29.85,3.55,43.65,28,286),
(34,new String'("Saint-Drézéry"),34160,2156,1755,205,10.47,3.98333,43.7333,60,145),
(34,new String'("Babeau-Bouldoux"),34360,293,242,13,21.4,2.9,43.4333,153,681),
(34,new String'("Saint-Jean-de-la-Blaquière"),34700,569,361,33,17.22,3.41667,43.7,85,557),
(34,new String'("Saint-Gély-du-Fesc"),34980,8821,7629,534,16.51,3.8,43.7,71,264),
(34,new String'("Valergues"),34130,2017,1737,387,5.2,4.06667,43.6667,9,41),
(34,new String'("Puissalicon"),34480,1117,908,85,13.05,3.23333,43.45,66,142),
(34,new String'("Cazevieille"),34270,184,119,11,16.21,3.8,43.7667,160,641),
(34,new String'("Montarnaud"),34570,2524,2348,91,27.53,3.7,43.65,105,319),
(34,new String'("Cambon-et-Salvergues"),34330,61,74,1,50.39,2.86667,43.6167,511,1152),
(34,new String'("Sauvian"),34410,4153,3562,317,13.07,3.26667,43.3,3,41),
(34,new String'("Saint-Vincent-d'Olargues"),34390,325,322,20,15.84,2.87917,43.5606,180,1085),
(34,new String'("Sussargues"),34160,2567,2130,396,6.48,4.0,43.7,35,126),
(34,new String'("Poussan"),34560,5224,4037,173,30.08,3.66667,43.4833,0,286),
(34,new String'("Lauret"),34270,563,426,84,6.67,3.88333,43.8333,125,400),
(34,new String'("Assignan"),34360,180,168,22,7.95,2.88333,43.4,173,408),
(34,new String'("Saint-Nazaire-de-Pézan"),34400,576,539,101,5.66,4.13333,43.6333,0,5),
(34,new String'("Cébazan"),34360,548,346,42,13.03,2.98333,43.4,112,268),
(34,new String'("Valflaunès"),34270,709,651,33,21.04,3.86667,43.8,109,640),
(34,new String'("Montels"),34310,246,168,33,7.3,3.03333,43.3,0,24),
(34,new String'("Saint-Geniès-des-Mourgues"),34160,1692,1509,148,11.37,4.03333,43.7,23,90),
(34,new String'("Villeneuvette"),34800,63,85,20,3.14,3.41667,43.6167,116,317),
(34,new String'("Lavérune"),34880,2735,2610,380,7.18,3.83333,43.5833,17,72),
(34,new String'("Brissac"),34190,618,442,14,44.13,3.7,43.8667,99,772),
(34,new String'("Carlencas-et-Levas"),34600,124,88,11,10.78,3.23333,43.6333,277,491),
(34,new String'("Guzargues"),34820,477,345,40,11.73,3.91667,43.7167,80,209),
(34,new String'("Coulobres"),34290,354,230,118,2.99,3.28333,43.45,55,120),
(34,new String'("Fozières"),34700,182,166,33,5.43,3.35,43.75,171,680),
(34,new String'("Maureilhan"),34370,1893,1430,179,10.55,3.12,43.3573,34,85),
(34,new String'("Cournonsec"),34660,2389,1965,198,12.06,3.71667,43.55,34,156),
(34,new String'("Pignan"),34570,6366,5667,313,20.32,3.76667,43.5833,29,218),
(34,new String'("Aigne"),34210,265,234,24,10.94,2.81667,43.3333,79,273),
(34,new String'("Boujan-sur-Libron"),34760,3121,2610,444,7.02,3.25,43.3667,34,106),
(34,new String'("Cazouls-lès-Béziers"),34370,4461,3343,115,38.46,3.1,43.3833,16,204),
(34,new String'("Portiragnes"),34420,3160,2281,156,20.16,3.33333,43.3,0,41),
(34,new String'("Saint-Bauzille-de-Putois"),34190,1593,1141,87,18.16,3.73333,43.9,118,483),
(34,new String'("Arboras"),34150,99,74,14,6.73,3.48333,43.7167,137,702),
(34,new String'("Rouet"),34380,58,46,2,24.77,3.81306,43.812,179,500),
(34,new String'("Jonquières"),34725,391,355,190,2.05,3.46667,43.6833,94,126),
(34,new String'("Saint-Privat"),34700,405,218,15,26.9,3.41667,43.75,197,782),
(34,new String'("Argelliers"),34380,890,722,17,50.29,3.68333,43.7,80,531),
(34,new String'("Saint-Geniès-de-Varensal"),34610,190,208,15,12.55,3.0,43.6667,358,1086),
(34,new String'("Mas-de-Londres"),34380,482,276,25,19.06,3.75,43.7833,167,400),
(34,new String'("Castries"),34160,5752,5140,239,24.05,3.98333,43.6667,20,154),
(34,new String'("Montbazin"),34560,2968,2213,140,21.13,3.68333,43.5167,16,313),
(34,new String'("Soumont"),34700,160,135,14,11.04,3.36667,43.7333,130,542),
(34,new String'("Frontignan"),34110,22526,19130,710,31.72,3.75,43.45,0,223),
(34,new String'("Marseillan"),34340,7883,6198,152,51.71,3.53333,43.35,0,33),
(34,new String'("Saint-Maurice-Navacelles"),34520,156,142,2,68.6,3.5,43.8333,219,800),
(34,new String'("Le Crès"),34920,8005,6799,1370,5.84,3.93333,43.65,29,83),
(34,new String'("Montpellier"),34000,257351,225511,4524,56.88,3.88333,43.6,7,121),
(34,new String'("Aumelas"),34230,489,380,8,58.26,3.59861,43.6028,64,341),
(34,new String'("Plaissan"),34230,899,642,155,5.79,3.53333,43.55,35,165),
(34,new String'("Usclas-d'Hérault"),34230,296,144,104,2.82,3.46417,43.5187,18,30),
(34,new String'("Saint-Brès"),34670,2659,2477,547,4.86,4.025,43.6667,13,41),
(34,new String'("Villeneuve-lès-Béziers"),34420,3986,3431,230,17.31,3.26667,43.3167,2,51),
(34,new String'("Matelles"),34270,1677,1429,99,16.81,3.81667,43.7333,60,300),
(34,new String'("Garrigues"),34160,167,127,33,4.92,4.01667,43.8,58,221),
(34,new String'("Villeneuve-lès-Maguelone"),34750,9141,7341,402,22.7,3.86084,43.5323,0,130),
(34,new String'("Saint-Jean-de-Minervois"),34360,143,115,4,32.7,2.83333,43.3833,159,778),
(34,new String'("Saint-Gervais-sur-Mare"),34610,861,798,35,24.29,3.03333,43.65,280,940),
(34,new String'("Sérignan"),34410,6685,6120,243,27.45,3.28333,43.2833,0,24),
(34,new String'("Verreries-de-Moussans"),34220,94,104,5,18.69,2.7,43.45,404,849),
(34,new String'("Vendargues"),34740,5579,5222,621,8.98,3.96667,43.65,25,86),
(34,new String'("Vailhauquès"),34570,2366,1900,146,16.12,3.71667,43.6667,80,303),
(34,new String'("Saint-Pierre-de-la-Fage"),34520,113,88,6,18.6,3.41667,43.7833,360,780),
(34,new String'("Lagamas"),34150,114,112,25,4.52,3.51667,43.6667,33,142),
(34,new String'("Aniane"),34150,2773,2099,91,30.34,3.58333,43.6833,36,367),
(34,new String'("Maraussan"),34370,3757,2786,303,12.37,3.15,43.3667,8,92),
(34,new String'("La Tour-sur-Orb"),34260,1229,1052,40,30.65,3.15,43.65,204,745),
(34,new String'("Claret"),34270,1389,1069,49,28.27,3.9,43.8667,135,410),
(34,new String'("Fraisse-sur-Agout"),34330,346,323,5,58.46,2.81667,43.6,435,1111),
(34,new String'("Octon"),34800,453,399,20,21.81,3.3,43.65,134,700),
(34,new String'("Loupian"),34140,2092,1486,130,16.0,3.61667,43.45,0,170),
(34,new String'("Cournonterral"),34660,5939,5070,207,28.62,3.71667,43.55,29,320),
(34,new String'("Lunel"),34400,25277,22346,1057,23.9,4.13333,43.6833,2,53),
(34,new String'("Dio-et-Valquières"),34650,152,134,8,18.77,3.2,43.6667,256,701),
(34,new String'("Saint-Just"),34400,2851,2493,468,6.08,4.11667,43.65,2,9),
(34,new String'("Grabels"),34790,6393,5438,393,16.24,3.78333,43.65,50,167),
(34,new String'("Fouzilhon"),34480,219,146,40,5.39,3.25,43.5,134,214),
(34,new String'("Caux"),34720,2509,1976,101,24.84,3.36667,43.5,27,166),
(34,new String'("Berlou"),34360,191,184,16,11.34,2.95,43.4833,130,680),
(34,new String'("Aspiran"),34800,1446,1167,89,16.13,3.43333,43.5667,17,160),
(34,new String'("Courniou"),34220,607,603,20,30.06,2.73333,43.4667,329,951),
(34,new String'("Saint-Pons-de-Mauchiens"),34230,656,513,48,13.58,3.51667,43.5167,18,185),
(34,new String'("Montaud"),34160,906,617,70,12.92,3.95,43.75,51,210),
(34,new String'("La Grande-Motte"),34280,8440,6466,797,10.58,4.08333,43.5667,0,3),
(34,new String'("Le Puech"),34700,225,189,14,15.86,3.31667,43.7,98,385),
(34,new String'("Colombiers"),34440,2335,2063,230,10.14,3.13333,43.3167,21,100),
(34,new String'("Pouzols"),34230,842,630,284,2.96,3.5,43.6167,27,100),
(34,new String'("Cazedarnes"),34460,534,397,45,11.64,3.03333,43.4167,98,251),
(34,new String'("Sainte-Croix-de-Quintillargues"),34270,606,532,91,6.62,3.90917,43.7725,104,321),
(34,new String'("Le Pradal"),34600,280,191,73,3.8,3.11667,43.6333,236,662),
(34,new String'("Assas"),34820,1529,1310,80,19.11,3.88333,43.7,59,164),
(34,new String'("Castelnau-de-Guers"),34120,1123,889,49,22.51,3.43333,43.4333,1,105),
(34,new String'("Agel"),34210,219,167,17,12.54,2.85,43.3333,70,257),
(34,new String'("Pouzolles"),34480,1060,781,105,10.01,3.26667,43.4833,48,180),
(34,new String'("Moulès-et-Baucels"),34190,850,598,37,22.78,3.71667,43.95,156,727),
(34,new String'("Colombières-sur-Orb"),34390,471,417,58,8.11,3.01028,43.5803,132,1008),
(34,new String'("Taussac-la-Billière"),34600,474,353,32,14.62,3.1,43.6167,199,700),
(34,new String'("Gorniès"),34190,112,121,3,29.31,3.63333,43.9,176,940),
(34,new String'("Saint-Mathieu-de-Tréviers"),34270,4686,3713,213,21.92,3.85,43.7667,78,400),
(34,new String'("Cers"),34420,2191,1802,279,7.85,3.3,43.3167,3,48),
(34,new String'("Montpeyroux"),34150,1227,1087,54,22.42,3.5,43.6833,66,841),
(34,new String'("Saint-Geniès-de-Fontedit"),34480,1389,1083,150,9.24,3.17889,43.4684,58,150),
(34,new String'("Popian"),34230,360,248,61,5.86,3.53333,43.6167,47,130),
(34,new String'("Murles"),34980,294,233,12,24.06,3.76667,43.6833,80,298),
(34,new String'("Lacoste"),34800,295,248,39,7.46,3.43333,43.65,40,266),
(34,new String'("Vias"),34450,5354,4327,164,32.49,3.41667,43.3,0,33),
(34,new String'("Lamalou-les-Bains"),34240,2438,2157,394,6.18,3.06667,43.6,175,458),
(34,new String'("Juvignac"),34990,7466,5587,689,10.83,3.8,43.6167,27,150),
(34,new String'("Cazilhac"),34190,1310,1163,112,11.69,3.7,43.925,132,523),
(34,new String'("Vailhan"),34320,169,120,15,11.23,3.3,43.55,93,460),
(34,new String'("Le Caylar"),34520,442,383,20,22.08,3.3,43.85,714,826),
(34,new String'("Prades-sur-Vernazobre"),34360,279,236,13,19.98,2.98333,43.45,64,663),
(34,new String'("Montagnac"),34530,3593,2983,90,39.81,3.48333,43.4833,8,172),
(34,new String'("Fontanès"),34270,282,202,34,8.18,3.91445,43.7945,88,241),
(34,new String'("Buzignargues"),34160,261,199,56,4.61,4.0,43.7667,40,133),
(34,new String'("Lespignan"),34710,3120,2570,136,22.92,3.16667,43.2667,0,90),
(34,new String'("Nézignan-l'Évêque"),34120,1520,957,351,4.33,3.41667,43.4167,7,74),
(34,new String'("Le Bosc"),34700,1210,740,43,28.13,3.38333,43.7167,56,432),
(34,new String'("Rives"),34520,121,127,5,23.79,3.26667,43.8333,640,853),
(34,new String'("Saint-Saturnin-de-Lucian"),34725,308,229,31,9.83,3.47084,43.6942,118,720),
(34,new String'("Le Bousquet-d'Orb"),34260,1604,1484,135,11.83,3.16667,43.7,236,787),
(34,new String'("Olonzac"),34210,1683,1566,88,18.95,2.73333,43.2667,29,182),
(34,new String'("La Boissière"),34150,917,719,37,24.45,3.65,43.6667,136,367),
(34,new String'("Creissan"),34370,1295,934,145,8.89,3.01667,43.3667,73,201),
(34,new String'("Mudaison"),34130,2498,2262,308,8.1,4.03945,43.6464,4,21),
(34,new String'("Roquebrun"),34460,554,579,13,39.64,3.01667,43.5,56,731),
(34,new String'("Mireval"),34110,3275,3051,296,11.05,3.8,43.5,0,196),
(34,new String'("Aumes"),34530,440,310,59,7.39,3.46667,43.4667,6,106),
(34,new String'("Campagnan"),34230,550,393,146,3.75,3.48333,43.5333,18,123),
(34,new String'("Cesseras"),34210,372,400,24,15.07,2.71667,43.3333,54,417),
(34,new String'("Cabrerolles"),34480,363,269,12,28.68,3.13333,43.5333,134,705),
(34,new String'("Candillargues"),34130,1401,1143,170,8.23,4.06667,43.6167,0,7),
(34,new String'("Saint-André-de-Sangonis"),34725,5319,3788,271,19.6,3.5,43.65,26,122),
(34,new String'("Le Pouget"),34230,1819,1350,130,13.91,3.51667,43.5833,25,161),
(34,new String'("Clermont-l'Hérault"),34800,8018,6531,246,32.49,3.43333,43.6167,40,322),
(34,new String'("Vélieux"),34220,62,50,6,10.15,2.75,43.3833,213,675),
(34,new String'("Lieuran-Cabrières"),34800,279,182,45,6.13,3.43333,43.5833,77,323),
(34,new String'("Rieussec"),34220,91,76,4,22.2,2.75,43.4167,314,860),
(34,new String'("Le Poujol-sur-Orb"),34600,1024,898,223,4.58,3.05,43.5833,162,380),
(34,new String'("Causse-de-la-Selle"),34380,337,291,7,45.19,3.65,43.8,68,640),
(34,new String'("Boisset"),34220,26,30,1,17.47,2.70417,43.4017,257,794),
(34,new String'("Romiguières"),34650,27,15,7,3.45,3.23333,43.8167,554,877),
(34,new String'("Sorbs"),34520,38,52,1,20.2,3.4,43.8833,480,860),
(34,new String'("Saint-Martin-de-l'Arçon"),34390,125,118,29,4.22,2.98333,43.5833,120,1065),
(34,new String'("Saint-Martin-de-Londres"),34380,2370,1892,62,38.2,3.73333,43.7833,91,488),
(34,new String'("Bouzigues"),34140,1626,1206,533,3.05,3.65,43.45,0,61),
(34,new String'("Prades-le-Lez"),34730,4534,4341,510,8.88,3.86667,43.7,53,134),
(34,new String'("Teyran"),34820,4427,4236,440,10.04,3.91667,43.6833,45,122),
(34,new String'("Saint-Jean-de-Cornies"),34160,673,478,216,3.11,4.0,43.7333,50,106),
(34,new String'("Saint-Jean-de-Cuculles"),34270,468,352,51,9.09,3.83333,43.75,72,459),
(34,new String'("Le Cros"),34520,48,39,2,22.45,3.36667,43.8667,596,865),
(34,new String'("Nizas"),34320,582,524,68,8.53,3.41667,43.5167,19,131),
(34,new String'("Montesquieu"),34320,65,47,4,14.47,3.26667,43.5667,140,467),
(34,new String'("Gigean"),34770,5687,3548,343,16.56,3.7,43.5,10,232),
(34,new String'("Abeilhan"),34290,1355,985,173,7.81,3.3,43.45,43,105),
(34,new String'("La Caunette"),34210,328,306,15,21.78,2.78333,43.35,112,483),
(34,new String'("Valras-Plage"),34350,4592,3635,1954,2.35,3.28333,43.25,0,10),
(34,new String'("Palavas-les-Flots"),34250,5995,5419,2518,2.38,3.93333,43.5333,0,3),
(34,new String'("Lauroux"),34700,203,172,7,26.42,3.28333,43.7833,212,845),
(34,new String'("Saturargues"),34400,891,596,148,5.99,4.11667,43.7167,16,68),
(35,new String'("Bain-de-Bretagne"),35470,7339,5516,113,64.77,-1.68333,47.8333,17,114),
(35,new String'("Domalain"),35680,1958,1490,58,33.54,-1.25,48.0,45,108),
(35,new String'("Sixt-sur-Aff"),35550,2152,1915,50,42.5,-2.08333,47.7833,5,92),
(35,new String'("Plélan-le-Grand"),35380,3566,2944,71,49.74,-2.1,48.0,42,154),
(35,new String'("Fleurigné"),35133,1043,898,57,18.17,-1.11667,48.3333,79,233),
(35,new String'("Montours"),35460,1016,811,66,15.27,-1.3,48.45,108,184),
(35,new String'("Guipel"),35440,1579,1419,62,25.11,-1.71667,48.3,58,113),
(35,new String'("Saint-Just"),35550,1058,924,37,28.05,-1.96667,47.7667,8,94),
(35,new String'("Beaucé"),35133,1214,1056,148,8.17,-1.16667,48.3333,70,188),
(35,new String'("Rimou"),35560,358,307,26,13.28,0.487501,48.3995,14,83),
(35,new String'("Le Petit-Fougeray"),35320,870,460,97,8.95,-1.6,47.9333,44,111),
(35,new String'("Langon"),35660,1443,1282,39,36.54,-1.85,47.7167,1,97),
(35,new String'("Landavran"),35450,626,398,124,5.01,-1.28333,48.15,68,127),
(35,new String'("Moutiers"),35130,900,657,51,17.64,-1.21667,47.9667,51,108),
(35,new String'("La Chapelle-Erbrée"),35500,630,450,52,11.98,-1.1,48.1333,77,167),
(35,new String'("Roz-sur-Couesnon"),35610,1034,952,39,25.86,-1.6,48.5833,5,97),
(35,new String'("Rennes"),35000,207178,206194,4111,50.39,-1.68333,48.0833,20,74),
(35,new String'("Saint-Gilles"),35590,3783,3463,182,20.72,-1.83333,48.15,34,96),
(35,new String'("Tresbœuf"),35320,1198,923,47,25.33,-1.55,47.8833,25,113),
(35,new String'("Andouillé-Neuville"),35250,807,504,63,12.61,-1.58333,48.3,52,111),
(35,new String'("Chelun"),35640,341,249,30,11.25,-1.21667,47.85,73,112),
(35,new String'("Brulais"),35330,465,400,38,11.96,-2.03333,47.8833,27,91),
(35,new String'("La Chapelle-Chaussée"),35630,1146,763,77,14.76,-1.85,48.2667,84,148),
(35,new String'("Landujan"),35360,936,688,65,14.32,-2.0,48.25,62,118),
(35,new String'("Redon"),35600,9592,9500,635,15.09,-2.08333,47.65,0,73),
(35,new String'("Baulon"),35580,1951,1325,77,25.02,-1.93333,47.9833,48,124),
(35,new String'("Plesder"),35720,708,569,64,11.03,-1.91667,48.4167,18,97),
(35,new String'("Pléchâtel"),35470,2735,1952,75,36.32,-1.75,47.9,7,116),
(35,new String'("Saint-Malo"),35400,46342,50697,1266,36.58,-2.01667,48.65,0,51),
(35,new String'("Teillay"),35620,997,786,38,26.21,-1.53333,47.8,37,98),
(35,new String'("Saint-Lunaire"),35800,2329,2246,226,10.27,-2.11667,48.6333,0,64),
(35,new String'("Amanlis"),35150,1602,1442,63,25.25,-1.48333,48.0,25,93),
(35,new String'("Dinard"),35800,10579,10443,1349,7.84,-2.06667,48.6333,0,56),
(35,new String'("Quédillac"),35290,1132,964,42,26.54,-2.15,48.25,60,121),
(35,new String'("Cancale"),35260,5324,5208,422,12.61,-1.85,48.6833,0,56),
(35,new String'("Cherrueix"),35120,1150,960,90,12.69,-1.7,48.6,1,9),
(35,new String'("Tressé"),35720,340,250,64,5.24,-1.88333,48.4833,35,77),
(35,new String'("Availles-sur-Seiche"),35130,702,512,63,11.06,-1.2,47.9667,52,89),
(35,new String'("Moulins"),35680,651,563,42,15.21,-1.36667,48.0,42,94),
(35,new String'("Pipriac"),35550,3559,2916,73,48.65,-1.95,47.8167,14,98),
(35,new String'("Guipry"),35480,3646,2990,72,50.35,-1.83333,47.8167,3,115),
(35,new String'("Corps-Nuds"),35150,2941,2460,130,22.56,-1.58333,47.9833,34,90),
(35,new String'("Comblessac"),35330,660,487,38,17.23,-2.08333,47.8667,17,96),
(35,new String'("Gévezé"),35850,3984,2764,144,27.54,-1.78333,48.2167,38,109),
(35,new String'("Saint-Suliac"),35430,940,855,172,5.46,-1.96667,48.5667,0,73),
(35,new String'("Saint-Hilaire-des-Landes"),35140,993,922,54,18.27,-1.35,48.35,54,117),
(35,new String'("Saint-Étienne-en-Coglès"),35460,1684,1424,74,22.65,-1.33333,48.4,73,155),
(35,new String'("Rannée"),35130,1156,1110,22,51.95,-1.23333,47.9167,55,114),
(35,new String'("Laignelet"),35133,979,793,66,14.83,-1.15,48.3667,104,231),
(35,new String'("Saint-Ganton"),35550,418,386,29,14.08,-1.88333,47.75,25,102),
(35,new String'("Miniac-Morvan"),35540,3705,2792,119,31.03,-1.9,48.5167,2,68),
(35,new String'("Domagné"),35113,2217,1638,76,29.0,-1.38333,48.0833,43,96),
(35,new String'("Le Lou-du-Lac"),35360,96,101,30,3.18,-1.98333,48.2,63,101),
(35,new String'("Saint-Grégoire"),35760,8549,7646,494,17.3,-1.68333,48.15,25,92),
(35,new String'("Montauban-de-Bretagne"),35360,4739,4042,110,42.96,-2.05,48.2,42,117),
(35,new String'("Le Châtellier"),35133,377,393,28,13.43,0.745834,48.4159,119,183),
(35,new String'("Montgermont"),35760,3056,2748,654,4.67,-1.71667,48.15,34,62),
(35,new String'("Chauvigné"),35490,788,576,44,17.71,-1.46667,48.3833,30,107),
(35,new String'("Vern-sur-Seiche"),35770,8146,7455,413,19.7,-1.6,48.05,21,72),
(35,new String'("Combourg"),35270,5637,4869,88,63.55,-1.75,48.4167,29,120),
(35,new String'("Visseiche"),35130,827,688,51,16.03,-1.3,47.95,42,91),
(35,new String'("Saint-Léger-des-Prés"),35270,232,232,41,5.54,-1.65,48.4,40,86),
(35,new String'("Bovel"),35330,579,331,39,14.6,-1.98333,47.95,45,128),
(35,new String'("Ercé-près-Liffré"),35340,1801,1363,114,15.78,-1.5,48.25,46,112),
(35,new String'("Coësmes"),35134,1391,1072,59,23.24,-1.43333,47.8833,47,107),
(35,new String'("Saint-Jouan-des-Guérets"),35430,2672,2489,289,9.24,-1.96667,48.6,0,61),
(35,new String'("Parcé"),35210,640,601,37,16.88,-1.2,48.2667,73,166),
(35,new String'("Lécousse"),35133,2931,2834,264,11.07,-1.21667,48.3667,62,181),
(35,new String'("Osse"),35410,1179,772,131,8.99,-1.45,48.05,44,78),
(35,new String'("Hirel"),35120,1373,1178,139,9.85,-1.8,48.6,1,9),
(35,new String'("Hédé-Bazouges"),35630,1940,1833,133,14.52,-1.8,48.3,39,108),
(35,new String'("Liffré"),35340,6829,6454,102,66.86,-1.5,48.2167,40,113),
(35,new String'("Saint-Germain-sur-Ille"),35250,892,725,228,3.9,-1.66667,48.25,37,100),
(35,new String'("Chevaigné"),35250,1838,1620,177,10.33,-1.63333,48.2167,32,90),
(35,new String'("Le Crouais"),35290,487,361,77,6.25,-2.13333,48.2,77,114),
(35,new String'("Coglès"),35460,650,575,37,17.21,-1.36667,48.4667,70,142),
(35,new String'("Montfort-sur-Meu"),35160,6458,5408,460,14.02,-1.96667,48.1333,28,131),
(35,new String'("Iffs"),35630,264,232,58,4.52,-1.86667,48.2833,53,141),
(35,new String'("Muel"),35290,816,648,28,28.9,1.84278,48.1273,45,133),
(35,new String'("Gaël"),35290,1584,1350,30,52.1,-2.23333,48.1333,51,131),
(35,new String'("Pocé-les-Bois"),35500,1078,970,72,14.84,-1.25,48.1167,47,112),
(35,new String'("Saint-Jean-sur-Vilaine"),35220,1043,872,97,10.73,-1.36667,48.1167,42,112),
(35,new String'("Orgères"),35230,3905,2865,239,16.33,-1.66667,48.0,26,111),
(35,new String'("Montreuil-sous-Pérouse"),35500,1061,928,68,15.49,-1.23333,48.15,53,125),
(35,new String'("Sougéal"),35610,642,586,45,14.15,-1.51667,48.5167,5,104),
(35,new String'("Le Vivier-sur-Mer"),35960,1014,1009,452,2.24,-1.78333,48.6,3,8),
(35,new String'("La Ville-ès-Nonais"),35430,1036,681,238,4.34,-1.95,48.55,0,53),
(35,new String'("Janzé"),35150,8142,5361,197,41.26,-1.5,47.9667,31,117),
(35,new String'("Miniac-sous-Bécherel"),35190,708,560,52,13.55,-1.93333,48.2833,79,183),
(35,new String'("Saint-Coulomb"),35350,2482,2167,137,18.04,-1.9,48.6833,0,52),
(35,new String'("Talensac"),35160,2353,2046,108,21.61,-1.93333,48.1,24,128),
(35,new String'("Le Pertre"),35370,1439,1354,32,43.63,-1.03333,48.0333,67,184),
(35,new String'("Saint-Sulpice-la-Forêt"),35250,1423,1307,211,6.72,-1.58333,48.2167,46,92),
(35,new String'("Québriac"),35190,1469,1040,70,20.72,-1.83333,48.35,22,96),
(35,new String'("Lohéac"),35550,664,603,129,5.11,-1.88333,47.8667,34,100),
(35,new String'("Marcillé-Raoul"),35560,833,660,37,22.41,-1.6,48.3833,25,91),
(35,new String'("Ercé-en-Lamée"),35620,1437,1157,36,39.21,-1.56667,47.8333,23,107),
(35,new String'("Romagne"),35133,2154,1609,79,26.93,-1.28333,48.35,57,171),
(35,new String'("Bruz"),35170,16465,13181,549,29.95,-1.75,48.0333,12,99),
(35,new String'("Thorigné-Fouillard"),35235,7140,6631,525,13.58,0.420279,48.1598,27,89),
(35,new String'("Laillé"),35890,4348,3554,135,32.04,-1.71667,47.9833,5,110),
(35,new String'("Parthenay-de-Bretagne"),35850,1378,563,287,4.8,-1.83333,48.2,62,107),
(35,new String'("Dourdain"),35450,1046,706,75,13.8,-1.36667,48.1833,52,112),
(35,new String'("Saint-Ouen-la-Rouërie"),35460,792,754,37,21.12,0.559168,48.4628,12,114),
(35,new String'("Saulnières"),35320,700,583,67,10.34,-1.58333,47.9167,56,117),
(35,new String'("Renac"),35660,944,858,36,25.89,-1.98333,47.7167,2,94),
(35,new String'("Saint-Symphorien"),35630,560,0,70,7.91,-1.83333,48.2833,51,122),
(35,new String'("Retiers"),35240,3775,3226,91,41.38,-1.38333,47.9167,41,120),
(35,new String'("La Fontenelle"),35560,541,512,43,12.36,-1.5,48.4667,7,117),
(35,new String'("Mecé"),35450,570,468,36,15.63,-1.3,48.2333,85,132),
(35,new String'("Lourmais"),35270,322,251,44,7.22,-1.73333,48.45,60,111),
(35,new String'("Combourtillé"),35210,578,400,62,9.25,-1.25,48.2667,72,130),
(35,new String'("Javené"),35133,1914,1517,103,18.45,-1.21667,48.3167,60,109),
(35,new String'("Dompierre-du-Chemin"),35210,548,473,56,9.68,-1.15,48.2667,93,182),
(35,new String'("Betton"),35830,10111,8555,378,26.73,-1.65,48.1833,27,90),
(35,new String'("Saint-Germain-en-Coglès"),35133,2053,1777,63,32.09,-1.25,48.4,105,194),
(35,new String'("Esse"),35150,1122,858,48,23.19,-1.41667,47.9667,32,92),
(35,new String'("Dingé"),35440,1580,1328,29,52.89,-1.71667,48.35,54,108),
(35,new String'("Bourg-des-Comptes"),35890,2848,2008,121,23.41,-1.75,47.9333,7,99),
(35,new String'("Boisgervilly"),35360,1513,1214,75,19.95,-2.06667,48.1667,58,111),
(35,new String'("La Chapelle-Bouëxic"),35330,1299,808,62,20.66,-1.93333,47.9333,32,112),
(35,new String'("Sains"),35610,482,503,47,10.25,-1.58333,48.55,19,96),
(35,new String'("Tremblay"),35460,1508,1424,41,36.22,-1.46667,48.4167,10,116),
(35,new String'("Cardroc"),35190,525,398,71,7.39,-1.88333,48.2833,65,152),
(35,new String'("La Gouesnière"),35350,1646,1068,188,8.74,-1.9,48.6167,2,47),
(35,new String'("Iffendic"),35750,4291,3048,58,73.66,-2.03333,48.1333,32,134),
(35,new String'("Trémeheuc"),35270,366,313,60,6.05,-1.7,48.4333,69,127),
(35,new String'("Saint-Maugan"),35750,587,349,69,8.43,-2.08333,48.1333,42,98),
(35,new String'("Fougères"),35300,19779,21798,1890,10.46,-1.2,48.35,62,171),
(35,new String'("Goven"),35580,4132,2967,104,39.73,-1.85,48.0,15,116),
(35,new String'("Vieux-Vy-sur-Couesnon"),35490,1104,861,51,21.56,-1.48333,48.35,22,107),
(35,new String'("Saint-Sulpice-des-Landes"),35390,806,562,72,11.19,0.376945,47.7667,28,99),
(35,new String'("Mézières-sur-Couesnon"),35140,1378,825,55,24.74,-1.45,48.3,35,121),
(35,new String'("Cintré"),35310,2054,1467,246,8.32,-1.86667,48.1,25,63),
(35,new String'("Montautour"),35210,249,240,36,6.9,-1.15,48.2,105,194),
(35,new String'("Vergéal"),35680,738,589,65,11.21,-1.26667,48.0333,62,108),
(35,new String'("Champeaux"),35500,473,421,48,9.83,-1.31667,48.15,49,116),
(35,new String'("Cornille"),35500,860,663,68,12.47,-1.3,48.0833,45,107),
(35,new String'("Étrelles"),35370,2559,2128,94,27.17,-1.18333,48.0667,52,108),
(35,new String'("Chavagne"),35310,3725,3091,299,12.44,-1.78333,48.05,16,38),
(35,new String'("Louvigné-de-Bais"),35680,1709,1411,111,15.37,-1.33333,48.05,33,106),
(35,new String'("Taillis"),35500,1002,770,81,12.27,-1.23333,48.1833,72,136),
(35,new String'("Bruc-sur-Aff"),35550,845,777,39,21.23,-2.01667,47.8167,12,84),
(35,new String'("Torcé"),35370,1147,916,81,14.03,-1.26667,48.0667,69,104),
(35,new String'("Paimpont"),35380,1631,1399,14,110.28,-2.18333,48.0167,62,258),
(35,new String'("Thourie"),35134,707,526,29,24.04,-1.48333,47.85,34,97),
(35,new String'("Noyal-Châtillon-sur-Seiche"),35230,6250,5635,235,26.51,0.342501,48.0434,17,54),
(35,new String'("Saint-Médard-sur-Ille"),35250,1319,1154,72,18.22,-1.66667,48.2667,44,115),
(35,new String'("Le Tronchet"),35540,1053,841,92,11.35,-1.83333,48.4833,13,79),
(35,new String'("Pleine-Fougères"),35610,1963,1740,61,31.98,-1.56667,48.5333,5,93),
(35,new String'("Mont-Dol"),35120,1248,1099,47,26.44,-1.76667,48.5667,1,62),
(35,new String'("Lalleu"),35320,581,468,37,15.47,-1.51667,47.85,31,104),
(35,new String'("Trimer"),35190,177,102,49,3.56,-1.88333,48.3333,29,87),
(35,new String'("La Bosse-de-Bretagne"),35320,607,388,59,10.21,-1.6,47.8667,22,106),
(35,new String'("Le Ferré"),35420,682,592,40,16.92,-1.3,48.5,90,172),
(35,new String'("Forges-la-Forêt"),35640,280,242,46,6.04,-1.26667,47.8667,70,111),
(35,new String'("Landéan"),35133,1256,1170,45,27.31,-1.15,48.4167,107,208),
(35,new String'("Poilley"),35420,397,382,36,10.78,-1.26667,48.4667,115,184),
(35,new String'("Saint-Gonlay"),35750,349,273,37,9.26,-2.06667,48.1167,38,95),
(35,new String'("Bléruais"),35750,98,60,29,3.33,-2.13333,48.1167,45,97),
(35,new String'("Montreuil-sur-Ille"),35440,2114,1554,139,15.15,-1.66667,48.3,50,96),
(35,new String'("Epiniac"),35120,1364,1089,57,23.77,-1.7,48.5,11,107),
(35,new String'("Erbrée"),35500,1664,1498,46,35.52,-1.11667,48.1,70,163),
(35,new String'("La Boussac"),35120,1169,975,53,21.93,-1.66667,48.5167,18,108),
(35,new String'("Livré-sur-Changeon"),35450,1646,1135,62,26.37,-1.35,48.2167,59,126),
(35,new String'("Saint-Aubin-du-Pavail"),35410,729,589,125,5.83,-1.46667,48.05,50,76),
(35,new String'("Saint-Georges-de-Chesné"),35140,602,385,51,11.62,-1.28333,48.2667,58,122),
(35,new String'("Saint-Broladre"),35120,1140,1013,47,23.81,-1.65,48.5833,1,102),
(35,new String'("Saint-Ouen-des-Alleux"),35140,1312,924,86,15.2,-1.41667,48.3333,32,106),
(35,new String'("Bréal-sous-Montfort"),35310,5055,3828,149,33.82,-1.86667,48.05,19,82),
(35,new String'("Piré-sur-Seiche"),35150,2283,1876,62,36.34,-1.43333,48.0,31,86),
(35,new String'("Mernel"),35330,986,755,56,17.37,-1.96667,47.9,23,103),
(35,new String'("Saint-Erblon"),35230,2482,2230,227,10.93,-1.65,48.0167,20,49),
(35,new String'("La Dominelais"),35390,1253,908,38,32.45,-1.68333,47.7667,22,105),
(35,new String'("Bréal-sous-Vitré"),35370,645,530,112,5.75,-1.06667,48.1,110,181),
(35,new String'("Saint-Gondran"),35630,520,465,118,4.4,-1.83333,48.2667,80,121),
(35,new String'("Val-d'Izé"),35450,2493,2083,56,43.79,-1.3,48.1833,67,129),
(35,new String'("Domloup"),35410,2989,2436,158,18.91,0.476945,48.062,33,87),
(35,new String'("Bédée"),35137,3997,3299,102,38.95,-1.95,48.1833,32,119),
(35,new String'("Saint-Père"),35430,2300,1754,116,19.74,-1.91667,48.5833,1,56),
(35,new String'("La Chapelle-aux-Filtzméens"),35190,764,381,120,6.36,0.174445,48.3837,21,85),
(35,new String'("Billé"),35133,1030,833,60,16.96,-1.25,48.2833,57,117),
(35,new String'("Bazouges-la-Pérouse"),35560,1877,1857,32,58.18,-1.58333,48.4167,10,116),
(35,new String'("Pancé"),35320,1132,966,58,19.33,-1.66667,47.8833,17,105),
(35,new String'("Gennes-sur-Seiche"),35370,814,738,44,18.5,-1.11667,47.9833,58,104),
(35,new String'("La Mézière"),35520,4320,3132,266,16.23,-1.75,48.2167,39,114),
(35,new String'("Saint-Méloir-des-Ondes"),35350,3732,3010,126,29.49,-1.9,48.65,2,58),
(35,new String'("Vitré"),35500,16834,15324,454,37.03,-1.2,48.1333,56,127),
(35,new String'("Chanteloup"),35150,1623,1110,92,17.53,-1.61667,47.9667,38,109),
(35,new String'("La Chapelle-du-Lou"),35360,723,374,99,7.28,-2.0,48.2167,74,114),
(35,new String'("Vendel"),35140,437,339,68,6.37,-1.31667,48.3,50,105),
(35,new String'("Romillé"),35850,3632,2688,126,28.67,-1.9,48.2167,60,142),
(35,new String'("Clayes"),35590,678,457,158,4.28,-1.85,48.1833,65,109),
(35,new String'("Saint-Brice-en-Coglès"),35460,2752,2399,167,16.46,-1.36667,48.4,80,124),
(35,new String'("Pleurtuit"),35730,5962,4543,200,29.67,-2.06667,48.5833,0,92),
(35,new String'("Pacé"),35740,9961,7890,285,34.94,-1.76667,48.15,27,91),
(35,new String'("La Nouaye"),35137,294,235,106,2.77,-1.98333,48.15,38,76),
(35,new String'("Le Minihic-sur-Rance"),35870,1427,1266,364,3.91,-2.01667,48.5833,0,61),
(35,new String'("Bonnemain"),35270,1377,1140,57,23.77,-1.76667,48.4667,43,108),
(35,new String'("Saint-Onen-la-Chapelle"),35290,1097,784,44,24.66,-2.16667,48.1667,57,114),
(35,new String'("Trans-la-Forêt"),35610,550,585,37,14.83,-1.6,48.5,33,117),
(35,new String'("Le Rheu"),35650,7669,5735,405,18.89,-1.8,48.1,18,48),
(35,new String'("Servon-sur-Vilaine"),35530,3542,2919,232,15.26,-1.45,48.1167,34,91),
(35,new String'("Saint-Georges-de-Reintembault"),35420,1638,1681,52,31.02,0.756668,48.5084,94,180),
(35,new String'("Lillemer"),35111,282,200,75,3.74,-1.86667,48.5667,1,13),
(35,new String'("Monterfil"),35160,1273,976,75,16.94,-1.98333,48.0667,32,132),
(35,new String'("Drouges"),35130,520,418,44,11.63,-1.26667,47.9,57,109),
(35,new String'("Maxent"),35380,1305,1038,32,39.72,-2.03333,47.9833,51,137),
(35,new String'("Saint-Péran"),35380,351,197,37,9.37,-2.05,48.05,84,160),
(35,new String'("Saint-Germain-du-Pinel"),35370,877,648,77,11.3,-1.16667,48.0167,69,107),
(35,new String'("Antrain"),35560,1393,1388,149,9.31,-1.48333,48.45,6,84),
(35,new String'("Pont-Péan"),35131,3697,3203,422,8.76,0.295279,48.0128,17,44),
(35,new String'("La Noë-Blanche"),35470,976,838,42,23.18,-1.73333,47.8,18,95),
(35,new String'("Boistrudan"),35150,670,494,52,12.8,-1.4,47.9667,32,85),
(35,new String'("Saint-Malo-de-Phily"),35480,907,657,48,18.77,-1.78333,47.8667,5,114),
(35,new String'("Saint-Pierre-de-Plesguen"),35720,2650,2000,89,29.49,-1.91667,48.45,34,99),
(35,new String'("Luitré"),35133,1301,1200,44,29.15,-1.11667,48.2833,78,201),
(35,new String'("Pleumeleuc"),35137,2941,2126,150,19.51,-1.91667,48.1833,43,112),
(35,new String'("Baillé"),35460,312,314,59,5.23,-1.38333,48.35,60,111),
(35,new String'("Saint-Aubin-des-Landes"),35500,912,871,88,10.28,-1.3,48.1,45,105),
(35,new String'("Saint-Thual"),35190,749,415,65,11.4,-1.93333,48.3333,33,126),
(35,new String'("La Selle-en-Coglès"),35460,597,447,72,8.23,-1.35,48.4333,93,138),
(35,new String'("Sainte-Anne-sur-Vilaine"),35390,1014,777,35,28.57,-1.81667,47.7333,2,85),
(35,new String'("La Richardais"),35780,2393,2119,762,3.14,-2.03333,48.6,0,55),
(35,new String'("Montreuil-le-Gast"),35520,1912,1602,209,9.14,-1.71667,48.25,65,122),
(35,new String'("La Selle-en-Luitré"),35133,553,429,75,7.32,-1.13333,48.3,70,122),
(35,new String'("Marcillé-Robert"),35240,941,821,46,20.3,-1.36667,47.95,37,87),
(35,new String'("Roz-Landrieux"),35120,1265,1059,69,18.1,-1.83333,48.5333,0,50),
(35,new String'("Vignoc"),35630,1798,1096,127,14.09,-1.78333,48.25,63,121),
(35,new String'("Vezin-le-Coquet"),35132,4382,4029,557,7.86,-1.75,48.1167,21,67),
(35,new String'("Baguer-Morvan"),35120,1564,1342,67,23.11,-1.78333,48.5333,15,87),
(35,new String'("Arbrissel"),35130,279,237,60,4.62,-1.3,47.9333,52,82),
(35,new String'("L'Hermitage"),35590,3835,3091,561,6.83,-1.81667,48.1333,27,56),
(35,new String'("Saint-Sauveur-des-Landes"),35133,1442,1001,76,18.84,-1.31667,48.3333,85,132),
(35,new String'("Mellé"),35420,671,685,43,15.5,-1.2,48.5,129,196),
(35,new String'("La Bazouge-du-Désert"),35420,1093,1012,44,24.6,0.895001,48.4431,113,193),
(35,new String'("Le Verger"),35160,1514,1099,220,6.87,-1.93374,48.0696,29,92),
(35,new String'("La Couyère"),35320,501,350,42,11.72,-1.5,47.8833,44,109),
(35,new String'("Chasné-sur-Illet"),35250,1466,1141,154,9.47,-1.56667,48.25,39,81),
(35,new String'("Monthault"),35420,251,249,30,8.2,-1.18333,48.5167,114,197),
(35,new String'("Saint-Jacques-de-la-Lande"),35136,10497,7583,887,11.83,-1.71667,48.0667,18,47),
(35,new String'("Lanrigan"),35270,138,108,34,3.98,-1.7,48.4,50,85),
(35,new String'("Louvigné-du-Désert"),35420,3758,4025,90,41.66,-1.13333,48.4833,97,198),
(35,new String'("Saint-Guinoux"),35430,907,733,142,6.37,-1.88333,48.5833,2,48),
(35,new String'("Saint-Marcan"),35120,467,380,60,7.68,-1.63333,48.5833,4,96),
(35,new String'("Brécé"),35530,1929,1560,269,7.16,-1.48333,48.1167,32,73),
(35,new String'("Le Theil-de-Bretagne"),35240,1556,1129,64,24.2,-1.43333,47.9167,42,106),
(35,new String'("Saint-Séglin"),35330,478,434,50,9.4,-2.0,47.85,12,74),
(35,new String'("Cuguen"),35270,784,709,33,23.54,-1.65,48.45,35,113),
(35,new String'("Noyal-sur-Vilaine"),35530,5441,4696,179,30.36,-1.51667,48.1167,32,91),
(35,new String'("Saint-Malon-sur-Mel"),35750,589,447,36,16.07,1.90111,48.0931,46,116),
(35,new String'("Langan"),35850,894,771,114,7.8,-1.85,48.25,69,124),
(35,new String'("Lassy"),35580,1380,1026,141,9.76,-1.86667,47.9833,37,112),
(35,new String'("La Bouëxière"),35340,3834,3503,77,49.68,-1.43333,48.1833,42,125),
(35,new String'("Saint-Thurial"),35310,1886,1485,104,18.01,-1.93333,48.0333,32,128),
(35,new String'("Mouazé"),35250,1053,916,125,8.39,-1.6,48.2333,32,77),
(35,new String'("Breteil"),35160,3377,2974,229,14.7,-1.9,48.15,26,71),
(35,new String'("Vieux-Viel"),35610,288,275,32,8.77,-1.55,48.5167,14,108),
(35,new String'("Saint-Benoît-des-Ondes"),35114,1077,805,368,2.92,-1.85,48.6167,2,10),
(35,new String'("Guichen"),35580,7500,6523,174,42.99,-1.8,47.9667,7,107),
(35,new String'("Feins"),35440,809,710,39,20.35,-1.63333,48.3333,56,104),
(35,new String'("Meillac"),35270,1730,1354,53,32.21,-1.81667,48.4167,22,92),
(35,new String'("Crevin"),35320,2594,1722,312,8.31,-1.66667,47.9333,50,111),
(35,new String'("Saint-Georges-de-Gréhaigne"),35610,342,380,28,12.15,-1.55,48.5667,5,81),
(35,new String'("Longaulnay"),35190,614,341,81,7.52,-1.93333,48.3,65,191),
(35,new String'("Aubigné"),35250,428,240,194,2.2,-1.63333,48.3,52,87),
(35,new String'("Saint-Pern"),35190,973,775,80,12.13,-1.98333,48.2833,56,181),
(35,new String'("Le Sel-de-Bretagne"),35320,915,514,112,8.1,0.389445,47.8959,37,107),
(35,new String'("La Chapelle-Saint-Aubert"),35140,421,361,43,9.77,-1.3,48.3167,51,128),
(35,new String'("Campel"),35330,513,403,46,11.1,-2.0,47.9333,47,119),
(35,new String'("Saint-Marc-sur-Couesnon"),35140,517,409,42,12.05,-1.36667,48.3,42,117),
(35,new String'("Chantepie"),35135,9823,6795,819,11.98,-1.61667,48.0833,32,77),
(35,new String'("La Fresnais"),35111,2199,1949,152,14.43,-1.85,48.6,1,8),
(35,new String'("Maure-de-Bretagne"),35330,3203,2472,47,66.76,-1.98333,47.9,17,117),
(35,new String'("Lieuron"),35550,737,563,44,16.72,-1.95,47.85,18,69),
(35,new String'("Cesson-Sévigné"),35510,15219,14336,473,32.14,-1.6,48.125,27,82),
(35,new String'("Gahard"),35490,1268,917,50,24.96,-1.51667,48.3,45,112),
(35,new String'("Saint-Uniac"),35360,509,349,73,6.89,-2.03333,48.1667,45,96),
(35,new String'("Plerguer"),35540,2284,1772,113,20.19,-1.85,48.5333,2,78),
(35,new String'("Saint-Didier"),35220,1792,1277,126,14.14,-1.36667,48.1,40,97),
(35,new String'("Bains-sur-Oust"),35600,3406,3021,76,44.63,-2.06667,47.7,0,89),
(35,new String'("Chartres-de-Bretagne"),35131,7260,6467,729,9.95,-1.7,48.05,16,50),
(35,new String'("Messac"),35480,2778,2247,66,41.64,-1.8,47.8167,3,89),
(35,new String'("La Guerche-de-Bretagne"),35130,4255,4093,369,11.53,-1.23333,47.9333,51,91),
(35,new String'("Saint-Christophe-de-Valains"),35140,218,138,66,3.27,-1.45,48.35,35,104),
(35,new String'("Le Loroux"),35133,614,524,53,11.56,-1.06667,48.4,148,244),
(35,new String'("Lanhélin"),35720,957,619,148,6.43,-1.83333,48.45,44,88),
(35,new String'("Princé"),35210,375,333,30,12.36,-1.08333,48.2167,113,188),
(35,new String'("Nouvoitou"),35410,2895,2560,152,18.93,-1.55,48.05,22,75),
(35,new String'("Martigné-Ferchaud"),35640,2663,2633,35,74.1,-1.31667,47.8333,42,121),
(35,new String'("Saint-Aubin-du-Cormier"),35140,3578,2754,130,27.41,-1.4,48.2667,54,123),
(35,new String'("La Chapelle-de-Brain"),35660,952,835,53,17.65,0.0652788,47.7003,1,70),
(35,new String'("Langouet"),35630,546,537,78,6.99,-1.81667,48.25,71,121),
(35,new String'("Médréac"),35360,1876,1497,53,35.02,-2.06667,48.2667,45,137),
(35,new String'("Saint-Christophe-des-Bois"),35210,528,475,57,9.26,-1.25,48.2333,99,136),
(35,new String'("Saint-Jean-sur-Couesnon"),35140,1072,863,58,18.32,-1.36667,48.2833,47,122),
(35,new String'("Châtillon-en-Vendelais"),35210,1694,1548,52,32.03,-1.16667,48.2167,87,194),
(35,new String'("Saint-M'Hervon"),35360,433,317,176,2.46,-2.05,48.2333,71,112),
(35,new String'("Pleugueneuc"),35720,1659,1289,67,24.52,-1.9,48.4,17,89),
(35,new String'("Saint-Armel"),35230,1830,1395,236,7.75,-1.58333,48.0167,22,79),
(35,new String'("Sainte-Marie"),35600,2275,1760,89,25.28,-2.0,47.7,0,68),
(35,new String'("Saint-Aubin-d'Aubigné"),35250,3310,2441,140,23.52,-1.6,48.25,42,111),
(35,new String'("Châteaugiron"),35410,6545,5498,752,8.7,-1.5,48.05,28,76),
(35,new String'("Moussé"),35130,326,200,96,3.37,-1.26667,47.9333,52,87),
(35,new String'("Tinténiac"),35190,3373,2440,144,23.4,-1.85,48.3167,31,90),
(35,new String'("La Baussaine"),35190,623,476,64,9.63,-1.9,48.3167,48,117),
(35,new String'("Sens-de-Bretagne"),35490,2547,1515,82,30.82,-1.55,48.3333,16,107),
(35,new String'("Romazy"),35490,276,237,38,7.18,-1.5,48.3667,14,85),
(35,new String'("Brie"),35150,812,699,59,13.56,-1.53333,47.95,45,113),
(35,new String'("Trévérien"),35190,840,524,69,12.08,-1.93333,48.3667,13,68),
(35,new String'("Montreuil-des-Landes"),35210,236,184,25,9.42,-1.21667,48.25,85,133),
(35,new String'("Bécherel"),35190,758,660,1329,0.57,-1.95,48.3,113,177),
(35,new String'("Marpiré"),35220,1064,769,100,10.62,-1.33333,48.1333,69,119),
(35,new String'("Saint-Senoux"),35580,1695,1076,92,18.29,-1.78333,47.9,7,111),
(35,new String'("La Selle-Guerchaise"),35130,150,128,70,2.14,-1.16667,47.95,65,95),
(35,new String'("Parigné"),35133,1317,1134,63,20.72,-1.2,48.4333,109,182),
(35,new String'("Balazé"),35500,2165,1917,59,36.66,-1.18333,48.1667,70,169),
(35,new String'("La Chapelle-Thouarault"),35590,1926,1915,252,7.64,-1.86667,48.1333,28,64),
(35,new String'("Saint-Briac-sur-Mer"),35800,1968,2052,244,8.06,-2.13333,48.6333,0,62),
(35,new String'("Melesse"),35520,5577,5163,172,32.39,-1.7,48.2167,38,111),
(35,new String'("Noyal-sous-Bazouges"),35560,372,379,25,14.83,-1.63333,48.4167,25,109),
(35,new String'("Loutehel"),35330,215,191,29,7.21,-2.08333,47.9333,31,99),
(35,new String'("Gosné"),35140,1728,1380,95,18.14,-1.46667,48.25,53,114),
(35,new String'("Guignen"),35580,3511,2426,66,53.05,-1.85,47.9167,21,122),
(35,new String'("Grand-Fougeray"),35390,2352,1970,42,55.42,-1.73333,47.7167,3,92),
(35,new String'("Châteauneuf-d'Ille-et-Vilaine"),35430,1249,911,905,1.38,0.0702788,48.5612,2,43),
(35,new String'("Argentré-du-Plessis"),35370,4212,3614,101,41.46,-1.15,48.0667,67,163),
(35,new String'("Dol-de-Bretagne"),35120,5335,4566,343,15.53,-1.75,48.55,1,58),
(35,new String'("Mondevert"),35370,771,576,153,5.02,-1.1,48.0833,107,142),
(35,new String'("Baguer-Pican"),35120,1380,984,88,15.63,-1.7,48.55,1,90),
(35,new String'("La Chapelle-des-Fougeretz"),35520,3944,3314,452,8.71,0.267223,48.1773,41,95),
(35,new String'("Acigné"),35690,6166,5254,208,29.55,-1.53333,48.1333,29,96),
(35,new String'("Le Tiercent"),35460,177,165,47,3.7,-1.4,48.35,50,98),
(35,new String'("La Chapelle-Janson"),35133,1343,1177,49,26.96,-1.1,48.35,79,249),
(35,new String'("Bais"),35680,2114,1935,60,35.18,-1.28333,48.0167,47,109),
(35,new String'("Villamée"),35420,335,313,31,10.66,-1.21667,48.4667,134,171),
(35,new String'("Saint-Rémy-du-Plain"),35560,789,580,53,14.87,-1.56667,48.3667,23,105),
(35,new String'("Chancé"),35680,304,246,58,5.22,-1.38333,48.0333,50,89),
(35,new String'("Brielles"),35370,670,513,58,11.4,-1.08333,48.0167,67,109),
(35,new String'("Sainte-Colombe"),35134,307,270,40,7.58,-1.45,47.8833,47,106),
(35,new String'("Bourgbarré"),35230,3458,2326,243,14.2,-1.61667,48.0,27,104),
(35,new String'("Broualan"),35120,351,290,27,12.76,-1.65,48.4667,60,116),
(35,new String'("Saint-M'Hervé"),35500,1370,1213,46,29.68,-1.11667,48.1833,72,171),
(35,new String'("Mordelles"),35310,7180,5902,241,29.76,-1.85,48.0667,19,51),
(35,new String'("Irodouër"),35850,2015,1393,85,23.54,-1.95,48.25,78,144),
(35,new String'("Treffendel"),35380,1246,767,65,18.98,-2.0,48.0333,56,143),
(35,new String'("Saint-Méen-le-Grand"),35290,4426,3564,242,18.28,-2.2,48.1833,79,123),
(35,new String'("Châteaubourg"),35220,6081,4874,212,28.6,-1.4,48.1167,35,117),
(35,new String'("Saint-Marc-le-Blanc"),35460,1288,1086,73,17.53,-1.4,48.3667,62,121),
(35,new String'("Saint-Domineuc"),35190,2242,1440,142,15.7,-1.86667,48.3667,17,90),
(35,new String'("Saint-Brieuc-des-Iffs"),35630,363,293,43,8.29,-1.85,48.3,34,133),
(35,new String'("Poligné"),35320,1136,760,122,9.24,-1.68333,47.8833,12,93),
(35,new String'("Eancé"),35640,400,338,24,16.5,-1.25,47.8167,61,112),
(36,new String'("Saint-Médard"),36700,45,73,3,12.6,1.25,47.0,108,174),
(36,new String'("Saint-Pierre-de-Lamps"),36110,43,44,4,10.28,1.5,46.9667,138,185),
(36,new String'("Bazaiges"),36270,230,230,12,18.37,1.53333,46.5,175,280),
(36,new String'("Bretagne"),36110,143,81,7,18.36,1.7,47.0,132,186),
(36,new String'("Saint-Chartier"),36400,584,540,21,27.52,1.96667,46.65,181,271),
(36,new String'("Francillon"),36110,71,72,6,10.27,1.55,46.9833,144,194),
(36,new String'("Thenay"),36800,888,827,25,34.21,1.43333,46.6333,93,187),
(36,new String'("Villentrois"),36600,614,645,18,32.38,1.46667,47.1833,85,151),
(36,new String'("Vicq-Exemplet"),36400,327,360,8,38.74,2.13333,46.6333,185,263),
(36,new String'("Neuvy-Saint-Sépulchre"),36230,1695,1654,48,35.11,1.81667,46.6,166,275),
(36,new String'("Cuzion"),36190,446,504,24,18.45,1.6,46.4833,135,287),
(36,new String'("Martizay"),36220,1045,1050,26,39.0,1.03333,46.8,75,136),
(36,new String'("Buxières-d'Aillac"),36230,225,217,8,25.75,1.75,46.6333,155,222),
(36,new String'("Fontguenand"),36600,238,230,13,18.24,1.53333,47.2167,86,141),
(36,new String'("Aigurande"),36140,1567,1667,56,27.77,1.83333,46.4333,284,442),
(36,new String'("Fontenay"),36150,84,86,6,12.33,1.73333,47.05,118,171),
(36,new String'("La Châtre-Langlin"),36170,567,566,20,27.4,1.38333,46.4167,173,302),
(36,new String'("Jeu-les-Bois"),36120,394,343,10,38.32,1.8,46.6667,143,206),
(36,new String'("Dun-le-Poëlier"),36210,471,457,20,22.56,1.75,47.2,87,140),
(36,new String'("La Vernelle"),36600,778,693,45,17.08,1.53333,47.2333,71,114),
(36,new String'("Bagneux"),36210,195,174,7,25.3,1.75,47.1833,92,146),
(36,new String'("Crozon-sur-Vauvre"),36140,379,388,13,27.69,1.86667,46.4833,237,450),
(36,new String'("Chasseneuil"),36800,666,620,22,29.85,1.48333,46.6333,93,177),
(36,new String'("Guilly"),36150,247,223,11,20.64,1.71667,47.0667,106,169),
(36,new String'("La Berthenoux"),36400,452,468,11,39.82,2.06667,46.65,184,269),
(36,new String'("Bouesse"),36200,370,398,15,24.19,1.68333,46.6167,144,242),
(36,new String'("Lourouer-Saint-Laurent"),36400,254,224,22,11.21,2.01667,46.6333,194,246),
(36,new String'("Briantes"),36400,608,557,26,23.12,2.01667,46.55,207,308),
(36,new String'("Buzançais"),36500,4494,4576,76,58.64,1.41667,46.8833,102,155),
(36,new String'("Le Tranger"),36700,175,162,7,22.26,1.23333,46.95,86,184),
(36,new String'("Fougerolles"),36230,332,287,19,17.17,1.86667,46.5667,187,284),
(36,new String'("Montipouret"),36230,569,507,20,27.89,1.9,46.65,170,259),
(36,new String'("Preuilly-la-Ville"),36220,168,130,39,4.23,0.966667,46.6833,67,117),
(36,new String'("Vigoux"),36170,466,445,12,37.51,1.48333,46.5167,168,269),
(36,new String'("Vendœuvres"),36500,1125,1018,11,96.45,1.35,46.8,97,139),
(36,new String'("Thizay"),36100,257,250,15,16.65,1.9,46.9,130,169),
(36,new String'("Diou"),36260,279,235,17,16.39,2.05,47.05,112,176),
(36,new String'("Varennes-sur-Fouzon"),36210,723,665,31,22.85,1.6,47.2167,77,132),
(36,new String'("Veuil"),36600,383,364,20,18.84,1.51667,47.1167,97,158),
(36,new String'("La Motte-Feuilly"),36160,36,42,6,5.68,2.08333,46.5333,228,274),
(36,new String'("Pommiers"),36190,273,268,22,12.19,1.65,46.5167,196,280),
(36,new String'("Faverolles"),36360,352,379,8,41.41,1.40833,47.172,91,154),
(36,new String'("Douadic"),36300,458,440,10,43.14,1.11667,46.7,87,150),
(36,new String'("Pellevoisin"),36180,833,885,32,25.62,1.41667,46.9833,117,192),
(36,new String'("Langé"),36600,297,293,14,20.63,1.51667,47.0667,105,177),
(36,new String'("Orsennes"),36190,793,790,16,49.28,1.68333,46.4833,209,376),
(36,new String'("Fléré-la-Rivière"),36700,608,594,24,25.31,1.1,47.0167,79,142),
(36,new String'("Villegouin"),36500,402,411,16,24.03,1.38333,46.9667,101,201),
(36,new String'("Bouges-le-Château"),36110,283,255,8,34.77,1.67333,47.0395,120,207),
(36,new String'("Murs"),36700,125,137,5,23.05,1.15,46.9,106,150),
(36,new String'("Villers-les-Ormes"),36250,423,338,24,17.6,1.63333,46.8667,141,169),
(36,new String'("Déols"),36130,7916,8066,249,31.74,1.7,46.8333,140,165),
(36,new String'("Obterre"),36290,247,267,8,28.47,1.03333,46.9,98,144),
(36,new String'("Valençay"),36600,2594,2736,62,41.59,1.56667,47.15,91,154),
(36,new String'("Cléré-du-Bois"),36700,282,267,7,36.13,1.1,46.9167,95,147),
(36,new String'("Ardentes"),36120,3774,3322,60,62.09,1.83333,46.75,150,208),
(36,new String'("Brives"),36100,276,198,14,19.61,1.95,46.85,135,168),
(36,new String'("Mérigny"),36220,563,572,17,31.77,0.916667,46.6167,67,136),
(36,new String'("Saulnay"),36290,183,179,8,22.2,1.26667,46.8667,97,146),
(36,new String'("Tournon-Saint-Martin"),36220,1214,1251,47,25.82,0.95,46.7333,64,140),
(36,new String'("Chezelles"),36500,442,409,25,17.32,1.56667,46.8833,132,171),
(36,new String'("Cluis"),36340,1020,1063,28,35.32,1.75,46.55,188,340),
(36,new String'("Sainte-Gemme"),36500,262,272,8,32.5,1.33333,46.85,94,138),
(36,new String'("Bonneuil"),36310,100,83,8,11.41,1.23333,46.3667,160,234),
(36,new String'("Paulnay"),36290,356,354,9,38.48,1.15,46.85,88,149),
(36,new String'("Ceaulmont"),36200,719,652,41,17.38,1.58333,46.5167,104,266),
(36,new String'("Gargilesse-Dampierre"),36190,319,324,20,15.72,1.6,46.5167,124,275),
(36,new String'("Saint-Benoît-du-Sault"),36170,652,766,362,1.8,1.4,46.45,175,246),
(36,new String'("Tranzault"),36230,326,323,18,17.97,1.85,46.6167,166,238),
(36,new String'("Vouillon"),36100,260,250,17,14.98,1.91667,46.8167,142,171),
(36,new String'("Reboursin"),36150,121,98,9,12.72,1.81667,47.1,108,160),
(36,new String'("Vigoulant"),36160,129,109,13,9.71,2.06667,46.4333,270,426),
(36,new String'("Aize"),36150,128,126,7,17.07,1.7,47.1,100,161),
(36,new String'("Issoudun"),36100,13090,13680,357,36.6,2.0,46.95,122,161),
(36,new String'("Maillet"),36340,265,247,10,25.02,1.68333,46.5667,170,254),
(36,new String'("Saint-Denis-de-Jouhet"),36230,954,1007,21,43.48,1.86667,46.5333,227,382),
(36,new String'("Ségry"),36100,519,465,15,33.06,2.08333,46.8833,130,176),
(36,new String'("Néret"),36400,217,208,11,19.05,2.15,46.5667,219,282),
(36,new String'("Villegongis"),36110,136,101,7,18.15,1.58333,46.9,141,196),
(36,new String'("Saint-Civran"),36170,177,154,15,11.61,1.4,46.5,133,241),
(36,new String'("Saint-Aubin"),36100,198,169,6,28.32,2.03333,46.85,142,181),
(36,new String'("Roussines"),36170,354,392,15,22.98,1.38333,46.4667,135,246),
(36,new String'("Villiers"),36290,192,189,7,24.53,1.185,46.8873,99,152),
(36,new String'("Diors"),36130,712,675,27,25.44,1.81667,46.8167,149,167),
(36,new String'("Fontgombault"),36220,267,283,25,10.58,0.983333,46.6833,67,136),
(36,new String'("Sougé"),36500,153,161,11,13.02,1.48333,46.95,120,170),
(36,new String'("Sacierges-Saint-Martin"),36170,312,337,10,31.17,1.36667,46.5,125,224),
(36,new String'("Saint-Aigny"),36300,296,256,19,14.86,1.01667,46.6333,72,141),
(36,new String'("Lignerolles"),36160,118,138,9,13.0,2.13333,46.4833,291,410),
(36,new String'("Rivarennes"),36800,604,545,16,37.41,1.38333,46.6167,88,171),
(36,new String'("Châteauroux"),36000,46140,49598,1806,25.54,1.7,46.8167,132,164),
(36,new String'("Nuret-le-Ferron"),36800,327,315,6,47.29,1.43333,46.6667,108,176),
(36,new String'("Vineuil"),36110,1184,1138,26,44.41,1.63333,46.9,142,186),
(36,new String'("Bommiers"),36120,293,260,10,28.38,1.98528,46.7948,143,204),
(36,new String'("Neuillay-les-Bois"),36500,685,560,14,47.63,1.48333,46.7667,117,154),
(36,new String'("Chaillac"),36310,1118,1170,18,59.79,1.3,46.4333,122,253),
(36,new String'("Urciers"),36160,257,260,13,19.02,2.13333,46.5333,247,363),
(36,new String'("Saint-Gilles"),36170,114,133,14,7.68,1.46667,46.4833,162,259),
(36,new String'("Reuilly"),36260,2078,1962,80,25.8,2.05,47.0833,107,167),
(36,new String'("Sauzelles"),36220,234,231,18,12.86,1.0,46.65,72,134),
(36,new String'("Neuvy-Pailloux"),36100,1309,1158,31,41.81,1.85,46.8833,140,174),
(36,new String'("Sazeray"),36160,331,319,14,22.69,2.05,46.4333,260,432),
(36,new String'("Chassignolles"),36400,589,543,19,29.94,1.93333,46.5333,204,376),
(36,new String'("Chabris"),36210,2790,2656,67,41.22,1.65,47.25,72,134),
(36,new String'("Saint-Genou"),36500,1016,1038,41,24.41,1.33333,46.9333,97,167),
(36,new String'("Le Pêchereau"),36200,1968,1885,93,20.94,1.55,46.5833,103,256),
(36,new String'("Condé"),36100,229,231,9,23.82,1.98583,46.8789,130,168),
(36,new String'("Le Magny"),36400,1034,858,57,17.84,1.96667,46.55,207,294),
(36,new String'("Mézières-en-Brenne"),36290,1076,1159,18,57.57,1.21667,46.8167,84,138),
(36,new String'("Mosnay"),36200,477,439,18,25.28,1.6,46.6167,116,227),
(36,new String'("Lye"),36600,823,803,33,24.77,1.48333,47.2167,76,136),
(36,new String'("Dunet"),36310,111,106,12,9.24,1.3,46.4667,112,199),
(36,new String'("Vatan"),36150,2063,1971,69,29.8,1.81667,47.0667,118,201),
(36,new String'("Anjouin"),36210,344,339,11,28.91,1.78333,47.2,94,151),
(36,new String'("Méobecq"),36500,366,362,10,35.56,1.41667,46.7333,110,137),
(36,new String'("Paudy"),36260,466,435,15,30.28,1.91667,47.0333,139,187),
(36,new String'("Néons-sur-Creuse"),36220,399,389,20,19.85,0.916667,46.7333,59,132),
(36,new String'("Saint-Cyran-du-Jambot"),36700,205,181,14,14.21,1.13333,47.0167,79,143),
(36,new String'("Saint-Aoustrille"),36100,177,159,9,19.47,1.93333,46.9333,127,163),
(36,new String'("Buxeuil"),36150,220,227,11,19.75,1.68333,47.1333,97,161),
(36,new String'("Sainte-Fauste"),36100,299,253,12,23.07,1.86667,46.85,142,168),
(36,new String'("Arthon"),36330,1183,995,25,46.8,1.7,46.6833,132,184),
(36,new String'("Saint-Pierre-de-Jards"),36260,117,137,6,18.01,1.98333,47.1,114,154),
(36,new String'("Argy"),36500,617,614,15,38.89,1.43333,46.9333,106,182),
(36,new String'("Mouhers"),36340,249,250,13,17.89,1.78333,46.5667,190,293),
(36,new String'("Saint-Août"),36120,881,814,16,54.11,1.96667,46.7167,162,261),
(36,new String'("Jeu-Maloches"),36240,131,121,10,12.73,1.45,47.0333,127,189),
(36,new String'("Saint-Martin-de-Lamps"),36110,170,146,10,15.61,1.51667,46.9833,133,179),
(36,new String'("Gehée"),36240,270,301,11,22.75,1.5,47.0333,112,178),
(36,new String'("Meunet-Planches"),36100,194,140,7,26.73,1.95,46.8167,132,174),
(36,new String'("Le Menoux"),36200,461,420,82,5.58,1.56667,46.55,108,267),
(36,new String'("La Buxerette"),36140,109,128,9,10.99,1.8,46.5,282,387),
(36,new String'("Sembleçay"),36210,104,106,12,8.08,1.66667,47.2167,81,123),
(36,new String'("Villedieu-sur-Indre"),36320,2744,2339,47,57.77,1.53333,46.85,110,163),
(36,new String'("Bordes"),36100,925,940,56,16.3,1.97583,46.9806,123,164),
(36,new String'("Bélâbre"),36370,1020,1028,25,40.14,1.16667,46.55,95,156),
(36,new String'("Lignac"),36370,558,572,8,67.03,1.21667,46.4667,104,197),
(36,new String'("Montchevrier"),36140,496,537,14,34.7,1.75,46.4833,230,397),
(36,new String'("Châtillon-sur-Indre"),36700,2828,3120,62,45.3,1.16667,46.9833,82,148),
(36,new String'("Gournay"),36230,330,283,16,20.33,1.73333,46.5833,171,252),
(36,new String'("La Pérouille"),36350,432,334,20,21.54,1.51667,46.6833,131,177),
(36,new String'("Le Poinçonnet"),36330,5829,5021,129,45.0,1.71667,46.7667,145,186),
(36,new String'("Pouligny-Saint-Pierre"),36300,1056,978,22,47.45,1.03333,46.6833,72,143),
(36,new String'("Montgivray"),36400,1705,1681,66,25.48,1.98333,46.6,187,253),
(36,new String'("Saint-Hilaire-sur-Benaize"),36370,358,303,10,32.61,1.08333,46.5667,82,146),
(36,new String'("Éguzon-Chantôme"),36270,1337,1373,36,36.44,1.5825,46.4423,142,319),
(36,new String'("Saint-Marcel"),36200,1552,1644,86,17.84,1.51667,46.6,98,178),
(36,new String'("Lizeray"),36100,101,100,2,35.41,1.9,46.9667,140,188),
(36,new String'("Montlevicq"),36400,102,116,5,18.79,2.07,46.5773,207,263),
(36,new String'("Parpeçay"),36210,248,244,17,14.55,1.65,47.2,82,118),
(36,new String'("Mouhet"),36170,512,479,15,32.26,1.43333,46.3833,237,344),
(36,new String'("Azay-le-Ferron"),36290,912,991,14,60.95,1.06667,46.85,77,143),
(36,new String'("Brion"),36110,501,440,11,44.2,1.73333,46.95,158,222),
(36,new String'("Mers-sur-Indre"),36230,622,584,24,25.45,1.88333,46.65,164,246),
(36,new String'("Celon"),36200,403,381,23,17.04,1.5,46.5167,117,249),
(36,new String'("Chalais"),36370,169,165,4,39.65,1.2,46.5333,95,161),
(36,new String'("Ménétréols-sous-Vatan"),36150,124,124,4,27.83,1.85,47.0167,164,221),
(36,new String'("Beaulieu"),36310,80,95,10,7.48,1.30722,46.3867,187,237),
(36,new String'("Frédille"),36180,66,74,10,6.31,1.46667,47.0,120,172),
(36,new String'("Liniez"),36150,338,305,12,26.94,1.75,47.0167,139,216),
(36,new String'("Sainte-Lizaigne"),36260,1240,1160,47,26.36,2.01667,47.0,115,171),
(36,new String'("Vijon"),36160,308,323,14,21.26,2.11667,46.4333,299,454),
(36,new String'("Clion"),36700,1118,1155,33,33.53,1.23333,46.9333,86,153),
(36,new String'("Coings"),36130,852,814,29,29.33,1.71667,46.8833,145,171),
(36,new String'("Montierchaume"),36130,1688,1758,45,37.2,1.76667,46.8667,144,169),
(36,new String'("Le Pont-Chrétien-Chabenet"),36800,966,881,106,9.03,1.46667,46.6167,96,178),
(36,new String'("Arpheuilles"),36700,242,254,10,22.49,1.26667,46.9,93,143),
(36,new String'("Giroux"),36150,126,117,5,23.48,1.9,47.0667,133,181),
(36,new String'("Rosnay"),36300,578,526,9,59.03,1.21667,46.7,87,133),
(36,new String'("Poulaines"),36210,878,836,18,46.32,1.66667,47.15,87,156),
(36,new String'("Saint-Gaultier"),36800,1883,1934,204,9.2,1.41667,46.6333,91,169),
(36,new String'("Saint-Plantaire"),36190,549,550,16,34.07,1.675,46.4583,197,371),
(36,new String'("Mauvières"),36370,338,310,14,23.94,1.08333,46.5667,84,147),
(36,new String'("Rouvres-les-Bois"),36110,330,361,10,30.85,1.65,47.0667,113,196),
(36,new String'("Argenton-sur-Creuse"),36200,5120,5146,174,29.34,1.51667,46.5833,99,234),
(36,new String'("Tendu"),36200,592,451,14,42.17,1.55,46.6333,107,174),
(36,new String'("Malicornay"),36340,175,196,10,16.31,1.65,46.5833,190,281),
(36,new String'("Ciron"),36300,528,533,9,57.94,1.25,46.6167,78,154),
(36,new String'("Pouligny-Saint-Martin"),36160,237,254,15,15.66,2.0,46.5167,225,342),
(36,new String'("Écueillé"),36240,1313,1411,37,34.9,1.35,47.0833,119,187),
(36,new String'("Luzeret"),36800,147,160,5,26.78,1.4,46.55,128,192),
(36,new String'("Thevet-Saint-Julien"),36400,460,455,14,30.94,2.06667,46.65,187,263),
(36,new String'("Luçay-le-Mâle"),36360,1480,1707,21,68.08,1.43333,47.1167,97,182),
(36,new String'("La Châtre"),36400,4482,4548,739,6.06,1.98333,46.5833,198,263),
(36,new String'("Velles"),36330,919,827,14,63.09,1.65,46.6833,117,184),
(36,new String'("Lacs"),36400,652,615,48,13.46,2.01667,46.5833,203,263),
(36,new String'("Le Blanc"),36300,6968,6995,120,57.61,1.06667,46.6333,72,140),
(36,new String'("Sassierges-Saint-Germain"),36120,469,407,14,31.72,1.9,46.7667,148,217),
(36,new String'("Chazelet"),36170,118,146,10,11.73,1.45,46.5167,141,237),
(36,new String'("Chavin"),36200,283,301,20,14.01,1.61667,46.5667,154,276),
(36,new String'("Baraize"),36270,319,301,19,16.39,1.56667,46.4833,123,292),
(36,new String'("Menetou-sur-Nahon"),36210,121,113,17,6.98,1.65,47.2167,79,116),
(36,new String'("Migny"),36260,119,99,8,13.35,2.06667,47.0167,112,153),
(36,new String'("Lurais"),36220,231,237,16,13.61,0.95,46.7,67,134),
(36,new String'("Ambrault"),36120,917,714,35,25.59,1.96667,46.7833,143,206),
(36,new String'("Meunet-sur-Vatan"),36150,197,176,15,12.47,1.85,47.0833,109,156),
(36,new String'("Champillet"),36160,154,154,22,6.94,2.11667,46.55,224,289),
(36,new String'("Étrechet"),36120,887,802,49,17.89,1.76667,46.7667,145,167),
(36,new String'("Migné"),36800,277,296,4,56.32,1.31667,46.7167,96,138),
(36,new String'("Pouligny-Notre-Dame"),36160,615,605,18,33.75,2.01667,46.4833,239,456),
(36,new String'("Lys-Saint-Georges"),36230,246,213,18,12.98,1.82333,46.642,156,224),
(36,new String'("Feusines"),36160,203,192,16,12.49,2.1,46.5167,253,361),
(36,new String'("Vicq-sur-Nahon"),36600,768,778,15,49.08,1.53333,47.1,101,191),
(36,new String'("Badecon-le-Pin"),36200,762,697,77,9.88,1.58333,46.5167,111,259),
(36,new String'("Préaux"),36240,162,184,4,32.54,1.28333,47.0167,124,194),
(36,new String'("Ruffec"),36300,636,525,15,40.93,1.16667,46.6333,77,141),
(36,new String'("Lureuil"),36220,268,287,12,22.04,1.03333,46.75,90,151),
(36,new String'("Palluau-sur-Indre"),36500,770,830,18,41.55,1.31667,46.95,91,196),
(36,new String'("Pérassay"),36160,387,443,15,24.19,2.15,46.4667,268,422),
(36,new String'("Sainte-Sévère-sur-Indre"),36160,840,899,32,26.03,2.06667,46.4833,222,342),
(36,new String'("Prissac"),36370,670,738,10,62.83,1.31667,46.5167,105,199),
(36,new String'("Sarzay"),36230,328,300,17,18.3,1.9,46.6,183,256),
(36,new String'("Saint-Christophe-en-Bazelle"),36210,381,373,27,13.94,1.71667,47.1833,97,135),
(36,new String'("La Chapelle-Saint-Laurian"),36150,134,141,13,9.82,1.78333,47.05,125,174),
(36,new String'("Saint-Valentin"),36100,278,276,11,24.9,1.86667,46.95,140,207),
(36,new String'("Saint-Christophe-en-Boucherie"),36400,247,246,9,26.89,2.12111,46.6781,191,274),
(36,new String'("Heugnes"),36180,388,436,9,42.17,1.40889,47.012,133,201),
(36,new String'("Chitray"),36800,165,143,8,19.94,1.36667,46.6167,87,152),
(36,new String'("Orville"),36210,128,120,13,9.35,1.79111,47.1523,97,152),
(36,new String'("Luant"),36350,1394,1279,44,31.06,1.55,46.7333,129,181),
(36,new String'("Moulins-sur-Céphons"),36110,326,320,10,32.17,1.55,47.0167,117,203),
(36,new String'("Chouday"),36100,162,153,5,30.0,2.06667,46.9167,136,164),
(36,new String'("Lingé"),36220,252,238,7,32.66,1.08333,46.75,77,147),
(36,new String'("La Champenoise"),36100,315,250,7,44.34,1.8,46.9333,152,216),
(36,new String'("Oulches"),36800,417,374,9,43.36,1.3,46.6167,84,163),
(36,new String'("Parnac"),36170,519,562,11,46.75,1.45,46.45,182,317),
(36,new String'("Lourdoueix-Saint-Michel"),36140,350,426,17,19.67,1.73333,46.4333,245,382),
(36,new String'("Crevant"),36140,739,713,20,36.54,2.51667,46.3667,272,467),
(36,new String'("Saint-Michel-en-Brenne"),36290,325,308,6,49.15,1.16667,46.8,76,111),
(36,new String'("Verneuil-sur-Igneraie"),36400,345,327,35,9.84,2.01667,46.65,182,259),
(36,new String'("Pruniers"),36120,543,416,11,49.0,2.05139,46.7889,151,200),
(36,new String'("La Chapelle-Orthemale"),36500,126,95,7,16.8,1.45,46.8333,111,151),
(36,new String'("Concremiers"),36300,644,611,22,28.11,1.01667,46.6,77,131),
(36,new String'("Saint-Maur"),36250,3268,3340,46,70.31,1.63333,46.8,127,184),
(36,new String'("Luçay-le-Libre"),36150,119,102,10,11.85,1.9,47.0833,119,157),
(36,new String'("Mâron"),36120,734,677,26,27.84,1.86667,46.8,147,171),
(36,new String'("Saint-Florentin"),36150,503,451,31,15.95,1.78333,47.0667,118,162),
(36,new String'("Levroux"),36110,2834,2913,50,56.43,1.61667,46.9833,125,190),
(36,new String'("Nohant-Vic"),36400,477,501,22,21.25,1.96,46.6387,175,261),
(36,new String'("Baudres"),36110,486,495,17,27.4,1.56667,47.05,110,206),
(36,new String'("Saint-Georges-sur-Arnon"),36100,548,431,22,23.87,2.1,47.0,117,161),
(36,new String'("Tilly"),36310,168,189,11,14.77,1.2,46.4167,143,221),
(36,new String'("Ingrandes"),36300,336,318,30,11.12,0.966667,46.6,76,131),
(36,new String'("Sainte-Cécile"),36210,99,99,10,9.5,1.66667,47.1833,88,121),
(36,new String'("Niherne"),36250,1551,1482,36,42.87,1.56667,46.8333,122,163),
(36,new String'("Selles-sur-Nahon"),36180,70,72,10,6.77,1.45,47.0,118,170),
(36,new String'("Saint-Lactencin"),36500,406,353,12,32.2,1.48333,46.8833,116,182),
(37,new String'("Chançay"),37210,1091,949,72,15.04,0.866667,47.45,54,115),
(37,new String'("Bléré"),37150,5213,4578,169,30.8,1.0,47.3333,52,112),
(37,new String'("Truyes"),37320,2094,1728,127,16.39,0.833333,47.2667,57,99),
(37,new String'("Saint-Branchs"),37320,2444,2212,47,51.16,0.766667,47.2333,62,125),
(37,new String'("Savonnières"),37510,3118,2558,189,16.46,0.55,47.35,37,96),
(37,new String'("Saint-Cyr-sur-Loire"),37540,16072,16096,1190,13.5,0.666667,47.4,45,101),
(37,new String'("Ballan-Miré"),37510,8106,7054,309,26.16,0.616667,47.3333,43,99),
(37,new String'("Esvres"),37320,4523,4278,126,35.85,0.783333,47.2833,52,96),
(37,new String'("Amboise"),37530,12846,11461,316,40.65,0.983333,47.4167,52,127),
(37,new String'("Pocé-sur-Cisse"),37530,1628,1582,153,10.61,0.983333,47.4333,52,114),
(37,new String'("La Roche-Clermault"),37500,487,479,27,18.03,0.2,47.15,30,112),
(37,new String'("La Croix-en-Touraine"),37150,2224,1968,147,15.04,0.983333,47.3333,52,117),
(37,new String'("Restigné"),37140,1198,1225,56,21.31,0.233333,47.2833,30,114),
(37,new String'("Beaumont-la-Ronce"),37360,1167,995,29,39.04,0.666667,47.5667,85,175),
(37,new String'("Bourgueil"),37140,3898,4108,118,32.95,0.166667,47.2833,28,117),
(37,new String'("La Chapelle-aux-Naux"),37130,534,496,101,5.25,0.416667,47.3167,36,41),
(37,new String'("Lignières-de-Touraine"),37130,1130,928,113,10.0,0.416667,47.3,36,98),
(37,new String'("Cinq-Mars-la-Pile"),37130,3369,2620,167,20.11,0.466667,47.35,37,101),
(37,new String'("Louans"),37320,601,543,33,18.02,0.75,47.1833,99,126),
(37,new String'("Rilly-sur-Vienne"),37220,465,404,35,13.1,0.483333,47.05,38,124),
(37,new String'("Monthodon"),37110,623,559,18,33.91,0.833333,47.65,115,172),
(37,new String'("Véretz"),37270,4123,3022,297,13.86,0.8,47.3667,47,94),
(37,new String'("Céré-la-Ronde"),37460,446,437,9,49.2,1.18333,47.2667,84,186),
(37,new String'("Villaines-les-Rochers"),37190,981,918,78,12.47,0.5,47.2167,52,116),
(37,new String'("La Chapelle-Blanche-Saint-Martin"),37240,667,519,23,28.5,0.783333,47.0833,67,126),
(37,new String'("Marcilly-sur-Vienne"),37800,561,509,51,10.99,0.533333,47.0333,32,121),
(37,new String'("Manthelan"),37240,1371,1145,34,39.58,0.783333,47.1333,79,128),
(37,new String'("Preuilly-sur-Claise"),37290,1072,1290,89,12.0,0.933333,46.85,67,137),
(37,new String'("Braye-sur-Maulne"),37330,216,205,18,11.84,0.25,47.55,50,121),
(37,new String'("Vernou-sur-Brenne"),37210,2678,2451,103,25.91,0.85,47.4167,47,130),
(37,new String'("Sainte-Maure-de-Touraine"),37800,4096,3908,101,40.41,0.616667,47.1,58,122),
(37,new String'("Loches"),37600,6507,6329,240,27.06,1.0,47.1333,64,147),
(37,new String'("Sainte-Catherine-de-Fierbois"),37800,652,611,42,15.49,0.65,47.15,92,129),
(37,new String'("Saint-Nicolas-de-Bourgueil"),37140,1177,1196,32,36.45,0.116667,47.2833,26,116),
(37,new String'("Montreuil-en-Touraine"),37530,768,642,30,25.09,0.95,47.4833,76,113),
(37,new String'("Thizay"),37500,272,233,39,6.92,0.143056,47.1664,27,100),
(37,new String'("Villedômer"),37110,1339,1135,37,35.49,0.883333,47.55,72,154),
(37,new String'("Parçay-Meslay"),37210,2304,2195,163,14.07,0.75,47.4333,74,122),
(37,new String'("Limeray"),37530,1173,945,81,14.39,1.03333,47.4667,52,116),
(37,new String'("Cangey"),37530,1083,773,47,22.98,1.06667,47.4667,56,114),
(37,new String'("Descartes"),37160,3815,4015,100,38.08,0.697778,46.9737,37,121),
(37,new String'("Antogny-le-Tillac"),37800,532,447,30,17.31,0.578056,46.9642,37,123),
(37,new String'("Saint-Règle"),37530,482,348,74,6.49,1.05,47.4167,62,110),
(37,new String'("Verneuil-sur-Indre"),37600,512,479,12,39.63,1.03333,47.05,73,149),
(37,new String'("Rouziers-de-Touraine"),37360,1223,1037,67,18.19,0.65,47.5167,78,132),
(37,new String'("Notre-Dame-d'Oé"),37390,3998,3330,517,7.73,0.716667,47.45,85,109),
(37,new String'("Tournon-Saint-Pierre"),37290,477,516,32,14.76,0.95367,46.7372,62,136),
(37,new String'("Chinon"),37500,7894,8712,202,39.02,0.25,47.1667,27,112),
(37,new String'("Dierre"),37150,572,495,55,10.27,0.95,47.35,52,115),
(37,new String'("Saint-Senoch"),37600,500,420,20,24.08,0.966667,47.05,98,149),
(37,new String'("Tauxigny"),37310,1242,1090,33,36.83,0.833333,47.2167,67,114),
(37,new String'("Jaulnay"),37120,253,273,17,14.76,0.416667,46.95,65,134),
(37,new String'("Ambillou"),37340,1774,1300,36,48.85,0.45,47.45,68,117),
(37,new String'("Boussay"),37290,248,268,9,27.54,0.883333,46.8333,62,137),
(37,new String'("Sennevières"),37600,223,210,9,23.54,1.08333,47.1,91,149),
(37,new String'("Auzouer-en-Touraine"),37110,2064,1361,60,34.05,0.916667,47.55,72,138),
(37,new String'("Ferrière-Larçon"),37350,273,298,13,20.87,0.883333,46.9833,80,132),
(37,new String'("Saint-Hippolyte"),37600,598,567,18,32.99,1.1,47.05,75,152),
(37,new String'("Larçay"),37270,2391,2035,213,11.19,0.783333,47.3667,46,95),
(37,new String'("Theneuil"),37220,314,294,32,9.8,0.433333,47.0833,34,107),
(37,new String'("Yzeures-sur-Creuse"),37290,1445,1477,26,55.42,0.866667,46.7833,53,139),
(37,new String'("Chaveignes"),37120,572,593,26,21.34,0.35,47.0333,45,117),
(37,new String'("Benais"),37140,937,870,46,20.08,0.216667,47.2833,33,114),
(37,new String'("Saint-Patrice"),37130,677,639,39,17.18,0.316667,47.2833,32,114),
(37,new String'("Loché-sur-Indrois"),37460,505,532,6,74.13,1.21667,47.0833,98,152),
(37,new String'("Candes-Saint-Martin"),37500,221,227,38,5.77,0.083333,47.2167,27,101),
(37,new String'("Rivarennes"),37190,1010,713,53,18.92,0.35,47.2667,36,121),
(37,new String'("Betz-le-Château"),37600,582,595,12,46.88,0.916667,46.9833,91,144),
(37,new String'("Lussault-sur-Loire"),37400,717,692,76,9.36,0.916667,47.4,51,109),
(37,new String'("Trogues"),37220,335,290,35,9.38,0.5,47.1167,32,99),
(37,new String'("Chambray-lès-Tours"),37170,10733,10269,553,19.4,0.716667,47.3333,64,96),
(37,new String'("Saché"),37190,1277,1005,45,28.29,0.55,47.2333,41,113),
(37,new String'("Tours"),37000,134817,132677,3888,34.67,0.683333,47.3833,44,109),
(37,new String'("Beaumont-Village"),37460,258,242,13,19.25,1.2,47.1667,86,144),
(37,new String'("Saint-Roch"),37390,1243,871,261,4.75,0.583333,47.45,78,113),
(37,new String'("Le Petit-Pressigny"),37350,322,366,10,32.05,0.916667,46.9167,71,145),
(37,new String'("Chambourg-sur-Indre"),37310,1281,1190,45,28.39,0.966667,47.1833,62,119),
(37,new String'("Saint-Pierre-des-Corps"),37700,15227,15757,1349,11.28,0.733333,47.3833,46,51),
(37,new String'("Cigogné"),37310,336,308,15,21.79,0.933333,47.25,73,106),
(37,new String'("Couesmes"),37330,531,515,27,19.12,0.35,47.5667,58,128),
(37,new String'("Panzoult"),37220,568,564,16,34.61,0.4,47.1333,27,119),
(37,new String'("Druye"),37190,895,721,39,22.87,0.516667,47.3167,69,101),
(37,new String'("Joué-lès-Tours"),37300,35976,36511,1110,32.41,0.666667,47.35,44,96),
(37,new String'("Marçay"),37500,463,451,21,21.35,0.216667,47.1,37,97),
(37,new String'("Azay-le-Rideau"),37190,3435,3106,125,27.34,0.466667,47.2667,36,102),
(37,new String'("Ports"),37800,358,347,32,11.01,0.55,47.0167,32,123),
(37,new String'("Saint-Michel-sur-Loire"),37130,629,509,35,17.51,0.35,47.3167,32,108),
(37,new String'("Charentilly"),37390,1094,987,77,14.13,0.616667,47.4667,73,122),
(37,new String'("Saint-Paterne-Racan"),37370,1676,1511,35,47.77,0.483333,47.6,65,133),
(37,new String'("Champigny-sur-Veude"),37120,865,881,53,16.18,0.316667,47.0667,39,107),
(37,new String'("Bossée"),37240,340,334,17,19.01,0.733333,47.1,104,121),
(37,new String'("Mettray"),37390,2104,2027,203,10.34,0.65,47.45,57,100),
(37,new String'("Villiers-au-Bouin"),37330,797,602,26,29.83,0.316667,47.5667,52,114),
(37,new String'("Artannes-sur-Indre"),37260,2480,2185,118,20.97,0.6,47.2667,47,98),
(37,new String'("Ingrandes-de-Touraine"),37140,501,470,52,9.46,0.266667,47.2833,33,113),
(37,new String'("Rivière"),37500,702,625,191,3.66,0.266667,47.15,28,107),
(37,new String'("Monts"),37260,6962,6512,255,27.28,0.616667,47.2833,47,99),
(37,new String'("Le Boulay"),37110,694,493,34,20.1,0.857778,47.6059,87,166),
(37,new String'("Genillé"),37460,1582,1423,25,63.12,1.1,47.1833,71,144),
(37,new String'("Marcilly-sur-Maulne"),37330,225,237,15,14.6,0.25,47.55,47,121),
(37,new String'("Chanceaux-près-Loches"),37600,148,143,10,14.58,0.933333,47.15,75,133),
(37,new String'("Rochecorbon"),37210,3311,2982,197,16.78,0.75,47.4167,47,124),
(37,new String'("Villandry"),37510,1071,920,60,17.8,0.516667,47.3333,38,97),
(37,new String'("Sorigny"),37250,2203,1911,50,43.43,0.7,47.2333,68,123),
(37,new String'("Autrèche"),37110,394,400,19,20.72,1.0,47.5333,82,122),
(37,new String'("Marray"),37370,410,337,17,23.81,0.700833,47.6212,89,182),
(37,new String'("Montrésor"),37460,338,395,344,0.98,1.2,47.15,87,121),
(37,new String'("Le Liège"),37460,345,227,30,11.15,1.1,47.2167,93,141),
(37,new String'("Crissay-sur-Manse"),37220,118,119,15,7.5,0.483333,47.1333,44,120),
(37,new String'("Thilouze"),37260,1602,1125,47,33.75,0.583333,47.2167,53,114),
(37,new String'("Assay"),37120,173,174,11,14.53,0.29,47.0745,38,92),
(37,new String'("Saint-Christophe-sur-le-Nais"),37370,1087,964,59,18.27,0.483333,47.6167,52,127),
(37,new String'("Barrou"),37350,501,482,16,30.71,0.766667,46.8667,47,146),
(37,new String'("Château-la-Vallière"),37330,1650,1533,75,21.94,0.316667,47.55,58,110),
(37,new String'("Marigny-Marmande"),37120,605,621,19,30.83,0.483333,46.9833,54,134),
(37,new String'("Cravant-les-Côteaux"),37500,723,751,18,38.21,0.35,47.15,27,121),
(37,new String'("Verneuil-le-Château"),37120,151,110,17,8.44,0.45,47.0333,58,123),
(37,new String'("Bueil-en-Touraine"),37370,323,366,17,18.06,0.55,47.6448,63,127),
(37,new String'("Civray-sur-Esves"),37160,221,202,16,13.29,0.716667,47.0333,59,119),
(37,new String'("Crotelles"),37380,640,530,40,15.89,0.833333,47.55,95,152),
(37,new String'("Azay-sur-Cher"),37270,2993,2707,130,22.85,0.85,47.35,48,103),
(37,new String'("Chambon"),37290,301,289,16,17.88,0.812222,46.8428,47,136),
(37,new String'("Varennes"),37600,238,210,21,11.07,0.916667,47.0667,86,142),
(37,new String'("Cerelles"),37390,1231,982,100,12.3,0.683333,47.5,62,122),
(37,new String'("Vou"),37240,224,234,10,21.95,0.85,47.0833,81,134),
(37,new String'("Savigné-sur-Lathan"),37340,1367,1047,77,17.61,0.316667,47.45,79,95),
(37,new String'("Courcoué"),37120,264,236,16,15.66,0.383333,47.0333,59,122),
(37,new String'("Saint-Antoine-du-Rocher"),37360,1483,1095,61,24.23,0.633333,47.5,60,127),
(37,new String'("Lémeré"),37120,442,369,22,19.83,0.333333,47.0833,35,115),
(37,new String'("Perrusson"),37600,1538,1418,53,28.94,1.0,47.1,72,149),
(37,new String'("Nouâtre"),37800,881,788,91,9.65,0.55,47.05,32,49),
(37,new String'("L'Île-Bouchard"),37220,1721,1765,494,3.48,0.416667,47.1167,33,65),
(37,new String'("Reignac-sur-Indre"),37310,1231,1068,54,22.44,0.916667,47.2167,60,101),
(37,new String'("Courçay"),37310,834,694,33,24.77,0.866667,47.25,57,99),
(37,new String'("Monnaie"),37380,4011,3305,101,39.42,0.783333,47.5,89,147),
(37,new String'("Chemillé-sur-Dême"),37370,679,575,20,33.54,0.65,47.65,75,164),
(37,new String'("Saint-Germain-sur-Vienne"),37500,376,353,28,13.36,0.1,47.2,27,105),
(37,new String'("La Chapelle-sur-Loire"),37140,1528,1479,79,19.17,0.233333,47.25,27,37),
(37,new String'("Richelieu"),37120,1941,2172,381,5.09,0.316667,47.0167,47,77),
(37,new String'("Château-Renault"),37110,5181,5481,1476,3.51,0.916667,47.5833,83,129),
(37,new String'("Cussay"),37240,586,560,22,25.81,0.8,47.0167,65,124),
(37,new String'("Paulmy"),37350,243,261,9,25.97,0.833333,46.9833,72,127),
(37,new String'("Montlouis-sur-Loire"),37270,10487,9653,427,24.55,0.833333,47.3833,46,97),
(37,new String'("Neuvy-le-Roi"),37370,1156,1108,24,47.5,0.6,47.6,75,128),
(37,new String'("Luzé"),37120,264,263,13,20.3,0.433333,47.0167,65,129),
(37,new String'("Vouvray"),37210,3069,3048,133,22.92,0.8,47.4167,48,121),
(37,new String'("Maillé"),37800,604,653,38,15.67,0.583333,47.05,43,110),
(37,new String'("La Ville-aux-Dames"),37700,4966,4643,620,8.0,0.766667,47.4,46,52),
(37,new String'("Dolus-le-Sec"),37310,685,537,25,27.27,0.9,47.1667,89,127),
(37,new String'("Saint-Avertin"),37550,13947,14094,1052,13.25,0.733333,47.3667,46,98),
(37,new String'("Sublaines"),37310,178,159,12,14.44,1.0,47.2667,87,117),
(37,new String'("Épeigné-les-Bois"),37150,436,376,30,14.52,1.1,47.3,71,141),
(37,new String'("Huismes"),37420,1536,1388,64,23.82,0.25,47.2333,31,118),
(37,new String'("Bréhémont"),37130,793,716,62,12.71,0.35,47.3,32,40),
(37,new String'("Parçay-sur-Vienne"),37220,655,530,34,18.74,0.466667,47.1,32,115),
(37,new String'("Chédigny"),37310,546,435,23,23.17,1.0,47.2,62,110),
(37,new String'("Reugny"),37380,1582,1417,53,29.72,0.883333,47.4833,60,133),
(37,new String'("Lerné"),37500,319,312,19,16.36,0.133333,47.15,43,117),
(37,new String'("Épeigné-sur-Dême"),37370,159,145,7,21.08,0.616667,47.6667,66,128),
(37,new String'("Saint-Épain"),37800,1544,1419,24,62.65,0.533333,47.1333,47,122),
(37,new String'("Francueil"),37150,1297,946,100,12.91,1.08333,47.3167,54,117),
(37,new String'("Chezelles"),37220,137,130,9,15.17,0.433333,47.05,45,122),
(37,new String'("Beaulieu-lès-Loches"),37600,1759,1720,453,3.88,1.01667,47.1167,68,121),
(37,new String'("Braye-sous-Faye"),37120,325,368,20,15.67,0.35,47.0,54,102),
(37,new String'("Saint-Benoît-la-Forêt"),37500,882,766,25,35.25,0.316667,47.2167,50,119),
(37,new String'("Saint-Étienne-de-Chigny"),37230,1426,1323,67,21.11,0.533333,47.3833,37,108),
(37,new String'("Villeperdue"),37260,978,820,81,11.95,0.633333,47.2,93,118),
(37,new String'("Neuillé-Pont-Pierre"),37360,1951,1765,50,39.0,0.55,47.55,75,135),
(37,new String'("Mazières-de-Touraine"),37130,1303,1022,38,34.18,0.433333,47.3833,52,109),
(37,new String'("Anché"),37500,431,365,53,7.99,0.3,47.1333,28,87),
(37,new String'("Couziers"),37500,113,102,9,12.05,0.083333,47.15,29,115),
(37,new String'("Mosnes"),37530,742,737,51,14.5,1.1,47.45,55,114),
(37,new String'("Cléré-les-Pins"),37340,1304,1165,36,35.62,0.4,47.4167,80,111),
(37,new String'("Noizay"),37210,1155,1156,66,17.47,0.9,47.4167,48,114),
(37,new String'("Nouzilly"),37380,1239,1106,30,40.24,0.75,47.55,75,164),
(37,new String'("Fondettes"),37230,10377,8918,326,31.83,0.6,47.4,42,100),
(37,new String'("Neuillé-le-Lierre"),37380,765,582,46,16.63,0.916667,47.5167,65,122),
(37,new String'("Saint-Quentin-sur-Indrois"),37310,492,429,18,27.23,1.02361,47.2037,65,127),
(37,new String'("Athée-sur-Cher"),37270,2501,2016,72,34.47,0.916667,47.3167,49,104),
(37,new String'("Le Louroux"),37240,473,425,16,28.87,0.783333,47.1667,79,127),
(37,new String'("Savigny-en-Véron"),37420,1453,1272,68,21.31,0.15,47.2,27,43),
(37,new String'("Faye-la-Vineuse"),37120,295,285,16,17.55,0.333333,46.95,62,131),
(37,new String'("Langeais"),37130,4029,3868,66,60.38,0.4,47.3333,36,109),
(37,new String'("Rillé"),37340,307,272,12,23.96,0.25,47.45,67,119),
(37,new String'("Villeloin-Coulangé"),37460,649,618,18,34.62,1.23333,47.1333,92,144),
(37,new String'("Pussigny"),37800,190,184,22,8.48,0.566667,46.9833,37,114),
(37,new String'("Civray-de-Touraine"),37150,1815,1523,79,22.88,1.06667,47.3333,46,129),
(37,new String'("La Guerche"),37350,199,229,37,5.27,0.733333,46.8833,43,67),
(37,new String'("Rigny-Ussé"),37420,532,506,38,13.97,0.3,47.25,31,117),
(37,new String'("La Membrolle-sur-Choisille"),37390,3009,2926,437,6.87,0.639444,47.4381,51,94),
(37,new String'("Courcelles-de-Touraine"),37330,482,325,18,25.71,0.3,47.4833,79,110),
(37,new String'("Nazelles-Négron"),37530,3522,3635,157,22.32,0.953333,47.4323,51,114),
(37,new String'("Ciran"),37240,440,364,31,13.86,0.866667,47.0667,77,131),
(37,new String'("Saint-Martin-le-Beau"),37270,2902,2466,157,18.44,0.916667,47.35,49,108),
(37,new String'("Veigné"),37250,6091,5473,229,26.58,0.733333,47.2833,51,94),
(37,new String'("Luzillé"),37150,894,778,21,40.68,1.06667,47.2667,68,132),
(37,new String'("Saint-Ouen-les-Vignes"),37530,1031,941,55,18.55,1.0,47.4667,63,116),
(37,new String'("Mouzay"),37600,486,464,20,23.71,0.883333,47.0833,92,146),
(37,new String'("Avon-les-Roches"),37220,549,520,16,33.28,0.45,47.15,38,119),
(37,new String'("Brèches"),37330,284,255,24,11.63,0.383333,47.5667,74,133),
(37,new String'("Sonzay"),37360,1294,1100,26,48.34,0.466667,47.5333,78,139),
(37,new String'("Hermites"),37110,568,538,17,32.6,0.75,47.6667,96,167),
(37,new String'("Braslou"),37120,320,326,20,15.79,0.383333,47.0,56,131),
(37,new String'("Azay-sur-Indre"),37310,382,355,27,13.89,0.95,47.2,61,106),
(37,new String'("Ligueil"),37240,2222,2162,74,29.72,0.816667,47.0333,66,128),
(37,new String'("Charnizay"),37290,496,524,9,51.71,0.983333,46.9167,84,147),
(37,new String'("Cheillé"),37190,1657,1283,35,46.26,0.416667,47.2667,37,120),
(37,new String'("La Celle-Guenand"),37350,395,362,10,36.7,0.9,46.9333,70,144),
(37,new String'("Cormery"),37320,1653,1540,272,6.07,0.85,47.2667,57,94),
(37,new String'("Chenonceaux"),37150,356,326,82,4.33,1.06667,47.3333,54,129),
(37,new String'("Marcé-sur-Esves"),37160,236,227,21,10.99,0.65,47.0167,50,112),
(37,new String'("Brizay"),37220,339,287,23,14.27,0.4,47.1,39,116),
(37,new String'("Luynes"),37230,5078,4502,149,34.01,0.55,47.3833,39,105),
(37,new String'("Neuilly-le-Brignon"),37160,311,308,14,22.0,0.783333,46.9667,62,124),
(37,new String'("Draché"),37800,706,635,38,18.51,0.616667,47.05,56,112),
(37,new String'("Abilly"),37160,1121,1106,37,30.27,0.727778,46.9412,42,123),
(37,new String'("Souvigné"),37330,779,554,31,24.41,0.4,47.5167,76,126),
(37,new String'("Saint-Laurent-en-Gâtines"),37380,933,730,29,31.62,0.783333,47.5833,110,171),
(37,new String'("Crouzilles"),37220,567,519,38,14.54,0.45,47.1167,32,102),
(37,new String'("La Ferrière"),37110,292,214,18,15.76,0.746944,47.6284,118,170),
(37,new String'("Louestault"),37370,366,290,22,16.45,0.65,47.6167,85,180),
(37,new String'("Dame-Marie-les-Bois"),37110,313,275,35,8.91,1.03333,47.5333,93,131),
(37,new String'("La Celle-Saint-Avant"),37160,1038,1084,58,17.8,0.6,47.0167,37,103),
(37,new String'("Souvigny-de-Touraine"),37530,372,366,14,26.18,1.08333,47.4167,72,133),
(37,new String'("Gizeux"),37340,449,427,21,21.06,0.2,47.4,47,108),
(37,new String'("Chargé"),37530,1159,946,136,8.46,1.03333,47.4333,52,112),
(37,new String'("Saint-Laurent-de-Lin"),37330,300,234,21,13.86,0.25,47.5,64,119),
(37,new String'("Villedômain"),37460,131,122,7,16.47,1.25,47.05,116,163),
(37,new String'("Semblançay"),37360,2082,1692,58,35.66,0.583333,47.5,92,134),
(37,new String'("Bossay-sur-Claise"),37290,826,786,12,65.56,0.95,46.8333,67,144),
(37,new String'("Saunay"),37110,658,507,25,25.98,0.966667,47.6,92,147),
(37,new String'("Pernay"),37230,1055,865,59,17.61,0.5,47.45,60,119),
(37,new String'("Sepmes"),37800,663,646,23,28.59,0.666667,47.0667,60,119),
(37,new String'("Cinais"),37500,446,439,50,8.77,0.166667,47.15,29,107),
(37,new String'("Montbazon"),37250,3933,3433,605,6.5,0.716667,47.2833,52,92),
(37,new String'("Tavant"),37220,262,238,50,5.22,0.383333,47.1167,28,82),
(37,new String'("Hommes"),37340,900,664,30,29.59,0.3,47.4333,75,93),
(37,new String'("Lublé"),37330,139,125,11,12.6,0.25,47.5167,57,118),
(37,new String'("Continvoir"),37340,467,449,11,41.19,0.216667,47.3833,47,109),
(37,new String'("Esves-le-Moutier"),37240,145,164,13,10.53,0.9,47.0333,86,132),
(37,new String'("Chaumussay"),37350,249,262,13,19.15,0.85,46.8667,60,135),
(37,new String'("Nouans-les-Fontaines"),37460,791,789,12,63.31,1.3,47.1333,101,162),
(37,new String'("Pouzay"),37800,828,755,58,14.07,0.533333,47.0833,32,99),
(37,new String'("Beaumont-en-Véron"),37420,2793,2758,148,18.83,0.183333,47.2,28,81),
(37,new String'("Morand"),37110,328,235,22,14.62,1.01667,47.5667,104,147),
(37,new String'("La Tour-Saint-Gelin"),37120,548,534,40,13.45,0.383333,47.05,63,117),
(37,new String'("Saint-Genouph"),37510,1028,940,216,4.74,0.6,47.3833,42,49),
(37,new String'("Chouzé-sur-Loire"),37140,2071,2094,73,28.04,0.133333,47.25,25,36),
(37,new String'("Razines"),37120,240,246,16,14.73,0.366667,46.9667,56,134),
(37,new String'("Essards"),37130,155,153,37,4.17,0.301944,47.3453,52,105),
(37,new String'("Avrillé-les-Ponceaux"),37340,449,384,13,32.8,0.283333,47.4,57,95),
(37,new String'("La Riche"),37520,10080,8599,1233,8.17,0.65,47.3833,43,51),
(37,new String'("Seuilly"),37500,368,369,23,15.73,0.166667,47.15,35,111),
(37,new String'("Neuil"),37190,439,369,23,18.82,0.5,47.1667,60,117),
(37,new String'("Berthenay"),37510,742,675,102,7.24,0.516667,47.3667,37,45),
(37,new String'("Vallères"),37190,1128,779,76,14.72,0.466667,47.3167,37,97),
(37,new String'("Chisseaux"),37150,637,575,53,11.8,1.08333,47.3333,54,136),
(37,new String'("Le Grand-Pressigny"),37350,997,1117,25,39.55,0.8,46.9167,52,135),
(37,new String'("Pont-de-Ruan"),37260,871,596,151,5.74,0.583333,47.25,46,94),
(37,new String'("Noyant-de-Touraine"),37800,991,646,72,13.74,0.55,47.1,51,103),
(37,new String'("Sazilly"),37220,254,231,24,10.57,0.333333,47.1333,27,87),
(37,new String'("Chemillé-sur-Indrois"),37460,226,197,9,24.87,1.16667,47.15,82,142),
(37,new String'("Saint-Nicolas-des-Motets"),37110,265,224,20,12.77,1.03333,47.5833,108,151),
(37,new String'("Channay-sur-Lathan"),37330,817,595,28,28.71,0.266667,47.4833,71,91),
(37,new String'("Avoine"),37420,1834,1778,145,12.58,0.183333,47.2,29,42),
(37,new String'("Orbigny"),37460,756,726,11,65.88,1.23333,47.2,98,182),
(37,new String'("Villebourg"),37370,281,259,22,12.36,0.533333,47.65,57,127),
(37,new String'("Ferrière-sur-Beaulieu"),37600,735,563,37,19.63,1.03333,47.1333,75,144),
(37,new String'("Ligré"),37500,1029,966,37,27.7,0.266667,47.1167,31,111),
(37,new String'("Saint-Aubin-le-Dépeint"),37370,325,329,21,15.19,0.383333,47.6333,60,133),
(37,new String'("Saint-Flovier"),37600,603,605,20,29.22,1.03333,46.95,102,146),
(37,new String'("Saint-Jean-Saint-Germain"),37600,723,602,33,21.34,1.03333,47.0833,72,147),
(37,new String'("Bournan"),37240,265,215,18,14.67,0.733333,47.0667,62,121),
(37,new String'("Chanceaux-sur-Choisille"),37390,3586,2822,194,18.47,0.7,47.4667,62,121),
(37,new String'("Bridoré"),37600,552,475,37,14.54,1.08333,47.0167,76,144),
(37,new String'("Neuville-sur-Brenne"),37110,802,623,116,6.89,0.908333,47.6192,87,146),
(37,new String'("Saint-Bauld"),37310,204,168,49,4.11,0.833333,47.1833,77,103),
(38,new String'("Voiron"),38500,19893,19799,908,21.9,5.58333,45.3667,222,846),
(38,new String'("Réaumont"),38140,964,791,194,4.95,5.51667,45.3667,309,436),
(38,new String'("La Terrasse"),38660,2374,1913,250,9.47,5.93333,45.3333,229,1045),
(38,new String'("Le Périer"),38740,141,126,2,47.99,5.96667,44.9333,815,2992),
(38,new String'("Nantoin"),38260,439,321,46,9.5,5.26667,45.4333,430,609),
(38,new String'("Saint-Vincent-de-Mercuze"),38660,1408,1361,179,7.85,5.95,45.3667,238,863),
(38,new String'("Saint-Laurent-en-Beaumont"),38350,444,370,33,13.15,5.85,44.8833,557,1492),
(38,new String'("Frontonas"),38290,1931,1702,152,12.65,5.18333,45.65,207,401),
(38,new String'("Massieu"),38620,762,688,72,10.46,5.58333,45.4333,422,867),
(38,new String'("Le Bouchage"),38510,582,462,51,11.2,5.53333,45.6667,207,210),
(38,new String'("Beaurepaire"),38270,4620,3837,250,18.46,5.05,45.3333,225,315),
(38,new String'("La Chapelle-de-Surieu"),38150,686,477,61,11.22,4.9,45.4,252,407),
(38,new String'("Clavans-en-Haut-Oisans"),38142,113,83,7,15.58,6.15,45.0667,1024,3464),
(38,new String'("Cras"),38210,467,325,86,5.43,5.45,45.2667,280,773),
(38,new String'("Beaulieu"),38470,626,514,71,8.79,5.38333,45.2,160,355),
(38,new String'("Le Péage-de-Roussillon"),38550,6751,6338,911,7.41,4.8,45.3667,134,263),
(38,new String'("La Bâtie-Divisin"),38490,897,802,85,10.51,5.6,45.5,360,615),
(38,new String'("Montbonnot-Saint-Martin"),38330,4651,3828,728,6.38,5.8,45.2333,215,356),
(38,new String'("Le Pin"),38730,1231,977,128,9.6,5.5,45.45,487,767),
(38,new String'("Autrans"),38880,1702,1544,38,44.02,5.55,45.1667,1005,1711),
(38,new String'("Saint-Pierre-de-Méaroz"),38350,137,104,29,4.64,5.81667,44.8833,508,868),
(38,new String'("Colombe"),38690,1439,1430,108,13.23,5.45,45.4,448,738),
(38,new String'("Treffort"),38650,245,129,22,10.99,5.65806,44.9156,486,1070),
(38,new String'("Leyrieu"),38460,724,643,113,6.39,5.25,45.75,203,420),
(38,new String'("Saint-Martin-d'Hères"),38400,36177,35769,3906,9.26,5.76667,45.1667,206,610),
(38,new String'("Viriville"),38980,1545,1208,50,30.46,5.2,45.3167,306,606),
(38,new String'("Sainte-Agnès"),38190,537,457,19,26.85,5.91667,45.2333,270,2969),
(38,new String'("Velanne"),38620,495,414,61,8.04,5.63333,45.4833,380,641),
(38,new String'("Notre-Dame-de-Vaulx"),38144,542,494,68,7.88,5.75,44.9833,877,1712),
(38,new String'("Cornillon-en-Trièves"),38710,173,137,12,13.92,5.7,44.8333,493,1106),
(38,new String'("Quet-en-Beaumont"),38970,64,49,7,8.1,5.86667,44.8333,581,1664),
(38,new String'("Ambel"),38970,23,22,4,4.83,5.93333,44.8167,735,1596),
(38,new String'("Vignieu"),38890,907,705,96,9.4,5.41667,45.6333,220,444),
(38,new String'("Bossieu"),38260,271,277,20,13.48,5.15,45.4167,361,524),
(38,new String'("Oytier-Saint-Oblas"),38780,1581,1353,110,14.3,5.01667,45.5667,232,376),
(38,new String'("Saint-Hilaire"),38660,1532,1248,177,8.61,5.88333,45.3,647,2060),
(38,new String'("Varacieux"),38470,826,644,44,18.48,5.33333,45.2333,326,704),
(38,new String'("Cholonge"),38220,322,229,36,8.92,5.8,45.0,905,2140),
(38,new String'("Goncelin"),38570,2173,1934,151,14.36,5.98333,45.3333,235,1278),
(38,new String'("Coublevie"),38500,4296,3742,609,7.05,5.61667,45.35,250,651),
(38,new String'("Saint-Pierre-d'Entremont"),73670,559,478,17,32.31,5.85389,45.4153,598,2047),
(38,new String'("Brézins"),38590,1759,1325,212,8.26,5.31667,45.35,356,407),
(38,new String'("Sainte-Marie-d'Alloix"),38660,553,569,181,3.04,5.96667,45.3833,242,380),
(38,new String'("Côtes-d'Arey"),38138,1937,1550,79,24.31,4.86695,45.4559,217,409),
(38,new String'("Rovon"),38470,593,532,50,11.82,5.46667,45.2,172,1471),
(38,new String'("Montseveroux"),38122,884,782,53,16.48,4.96667,45.4333,289,452),
(38,new String'("Sablons"),38550,2031,1534,198,10.23,4.76667,45.3167,135,154),
(38,new String'("Saint-Aupre"),38960,1077,875,90,11.93,5.66667,45.3833,436,925),
(38,new String'("Villard-de-Lans"),38250,4034,3799,60,67.2,5.55,45.0667,720,2286),
(38,new String'("Saint-Michel-en-Beaumont"),38350,37,30,4,8.04,5.9,44.8667,958,2020),
(38,new String'("Châtelus"),38680,87,90,7,12.3,5.36667,45.05,229,1269),
(38,new String'("Mottier"),38260,687,511,64,10.72,5.31667,45.4167,448,641),
(38,new String'("Notre-Dame-de-Commiers"),38450,475,377,99,4.79,5.7,45.0167,317,1323),
(38,new String'("Moissieu-sur-Dolon"),38270,701,500,48,14.38,4.98333,45.3833,287,463),
(38,new String'("Lumbin"),38660,1969,1459,290,6.77,5.91667,45.3167,222,880),
(38,new String'("Corps"),38970,511,453,45,11.22,5.95,44.8167,639,1840),
(38,new String'("Charette"),38390,461,281,40,11.26,5.36667,45.8167,240,350),
(38,new String'("Saint-Étienne-de-Saint-Geoirs"),38590,2917,2242,156,18.62,5.35,45.3333,369,545),
(38,new String'("La Buisse"),38500,2814,2406,244,11.53,5.61667,45.3333,184,935),
(38,new String'("Commelle"),38260,794,599,56,14.04,5.21667,45.4167,396,587),
(38,new String'("Saint-Jean-d'Hérans"),38710,297,241,16,17.48,5.76667,44.85,486,1101),
(38,new String'("Notre-Dame-de-l'Osier"),38470,499,393,59,8.38,5.4,45.2333,315,556),
(38,new String'("Burcin"),38690,451,370,67,6.69,5.43333,45.4333,453,734),
(38,new String'("Saint-Barthélemy"),38270,961,761,120,7.98,5.075,45.35,258,326),
(38,new String'("Châteauvilain"),38300,630,484,71,8.82,5.33001,45.5167,345,644),
(38,new String'("Meylan"),38240,17487,18730,1419,12.32,5.78333,45.2333,206,1313),
(38,new String'("Saint-Jean-de-Soudain"),38110,1430,977,191,7.48,5.43333,45.5667,303,471),
(38,new String'("Éparres"),38300,901,917,113,7.95,5.3,45.5333,319,501),
(38,new String'("Voissant"),38620,205,209,52,3.88,5.7,45.4833,269,788),
(38,new String'("Chasselay"),38470,431,341,45,9.45,5.33333,45.25,418,729),
(38,new String'("Sainte-Marie-du-Mont"),38660,238,203,9,23.87,5.93333,45.4,522,1880),
(38,new String'("Monestier-d'Ambel"),38970,23,20,2,11.02,5.93333,44.7833,746,2378),
(38,new String'("Tréminis"),38710,173,172,3,49.4,5.76667,44.75,792,2755),
(38,new String'("Montagnieu"),38110,896,701,101,8.83,5.45,45.5167,380,582),
(38,new String'("Chanas"),38150,2339,1935,200,11.65,4.81667,45.3,142,223),
(38,new String'("Engins"),38360,496,420,24,20.64,5.61667,45.1833,560,1704),
(38,new String'("Chatte"),38160,2406,2445,105,22.81,5.28333,45.15,164,443),
(38,new String'("Charvieu-Chavagneux"),38230,7722,7876,892,8.65,5.16389,45.7456,200,251),
(38,new String'("Pont-de-Chéruy"),38230,5143,4546,2049,2.51,5.18333,45.75,196,236),
(38,new String'("Abrets"),38490,3455,2704,501,6.89,5.58333,45.5333,261,434),
(38,new String'("Saint-Didier-de-Bizonnes"),38690,288,209,40,7.2,5.35,45.45,514,647),
(38,new String'("Saint-Victor-de-Cessieu"),38110,2144,1670,175,12.22,5.4,45.55,310,555),
(38,new String'("Villard-Saint-Christophe"),38119,374,272,26,14.22,5.8,44.9667,940,2176),
(38,new String'("Paladru"),38137,1087,865,93,11.64,5.55,45.4667,488,711),
(38,new String'("Saint-Arey"),38350,79,56,11,6.67,5.73333,44.8667,487,1483),
(38,new String'("Laval"),38190,962,805,37,25.33,5.93333,45.25,320,2600),
(38,new String'("Saint-Théoffrey"),38119,449,340,78,5.75,5.76667,44.9833,905,1240),
(38,new String'("La Verpillière"),38290,6411,5688,965,6.64,5.15,45.6333,205,305),
(38,new String'("Vizille"),38220,7630,7442,725,10.51,5.76667,45.0833,268,1016),
(38,new String'("Saint-Clair-de-la-Tour"),38110,3428,2684,370,9.24,5.48333,45.5667,314,425),
(38,new String'("Jarrie"),38560,3853,4010,290,13.26,5.76667,45.1167,259,733),
(38,new String'("Faverges-de-la-Tour"),38110,1285,1106,167,7.67,5.51667,45.5833,285,432),
(38,new String'("Le Monestier-du-Percy"),38930,239,164,15,14.99,5.65,44.8,597,1896),
(38,new String'("La Tour-du-Pin"),38110,7975,6540,1671,4.77,5.45,45.5667,309,461),
(38,new String'("Beaufin"),38970,22,27,3,6.36,5.95,44.7833,744,2080),
(38,new String'("Lentiol"),38270,215,147,28,7.6,5.11667,45.3,337,479),
(38,new String'("Saint-Martin-de-Vaulserre"),38480,254,206,64,3.92,5.66667,45.4833,320,584),
(38,new String'("Lalley"),38930,210,185,8,23.65,5.68333,44.75,673,2045),
(38,new String'("Lans-en-Vercors"),38250,2557,2037,66,38.67,5.58333,45.1167,902,1960),
(38,new String'("Roussillon"),38150,7964,7438,685,11.62,4.81667,45.3667,146,265),
(38,new String'("Percy"),38930,138,111,8,15.93,5.64973,44.8014,591,1880),
(38,new String'("Saint-Maurice-en-Trièves"),38930,168,163,12,12.94,5.66667,44.75,671,1975),
(38,new String'("Roches-de-Condrieu"),38370,1957,1816,1900,1.03,4.76667,45.45,155,200),
(38,new String'("Morêtel-de-Mailles"),38570,400,303,59,6.71,6.0,45.3667,250,1178),
(38,new String'("Badinières"),38300,606,418,101,5.99,5.3,45.5,396,550),
(38,new String'("Meyrieu-les-Étangs"),38440,868,714,101,8.54,5.20001,45.5137,410,527),
(38,new String'("Noyarey"),38360,2243,2103,133,16.86,5.63333,45.25,191,1649),
(38,new String'("Saint-Ismier"),38330,6381,5922,428,14.9,5.83333,45.25,216,1489),
(38,new String'("Oris-en-Rattier"),38350,111,83,5,18.83,5.86667,44.9167,768,2606),
(38,new String'("Jarcieu"),38270,1036,780,164,6.31,4.95,45.3333,205,248),
(38,new String'("Heyrieux"),38540,4756,4158,340,13.95,5.05,45.6333,259,381),
(38,new String'("Château-Bernard"),38650,280,167,15,18.27,5.58333,44.9833,754,2286),
(38,new String'("Sonnay"),38150,1299,959,91,14.17,4.9,45.35,225,407),
(38,new String'("Fontaine"),38600,22243,23323,3300,6.74,5.66667,45.1833,202,1007),
(38,new String'("Saint-Jean-de-Vaulx"),38220,552,450,51,10.73,5.75,45.0167,890,1631),
(38,new String'("Venon"),38610,722,677,166,4.34,5.8,45.1667,298,921),
(38,new String'("Saint-Julien-de-l'Herms"),38122,144,111,15,9.17,5.1,45.4333,374,507),
(38,new String'("Dolomieu"),38110,2956,2369,221,13.32,5.5,45.6167,260,454),
(38,new String'("Granieu"),38490,447,258,119,3.73,5.58333,45.6,214,311),
(38,new String'("Le Gua"),38450,1887,1716,66,28.48,5.61667,45.0167,340,2161),
(38,new String'("Saint-André-le-Gaz"),38490,2522,1954,283,8.89,5.53333,45.55,356,488),
(38,new String'("Cordéac"),38710,205,193,7,26.62,5.85,44.8333,579,2793),
(38,new String'("Montferrat"),38620,1588,1286,129,12.26,5.58333,45.4833,488,721),
(38,new String'("Sainte-Luce"),38970,40,22,5,7.95,5.91667,44.85,667,1877),
(38,new String'("Valencogne"),38730,603,458,79,7.55,5.53333,45.5,516,680),
(38,new String'("La Flachère"),38530,446,387,156,2.85,5.96306,45.3987,319,920),
(38,new String'("Eyzin-Pinet"),38780,2150,1819,75,28.44,4.98333,45.4667,218,450),
(38,new String'("Longechenal"),38690,570,428,70,8.12,5.33333,45.4167,489,671),
(38,new String'("Saint-Guillaume"),38650,282,270,21,13.33,5.58333,44.95,550,1733),
(38,new String'("Lieudieu"),38440,292,248,49,5.94,5.18333,45.4667,452,543),
(38,new String'("Lavars"),38710,138,113,9,14.8,5.66667,44.85,484,1080),
(38,new String'("Le Touvet"),38660,2977,2822,257,11.56,5.95,45.35,236,1008),
(38,new String'("Saint-Paul-d'Izeaux"),38140,314,295,41,7.63,5.43333,45.3167,458,764),
(38,new String'("La Garde"),38520,114,65,12,9.09,6.04584,45.0689,715,1859),
(38,new String'("Barraux"),38530,1862,1475,167,11.13,5.98333,45.4333,241,950),
(38,new String'("Brion"),38590,130,138,32,3.94,5.33333,45.3,466,724),
(38,new String'("Le Versoud"),38420,4566,3814,719,6.35,5.86667,45.2,216,441),
(38,new String'("Le Pont-de-Beauvoisin"),38480,3453,2500,469,7.36,5.66667,45.5333,239,332),
(38,new String'("Theys"),38570,1992,1571,55,35.77,6.0,45.3,320,2124),
(38,new String'("Saint-Jean-le-Vieux"),38420,243,211,52,4.59,5.88333,45.2083,313,1169),
(38,new String'("La Bâtie-Montgascon"),38110,1771,1433,210,8.43,5.53333,45.5833,314,425),
(38,new String'("Saint-Michel-de-Saint-Geoirs"),38590,293,247,41,7.14,5.36667,45.3,459,728),
(38,new String'("Siccieu-Saint-Julien-et-Carisieu"),38460,581,496,40,14.22,5.31612,45.735,237,417),
(38,new String'("Beaucroissant"),38140,1477,1245,132,11.18,5.46667,45.3333,332,753),
(38,new String'("Domarin"),38300,1415,1427,473,2.99,5.25,45.5833,231,450),
(38,new String'("Champ-sur-Drac"),38560,3136,3262,351,8.92,5.73333,45.0667,259,1281),
(38,new String'("Valencin"),38540,2510,2073,260,9.63,5.01667,45.6167,270,379),
(38,new String'("Besse"),38142,142,130,5,25.46,6.16667,45.0667,1228,3122),
(38,new String'("Saint-Mury-Monteymond"),38190,349,314,31,11.09,5.93333,45.2167,320,2600),
(38,new String'("Échirolles"),38130,35748,32811,4548,7.86,5.71667,45.1333,217,395),
(38,new String'("Champagnier"),38800,1256,961,190,6.61,5.71667,45.1,239,516),
(38,new String'("Saint-Nizier-du-Moucherotte"),38250,1030,804,91,11.26,5.63333,45.1667,863,1897),
(38,new String'("Tencin"),38570,1222,897,181,6.75,5.96667,45.3167,229,1116),
(38,new String'("La Sône"),38840,633,589,214,2.95,5.28333,45.1167,160,270),
(38,new String'("Pommiers-la-Placette"),38340,568,590,33,16.92,5.65,45.3167,344,1849),
(38,new String'("Avenières"),38630,5430,4306,181,30.0,5.56667,45.6333,201,291),
(38,new String'("Revel-Tourdan"),38270,1024,842,88,11.62,5.03333,45.3833,267,444),
(38,new String'("Diémoz"),38790,2626,2241,191,13.72,5.1,45.5833,287,423),
(38,new String'("La Chapelle-de-la-Tour"),38110,1664,1382,184,9.04,5.46667,45.5833,323,453),
(38,new String'("Entre-deux-Guiers"),38380,1766,1476,167,10.55,5.75,45.4333,373,1420),
(38,new String'("Izeaux"),38140,2111,1810,135,15.54,5.41667,45.3333,405,700),
(38,new String'("Rencurel"),38680,304,295,8,34.63,5.4722,45.1,631,1625),
(38,new String'("Fontanil-Cornillon"),38120,2818,2454,512,5.5,5.66667,45.25,196,1240),
(38,new String'("Veyssilieu"),38460,293,240,45,6.49,5.21667,45.6833,248,432),
(38,new String'("Proveysieux"),38120,522,479,25,20.37,5.7,45.2667,264,1844),
(38,new String'("Côtes-de-Corps"),38970,66,43,6,9.83,5.92306,44.8323,680,2015),
(38,new String'("Châtenay"),38980,428,303,92,4.62,5.23333,45.3167,324,548),
(38,new String'("Saint-Gervais"),38470,574,378,43,13.15,5.48333,45.2,178,1536),
(38,new String'("Malleval-en-Vercors"),38470,51,30,3,14.1,5.4375,45.1473,440,1440),
(38,new String'("Saint-Clair-du-Rhône"),38370,3890,3599,543,7.16,4.78333,45.4333,153,307),
(38,new String'("Charnècles"),38140,1481,1309,283,5.23,5.53333,45.35,260,405),
(38,new String'("Ornacieux"),38260,403,228,82,4.89,5.21667,45.4,371,540),
(38,new String'("Huez"),38750,1368,1662,96,14.16,6.05,45.0833,1024,3081),
(38,new String'("Hières-sur-Amby"),38118,1149,998,131,8.73,5.28333,45.8,193,429),
(38,new String'("Bresson"),38320,692,738,248,2.78,5.75,45.1333,228,533),
(38,new String'("Montalieu-Vercieu"),38390,3189,2177,368,8.66,5.4,45.8167,200,347),
(38,new String'("Grenoble"),38000,155637,153426,8584,18.13,5.71667,45.1667,204,600),
(38,new String'("Varces-Allières-et-Risset"),38760,6330,5342,303,20.88,5.68195,45.0867,247,1960),
(38,new String'("Brangues"),38510,585,469,50,11.67,5.53333,45.7,204,236),
(38,new String'("Saint-Siméon-de-Bressieux"),38870,2777,2493,147,18.79,5.25,45.3333,337,627),
(38,new String'("Blandin"),38730,140,122,32,4.26,5.45,45.4667,387,664),
(38,new String'("Saint-Romain-de-Jalionas"),38460,3147,2749,230,13.65,5.21667,45.75,194,222),
(38,new String'("Revel"),38420,1377,1165,46,29.55,5.86667,45.1833,299,2840),
(38,new String'("Ornon"),38520,131,138,11,11.6,5.98333,45.05,799,2856),
(38,new String'("Saint-Just-de-Claix"),38680,1219,1024,105,11.59,5.28333,45.0667,160,320),
(38,new String'("Passins"),38510,1120,699,80,13.92,5.43333,45.6833,210,377),
(38,new String'("Le Sappey-en-Chartreuse"),38700,1072,941,70,15.13,5.78333,45.2667,840,2079),
(38,new String'("Panossas"),38460,605,500,75,7.99,5.2,45.6833,223,390),
(38,new String'("Vaulnaveys-le-Bas"),38410,1174,1075,98,11.9,5.81667,45.1,287,1326),
(38,new String'("Veurey-Voroize"),38113,1380,1316,113,12.21,5.61667,45.2667,178,1620),
(38,new String'("Saint-Andéol"),38650,116,123,3,29.7,5.55,44.9667,792,2087),
(38,new String'("Chavanoz"),38230,4288,3943,520,8.24,5.16667,45.7833,188,245),
(38,new String'("Domène"),38420,6626,6413,1252,5.29,5.83333,45.2,214,520),
(38,new String'("Anthon"),38280,969,920,109,8.82,5.16667,45.8,182,249),
(38,new String'("Bourgoin-Jallieu"),38300,26173,22934,1073,24.37,5.27972,45.5917,215,382),
(38,new String'("Roche"),38090,1878,1547,93,20.14,5.15945,45.5889,267,516),
(38,new String'("Saint-Martin-le-Vinoux"),38950,5357,5191,532,10.06,5.71667,45.2,205,1299),
(38,new String'("Flachères"),38690,496,301,100,4.94,5.31667,45.4667,530,641),
(38,new String'("La Tronche"),38700,6232,6452,970,6.42,5.73333,45.2,207,1045),
(38,new String'("Saint-Albin-de-Vaulserre"),38480,371,368,74,4.99,5.7,45.5,253,522),
(38,new String'("Tignieu-Jameyzieu"),38230,6055,4835,454,13.32,5.18333,45.7333,199,237),
(38,new String'("Charantonnay"),38790,1880,1555,170,11.0,5.1,45.5333,337,472),
(38,new String'("Merlas"),38620,496,407,31,15.64,5.66667,45.45,400,925),
(38,new String'("Saint-Alban-de-Roche"),38300,1811,1758,296,6.11,5.23333,45.6,230,462),
(38,new String'("Saint-Paul-de-Varces"),38760,2167,1845,110,19.69,5.63333,45.0667,293,2047),
(38,new String'("Virieu"),38730,1049,940,92,11.38,5.46667,45.4833,384,775),
(38,new String'("Panissage"),38730,451,354,92,4.88,5.45,45.4833,381,636),
(38,new String'("Sainte-Blandine"),38110,904,763,98,9.21,5.43333,45.55,328,493),
(38,new String'("Auberives-sur-Varèze"),38550,1487,1159,210,7.05,4.83333,45.4333,169,256),
(38,new String'("Saint-Savin"),38300,3566,2751,145,24.55,5.3,45.6333,216,403),
(38,new String'("Allevard"),38580,3783,3085,147,25.63,6.06667,45.4,399,2749),
(38,new String'("Saint-Jean-d'Avelanne"),38480,901,620,114,7.85,5.66667,45.5,256,549),
(38,new String'("Bizonnes"),38690,835,630,75,11.04,5.36667,45.45,529,642),
(38,new String'("Saint-Christophe-en-Oisans"),38520,114,106,0,123.47,6.18333,44.9667,1168,4008),
(38,new String'("Saint-Pierre-de-Chartreuse"),38380,1011,769,12,80.12,5.81667,45.3333,640,2079),
(38,new String'("Serpaize"),38200,1511,1240,129,11.71,4.91667,45.5667,190,324),
(38,new String'("Vinay"),38470,4070,3528,254,16.01,5.4,45.2167,168,580),
(38,new String'("Chimilin"),38490,1359,1144,140,9.66,5.6,45.5833,228,362),
(38,new String'("Saint-Martin-de-Clelles"),38930,160,116,10,14.72,5.61667,44.85,519,2082),
(38,new String'("Saint-Maximin"),38530,641,539,61,10.35,6.03333,45.4167,274,1204),
(38,new String'("Avignonet"),38650,214,189,25,8.41,5.68333,44.95,362,825),
(38,new String'("Laffrey"),38220,382,311,56,6.72,5.76667,45.0333,680,1262),
(38,new String'("Serre-Nerpol"),38470,297,284,22,13.16,5.375,45.2581,340,720),
(38,new String'("Villette-de-Vienne"),38200,1631,1173,147,11.03,4.9,45.5833,196,364),
(38,new String'("La Forteresse"),38590,297,235,32,9.22,5.4,45.3,503,773),
(38,new String'("Nivolas-Vermelle"),38300,2339,1823,384,6.09,5.3,45.55,258,441),
(38,new String'("Saint-Geoirs"),38590,497,410,71,6.93,5.35,45.3167,414,747),
(38,new String'("Optevoz"),38460,760,530,63,12.0,5.33333,45.75,280,415),
(38,new String'("La Valette"),38350,73,58,9,7.87,5.85639,44.942,710,2203),
(38,new String'("Sousville"),38350,149,123,50,2.93,5.80723,44.9134,560,942),
(38,new String'("Saint-Paul-lès-Monestier"),38650,260,220,18,13.88,5.63333,44.9333,515,1800),
(38,new String'("Roissard"),38650,251,193,17,14.25,5.63333,44.8833,486,1800),
(38,new String'("Marcieu"),38350,70,71,5,11.97,5.68333,44.9167,485,1729),
(38,new String'("Luzinay"),38200,2206,1973,116,18.96,4.95,45.5833,207,366),
(38,new String'("La Ferrière"),38580,228,214,4,54.33,6.08333,45.3167,812,2925),
(38,new String'("Pisieu"),38270,528,470,28,18.76,5.05,45.3833,291,490),
(38,new String'("Dionay"),38160,121,107,8,14.01,5.21667,45.2,392,625),
(38,new String'("Saint-Sébastien"),38710,255,178,12,20.98,5.8,44.85,579,1931),
(38,new String'("Mayres-Savel"),38350,106,107,8,12.51,5.72195,44.8745,484,1769),
(38,new String'("Saint-Vérand"),38160,1823,1447,102,17.83,5.33167,45.1731,276,480),
(38,new String'("Corbelin"),38630,2124,1752,177,12.0,5.55,45.6,212,365),
(38,new String'("Four"),38080,1120,912,94,11.82,5.18333,45.5833,270,529),
(38,new String'("Saint-Jean-de-Moirans"),38430,3090,2675,480,6.43,5.58333,45.3333,186,304),
(38,new String'("La Salette-Fallavaux"),38970,72,76,3,22.29,5.98333,44.85,983,2402),
(38,new String'("Saint-Hilaire-de-la-Côte"),38260,1434,1106,104,13.75,5.31667,45.3833,361,647),
(38,new String'("Vézeronce-Curtin"),38510,1784,1506,124,14.37,5.47056,45.6506,205,316),
(38,new String'("Vertrieu"),38390,660,469,143,4.59,5.36667,45.8667,196,360),
(38,new String'("Hurtières"),38570,176,121,52,3.35,5.96667,45.2833,429,1038),
(38,new String'("Marcollin"),38270,629,460,58,10.69,5.08333,45.3,279,442),
(38,new String'("Roybon"),38940,1297,1233,19,67.31,5.25,45.25,436,729),
(38,new String'("Chamrousse"),38410,453,523,34,13.29,5.9,45.1333,1384,2440),
(38,new String'("Bessins"),38160,129,107,27,4.65,5.26667,45.2,405,650),
(38,new String'("Chozeau"),38460,1040,814,126,8.2,5.21667,45.7,204,416),
(38,new String'("Morestel"),38510,4201,3032,523,8.03,5.46667,45.6667,205,319),
(38,new String'("Saint-Hilaire-de-Brens"),38460,516,414,68,7.52,5.28333,45.6667,218,387),
(38,new String'("Le Pont-de-Claix"),38800,11268,11604,2012,5.6,5.7,45.1167,227,391),
(38,new String'("La Morte"),38350,156,130,8,19.45,5.85,45.0333,1063,2653),
(38,new String'("Saint-Georges-d'Espéranche"),38790,3208,2838,130,24.65,5.06667,45.55,270,456),
(38,new String'("Saint-Égrève"),38120,16006,15510,1471,10.88,5.68306,45.2317,198,1299),
(38,new String'("Corenc"),38700,3851,3842,592,6.5,5.76667,45.2167,221,1328),
(38,new String'("Vénérieu"),38460,583,382,97,6.0,5.28333,45.6667,217,420),
(38,new String'("Saint-Barthélemy-de-Séchilienne"),38220,471,529,38,12.1,5.82612,45.0442,301,1925),
(38,new String'("Pinsot"),38580,200,139,8,24.27,6.1,45.35,551,2858),
(38,new String'("Sinard"),38650,639,579,61,10.44,5.65,44.95,485,1005),
(38,new String'("Moras"),38460,470,415,56,8.32,5.25834,45.6873,275,436),
(38,new String'("Saint-Pierre-de-Mésage"),38220,719,674,102,7.03,5.76667,45.05,289,1342),
(38,new String'("Poliénas"),38210,1098,917,78,14.03,5.46667,45.25,178,409),
(38,new String'("Saint-Martin-de-la-Cluze"),38650,607,566,37,16.26,5.65862,44.9828,330,941),
(38,new String'("Miribel-les-Échelles"),38380,1743,1708,59,29.34,5.7,45.4167,310,920),
(38,new String'("Satolas-et-Bonce"),38290,2101,1648,125,16.8,5.13333,45.7,200,285),
(38,new String'("Salagnon"),38890,1197,931,145,8.21,5.35,45.6667,221,397),
(38,new String'("Montcarra"),38890,475,352,96,4.9,5.38333,45.6167,309,452),
(38,new String'("Saint-Sorlin-de-Morestel"),38510,543,448,100,5.38,5.48333,45.6333,220,419),
(38,new String'("Corrençon-en-Vercors"),38250,359,322,9,39.34,5.53333,45.0333,1055,2286),
(38,new String'("Bévenais"),38690,928,649,65,14.08,5.38333,45.4,426,705),
(38,new String'("Chamagnieu"),38460,1487,1180,108,13.7,5.16667,45.6833,202,341),
(38,new String'("Têche"),38470,560,495,111,5.03,5.38333,45.1833,162,411),
(38,new String'("Saint-Martin-d'Uriage"),38410,5446,4793,183,29.69,5.83333,45.15,320,2200),
(38,new String'("Saint-Marcellin"),38160,8062,6947,1032,7.81,5.31667,45.15,174,454),
(38,new String'("Allemond"),38114,871,760,19,44.75,6.03751,45.1303,702,2969),
(38,new String'("Saint-Bernard"),38660,632,468,29,21.59,5.9,45.3333,593,2047),
(38,new String'("Prunières"),38350,376,312,45,8.2,5.76667,44.8833,592,1617),
(38,new String'("Eclose"),38300,713,536,69,10.29,5.3,45.5,478,640),
(38,new String'("Livet-et-Gavet"),38220,1226,1365,26,46.54,5.93333,45.1,366,2763),
(38,new String'("Saint-Lattier"),38840,1265,1034,69,18.17,5.2,45.0833,144,406),
(38,new String'("Saint-Just-Chaleyssin"),38540,2468,2241,176,13.95,5.0,45.5833,218,373),
(38,new String'("Anjou"),38150,992,810,197,5.03,4.88333,45.35,218,383),
(38,new String'("Culin"),38300,662,516,90,7.32,5.25,45.5167,421,536),
(38,new String'("La Côte-Saint-André"),38260,4833,4238,173,27.93,5.25,45.3833,335,582),
(38,new String'("Maubec"),38300,1608,1369,187,8.57,5.3,45.5667,255,491),
(38,new String'("Saint-Romain-de-Surieu"),38150,324,246,68,4.71,4.88333,45.3833,240,402),
(38,new String'("Reventin-Vaugris"),38121,1765,1575,95,18.4,4.83333,45.4667,141,404),
(38,new String'("Septème"),38780,1750,1469,81,21.55,5.01667,45.55,188,386),
(38,new String'("Rives"),38140,6062,5601,554,10.93,5.5,45.35,314,469),
(38,new String'("Pajay"),38260,1050,796,73,14.32,5.13333,45.3667,270,410),
(38,new String'("Assieu"),38150,1316,889,106,12.34,4.86667,45.4167,220,407),
(38,new String'("Succieu"),38300,703,547,84,8.35,5.33333,45.5333,324,571),
(38,new String'("Châlons"),38122,165,162,31,5.2,4.93333,45.45,297,428),
(38,new String'("Meyrié"),38300,1001,831,291,3.43,5.28333,45.5667,283,400),
(38,new String'("Plan"),38590,246,182,40,6.1,5.4,45.3167,452,785),
(38,new String'("Saint-Bueil"),38620,700,628,183,3.81,5.68333,45.4667,293,570),
(38,new String'("Saint-Cassien"),38500,1107,961,195,5.67,5.55,45.35,307,424),
(38,new String'("Salaise-sur-Sanne"),38150,4201,3645,260,16.15,4.81667,45.3333,137,234),
(38,new String'("Saint-Baudille-de-la-Tour"),38118,744,570,34,21.76,5.33333,45.7833,230,404),
(38,new String'("Montchaboud"),38220,369,335,188,1.96,5.76667,45.1,261,733),
(38,new String'("Saint-Pierre-de-Chérennes"),38160,476,354,39,12.03,5.36667,45.1167,170,1400),
(38,new String'("Dizimieu"),38460,651,497,66,9.74,5.3,45.7167,230,417),
(38,new String'("Moirans"),38430,7780,7485,387,20.06,5.56667,45.3333,180,341),
(38,new String'("Sarcenas"),38700,197,141,25,7.76,5.75,45.2667,892,2079),
(38,new String'("Beauvoir-de-Marc"),38440,1028,957,91,11.27,5.08333,45.5167,306,456),
(38,new String'("Prébois"),38710,163,140,10,16.03,5.7,44.7833,596,1720),
(38,new String'("Chèzeneuve"),38300,499,373,73,6.79,5.21667,45.5667,400,529),
(38,new String'("Auberives-en-Royans"),38680,359,326,70,5.07,5.3,45.0667,170,330),
(38,new String'("Saint-Antoine-l'Abbaye"),38160,1016,907,45,22.21,5.21667,45.175,274,578),
(38,new String'("Gillonnay"),38260,975,824,68,14.29,5.28333,45.3833,346,633),
(38,new String'("Tramolé"),38300,533,476,76,6.99,5.26667,45.5167,394,538),
(38,new String'("Le Cheylas"),38570,2673,2117,316,8.44,6.0,45.3667,240,1202),
(38,new String'("Saint-Maurice-l'Exil"),38550,5845,5512,455,12.82,4.78333,45.4,139,265),
(38,new String'("Clelles"),38930,510,376,24,20.88,5.61667,44.8333,520,1560),
(38,new String'("Belmont"),38690,463,266,71,6.51,5.36362,45.4737,455,662),
(38,new String'("Valjouffrey"),38740,148,156,2,72.56,6.03112,44.8723,923,3565),
(38,new String'("Chassignieu"),38730,206,192,39,5.17,5.5,45.5,373,607),
(38,new String'("Saint-Quentin-sur-Isère"),38210,1311,1232,67,19.45,5.55,45.2833,176,1008),
(38,new String'("Penol"),38260,322,288,26,12.16,5.2,45.3833,281,455),
(38,new String'("Quaix-en-Chartreuse"),38950,924,741,51,18.09,5.71862,45.2528,270,1689),
(38,new String'("Le Freney-d'Oisans"),38142,265,220,18,14.54,6.11667,45.0333,871,3445),
(38,new String'("Herbeys"),38320,1343,1168,173,7.73,5.78333,45.1333,417,935),
(38,new String'("Chonas-l'Amballan"),38121,1545,1218,208,7.41,4.81667,45.4667,146,323),
(38,new String'("Le Bourg-d'Oisans"),38520,3327,2992,93,35.75,6.03333,45.05,701,3121),
(38,new String'("Annoisin-Chatelans"),38460,634,541,47,13.27,5.28333,45.75,280,452),
(38,new String'("Montagne"),38160,265,249,30,8.78,5.2,45.15,259,560),
(38,new String'("Villefontaine"),38090,18374,17757,1579,11.63,5.15,45.6167,208,352),
(38,new String'("Vasselin"),38890,424,300,110,3.85,5.45,45.6333,221,450),
(38,new String'("Saint-Quentin-Fallavier"),38070,5922,5847,259,22.83,5.11667,45.6333,206,364),
(38,new String'("Pont-Évêque"),38780,5041,5065,575,8.76,4.91667,45.5333,165,321),
(38,new String'("Villemoirieu"),38460,1809,1391,136,13.29,5.21667,45.7167,203,425),
(38,new String'("Ruy"),38300,4198,3760,201,20.81,5.31667,45.5833,244,505),
(38,new String'("Estrablin"),38780,3264,3217,157,20.69,4.96667,45.5167,186,352),
(38,new String'("Sassenage"),38360,10996,9726,826,13.31,5.66667,45.2,199,1409),
(38,new String'("Nantes-en-Ratier"),38350,479,395,39,12.13,5.82667,44.935,587,1975),
(38,new String'("Saint-Ondras"),38490,597,496,73,8.15,5.53333,45.5167,361,626),
(38,new String'("Marcilloles"),38260,998,760,105,9.5,5.18333,45.3333,288,351),
(38,new String'("Cour-et-Buis"),38122,851,726,61,13.73,5.0,45.4333,328,462),
(38,new String'("Saint-Honoré"),38350,814,780,55,14.58,5.81667,44.9333,895,2384),
(38,new String'("Moidieu-Détourbe"),38440,1790,1409,99,18.04,5.01667,45.5167,235,423),
(38,new String'("Sillans"),38590,1860,1404,147,12.61,5.38333,45.3333,393,567),
(38,new String'("Jardin"),38200,2241,1951,242,9.25,4.91667,45.5,194,407),
(38,new String'("Ponsonnas"),38350,272,224,93,2.9,5.8,44.8833,496,870),
(38,new String'("Cheyssieu"),38550,1047,731,122,8.55,4.85,45.4333,180,254),
(38,new String'("Le Grand-Lemps"),38690,2940,2356,227,12.9,5.41667,45.3833,434,724),
(38,new String'("Saint-Prim"),38370,1200,892,164,7.3,4.8,45.45,155,309),
(38,new String'("Torchefelon"),38690,621,449,71,8.68,5.4,45.5167,378,589),
(38,new String'("Saint-Pierre-de-Bressieux"),38870,684,627,29,23.08,5.28333,45.3167,378,723),
(38,new String'("Froges"),38190,3435,3090,534,6.43,5.91667,45.2667,219,965),
(38,new String'("La Combe-de-Lancey"),38190,705,529,38,18.55,5.9,45.2333,316,2813),
(38,new String'("Siévoz"),38350,121,116,16,7.37,5.83333,44.9,582,1605),
(38,new String'("Saint-Clair-sur-Galaure"),38940,272,248,17,15.3,5.15,45.25,388,540),
(38,new String'("Renage"),38140,3717,3331,728,5.1,5.48333,45.3333,229,464),
(38,new String'("Oulles"),38520,12,16,1,11.01,5.98333,45.0833,728,2559),
(38,new String'("Murianette"),38420,874,617,143,6.07,5.81667,45.1833,213,999),
(38,new String'("Pierre-Châtel"),38119,1333,1206,116,11.48,5.76667,44.95,888,1424),
(38,new String'("Villard-Notre-Dame"),38520,25,41,1,14.06,6.05,45.0167,720,3023),
(38,new String'("Seyssuel"),38200,1990,1885,204,9.75,4.85,45.5667,141,357),
(38,new String'("La Mure"),38350,5091,5188,611,8.33,5.78751,44.9031,720,1204),
(38,new String'("Meyssiès"),38440,602,535,43,13.88,5.05,45.4667,280,477),
(38,new String'("Poisat"),38320,2078,2079,811,2.56,5.76667,45.15,214,724),
(38,new String'("Chichilianne"),38930,274,206,4,62.48,5.56667,44.8167,798,2082),
(38,new String'("Mizoën"),38142,193,163,13,14.6,6.13333,45.05,955,2964),
(38,new String'("Royas"),38440,386,305,70,5.48,5.1,45.5,329,472),
(38,new String'("Notre-Dame-de-Mésage"),38220,1198,1201,264,4.53,5.76667,45.0667,270,1276),
(38,new String'("Bilieu"),38850,1274,926,189,6.71,5.55,45.45,488,810),
(38,new String'("Saint-Sauveur"),38160,1927,1675,204,9.42,5.35,45.15,160,301),
(38,new String'("Pact"),38270,829,642,85,9.74,4.98333,45.35,238,309),
(38,new String'("Veyrins-Thuellin"),38630,1904,1482,164,11.56,5.53917,45.6256,204,322),
(38,new String'("Primarette"),38270,720,621,33,21.76,5.03333,45.4,300,485),
(38,new String'("Saint-Didier-de-la-Tour"),38110,1813,1420,123,14.63,5.48333,45.55,328,554),
(38,new String'("Morette"),38210,386,362,61,6.27,5.45,45.2833,280,761),
(38,new String'("Quincieu"),38470,81,74,17,4.75,5.38333,45.2667,480,771),
(38,new String'("Saint-Bonnet-de-Chavagne"),38840,628,449,41,15.18,5.23333,45.1333,160,388),
(38,new String'("L'Isle-d'Abeau"),38080,15586,12033,1710,9.11,5.23333,45.6167,208,302),
(38,new String'("Saint-André-en-Royans"),38680,326,295,31,10.42,5.35,45.0833,224,1007),
(38,new String'("Vernioz"),38150,1183,888,104,11.32,4.88333,45.4333,218,408),
(38,new String'("Monteynard"),38770,478,402,44,10.72,5.7,44.9667,362,1712),
(38,new String'("Soleymieu"),38460,702,574,52,13.36,5.35,45.7167,221,363),
(38,new String'("Miribel-Lanchâtre"),38450,375,251,38,9.65,5.61667,44.9667,423,1509),
(38,new String'("Savas-Mépin"),38440,806,575,77,10.43,5.05,45.5,288,472),
(38,new String'("Monestier-de-Clermont"),38650,1273,920,233,5.45,5.63333,44.9,679,1070),
(38,new String'("Saint-Michel-les-Portes"),38650,248,143,12,20.59,5.6,44.8667,558,2082),
(38,new String'("Mens"),38710,1387,1178,49,28.29,5.75,44.8167,612,1929),
(38,new String'("Crémieu"),38460,3347,3171,545,6.14,5.25,45.7167,203,415),
(38,new String'("Saint-Baudille-et-Pipet"),38710,254,232,7,35.97,5.76667,44.7833,718,2696),
(38,new String'("Doissin"),38730,851,616,100,8.45,5.41667,45.5,411,661),
(38,new String'("Sérézin-de-la-Tour"),38300,865,612,92,9.31,5.35,45.55,266,466),
(38,new String'("Saint-Marcel-Bel-Accueil"),38080,1296,1253,71,18.23,5.23333,45.65,210,452),
(38,new String'("Saint-Chef"),38890,3493,2896,128,27.16,5.36667,45.6333,218,440),
(38,new String'("Vaujany"),38114,345,311,5,64.54,6.08333,45.15,752,3464),
(38,new String'("Ville-sous-Anjou"),38150,1146,1009,62,18.25,4.85,45.3667,186,401),
(38,new String'("Saint-Pierre-d'Allevard"),38830,2799,2280,103,27.09,6.05,45.3667,429,1766),
(38,new String'("Champier"),38260,1242,967,86,14.43,5.28333,45.45,470,631),
(38,new String'("Courtenay"),38510,1201,738,37,32.08,5.38333,45.7333,219,375),
(38,new String'("Châbons"),38690,1844,1487,101,18.14,5.43333,45.4167,386,687),
(38,new String'("Arandon"),38510,564,406,46,12.22,5.43333,45.7167,212,292),
(38,new String'("Cessieu"),38110,2652,2117,184,14.35,5.36667,45.5667,278,510),
(38,new String'("Monsteroux-Milieu"),38122,741,515,90,8.17,4.95,45.4333,267,425),
(38,new String'("Chapareillan"),38530,2747,2148,90,30.28,5.96667,45.4667,245,1934),
(38,new String'("La Salle-en-Beaumont"),38350,307,242,33,9.26,5.86667,44.8667,579,1480),
(38,new String'("La Buissière"),38530,663,566,85,7.71,5.98333,45.4,242,420),
(38,new String'("Balbins"),38260,386,371,53,7.26,5.21667,45.3833,347,530),
(38,new String'("Villard-Reculas"),38114,62,57,12,4.99,6.03333,45.1,826,2058),
(38,new String'("Beaufort"),38270,563,415,64,8.69,5.12195,45.3264,266,374),
(38,new String'("Saint-Nicolas-de-Macherin"),38500,887,779,83,10.6,5.6,45.3833,447,952),
(38,new String'("Presles"),38680,99,89,3,25.68,5.38333,45.0833,468,1370),
(38,new String'("Montrevel"),38690,473,346,50,9.37,5.4,45.4667,441,705),
(38,new String'("Grenay"),38540,1453,1191,201,7.2,5.08333,45.6667,220,321),
(38,new String'("Apprieu"),38140,3108,2530,205,15.09,5.5,45.4,371,773),
(38,new String'("Bonnefamille"),38090,1015,929,107,9.43,5.11667,45.6,275,443),
(38,new String'("Chélieu"),38730,661,522,65,10.13,5.48333,45.5,374,607),
(38,new String'("Auris"),38142,207,216,18,11.21,6.08333,45.05,720,2164),
(38,new String'("Gières"),38610,6118,6131,882,6.93,5.78333,45.1833,205,660),
(38,new String'("Porcieu-Amblagnieu"),38390,1603,1250,101,15.8,5.4,45.8333,191,395),
(38,new String'("Saint-Appolinard"),38160,398,319,36,10.76,5.26251,45.1889,329,643),
(38,new String'("Chirens"),38850,2197,1889,125,17.53,5.55,45.4167,441,876),
(38,new String'("La Motte-Saint-Martin"),38770,413,338,28,14.64,5.71667,44.95,486,1712),
(38,new String'("Bressieux"),38870,90,90,101,0.89,5.28333,45.3167,395,525),
(38,new String'("Gresse-en-Vercors"),38650,406,299,5,81.13,5.56667,44.9,960,2341),
(38,new String'("Saint-Nazaire-les-Eymes"),38330,2907,2337,342,8.49,5.85334,45.2495,219,1736),
(38,new String'("Romagnieu"),38480,1433,1236,83,17.11,5.63333,45.5667,218,364),
(38,new String'("Sardieu"),38260,1017,600,90,11.2,5.2,45.3667,322,358),
(38,new String'("La Chapelle-du-Bard"),38580,504,425,18,27.71,6.1,45.4167,358,2526),
(38,new String'("Saint-Jean-de-Bournay"),38440,4366,3859,162,26.87,5.13333,45.4833,345,511),
(38,new String'("Clonas-sur-Varèze"),38550,1495,1281,218,6.83,4.8,45.4167,157,256),
(38,new String'("Villard-Bonnot"),38190,7296,6955,1249,5.84,5.88333,45.2333,218,448),
(38,new String'("Tullins"),38210,7663,7061,266,28.79,5.48333,45.3,179,784),
(38,new String'("Montfalcon"),38940,126,99,21,5.82,5.16667,45.25,410,552),
(38,new String'("Vourey"),38210,1578,1549,229,6.88,5.51667,45.3167,181,402),
(38,new String'("Sainte-Anne-sur-Gervonde"),38440,581,399,75,7.67,5.23333,45.5,426,546),
(38,new String'("Crolles"),38190,8451,8253,594,14.21,5.88333,45.2833,219,1000),
(38,new String'("La Rivière"),38210,637,470,34,18.45,5.51667,45.2333,178,1604),
(38,new String'("Adrets"),38190,903,648,55,16.15,5.96667,45.2667,560,2440),
(38,new String'("Oyeu"),38690,919,754,67,13.69,5.46667,45.4167,516,771),
(38,new String'("Biol"),38690,1373,1201,88,15.51,5.38528,45.4917,438,691),
(38,new String'("La Murette"),38140,1795,1618,425,4.22,5.53333,45.3667,379,787),
(38,new String'("La Pierre"),38570,428,390,129,3.31,5.95,45.2917,225,452),
(38,new String'("Thodure"),38260,704,562,48,14.43,5.16667,45.3167,287,492),
(38,new String'("Bougé-Chambalud"),38150,1252,918,78,15.85,4.9,45.3333,172,232),
(38,new String'("Pommier-de-Beaurepaire"),38260,694,583,36,19.16,5.11667,45.4,274,507),
(38,new String'("Saint-Victor-de-Morestel"),38510,1125,850,85,13.13,5.5,45.7,205,272),
(38,new String'("L'Albenc"),38470,1091,991,110,9.86,5.43333,45.2167,170,415),
(38,new String'("Saint-Romans"),38160,1742,1411,102,17.04,5.31667,45.1167,160,863),
(38,new String'("Saint-Blaise-du-Buis"),38140,993,854,182,5.44,5.51667,45.3667,372,492),
(38,new String'("Valbonnais"),38740,503,440,21,23.95,5.9,44.9,672,2544),
(38,new String'("Voreppe"),38340,9847,9231,343,28.65,5.63333,45.3,185,1702),
(38,new String'("Pellafol"),38970,137,137,3,34.73,5.91667,44.8,639,2793),
(38,new String'("Biviers"),38330,2360,2385,382,6.17,5.8,45.2333,311,1388),
(38,new String'("Vernas"),38460,230,174,39,5.87,5.28167,45.7775,195,429),
(38,new String'("Entraigues"),38740,240,229,11,21.66,5.94806,44.9017,744,2574),
(38,new String'("Villette-d'Anthon"),38280,4284,3906,187,22.8,5.11667,45.8,179,260),
(38,new String'("Bouvesse-Quirieu"),38390,1418,969,80,17.51,5.4,45.8,200,338),
(38,new String'("Sermérieu"),38510,1502,1168,87,17.14,5.41667,45.6667,223,385),
(38,new String'("Séchilienne"),38220,927,760,43,21.47,5.83333,45.0667,304,1646),
(38,new String'("Charancieu"),38490,714,566,129,5.53,5.56667,45.5167,386,615),
(38,new String'("Murinais"),38160,381,339,46,8.22,5.31667,45.2167,345,667),
(38,new String'("Chuzelles"),38200,2052,1958,157,13.03,4.88333,45.5833,165,361),
(38,new String'("Izeron"),38160,776,609,45,17.19,5.38333,45.15,166,1440),
(38,new String'("Le Passage"),38490,766,648,114,6.68,5.5,45.5167,365,521),
(38,new String'("Choranche"),38680,131,130,12,10.63,5.4,45.0667,200,1200),
(38,new String'("Aoste"),38490,2682,1723,273,9.82,5.6,45.5833,207,256),
(38,new String'("Seyssins"),38180,6913,6844,864,8.0,5.68333,45.15,219,1897),
(38,new String'("Saint-Étienne-de-Crossey"),38960,2545,2478,198,12.84,5.63333,45.3667,370,883),
(38,new String'("Méaudre"),38112,1350,1040,39,33.87,5.53333,45.1333,940,1625),
(38,new String'("Saint-Joseph-de-Rivière"),38134,1145,958,65,17.39,5.68333,45.3667,387,1880),
(38,new String'("Montaud"),38210,526,383,36,14.59,5.56667,45.2667,400,1643),
(38,new String'("Bellegarde-Poussieu"),38270,928,851,55,16.79,4.95,45.3833,229,436),
(38,new String'("Brié-et-Angonnes"),38320,2416,1828,249,9.7,5.8,45.1167,306,737),
(38,new String'("Vénosc"),38520,815,939,32,25.06,6.11667,44.9833,816,3465),
(38,new String'("Bernin"),38190,2991,2906,389,7.67,5.86667,45.2667,219,1200),
(38,new String'("Saint-Pancrasse"),38660,438,407,65,6.71,5.86667,45.2833,760,2060),
(38,new String'("Vatilieu"),38470,385,341,41,9.22,5.41667,45.25,352,787),
(38,new String'("Vaulx-Milieu"),38090,2435,2221,269,9.02,5.18333,45.6167,208,330),
(38,new String'("Trept"),38460,1774,1539,111,15.87,5.31667,45.6833,219,360),
(38,new String'("Claix"),38640,7538,7389,312,24.12,5.66667,45.1167,226,1960),
(38,new String'("La Motte-d'Aveillans"),38770,1794,1526,183,9.78,5.75,44.95,637,1617),
(38,new String'("Vif"),38450,8053,6478,284,28.3,5.66667,45.05,277,1263),
(38,new String'("Saint-Hilaire-du-Rosier"),38840,1987,1760,121,16.42,5.25,45.1,151,280),
(38,new String'("Chantelouve"),38740,76,73,2,33.41,5.96834,44.9839,975,3023),
(38,new String'("Mont-de-Lans"),38860,1255,1086,39,31.66,6.13333,45.0333,732,3285),
(38,new String'("Saint-Agnin-sur-Bion"),38300,835,674,86,9.7,5.25,45.5333,320,503),
(38,new String'("Saint-Georges-de-Commiers"),38450,2102,1886,143,14.62,5.7,45.0333,286,1370),
(38,new String'("Oz"),38114,221,153,13,16.81,6.05,45.1333,716,3320),
(38,new String'("Châtonnay"),38440,1861,1424,58,31.84,5.2,45.4833,424,615),
(38,new String'("Saint-Geoire-en-Valdaine"),38620,2402,1972,143,16.73,5.63333,45.45,364,739),
(38,new String'("Creys-Mépieu"),38510,1405,1091,48,28.99,5.48778,45.7284,200,343),
(38,new String'("Villard-Reymond"),38520,35,31,3,11.21,6.01667,45.0333,840,2732),
(38,new String'("Crachier"),38300,471,434,129,3.64,5.23333,45.55,370,462),
(38,new String'("Saint-Sulpice-des-Rivoires"),38620,450,411,62,7.16,5.6,45.4667,511,780),
(38,new String'("Villeneuve-de-Marc"),38440,1141,884,43,26.18,5.1,45.4833,344,524),
(38,new String'("Lavaldens"),38350,157,139,3,41.4,5.88333,44.9833,959,2856),
(38,new String'("Marnans"),38980,147,114,22,6.6,5.23333,45.3,441,630),
(38,new String'("Saint-Sorlin-de-Vienne"),38200,821,700,82,9.94,4.94278,45.4678,219,428),
(38,new String'("Saint-Christophe-sur-Guiers"),38380,798,718,33,23.54,5.76667,45.4333,386,1761),
(38,new String'("Cognin-les-Gorges"),38470,656,540,52,12.52,5.41667,45.1667,166,1120),
(38,new String'("Le Champ-près-Froges"),38190,1250,1159,258,4.83,5.93333,45.2833,220,836),
(38,new String'("Semons"),38260,368,291,34,10.55,5.2,45.4333,388,564),
(38,new String'("Parmilieu"),38390,651,421,50,12.83,5.35,45.8333,235,442),
(38,new String'("Janneyrias"),38280,1485,1170,141,10.52,5.1,45.75,213,287),
(38,new String'("Rochetoirin"),38110,1034,863,97,10.62,5.41667,45.5833,302,487),
(38,new String'("Fitilieu"),38490,1709,1275,170,10.01,5.56667,45.55,280,407),
(38,new String'("Chasse-sur-Rhône"),38670,5267,4793,665,7.91,4.81667,45.5667,145,290),
(38,new String'("Arzay"),38260,216,169,22,9.79,5.16667,45.4333,375,545),
(38,new String'("Saint-Laurent-du-Pont"),38380,4484,4238,127,35.25,5.73333,45.3833,379,1735),
(38,new String'("Saint-Julien-de-Raz"),38134,434,445,40,10.81,5.66167,45.3498,463,1891),
(38,new String'("La Frette"),38260,1085,822,91,11.8,5.35,45.3833,407,669),
(38,new String'("Seyssinet-Pariset"),38170,12113,13074,1137,10.65,5.65,45.1667,209,1565),
(38,new String'("Pressins"),38480,1102,819,109,10.1,5.61667,45.5167,262,532),
(38,new String'("Artas"),38440,1620,1349,114,14.15,5.16667,45.5333,364,507),
(38,new String'("Beauvoir-en-Royans"),38160,74,70,35,2.1,5.33806,45.1209,160,606),
(38,new String'("Eydoche"),38690,477,332,85,5.58,5.33333,45.4333,493,629),
(38,new String'("Vienne"),38200,29328,29930,1294,22.65,4.86667,45.5167,140,404),
(38,new String'("Mont-Saint-Martin"),38120,88,98,16,5.31,5.66667,45.2667,520,1844),
(38,new String'("Charavines"),38850,1784,1428,237,7.52,5.51667,45.4333,440,800),
(38,new String'("Le Moutaret"),38580,222,161,41,5.29,6.08333,45.4333,320,1089),
(38,new String'("Pontcharra"),38530,7162,6418,459,15.58,6.01667,45.4333,244,1217),
(38,new String'("Saint-Alban-du-Rhône"),38370,865,838,242,3.56,4.76667,45.4333,149,166),
(38,new String'("Faramans"),38260,935,733,86,10.79,5.16667,45.3833,342,444),
(38,new String'("Eybens"),38320,9582,9473,2129,4.5,5.75,45.15,216,408),
(38,new String'("Chevrières"),38160,693,558,41,16.62,5.3,45.1833,310,661),
(38,new String'("La Balme-les-Grottes"),38390,915,675,62,14.61,5.33333,45.85,192,383),
(38,new String'("Vaulnaveys-le-Haut"),38410,3533,3098,177,19.86,5.8,45.1167,338,1714),
(38,new String'("Agnin"),38150,969,789,121,7.96,4.86667,45.3333,167,331),
(38,new String'("Pont-en-Royans"),38680,835,918,287,2.9,5.35,45.0667,183,788),
(38,new String'("Cognet"),38350,50,36,27,1.8,5.78333,44.8833,491,920),
(38,new String'("Chantesse"),38470,315,269,54,5.83,5.45,45.2333,247,489),
(38,new String'("Susville"),38350,1402,1468,141,9.91,5.78028,44.9159,874,1600),
(39,new String'("La Charme"),39230,53,39,14,3.71,5.56667,46.85,209,255),
(39,new String'("Charnod"),39240,45,43,8,5.17,5.5,46.3333,480,685),
(39,new String'("Lavangeot"),39700,115,157,47,2.41,5.61667,47.15,207,247),
(39,new String'("Pimorin"),39270,189,158,18,10.29,5.51667,46.5,400,641),
(39,new String'("Champagney"),39290,402,216,25,15.58,5.51528,47.26,192,239),
(39,new String'("Pleure"),39120,428,346,84,5.07,5.45,46.9167,197,222),
(39,new String'("Vernantois"),39570,331,273,47,6.99,5.58333,46.6333,294,617),
(39,new String'("Toulouse-le-Château"),39230,212,160,50,4.16,5.58333,46.8167,223,352),
(39,new String'("Santans"),39380,332,290,20,16.52,5.66667,47.0167,215,253),
(39,new String'("Mièges"),39250,92,91,28,3.19,6.03333,46.7833,721,831),
(39,new String'("Bracon"),39110,282,331,44,6.29,5.88333,46.9333,345,626),
(39,new String'("Nozeroy"),39250,417,424,111,3.74,6.03333,46.7833,660,834),
(39,new String'("Thervay"),39290,377,362,23,15.75,5.61667,47.25,192,311),
(39,new String'("Chille"),39570,326,254,166,1.96,5.58333,46.7,262,388),
(39,new String'("Écrille"),39270,82,68,15,5.25,5.63112,46.5059,389,603),
(39,new String'("Bellefontaine"),39400,550,453,22,24.71,6.06667,46.55,760,1302),
(39,new String'("Bouchoux"),39370,314,280,14,21.71,5.81667,46.3,710,1230),
(39,new String'("Mathenay"),39600,130,93,36,3.54,5.68333,46.9333,231,295),
(39,new String'("Augea"),39190,285,272,37,7.52,5.41667,46.55,188,400),
(39,new String'("Hautecour"),39130,178,186,34,5.19,5.76667,46.5667,570,779),
(39,new String'("Vincent"),39230,322,226,36,8.72,5.48333,46.7833,202,247),
(39,new String'("Vaux-lès-Saint-Claude"),39360,709,684,75,9.36,5.73333,46.3667,324,950),
(39,new String'("Lect"),39260,382,352,31,11.94,5.66667,46.3833,306,743),
(39,new String'("Thoirette"),39240,681,542,77,8.77,5.53333,46.2667,275,635),
(39,new String'("Billecul"),39250,33,32,7,4.41,6.05,46.75,780,926),
(39,new String'("Brans"),39290,235,178,26,8.77,5.56667,47.2333,198,367),
(39,new String'("Nans"),39300,90,83,11,8.05,5.96667,46.7833,635,904),
(39,new String'("Bréry"),39230,214,195,44,4.85,5.58333,46.7833,227,405),
(39,new String'("Grusse"),39190,183,147,56,3.25,5.5,46.6,228,550),
(39,new String'("Sapois"),39300,340,287,95,3.56,5.95,46.75,548,750),
(39,new String'("Crozets"),39260,215,202,28,7.59,5.8,46.4667,720,1064),
(39,new String'("Écleux"),39600,202,153,32,6.2,5.73333,47.0,223,277),
(39,new String'("Chamole"),39800,164,137,28,5.78,5.73333,46.8333,450,606),
(39,new String'("Sermange"),39700,282,231,39,7.07,5.65,47.2,228,284),
(39,new String'("Châtelneuf"),39300,137,126,10,13.0,5.91667,46.6833,677,885),
(39,new String'("Pagney"),39350,357,302,59,5.99,5.7,47.25,197,354),
(39,new String'("Courlans"),39570,992,737,161,6.16,5.5,46.6667,211,280),
(39,new String'("Genod"),39240,67,60,21,3.14,5.53333,46.35,326,689),
(39,new String'("Planches-en-Montagne"),39150,150,128,11,13.48,6.01667,46.6667,570,1061),
(39,new String'("Molinges"),39360,669,596,260,2.57,5.76667,46.35,334,686),
(39,new String'("Château-des-Prés"),39150,183,166,21,8.62,5.9,46.5,890,1070),
(39,new String'("Fétigny"),39240,99,78,30,3.3,5.6,46.45,390,731),
(39,new String'("Chaussenans"),39800,114,89,25,4.4,5.73333,46.8333,546,580),
(39,new String'("Ougney"),39350,322,283,45,7.08,5.66667,47.2333,193,372),
(39,new String'("Pretin"),39110,59,66,10,5.44,5.83333,46.9333,346,631),
(39,new String'("Grozon"),39800,483,396,33,14.25,5.7,46.8833,239,385),
(39,new String'("Mont-sous-Vaudrey"),39380,1272,1166,85,14.86,5.6,46.9667,211,252),
(39,new String'("Saint-Hymetière"),39240,75,68,22,3.32,5.55,46.35,325,464),
(39,new String'("Montmirey-la-Ville"),39290,184,198,46,3.93,5.51667,47.2167,197,320),
(39,new String'("Chamblay"),39380,415,388,30,13.82,5.71667,47.0,219,268),
(39,new String'("Évans"),39700,621,545,62,9.87,5.76667,47.1833,210,293),
(39,new String'("Domblans"),39210,926,837,92,10.01,5.6,46.7667,234,405),
(39,new String'("Falletans"),39700,399,308,16,24.35,5.56667,47.1,200,264),
(39,new String'("Froideville"),39230,74,51,24,2.97,5.48333,46.8167,199,224),
(39,new String'("Bans"),39380,197,140,50,3.92,5.58333,46.9833,209,246),
(39,new String'("Peintre"),39290,128,135,20,6.34,5.48333,47.2,190,262),
(39,new String'("Chemin"),39120,351,380,38,9.14,5.31667,46.9833,182,188),
(39,new String'("Auxange"),39700,202,132,38,5.2,5.65,47.1667,212,271),
(39,new String'("Hays"),39120,287,271,42,6.8,5.38333,46.9,197,219),
(39,new String'("Ranchot"),39700,472,439,68,6.91,5.73333,47.15,209,262),
(39,new String'("La Chaux-du-Dombief"),39150,526,486,24,21.65,5.9,46.6,719,1063),
(39,new String'("Charchilla"),39260,245,249,35,6.84,5.71667,46.4667,460,690),
(39,new String'("Reithouse"),39270,51,52,10,4.84,5.56667,46.55,489,672),
(39,new String'("Augisey"),39270,184,207,19,9.29,5.48333,46.55,427,594),
(39,new String'("Recanoz"),39230,80,52,26,3.01,5.5,46.8167,204,231),
(39,new String'("Dampierre"),39700,1209,999,172,6.99,5.75,47.15,210,272),
(39,new String'("Rouffange"),39350,96,83,33,2.87,5.7,47.2167,228,351),
(39,new String'("Our"),39700,164,169,11,13.86,5.65,47.1333,207,261),
(39,new String'("Pillemoine"),39300,61,56,13,4.69,5.9,46.7,654,821),
(39,new String'("Rahon"),39120,522,472,26,19.6,5.46139,46.987,191,243),
(39,new String'("Beaufort"),39190,1022,964,77,13.11,5.43333,46.5667,191,574),
(39,new String'("Augerans"),39380,151,137,18,8.05,5.58333,47.0167,206,248),
(39,new String'("Clucy"),39110,79,72,15,5.13,5.9,46.95,560,719),
(39,new String'("Conte"),39300,58,56,17,3.32,6.0,46.75,614,801),
(39,new String'("Offlanges"),39290,192,189,21,8.73,5.55,47.2,204,378),
(39,new String'("Macornay"),39570,1011,880,219,4.6,5.53333,46.65,259,505),
(39,new String'("Vitreux"),39350,266,209,33,7.85,5.68333,47.25,192,361),
(39,new String'("Condamine"),39570,272,212,74,3.65,5.43333,46.65,197,224),
(39,new String'("Crenans"),39260,246,220,27,8.82,5.73333,46.45,596,897),
(39,new String'("Prénovel"),39150,299,296,36,8.2,5.85,46.5,877,1045),
(39,new String'("Villevieux"),39140,731,670,74,9.87,5.46667,46.7333,193,208),
(39,new String'("Varessia"),39270,40,24,21,1.83,5.55,46.55,473,672),
(39,new String'("Loulle"),39300,172,176,15,10.9,5.88333,46.7,610,776),
(39,new String'("Barretaine"),39800,200,200,21,9.23,5.71667,46.8167,471,591),
(39,new String'("Arlay"),39140,734,723,52,14.11,5.53333,46.7667,212,325),
(39,new String'("La Ferté"),39600,197,191,16,11.75,5.66667,46.95,220,288),
(39,new String'("L'Étoile"),39570,559,581,91,6.13,5.53333,46.7167,235,424),
(39,new String'("Bersaillin"),39800,392,275,28,13.9,5.6,46.8667,222,300),
(39,new String'("Villards-d'Héria"),39260,449,476,45,9.91,5.73333,46.4167,459,950),
(39,new String'("Broissia"),39320,53,37,17,2.97,5.43333,46.3667,335,539),
(39,new String'("La Boissière"),39240,68,52,12,5.36,5.53333,46.4167,370,629),
(39,new String'("La Chassagne"),39230,120,92,21,5.67,5.45,46.8667,193,218),
(39,new String'("Fraisans"),39700,1228,1240,72,16.9,5.76667,47.15,209,279),
(39,new String'("Conliège"),39570,701,732,115,6.05,5.6,46.65,302,550),
(39,new String'("Cézia"),39240,69,63,19,3.6,5.56667,46.3667,458,802),
(39,new String'("Uxelles"),39130,46,39,8,5.27,5.78333,46.6,570,686),
(39,new String'("Mérona"),39270,11,8,3,2.97,5.63333,46.55,548,702),
(39,new String'("Étival"),39130,319,284,23,13.83,5.8,46.5,759,1027),
(39,new String'("Chevrotaine"),39130,37,31,6,5.33,5.85,46.65,620,811),
(39,new String'("Choux"),39370,126,118,15,8.27,5.76667,46.3167,580,1020),
(39,new String'("La Chaux-en-Bresse"),39230,33,36,16,2.05,5.48333,46.8333,195,223),
(39,new String'("Onoz"),39270,87,62,5,14.85,5.65,46.45,425,740),
(39,new String'("Serre-les-Moulières"),39700,184,141,32,5.67,5.61695,47.205,214,389),
(39,new String'("Quintigny"),39570,221,201,60,3.65,5.53333,46.7333,212,395),
(39,new String'("Villers-Farlay"),39600,551,429,54,10.04,5.75,47.0,226,291),
(39,new String'("Menotey"),39290,279,235,55,5.02,5.5,47.1667,211,345),
(39,new String'("Moutonne"),39270,118,81,29,3.99,5.56667,46.5167,470,578),
(39,new String'("Montfleur"),39320,168,150,21,7.88,5.43333,46.3167,327,590),
(39,new String'("Villette-lès-Dole"),39100,775,645,168,4.59,5.5,47.05,195,232),
(39,new String'("Pont-d'Héry"),39110,255,206,18,13.54,5.9,46.8667,430,781),
(39,new String'("Gendrey"),39350,390,310,28,13.9,5.68333,47.2,222,371),
(39,new String'("Villerserine"),39800,50,42,17,2.85,5.65,46.85,239,271),
(39,new String'("Saligney"),39350,171,153,21,7.98,5.63333,47.2167,199,354),
(39,new String'("Crotenay"),39300,677,598,58,11.61,5.81667,46.75,469,642),
(39,new String'("Foucherans"),39100,1877,1760,243,7.7,5.45,47.0833,203,278),
(39,new String'("Ravilloles"),39170,514,404,65,7.79,5.8,46.4333,590,980),
(39,new String'("Saint-Lothain"),39230,460,436,37,12.33,5.63333,46.8167,242,480),
(39,new String'("Cernon"),39240,268,254,16,16.45,5.65,46.4,307,801),
(39,new String'("Monteplain"),39700,140,154,83,1.68,5.7,47.15,210,258),
(39,new String'("Gigny"),39320,299,260,18,16.04,5.46112,46.452,359,579),
(39,new String'("Censeau"),39250,313,292,31,9.86,6.06667,46.8167,770,882),
(39,new String'("Ponthoux"),39170,92,80,42,2.18,5.8,46.4,420,890),
(39,new String'("Vevy"),39570,243,257,25,9.62,5.65,46.6667,501,556),
(39,new String'("Damparis"),39500,2799,2799,316,8.85,5.41667,47.0833,187,245),
(39,new String'("Chevreaux"),39190,139,188,22,6.12,5.4,46.5,275,647),
(39,new String'("Tavaux"),39500,4123,4277,297,13.86,5.4,47.0333,189,197),
(39,new String'("Balanod"),39160,323,293,65,4.93,5.36667,46.45,207,435),
(39,new String'("Saint-Loup"),39120,278,279,29,9.58,5.31667,47.0,181,188),
(39,new String'("Sainte-Agnès"),39190,316,287,77,4.08,5.48333,46.6,201,342),
(39,new String'("Crans"),39300,67,72,7,9.03,5.96667,46.7,624,895),
(39,new String'("Châtonnay"),39240,62,47,21,2.82,5.55,46.4333,345,440),
(39,new String'("Le Pin"),39210,264,256,93,2.82,5.56667,46.7,270,385),
(39,new String'("Pagnoz"),39330,229,221,69,3.29,5.81667,46.9667,267,459),
(39,new String'("Saint-Jean-d'Étreux"),39160,142,126,33,4.28,5.36667,46.4167,290,600),
(39,new String'("Longwy-sur-le-Doubs"),39120,537,495,32,16.46,5.36667,46.95,182,189),
(39,new String'("Onglières"),39250,74,70,8,8.99,6.01667,46.8,728,892),
(39,new String'("Vosbles"),39240,98,101,7,12.67,5.51667,46.3333,319,730),
(39,new String'("Dessia"),39320,74,70,15,4.64,5.5,46.3833,510,671),
(39,new String'("Saint-Cyr-Montmalin"),39600,208,175,20,10.21,5.72945,46.9495,237,335),
(39,new String'("Desnes"),39140,475,426,52,9.06,5.46667,46.7667,201,226),
(39,new String'("Biarne"),39290,363,354,58,6.21,5.45,47.15,192,262),
(39,new String'("Cerniébaud"),39250,65,53,6,10.53,6.1,46.7333,926,1237),
(39,new String'("Chaux-des-Crotenay"),39150,404,375,34,11.67,5.96667,46.6667,560,859),
(39,new String'("Saint-Germain-en-Montagne"),39300,421,390,78,5.35,5.93333,46.7833,588,850),
(39,new String'("La Mouille"),39400,317,287,39,8.06,5.98333,46.5,600,1100),
(39,new String'("Geraise"),39110,44,40,7,6.04,5.95,46.95,470,742),
(39,new String'("Gevry"),39100,653,626,122,5.31,5.45,47.0333,192,198),
(39,new String'("La Châtelaine"),39600,127,133,9,13.17,5.81667,46.8667,470,633),
(39,new String'("Montbarrey"),39380,332,282,34,9.7,5.65,47.0167,212,247),
(39,new String'("Le Larderet"),39300,81,72,12,6.31,5.95,46.8167,590,796),
(39,new String'("Montain"),39210,496,405,216,2.29,5.58333,46.7167,284,380),
(39,new String'("Vaux-sur-Poligny"),39800,126,112,100,1.26,5.71667,46.8333,377,577),
(39,new String'("Villers-Robert"),39120,206,157,20,10.13,5.51667,46.95,202,243),
(39,new String'("Moutoux"),39300,55,58,12,4.27,5.93333,46.7833,585,870),
(39,new String'("Grange-de-Vaivre"),39600,48,45,27,1.74,5.85,47.0,245,403),
(39,new String'("Bletterans"),39140,1394,1360,174,7.97,5.45,46.75,190,224),
(39,new String'("Monnières"),39100,453,404,219,2.06,5.46667,47.1167,220,341),
(39,new String'("Véria"),39160,139,118,13,10.09,5.43333,46.45,377,642),
(39,new String'("Saint-Claude"),39200,11026,12296,157,70.19,5.86667,46.3833,360,1222),
(39,new String'("Louvatange"),39350,117,71,35,3.31,5.71667,47.2,234,265),
(39,new String'("Moussières"),39310,196,164,11,16.95,5.9,46.3333,880,1310),
(39,new String'("Lavancia-Epercy"),1590,647,619,61,10.56,5.68333,46.3333,305,901),
(39,new String'("Gatey"),39120,364,247,24,14.84,5.43333,46.95,197,223),
(39,new String'("Péseux"),39120,289,248,53,5.36,5.36667,46.9917,187,190),
(39,new String'("Chapelle-Voland"),39140,619,567,20,30.5,5.36667,46.8,183,218),
(39,new String'("Villette-lès-Arbois"),39600,399,304,73,5.45,5.75,46.9167,248,338),
(39,new String'("Le Deschaux"),39120,997,787,116,8.56,5.5,46.95,201,236),
(39,new String'("Châtillon"),39130,141,127,8,16.77,5.73333,46.65,447,747),
(39,new String'("Moissey"),39290,570,527,53,10.63,5.51667,47.2,217,377),
(39,new String'("Saint-Maurice-Crillat"),39130,212,210,10,20.79,5.83251,46.5698,579,1135),
(39,new String'("Abergement-lès-Thésy"),39110,67,53,14,4.63,5.93333,46.9167,619,732),
(39,new String'("La Frasnée"),39130,38,41,11,3.19,5.8,46.55,538,775),
(39,new String'("Orgelet"),39270,1685,1691,72,23.11,5.61667,46.5167,374,653),
(39,new String'("Montagna-le-Templier"),39320,95,88,13,7.05,5.45,46.35,340,571),
(39,new String'("Alièze"),39270,155,144,26,5.86,5.58333,46.5833,538,686),
(39,new String'("La Bretenière"),39700,202,165,123,1.63,5.66001,47.1289,208,257),
(39,new String'("Geruge"),39570,166,146,38,4.36,5.53333,46.6333,378,550),
(39,new String'("La Loye"),39380,546,509,27,19.56,5.56667,47.0333,200,247),
(39,new String'("Colonne"),39800,257,234,23,11.13,5.58333,46.8833,213,245),
(39,new String'("Chemenot"),39230,37,35,7,4.74,5.53333,46.8667,203,227),
(39,new String'("Saizenay"),39110,108,119,22,4.88,5.91667,46.9667,498,737),
(39,new String'("Nevy-lès-Dole"),39380,249,217,35,7.01,5.51667,47.0,198,242),
(39,new String'("Entre-deux-Monts"),39150,159,123,29,5.36,5.96667,46.65,713,940),
(39,new String'("Nancuise"),39270,42,47,8,5.21,5.53333,46.4667,364,584),
(39,new String'("Commenailles"),39140,780,720,36,21.52,5.45,46.8,194,222),
(39,new String'("Coyron"),39260,74,58,13,5.53,5.7,46.5,423,555),
(39,new String'("La Barre"),39700,230,230,69,3.31,5.68333,47.15,209,262),
(39,new String'("Marnoz"),39110,400,320,82,4.87,5.83333,46.95,276,616),
(39,new String'("Courlaoux"),39570,955,848,76,12.42,5.45,46.6667,201,230),
(39,new String'("Foncine-le-Haut"),39460,1024,948,35,28.95,6.08333,46.6667,750,1212),
(39,new String'("Le Latet"),39300,75,63,18,4.02,5.93333,46.8,586,800),
(39,new String'("Orchamps"),39700,1047,1009,105,9.92,5.66667,47.15,206,267),
(39,new String'("Aumur"),39410,368,343,39,9.22,5.35,47.05,181,191),
(39,new String'("Cize"),39300,821,827,195,4.19,5.91667,46.7333,515,811),
(39,new String'("Amange"),39700,372,290,54,6.77,5.56667,47.15,210,376),
(39,new String'("Savigna"),39240,110,118,11,9.96,5.6,46.4333,349,571),
(39,new String'("Morez"),39400,5154,6141,532,9.67,6.03333,46.5167,650,1302),
(39,new String'("Crançot"),39570,556,487,38,14.37,5.66667,46.6833,450,561),
(39,new String'("Longcochon"),39250,48,51,13,3.64,6.06667,46.7667,758,886),
(39,new String'("Archelange"),39290,235,213,46,5.09,5.51667,47.15,229,352),
(39,new String'("Rothonay"),39270,123,143,9,12.98,5.53333,46.5167,449,591),
(39,new String'("Chavéria"),39270,220,171,21,10.22,5.58333,46.5,380,620),
(39,new String'("Foulenay"),39230,84,81,20,4.16,5.48333,46.8667,197,221),
(39,new String'("Frébuans"),39570,366,345,138,2.65,5.48333,46.65,209,271),
(39,new String'("Chambéria"),39270,167,149,11,14.67,5.56667,46.4667,356,582),
(39,new String'("Aromas"),39240,540,496,28,18.75,5.48333,46.3,390,660),
(39,new String'("Maisod"),39260,318,271,43,7.39,5.68333,46.4667,423,553),
(39,new String'("Cousance"),39190,1231,1297,192,6.39,5.39056,46.532,196,330),
(39,new String'("Arinthod"),39240,1150,1214,58,19.77,5.56667,46.3833,335,841),
(39,new String'("Gizia"),39190,216,221,29,7.35,5.43333,46.5167,220,633),
(39,new String'("Mantry"),39230,441,456,40,10.83,5.56667,46.8,216,385),
(39,new String'("Beffia"),39270,88,81,17,5.17,5.55,46.5167,474,585),
(39,new String'("Le Pasquier"),39300,254,252,32,7.75,5.9,46.8,577,661),
(39,new String'("Saint-Laurent-en-Grandvaux"),39150,1800,1790,102,17.57,5.95667,46.5764,824,1094),
(39,new String'("Lavans-lès-Saint-Claude"),39170,1878,1900,161,11.65,5.78333,46.3833,356,936),
(39,new String'("Digna"),39190,367,301,108,3.38,5.4,46.5,198,410),
(39,new String'("Bellecombe"),39310,79,92,6,12.17,5.92223,46.3242,1150,1380),
(39,new String'("La Vieille-Loye"),39380,383,345,41,9.19,5.63333,47.0333,217,252),
(39,new String'("Cramans"),39600,480,432,59,8.13,5.76667,47.0167,229,340),
(39,new String'("Lac-des-Rouges-Truites"),39150,361,331,18,19.69,5.99751,46.6062,829,1181),
(39,new String'("Esserval-Combe"),39250,17,21,9,1.76,6.04001,46.8012,730,846),
(39,new String'("Condes"),39240,115,108,56,2.05,5.61667,46.3333,300,600),
(39,new String'("Villeneuve-lès-Charnod"),39240,85,65,12,7.05,5.46667,46.3333,419,641),
(39,new String'("Brevans"),39100,628,655,173,3.62,5.51667,47.1,200,235),
(39,new String'("Courbouzon"),39570,592,565,176,3.35,5.53333,46.65,245,460),
(39,new String'("Moiron"),39570,142,135,76,1.85,5.56667,46.6333,281,492),
(39,new String'("Cuttura"),39170,335,345,56,5.95,5.8,46.4167,479,900),
(39,new String'("Bourcia"),39320,115,110,10,11.13,5.41667,46.35,348,770),
(39,new String'("Vers-en-Montagne"),39300,201,196,24,8.35,5.91667,46.8167,586,660),
(39,new String'("Plaisia"),39270,115,115,21,5.31,5.63333,46.5333,420,690),
(39,new String'("Biefmorin"),39800,76,67,6,11.25,5.56667,46.9,205,246),
(39,new String'("Le Petit-Mercey"),39350,111,58,44,2.49,5.75,47.2,240,278),
(39,new String'("Montagna-le-Reconduit"),39160,124,109,22,5.43,5.4,46.4667,270,553),
(39,new String'("Belmont"),39380,271,257,16,16.06,5.59417,47.0162,207,249),
(39,new String'("Supt"),39300,106,107,7,13.97,5.95,46.85,612,881),
(39,new String'("Bonlieu"),39130,259,232,19,13.05,5.85,46.6,620,1023),
(39,new String'("Coisia"),39240,162,122,24,6.73,5.58333,46.3167,285,756),
(39,new String'("Balaiseaux"),39120,268,188,44,6.01,5.46667,46.9667,196,222),
(39,new String'("Taxenne"),39350,92,97,23,3.84,5.68333,47.2167,212,353),
(39,new String'("Rosay"),39190,125,139,12,9.93,5.45,46.5167,359,637),
(39,new String'("Ruffey-sur-Seille"),39140,760,736,42,18.01,5.5,46.75,201,304),
(39,new String'("Saugeot"),39130,53,59,11,4.49,5.83333,46.6,600,755),
(39,new String'("Rainans"),39290,226,172,61,3.67,5.48333,47.15,199,310),
(39,new String'("Champdivers"),39500,439,434,58,7.45,5.38333,47.0167,187,192),
(39,new String'("Rotalier"),39190,171,163,42,4.07,5.48333,46.5833,224,572),
(39,new String'("Patornay"),39130,137,169,76,1.8,5.7,46.5833,429,479),
(39,new String'("Lavigny"),39210,365,363,67,5.38,5.6,46.7167,275,517),
(39,new String'("Salans"),39700,574,465,83,6.88,5.8,47.1667,211,276),
(39,new String'("Boissia"),39130,142,104,25,5.67,5.73473,46.5925,426,528),
(39,new String'("Miéry"),39800,147,104,19,7.67,5.66667,46.8167,305,560),
(39,new String'("Syam"),39300,199,222,28,6.9,5.95,46.7,521,794),
(39,new String'("Molay"),39500,500,476,78,6.38,5.42028,47.02,190,196),
(39,new String'("Ivrey"),39110,58,58,8,6.67,5.9,46.9833,319,810),
(39,new String'("Saint-Maur"),39570,211,168,32,6.5,5.58333,46.6167,525,643),
(39,new String'("Louvenne"),39320,143,113,18,7.8,5.46667,46.4167,355,563),
(39,new String'("Martigna"),39260,205,193,23,8.77,5.7,46.4,500,774),
(39,new String'("Prémanon"),39220,1043,663,37,28.18,6.03333,46.4667,769,1417),
(39,new String'("Andelot-Morval"),39320,88,79,8,10.54,5.41639,46.4253,360,593),
(39,new String'("Dompierre-sur-Mont"),39270,245,179,33,7.37,5.6,46.55,486,644),
(39,new String'("Parcey"),39100,955,838,106,8.94,5.48333,47.0167,192,215),
(39,new String'("Séligney"),39120,90,111,21,4.15,5.53333,46.9333,209,241),
(39,new String'("Chemilla"),39240,96,73,51,1.87,5.56667,46.3667,322,521),
(39,new String'("Lavans-lès-Dole"),39700,335,265,32,10.27,5.63333,47.15,205,266),
(39,new String'("Pointre"),39290,114,80,17,6.54,5.5,47.2167,194,218),
(39,new String'("Dournon"),39110,126,102,19,6.55,5.96667,46.9333,593,719),
(39,new String'("Montaigu"),39570,500,507,70,7.1,5.56667,46.6667,270,544),
(39,new String'("Jouhe"),39100,569,438,95,5.96,5.48333,47.1333,202,342),
(39,new String'("Abergement-le-Grand"),39600,64,41,15,4.22,5.68333,46.9167,239,288),
(39,new String'("Blois-sur-Seille"),39210,103,82,19,5.4,5.66667,46.75,285,548),
(39,new String'("Le Vernois"),39210,280,232,259,1.08,5.6,46.7333,269,317),
(39,new String'("Chalesmes"),39150,102,90,10,9.47,6.03806,46.6895,830,1113),
(39,new String'("Neuvilley"),39800,74,46,18,4.07,5.6,46.9,222,252),
(39,new String'("Poligny"),39800,4226,4518,84,50.22,5.71667,46.8333,252,626),
(39,new String'("Andelot-en-Montagne"),39110,540,549,43,12.48,5.93333,46.85,597,740),
(39,new String'("Gevingey"),39570,452,417,76,5.9,5.5,46.6333,242,487),
(39,new String'("Pont-de-Poitte"),39130,659,581,93,7.02,5.68333,46.5833,425,570),
(39,new String'("Graye-et-Charnay"),39320,139,101,22,6.31,5.46667,46.4667,367,604),
(39,new String'("Lavans-sur-Valouse"),39240,139,148,14,9.51,5.55,46.3333,320,799),
(39,new String'("Saint-Germain-lès-Arlay"),39210,502,503,82,6.08,5.56667,46.7667,222,386),
(39,new String'("Buvilly"),39800,360,338,60,6.0,5.71667,46.8667,290,575),
(39,new String'("Molamboz"),39600,85,84,12,7.06,5.68333,46.9333,223,290),
(39,new String'("Sergenaux"),39230,61,35,18,3.24,5.45,46.8833,197,221),
(39,new String'("La Latette"),39250,74,77,12,5.89,6.08333,46.75,829,971),
(39,new String'("Chêne-Bernard"),39120,72,62,19,3.61,5.48333,46.9167,197,223),
(39,new String'("Lamoura"),39310,529,438,23,22.28,5.96667,46.4,1064,1495),
(39,new String'("Saint-Baraing"),39120,271,181,43,6.28,5.43333,46.9833,187,217),
(39,new String'("Le Chateley"),39230,85,77,18,4.67,5.55,46.8833,209,231),
(39,new String'("Planches-près-Arbois"),39600,101,79,72,1.39,5.8,46.8833,320,571),
(39,new String'("Vescles"),39240,211,183,10,20.27,5.6,46.3667,305,800),
(39,new String'("Germigney"),39380,91,77,16,5.44,5.68806,47.0267,220,254),
(39,new String'("Fontainebrux"),39140,178,131,26,6.75,5.41667,46.7,195,229),
(39,new String'("Abergement-le-Petit"),39800,41,43,26,1.52,5.7,46.9,250,290),
(39,new String'("Montmorot"),39570,3061,3090,269,11.36,5.51667,46.6833,223,355),
(39,new String'("Chilly-sur-Salins"),39110,94,92,7,11.94,5.86667,46.8833,573,695),
(39,new String'("Frontenay"),39210,167,170,20,8.13,5.61667,46.7833,250,563),
(39,new String'("Bonnaud"),39190,46,30,27,1.65,5.43333,46.6167,194,216),
(39,new String'("Blye"),39130,152,117,14,10.76,5.7,46.6167,436,590),
(39,new String'("Pont-du-Navoy"),39300,246,226,26,9.46,5.78333,46.7333,463,741),
(39,new String'("Nanc-lès-Saint-Amour"),39160,285,261,53,5.29,5.35862,46.4228,209,596),
(39,new String'("Lent"),39300,125,137,30,4.11,5.97889,46.7442,625,808),
(39,new String'("Repôts"),39140,36,23,8,4.02,5.41667,46.6833,199,220),
(39,new String'("Charcier"),39130,120,107,9,12.91,5.75,46.6333,448,654),
(39,new String'("Brainans"),39800,168,166,23,7.07,5.61667,46.8667,232,301),
(39,new String'("Chaux-Champagny"),39110,63,73,8,7.33,5.88889,46.8959,401,740),
(39,new String'("Chaînée-des-Coupis"),39120,195,138,38,5.04,5.43333,46.9333,203,220),
(39,new String'("Chaussin"),39120,1617,1579,96,16.82,5.41667,46.9667,183,214),
(39,new String'("Francheville"),39230,37,26,25,1.46,5.5,46.8333,203,223),
(39,new String'("Arbois"),39600,3520,3698,77,45.42,5.76667,46.9,246,613),
(39,new String'("Dammartin-Marpain"),39290,290,227,25,11.32,5.54473,47.2567,191,241),
(39,new String'("Cosges"),39140,329,301,24,13.49,5.4,46.75,187,216),
(39,new String'("Charézier"),39130,148,139,15,9.26,5.73333,46.6167,434,609),
(39,new String'("Sirod"),39300,572,528,35,16.1,5.98333,46.7333,560,890),
(39,new String'("Doucier"),39130,295,270,23,12.52,5.76667,46.65,447,635),
(39,new String'("Pupillin"),39600,247,218,37,6.61,5.76667,46.8833,283,622),
(39,new String'("Le Villey"),39230,80,92,22,3.57,5.5,46.85,198,222),
(39,new String'("La Chaumusse"),39150,357,289,33,10.62,5.93333,46.5833,790,958),
(39,new String'("Bief-du-Fourg"),39250,165,131,16,10.2,6.11667,46.8167,840,883),
(39,new String'("Voiteur"),39210,756,720,80,9.42,5.61667,46.75,245,497),
(39,new String'("Vulvoz"),39360,20,16,4,4.49,5.78333,46.3333,448,1010),
(39,new String'("Songeson"),39130,74,58,8,8.42,5.81667,46.65,530,832),
(39,new String'("Courtefontaine"),39700,217,178,15,13.64,5.80417,47.1292,225,306),
(39,new String'("Marigny"),39130,180,172,15,11.99,5.78333,46.6833,454,628),
(39,new String'("La Tour-du-Meix"),39270,229,162,17,13.42,5.66667,46.5333,423,686),
(39,new String'("Senaud"),39160,56,39,13,4.06,5.38333,46.4,390,596),
(39,new String'("Bourg-de-Sirod"),39300,98,86,22,4.42,5.95695,46.7289,529,804),
(39,new String'("Publy"),39570,283,262,18,15.18,5.65,46.6333,471,669),
(39,new String'("Cressia"),39270,277,314,18,14.99,5.48333,46.5167,431,637),
(39,new String'("Menétrux-en-Joux"),39130,56,47,6,8.78,5.83333,46.6167,502,819),
(39,new String'("Perrigny"),39570,1538,1643,173,8.89,5.58333,46.6667,271,564),
(39,new String'("Mignovillard"),39250,683,644,13,49.81,6.13333,46.8,799,1189),
(39,new String'("Longchaumois"),39400,1145,1092,19,57.6,5.93333,46.45,470,1411),
(39,new String'("Chassal"),39360,495,510,95,5.19,5.78333,46.3667,340,665),
(39,new String'("Nance"),39140,494,429,67,7.34,5.43333,46.7333,191,222),
(39,new String'("Montrevel"),39320,100,107,15,6.39,5.5,46.4333,370,629),
(39,new String'("Chêne-Sec"),39230,35,53,46,0.76,5.43333,46.85,193,216),
(39,new String'("Thoissia"),39160,46,24,11,3.89,5.4,46.4333,427,605),
(39,new String'("Besain"),39800,157,180,12,12.84,5.8,46.7833,514,640),
(39,new String'("Malange"),39700,295,242,35,8.4,5.61667,47.1833,212,391),
(39,new String'("Champrougier"),39230,94,104,10,8.73,5.51667,46.8667,202,226),
(39,new String'("Foncine-le-Bas"),39520,205,182,22,9.29,6.05,46.6333,730,1181),
(39,new String'("Légna"),39240,200,149,19,10.3,5.58333,46.4333,370,812),
(39,new String'("Saint-Julien"),39320,463,409,37,12.28,5.45334,46.3945,346,591),
(39,new String'("Monnet-la-Ville"),39300,368,330,59,6.19,5.8,46.7167,478,690),
(39,new String'("Montcusel"),39260,176,172,18,9.55,5.65,46.3667,420,802),
(39,new String'("Saffloz"),39130,105,87,12,8.65,5.85,46.6667,619,815),
(39,new String'("Coiserette"),39200,46,46,7,5.91,5.83333,46.35,546,1090),
(39,new String'("Larrivoire"),39360,102,108,15,6.5,5.78333,46.35,380,1010),
(39,new String'("Sarrogna"),39270,225,183,11,19.87,5.61667,46.4667,390,744),
(39,new String'("Cesancey"),39570,404,334,78,5.12,5.5,46.6333,204,450),
(39,new String'("Villard-sur-Bienne"),39200,196,132,18,10.37,5.9,46.4667,485,962),
(39,new String'("Val-d'Épy"),39160,151,134,17,8.64,5.39862,46.3828,285,555),
(39,new String'("Présilly"),39270,118,102,10,11.23,5.58333,46.55,480,701),
(39,new String'("Nogna"),39570,255,203,41,6.11,5.63333,46.6,497,623),
(39,new String'("Bretenières"),39120,38,30,9,4.11,5.55,46.9167,213,245),
(39,new String'("Chevigny"),39290,287,214,37,7.67,5.48333,47.1833,192,295),
(39,new String'("Aiglepierre"),39110,428,342,61,6.97,5.81667,46.95,278,631),
(39,new String'("Éclans-Nenon"),39700,410,382,15,25.83,5.60473,47.1248,205,261),
(39,new String'("Villeneuve-sous-Pymont"),39570,282,217,105,2.67,5.55,46.6833,260,390),
(39,new String'("Verges"),39570,172,169,27,6.16,5.68333,46.65,500,613),
(39,new String'("Vriange"),39700,119,137,20,5.78,5.58333,47.1833,226,378),
(39,new String'("Bois-d'Amont"),39220,1677,1518,139,12.06,6.1315,46.5333,1042,1310),
(39,new String'("Septmoncel"),39310,684,659,35,19.4,5.91667,46.3667,448,1281),
(39,new String'("Le Fied"),39800,191,180,22,8.39,5.71667,46.7667,520,562),
(39,new String'("Ney"),39300,554,578,76,7.26,5.88333,46.7333,489,719),
(39,new String'("Morbier"),39400,2255,2059,54,41.58,6.01667,46.5333,650,1180),
(39,new String'("Aumont"),39800,430,405,53,7.97,5.63333,46.9,227,297),
(39,new String'("Champvans"),39100,1357,1363,95,14.22,5.43556,47.105,188,290),
(39,new String'("Saint-Thiébaud"),39110,68,60,8,7.94,5.86667,46.9667,380,850),
(39,new String'("Granges-sur-Baume"),39210,132,130,16,7.93,5.65,46.7167,400,550),
(39,new String'("Souvans"),39380,500,451,25,19.66,5.55,47.0,202,246),
(39,new String'("Pratz"),39170,576,453,58,9.85,5.76667,46.3833,400,948),
(39,new String'("Choisey"),39100,1056,985,138,7.64,5.46667,47.0667,193,231),
(39,new String'("Vaudrey"),39380,384,317,21,17.87,5.61667,46.9833,212,259),
(39,new String'("Plasne"),39800,248,254,31,7.76,5.68333,46.8,480,606),
(39,new String'("Châtel-de-Joux"),39130,57,48,4,14.13,5.8,46.5333,596,1003),
(39,new String'("Rye"),39230,183,161,15,11.84,5.43333,46.8667,190,219),
(39,new String'("Monnetay"),39320,19,16,7,2.46,5.51667,46.45,429,598),
(39,new String'("Saint-Didier"),39570,308,267,101,3.02,5.51667,46.7,210,333),
(39,new String'("Coyrière"),39200,67,74,16,4.11,5.85,46.35,520,1125),
(39,new String'("Bornay"),39570,175,181,25,6.76,5.55,46.6167,335,629),
(39,new String'("Villechantria"),39320,124,112,19,6.28,5.45,46.3833,336,556),
(39,new String'("Chaumergy"),39230,478,412,77,6.14,5.48333,46.85,196,224),
(39,new String'("Vadans"),39600,254,268,22,11.25,5.7,46.9333,235,323),
(39,new String'("Salins-les-Bains"),39110,2926,3347,118,24.68,5.88333,46.95,284,737),
(39,new String'("Arsures"),39600,236,213,53,4.44,5.79084,46.9492,256,400),
(39,new String'("Vannoz"),39300,233,216,40,5.75,5.91667,46.7667,565,800),
(39,new String'("Ladoye-sur-Seille"),39210,61,69,16,3.69,5.68333,46.7667,338,560),
(39,new String'("Picarreau"),39800,94,87,10,8.96,5.75,46.75,530,628),
(39,new String'("Aresches"),39110,41,50,8,4.76,5.91667,46.9,570,736),
(39,new String'("Asnans-Beauvoisin"),39120,696,541,42,16.24,5.41167,46.9467,183,220),
(39,new String'("Molain"),39800,126,94,10,11.5,5.8,46.8167,560,686),
(39,new String'("Plainoiseau"),39210,547,508,101,5.38,5.55,46.7333,253,424),
(39,new String'("Saint-Aubin"),39410,1758,1539,52,33.76,5.33333,47.0333,180,192),
(39,new String'("Deux-Fays"),39230,122,115,18,6.77,5.48333,46.8833,200,226),
(39,new String'("Montigny-lès-Arsures"),39600,270,268,25,10.63,5.78333,46.9333,254,580),
(39,new String'("Mallerey"),39190,63,59,21,2.9,5.45,46.6333,196,228),
(39,new String'("Audelange"),39700,252,206,54,4.64,5.58333,47.1333,203,257),
(39,new String'("Montholier"),39800,326,285,40,7.99,5.65,46.9,228,310),
(39,new String'("Chancia"),1590,239,142,99,2.41,5.63333,46.35,300,680),
(39,new String'("Montmarlon"),39110,31,29,9,3.28,5.96306,46.8753,630,741),
(39,new String'("Rans"),39700,477,416,77,6.14,5.73333,47.1333,209,269),
(39,new String'("Ivory"),39110,84,84,9,9.13,5.86667,46.9167,544,632),
(39,new String'("Petit-Noir"),39120,1134,971,55,20.52,5.33333,46.9333,177,215),
(39,new String'("Cuvier"),39250,221,167,21,10.32,6.06667,46.8333,798,885),
(39,new String'("Lains"),39320,80,77,8,9.81,5.5,46.4,365,660),
(39,new String'("Menétru-le-Vignoble"),39210,155,138,26,5.88,5.61667,46.7667,267,550),
(39,new String'("Sergenon"),39120,49,50,12,3.88,5.45,46.9,196,222),
(39,new String'("Doye"),39250,92,69,25,3.56,6.01667,46.7667,630,801),
(39,new String'("Esserval-Tartre"),39250,84,69,6,12.19,6.05,46.8167,730,904),
(39,new String'("Arthenas"),39270,161,141,23,6.71,5.53333,46.5833,464,603),
(39,new String'("Tassenières"),39120,385,332,57,6.64,5.51667,46.9167,208,244),
(39,new String'("Oussières"),39800,229,223,30,7.54,5.58333,46.9,220,254),
(39,new String'("Briod"),39570,214,164,52,4.04,5.61667,46.6667,505,555),
(39,new String'("Neublans-Abergement"),39120,515,390,44,11.64,5.32973,46.9095,180,215),
(39,new String'("Montigny-sur-l'Ain"),39300,192,179,24,7.99,5.78333,46.7167,460,661),
(39,new String'("La Favière"),39250,32,30,11,2.78,6.03306,46.7528,725,885),
(39,new String'("Mirebel"),39570,243,202,14,16.63,5.73333,46.7,460,747),
(39,new String'("Lézat"),39400,186,196,32,5.75,5.93333,46.5,530,1115),
(39,new String'("Port-Lesney"),39600,553,414,50,10.91,5.81667,47.0,240,440),
(39,new String'("Revigny"),39570,264,253,40,6.51,5.6,46.6333,335,574),
(39,new String'("Montrond"),39300,504,408,19,25.32,5.83333,46.8,513,678),
(39,new String'("Fontenu"),39130,67,40,9,6.71,5.81667,46.6667,485,667),
(39,new String'("Bief-des-Maisons"),39150,75,85,12,5.79,6.03333,46.7,890,1144),
(39,new String'("Molpré"),39250,24,33,8,2.73,6.06751,46.7875,739,879),
(39,new String'("Bonnefontaine"),39800,96,84,10,8.8,5.75,46.7333,534,745),
(39,new String'("Marnézia"),39270,94,48,18,4.97,5.63333,46.5667,507,703),
(39,new String'("Pannessières"),39570,445,466,83,5.35,5.6,46.7,280,527),
(39,new String'("Essia"),39270,64,54,13,4.86,5.55,46.5833,459,640),
(39,new String'("Gredisans"),39290,147,136,62,2.37,5.51667,47.15,240,348),
(39,new String'("Darbonnay"),39230,97,95,22,4.39,5.6,46.8167,236,288),
(39,new String'("La Rixouse"),39200,208,215,16,12.59,5.88333,46.4667,443,996),
(39,new String'("Relans"),39140,345,248,72,4.74,5.45,46.7667,199,222),
(39,new String'("Chilly-le-Vignoble"),39570,605,393,197,3.07,5.5,46.65,212,287),
(39,new String'("Poids-de-Fiole"),39570,301,252,46,6.49,5.63333,46.6,513,611),
(39,new String'("Le Frasnois"),39130,154,151,10,14.56,5.9,46.6333,680,930),
(39,new String'("Clairvaux-les-Lacs"),39130,1424,1473,115,12.29,5.75,46.5667,450,826),
(39,new String'("Le Louverot"),39210,254,312,145,1.74,5.58389,46.7303,250,340),
(39,new String'("Valfin-sur-Valouse"),39240,85,91,9,8.67,5.53333,46.3667,335,689),
(39,new String'("Mont-sur-Monnet"),39300,220,174,11,19.93,5.83333,46.7167,502,745),
(39,new String'("Abergement-la-Ronce"),39500,765,735,107,7.12,5.38333,47.0667,186,195),
(39,new String'("Cuisia"),39190,402,364,39,10.16,5.4,46.5333,193,554),
(39,new String'("Fraroz"),39250,45,41,7,6.22,6.08333,46.7333,889,1222),
(39,new String'("Largillay-Marsonnay"),39130,189,134,27,6.98,5.66667,46.55,425,680),
(39,new String'("Meussia"),39260,424,382,31,13.64,5.73333,46.5,439,875),
(39,new String'("Thoiria"),39130,164,150,13,12.24,5.73333,46.5333,430,873),
(39,new String'("Communailles-en-Montagne"),39250,44,42,10,4.01,6.1,46.8,770,888),
(39,new String'("Denezières"),39130,85,78,13,6.41,5.8,46.6167,519,673),
(39,new String'("Cornod"),39240,236,219,16,13.99,5.55,46.3167,305,680),
(39,new String'("Baume-les-Messieurs"),39570,190,194,14,13.09,5.63333,46.7167,277,572),
(39,new String'("Charency"),39250,55,41,20,2.73,6.0,46.7667,630,804),
(39,new String'("Vercia"),39190,316,244,77,4.06,5.45,46.5833,198,296),
(39,new String'("Sellières"),39230,786,775,79,9.9,5.56667,46.8333,212,310),
(39,new String'("La Pesse"),39370,353,263,14,24.26,5.85,46.3,800,1440),
(39,new String'("Valempoulières"),39300,215,172,13,16.25,5.86667,46.8333,610,766),
(39,new String'("Orbagna"),39190,181,166,44,4.11,5.45,46.5833,199,572),
(39,new String'("Nevy-sur-Seille"),39210,235,244,35,6.56,5.63333,46.75,257,526),
(39,new String'("Piards"),39150,186,176,35,5.29,5.83333,46.4833,884,1030),
(39,new String'("L'Aubépin"),39160,140,131,24,5.67,5.36667,46.4333,325,590),
(39,new String'("Chatelay"),39380,90,108,6,13.07,5.7,47.0333,223,259),
(39,new String'("Romain"),39350,210,140,34,6.07,5.71667,47.2167,240,298),
(39,new String'("Loisia"),39320,172,157,14,11.58,5.45,46.4833,371,637),
(39,new String'("Rousses"),39220,3108,2929,81,38.0,6.06667,46.4833,720,1300),
(39,new String'("Marigna-sur-Valouse"),39240,106,81,12,8.35,5.53333,46.45,354,598),
(39,new String'("Moirans-en-Montagne"),39260,2284,2123,85,26.56,5.73333,46.4333,423,981),
(39,new String'("Leschères"),39170,212,153,25,8.28,5.83333,46.45,700,1064),
(39,new String'("Messia-sur-Sorne"),39570,824,805,306,2.69,5.51667,46.6667,233,356),
(39,new String'("Plénise"),39250,58,63,10,5.43,6.03333,46.8,733,907),
(39,new String'("Château-Chalon"),39210,164,160,16,10.17,5.63333,46.75,254,563),
(39,new String'("La Balme-d'Épy"),39320,53,39,17,2.97,5.41667,46.3833,372,556),
(39,new String'("Villers-les-Bois"),39800,200,210,19,10.5,5.58333,46.9167,212,252),
(39,new String'("Saint-Lamain"),39230,123,119,29,4.16,5.6,46.8,236,335),
(39,new String'("Mutigney"),39290,156,143,19,8.0,5.55,47.2833,188,233),
(39,new String'("Vincelles"),39190,386,364,61,6.29,5.48333,46.6,194,440),
(39,new String'("Rix"),39250,81,74,15,5.17,6.05,46.7667,721,923),
(39,new String'("Jeurre"),39360,253,254,36,6.99,5.71667,46.3667,315,696),
(39,new String'("Chissey-sur-Loue"),39380,346,347,8,38.56,5.72084,47.0212,223,282),
(39,new String'("Florentia"),39320,35,24,11,3.18,5.43333,46.4,417,556),
(39,new String'("Cernans"),39110,141,98,25,5.51,5.93333,46.9333,612,724),
(39,new String'("Chaux-des-Prés"),39150,191,168,24,7.79,5.86667,46.5,834,1003),
(39,new String'("Saint-Laurent-la-Roche"),39570,347,276,31,11.13,5.51667,46.6,270,578),
(39,new String'("Vertamboz"),39130,93,68,13,6.66,5.73333,46.6,439,615),
(39,new String'("Courbette"),39570,40,51,15,2.65,5.56667,46.6,494,625),
(39,new String'("Saint-Amour"),39160,2371,2104,203,11.65,5.35,46.4333,200,446),
(39,new String'("Plénisette"),39250,25,30,9,2.61,6.01667,46.8,750,890),
(39,new String'("Rogna"),39360,204,209,19,10.46,5.75,46.3333,410,960),
(39,new String'("Sampans"),39100,928,708,122,7.58,5.45,47.1167,193,342),
(39,new String'("Avignon-lès-Saint-Claude"),39200,360,309,45,7.83,5.84639,46.3906,580,917),
(39,new String'("Chazelles"),39160,125,112,30,4.04,5.33333,46.4,199,302),
(39,new String'("Châtenois"),39700,345,355,42,8.03,5.55251,47.147,207,348),
(39,new String'("Barésia-sur-l'Ain"),39130,154,98,16,9.39,5.7,46.55,423,567),
(39,new String'("Larnaud"),39140,529,493,49,10.67,5.46667,46.7167,197,236),
(39,new String'("Lajoux"),1410,252,220,10,23.65,5.96667,46.3833,936,1495),
(39,new String'("Le Vaudioux"),39300,162,169,26,6.01,5.91667,46.7,540,848),
(39,new String'("Maynal"),39190,306,280,37,8.14,5.41667,46.55,192,574),
(39,new String'("Romange"),39700,212,182,38,5.49,5.6,47.15,211,258),
(39,new String'("Molunes"),39310,141,125,6,20.51,5.92362,46.345,750,1330),
(39,new String'("Villard-Saint-Sauveur"),39200,627,654,69,9.05,5.86667,46.3667,410,1089),
(39,new String'("Nantey"),39160,75,61,11,6.5,5.4,46.4167,382,620),
(39,new String'("Frasne-les-Meulières"),39290,109,119,22,4.88,5.50195,47.2045,197,340),
(39,new String'("Crissey"),39100,655,593,136,4.81,5.48333,47.0667,194,220),
(39,new String'("Étrepigney"),39700,409,357,26,15.6,5.7,47.1333,207,262),
(39,new String'("Viry"),39360,925,827,36,25.4,5.75,46.3,539,1113),
(39,new String'("Tourmont"),39800,465,442,47,9.73,5.68333,46.8667,239,302),
(39,new String'("Mouchard"),39330,1142,1018,184,6.18,5.8,46.9667,244,382),
(39,new String'("Rochefort-sur-Nenon"),39700,563,641,55,10.2,5.56667,47.1167,201,256),
(39,new String'("Dramelay"),39240,34,32,5,6.53,5.53333,46.4,340,629),
(39,new String'("Mesnois"),39130,202,154,17,11.47,5.68333,46.6,434,703),
(39,new String'("Dole"),39100,24629,24955,641,38.38,5.5,47.1,196,341),
(39,new String'("Gillois"),39250,143,119,14,9.65,6.01667,46.7333,690,957),
(39,new String'("Plumont"),39700,92,90,7,12.1,5.71667,47.1167,212,268),
(39,new String'("Saint-Pierre"),39150,322,316,19,16.37,5.91667,46.5667,846,1135),
(39,new String'("Villeneuve-d'Aval"),39600,85,75,21,3.99,5.75,46.9667,237,297),
(39,new String'("Baverans"),39100,444,323,130,3.41,5.53333,47.1,201,237),
(39,new String'("Lons-le-Saunier"),39570,17681,18476,2302,7.68,5.55,46.6667,243,415),
(39,new String'("Ounans"),39380,385,281,31,12.19,5.66667,46.9833,214,253),
(39,new String'("La Chapelle-sur-Furieuse"),39110,329,287,36,9.03,5.86667,47.0,250,550),
(39,new String'("Thésy"),39110,66,62,13,4.92,5.91667,46.9167,639,718),
(39,new String'("Fay-en-Montagne"),39800,76,83,12,6.26,5.73333,46.75,519,567),
(39,new String'("Monay"),39230,134,130,53,2.5,5.6,46.8333,235,347),
(39,new String'("Mournans-Charbonny"),39250,85,91,16,5.06,6.00417,46.78,636,836),
(39,new String'("Champagne-sur-Loue"),39600,130,116,34,3.77,5.81667,47.0333,231,342),
(39,new String'("Vers-sous-Sellières"),39230,226,154,26,8.48,5.53333,46.8167,205,229),
(39,new String'("Annoire"),39120,392,411,24,15.69,5.28333,46.95,177,186),
(39,new String'("Chisséria"),39240,84,71,11,7.25,5.56667,46.3833,335,814),
(39,new String'("Passenans"),39230,336,296,68,4.94,5.61667,46.8,250,491),
(39,new String'("Équevillon"),39300,612,524,126,4.84,5.93333,46.7667,551,812),
(39,new String'("Mesnay"),39600,554,566,66,8.32,5.8,46.9,303,600),
(39,new String'("Bois-de-Gand"),39230,60,62,18,3.25,5.5,46.8333,204,226),
(39,new String'("Essards-Taignevaux"),39120,247,217,45,5.4,5.41667,46.9167,193,219),
(39,new String'("Cogna"),39130,260,212,39,6.6,5.75,46.5833,498,700),
(39,new String'("Montmirey-le-Château"),39290,168,145,20,8.02,5.53333,47.2167,204,293),
(39,new String'("Arsure-Arsurette"),39250,92,87,7,12.56,6.08333,46.7167,875,1205),
(39,new String'("Grande-Rivière"),39150,421,432,13,30.59,5.91306,46.5409,846,1152),
(39,new String'("La Marre"),39210,328,308,30,10.63,5.7,46.7333,510,576),
(39,new String'("Saint-Lupicin"),39170,2140,2081,224,9.54,5.78333,46.4,410,915),
(39,new String'("Soucia"),39130,163,113,13,12.37,5.75,46.55,484,884),
(39,new String'("Trenal"),39570,369,350,55,6.64,5.46667,46.65,198,260),
(39,new String'("Ardon"),39300,132,141,26,5.04,5.88333,46.7667,525,637),
(39,new String'("Fort-du-Plasne"),39150,427,397,33,12.92,5.98889,46.6184,730,970),
(39,new String'("Chapois"),39300,210,206,20,10.07,5.96667,46.8333,597,832),
(39,new String'("Lemuy"),39110,234,264,10,21.33,5.96667,46.9,608,884),
(39,new String'("Champagnole"),39300,8077,8609,400,20.18,5.91667,46.75,476,783),
(39,new String'("Lombard"),39230,182,129,33,5.41,5.5,46.7833,209,253),
(39,new String'("Authume"),39100,808,776,107,7.52,5.5,47.1333,223,337),
(40,new String'("Bergouey"),40250,98,110,22,4.39,-0.716667,43.6667,47,122),
(40,new String'("Samadet"),40320,1056,1010,40,26.19,-0.483333,43.6333,70,185),
(40,new String'("Artassenx"),40090,264,245,48,5.5,-0.383333,43.85,79,122),
(40,new String'("Trensacq"),40630,270,231,3,79.25,-0.75,44.2167,45,104),
(40,new String'("Ondres"),40440,4555,3646,301,15.13,-1.43333,43.5667,3,53),
(40,new String'("Maillas"),40120,113,102,1,63.84,-0.183333,44.25,88,152),
(40,new String'("Saint-Vincent-de-Paul"),40990,2997,2141,92,32.37,-1.0,43.75,2,70),
(40,new String'("Belhade"),40410,192,132,6,28.55,-0.683333,44.375,32,65),
(40,new String'("Betbezer-d'Armagnac"),40240,141,106,17,8.1,-0.171944,43.977,78,144),
(40,new String'("Estigarde"),40240,84,74,2,29.65,-0.116667,44.0333,113,151),
(40,new String'("Gaujacq"),40330,448,413,27,16.14,-0.733333,43.65,29,132),
(40,new String'("Saint-Cricq-Villeneuve"),40190,437,405,27,15.76,-0.35,43.8833,39,106),
(40,new String'("Cassen"),40380,573,372,95,5.97,-0.866667,43.7667,15,65),
(40,new String'("Linxe"),40260,1275,1057,15,80.93,-1.25,43.9167,14,71),
(40,new String'("Campet-et-Lamolère"),40090,346,265,18,18.97,-0.6,43.9167,18,56),
(40,new String'("Lucbardez-et-Bargues"),40090,507,329,23,21.48,-0.4,43.9667,38,97),
(40,new String'("Lacrabe"),40700,237,185,37,6.27,-0.583333,43.6167,49,135),
(40,new String'("Benquet"),40280,1494,1293,50,29.33,-0.5,43.8333,46,91),
(40,new String'("Villeneuve-de-Marsan"),40190,2371,2109,102,23.14,-0.3,43.9,48,116),
(40,new String'("Messanges"),40660,984,646,28,34.0,-1.38333,43.8167,0,60),
(40,new String'("Poyanne"),40380,613,518,57,10.72,-0.816667,43.75,12,99),
(40,new String'("Saint-Perdon"),40090,1707,984,55,30.62,-0.583333,43.8667,20,94),
(40,new String'("Saint-Sever"),40500,4789,4447,101,46.96,-0.566667,43.7667,26,118),
(40,new String'("Saint-Avit"),40090,615,541,15,40.74,-0.445278,43.9412,33,97),
(40,new String'("Josse"),40230,817,730,86,9.48,-1.21667,43.6333,2,36),
(40,new String'("Uza"),40170,155,160,12,12.88,-1.2,44.0333,12,44),
(40,new String'("Castel-Sarrazin"),40330,531,361,44,12.01,-0.783333,43.6167,25,73),
(40,new String'("Montfort-en-Chalosse"),40380,1157,1210,100,11.57,-0.833333,43.7167,26,108),
(40,new String'("Saint-Lon-les-Mines"),40300,1186,905,54,21.82,-1.11667,43.6167,4,105),
(40,new String'("Argelos"),40700,185,173,28,6.44,-0.633333,43.5833,48,157),
(40,new String'("Cauneille"),40300,797,705,51,15.42,-1.06667,43.55,2,136),
(40,new String'("Sainte-Foy"),40190,254,138,27,9.1,-0.332222,43.9373,63,102),
(40,new String'("Port-de-Lanne"),40300,901,702,71,12.68,-1.2,43.5667,0,63),
(40,new String'("Angresse"),40150,1535,1093,199,7.68,-1.38333,43.65,2,21),
(40,new String'("Misson"),40290,716,628,48,14.69,-0.966667,43.5833,27,112),
(40,new String'("Bas-Mauco"),40500,319,277,27,11.5,-0.555278,43.7964,35,74),
(40,new String'("Saint-André-de-Seignanx"),40390,1542,1274,79,19.49,0.648334,43.5573,1,67),
(40,new String'("Seyresse"),40180,798,595,357,2.23,-1.06667,43.6833,2,38),
(40,new String'("Bostens"),40090,176,149,22,7.66,-0.366667,43.9667,80,119),
(40,new String'("Aubagnan"),40700,242,233,71,3.4,-0.5,43.6667,62,140),
(40,new String'("Saugnac-et-Cambran"),40180,1612,1269,121,13.28,-1.0,43.6667,4,77),
(40,new String'("Clèdes"),40320,120,128,17,6.84,-0.383333,43.6167,91,185),
(40,new String'("Morcenx"),40110,4606,4392,74,62.08,-0.916667,44.0333,50,104),
(40,new String'("Pontonx-sur-l'Adour"),40465,2516,2072,50,49.42,-0.933333,43.7833,5,75),
(40,new String'("Carcen-Ponson"),40400,629,564,17,36.72,-0.8,43.8833,12,102),
(40,new String'("Laluque"),40465,823,610,15,52.81,-1.0,43.85,38,86),
(40,new String'("Coudures"),40500,476,384,40,11.65,-0.516667,43.7,50,135),
(40,new String'("Lahosse"),40250,292,257,36,8.08,-0.8,43.7,25,101),
(40,new String'("Moustey"),40410,668,607,9,67.31,-0.76167,44.3586,19,63),
(40,new String'("Pouydesseaux"),40120,901,626,26,34.09,-0.316667,43.9667,48,136),
(40,new String'("Caupenne"),40250,404,361,26,15.22,-0.75,43.6833,32,122),
(40,new String'("Meilhan"),40400,1104,999,28,39.07,-0.7,43.8667,18,84),
(40,new String'("Peyre"),40700,214,223,20,10.25,-0.55,43.5667,60,156),
(40,new String'("Pécorade"),40320,152,164,36,4.17,-0.366667,43.65,95,175),
(40,new String'("Aire-sur-l'Adour"),40800,6279,6003,108,57.78,-0.266667,43.7,68,176),
(40,new String'("Toulouzette"),40250,279,269,24,11.26,-0.683333,43.75,19,98),
(40,new String'("Onesse-et-Laharie"),40110,959,927,7,132.13,-1.06667,44.0667,22,96),
(40,new String'("Mano"),40410,109,93,3,32.27,-0.675,44.4167,38,74),
(40,new String'("Saint-Barthélemy"),40390,370,236,65,5.66,-1.33333,43.5167,0,71),
(40,new String'("Gibret"),40380,103,83,39,2.58,-0.816667,43.7,31,102),
(40,new String'("Cachen"),40120,232,216,6,35.66,-0.433333,44.0667,62,114),
(40,new String'("Saint-Aubin"),40250,502,461,51,9.72,-0.696944,43.7112,32,107),
(40,new String'("Montsoué"),40500,574,557,31,17.98,-0.516667,43.7333,45,166),
(40,new String'("Ozourt"),40380,201,155,50,3.97,-0.883333,43.6667,17,51),
(40,new String'("Créon-d'Armagnac"),40240,335,280,15,21.26,-0.1,44.0,110,163),
(40,new String'("Mouscardès"),40290,258,230,28,9.14,-0.883333,43.5833,45,125),
(40,new String'("Bonnegarde"),40330,287,275,29,9.67,-0.716667,43.5667,49,131),
(40,new String'("Saint-Laurent-de-Gosse"),40390,560,482,32,17.39,-1.26667,43.5333,0,76),
(40,new String'("Montaut"),40500,556,602,37,14.88,-0.656111,43.7409,25,121),
(40,new String'("Gouts"),40400,242,238,22,10.88,-0.8,43.7833,11,34),
(40,new String'("Estibeaux"),40290,654,502,39,16.72,-0.9,43.6,25,126),
(40,new String'("Moliets-et-Maa"),40660,956,609,34,27.66,-1.35,43.85,0,55),
(40,new String'("Castandet"),40270,400,415,24,16.66,-0.35,43.8,67,126),
(40,new String'("Lacquy"),40120,232,221,12,19.28,-0.266667,43.95,75,127),
(40,new String'("Sorde-l'Abbaye"),40300,651,535,39,16.34,-1.05,43.5333,2,135),
(40,new String'("Léon"),40550,1877,1461,29,64.45,-1.3,43.8833,6,67),
(40,new String'("Louer"),40380,266,179,93,2.85,-0.883333,43.75,10,52),
(40,new String'("Gastes"),40160,606,410,17,35.23,-1.15,44.3333,2,60),
(40,new String'("Parentis-en-Born"),40160,5304,4430,47,111.55,-1.06667,44.35,20,57),
(40,new String'("Rion-des-Landes"),40370,2459,2199,20,118.25,-0.916667,43.9333,46,103),
(40,new String'("Mimizan"),40200,7069,6862,61,114.83,-1.23333,44.2,0,80),
(40,new String'("Gaillères"),40090,571,430,40,14.04,-0.366667,43.9333,63,102),
(40,new String'("Grange"),40240,205,190,9,21.13,-0.1,43.9667,90,167),
(40,new String'("Biscarrosse"),40600,12197,9290,76,160.48,-1.16667,44.3917,0,78),
(40,new String'("Orthevielle"),40300,904,718,64,13.94,-1.15,43.55,1,106),
(40,new String'("Beyries"),40700,106,86,24,4.29,-0.633333,43.5667,77,163),
(40,new String'("Castelnau-Chalosse"),40360,555,435,52,10.66,-0.85,43.6667,17,96),
(40,new String'("Classun"),40320,264,180,29,8.82,-0.416667,43.7167,76,154),
(40,new String'("Hagetmau"),40700,4535,4411,159,28.37,-0.583333,43.6667,72,142),
(40,new String'("Duhort-Bachen"),40800,632,600,18,34.17,-0.316667,43.7333,64,159),
(40,new String'("Fargues"),40500,322,264,27,11.84,-0.45,43.7167,57,130),
(40,new String'("Labenne"),40530,4803,3340,196,24.48,-1.41667,43.6,2,52),
(40,new String'("Mézos"),40170,854,816,9,89.05,-1.16667,44.0833,12,72),
(40,new String'("Baigts"),40380,342,322,29,11.64,-0.783333,43.6833,32,122),
(40,new String'("Cagnotte"),40300,700,525,47,14.68,-1.06667,43.6,12,135),
(40,new String'("Sainte-Colombe"),40700,651,455,50,12.79,-0.55,43.6833,50,139),
(40,new String'("Peyrehorade"),40300,3467,3016,215,16.11,-1.1,43.55,2,140),
(40,new String'("Cazalis"),40700,149,134,29,5.13,-0.666667,43.6167,40,127),
(40,new String'("Bias"),40170,765,514,36,20.95,0.782223,44.1459,20,70),
(40,new String'("Sabres"),40630,1220,1106,7,160.13,-0.733333,44.15,58,107),
(40,new String'("Biarrotte"),40390,249,226,50,4.9,0.727779,43.5609,8,55),
(40,new String'("Candresse"),40180,791,558,92,8.54,-0.983333,43.7167,4,48),
(40,new String'("Brocas"),40420,787,700,14,53.46,-0.533333,44.05,54,111),
(40,new String'("Nassiet"),40330,331,279,28,11.77,-0.683333,43.6,38,145),
(40,new String'("Saint-Julien-d'Armagnac"),40240,118,102,8,14.64,-0.116667,43.9667,94,157),
(40,new String'("Montgaillard"),40500,577,485,28,20.46,-0.483333,43.75,38,124),
(40,new String'("Arsague"),40330,347,277,48,7.18,-0.796111,43.5803,46,94),
(40,new String'("Ossages"),40290,478,423,33,14.31,-0.883333,43.55,43,148),
(40,new String'("Le Frêche"),40190,392,386,16,23.41,-0.233333,43.9333,55,124),
(40,new String'("Bordères-et-Lamensans"),40270,349,344,22,15.6,-0.366667,43.7667,52,90),
(40,new String'("Dax"),40100,20665,19557,1048,19.7,-1.05,43.7167,2,46),
(40,new String'("Vieux-Boucau-les-Bains"),40480,1564,1383,368,4.25,-1.4,43.7833,0,21),
(40,new String'("Villenave"),40110,264,254,9,27.37,-0.8,43.9667,27,99),
(40,new String'("Arjuzanx"),40110,212,214,7,29.2,-0.85,44.0167,41,103),
(40,new String'("Arthez-d'Armagnac"),40190,120,102,10,11.17,-0.25,43.9,52,114),
(40,new String'("Castelnau-Tursan"),40320,187,190,20,9.27,-0.4,43.65,74,179),
(40,new String'("Haut-Mauco"),40280,809,720,43,18.64,-0.55,43.8333,49,91),
(40,new String'("Capbreton"),40130,7965,6642,366,21.75,-1.43333,43.6333,0,51),
(40,new String'("Puyol-Cazalet"),40320,122,96,26,4.59,-0.4,43.6,90,167),
(40,new String'("Sainte-Eulalie-en-Born"),40200,1167,785,16,70.83,-1.18333,44.2667,2,62),
(40,new String'("Narrosse"),40180,3015,2507,286,10.53,-1.0,43.7,4,44),
(40,new String'("Lévignacq"),40170,346,345,8,42.32,-1.16667,44.0,27,75),
(40,new String'("Urgons"),40320,264,251,22,11.53,-0.45,43.65,72,160),
(40,new String'("Labrit"),40420,874,715,12,72.18,-0.55,44.1,70,113),
(40,new String'("Saint-Pierre-du-Mont"),40280,8924,7186,339,26.25,-0.516667,43.8833,25,102),
(40,new String'("Boos"),40370,312,149,19,15.81,-0.983333,43.9,60,88),
(40,new String'("Laurède"),40250,371,340,65,5.7,-0.783333,43.75,13,99),
(40,new String'("Saint-Cricq-du-Gave"),40300,370,264,42,8.7,-1.01667,43.5333,6,143),
(40,new String'("Lussagnet"),40270,81,82,9,8.43,-0.233333,43.7667,87,141),
(40,new String'("Bourriot-Bergonce"),40120,328,311,3,82.65,-0.25,44.1167,89,148),
(40,new String'("Pontenx-les-Forges"),40200,1467,1085,18,80.62,-1.11667,44.25,9,56),
(40,new String'("Saint-Cricq-Chalosse"),40700,659,559,32,20.23,-0.683333,43.65,50,128),
(40,new String'("Soorts-Hossegor"),40150,3723,3296,256,14.51,-1.4,43.6667,0,55),
(40,new String'("Vielle-Tursan"),40320,289,291,22,12.81,-0.45,43.6833,64,142),
(40,new String'("Saint-Jean-de-Lier"),40380,388,323,47,8.15,-0.883333,43.7833,6,43),
(40,new String'("Saint-Julien-en-Born"),40170,1451,1312,19,72.93,-1.23333,44.0667,0,64),
(40,new String'("Bénesse-Maremne"),40230,2297,1754,122,18.69,-1.35,43.6333,1,25),
(40,new String'("Lüe"),40210,506,464,5,96.72,-0.983333,44.2333,33,80),
(40,new String'("Orist"),40300,679,537,46,14.76,-1.16667,43.6333,2,100),
(40,new String'("Amou"),40330,1559,1452,57,27.25,-0.75,43.6,31,147),
(40,new String'("Miramont-Sensacq"),40320,361,366,14,25.32,-0.316667,43.6,111,221),
(40,new String'("Oeyregave"),40300,362,295,45,8.03,-1.1,43.5333,2,69),
(40,new String'("Argelouse"),40430,101,55,4,22.79,-0.64616,44.366,39,73),
(40,new String'("Rimbez-et-Baudiets"),40310,101,86,3,32.84,0.05,44.05,88,154),
(40,new String'("Bélis"),40120,149,137,7,20.46,-0.45,44.0667,62,111),
(40,new String'("Castaignos-Souslens"),40700,396,358,53,7.45,-0.65,43.5833,45,146),
(40,new String'("Lencouacq"),40120,398,403,4,96.62,-0.4,44.1,75,128),
(40,new String'("Renung"),40270,508,467,23,21.95,-0.35,43.75,54,145),
(40,new String'("Banos"),40500,253,232,43,5.77,-0.616667,43.7333,34,124),
(40,new String'("Heugas"),40180,1237,1268,65,18.79,-1.08333,43.65,1,80),
(40,new String'("Habas"),40290,1443,1310,76,18.75,-0.933333,43.5667,14,123),
(40,new String'("Garrey"),40180,179,181,36,4.93,-0.9,43.6667,11,46),
(40,new String'("Doazit"),40700,900,887,40,22.16,-0.65,43.7,57,127),
(40,new String'("Ychoux"),40160,2041,1482,18,111.28,-0.966667,44.3333,37,71),
(40,new String'("Pey"),40300,696,544,50,13.85,-1.2,43.6333,2,57),
(40,new String'("Audon"),40400,321,275,42,7.55,-0.816667,43.8,8,55),
(40,new String'("Lauret"),40320,82,74,11,7.34,-0.333333,43.5667,117,237),
(40,new String'("Gousse"),40465,305,170,74,4.09,-0.9,43.7667,6,34),
(40,new String'("Aureilhan"),40200,946,640,82,11.51,-1.2,44.2167,5,34),
(40,new String'("Luxey"),40430,662,659,4,160.07,-0.516667,44.2667,62,121),
(40,new String'("Momuy"),40700,453,367,34,13.3,-0.633333,43.6167,41,126),
(40,new String'("Aurice"),40500,645,633,37,17.31,-0.6,43.8167,26,83),
(40,new String'("Tarnos"),40220,11906,10073,453,26.26,-1.46667,43.5333,0,53),
(40,new String'("Escource"),40210,610,605,5,102.74,-1.03333,44.1667,23,84),
(40,new String'("Lamothe"),40250,300,316,23,12.63,-0.65,43.7833,27,74),
(40,new String'("Retjons"),40120,320,278,4,77.84,-0.283333,44.1,68,134),
(40,new String'("Sindères"),40110,185,179,9,20.34,-0.983333,44.0333,56,96),
(40,new String'("Arue"),40120,309,286,6,48.11,-0.35,44.0667,47,113),
(40,new String'("Maylis"),40250,340,329,27,12.21,-0.683333,43.7,43,122),
(40,new String'("Saint-Geours-d'Auribat"),40380,348,279,63,5.47,-0.833333,43.75,15,86),
(40,new String'("Commensacq"),40210,406,320,5,71.24,-0.816667,44.2167,49,84),
(40,new String'("Poudenx"),40700,229,203,30,7.46,-0.583333,43.5833,53,151),
(40,new String'("Larbey"),40250,249,236,41,6.0,-0.716667,43.7,33,108),
(40,new String'("Arboucave"),40320,202,194,20,9.89,-0.433333,43.6167,86,170),
(40,new String'("Goos"),40180,538,423,51,10.49,-0.9,43.7333,4,73),
(40,new String'("Dumes"),40500,268,133,108,2.48,-0.583333,43.7,51,113),
(40,new String'("Ygos-Saint-Saturnin"),40110,1219,1135,21,57.88,-0.733333,43.9833,44,101),
(40,new String'("Sore"),40430,1044,897,7,147.72,-0.583333,44.3167,45,99),
(40,new String'("Luglon"),40630,339,307,8,41.07,-0.716667,44.0833,79,103),
(40,new String'("Geaune"),40320,730,660,69,10.53,-0.383333,43.65,82,221),
(40,new String'("Hastingues"),40300,601,447,41,14.54,-1.15,43.5333,0,84),
(40,new String'("Yzosse"),40180,422,429,79,5.32,-1.01667,43.7167,4,12),
(40,new String'("Liposthey"),40410,438,323,18,23.97,-0.883333,44.3167,61,73),
(40,new String'("Marpaps"),40330,147,109,21,6.84,-0.683333,43.5667,72,142),
(40,new String'("Azur"),40140,601,448,35,16.94,-1.3,43.8,3,49),
(40,new String'("Pouillon"),40350,2870,2685,57,49.74,-1.0,43.6,18,121),
(40,new String'("Latrille"),40800,166,186,24,6.84,-0.283333,43.6333,132,187),
(40,new String'("Bahus-Soubiran"),40320,372,303,25,14.53,-0.35,43.6667,100,169),
(40,new String'("Carcarès-Sainte-Croix"),40400,488,434,31,15.57,-0.783333,43.85,14,74),
(40,new String'("Monségur"),40700,378,299,19,19.69,-0.541389,43.6045,60,151),
(40,new String'("Larrivière-Saint-Savin"),40270,600,577,35,16.85,-0.416667,43.7667,45,134),
(40,new String'("Sort-en-Chalosse"),40180,886,708,57,15.39,-0.933333,43.6833,8,50),
(40,new String'("Saint-Geours-de-Maremne"),40230,2157,1666,50,42.9,-1.23333,43.6833,1,66),
(40,new String'("Solférino"),40210,345,348,3,97.83,-0.9,44.15,74,85),
(40,new String'("Gabarret"),40310,1287,1296,76,16.9,0.016667,43.9833,135,178),
(40,new String'("Saint-Agnet"),40800,193,188,24,7.8,-0.266667,43.6167,99,196),
(40,new String'("Uchacq-et-Parentis"),40090,575,496,14,38.58,-0.55,43.9167,28,74),
(40,new String'("Tercis-les-Bains"),40180,1161,1035,113,10.19,-1.1,43.6667,2,62),
(40,new String'("Pujo-le-Plan"),40190,577,544,31,18.51,-0.333333,43.85,51,116),
(40,new String'("Tosse"),40230,2374,1679,132,17.94,-1.33333,43.6833,12,54),
(40,new String'("Bretagne-de-Marsan"),40280,1426,910,110,12.93,-0.45,43.85,62,97),
(40,new String'("Cauna"),40500,421,389,31,13.39,-0.65,43.7833,21,74),
(40,new String'("Onard"),40380,351,296,57,6.15,-0.833333,43.7833,8,50),
(40,new String'("Serres-Gaston"),40700,360,341,40,8.88,-0.5,43.65,52,142),
(40,new String'("Téthieu"),40990,656,493,59,11.03,-0.975,43.7512,4,34),
(40,new String'("Labastide-Chalosse"),40700,135,117,29,4.56,-0.616667,43.6167,49,127),
(40,new String'("Gamarde-les-Bains"),40380,1050,883,55,18.95,-0.866667,43.7333,9,97),
(40,new String'("Bélus"),40300,603,431,50,11.84,-1.1,43.5833,35,130),
(40,new String'("Hinx"),40180,1775,1145,114,15.51,-0.933333,43.7,3,55),
(40,new String'("Lacajunte"),40320,134,136,23,5.63,-0.416667,43.6,94,174),
(40,new String'("Saubion"),40230,1377,935,176,7.8,-1.35,43.6667,7,38),
(40,new String'("Saint-Gor"),40120,310,270,5,53.72,-0.233333,44.05,65,128),
(40,new String'("Saint-Loubouer"),40320,434,410,25,16.95,-0.416667,43.6833,72,166),
(40,new String'("Mauries"),40320,90,63,16,5.49,-0.333333,43.6167,103,221),
(40,new String'("Donzacq"),40360,445,388,38,11.7,-0.8,43.65,20,112),
(40,new String'("Gaas"),40350,490,364,53,9.13,-1.03333,43.6167,17,87),
(40,new String'("Clermont"),40180,810,645,53,15.02,-0.916667,43.65,9,59),
(40,new String'("Bégaar"),40400,1089,939,39,27.8,-0.85,43.8167,7,52),
(40,new String'("Orx"),40230,521,422,43,11.89,-1.36667,43.6,3,31),
(40,new String'("Tilh"),40360,816,749,35,22.86,-0.833333,43.5833,59,151),
(40,new String'("Saint-Yaguen"),40400,569,456,15,37.59,-0.733333,43.8833,15,57),
(40,new String'("Le Leuy"),40250,226,204,23,9.46,-0.6525,43.8223,52,84),
(40,new String'("Biaudos"),40390,803,635,51,15.59,-1.3,43.55,0,66),
(40,new String'("Gourbera"),40990,356,256,12,27.73,-1.05,43.8,26,84),
(40,new String'("Eyres-Moncube"),40500,375,343,30,12.19,-0.55,43.7167,44,122),
(40,new String'("Saubusse"),40180,818,741,77,10.53,-1.18333,43.6667,1,31),
(40,new String'("Mant"),40700,289,272,14,19.34,-0.516667,43.5833,68,208),
(40,new String'("Brassempouy"),40330,302,268,28,10.72,-0.7,43.6333,35,131),
(40,new String'("Magescq"),40140,1853,1380,24,77.12,-1.21667,43.7833,9,66),
(40,new String'("Sarron"),40800,120,87,30,3.9,-0.266667,43.5833,107,199),
(40,new String'("Le Sen"),40420,207,201,4,51.1,-0.5,44.1333,88,123),
(40,new String'("Lit-et-Mixe"),40170,1520,1441,13,112.95,-1.25,44.0333,0,72),
(40,new String'("Lespéron"),40260,1017,864,9,102.81,-1.08333,43.9667,37,99),
(40,new String'("Parleboscq"),40310,506,504,12,40.19,0.0155556,43.9333,87,182),
(40,new String'("Saubrigues"),40230,1381,1079,64,21.44,-1.31667,43.6167,2,85),
(40,new String'("Arx"),40310,67,57,2,24.18,0.066667,44.1167,90,159),
(40,new String'("Labouheyre"),40210,2592,2537,71,36.13,-0.916667,44.2167,57,84),
(40,new String'("Garrosse"),40110,312,297,11,26.68,-0.916667,44.0167,58,94),
(40,new String'("Vielle-Soubiran"),40240,246,197,7,32.71,-0.183333,44.05,92,142),
(40,new String'("Cère"),40090,407,274,10,39.87,-0.516667,43.9833,42,99),
(40,new String'("Bougue"),40090,612,526,27,21.96,-0.383333,43.9,34,96),
(40,new String'("Nerbis"),40250,257,251,61,4.15,-0.733333,43.75,16,103),
(40,new String'("Herm"),40990,1044,783,20,52.08,-1.15,43.8167,28,84),
(40,new String'("Cazères-sur-l'Adour"),40270,1144,862,36,31.25,-0.316667,43.75,62,139),
(40,new String'("Lourquen"),40250,222,188,37,5.9,-0.783333,43.7333,24,86),
(40,new String'("Herré"),40310,127,144,5,23.14,-0.016667,44.0,138,152),
(40,new String'("Le Vignau"),40270,487,385,43,11.07,-0.283333,43.7667,72,132),
(40,new String'("Bats"),40320,291,230,39,7.35,-0.45,43.65,69,148),
(40,new String'("Bourdalat"),40190,210,187,14,14.15,-0.2,43.8333,76,135),
(40,new String'("Perquie"),40190,365,297,13,26.34,-0.283333,43.8667,58,121),
(40,new String'("Montégut"),40190,71,81,14,4.82,-0.2,43.8667,63,110),
(40,new String'("Hontanx"),40190,548,536,17,30.48,-0.266667,43.8167,77,137),
(40,new String'("Vert"),40420,236,209,5,40.03,-0.583333,44.0833,69,106),
(40,new String'("Audignon"),40500,359,327,38,9.31,-0.6,43.7167,37,116),
(40,new String'("Sarraziet"),40500,209,153,29,7.01,-0.483333,43.7,51,156),
(40,new String'("Lubbon"),40240,106,95,2,47.74,-0.016667,44.1,134,156),
(40,new String'("Castets"),40260,1963,1808,21,90.18,-1.15,43.8833,23,86),
(40,new String'("Saint-Michel-Escalus"),40550,291,231,16,17.59,-1.25,43.9,8,57),
(40,new String'("Serreslous-et-Arribans"),40700,208,182,38,5.46,-0.65,43.6667,62,132),
(40,new String'("Mont-de-Marsan"),40000,31225,29529,846,36.88,-0.5,43.8833,23,97),
(40,new String'("Maurrin"),40270,459,385,34,13.38,-0.366667,43.8333,67,121),
(40,new String'("Hauriet"),40250,264,251,34,7.57,-0.7,43.7167,24,106),
(40,new String'("Saint-Martin-de-Seignanx"),40390,4863,3904,107,45.35,-1.38333,43.55,0,72),
(40,new String'("Saint-Jean-de-Marsacq"),40230,1325,894,50,26.4,-1.25,43.6167,2,91),
(40,new String'("Roquefort"),40120,1896,1897,156,12.12,-0.3225,44.0334,49,95),
(40,new String'("Sainte-Marie-de-Gosse"),40390,1060,878,39,26.54,-1.23333,43.5583,0,108),
(40,new String'("Payros-Cazautets"),40320,95,100,14,6.35,-0.4,43.6167,79,166),
(40,new String'("Mugron"),40250,1390,1324,84,16.53,-0.75,43.75,14,111),
(40,new String'("Ousse-Suzan"),40110,243,252,9,24.48,-0.766667,43.95,22,96),
(40,new String'("Campagne"),40090,944,840,27,33.91,-0.633333,43.8667,20,92),
(40,new String'("Saint-Martin-d'Oney"),40090,1303,927,37,34.4,-0.633333,43.9167,18,67),
(40,new String'("Saint-Justin"),40240,929,887,14,65.62,-0.233333,43.9833,62,151),
(40,new String'("Baudignan"),40310,42,36,1,23.3,0.05,44.0833,104,161),
(40,new String'("Saint-Pandelon"),40180,750,668,81,9.18,-1.03333,43.6667,1,61),
(40,new String'("Soustons"),40140,7294,5751,72,100.38,-1.31667,43.75,0,62),
(40,new String'("Morganx"),40700,186,170,35,5.22,-0.566667,43.6167,57,136),
(40,new String'("Pomarez"),40360,1503,1451,49,30.57,-0.833333,43.6333,20,72),
(40,new String'("Bénesse-lès-Dax"),40180,518,454,87,5.89,-1.03333,43.65,21,96),
(40,new String'("Losse"),40240,260,308,2,102.69,-0.1,44.1,95,157),
(40,new String'("Saugnacq-et-Muret"),40410,905,712,8,109.37,-0.825,44.4083,20,64),
(40,new String'("Geloux"),40090,734,511,14,51.7,-0.633333,43.9833,33,84),
(40,new String'("Garein"),40420,424,382,7,57.1,-0.65,44.05,65,106),
(40,new String'("Beylongue"),40370,363,300,9,37.51,-0.833333,43.9167,35,103),
(40,new String'("Préchacq-les-Bains"),40465,676,462,78,8.63,-0.908333,43.7584,5,36),
(40,new String'("Monget"),40700,82,87,14,5.64,-0.516667,43.5667,70,170),
(40,new String'("Oeyreluy"),40180,1593,1119,278,5.72,-1.08333,43.6667,2,44),
(40,new String'("Tartas"),40400,3088,2843,101,30.37,-0.8,43.8333,10,68),
(40,new String'("Buanes"),40320,278,199,41,6.62,-0.416667,43.7167,69,149),
(40,new String'("Mées"),40990,1736,1375,114,15.11,-1.1,43.7,1,49),
(40,new String'("Rivière-Saas-et-Gourby"),40180,1180,941,43,27.37,-1.13333,43.6833,2,57),
(40,new String'("Souprosse"),40250,997,1069,23,42.56,-0.7,43.7833,15,84),
(40,new String'("Labastide-d'Armagnac"),40240,689,707,21,31.87,-0.183333,43.9667,67,139),
(40,new String'("Saint-Gein"),40190,448,395,25,17.85,-0.3,43.8333,69,127),
(40,new String'("Mauvezin-d'Armagnac"),40240,107,86,22,4.68,-0.116667,43.95,82,132),
(40,new String'("Sanguinet"),40460,3258,1984,40,81.43,-1.075,44.4833,20,45),
(40,new String'("Taller"),40260,458,417,11,41.07,-1.06667,43.8667,57,89),
(40,new String'("Sarbazan"),40120,1098,948,48,22.44,-0.316667,44.0167,54,112),
(40,new String'("Vicq-d'Auribat"),40380,262,189,62,4.2,-0.859722,43.785,9,45),
(40,new String'("Maillères"),40120,213,182,14,15.05,-0.433333,44.0333,44,118),
(40,new String'("Pissos"),40410,1356,1097,9,140.75,-0.766667,44.3,30,79),
(40,new String'("Saint-Paul-lès-Dax"),40990,12409,10228,212,58.45,-1.05,43.7333,2,61),
(40,new String'("Siest"),40180,113,82,38,2.91,-1.13333,43.65,1,97),
(40,new String'("Nousse"),40380,282,226,72,3.87,-0.816667,43.7167,22,107),
(40,new String'("Bastennes"),40360,264,241,36,7.29,-0.783333,43.65,24,98),
(40,new String'("Eugénie-les-Bains"),40320,448,507,40,11.03,-0.383333,43.7,82,159),
(40,new String'("Seignosse"),40510,3310,2423,94,35.09,-1.36667,43.6833,0,62),
(40,new String'("Saint-Martin-de-Hinx"),40390,1296,938,50,25.48,-1.26667,43.5833,1,106),
(40,new String'("Poyartin"),40380,754,631,57,13.04,-0.866667,43.6833,17,102),
(40,new String'("Pimbo"),40320,185,179,16,10.89,-0.366667,43.5833,100,213),
(40,new String'("Horsarrieu"),40700,633,636,57,11.02,-0.6,43.6833,50,133),
(40,new String'("Bassercles"),40700,118,122,17,6.59,-0.616667,43.55,65,167),
(40,new String'("Philondenx"),40320,215,204,22,9.66,-0.45,43.5667,101,227),
(40,new String'("Labatut"),40300,1423,1099,67,20.95,-0.985278,43.5503,5,125),
(40,new String'("Castelner"),40700,116,103,20,5.73,-0.583333,43.55,74,202),
(40,new String'("Mazerolles"),40090,698,566,43,15.97,-0.436389,43.8753,34,107),
(40,new String'("Canenx-et-Réaut"),40090,175,135,6,28.07,-0.433333,44.0,38,108),
(40,new String'("Bascons"),40090,912,869,48,18.7,-0.4,43.8167,66,107),
(40,new String'("Vielle-Saint-Girons"),40560,1195,1026,16,72.03,-1.3,43.95,0,76),
(40,new String'("Saint-Étienne-d'Orthe"),40300,593,467,53,11.07,-1.16667,43.5833,2,57),
(40,new String'("Escalans"),40310,251,219,8,30.31,0.033333,43.9667,86,176),
(40,new String'("Angoumé"),40990,288,179,36,7.83,-1.13333,43.6667,2,57),
(40,new String'("Grenade-sur-l'Adour"),40270,2503,2266,126,19.72,-0.416667,43.7833,48,84),
(40,new String'("Laglorieuse"),40090,557,567,48,11.59,-0.4,43.8667,52,118),
(40,new String'("Lesgor"),40400,375,262,13,28.19,-0.9,43.85,17,75),
(40,new String'("Sorbets"),40320,186,169,15,11.88,-0.316667,43.6333,105,218),
(40,new String'("Saint-Maurice-sur-Adour"),40270,578,509,60,9.53,-0.45,43.7833,41,76),
(40,new String'("Arengosse"),40110,706,676,11,62.48,-0.783333,44.0,32,102),
(40,new String'("Mimbaste"),40350,1018,993,49,20.6,-0.966667,43.65,5,72),
(40,new String'("Saint-Vincent-de-Tyrosse"),40230,7585,5365,361,20.98,-1.3,43.6667,7,61),
(40,new String'("Callen"),40430,142,149,1,87.86,-0.466667,44.3,65,119),
(40,new String'("Saint-Paul-en-Born"),40200,817,602,18,43.53,0.847501,44.2242,6,54),
(41,new String'("Mur-de-Sologne"),41230,1430,1197,28,50.5,1.61667,47.4167,88,131),
(41,new String'("Chaumont-sur-Tharonne"),41600,1096,1073,13,78.33,1.9,47.6167,98,142),
(41,new String'("Montrieux-en-Sologne"),41210,631,524,18,34.11,1.73333,47.55,80,118),
(41,new String'("Villeromain"),41100,225,198,17,13.08,1.15,47.7333,114,133),
(41,new String'("Saint-Rimay"),41800,285,311,38,7.36,0.916667,47.7667,65,125),
(41,new String'("Sainte-Gemmes"),41290,101,86,11,8.56,1.26667,47.7833,110,131),
(41,new String'("Dhuizon"),41220,1430,1253,32,43.34,1.65,47.5833,86,132),
(41,new String'("Thésée"),41140,1181,1123,67,17.61,1.31667,47.3333,61,122),
(41,new String'("Romorantin-Lanthenay"),41200,17027,18353,375,45.31,1.74361,47.3589,84,121),
(41,new String'("Thoury"),41220,391,337,24,15.76,1.6,47.6333,77,131),
(41,new String'("Sasnières"),41310,101,69,12,7.83,0.933333,47.7167,81,145),
(41,new String'("Séris"),41500,375,287,21,17.52,1.5,47.75,103,119),
(41,new String'("Neung-sur-Beuvron"),41210,1238,1111,19,63.0,1.8,47.5333,87,122),
(41,new String'("Savigny-sur-Braye"),41360,2177,2202,32,67.18,0.816667,47.8833,74,166),
(41,new String'("Pouillé"),41110,807,754,44,18.03,1.3,47.3167,61,183),
(41,new String'("La Colombe"),41160,198,119,10,18.36,1.36667,47.8833,118,153),
(41,new String'("Binas"),41240,731,593,27,26.38,1.46667,47.9,120,133),
(41,new String'("Saint-Sulpice-de-Pommeray"),41000,1801,1876,156,11.5,1.26667,47.6,80,144),
(41,new String'("Cour-sur-Loire"),41500,272,307,50,5.4,1.43333,47.65,67,115),
(41,new String'("Areines"),41100,609,532,125,4.84,1.1,47.8,77,130),
(41,new String'("Gombergean"),41310,182,145,14,12.18,1.08333,47.65,114,130),
(41,new String'("La Chapelle-Enchérie"),41290,176,146,16,10.76,1.2,47.8167,98,144),
(41,new String'("Montlivault"),41350,1339,1192,124,10.73,1.45,47.6333,67,90),
(41,new String'("Neuvy"),41250,326,295,10,31.28,1.6,47.5667,77,128),
(41,new String'("Saint-Agil"),41170,273,258,17,15.61,0.933333,48.0333,150,201),
(41,new String'("Saint-Bohaire"),41330,472,361,33,14.06,1.26667,47.65,85,123),
(41,new String'("Bauzy"),41250,264,257,10,24.7,1.6,47.5333,79,113),
(41,new String'("Gièvres"),41130,2292,2027,60,38.05,1.66667,47.2667,72,102),
(41,new String'("Oucques"),41290,1482,1314,56,26.23,1.3,47.8167,115,139),
(41,new String'("Hayes"),41800,201,169,12,15.71,0.776944,47.7153,93,156),
(41,new String'("Épuisay"),41360,745,533,31,23.52,0.933333,47.9,119,182),
(41,new String'("Thenay"),41400,846,803,42,20.03,1.28333,47.3833,74,116),
(41,new String'("Lamotte-Beuvron"),41600,4736,4251,202,23.34,2.01667,47.6,106,146),
(41,new String'("Oigny"),41170,93,80,9,9.86,0.933333,48.0667,134,184),
(41,new String'("Mont-près-Chambord"),41250,3271,3025,114,28.51,1.45,47.5667,72,123),
(41,new String'("Saint-Loup"),41320,361,298,24,14.7,1.83945,47.2653,82,151),
(41,new String'("Cellé"),41360,249,270,19,12.67,0.783333,47.8333,73,155),
(41,new String'("Saint-Jean-Froidmentel"),41160,503,437,29,17.2,1.25,47.95,88,189),
(41,new String'("Beauchêne"),41170,163,142,16,10.08,0.969444,47.9406,164,205),
(41,new String'("Le Plessis-Dorin"),41170,184,202,12,14.19,0.866667,48.0833,131,249),
(41,new String'("Arville"),41170,104,108,10,9.75,0.95,48.0667,157,204),
(41,new String'("Valaire"),41120,75,87,11,6.68,1.26667,47.4667,62,109),
(41,new String'("Pray"),41190,305,262,29,10.48,1.11667,47.6833,123,132),
(41,new String'("La Ville-aux-Clercs"),41160,1333,1197,50,26.61,1.08333,47.9167,115,195),
(41,new String'("Prénouvellon"),41240,218,228,11,19.77,1.53333,47.9667,116,131),
(41,new String'("Artins"),41800,298,282,25,11.72,0.733333,47.75,57,139),
(41,new String'("Coulanges"),41150,308,312,36,8.35,1.21667,47.55,67,116),
(41,new String'("Fresnes"),41700,1080,808,67,16.02,1.41667,47.4333,86,112),
(41,new String'("Mondoubleau"),41170,1497,1607,309,4.84,0.9,47.9833,110,166),
(41,new String'("Vallières-les-Grandes"),41400,836,610,20,40.75,1.15,47.4167,77,134),
(41,new String'("Thoré-la-Rochette"),41100,886,884,82,10.78,0.966667,47.7833,69,137),
(41,new String'("Azé"),41100,1119,985,35,31.93,0.998611,47.8512,80,154),
(41,new String'("Vouzon"),41600,1487,1060,19,78.25,2.0593,47.65,108,147),
(41,new String'("Soings-en-Sologne"),41230,1543,1314,43,35.3,1.51667,47.4167,92,137),
(41,new String'("Saint-Hilaire-la-Gravelle"),41160,689,687,39,17.57,1.2,47.9167,87,172),
(41,new String'("Faye"),41100,220,183,25,8.7,1.18333,47.8,98,133),
(41,new String'("Monteaux"),41150,792,663,126,6.27,1.11667,47.4833,56,102),
(41,new String'("Montrouveau"),41800,133,110,7,17.7,0.733333,47.7167,94,141),
(41,new String'("Vievy-le-Rayé"),41290,490,461,10,45.12,1.31667,47.8667,99,152),
(41,new String'("Bonneveau"),41800,502,465,45,10.95,0.75,47.8167,65,154),
(41,new String'("Lunay"),41360,1334,1290,34,38.63,0.916667,47.8,66,156),
(41,new String'("Ruan-sur-Egvonne"),41270,91,93,8,11.35,1.14556,48.0134,123,258),
(41,new String'("Le Plessis-l'Échelle"),41370,74,65,6,11.7,1.43333,47.8167,111,147),
(41,new String'("Vineuil"),41350,7119,6653,318,22.34,1.38333,47.5833,68,100),
(41,new String'("Maves"),41500,663,577,19,33.33,1.36667,47.75,99,127),
(41,new String'("Couture-sur-Loir"),41800,415,433,29,14.3,0.683333,47.75,54,136),
(41,new String'("Villerable"),41100,535,501,31,16.81,1.03333,47.75,87,138),
(41,new String'("Essarts"),41800,105,102,23,4.38,0.716667,47.7333,75,139),
(41,new String'("Muides-sur-Loire"),41500,1365,1158,149,9.15,1.51667,47.6667,72,104),
(41,new String'("Saint-Laurent-des-Bois"),41240,296,225,16,18.32,1.45,47.85,123,152),
(41,new String'("Ambloy"),41310,196,155,14,13.16,0.966667,47.7167,99,134),
(41,new String'("Boisseau"),41290,100,86,12,8.06,1.3,47.7667,103,129),
(41,new String'("Villebarou"),41000,2619,1942,287,9.11,1.31667,47.6167,108,121),
(41,new String'("La Chapelle-Saint-Martin-en-Plaine"),41500,689,590,30,22.83,1.41667,47.7167,104,124),
(41,new String'("La Chaussée-Saint-Victor"),41260,4230,4079,638,6.63,1.36667,47.6167,67,114),
(41,new String'("Saint-Cyr-du-Gault"),41190,179,196,6,26.06,1.03333,47.6167,108,149),
(41,new String'("Candé-sur-Beuvron"),41120,1479,1205,95,15.49,1.25,47.5,62,111),
(41,new String'("Sargé-sur-Braye"),41170,1003,975,23,42.61,0.85,47.9167,78,202),
(41,new String'("Vernou-en-Sologne"),41230,606,523,11,51.31,1.68333,47.5,82,116),
(41,new String'("Tripleville"),41240,149,130,11,13.07,1.48333,47.95,112,131),
(41,new String'("Seigy"),41110,1121,1091,137,8.18,1.4,47.2333,67,137),
(41,new String'("Briou"),41370,117,101,11,10.17,1.48333,47.8167,116,148),
(41,new String'("Villeherviers"),41200,492,498,12,38.9,1.8,47.3667,85,112),
(41,new String'("Fontaine-Raoul"),41270,238,197,10,21.9,1.13333,47.9833,124,252),
(41,new String'("Chauvigny-du-Perche"),41270,227,244,9,23.43,1.06667,47.95,132,226),
(41,new String'("Roches-l'Évêque"),41800,292,283,121,2.4,0.883333,47.7833,66,134),
(41,new String'("Fougères-sur-Bièvre"),41120,801,653,54,14.69,1.35,47.45,78,121),
(41,new String'("Chambon-sur-Cisse"),41190,689,745,54,12.71,1.21667,47.5667,72,131),
(41,new String'("Chitenay"),41120,1022,926,65,15.61,1.36667,47.5,67,116),
(41,new String'("Baillou"),41170,246,229,12,19.85,0.85,47.9667,88,166),
(41,new String'("Villerbon"),41000,776,682,44,17.28,1.36667,47.6667,101,117),
(41,new String'("Membrolles"),41240,263,216,13,18.95,1.46667,47.9833,114,134),
(41,new String'("Baigneaux"),41290,51,47,7,6.58,1.25,47.7833,121,129),
(41,new String'("Rilly-sur-Loire"),41150,459,404,44,10.22,1.13333,47.4667,58,109),
(41,new String'("Molineuf"),41190,796,803,72,11.02,1.23333,47.5833,72,145),
(41,new String'("Fontaine-les-Coteaux"),41800,385,343,17,22.11,0.833333,47.8,63,154),
(41,new String'("Ternay"),41800,314,272,21,14.38,0.783333,47.7333,59,139),
(41,new String'("Angé"),41400,817,793,47,17.36,1.23333,47.3167,59,172),
(41,new String'("Fossé"),41330,1121,850,109,10.2,1.28333,47.6333,85,120),
(41,new String'("Huisseau-en-Beauce"),41310,404,314,44,8.98,1.01667,47.7167,90,131),
(41,new String'("Oisly"),41700,342,310,32,10.61,1.38333,47.3833,98,131),
(41,new String'("Villeny"),41220,403,334,11,33.98,1.75,47.6167,93,136),
(41,new String'("Verdes"),41240,495,388,17,28.59,1.43333,47.95,107,132),
(41,new String'("Vendôme"),41100,16920,17709,708,23.89,1.06667,47.8,76,141),
(41,new String'("Saint-Romain-sur-Cher"),41140,1513,1291,48,31.17,1.4,47.3167,64,120),
(41,new String'("Villetrun"),41100,324,267,47,6.83,1.16667,47.7833,109,131),
(41,new String'("Mazangé"),41100,916,842,37,24.26,0.95,47.8167,71,156),
(41,new String'("Choue"),41170,529,544,14,37.39,0.933333,48.0,112,212),
(41,new String'("Saint-Julien-de-Chédon"),41400,734,699,74,9.87,1.2,47.3,59,159),
(41,new String'("Lancé"),41310,453,407,25,18.01,1.06667,47.7,116,131),
(41,new String'("Fortan"),41360,268,183,44,5.98,0.916667,47.85,95,147),
(41,new String'("Crouy-sur-Cosson"),41220,510,472,17,28.37,1.6,47.65,77,111),
(41,new String'("Yvoy-le-Marron"),41600,617,534,12,48.92,1.85,47.6333,94,138),
(41,new String'("Salbris"),41300,5704,6029,53,106.61,2.05,47.4259,96,131),
(41,new String'("Châteauvieux"),41110,555,575,16,33.48,1.38333,47.2167,79,160),
(41,new String'("Cour-Cheverny"),41700,2731,2555,91,29.8,1.45,47.5,73,118),
(41,new String'("Montoire-sur-le-Loir"),41800,4058,4275,193,21.02,0.866667,47.75,60,146),
(41,new String'("Villefranche-sur-Cher"),41200,2701,2413,99,27.23,1.77,47.2934,82,123),
(41,new String'("Lestiou"),41500,269,202,32,8.29,1.58333,47.7333,77,117),
(41,new String'("Pezou"),41100,1125,938,80,13.97,1.13333,47.8667,82,148),
(41,new String'("Crucheray"),41100,411,373,16,25.43,1.08333,47.7333,93,132),
(41,new String'("Feings"),41120,708,530,42,16.52,1.35,47.4333,84,116),
(41,new String'("Tourailles"),41190,130,133,17,7.46,1.15,47.6833,117,134),
(41,new String'("Cormeray"),41120,1530,1038,148,10.31,1.4,47.4833,91,109),
(41,new String'("Monthou-sur-Bièvre"),41120,764,505,45,16.62,1.3,47.4667,62,113),
(41,new String'("Rahart"),41160,288,256,20,14.23,1.06667,47.8667,108,154),
(41,new String'("Saint-Claude-de-Diray"),41350,1698,1564,185,9.17,1.41667,47.6167,67,94),
(41,new String'("Courmemin"),41230,524,472,21,24.17,1.63333,47.4667,84,124),
(41,new String'("Avaray"),41500,723,577,52,13.88,1.56667,47.7167,75,118),
(41,new String'("Souvigny-en-Sologne"),41600,494,414,11,41.55,2.16667,47.6417,122,152),
(41,new String'("Saint-Firmin-des-Prés"),41100,835,777,60,13.89,1.11667,47.8333,79,140),
(41,new String'("Mennetou-sur-Cher"),41320,884,903,54,16.26,1.88333,47.2667,85,136),
(41,new String'("Blois"),41000,46492,49062,1241,37.46,1.33333,47.5833,63,135),
(41,new String'("Houssay"),41800,370,371,22,16.56,0.933333,47.75,75,137),
(41,new String'("Pierrefitte-sur-Sauldre"),41300,842,851,11,74.96,2.15,47.5083,108,148),
(41,new String'("Moisy"),41160,318,270,18,17.33,1.31667,47.9167,117,137),
(41,new String'("Lavardin"),41800,208,263,30,6.71,0.883333,47.75,63,146),
(41,new String'("Méhers"),41140,341,257,18,18.27,1.45,47.3333,78,109),
(41,new String'("Chémery"),41700,961,848,28,34.16,1.46667,47.35,84,136),
(41,new String'("Naveil"),41100,2143,1832,161,13.28,1.03333,47.8,72,137),
(41,new String'("La Marolle-en-Sologne"),41210,397,354,15,25.24,1.78333,47.5833,97,136),
(41,new String'("Saint-Jacques-des-Guérets"),41800,94,78,51,1.81,0.8,47.7667,60,67),
(41,new String'("Josnes"),41370,907,872,43,20.63,1.51667,47.8,108,130),
(41,new String'("Saint-Georges-sur-Cher"),41400,2448,2156,102,23.78,1.13333,47.3167,56,141),
(41,new String'("Saint-Aignan"),41110,3166,3543,171,18.48,1.38333,47.2667,64,164),
(41,new String'("Saint-Lubin-en-Vergonnois"),41190,682,743,39,17.06,1.23333,47.6167,80,132),
(41,new String'("Marcilly-en-Gault"),41210,751,754,14,50.31,1.86667,47.45,94,129),
(41,new String'("Pontlevoy"),41400,1586,1460,31,51.12,1.25,47.3833,77,137),
(41,new String'("Orchaise"),41190,897,855,44,20.03,1.2,47.5833,77,146),
(41,new String'("Pruniers-en-Sologne"),41200,2292,2123,52,43.84,1.67111,47.3228,74,111),
(41,new String'("Souesmes"),41300,1119,1114,11,99.5,2.18333,47.4583,105,158),
(41,new String'("Billy"),41130,901,802,34,26.47,1.53333,47.3,69,107),
(41,new String'("Bracieux"),41250,1254,1163,425,2.95,1.55,47.55,74,89),
(41,new String'("Troo"),41800,328,291,23,14.19,0.783333,47.7833,58,154),
(41,new String'("Villexanton"),41500,187,198,16,11.53,1.41667,47.7333,104,124),
(41,new String'("Villemardy"),41100,282,217,23,12.17,1.18333,47.7333,118,133),
(41,new String'("Couddes"),41700,511,486,27,18.64,1.4,47.3667,94,119),
(41,new String'("Brévainville"),41160,171,163,10,16.16,1.28333,47.95,88,144),
(41,new String'("Monthou-sur-Cher"),41400,969,903,48,20.16,1.3,47.35,61,135),
(41,new String'("Fréteval"),41160,1095,897,53,20.49,1.21667,47.8833,85,151),
(41,new String'("Theillay"),41300,1274,1293,13,96.38,2.04029,47.3167,96,168),
(41,new String'("Ouchamps"),41120,832,803,63,13.08,1.31667,47.4667,62,114),
(41,new String'("Chailles"),41120,2537,2019,136,18.54,1.31667,47.55,63,110),
(41,new String'("Le Gault-Perche"),41270,290,303,10,28.2,0.979444,48.095,165,228),
(41,new String'("Cellettes"),41120,2345,2137,111,20.96,1.38333,47.5333,68,107),
(41,new String'("Conan"),41290,199,190,13,15.3,1.28333,47.75,97,126),
(41,new String'("Villefrancœur"),41330,486,462,26,18.08,1.21667,47.7,105,127),
(41,new String'("Marolles"),41330,710,716,71,9.88,1.3,47.65,87,117),
(41,new String'("Roches"),41370,73,65,8,8.79,1.45,47.8,112,136),
(41,new String'("Chambord"),41250,134,185,2,54.38,1.51667,47.6167,72,129),
(41,new String'("Tréhet"),41800,111,121,19,5.65,0.633333,47.7333,53,110),
(41,new String'("Herbault"),41190,1197,1050,92,13.01,1.13333,47.6,105,147),
(41,new String'("Orçay"),41300,240,257,12,18.75,2.10833,47.2917,122,168),
(41,new String'("Saint-Avit"),41170,110,121,7,14.83,0.916667,48.0833,156,240),
(41,new String'("Veilleins"),41230,150,180,3,43.26,1.66667,47.4167,93,127),
(41,new String'("Morée"),41160,1140,994,44,25.83,1.23333,47.9,86,152),
(41,new String'("Saint-Ouen"),41100,3448,3050,305,11.3,1.08333,47.8167,77,140),
(41,new String'("Suèvres"),41500,1498,1371,40,36.65,1.46667,47.6667,71,119),
(41,new String'("Bouffry"),41270,146,158,8,17.73,1.1,48.0,139,257),
(41,new String'("Saint-Gourgon"),41310,120,116,11,10.15,1.01667,47.6667,112,129),
(41,new String'("Villiers-sur-Loir"),41100,1192,1189,119,9.96,1.0,47.8,70,141),
(41,new String'("Ouzouer-le-Doyen"),41160,226,166,13,16.59,1.33333,47.9333,116,133),
(41,new String'("La Chapelle-Vicomtesse"),41270,186,165,12,15.03,1.03333,47.9833,155,243),
(41,new String'("Maslives"),41250,684,580,93,7.35,1.48333,47.6333,72,99),
(41,new String'("Lisle"),41100,211,194,31,6.61,1.11667,47.85,82,147),
(41,new String'("Saint-Dyé-sur-Loire"),41500,1114,944,202,5.51,1.48333,47.65,72,92),
(41,new String'("Meusnes"),41130,1047,944,78,13.35,1.48333,47.25,68,132),
(41,new String'("Authon"),41310,641,697,19,32.26,0.9,47.65,90,156),
(41,new String'("Chissay-en-Touraine"),41400,1143,918,62,18.17,1.13333,47.3333,55,138),
(41,new String'("Montrichard"),41400,3427,3630,238,14.36,1.18333,47.35,59,134),
(41,new String'("Choussy"),41700,330,234,21,15.45,1.35,47.3667,80,117),
(41,new String'("Couffy"),41110,558,555,37,14.92,1.43333,47.2333,67,134),
(41,new String'("Villeporcher"),41310,148,137,12,12.1,1.0,47.6333,115,137),
(41,new String'("Lorges"),41370,370,289,27,13.52,1.5,47.8167,115,146),
(41,new String'("La Madeleine-Villefrouin"),41370,27,28,2,9.68,1.41333,47.7856,105,128),
(41,new String'("Sassay"),41700,918,730,55,16.44,1.43333,47.4,99,137),
(41,new String'("Maray"),41320,229,252,8,27.8,1.88333,47.25,85,151),
(41,new String'("La Ferté-Imbault"),41300,989,1036,19,50.02,1.96667,47.3833,94,126),
(41,new String'("La Ferté-Saint-Cyr"),41220,1019,894,17,57.93,1.66667,47.65,78,131),
(41,new String'("Gy-en-Sologne"),41230,511,450,14,35.92,1.58333,47.35,77,111),
(41,new String'("Danzé"),41160,721,603,17,42.26,1.03333,47.9,107,183),
(41,new String'("Épiais"),41290,142,94,16,8.7,1.25,47.8,108,136),
(41,new String'("Châtres-sur-Cher"),41320,1090,1128,30,35.33,1.91667,47.2667,87,157),
(41,new String'("Renay"),41100,176,167,14,12.05,1.16667,47.85,90,143),
(41,new String'("Busloup"),41160,433,379,22,18.94,1.13333,47.9,88,162),
(41,new String'("Meslay"),41100,293,294,40,7.18,1.1,47.8167,77,130),
(41,new String'("Villechauve"),41310,289,270,26,11.02,0.95,47.65,97,147),
(41,new String'("Saint-Arnoult"),41800,331,306,34,9.57,0.866667,47.7,85,152),
(41,new String'("Fontaines-en-Sologne"),41250,623,519,13,46.25,1.55,47.5167,80,119),
(41,new String'("Sougé"),41800,482,440,28,16.88,0.727778,47.7703,56,147),
(41,new String'("La Ferté-Beauharnais"),41210,536,463,221,2.42,1.85,47.5333,95,109),
(41,new String'("Veuves"),41150,212,216,26,8.07,1.11667,47.4667,58,65),
(41,new String'("Semerville"),41160,95,79,9,9.67,1.4,47.9333,123,132),
(41,new String'("Onzain"),41150,3471,3144,116,29.89,1.18333,47.5,59,119),
(41,new String'("Santenay"),41190,271,254,8,30.28,1.11667,47.5667,94,144),
(41,new String'("Contres"),41700,3420,3266,94,36.09,1.43333,47.4167,94,129),
(41,new String'("Lancôme"),41190,136,114,13,9.89,1.11667,47.65,105,129),
(41,new String'("Sambin"),41120,917,676,44,20.83,1.3,47.4333,84,120),
(41,new String'("Villedieu-le-Château"),41800,409,420,13,29.65,0.65,47.7167,60,133),
(41,new String'("Mareuil-sur-Cher"),41110,1123,957,35,31.88,1.33333,47.2833,64,186),
(41,new String'("Tour-en-Sologne"),41250,951,887,36,26.34,1.5,47.5333,72,123),
(41,new String'("Saint-Léonard-en-Beauce"),41370,622,538,15,40.66,1.38333,47.8333,113,152),
(41,new String'("La Chapelle-Vendômoise"),41330,741,744,56,13.07,1.25,47.6667,87,131),
(41,new String'("Le Poislay"),41270,210,198,13,15.89,1.06667,48.0667,154,202),
(41,new String'("Françay"),41190,297,231,14,20.31,1.13333,47.6167,107,134),
(41,new String'("Saint-Gervais-la-Forêt"),41350,3312,3306,369,8.97,1.35,47.5667,67,110),
(41,new String'("Millançay"),41200,744,667,12,57.94,1.76667,47.45,90,127),
(41,new String'("Marchenoir"),41370,699,633,74,9.42,1.4,47.8167,124,151),
(41,new String'("Villeneuve-Frouville"),41290,71,69,16,4.36,1.31667,47.7833,114,125),
(41,new String'("Périgny"),41100,191,188,18,10.41,1.15,47.7333,97,131),
(41,new String'("Bourré"),41400,748,677,154,4.84,1.21667,47.35,58,134),
(41,new String'("Sainte-Anne"),41100,371,273,72,5.13,1.08333,47.75,103,139),
(41,new String'("Huisseau-sur-Cosson"),41350,2193,1913,96,22.79,1.45,47.6,72,97),
(41,new String'("Mer"),41500,6115,5886,231,26.47,1.5,47.7,72,116),
(41,new String'("Chaon"),41600,448,375,14,31.85,2.175,47.6083,112,151),
(41,new String'("Saint-Viâtre"),41210,1269,1157,14,89.79,1.93333,47.5167,92,132),
(41,new String'("Nouan-le-Fuzelier"),41600,2381,2318,27,85.49,2.03628,47.5449,99,138),
(41,new String'("Menars"),41500,606,574,134,4.5,1.4,47.6333,67,111),
(41,new String'("Seur"),41120,467,354,121,3.85,1.33389,47.5028,67,106),
(41,new String'("Souday"),41170,538,542,14,36.42,0.866667,48.0333,106,182),
(41,new String'("Chouzy-sur-Cisse"),41150,1860,1864,82,22.43,1.25,47.5167,61,115),
(41,new String'("Boursay"),41270,206,203,9,22.08,0.966667,48.0167,136,210),
(41,new String'("Autainville"),41240,378,320,15,25.01,1.41667,47.8833,119,153),
(41,new String'("Marcilly-en-Beauce"),41100,362,232,56,6.39,1.0,47.7667,80,132),
(41,new String'("Lassay-sur-Croisne"),41230,245,184,14,16.92,1.61667,47.3667,84,112),
(41,new String'("Villavard"),41800,147,135,28,5.18,0.9,47.75,65,131),
(41,new String'("Champigny-en-Beauce"),41330,654,550,29,22.31,1.25,47.7167,92,129),
(41,new String'("Cheverny"),41700,932,985,28,33.0,1.46667,47.5,78,116),
(41,new String'("Mesland"),41150,556,528,21,26.38,1.11667,47.5167,62,116),
(41,new String'("Chaumont-sur-Loire"),41150,1056,1031,39,26.84,1.18333,47.4833,61,114),
(41,new String'("Selles-Saint-Denis"),41300,1241,1193,24,50.98,1.91667,47.3833,89,129),
(41,new String'("Noyers-sur-Cher"),41140,2809,2608,123,22.74,1.4,47.2833,63,121),
(41,new String'("Faverolles-sur-Cher"),41400,1293,1118,83,15.51,1.18333,47.3167,57,146),
(41,new String'("Courbouzon"),41500,445,390,69,6.41,1.55,47.7167,72,116),
(41,new String'("Talcy"),41370,261,247,17,15.21,1.45,47.7667,107,126),
(41,new String'("Prunay-Cassereau"),41310,652,612,19,32.85,0.916667,47.7,99,154),
(41,new String'("Mulsans"),41500,457,392,28,16.0,1.38333,47.7,105,121),
(41,new String'("Saint-Laurent-Nouan"),41220,4222,3686,69,60.98,1.61167,47.7167,72,112),
(41,new String'("La Chapelle-Montmartin"),41320,420,372,39,10.72,1.73972,47.2703,82,152),
(41,new String'("Cormenon"),41170,697,692,121,5.76,0.883333,47.9667,102,210),
(41,new String'("Le Temple"),41170,176,179,13,13.32,0.934722,47.9323,144,208),
(41,new String'("Saint-Étienne-des-Guérets"),41190,97,98,8,11.72,1.06667,47.6,122,148),
(41,new String'("Saint-Martin-des-Bois"),41800,615,589,16,36.4,0.833333,47.7167,60,156),
(41,new String'("Saint-Denis-sur-Loire"),41000,787,884,63,12.4,1.38333,47.6167,69,115),
(41,new String'("Châtillon-sur-Cher"),41130,1691,1514,57,29.66,1.5,47.2667,67,118),
(41,new String'("Saint-Julien-sur-Cher"),41320,747,664,46,15.99,1.76667,47.2833,82,152),
(41,new String'("Selles-sur-Cher"),41130,4616,4774,179,25.74,1.55,47.2667,68,104),
(41,new String'("Montils"),41120,1794,1436,193,9.27,1.3,47.5,62,101),
(41,new String'("Langon"),41320,848,769,21,38.82,1.83333,47.2833,82,130),
(41,new String'("Concriers"),41370,162,145,33,4.84,1.46667,47.7667,107,124),
(41,new String'("Villermain"),41240,350,285,12,28.75,1.53333,47.8667,112,143),
(41,new String'("La Fontenelle"),41270,196,185,9,20.1,1.03333,48.0667,156,202),
(41,new String'("Rhodon"),41290,105,87,14,7.12,1.26667,47.75,109,128),
(41,new String'("Droué"),41270,1073,1204,44,24.04,1.08333,48.0333,143,214),
(41,new String'("Villiersfaux"),41100,256,224,35,7.22,0.983333,47.75,85,134),
(41,new String'("Landes-le-Gaulois"),41190,697,584,28,24.15,1.18333,47.65,97,128),
(41,new String'("Lignières"),41160,418,376,26,15.77,1.18333,47.8667,84,149),
(41,new String'("Saint-Marc-du-Cor"),41170,190,171,14,13.09,0.95,47.9667,144,216),
(41,new String'("Villebout"),41270,127,106,11,11.21,1.18333,47.9833,107,225),
(41,new String'("Romilly"),41270,162,169,10,14.9,1.03333,47.95,144,210),
(41,new String'("Ouzouer-le-Marché"),41240,1907,1575,67,28.1,1.53333,47.9167,118,136),
(41,new String'("Rocé"),41100,188,197,18,10.27,1.15,47.8,87,131),
(41,new String'("Coulommiers-la-Tour"),41100,527,476,43,12.12,1.13333,47.7833,87,131),
(41,new String'("Saint-Amand-Longpré"),41310,1218,1034,56,21.37,1.01639,47.69,102,134),
(41,new String'("Beauvilliers"),41290,62,37,7,8.0,1.25833,47.8417,120,144),
(41,new String'("Rougeou"),41230,116,102,14,7.89,1.53333,47.3667,92,111),
(41,new String'("Loreux"),41200,236,255,7,29.95,1.83333,47.4,88,124),
(41,new String'("Averdon"),41330,703,644,24,29.14,1.3,47.6833,87,131),
(41,new String'("Nourray"),41310,116,122,9,12.17,1.06667,47.7167,103,133),
(41,new String'("Selommes"),41100,843,759,30,28.01,1.2,47.75,107,131),
(41,new String'("Seillac"),41150,84,78,8,9.58,1.15,47.55,82,122),
(42,new String'("La Côte-en-Couzan"),42111,76,85,8,9.11,3.81667,45.7833,702,1267),
(42,new String'("Périgneux"),42380,1370,1083,42,32.0,4.16667,45.4333,448,720),
(42,new String'("Poncins"),42110,897,754,43,20.63,4.16667,45.7333,331,393),
(42,new String'("Maclas"),42520,1685,1309,166,10.15,4.68333,45.35,256,453),
(42,new String'("Rive-de-Gier"),42800,14996,14383,2045,7.33,4.61667,45.5333,227,394),
(42,new String'("Firminy"),42700,17133,19283,1639,10.45,4.3,45.3833,446,800),
(42,new String'("Chazelles-sur-Lavieu"),42560,247,176,25,9.85,4.0,45.5333,586,1200),
(42,new String'("Châtelneuf"),42940,317,259,37,8.48,4.0,45.6333,498,1110),
(42,new String'("Cottance"),42360,664,551,49,13.55,4.3,45.8,403,656),
(42,new String'("Saint-Genest-Lerpt"),42530,5683,5684,448,12.68,4.33333,45.45,437,698),
(42,new String'("Luriecq"),42380,1190,767,58,20.28,4.06667,45.45,480,1120),
(42,new String'("Caloire"),42240,335,273,71,4.7,4.23333,45.4167,421,772),
(42,new String'("Chenereilles"),42560,476,314,53,8.97,4.08333,45.4833,428,749),
(42,new String'("Saint-Paul-en-Cornillon"),42240,1321,1306,355,3.72,4.23333,45.4,422,713),
(42,new String'("Arçon"),42370,99,107,5,19.19,3.9,46.0,511,1155),
(42,new String'("Saint-Julien-la-Vêtre"),42440,376,451,29,12.9,3.81667,45.8167,490,823),
(42,new String'("Cremeaux"),42260,947,902,28,33.32,3.93333,45.9,456,912),
(42,new String'("Cellieu"),42320,1578,1466,130,12.11,4.53333,45.5167,318,812),
(42,new String'("Chausseterre"),42430,245,277,14,16.58,3.78333,45.9,627,1144),
(42,new String'("Saint-Forgeux-Lespinasse"),42640,538,420,33,16.19,3.93333,46.1167,287,363),
(42,new String'("Leigneux"),42130,391,349,86,4.53,3.98333,45.75,389,581),
(42,new String'("Chirassimont"),42114,376,364,35,10.69,4.28333,45.9167,469,764),
(42,new String'("La Chamba"),42440,51,53,9,5.2,3.76667,45.75,983,1344),
(42,new String'("Saint-Laurent-Rochefort"),42130,252,248,16,15.6,3.91667,45.7667,420,895),
(42,new String'("L'Hôpital-le-Grand"),42210,952,594,74,12.86,4.2,45.6,352,380),
(42,new String'("Arcinges"),42460,194,134,56,3.44,4.28333,46.1333,398,720),
(42,new String'("Maringes"),42140,640,566,69,9.17,4.35,45.65,440,671),
(42,new String'("Unias"),42210,373,237,69,5.37,4.21667,45.6,345,371),
(42,new String'("Saint-Galmier"),42330,5588,5297,287,19.47,4.31667,45.5833,357,551),
(42,new String'("Verrières-en-Forez"),42600,632,539,29,21.17,4.0,45.5667,540,1272),
(42,new String'("La Talaudière"),42350,6459,6688,846,7.63,4.43333,45.4833,473,696),
(42,new String'("La Bénisson-Dieu"),42720,439,444,39,11.12,4.04556,46.15,255,344),
(42,new String'("Renaison"),42370,2866,2658,124,23.04,3.93333,46.05,327,820),
(42,new String'("Saint-Pierre-la-Noaille"),42190,368,323,51,7.21,4.1,46.1833,253,427),
(42,new String'("Marclopt"),42210,494,358,58,8.43,4.2,45.6667,335,363),
(42,new String'("Boën"),42130,3181,3118,530,6.0,3.98333,45.7333,374,557),
(42,new String'("Unieux"),42240,8643,8340,1007,8.58,4.26667,45.4,421,660),
(42,new String'("Vougy"),42720,1408,1495,67,20.9,4.11889,46.1034,256,368),
(42,new String'("Vivans"),42310,247,261,9,25.16,3.95,46.1833,282,364),
(42,new String'("Écoche"),42670,552,413,47,11.7,4.3,46.15,373,791),
(42,new String'("Notre-Dame-de-Boisset"),42120,544,510,59,9.1,4.13333,46.0,278,414),
(42,new String'("Saint-André-le-Puy"),42210,1265,1185,146,8.66,4.26667,45.65,357,374),
(42,new String'("Essertines-en-Donzy"),42360,490,432,70,6.97,4.35,45.75,456,590),
(42,new String'("Maizilly"),42750,341,298,66,5.12,4.25,46.1833,285,483),
(42,new String'("Sauvain"),42990,401,429,13,30.23,3.9,45.6667,640,1631),
(42,new String'("Saint-André-d'Apchon"),42370,1909,1741,142,13.44,3.93333,46.0333,327,808),
(42,new String'("Chalain-le-Comtal"),42600,657,454,35,18.36,4.16667,45.65,338,383),
(42,new String'("Le Cergne"),42460,713,698,120,5.93,4.31667,46.1167,476,787),
(42,new String'("Genilac"),42800,3730,3104,430,8.67,4.58167,45.5323,255,588),
(42,new String'("Saint-Symphorien-de-Lay"),42470,1800,1429,53,33.57,4.21667,45.95,305,621),
(42,new String'("Saint-Marcel-de-Félines"),42122,779,693,34,22.43,4.18333,45.8667,311,524),
(42,new String'("Nandax"),42720,529,333,65,8.03,4.16667,46.1,281,413),
(42,new String'("Marcoux"),42130,728,565,47,15.3,4.01667,45.7167,394,777),
(42,new String'("Cuinzier"),42460,658,584,117,5.62,4.28333,46.1333,389,610),
(42,new String'("Saint-Pierre-de-Bœuf"),42520,1621,1310,272,5.95,4.75,45.3667,130,445),
(42,new String'("Saint-Priest-la-Roche"),42590,302,274,22,13.5,4.1,45.9167,290,535),
(42,new String'("Saint-Germain-la-Montagne"),42670,233,202,18,12.54,4.38333,46.2,434,721),
(42,new String'("Chalain-d'Uzore"),42600,534,444,66,8.03,4.08333,45.6667,369,461),
(42,new String'("Pouilly-sous-Charlieu"),42720,2544,2720,159,15.99,4.11667,46.15,251,331),
(42,new String'("Saint-Jean-Saint-Maurice-sur-Loire"),42155,1124,1025,47,23.57,4.00195,45.9659,270,803),
(42,new String'("Saint-Haon-le-Vieux"),42370,907,810,55,16.34,3.91667,46.0667,319,843),
(42,new String'("Champdieu"),42600,1694,1474,93,18.2,4.05,45.65,363,727),
(42,new String'("Grézolles"),42260,279,228,49,5.6,3.95111,45.8634,453,611),
(42,new String'("Veauche"),42340,8507,8055,817,10.41,4.28333,45.55,348,406),
(42,new String'("Saint-Cyr-de-Favières"),42132,805,772,57,14.11,4.1,45.9667,287,541),
(42,new String'("Aveizieux"),42330,1467,1275,162,9.02,4.38333,45.5667,480,696),
(42,new String'("Civens"),42110,1367,1129,104,13.1,4.25,45.7833,327,470),
(42,new String'("Sorbiers"),42290,7717,7378,633,12.19,4.45,45.4833,435,822),
(42,new String'("Chalmazel"),42920,409,472,10,39.38,3.85,45.7,740,1595),
(42,new String'("Veauchette"),42340,921,740,122,7.54,4.26667,45.5667,347,376),
(42,new String'("Saint-Médard-en-Forez"),42330,935,806,89,10.39,4.36667,45.6,387,656),
(42,new String'("Tartaras"),42800,767,597,196,3.91,4.66667,45.55,190,348),
(42,new String'("Malleval"),42520,552,476,109,5.06,4.725,45.3833,151,414),
(42,new String'("Graix"),42220,145,134,16,8.58,4.56667,45.35,813,1431),
(42,new String'("Saint-Priest-la-Vêtre"),42440,134,106,25,5.17,3.8,45.8,607,820),
(42,new String'("Montrond-les-Bains"),42210,4785,4031,473,10.11,4.23333,45.6333,333,369),
(42,new String'("Colombier"),42220,308,269,17,17.86,4.6,45.3378,649,1429),
(42,new String'("Craintilleux"),42210,1170,902,142,8.22,4.23333,45.5833,348,379),
(42,new String'("Saint-Thurin"),42111,194,181,26,7.35,3.86667,45.8167,450,717),
(42,new String'("Ailleux"),42130,147,143,15,9.31,3.95,45.8,428,722),
(42,new String'("L'Hôpital-sous-Rochefort"),42130,118,109,102,1.15,3.93361,45.7739,411,578),
(42,new String'("Valeille"),42110,665,518,40,16.43,4.30695,45.7075,350,532),
(42,new String'("Bourg-Argental"),42220,3011,2771,149,20.15,4.55,45.3,450,1003),
(42,new String'("Arthun"),42130,511,459,36,13.88,4.03333,45.7667,346,502),
(42,new String'("Saint-Martin-d'Estréaux"),42620,897,958,30,29.6,3.8,46.2,298,589),
(42,new String'("Montbrison"),42600,15299,14597,936,16.33,4.05,45.6,370,552),
(42,new String'("Mornand-en-Forez"),42600,422,294,19,21.6,4.13333,45.6833,343,385),
(42,new String'("Chambœuf"),42330,1590,1358,142,11.12,4.31667,45.5833,366,545),
(42,new String'("Bussières"),42510,1515,1303,90,16.76,4.26667,45.8333,458,770),
(42,new String'("Lentigny"),42155,1587,1352,140,11.3,3.98333,46.0,320,440),
(42,new String'("Saint-Maurice-en-Gourgois"),42240,1728,1282,54,31.83,4.18333,45.4,422,816),
(42,new String'("Saint-Denis-de-Cabanne"),42750,1300,1293,169,7.65,4.21667,46.1667,273,423),
(42,new String'("Magneux-Haute-Rive"),42600,481,304,38,12.56,4.16667,45.6667,334,389),
(42,new String'("Changy"),42310,615,583,44,13.67,3.9,46.15,298,556),
(42,new String'("Salt-en-Donzy"),42110,535,393,59,8.93,4.28333,45.7333,346,490),
(42,new String'("Sainte-Croix-en-Jarez"),42800,435,351,36,12.05,4.65,45.4833,349,955),
(42,new String'("Saint-Étienne"),42000,171260,180438,2141,79.97,4.4,45.4333,422,1117),
(42,new String'("Vérin"),42410,692,577,226,3.05,4.75,45.45,143,369),
(42,new String'("Saint-Romain-en-Jarez"),42800,1168,929,68,16.96,4.51667,45.55,360,920),
(42,new String'("Saint-Jean-Bonnefonds"),42650,6316,6093,544,11.59,4.45,45.45,418,663),
(42,new String'("Cuzieu"),42330,1498,1394,130,11.51,4.26667,45.6167,348,390),
(42,new String'("Saint-Romain-la-Motte"),42640,1554,1384,56,27.56,3.98333,46.0833,290,361),
(42,new String'("Sury-le-Comtal"),42450,5605,4803,231,24.18,4.16667,45.5333,360,457),
(42,new String'("Saint-Michel-sur-Rhône"),42410,778,638,132,5.87,4.75,45.45,140,436),
(42,new String'("Andrézieux-Bouthéon"),42160,9676,9149,594,16.28,4.26028,45.5262,353,435),
(42,new String'("Noirétable"),42440,1666,1637,41,40.34,3.76667,45.8167,656,1351),
(42,new String'("L'Horme"),42152,4750,4639,1079,4.4,4.55,45.4833,299,414),
(42,new String'("Balbigny"),42510,2840,2618,167,16.98,4.18333,45.8167,314,482),
(42,new String'("Saint-Cyr-de-Valorges"),42114,352,274,35,9.91,4.30833,45.8917,526,892),
(42,new String'("Ouches"),42155,1116,1014,110,10.12,3.98333,46.0167,295,376),
(42,new String'("Chambles"),42170,969,762,51,18.9,4.23333,45.45,360,741),
(42,new String'("Le Crozet"),42310,298,293,22,13.31,3.855,46.1706,344,595),
(42,new String'("Tarentaise"),42660,450,412,35,12.57,4.5,45.3667,856,1296),
(42,new String'("Saint-Hilaire-Cusson-la-Valmitte"),42380,324,259,17,18.31,4.04195,45.3687,640,977),
(42,new String'("Burdignes"),42220,347,341,11,30.81,4.56667,45.2667,472,1382),
(42,new String'("Bard"),42600,610,577,44,13.78,4.01667,45.5833,417,1271),
(42,new String'("Saint-Priest-la-Prugne"),42830,459,442,12,36.68,3.75,45.9667,610,1287),
(42,new String'("Apinac"),42550,401,304,26,15.35,4.0,45.3833,796,1055),
(42,new String'("Trelins"),42130,616,538,76,8.09,4.01667,45.7333,368,736),
(42,new String'("Viricelles"),42140,432,333,216,2.0,4.38333,45.65,477,593),
(42,new String'("Marcilly-le-Châtel"),42130,1272,973,77,16.32,4.03723,45.695,377,708),
(42,new String'("Saint-Bonnet-les-Oules"),42330,1516,1257,122,12.41,4.33333,45.55,392,586),
(42,new String'("Perreux"),42120,2169,2074,52,41.35,4.11667,46.0333,255,436),
(42,new String'("Saint-Victor-sur-Rhins"),42630,1126,896,98,11.43,4.28333,46.0,330,574),
(42,new String'("Charlieu"),42190,3695,3592,551,6.7,4.18333,46.15,268,378),
(42,new String'("Le Chambon-Feugerolles"),42500,12851,14079,733,17.51,4.31667,45.4,464,849),
(42,new String'("Saint-Christo-en-Jarez"),42320,1822,1363,83,21.77,4.48333,45.55,540,885),
(42,new String'("Roche"),42600,268,253,11,23.33,3.95,45.6167,756,1418),
(42,new String'("Farnay"),42320,1342,1138,169,7.93,4.6,45.5,315,792),
(42,new String'("Saint-Barthélemy-Lestra"),42110,684,582,61,11.06,4.33333,45.7167,371,593),
(42,new String'("La Valla-en-Gier"),42131,939,741,26,34.78,4.51667,45.4167,440,1388),
(42,new String'("Saint-Martin-Lestra"),42110,910,702,55,16.33,4.35,45.7167,457,623),
(42,new String'("Jas"),42110,220,178,35,6.22,4.31667,45.75,368,566),
(42,new String'("Marlhes"),42660,1393,1305,42,32.6,4.4,45.2833,810,1190),
(42,new String'("Écotay-l'Olme"),42600,1130,1110,173,6.52,4.05,45.5833,416,667),
(42,new String'("Luré"),42260,142,143,22,6.23,3.93333,45.8833,510,681),
(42,new String'("Soleymieux"),42560,644,470,73,8.8,4.05,45.5167,514,780),
(42,new String'("Sainte-Colombe-sur-Gand"),42540,410,419,30,13.56,4.26667,45.8833,468,774),
(42,new String'("Saint-Romain-le-Puy"),42610,3607,2803,170,21.14,4.11667,45.55,366,524),
(42,new String'("Cezay"),42130,190,157,18,10.52,3.96667,45.8,419,714),
(42,new String'("La Gimond"),42140,272,217,80,3.37,4.41667,45.55,598,773),
(42,new String'("Bonson"),42160,3593,3816,697,5.15,4.23333,45.5167,355,385),
(42,new String'("Montarcher"),42380,63,75,10,5.99,4.0,45.45,938,1194),
(42,new String'("Saint-Nizier-sous-Charlieu"),42190,1661,1572,129,12.83,4.13333,46.15,252,408),
(42,new String'("Saint-Georges-Haute-Ville"),42610,1272,1122,132,9.63,4.1,45.55,400,655),
(42,new String'("Saint-Paul-en-Jarez"),42740,4103,4128,205,19.98,4.58333,45.4833,313,947),
(42,new String'("Sail-les-Bains"),42310,209,222,9,21.11,3.85,46.2333,279,421),
(42,new String'("Saint-Bonnet-des-Quarts"),42310,361,363,11,32.45,3.85,46.1333,395,966),
(42,new String'("Saint-Marcel-d'Urfé"),42430,283,264,20,13.92,3.88333,45.8667,491,900),
(42,new String'("Boyer"),42460,225,159,43,5.18,4.21667,46.1,318,449),
(42,new String'("Virigneux"),42140,588,465,49,11.84,4.35,45.6833,427,652),
(42,new String'("Chazelles-sur-Lyon"),42140,5110,4808,244,20.91,4.38333,45.6333,414,631),
(42,new String'("Débats-Rivière-d'Orpra"),42130,166,136,48,3.41,3.93861,45.76,402,680),
(42,new String'("Saint-Cyprien"),42160,2313,2126,317,7.28,4.23333,45.5333,354,380),
(42,new String'("La Chapelle-en-Lafaye"),42380,138,108,15,8.99,3.98333,45.4667,917,1174),
(42,new String'("Saint-Just-en-Bas"),42136,304,317,14,20.95,3.88333,45.7333,670,1174),
(42,new String'("Ambierle"),42820,1805,1729,58,30.76,3.9,46.1,297,843),
(42,new String'("Saint-Germain-Laval"),42260,1672,1487,97,17.08,4.01667,45.8333,344,526),
(42,new String'("Saint-Bonnet-le-Courreau"),42940,733,745,14,50.18,3.95,45.6667,500,1481),
(42,new String'("Pradines"),42630,679,611,58,11.6,4.18333,46.0,302,459),
(42,new String'("Saint-Rirand"),42370,158,110,9,16.43,3.85,46.0667,486,1035),
(42,new String'("Villemontais"),42155,981,933,77,12.73,3.95,45.9833,397,946),
(42,new String'("Noës"),42370,186,163,11,15.68,3.85195,46.0412,497,1122),
(42,new String'("Bessey"),42520,398,296,63,6.24,4.7,45.3833,278,430),
(42,new String'("Le Coteau"),42120,6905,7376,1412,4.89,4.08333,46.0333,265,317),
(42,new String'("Saint-Chamond"),42400,35793,37361,652,54.88,4.5,45.4667,326,1051),
(42,new String'("La Tuilière"),42830,287,321,9,31.09,3.8,45.9417,644,1097),
(42,new String'("Estivareilles"),42380,671,519,29,22.56,4.01667,45.4167,885,1149),
(42,new String'("Châteauneuf"),42800,1480,1445,108,13.65,4.62473,45.522,208,657),
(42,new String'("Saint-Bonnet-le-Château"),42380,1562,1549,835,1.87,4.06667,45.4167,779,952),
(42,new String'("Boisset-Saint-Priest"),42560,1141,880,62,18.28,4.11667,45.5167,399,645),
(42,new String'("Croizet-sur-Gand"),42540,284,224,47,5.98,4.23333,45.9167,407,578),
(42,new String'("Fraisses"),42490,3958,3954,854,4.63,4.26612,45.3878,437,746),
(42,new String'("Grammond"),42140,860,751,105,8.13,4.43333,45.5667,599,885),
(42,new String'("Saint-Vincent-de-Boisset"),42120,884,878,215,4.11,4.11667,46.0,269,382),
(42,new String'("Saint-Sauveur-en-Rue"),42220,1124,1105,37,30.26,4.5,45.2667,600,1359),
(42,new String'("Dargoire"),42800,452,410,235,1.92,4.66806,45.5603,189,335),
(42,new String'("Saint-Appolinard"),42520,609,526,61,9.84,4.65,45.3417,368,1060),
(42,new String'("Mizérieux"),42110,398,237,56,7.01,4.16667,45.8,319,394),
(42,new String'("Bussy-Albieux"),42260,482,442,24,19.65,4.03333,45.8,339,534),
(42,new String'("Champoly"),42430,288,264,19,14.89,3.83333,45.85,490,952),
(42,new String'("Savigneux"),42600,3186,2566,166,19.19,4.08333,45.6167,357,398),
(42,new String'("Sainte-Agathe-la-Bouteresse"),42130,1116,813,94,11.75,4.055,45.7342,355,411),
(42,new String'("Saint-Léger-sur-Roanne"),42155,1148,944,254,4.51,4.0,46.0333,296,339),
(42,new String'("Saint-Julien-d'Oddes"),42260,270,258,25,10.41,4.0,45.85,384,560),
(42,new String'("Marols"),42560,398,336,26,14.94,4.05,45.4833,620,1184),
(42,new String'("Combre"),42840,421,282,104,4.01,4.26667,46.0333,334,482),
(42,new String'("Thélis-la-Combe"),42220,175,146,12,14.57,4.55,45.3167,600,1313),
(42,new String'("La Gresle"),42460,790,745,53,14.75,4.28333,46.0667,371,662),
(42,new String'("Machézal"),42114,419,360,30,13.88,4.31667,45.9167,470,882),
(42,new String'("Lézigneux"),42600,1656,1153,110,15.04,4.06667,45.5667,419,844),
(42,new String'("Saint-Just-Saint-Rambert"),42170,14172,13189,348,40.63,4.24,45.4995,358,673),
(42,new String'("Lérigneux"),42600,155,126,15,9.76,3.96667,45.6,827,1344),
(42,new String'("Chagnon"),42800,506,412,204,2.48,4.55,45.5333,300,518),
(42,new String'("Planfoy"),42660,909,852,74,12.27,4.45,45.3833,597,1099),
(42,new String'("Sail-sous-Couzan"),42890,951,981,127,7.43,3.95,45.7333,396,689),
(42,new String'("Saint-Polgues"),42260,240,193,41,5.77,3.98333,45.9167,453,644),
(42,new String'("La Versanne"),42220,355,324,23,15.13,4.53333,45.3167,760,1292),
(42,new String'("La Grand-Croix"),42320,5070,4971,1251,4.05,4.55,45.5,274,427),
(42,new String'("Véranne"),42520,808,582,50,15.96,4.66667,45.3667,417,1390),
(42,new String'("Marcenod"),42140,650,518,72,9.0,4.5,45.5667,655,946),
(42,new String'("Pouilly-lès-Feurs"),42110,1181,988,90,13.03,4.23333,45.8,338,526),
(42,new String'("Saint-Martin-la-Plaine"),42800,3686,3432,380,9.7,4.6,45.5333,257,630),
(42,new String'("Sainte-Agathe-en-Donzy"),42510,111,117,32,3.39,4.31667,45.8333,566,771),
(42,new String'("La Chambonie"),42440,59,46,13,4.42,3.75,45.75,940,1383),
(42,new String'("Villerest"),42300,4641,4246,313,14.82,4.03667,45.9934,261,426),
(42,new String'("Saint-Priest-en-Jarez"),42270,6177,5815,2012,3.07,4.36667,45.4667,437,590),
(42,new String'("Montagny"),42840,1163,1113,45,25.57,4.23584,46.0328,316,542),
(42,new String'("Lavieu"),42560,95,77,21,4.45,4.03333,45.5333,496,771),
(42,new String'("Chavanay"),42410,2833,2291,188,15.06,4.73333,45.4167,140,463),
(42,new String'("Salvizinet"),42110,599,488,55,10.84,4.26667,45.7667,340,552),
(42,new String'("Saint-Cyr-les-Vignes"),42210,926,789,47,19.38,4.3,45.6833,357,595),
(42,new String'("Gumières"),42560,317,253,19,16.12,3.98333,45.5333,748,1236),
(42,new String'("Pouilly-les-Nonains"),42155,1824,1597,178,10.23,3.98333,46.0333,308,354),
(42,new String'("Panissières"),42360,2972,2860,111,26.71,4.33333,45.7833,426,835),
(42,new String'("Amions"),42260,290,238,17,17.01,4.03333,45.8833,359,525),
(42,new String'("Pélussin"),42410,3515,3354,109,32.16,4.68333,45.4167,240,1340),
(42,new String'("Saint-Romain-d'Urfé"),42430,284,271,18,15.0,3.83333,45.8833,593,886),
(42,new String'("Mars"),42750,552,551,45,12.03,4.24639,46.1531,331,592),
(42,new String'("Saint-Martin-la-Sauveté"),42260,974,898,32,29.74,3.91667,45.8333,396,889),
(42,new String'("Chambéon"),42110,483,369,28,16.85,4.18333,45.7,331,388),
(42,new String'("Saint-Paul-d'Uzore"),42600,138,98,14,9.51,4.08333,45.6667,350,520),
(42,new String'("Saint-Haon-le-Châtel"),42370,596,573,685,0.87,3.91667,46.0667,363,463),
(42,new String'("Saint-Thomas-la-Garde"),42600,585,517,171,3.41,4.08333,45.5667,400,546),
(42,new String'("Jonzieux"),42660,1217,1039,117,10.32,4.36667,45.3167,807,944),
(42,new String'("Saint-Paul-de-Vézelin"),42590,306,299,22,13.52,4.08333,45.8833,288,482),
(42,new String'("Rozier-en-Donzy"),42810,1362,1274,143,9.51,4.28333,45.8,380,682),
(42,new String'("Montverdun"),42130,1117,758,67,16.52,4.06667,45.7167,340,531),
(42,new String'("Essertines-en-Châtelneuf"),42600,664,587,43,15.2,4.0,45.6167,444,1010),
(42,new String'("Sainte-Foy-Saint-Sulpice"),42110,483,354,16,29.12,4.13333,45.7667,327,401),
(42,new String'("Boisset-lès-Montrond"),42210,1081,828,134,8.01,4.2,45.6167,337,379),
(42,new String'("Urbise"),42310,137,140,8,15.5,3.9,46.25,269,330),
(42,new String'("Aboën"),42380,363,234,40,8.96,4.13333,45.4167,594,771),
(42,new String'("La Tour-en-Jarez"),42580,1327,1153,262,5.05,4.4,45.4833,453,698),
(42,new String'("Saint-Régis-du-Coin"),42660,374,336,18,20.4,4.45,45.2833,977,1302),
(42,new String'("Saint-Sixte"),42130,695,582,45,15.35,3.98333,45.7833,390,656),
(42,new String'("La Fouillouse"),42480,4393,4234,213,20.57,4.31667,45.5,387,628),
(42,new String'("Bellegarde-en-Forez"),42210,1847,1468,97,18.91,4.3,45.65,361,606),
(42,new String'("Saint-Joseph"),42800,1908,1623,237,8.05,4.61667,45.55,219,497),
(42,new String'("Jeansagnière"),42920,83,103,5,14.01,3.83333,45.7333,900,1383),
(42,new String'("Saint-Jean-Soleymieux"),42560,850,726,51,16.47,4.03333,45.5,699,1204),
(42,new String'("Doizieux"),42740,828,652,29,28.07,4.58333,45.4167,480,1396),
(42,new String'("Saint-Étienne-le-Molard"),42130,969,749,58,16.55,4.08333,45.7333,338,397),
(42,new String'("Rivas"),42340,524,408,113,4.6,4.25,45.5833,349,390),
(42,new String'("Jarnosse"),42460,414,354,34,11.88,4.23333,46.1,344,570),
(42,new String'("Lupé"),42520,316,251,214,1.47,4.71667,45.3667,263,382),
(42,new String'("Mably"),42300,7551,7636,230,32.8,4.06667,46.0833,257,353),
(42,new String'("L'Étrat"),42580,2621,2524,309,8.48,4.38333,45.4833,430,686),
(42,new String'("Saint-Georges-de-Baroille"),42510,328,281,21,15.24,4.13333,45.85,304,416),
(42,new String'("Briennon"),42720,1733,1690,72,23.84,4.08333,46.15,253,345),
(42,new String'("Précieux"),42600,1047,771,64,16.29,4.15111,45.5864,358,404),
(42,new String'("Margerie-Chantagret"),42560,699,510,90,7.71,4.06667,45.5333,491,802),
(42,new String'("La Chapelle-Villars"),42410,561,333,68,8.25,4.71667,45.4667,318,785),
(42,new String'("Merle-Leignec"),42380,306,239,18,16.17,4.0175,45.3748,660,994),
(42,new String'("Souternon"),42260,326,311,19,17.05,4.0,45.8667,383,581),
(42,new String'("La Ricamarie"),42150,7976,8456,1147,6.95,4.36667,45.4,528,841),
(42,new String'("Pinay"),42590,278,273,41,6.62,4.15,45.8667,302,470),
(42,new String'("Roisey"),42520,881,698,67,13.03,4.67195,45.3875,390,1343),
(42,new String'("Néronde"),42510,472,448,55,8.57,4.23333,45.8333,377,606),
(42,new String'("Le Bessat"),42660,438,415,43,10.06,4.51667,45.3667,700,1308),
(42,new String'("Belmont-de-la-Loire"),42670,1532,1497,64,23.71,4.35,46.1667,402,822),
(42,new String'("Cervières"),42440,115,111,15,7.56,3.78333,45.85,655,979),
(42,new String'("Usson-en-Forez"),42550,1466,1230,31,47.24,3.93333,45.3833,767,1137),
(42,new String'("Saint-Julien-Molin-Molette"),42220,1243,1136,131,9.45,4.61667,45.3167,441,880),
(42,new String'("Cherier"),42430,483,445,17,28.11,3.91667,45.9667,594,1156),
(42,new String'("La Pacaudière"),42310,1066,1169,51,20.61,3.86667,46.1833,295,443),
(42,new String'("Roche-la-Molière"),42230,10359,10077,593,17.44,4.31667,45.4333,469,700),
(42,new String'("Chevrières"),42140,1055,844,72,14.54,4.4,45.5833,426,770),
(42,new String'("Montchal"),42360,443,424,50,8.84,4.31473,45.8259,512,782),
(42,new String'("Chuyer"),42410,766,588,63,12.06,4.7,45.45,319,880),
(42,new String'("Châtelus"),42140,127,108,50,2.53,4.46667,45.6,550,788),
(42,new String'("Saint-Héand"),42570,3561,3750,113,31.3,4.36667,45.5167,467,870),
(42,new String'("Saint-Nizier-de-Fornas"),42380,642,584,40,15.88,4.08333,45.4,619,995),
(42,new String'("Parigny"),42120,624,506,68,9.15,4.1,45.9833,277,446),
(42,new String'("Saint-Hilaire-sous-Charlieu"),42190,563,399,41,13.51,4.2,46.1167,280,464),
(42,new String'("Saint-Jean-la-Vêtre"),42440,344,387,21,16.22,3.8,45.7833,654,1296),
(42,new String'("Palogneux"),42890,73,52,10,7.01,3.91667,45.75,496,945),
(42,new String'("Nollieux"),42260,156,133,22,6.95,4.0,45.8167,389,612),
(42,new String'("Saint-Marcellin-en-Forez"),42680,4213,3376,135,31.09,4.16667,45.4833,379,640),
(42,new String'("Nervieux"),42510,906,791,46,19.44,4.15,45.8,315,385),
(42,new String'("Pralong"),42600,850,677,105,8.03,4.03333,45.6667,398,716),
(42,new String'("Rozier-Côtes-d'Aurec"),42380,445,359,32,13.89,4.11667,45.3667,540,931),
(42,new String'("Commelle-Vernay"),42120,2800,2793,225,12.41,4.06667,46.0,265,446),
(42,new String'("Villers"),42460,575,501,100,5.73,4.23333,46.1167,357,482),
(42,new String'("Saint-Didier-sur-Rochefort"),42111,415,409,18,22.75,3.85,45.7833,457,900),
(42,new String'("Cordelle"),42123,892,782,33,26.64,4.06667,45.95,280,556),
(42,new String'("Saint-Germain-Lespinasse"),42640,1161,1098,77,15.0,3.9625,46.1031,281,349),
(42,new String'("Regny"),42630,1581,1618,114,13.8,4.21667,45.9833,305,510),
(42,new String'("Saint-Denis-sur-Coise"),42140,586,548,54,10.79,4.43333,45.6167,451,721),
(42,new String'("Neaux"),42470,520,443,29,17.36,4.18333,45.9667,294,606),
(42,new String'("La Tourette"),42380,566,426,100,5.65,4.08445,45.4148,619,872),
(42,new String'("Violay"),42780,1338,1346,49,27.07,4.35,45.85,535,1003),
(42,new String'("Lay"),42470,710,648,55,12.85,4.21667,45.95,339,592),
(42,new String'("Chandon"),42190,1448,1382,116,12.38,4.21667,46.15,271,472),
(42,new String'("Villars"),42390,7831,8496,1369,5.72,4.35,45.4667,428,600),
(42,new String'("Saint-Alban-les-Eaux"),42370,920,954,118,7.75,3.93333,46.0,360,791),
(42,new String'("Dancé"),42260,159,110,18,8.83,4.03333,45.9,283,583),
(42,new String'("Belleroche"),42670,259,212,18,13.93,4.41667,46.1667,473,881),
(42,new String'("Roanne"),42300,36806,38880,2283,16.12,4.06889,46.0367,257,304),
(42,new String'("Pavezin"),42410,339,262,38,8.87,4.66667,45.4667,436,955),
(42,new String'("Valfleury"),42320,664,519,75,8.77,4.5,45.5167,359,820),
(42,new String'("Salles"),42440,479,425,18,25.22,3.79361,45.8478,636,963),
(42,new String'("Neulise"),42590,1269,1152,55,22.99,4.18333,45.9,376,606),
(42,new String'("Vendranges"),42590,325,237,29,11.14,4.13333,45.9333,305,562),
(42,new String'("Juré"),42430,244,209,20,12.07,3.88333,45.8833,490,836),
(42,new String'("Grézieux-le-Fromental"),42600,121,105,11,10.31,4.15,45.6167,351,389),
(42,new String'("Saint-Romain-les-Atheux"),42660,924,816,62,14.68,4.38333,45.35,635,983),
(42,new String'("Fourneaux"),42470,617,548,50,12.17,4.26945,45.937,416,607),
(42,new String'("Coutouvre"),42460,1098,1024,50,21.87,4.21667,46.0667,303,538),
(42,new String'("Cleppé"),42110,556,454,35,15.48,4.18333,45.7667,323,394),
(42,new String'("Épercieux-Saint-Paul"),42110,663,543,83,7.92,4.21667,45.8,319,344),
(42,new String'("Feurs"),42110,7921,7671,324,24.39,4.23333,45.75,327,366),
(42,new String'("Saint-Jodard"),42590,555,604,83,6.65,4.13333,45.8833,300,464),
(42,new String'("Riorges"),42153,10714,10068,690,15.51,4.03333,46.0333,277,334),
(42,new String'("La Valla-sur-Rochefort"),42111,137,118,15,8.98,3.85,45.75,766,1224),
(42,new String'("Lorette"),42420,4498,4861,1319,3.41,4.58333,45.5167,257,500),
(42,new String'("La Terrasse-sur-Dorlay"),42740,765,654,88,8.69,4.58333,45.45,400,873),
(42,new String'("Saint-Just-en-Chevalet"),42430,1182,1286,40,29.19,3.85,45.9167,556,983),
(42,new String'("Saint-Genest-Malifaux"),42660,2931,2691,62,47.08,4.41667,45.3333,680,1292),
(42,new String'("Bully"),42260,395,298,20,19.03,4.0,45.9333,281,733),
(42,new String'("Noailly"),42640,776,720,24,31.45,4.01667,46.1333,268,363),
(42,new String'("Saint-Just-la-Pendue"),42540,1569,1420,78,19.88,4.25,45.9,428,637),
(42,new String'("Saint-Georges-en-Couzan"),42990,406,459,17,23.64,3.93333,45.7,452,1134),
(42,new String'("Pommiers"),42260,374,372,15,23.84,4.06667,45.8333,318,408),
(42,new String'("Sevelinges"),42460,651,581,79,8.19,4.3,46.1,397,682),
(42,new String'("Saint-Laurent-la-Conche"),42210,594,480,38,15.51,4.2,45.6833,326,366),
(42,new String'("Fontanès"),42140,652,576,98,6.63,4.43333,45.55,633,900),
(43,new String'("Blavozy"),43700,1592,1319,249,6.38,3.95,45.05,634,871),
(43,new String'("Desges"),43300,63,79,3,16.83,3.46667,45.0167,662,1177),
(43,new String'("Vissac-Auteyrac"),43300,336,299,19,17.1,3.60973,45.122,678,1229),
(43,new String'("Loudes"),43320,870,804,35,24.33,3.75,45.0833,759,1042),
(43,new String'("Saint-Jeures"),43200,910,782,26,34.14,4.2,45.1,749,1208),
(43,new String'("La Chapelle-Geneste"),43160,139,141,7,18.06,3.66667,45.35,668,1114),
(43,new String'("Vieille-Brioude"),43100,1215,1102,43,27.7,3.41667,45.2667,425,725),
(43,new String'("Saint-Julien-Chapteuil"),43260,1870,1806,66,28.26,4.06667,45.0333,771,1408),
(43,new String'("Grenier-Montgon"),43450,118,123,23,5.01,3.21667,45.2833,504,694),
(43,new String'("Vazeilles-Limandre"),43320,241,211,20,11.72,3.66667,45.1167,877,1197),
(43,new String'("Tence"),43190,3193,2891,61,52.12,4.28333,45.1167,803,1127),
(43,new String'("Fontannes"),43100,1058,873,108,9.77,3.425,45.2917,419,527),
(43,new String'("Blanzac"),43350,311,267,36,8.58,3.85,45.1167,569,915),
(43,new String'("Borne"),43350,425,352,77,5.48,3.78333,45.1,720,885),
(43,new String'("Le Chambon-sur-Lignon"),43400,2672,2645,64,41.71,4.3,45.05,874,1139),
(43,new String'("Blassac"),43380,152,121,12,12.56,3.41667,45.1667,441,953),
(43,new String'("Moudeyres"),43150,107,104,11,9.25,4.11667,44.95,957,1286),
(43,new String'("Chassignolles"),43440,80,84,4,18.27,3.5,45.4,666,1100),
(43,new String'("Saint-Préjet-d'Allier"),43580,171,199,6,24.46,3.61667,44.9167,711,1135),
(43,new String'("Monistrol-sur-Loire"),43120,8717,7451,180,48.25,4.16667,45.2833,434,874),
(43,new String'("Boisset"),43500,285,221,20,14.04,3.98333,45.3167,590,944),
(43,new String'("Beaumont"),43100,269,236,22,12.03,3.34239,45.3167,421,692),
(43,new String'("Azerat"),43390,265,274,14,18.11,3.38333,45.3667,404,661),
(43,new String'("Vazeilles-près-Saugues"),43580,42,44,6,6.73,3.58333,44.9,894,1154),
(43,new String'("Torsiac"),43450,72,71,7,9.06,3.23333,45.35,460,690),
(43,new String'("Josat"),43230,91,111,7,12.44,3.6,45.2167,620,1107),
(43,new String'("Solignac-sous-Roche"),43130,216,150,24,8.65,4.0,45.25,520,876),
(43,new String'("Pébrac"),43300,124,137,6,17.85,3.51667,45.0333,560,1071),
(43,new String'("Ally"),43380,163,222,5,31.13,3.30833,45.1583,549,1109),
(43,new String'("Beaulieu"),43800,923,845,41,22.27,3.94195,45.1281,543,948),
(43,new String'("Polignac"),43770,2809,2603,84,33.05,3.86667,45.0667,562,892),
(43,new String'("Saint-Geneys-près-Saint-Paulien"),43350,303,254,18,16.49,3.81667,45.15,750,1098),
(43,new String'("Saint-Julien-des-Chazes"),43300,75,69,11,6.63,3.58333,45.05,519,923),
(43,new String'("Léotoing"),43410,207,209,10,19.56,3.23333,45.3667,460,701),
(43,new String'("Monistrol-d'Allier"),43580,219,256,8,27.32,3.63333,44.95,551,1074),
(43,new String'("Venteuges"),43170,366,380,9,39.35,3.51667,44.9833,670,1270),
(43,new String'("Chomelix"),43500,488,409,18,26.47,3.83333,45.2667,674,1089),
(43,new String'("Saint-Martin-de-Fugères"),43150,204,245,9,20.87,3.93333,44.9,725,1185),
(43,new String'("Le Brignon"),43370,595,544,17,34.9,3.88333,44.9333,698,1127),
(43,new String'("Brioude"),43100,6664,6818,492,13.52,3.4,45.3,414,622),
(43,new String'("Sainte-Florine"),43250,3145,3005,410,7.67,3.33333,45.4,400,511),
(43,new String'("Laussonne"),43150,1007,990,40,25.11,4.05,44.9667,796,1191),
(43,new String'("Couteuges"),43230,302,262,29,10.34,3.51667,45.1833,520,722),
(43,new String'("Autrac"),43450,78,69,9,8.46,3.13333,45.3333,552,1028),
(43,new String'("Grazac"),43200,1000,728,46,21.66,4.18333,45.1833,537,854),
(43,new String'("Bonneval"),43160,86,105,5,14.66,3.75,45.3167,740,1126),
(43,new String'("Saint-Paulien"),43350,2406,1910,59,40.63,3.81667,45.1333,704,1070),
(43,new String'("Sembadel"),43160,248,251,13,18.59,3.68333,45.2667,849,1128),
(43,new String'("Saint-Pierre-Eynac"),43260,1030,848,42,23.99,4.03333,45.05,685,1070),
(43,new String'("Beauzac"),43590,2762,2063,76,36.33,4.1,45.25,440,969),
(43,new String'("Saint-Front"),43550,458,516,8,52.33,4.13333,44.9833,796,1594),
(43,new String'("Landos"),43340,932,902,25,36.51,3.83333,44.85,978,1237),
(43,new String'("Vorey"),43800,1423,1447,36,39.23,3.9,45.1833,510,948),
(43,new String'("Siaugues-Sainte-Marie"),43300,798,798,19,40.01,3.6325,45.0937,540,1301),
(43,new String'("Goudet"),43150,61,62,13,4.5,3.91667,44.8833,733,1018),
(43,new String'("Lorlanges"),43360,326,242,22,14.49,3.26667,45.3333,523,682),
(43,new String'("Bas-en-Basset"),43210,4126,3349,88,46.76,4.1,45.3,433,901),
(43,new String'("Frugières-le-Pin"),43230,135,121,11,11.57,3.5,45.2667,467,766),
(43,new String'("Allègre"),43270,987,1009,41,23.57,3.7,45.2,880,1172),
(43,new String'("Saint-Julien-d'Ance"),43500,238,213,13,17.82,3.91667,45.3,653,954),
(43,new String'("Valprivas"),43210,498,401,21,23.66,4.05,45.3167,491,953),
(43,new String'("Saint-Vert"),43440,109,103,5,20.67,3.55,45.3667,710,1132),
(43,new String'("Lavoûte-Chilhac"),43380,308,302,85,3.61,3.4,45.15,447,640),
(43,new String'("Sanssac-l'Église"),43320,1049,894,68,15.28,3.76667,45.05,660,964),
(43,new String'("Mézères"),43800,158,102,18,8.58,4.0,45.15,805,1089),
(43,new String'("Saint-Pal-de-Mons"),43620,2069,1747,76,27.11,4.28333,45.2333,615,969),
(43,new String'("Champclause"),43260,207,229,9,22.27,4.175,45.025,1108,1436),
(43,new String'("Tiranges"),43130,456,407,16,26.83,3.98333,45.3,489,921),
(43,new String'("Saint-Arcons-d'Allier"),43300,194,164,12,16.08,3.56667,45.0667,498,1045),
(43,new String'("Lempdes-sur-Allagnon"),43410,1323,1370,127,10.4,3.2721,45.385,425,546),
(43,new String'("La Besseyre-Saint-Mary"),43170,134,131,6,21.57,3.41667,44.9667,749,1496),
(43,new String'("Saint-Julien-Molhesabate"),43220,206,198,7,27.5,4.43333,45.1833,809,1388),
(43,new String'("Saint-Paul-de-Tartas"),43420,192,244,6,27.47,3.9,44.8,933,1342),
(43,new String'("Chadron"),43150,258,207,18,13.62,3.93333,44.9667,667,983),
(43,new String'("Paulhac"),43100,656,618,78,8.4,3.35,45.3,436,646),
(43,new String'("Saint-Julien-du-Pinet"),43200,452,344,26,17.2,4.03333,45.1333,637,1186),
(43,new String'("La Séauve-sur-Semène"),43140,1414,1097,179,7.86,4.25,45.2833,657,865),
(43,new String'("Vergezac"),43320,428,405,21,20.31,3.71667,45.0333,902,1259),
(43,new String'("Saint-Bonnet-le-Froid"),43290,231,194,17,13.09,4.45,45.15,758,1161),
(43,new String'("Lantriac"),43260,1860,1598,81,22.83,4.0,45.0,678,1083),
(43,new String'("Prades"),43300,62,62,12,4.82,3.59278,45.0275,535,880),
(43,new String'("Saint-Jean-de-Nay"),43320,384,429,13,28.26,3.7,45.0667,868,1301),
(43,new String'("Solignac-sur-Loire"),43370,1210,1058,50,24.0,3.88333,44.9667,655,1115),
(43,new String'("Espaly-Saint-Marcel"),43000,3548,3553,564,6.29,3.86667,45.05,618,892),
(43,new String'("Freycenet-la-Cuche"),43150,137,144,8,16.25,4.1,44.8833,1034,1524),
(43,new String'("Raucoules"),43290,891,751,42,21.01,4.3,45.1833,630,915),
(43,new String'("Chanaleilles"),43170,207,228,4,48.52,3.5,44.8667,1077,1486),
(43,new String'("Saint-Austremoine"),43380,50,58,4,11.55,3.38333,45.1167,527,1044),
(43,new String'("Chaudeyrolles"),43430,102,108,5,18.9,4.25,44.95,1124,1720),
(43,new String'("Cussac-sur-Loire"),43370,1688,1376,164,10.27,3.87111,44.99,647,1069),
(43,new String'("Chavaniac-Lafayette"),43230,280,288,33,8.41,3.58333,45.15,620,1046),
(43,new String'("Fay-sur-Lignon"),43430,419,399,31,13.24,4.23333,44.9833,1079,1380),
(43,new String'("Le Bouchet-Saint-Nicolas"),43510,241,236,12,19.31,3.78333,44.8833,1118,1301),
(43,new String'("Présailles"),43150,152,161,6,22.23,4.03333,44.9,960,1283),
(43,new String'("Cistrières"),43160,136,139,6,21.89,3.61667,45.3167,711,1155),
(43,new String'("Saint-Étienne-sur-Blesle"),43450,51,52,2,17.65,3.13333,45.3167,554,1004),
(43,new String'("Chambezon"),43410,88,94,17,5.09,3.23333,45.3833,433,720),
(43,new String'("Lubilhac"),43100,107,133,4,24.09,3.25,45.25,565,996),
(43,new String'("Saint-Georges-d'Aurac"),43230,452,412,25,17.42,3.53333,45.15,557,911),
(43,new String'("Auzon"),43390,925,816,54,16.96,3.38333,45.3833,400,755),
(43,new String'("Chaspinhac"),43700,725,540,44,16.44,3.95,45.0833,572,937),
(43,new String'("Saint-Privat-du-Dragon"),43380,164,186,7,21.66,3.46667,45.1833,449,780),
(43,new String'("Langeac"),43300,3978,4072,117,33.94,3.48333,45.1,488,951),
(43,new String'("Mazeyrat-d'Allier"),43300,1546,1228,34,44.95,3.52806,45.1209,481,1000),
(43,new String'("Ferrussac"),43300,85,92,4,17.08,3.41667,45.1,585,1057),
(43,new String'("Saint-Beauzire"),43100,332,272,14,23.46,3.2675,45.275,553,891),
(43,new String'("Arlempdes"),43490,132,114,9,13.74,3.91667,44.8667,769,1166),
(43,new String'("Tailhac"),43300,81,74,6,12.52,3.46667,45.05,575,1067),
(43,new String'("Beaux"),43200,794,653,47,16.78,4.1,45.1833,475,920),
(43,new String'("Bains"),43370,1270,1028,33,37.56,3.76667,45.0167,878,1332),
(43,new String'("Aurec-sur-Loire"),43110,5614,4894,250,22.44,4.2,45.3667,414,821),
(43,new String'("Le Monastier-sur-Gazeille"),43150,1767,1728,44,39.39,3.99528,44.9392,752,1283),
(43,new String'("Roche-en-Régnier"),43130,491,389,18,26.92,3.93333,45.2167,504,1076),
(43,new String'("Berbezit"),43160,59,59,5,10.39,3.6,45.2833,712,1163),
(43,new String'("Chilhac"),43380,197,185,47,4.11,3.45,45.15,468,780),
(43,new String'("Saint-Germain-Laprade"),43700,3413,2991,121,28.09,3.96667,45.0333,601,920),
(43,new String'("Araules"),43200,623,607,20,31.1,4.16667,45.0833,920,1386),
(43,new String'("Cubelles"),43170,136,126,11,12.13,3.58333,45.0,640,1054),
(43,new String'("Saint-Étienne-du-Vigan"),43420,112,110,11,9.43,3.83333,44.7833,872,1164),
(43,new String'("Saint-Vénérand"),43580,55,52,5,9.68,3.66667,44.8667,660,1099),
(43,new String'("Saugues"),43170,1873,2015,23,78.8,3.55,44.9667,661,1483),
(43,new String'("Ceyssac"),43000,398,405,36,10.86,3.81667,45.0333,657,897),
(43,new String'("Pinols"),43300,227,267,6,34.92,3.41667,45.05,706,1428),
(43,new String'("Sainte-Eugénie-de-Villeneuve"),43230,93,109,15,6.11,3.61667,45.1333,829,1129),
(43,new String'("Lissac"),43350,260,239,21,12.03,3.76667,45.1333,791,908),
(43,new String'("Barges"),43340,70,73,9,7.02,3.9,44.8333,945,1258),
(43,new String'("Riotord"),43220,1197,1155,23,51.88,4.4,45.2333,791,1369),
(43,new String'("Croisances"),43580,35,40,4,7.37,3.6,44.9,867,1151),
(43,new String'("Alleyrac"),43150,123,118,10,11.34,3.96667,44.8833,1025,1283),
(43,new String'("Saint-Maurice-de-Lignon"),43200,2402,1800,79,30.23,4.15,45.2167,461,892),
(43,new String'("Lafarre"),43490,63,72,4,13.02,3.98973,44.8423,823,1192),
(43,new String'("Bellevue-la-Montagne"),43350,468,476,14,32.74,3.81667,45.2167,600,1061),
(43,new String'("Bournoncle-Saint-Pierre"),43360,1008,953,62,16.16,3.31667,45.3333,419,614),
(43,new String'("Aiguilhe"),43000,1585,1552,1440,1.1,3.88473,45.0509,609,751),
(43,new String'("Villettes"),43600,1204,853,102,11.78,4.18333,45.2333,505,794),
(43,new String'("Frugerès-les-Mines"),43250,510,499,472,1.08,3.31667,45.3833,414,480),
(43,new String'("Montfaucon-en-Velay"),43290,1277,1207,255,4.99,4.31362,45.185,875,969),
(43,new String'("Saint-Hilaire"),43390,183,190,12,14.64,3.43899,45.3807,519,884),
(43,new String'("La Chapelle-Bertin"),43270,58,72,5,11.29,3.65,45.2167,680,1136),
(43,new String'("Saint-Jean-d'Aubrigoux"),43500,187,185,10,17.8,3.81667,45.35,880,1191),
(43,new String'("Charraix"),43300,95,82,10,9.46,3.56667,45.0333,720,1030),
(43,new String'("Auvers"),43300,62,67,2,21.5,3.41667,45.0,756,1496),
(43,new String'("Lavoûte-sur-Loire"),43800,760,692,74,10.16,3.9,45.1167,554,900),
(43,new String'("Saint-Christophe-sur-Dolaison"),43370,954,907,34,27.34,3.81667,45.0,763,1069),
(43,new String'("Mazet-Saint-Voy"),43520,1150,1032,25,45.02,4.23333,45.05,875,1283),
(43,new String'("Saint-Didier-sur-Doulon"),43440,211,222,6,34.14,3.55,45.3,550,1089),
(43,new String'("Vernassal"),43270,393,332,20,19.23,3.7,45.15,850,1163),
(43,new String'("Vielprat"),43490,63,66,8,7.24,3.95,44.85,791,1112),
(43,new String'("Le Mas-de-Tence"),43190,175,150,13,12.83,4.36667,45.1167,936,1153),
(43,new String'("Lapte"),43200,1502,1252,48,30.75,4.21667,45.1833,600,914),
(43,new String'("Dunières"),43220,2934,2945,84,34.75,4.33333,45.2167,711,1033),
(43,new String'("Chamalières-sur-Loire"),43800,465,408,34,13.4,3.98333,45.2,495,984),
(43,new String'("Saint-Étienne-Lardeyrol"),43260,695,611,58,11.8,4.0,45.0667,669,1033),
(43,new String'("Vézézoux"),43390,517,405,72,7.13,3.35,45.4,393,638),
(43,new String'("Fix-Saint-Geneys"),43320,139,139,17,7.91,3.66667,45.1333,951,1195),
(43,new String'("Javaugues"),43100,197,156,28,6.98,3.48333,45.2833,459,798),
(43,new String'("Le Monteil"),43700,604,538,272,2.22,3.91473,45.0656,586,786),
(43,new String'("Saint-Laurent-Chabreuges"),43100,233,243,28,8.27,3.35,45.2833,477,683),
(43,new String'("Chaniat"),43100,166,134,11,13.93,3.48333,45.3167,454,869),
(43,new String'("Coubon"),43700,3063,2708,134,22.73,3.91667,45.0,607,948),
(43,new String'("Saint-Georges-Lagricol"),43500,498,411,25,19.17,3.88611,45.2981,743,963),
(43,new String'("Salzuit"),43230,361,341,44,8.05,3.5,45.2167,514,768),
(43,new String'("Saint-Didier-d'Allier"),43580,34,43,4,7.71,3.68333,44.9667,622,1214),
(43,new String'("Saint-Jean-Lachalm"),43510,285,281,8,34.64,3.71667,44.9667,634,1417),
(43,new String'("Chanteuges"),43300,424,403,25,16.33,3.55,45.0667,493,894),
(43,new String'("Domeyrat"),43230,192,145,20,9.57,3.51667,45.25,472,752),
(43,new String'("La Chapelle-d'Aurec"),43120,902,626,76,11.79,4.2,45.3333,422,796),
(43,new String'("Vastres"),43430,212,222,6,30.34,4.26112,44.9892,777,1215),
(43,new String'("Agnat"),43100,190,209,9,19.65,3.46667,45.35,445,860),
(43,new String'("Arsac-en-Velay"),43700,1179,915,97,12.15,3.95,44.9833,620,958),
(43,new String'("Sainte-Sigolène"),43600,5913,5435,192,30.64,4.25,45.2333,560,854),
(43,new String'("Le Pertuis"),43200,423,374,35,11.89,4.05,45.1,879,1255),
(43,new String'("Le Puy-en-Velay"),43000,18521,20489,1103,16.79,3.88583,45.0442,600,888),
(43,new String'("Saint-Bérain"),43300,96,118,7,13.0,3.63333,45.0333,551,1301),
(43,new String'("Saint-André-de-Chalencon"),43130,340,279,19,17.2,4.0,45.2833,549,969),
(43,new String'("Montregard"),43290,607,593,15,39.93,4.35,45.15,859,1142),
(43,new String'("Saint-Arcons-de-Barges"),43420,115,118,7,15.38,3.93333,44.8333,825,1342),
(43,new String'("Chenereilles"),43190,301,244,20,14.42,4.23333,45.1333,806,956),
(43,new String'("Queyrières"),43260,310,285,22,13.95,4.1,45.0667,949,1436),
(43,new String'("Jax"),43230,134,132,11,11.93,3.61667,45.1667,646,1150),
(43,new String'("Saint-Hostien"),43260,684,578,50,13.49,4.05,45.0667,747,1204),
(43,new String'("Chastel"),43300,145,161,5,27.69,3.31667,45.0833,711,1359),
(43,new String'("Chadrac"),43770,2671,3010,1077,2.48,3.9,45.0667,577,730),
(43,new String'("Estables"),43150,344,327,10,33.94,4.15,44.9083,1033,1725),
(43,new String'("Chaspuzac"),43320,687,521,70,9.77,3.73333,45.0667,818,964),
(43,new String'("Grèzes"),43170,213,257,5,35.79,3.5,44.9167,1017,1484),
(43,new String'("Saint-Pierre-du-Champ"),43810,489,518,15,31.09,3.89945,45.2478,631,963),
(43,new String'("Saint-Pal-de-Chalencon"),43500,1018,1045,35,28.95,3.95695,45.3567,700,978),
(43,new String'("Saint-Romain-Lachalm"),43620,1074,829,56,19.02,4.33333,45.2667,757,1008),
(43,new String'("Espalem"),43450,287,228,19,14.62,3.25,45.3167,580,739),
(43,new String'("Costaros"),43490,620,549,161,3.85,3.83333,44.9,1031,1215),
(43,new String'("Sainte-Marguerite"),43230,37,37,6,5.39,3.58333,45.2,590,889),
(43,new String'("Saint-Vincent"),43800,978,831,47,20.4,3.90945,45.1442,528,932),
(43,new String'("La Chomette"),43230,140,131,20,6.9,3.48333,45.2333,573,743),
(43,new String'("Laval-sur-Doulon"),43440,62,60,5,12.28,3.58333,45.35,642,1110),
(43,new String'("Chassagnes"),43230,178,129,14,12.24,3.55,45.2167,529,871),
(43,new String'("Pont-Salomon"),43330,1870,1661,221,8.43,4.25,45.3333,552,803),
(43,new String'("Craponne-sur-Arzon"),43500,2164,2651,64,33.37,3.85,45.3333,771,1063),
(43,new String'("Félines"),43160,283,322,13,20.5,3.75,45.2667,958,1122),
(43,new String'("Aubazat"),43380,188,172,11,16.38,3.45,45.1333,464,848),
(43,new String'("Saint-Géron"),43360,233,178,21,10.76,3.28333,45.3333,437,674),
(43,new String'("Bessamorel"),43200,409,329,55,7.37,4.08723,45.1206,760,1137),
(43,new String'("Saint-Didier-en-Velay"),43140,3367,2890,131,25.56,4.28333,45.3,640,924),
(43,new String'("Cayres"),43510,708,613,24,29.22,3.8,44.9167,971,1382),
(43,new String'("Ouides"),43510,55,60,5,10.69,3.73333,44.9,798,1286),
(43,new String'("Séneujols"),43510,304,270,24,12.24,3.78333,44.9667,985,1417),
(43,new String'("Saint-Vidal"),43320,521,354,67,7.71,3.78333,45.0667,682,924),
(43,new String'("Cohade"),43100,823,653,82,9.99,3.38333,45.3333,405,459),
(43,new String'("Varennes-Saint-Honorat"),43270,34,39,2,11.91,3.63333,45.1833,720,1174),
(43,new String'("Saint-Victor-sur-Arlanc"),43500,106,107,8,11.88,3.78333,45.3333,659,1044),
(43,new String'("Chazelles"),43300,34,34,6,4.9,3.48806,45.0192,626,1013),
(43,new String'("Salettes"),43150,148,129,7,20.28,3.96528,44.8634,786,1181),
(43,new String'("Saint-Cirgues"),43380,161,147,11,13.62,3.41667,45.15,459,1033),
(43,new String'("Cerzat"),43380,194,196,18,10.41,3.48333,45.1667,475,747),
(43,new String'("Saint-Ilpize"),43380,176,205,14,11.81,3.4,45.2,432,763),
(43,new String'("Lamothe"),43100,824,717,67,12.24,3.42445,45.3131,417,645),
(43,new String'("Cronce"),43300,81,100,5,16.15,3.36667,45.1,623,1173),
(43,new String'("Montclard"),43230,62,65,6,9.58,3.56667,45.2667,640,1204),
(43,new String'("Esplantas"),43170,101,95,9,10.4,3.56667,44.9,962,1142),
(43,new String'("Arlet"),43380,23,20,3,5.78,3.43333,45.1167,545,933),
(43,new String'("Monlet"),43270,416,377,11,35.7,3.71667,45.2167,859,1172),
(43,new String'("Yssingeaux"),43200,7009,6498,86,80.57,4.11667,45.1333,589,1320),
(43,new String'("Malvalette"),43210,732,422,34,21.01,4.15,45.35,418,846),
(43,new String'("Paulhaguet"),43230,940,981,83,11.23,3.53333,45.2,494,689),
(43,new String'("Blesle"),43450,634,660,21,29.8,3.18333,45.3167,472,875),
(43,new String'("Alleyras"),43580,173,231,6,24.86,3.68333,44.9,634,1074),
(43,new String'("Saint-Just-Malmont"),43240,4126,3957,177,23.28,4.31667,45.3333,520,934),
(43,new String'("Freycenet-la-Tour"),43150,129,146,16,7.93,4.06667,44.9333,964,1244),
(43,new String'("Brives-Charensac"),43700,4231,4354,868,4.87,3.93333,45.05,598,838),
(43,new String'("Retournac"),43130,2714,2216,59,45.76,4.03333,45.2,479,1064),
(43,new String'("La Chaise-Dieu"),43160,722,769,53,13.58,3.7,45.3167,916,1120),
(43,new String'("Connangles"),43160,137,129,6,21.89,3.65,45.3,873,1145),
(43,new String'("Vals-près-le-Puy"),43750,3518,3393,687,5.12,3.86667,45.0167,632,920),
(43,new String'("Beaune-sur-Arzon"),43500,209,189,14,14.38,3.81667,45.2833,885,1073),
(43,new String'("Villeneuve-d'Allier"),43380,329,303,22,14.31,3.4,45.2,436,902),
(43,new String'("Collat"),43230,85,80,8,10.22,3.61667,45.25,687,1191),
(43,new String'("Champagnac-le-Vieux"),43440,232,277,11,20.61,3.5,45.35,640,980),
(43,new String'("Vals-le-Chastel"),43230,46,46,11,3.99,3.53333,45.2667,507,777),
(43,new String'("Saint-Ferréol-d'Auroure"),43330,2390,2047,220,10.85,4.25,45.35,457,818),
(43,new String'("Jullianges"),43500,439,380,23,18.44,3.78333,45.3,838,1089),
(43,new String'("Le Vernet"),43320,31,39,8,3.82,3.66667,45.0333,1070,1301),
(43,new String'("Céaux-d'Allègre"),43270,462,411,14,32.41,3.73333,45.1667,834,1144),
(43,new String'("Mercœur"),43100,136,150,4,27.51,3.29335,45.1918,600,1009),
(43,new String'("Saint-Privat-d'Allier"),43580,401,414,13,29.96,3.68333,44.9833,547,1221),
(43,new String'("Saint-Haon"),43340,347,370,9,37.57,3.75,44.85,689,1240),
(43,new String'("Montusclat"),43260,130,123,12,10.47,4.13333,45.0167,832,1328),
(43,new String'("Rosières"),43800,1431,1309,53,26.82,3.98333,45.1333,594,1072),
(43,new String'("Thoras"),43170,216,270,5,37.56,3.56667,44.8667,960,1371),
(43,new String'("Vergongheon"),43360,1838,1608,145,12.61,3.33333,45.3667,403,483),
(43,new String'("Saint-Just-près-Brioude"),43100,425,391,9,46.94,3.36667,45.2333,513,941),
(43,new String'("Saint-Christophe-d'Allier"),43340,105,140,5,19.3,3.70445,44.8556,689,1133),
(43,new String'("Saint-Préjet-Armandon"),43230,107,93,12,8.47,3.55,45.25,506,853),
(43,new String'("Malrevers"),43800,720,691,51,14.09,3.95,45.1,591,920),
(43,new String'("Malvières"),43160,134,103,9,13.72,3.73333,45.3333,668,1074),
(43,new String'("Lavaudieu"),43100,224,225,12,17.54,3.46667,45.2667,438,727),
(43,new String'("Pradelles"),43420,613,584,35,17.48,3.88223,44.7695,880,1302),
(43,new String'("Rauret"),43340,178,139,8,20.75,3.78333,44.8167,775,1204),
(43,new String'("Saint-Pal-de-Senouire"),43160,101,118,5,18.35,3.65,45.2667,789,1204),
(43,new String'("Saint-Victor-Malescours"),43140,790,673,54,14.47,4.31667,45.2833,753,931),
(43,new String'("Mazerat-Aurouze"),43230,200,198,12,16.35,3.56667,45.1833,534,968),
(44,new String'("Saint-Vincent-des-Landes"),44590,1462,1323,43,33.7,-1.5,47.65,25,77),
(44,new String'("Corcoué-sur-Logne"),44650,2553,1990,50,50.39,0.423057,46.9656,10,69),
(44,new String'("Indre"),44610,4006,3641,848,4.72,0.32889,47.1987,0,26),
(44,new String'("Saint-Malo-de-Guersac"),44550,3212,3126,219,14.62,-2.16667,47.35,0,13),
(44,new String'("Maisdon-sur-Sèvre"),44690,2636,2054,151,17.45,-1.38333,47.1,3,63),
(44,new String'("Piriac-sur-Mer"),44420,2209,1900,178,12.37,-2.55,47.3833,0,36),
(44,new String'("Le Landreau"),44430,2876,2139,119,23.98,-1.3,47.2,3,96),
(44,new String'("Mouzeil"),44850,1783,1213,94,18.87,-1.35,47.45,9,54),
(44,new String'("Sainte-Pazanne"),44680,5437,3448,130,41.56,-1.81667,47.1,0,41),
(44,new String'("Joué-sur-Erdre"),44440,2163,1690,39,54.53,-1.41667,47.5,7,66),
(44,new String'("Guenrouet"),44530,3007,2408,43,69.9,-1.95,47.5167,0,73),
(44,new String'("Brains"),44830,2584,2172,168,15.31,-1.71667,47.1667,0,34),
(44,new String'("Erbray"),44110,2940,2349,50,58.18,-1.31667,47.65,41,108),
(44,new String'("Carquefou"),44470,17805,15369,410,43.42,-1.5,47.3,1,76),
(44,new String'("Saint-Herblain"),44800,43153,43728,1437,30.02,-1.65,47.2167,1,64),
(44,new String'("Oudon"),44521,3355,2617,151,22.12,-1.28333,47.35,2,74),
(44,new String'("Treffieux"),44170,786,618,41,19.12,-1.53333,47.6167,19,54),
(44,new String'("Saint-Viaud"),44320,2116,1840,64,32.63,-2.01667,47.25,0,51),
(44,new String'("Saint-Même-le-Tenu"),44270,1152,928,63,18.27,-1.78333,47.0167,0,39),
(44,new String'("Vallet"),44330,8425,6807,142,58.96,-1.26667,47.1667,6,98),
(44,new String'("La Marne"),44270,1364,917,76,17.8,-1.73333,47.0,3,39),
(44,new String'("Saint-Père-en-Retz"),44320,4135,3457,65,62.72,-2.03333,47.2,0,62),
(44,new String'("Fay-de-Bretagne"),44130,3230,2491,49,64.81,-1.8,47.4167,18,87),
(44,new String'("Juigné-des-Moutiers"),44670,353,322,14,24.65,-1.18333,47.6833,52,102),
(44,new String'("Saint-Hilaire-de-Clisson"),44190,2019,1474,109,18.43,-1.31667,47.0667,22,54),
(44,new String'("Boussay"),44190,2684,2361,101,26.45,-1.18333,47.05,27,111),
(44,new String'("Donges"),44480,6748,6156,139,48.5,-2.06667,47.3,0,31),
(44,new String'("Missillac"),44780,4843,3808,81,59.55,-2.16667,47.4833,0,63),
(44,new String'("Teillé"),44440,1740,1299,60,28.55,0.720279,47.4617,17,64),
(44,new String'("La Chapelle-Saint-Sauveur"),44370,780,627,41,18.7,-0.983333,47.4333,32,76),
(44,new String'("Blain"),44130,9434,7731,92,101.72,-1.75,47.4833,7,44),
(44,new String'("Couffé"),44521,2290,1790,57,39.97,-1.28333,47.4,7,73),
(44,new String'("Pornic"),44210,14101,11891,149,94.18,-2.1,47.1167,0,60),
(44,new String'("La Planche"),44140,2382,2074,97,24.42,-1.43333,47.0167,13,52),
(44,new String'("Pannecé"),44440,1349,911,44,30.59,-1.23333,47.4833,22,79),
(44,new String'("La Turballe"),44420,4582,4042,247,18.53,-2.51667,47.35,0,45),
(44,new String'("Petit-Auverné"),44670,433,386,19,22.53,-1.28333,47.6167,37,81),
(44,new String'("La Remaudière"),44430,1140,816,87,12.98,-1.25,47.2333,38,101),
(44,new String'("Remouillé"),44140,1695,1443,79,21.38,-1.36667,47.05,17,61),
(44,new String'("Paimbœuf"),44560,3206,2762,1603,2.0,-2.03333,47.2833,0,11),
(44,new String'("Montrelais"),44370,822,664,59,13.73,-0.966667,47.3833,7,62),
(44,new String'("Corsept"),44560,2742,1965,116,23.62,-2.05,47.2833,0,26),
(44,new String'("Sucé-sur-Erdre"),44240,6258,5868,151,41.33,0.470557,47.3448,2,47),
(44,new String'("Le Fresne-sur-Loire"),49123,982,699,156,6.29,-0.928333,47.4009,7,61),
(44,new String'("Saint-Lyphard"),44410,4326,3180,175,24.63,-2.3,47.4,0,23),
(44,new String'("La Chapelle-Glain"),44670,822,761,23,34.5,-1.2,47.6167,46,99),
(44,new String'("Prinquiau"),44260,3103,2053,135,22.82,-2.0,47.3667,0,70),
(44,new String'("La Rouxière"),44370,1014,877,48,20.96,-1.06667,47.45,23,78),
(44,new String'("Grandchamps-des-Fontaines"),44119,4837,3464,142,33.87,0.394723,47.365,8,70),
(44,new String'("Malville"),44260,3161,2974,101,31.24,-1.86667,47.3667,1,89),
(44,new String'("Le Pouliguen"),44510,4979,5265,1134,4.39,-2.43333,47.2667,0,23),
(44,new String'("Avessac"),44460,2437,2154,31,76.49,-1.98333,47.65,0,81),
(44,new String'("Saint-Herblon"),44150,2407,1842,65,36.9,-1.1,47.4167,5,80),
(44,new String'("Montoir-de-Bretagne"),44550,6793,6194,184,36.79,-2.15,47.3333,0,15),
(44,new String'("Basse-Goulaine"),44115,8091,7504,588,13.74,-1.43333,47.2167,1,44),
(44,new String'("Trans-sur-Erdre"),44440,970,680,42,22.56,-1.36667,47.4833,17,57),
(44,new String'("Le Loroux-Bottereau"),44430,7052,4936,155,45.31,-1.35,47.25,2,93),
(44,new String'("Saint-Michel-Chef-Chef"),44730,4435,3176,176,25.12,-2.15,47.1833,0,57),
(44,new String'("Trignac"),44570,7264,6952,505,14.38,-2.18333,47.3167,0,10),
(44,new String'("Touches"),44390,2268,1948,64,35.15,-1.425,47.4417,3,52),
(44,new String'("Thouaré-sur-Loire"),44470,7674,6660,601,12.76,-1.45,47.2667,1,73),
(44,new String'("Saint-André-des-Eaux"),44117,5336,3532,215,24.71,-2.31667,47.3167,0,41),
(44,new String'("Bouguenais"),44340,18194,15631,577,31.5,-1.61667,47.1833,1,41),
(44,new String'("Sorinières"),44840,7444,6229,571,13.02,-1.53333,47.15,3,44),
(44,new String'("Sion-les-Mines"),44590,1678,1367,30,54.71,-1.58333,47.7333,17,88),
(44,new String'("Puceul"),44390,960,631,47,20.09,-1.61667,47.5167,26,82),
(44,new String'("Saint-Géréon"),44150,2692,2488,358,7.51,-1.2,47.3667,6,51),
(44,new String'("Saint-Sébastien-sur-Loire"),44230,25017,25223,2145,11.66,-1.5,47.2167,2,33),
(44,new String'("Assérac"),44410,1789,1361,54,32.91,-2.38333,47.4333,0,49),
(44,new String'("Savenay"),44260,7565,5890,290,26.0,-1.95,47.3667,0,86),
(44,new String'("La Chevrolière"),44118,5017,4851,154,32.56,-1.61667,47.1,0,22),
(44,new String'("Le Cellier"),44850,3713,3449,103,35.99,-1.35,47.3167,2,85),
(44,new String'("Paulx"),44270,1909,1355,53,35.92,-1.75,46.9667,4,51),
(44,new String'("Grand-Auverné"),44520,805,681,23,34.4,-1.33333,47.6,37,88),
(44,new String'("Villepot"),44110,653,668,31,20.59,-1.28333,47.7833,66,116),
(44,new String'("Saint-Jean-de-Boiseau"),44640,5131,4563,450,11.4,-1.71667,47.2,0,34),
(44,new String'("Herbignac"),44410,5817,4350,81,71.43,-2.31667,47.45,0,55),
(44,new String'("Saint-Fiacre-sur-Maine"),44690,1194,996,200,5.97,-1.41667,47.15,2,49),
(44,new String'("La Chapelle-Basse-Mer"),44450,5195,4271,234,22.14,-1.33333,47.2667,1,79),
(44,new String'("Préfailles"),44770,1256,1038,257,4.88,-2.21667,47.1333,0,36),
(44,new String'("Quilly"),44750,1280,905,72,17.67,-1.95,47.4667,1,37),
(44,new String'("Saint-Léger-les-Vignes"),44710,1518,1158,233,6.49,-1.73333,47.1333,0,29),
(44,new String'("Gorges"),44190,4189,2650,265,15.77,-1.3,47.1,5,49),
(44,new String'("Guémené-Penfao"),44290,5035,4569,47,105.51,-1.83333,47.6333,2,83),
(44,new String'("Fercé"),44660,485,517,22,22.04,-1.41667,47.8,42,117),
(44,new String'("Pont-Saint-Martin"),44860,5684,4756,259,21.88,-1.58333,47.1167,0,31),
(44,new String'("La Chevallerais"),44810,1377,652,134,10.23,-1.66667,47.4667,18,42),
(44,new String'("Casson"),44390,2089,1319,129,16.15,-1.55,47.3833,3,46),
(44,new String'("Bonnœuvre"),44540,561,505,35,15.66,-1.23333,47.5333,22,78),
(44,new String'("Saint-Mars-du-Désert"),44850,4027,3407,132,30.46,-1.4,47.3667,3,77),
(44,new String'("Treillières"),44119,7965,6030,274,29.05,-1.63333,47.3333,9,74),
(44,new String'("Mouzillon"),44330,2594,1759,157,16.5,-1.28333,47.15,9,78),
(44,new String'("Saint-Sulpice-des-Landes"),44540,650,607,21,30.78,0.79389,47.5748,44,86),
(44,new String'("Bourgneuf-en-Retz"),44580,3408,2400,64,53.19,-1.95,47.05,0,39),
(44,new String'("La Montagne"),44620,5985,5847,1644,3.64,-1.68333,47.1833,2,38),
(44,new String'("Vay"),44170,1940,1227,53,36.13,-1.7,47.55,21,96),
(44,new String'("Sévérac"),44530,1557,1192,69,22.41,-2.08333,47.5333,0,71),
(44,new String'("Couëron"),44220,18591,17821,422,44.03,-1.73333,47.2167,0,74),
(44,new String'("Cordemais"),44360,2983,2518,80,37.15,-1.88333,47.2833,0,91),
(44,new String'("Drefféac"),44530,1843,1322,130,14.16,-2.06667,47.4667,0,33),
(44,new String'("Orvault"),44700,24504,23550,885,27.67,-1.61667,47.2667,7,74),
(44,new String'("Arthon-en-Retz"),44320,3761,2668,95,39.24,-1.95,47.1167,1,61),
(44,new String'("Soudan"),44110,2013,2007,37,53.82,-1.3,47.7333,57,111),
(44,new String'("Geneston"),44140,3524,2214,438,8.04,0.487223,47.0556,14,39),
(44,new String'("La Limouzinière"),44310,2139,1407,72,29.54,-1.6,46.9833,8,50),
(44,new String'("Bouvron"),44130,2863,2408,60,47.63,-1.85,47.4167,11,82),
(44,new String'("Mesquer"),44420,1727,1473,103,16.72,-2.45,47.4,0,34),
(44,new String'("Derval"),44590,3246,2489,51,63.51,-1.66667,47.6667,8,77),
(44,new String'("Le Gâvre"),44130,1557,945,29,53.58,-1.75,47.5167,22,62),
(44,new String'("Ruffigné"),44660,719,602,21,33.63,-1.5,47.75,33,98),
(44,new String'("Sautron"),44880,6901,6818,399,17.28,-1.66667,47.2667,25,80),
(44,new String'("Clisson"),44190,6732,5932,595,11.3,-1.28333,47.0833,7,71),
(44,new String'("Machecoul"),44270,5914,5424,88,66.62,-1.81667,47.0,0,36),
(44,new String'("Pouillé-les-Côteaux"),44522,873,702,74,11.72,-1.16667,47.45,18,76),
(44,new String'("Château-Thébaud"),44690,2862,2474,162,17.64,0.580279,47.125,2,60),
(44,new String'("Ligné"),44850,4592,2948,101,45.41,-1.38333,47.4167,12,72),
(44,new String'("La Grigonnais"),44170,1548,1101,72,21.22,-1.66667,47.5333,20,82),
(44,new String'("Vue"),44640,1415,996,72,19.51,-1.88333,47.2,0,60),
(44,new String'("La Chapelle-des-Marais"),44410,3772,2952,208,18.05,-2.25,47.45,0,11),
(44,new String'("Pontchâteau"),44160,9683,7770,173,55.79,-2.08333,47.4333,0,52),
(44,new String'("Saint-Étienne-de-Montluc"),44360,6611,6228,114,57.57,-1.78333,47.2667,0,89),
(44,new String'("Rouans"),44640,2663,2131,70,37.73,-1.86667,47.1833,0,60),
(44,new String'("Frossay"),44320,2977,2110,52,57.22,-1.93333,47.25,0,47),
(44,new String'("Notre-Dame-des-Landes"),44130,1970,1650,52,37.4,-1.7,47.3833,29,82),
(44,new String'("Monnières"),44690,1932,1543,197,9.78,-1.35,47.1333,2,61),
(44,new String'("Saint-Julien-de-Concelles"),44450,6820,6255,214,31.74,-1.38333,47.25,0,53),
(44,new String'("Pornichet"),44380,10451,9689,824,12.67,-2.35,47.25,0,44),
(44,new String'("Lège"),44650,4290,3588,67,63.32,-1.6,46.8833,18,74),
(44,new String'("Chauvé"),44320,2515,1702,61,40.98,-1.98333,47.15,0,62),
(44,new String'("Saint-Lumine-de-Coutais"),44310,1891,1333,107,17.64,-1.71667,47.05,1,48),
(44,new String'("Vieillevigne"),44116,3905,3263,75,51.76,-1.43333,46.9667,21,66),
(44,new String'("Riaillé"),44440,2127,1722,42,50.02,-1.28333,47.5167,17,88),
(44,new String'("Moutiers-en-Retz"),44760,1316,908,137,9.58,1.99834,47.0634,0,39),
(44,new String'("Saint-Julien-de-Vouvantes"),44670,924,879,36,25.6,-1.23333,47.65,47,99),
(44,new String'("Saint-Hilaire-de-Chaléons"),44680,1967,1551,56,34.98,-1.86667,47.1,1,32),
(44,new String'("Saint-Gildas-des-Bois"),44530,3454,3062,103,33.42,-2.03333,47.5167,1,74),
(44,new String'("La Chapelle-Heulin"),44330,3045,1859,226,13.47,-1.33333,47.1833,2,37),
(44,new String'("Sainte-Reine-de-Bretagne"),44160,2135,1682,108,19.73,-2.18333,47.4333,0,37),
(44,new String'("Petit-Mars"),44390,3462,2438,133,25.97,-1.45,47.4,2,43),
(44,new String'("Vertou"),44120,21443,20261,600,35.68,-1.48333,47.1667,1,56),
(44,new String'("La Meilleraye-de-Bretagne"),44520,1345,1028,48,27.63,-1.4,47.55,29,91),
(44,new String'("Nantes"),44000,284970,270343,4371,65.19,-1.55,47.2167,2,52),
(44,new String'("Rougé"),44660,2253,2141,40,56.32,-1.45,47.7833,39,109),
(44,new String'("Sainte-Luce-sur-Loire"),44980,11907,11263,1039,11.45,-1.5,47.25,2,36),
(44,new String'("Saint-Molf"),44350,2324,1500,101,22.82,-2.41667,47.3833,0,30),
(44,new String'("Saint-Aignan-Grandlieu"),44860,3506,3478,195,17.94,0.369445,47.1239,0,29),
(44,new String'("Mésanger"),44522,4394,3135,88,49.75,-1.23333,47.4333,7,76),
(44,new String'("Batz-sur-Mer"),44740,3071,3051,331,9.27,-2.48333,47.2833,0,21),
(44,new String'("Moisdon-la-Rivière"),44520,1920,1734,38,50.43,-1.36667,47.6167,28,79),
(44,new String'("Cheix-en-Retz"),44640,844,530,101,8.34,-1.81667,47.1833,0,27),
(44,new String'("Le Croisic"),44490,4050,4267,900,4.5,-2.51667,47.3,0,20),
(44,new String'("Rezé"),44400,38425,35518,2788,13.78,-1.56667,47.2,1,42),
(44,new String'("Saint-Nicolas-de-Redon"),44460,3109,2802,139,22.32,-2.06667,47.65,0,73),
(44,new String'("Châteaubriant"),44110,12022,12065,357,33.62,-1.38333,47.7167,48,107),
(44,new String'("Saint-Philbert-de-Grand-Lieu"),44310,8061,6251,137,58.81,-1.63333,47.0333,0,51),
(44,new String'("Chéméré"),44680,2259,1585,60,37.31,-1.91667,47.1167,2,60),
(44,new String'("Pierric"),44290,943,783,34,27.3,-1.73333,47.6833,2,78),
(44,new String'("Aigrefeuille-sur-Maine"),44140,3320,2152,227,14.58,-1.4,47.0667,2,56),
(44,new String'("La Boissière-du-Doré"),44430,913,673,97,9.41,0.780001,47.232,50,106),
(44,new String'("Jans"),44170,1098,991,33,33.21,-1.61667,47.6167,13,56),
(44,new String'("Héric"),44810,5276,3990,71,73.93,-1.65,47.4167,17,66),
(44,new String'("Plessé"),44630,4631,3414,44,104.38,-1.88333,47.5333,1,66),
(44,new String'("Barbechat"),44450,1284,1061,109,11.76,-1.28333,47.2833,7,84),
(44,new String'("Anetz"),44150,1910,1368,128,14.83,-1.1,47.3833,7,32),
(44,new String'("Bouaye"),44830,5958,5252,430,13.83,-1.7,47.15,0,34),
(44,new String'("Saint-Étienne-de-Mer-Morte"),44270,1483,1003,54,27.33,-1.75,46.9333,9,47),
(44,new String'("Guérande"),44350,15534,13655,190,81.44,-2.43333,47.3333,0,60),
(44,new String'("La Bernerie-en-Retz"),44760,2564,2141,421,6.09,-2.03333,47.0833,0,47),
(44,new String'("Massérac"),44290,643,454,34,18.78,-1.91667,47.6667,0,55),
(44,new String'("Noyal-sur-Brutz"),44110,582,481,75,7.71,-1.33333,47.7833,64,112),
(44,new String'("Soulvache"),44660,397,402,35,11.27,-1.46667,47.8333,37,109),
(44,new String'("Lavau-sur-Loire"),44260,758,615,46,16.22,-1.96667,47.3,0,15),
(44,new String'("Sainte-Anne-sur-Brivet"),44160,2588,1925,99,25.99,1.99667,47.4598,0,37),
(44,new String'("Saint-Joachim"),44720,4046,3773,46,86.22,-2.2,47.3833,0,9),
(44,new String'("Saint-Colomban"),44310,3129,2028,87,35.72,0.41639,47.0089,2,37),
(44,new String'("La Roche-Blanche"),44522,1131,846,76,14.82,-1.13333,47.4333,7,84),
(44,new String'("Touvois"),44650,1627,1302,41,39.21,-1.68333,46.9,18,61),
(44,new String'("Lusanger"),44590,1019,947,28,35.38,-1.58333,47.6833,21,72),
(44,new String'("Ancenis"),44150,7551,7009,376,20.07,-1.16667,47.3667,5,41),
(44,new String'("Abbaretz"),44170,1916,1509,31,61.76,-1.53333,47.55,26,91),
(44,new String'("Saint-Lumine-de-Clisson"),44190,1959,1348,107,18.26,-1.33333,47.0833,2,61),
(44,new String'("Conquereuil"),44290,1046,955,31,32.87,-1.75,47.6167,7,57),
(44,new String'("Varades"),44370,3514,3193,76,45.82,-1.03333,47.3833,7,74),
(44,new String'("Nort-sur-Erdre"),44390,7781,5881,116,66.56,-1.5,47.4333,2,73),
(44,new String'("Saint-Brevin-les-Pins"),44250,12248,9608,634,19.29,-2.16667,47.25,0,39),
(44,new String'("Besné"),44160,2646,2029,150,17.54,-2.08333,47.4,0,16),
(44,new String'("La Plaine-sur-Mer"),44770,3835,2513,233,16.39,-2.16667,47.1333,0,38),
(44,new String'("Crossac"),44160,2739,2145,105,25.85,-2.16667,47.4167,0,22),
(44,new String'("Bouée"),44260,860,661,40,21.34,-1.91667,47.3167,0,28),
(44,new String'("Vigneux-de-Bretagne"),44360,5438,4712,99,54.68,-1.73333,47.3167,24,92),
(44,new String'("Le Temple-de-Bretagne"),44360,1850,1557,1156,1.6,-1.78333,47.3167,77,90),
(44,new String'("Saint-Mars-de-Coutais"),44680,2505,1859,72,34.67,-1.73333,47.1167,0,38),
(44,new String'("Mouais"),44590,388,259,39,9.93,-1.65,47.7,9,61),
(44,new String'("Gétigné"),44190,3397,3074,141,23.97,-1.25,47.0667,13,97),
(44,new String'("La Baule-Escoublac"),44500,16040,15833,722,22.19,-2.36667,47.3,1,55),
(44,new String'("Vritz"),49440,729,803,22,32.89,-1.06667,47.5833,35,92),
(44,new String'("Montbert"),44140,2976,2293,105,28.24,-1.5,47.05,7,51),
(44,new String'("Fégréac"),44460,2278,1994,51,44.18,-2.05,47.5833,0,62),
(44,new String'("Saint-Aubin-des-Châteaux"),44110,1615,1314,33,47.56,-1.48333,47.7167,32,92),
(44,new String'("Maumusson"),44540,1011,810,41,24.56,-1.1,47.4833,27,84),
(44,new String'("Le Pellerin"),44640,4382,3777,142,30.65,-1.75,47.2,0,27),
(44,new String'("Le Pallet"),44330,2948,2394,250,11.75,-1.33333,47.1333,2,52),
(44,new String'("La Regrippière"),44330,1544,1089,84,18.17,-1.18333,47.1833,42,101),
(44,new String'("Marsac-sur-Don"),44170,1447,1200,52,27.68,-1.66667,47.6,11,95),
(44,new String'("Mauves-sur-Loire"),44470,3033,2408,205,14.75,-1.4,47.3,1,84),
(44,new String'("La Chapelle-Launay"),44260,2778,2256,111,24.82,-1.96667,47.3667,0,77),
(44,new String'("Nozay"),44170,3835,3156,66,57.7,-1.63333,47.5667,13,96),
(44,new String'("Saffré"),44390,3537,2678,61,57.46,-1.56667,47.5,17,78),
(44,new String'("Issé"),44520,1827,1776,47,38.66,-1.45,47.6167,22,76),
(44,new String'("La Chapelle-sur-Erdre"),44240,17300,16387,517,33.42,-1.55,47.3,1,57),
(44,new String'("La Haie-Fouassière"),44690,4358,3337,369,11.81,-1.4,47.15,2,62),
(44,new String'("Saint-Nazaire"),44600,67031,65868,1432,46.79,-2.2,47.2833,0,47),
(44,new String'("Haute-Goulaine"),44115,5530,4930,268,20.59,-1.43333,47.2,0,56),
(44,new String'("Port-Saint-Père"),44710,2724,2141,83,32.57,-1.75,47.1333,0,52),
(44,new String'("Le Bignon"),44140,3309,2583,120,27.54,0.509445,47.0984,3,58),
(44,new String'("Campbon"),44750,3805,2899,76,49.82,-1.96667,47.4167,3,80),
(44,new String'("Le Pin"),44540,731,602,29,24.95,-2.16667,47.35,39,91),
(44,new String'("Saint-Mars-la-Jaille"),44540,2445,2195,121,20.06,-1.18333,47.5167,22,88),
(44,new String'("Belligné"),44370,1765,1453,53,32.8,-1.03333,47.4667,47,94),
(44,new String'("Fresnay-en-Retz"),44580,1235,859,60,20.49,-1.88333,47.0167,1,42),
(44,new String'("Louisfert"),44110,898,796,49,18.16,-1.43333,47.6833,39,87),
(45,new String'("La Selle-sur-le-Bied"),45210,977,772,40,23.96,2.88333,48.0667,97,143),
(45,new String'("Bouzy-la-Forêt"),45460,1215,866,32,37.47,2.38333,47.85,113,142),
(45,new String'("Amilly"),45200,11588,11497,287,40.26,2.77028,47.9731,86,139),
(45,new String'("Quiers-sur-Bézonde"),45270,1173,970,70,16.61,2.43333,48.0,104,135),
(45,new String'("Jargeau"),45150,4488,3981,306,14.66,2.11667,47.8667,97,108),
(45,new String'("Givraines"),45300,378,306,33,11.26,2.36667,48.15,95,127),
(45,new String'("Saint-Denis-de-l'Hôtel"),45550,2925,2621,114,25.45,2.11667,47.8667,97,124),
(45,new String'("Montliard"),45340,224,175,24,8.99,2.4,48.0167,104,147),
(45,new String'("Coullons"),45720,2451,2272,31,78.97,2.5,47.6167,130,205),
(45,new String'("Barville-en-Gâtinais"),45340,305,198,29,10.29,2.4,48.1167,99,118),
(45,new String'("Escrignelles"),45250,64,78,4,14.04,2.81667,47.7167,159,176),
(45,new String'("Pannes"),45700,3379,2908,162,20.84,2.66667,48.0167,83,107),
(45,new String'("Saint-Brisson-sur-Loire"),45500,1029,1003,47,21.86,2.68333,47.65,122,208),
(45,new String'("Sennely"),45240,651,524,13,49.32,2.15,47.6833,114,144),
(45,new String'("Mérinville"),45210,164,112,13,11.84,2.93333,48.0833,127,149),
(45,new String'("Nangeville"),45330,116,101,13,8.59,2.31667,48.3,109,142),
(45,new String'("Ouzouer-sous-Bellegarde"),45270,283,259,24,11.57,2.46667,47.9833,99,125),
(45,new String'("Châtillon-le-Roi"),45480,277,274,61,4.54,2.1,48.15,118,136),
(45,new String'("Gémigny"),45310,223,160,15,14.17,1.7,47.9667,114,129),
(45,new String'("Rouvray-Sainte-Croix"),45310,139,131,14,9.47,1.73333,48.05,119,133),
(45,new String'("Tavers"),45190,1334,1217,58,22.62,1.61667,47.75,75,119),
(45,new String'("Louzouer"),45210,266,277,23,11.23,2.88333,48.0333,112,138),
(45,new String'("Château-Renard"),45220,2280,2389,56,40.34,2.93333,47.9333,104,188),
(45,new String'("Nibelle"),45340,1045,752,38,27.18,2.33333,48.0167,117,170),
(45,new String'("La Ferté-Saint-Aubin"),45240,7127,6781,82,86.12,1.93333,47.7167,93,137),
(45,new String'("Tournoisis"),45310,371,308,24,14.94,1.63333,48.0,117,131),
(45,new String'("Bou"),45430,902,845,143,6.29,2.05,47.8667,97,102),
(45,new String'("Bucy-Saint-Liphard"),45140,205,217,11,17.84,1.76667,47.9333,105,131),
(45,new String'("Audeville"),45300,177,161,13,12.71,2.23333,48.2667,120,137),
(45,new String'("Ouzouer-des-Champs"),45290,280,275,24,11.32,2.7,47.8833,102,125),
(45,new String'("Lombreuil"),45700,306,240,40,7.56,2.63333,47.95,94,107),
(45,new String'("Ascoux"),45300,913,786,135,6.75,2.25,48.1167,107,121),
(45,new String'("Sceaux-du-Gâtinais"),45490,620,492,19,31.72,2.6,48.1,77,101),
(45,new String'("Sermaises"),45300,1593,1594,74,21.25,2.2,48.3,104,139),
(45,new String'("Ladon"),45270,1342,1104,97,13.75,2.53333,48.0,89,108),
(45,new String'("Bricy"),45310,540,551,42,12.66,1.78333,48.0,116,131),
(45,new String'("Sury-aux-Bois"),45530,787,507,20,38.0,2.33333,47.9667,109,160),
(45,new String'("Rebréchien"),45470,1363,1168,71,19.19,2.05,47.9833,114,141),
(45,new String'("Jouy-le-Potier"),45370,1324,1326,26,50.4,1.81667,47.75,94,119),
(45,new String'("Corbeilles"),45490,1490,1463,45,32.62,2.55,48.0667,79,96),
(45,new String'("Marigny-les-Usages"),45760,1140,1172,118,9.66,2.01667,47.95,103,138),
(45,new String'("Jouy-en-Pithiverais"),45480,249,241,15,15.86,2.11667,48.1333,109,137),
(45,new String'("Cortrat"),45700,90,94,8,11.03,2.76667,47.9,95,132),
(45,new String'("Mainvilliers"),45330,237,234,23,10.3,2.28333,48.3,117,140),
(45,new String'("Champoulet"),45420,47,69,5,9.36,2.91667,47.6667,169,211),
(45,new String'("Le Bardon"),45130,1039,818,84,12.23,1.65,47.85,99,116),
(45,new String'("Briare"),45250,5710,5989,125,45.41,2.73333,47.6333,122,189),
(45,new String'("Varennes-Changy"),45290,1564,1232,52,29.77,2.66056,47.8653,103,154),
(45,new String'("Batilly-en-Puisaye"),45420,112,110,6,17.35,2.88334,47.6123,155,211),
(45,new String'("Cepoy"),45120,2347,2063,275,8.52,2.73333,48.05,77,114),
(45,new String'("Dordives"),45680,2976,2590,196,15.18,2.76667,48.15,67,115),
(45,new String'("Adon"),45230,179,198,7,24.65,2.8,47.7667,137,176),
(45,new String'("Nevoy"),45500,1149,1019,37,30.75,2.58333,47.7167,117,160),
(45,new String'("Dammarie-sur-Loing"),45230,530,468,25,20.94,2.88333,47.7833,126,177),
(45,new String'("Coinces"),45310,556,437,25,21.63,1.75,48.0167,114,133),
(45,new String'("Saint-Germain-des-Prés"),45220,1881,1709,71,26.18,2.85,47.95,95,148),
(45,new String'("Coudroy"),45260,348,274,23,14.73,2.46667,47.9167,100,136),
(45,new String'("Outarville"),45480,1433,1443,30,46.61,2.01667,48.2167,120,139),
(45,new String'("Montbarrois"),45340,272,274,45,6.01,2.4,48.05,107,142),
(45,new String'("Puiseaux"),45390,3297,3041,162,20.32,2.46667,48.2,82,141),
(45,new String'("La Chapelle-Saint-Sépulcre"),45210,262,250,42,6.21,2.85,48.0167,102,137),
(45,new String'("Neuvy-en-Sullias"),45510,1198,935,47,25.28,2.25,47.8,106,149),
(45,new String'("Saint-Benoît-sur-Loire"),45730,2057,1877,112,18.27,2.3,47.8167,105,115),
(45,new String'("Douchy"),45220,1012,956,43,23.51,3.05,47.95,121,190),
(45,new String'("Escrennes"),45300,709,650,61,11.55,2.18333,48.1333,102,123),
(45,new String'("Saint-Florent"),45600,464,414,12,37.78,2.47667,47.6906,128,162),
(45,new String'("Paucourt"),45200,894,860,44,20.2,2.8,48.0333,82,127),
(45,new String'("Presnoy"),45260,245,163,31,7.72,2.55,47.95,92,110),
(45,new String'("Bouzonville-aux-Bois"),45300,420,344,55,7.54,2.23472,48.1031,108,118),
(45,new String'("Thimory"),45260,728,513,58,12.37,2.6,47.9167,97,117),
(45,new String'("Tigy"),45510,2271,1959,48,47.29,2.2,47.8,104,149),
(45,new String'("Chanteau"),45400,1281,1135,44,28.85,1.96667,47.9667,109,138),
(45,new String'("Rouvres-Saint-Jean"),45300,282,233,27,10.1,2.21667,48.3167,99,142),
(45,new String'("Traînou"),45470,3105,2794,92,33.68,2.1,47.9667,107,144),
(45,new String'("Fréville-du-Gâtinais"),45270,182,170,18,9.77,2.43333,48.0167,97,131),
(45,new String'("Châtillon-Coligny"),45230,1983,1945,77,25.53,2.85,47.8333,115,179),
(45,new String'("Chevry-sous-le-Bignon"),45210,231,202,31,7.4,2.9,48.1333,97,133),
(45,new String'("Crottes-en-Pithiverais"),45170,330,245,24,13.65,2.06667,48.1167,122,137),
(45,new String'("Montcorbon"),45220,460,432,17,26.61,3.06667,47.9667,144,199),
(45,new String'("Échilleuses"),45390,374,323,30,12.43,2.43333,48.1667,91,129),
(45,new String'("Neuville-aux-Bois"),45170,4113,3876,129,31.74,2.05,48.0667,118,142),
(45,new String'("Baccon"),45130,717,629,21,33.02,1.63333,47.8833,99,131),
(45,new String'("Dadonville"),45300,2259,1873,124,18.21,2.26667,48.15,96,125),
(45,new String'("Saint-Jean-de-Braye"),45800,19057,17757,1391,13.7,1.96667,47.9,95,127),
(45,new String'("Égry"),45340,341,264,46,7.39,2.43333,48.1,95,115),
(45,new String'("Ardon"),45160,1113,849,20,53.65,1.86667,47.7833,98,123),
(45,new String'("Chapelon"),45270,282,234,43,6.52,2.58333,48.0333,84,94),
(45,new String'("Chambon-la-Forêt"),45340,840,624,48,17.16,2.3,48.05,104,168),
(45,new String'("Sougy"),45410,874,805,30,28.25,1.78333,48.05,121,134),
(45,new String'("Gien"),45500,14684,15321,216,67.86,2.63333,47.7,117,190),
(45,new String'("Courcelles"),45300,285,252,45,6.3,2.31667,48.0833,97,118),
(45,new String'("Villemandeur"),45700,6450,5666,562,11.46,2.7,47.9833,84,99),
(45,new String'("Mardié"),45430,2560,2372,148,17.28,2.05,47.8833,97,124),
(45,new String'("Saint-Loup-de-Gonois"),45210,111,102,18,6.16,2.91667,48.05,107,148),
(45,new String'("Gy-les-Nonains"),45220,638,607,31,20.13,2.85139,47.9473,96,147),
(45,new String'("Bouilly-en-Gâtinais"),45300,344,299,21,15.96,2.28333,48.0833,98,122),
(45,new String'("Cerdon"),45620,1039,1009,15,67.07,2.36667,47.6333,132,172),
(45,new String'("Vannes-sur-Cosson"),45510,600,522,16,35.65,2.21667,47.7167,119,148),
(45,new String'("Cernoy-en-Berry"),45360,457,441,16,28.23,2.66667,47.5414,176,266),
(45,new String'("Treilles-en-Gâtinais"),45490,297,273,21,13.97,2.65972,48.0787,85,98),
(45,new String'("Léouville"),45480,66,42,15,4.28,2.08333,48.2167,123,136),
(45,new String'("Cercottes"),45520,1232,737,50,24.24,1.88333,47.9833,119,133),
(45,new String'("Orville"),45390,109,110,15,7.19,2.43333,48.2333,72,115),
(45,new String'("Moulon"),45270,188,179,20,9.4,2.6,48.0167,87,109),
(45,new String'("Dimancheville"),45390,112,88,47,2.35,2.43333,48.2333,77,133),
(45,new String'("Saint-Gondon"),45500,1099,875,49,22.4,2.53333,47.7,117,164),
(45,new String'("Fontenay-sur-Loing"),45210,1713,1424,176,9.73,2.76667,48.1,70,109),
(45,new String'("Auvilliers-en-Gâtinais"),45270,352,306,17,20.61,2.5,47.9667,96,126),
(45,new String'("Ervauville"),45320,565,389,45,12.54,2.98333,48.0833,134,164),
(45,new String'("Saint-Firmin-sur-Loire"),45360,502,553,20,24.76,2.73333,47.6167,126,234),
(45,new String'("Seichebrières"),45530,173,127,11,14.84,2.26667,47.9667,120,168),
(45,new String'("Ouzouer-sur-Loire"),45570,2765,2519,80,34.27,2.48333,47.7667,112,154),
(45,new String'("Charsonville"),45130,588,582,23,24.55,1.58333,47.9333,110,131),
(45,new String'("Le Moulinet-sur-Solin"),45290,138,143,7,19.37,2.61667,47.8333,123,177),
(45,new String'("Chaingy"),45380,3531,2868,162,21.69,1.76667,47.8833,82,124),
(45,new String'("Saint-Père-sur-Loire"),45600,1040,1005,97,10.69,2.37028,47.7748,107,117),
(45,new String'("Thignonville"),45300,330,321,36,9.16,2.16667,48.2833,112,132),
(45,new String'("Beaugency"),45190,7659,7112,465,16.45,1.63333,47.7833,78,118),
(45,new String'("Coudray"),45330,404,368,32,12.42,2.36667,48.2667,94,141),
(45,new String'("Pithiviers"),45300,8804,9235,1268,6.94,2.25,48.1667,97,130),
(45,new String'("La Neuville-sur-Essonne"),45390,366,289,39,9.19,2.36667,48.1833,87,129),
(45,new String'("Chevilly"),45520,2495,2383,59,41.76,1.88333,48.0333,117,138),
(45,new String'("Villamblain"),45310,275,213,10,25.95,1.55,48.0167,119,135),
(45,new String'("Montargis"),45200,14649,15025,3284,4.46,2.75,48.0,82,112),
(45,new String'("Préfontaines"),45490,461,446,39,11.75,2.68333,48.1,77,102),
(45,new String'("Thou"),45420,237,258,15,15.16,2.90834,47.5803,143,196),
(45,new String'("Batilly-en-Gâtinais"),45340,404,350,39,10.32,2.38333,48.0667,106,120),
(45,new String'("Baule"),45130,2043,1657,168,12.11,1.66667,47.8167,81,116),
(45,new String'("Bougy-lez-Neuville"),45170,189,177,11,16.73,2.03333,48.0333,123,144),
(45,new String'("Ramoulu"),45300,259,218,21,11.96,2.28333,48.2167,91,135),
(45,new String'("Courcy-aux-Loges"),45300,434,350,20,20.9,2.21667,48.0667,114,150),
(45,new String'("Montereau"),45260,622,547,12,50.12,2.56667,47.85,106,175),
(45,new String'("Griselles"),45210,801,620,26,30.32,2.83333,48.0833,87,133),
(45,new String'("Vitry-aux-Loges"),45530,1850,1725,41,44.06,2.26667,47.9333,107,138),
(45,new String'("Greneville-en-Beauce"),45480,662,585,29,22.47,2.11667,48.1833,114,137),
(45,new String'("Sully-la-Chapelle"),45450,416,317,15,26.17,2.18333,47.9667,106,147),
(45,new String'("Corquilleroy"),45120,2621,2109,187,13.96,2.7,48.05,80,102),
(45,new String'("Bazoches-sur-le-Betz"),45210,985,671,64,15.38,2.98333,48.1333,120,152),
(45,new String'("Meung-sur-Loire"),45130,6086,6254,299,20.35,1.7,47.8333,82,113),
(45,new String'("Vieilles-Maisons-sur-Joudry"),45260,600,462,36,16.46,2.44472,47.8859,113,141),
(45,new String'("Saint-Maurice-sur-Fessard"),45700,1160,887,75,15.38,2.61667,48.0,84,117),
(45,new String'("Oussoy-en-Gâtinais"),45290,406,339,17,23.23,2.65,47.9167,94,137),
(45,new String'("Rozières-en-Beauce"),45130,183,157,19,9.17,1.7,47.9333,107,124),
(45,new String'("Aschères-le-Marché"),45170,1191,1050,56,20.9,2.0,48.1,121,133),
(45,new String'("Guilly"),45600,666,540,39,17.03,2.28333,47.8,102,119),
(45,new String'("Marsainvilliers"),45300,302,307,27,10.82,2.28333,48.2167,119,132),
(45,new String'("Ruan"),45410,232,235,14,16.26,1.93917,48.1117,119,132),
(45,new String'("Grangermont"),45390,209,175,53,3.93,2.41667,48.1833,91,128),
(45,new String'("Juranville"),45340,485,403,31,15.23,2.5,48.05,85,110),
(45,new String'("Courtemaux"),45320,289,221,23,12.19,2.93333,48.05,110,154),
(45,new String'("Augerville-la-Rivière"),45330,236,193,58,4.03,2.43333,48.25,72,120),
(45,new String'("La Bussière"),45230,793,749,22,35.23,2.75084,47.7456,144,186),
(45,new String'("Semoy"),45400,3107,2877,399,7.78,1.95,47.9333,103,134),
(45,new String'("Faverelles"),45420,159,198,8,18.92,2.93333,47.5667,156,228),
(45,new String'("Nesploy"),45270,387,298,30,12.87,2.36667,48.0,112,144),
(45,new String'("Chilleurs-aux-Bois"),45170,1841,1705,35,52.22,2.13333,48.0667,114,150),
(45,new String'("Engenville"),45300,507,393,28,18.1,2.25,48.2333,119,136),
(45,new String'("Gidy"),45520,1585,1482,66,23.91,1.83333,47.9833,117,128),
(45,new String'("Saint-Lyé-la-Forêt"),45170,1098,949,40,27.22,1.98333,48.05,120,137),
(45,new String'("Châlette-sur-Loing"),45120,13050,13967,993,13.13,2.73333,48.0167,77,114),
(45,new String'("Chuelles"),45220,1136,914,36,30.82,2.96667,48.0,138,181),
(45,new String'("Oison"),45170,130,127,10,12.09,1.96667,48.1333,122,139),
(45,new String'("Sandillon"),45640,3865,3402,93,41.31,2.03333,47.85,95,124),
(45,new String'("Villeneuve-sur-Conie"),45310,204,195,11,17.97,1.65,48.05,112,134),
(45,new String'("Bonnée"),45460,670,658,57,11.61,2.38333,47.8,111,118),
(45,new String'("Saint-Martin-sur-Ocre"),45500,1244,1158,78,15.79,2.66667,47.65,122,191),
(45,new String'("Choux"),45290,500,449,14,33.36,2.66667,47.8,123,177),
(45,new String'("La Chapelle-Saint-Mesmin"),45380,9658,8946,1077,8.96,1.83333,47.8833,87,113),
(45,new String'("Autry-le-Châtel"),45500,1017,1015,20,50.56,2.60222,47.5975,141,236),
(45,new String'("Dammarie-en-Puisaye"),45420,180,155,6,25.89,2.86667,47.6333,152,192),
(45,new String'("Laas"),45300,203,165,30,6.6,2.21667,48.1167,112,119),
(45,new String'("Pierrefitte-ès-Bois"),45360,286,318,10,27.18,2.71667,47.5083,190,281),
(45,new String'("Donnery"),45450,2533,2020,116,21.77,2.1,47.9167,99,124),
(45,new String'("Boisseaux"),45480,422,253,58,7.19,1.98333,48.25,124,140),
(45,new String'("Beaulieu-sur-Loire"),45630,1785,1689,36,48.83,2.81667,47.5427,130,260),
(45,new String'("Morville-en-Beauce"),45300,187,178,16,11.02,2.16667,48.25,115,134),
(45,new String'("Briarres-sur-Essonne"),45390,537,532,65,8.23,2.41667,48.2333,77,135),
(45,new String'("Bordes"),45460,1777,1445,73,24.02,2.4,47.8167,112,150),
(45,new String'("Beaune-la-Rolande"),45340,2018,2097,98,20.55,2.43333,48.0667,91,119),
(45,new String'("Saint-Aignan-le-Jaillard"),45600,573,561,23,24.31,2.43333,47.75,112,159),
(45,new String'("Foucherolles"),45320,295,169,30,9.8,3.01667,48.0833,142,164),
(45,new String'("Montcresson"),45700,1299,1266,61,21.0,2.81667,47.9,94,140),
(45,new String'("Fleury-les-Aubrais"),45400,21171,20702,2091,10.12,1.91667,47.9333,109,133),
(45,new String'("Ouzouer-sur-Trézée"),45250,1276,1208,20,61.63,2.8,47.6667,137,185),
(45,new String'("Intville-la-Guétard"),45300,123,99,25,4.88,2.21667,48.25,120,134),
(45,new String'("La Selle-en-Hermoy"),45210,779,613,39,19.56,2.9,48.0167,112,156),
(45,new String'("Bazoches-les-Gallerandes"),45480,1452,1348,39,36.73,2.05,48.1667,120,137),
(45,new String'("Mareau-aux-Prés"),45370,1290,1140,96,13.34,1.78333,47.8667,82,103),
(45,new String'("Sainte-Geneviève-des-Bois"),45230,1081,990,26,40.74,2.81667,47.8167,115,166),
(45,new String'("Bonny-sur-Loire"),45420,2049,1924,79,25.8,2.83333,47.5667,130,189),
(45,new String'("Lion-en-Beauce"),45410,135,97,19,7.0,1.93333,48.1333,121,137),
(45,new String'("Girolles"),45120,676,581,48,13.9,2.71667,48.0667,76,104),
(45,new String'("Isdes"),45620,590,476,13,43.89,2.25,47.6667,129,157),
(45,new String'("Épieds-en-Beauce"),45130,1429,1035,35,40.22,1.61667,47.95,114,129),
(45,new String'("Lorris"),45260,2966,2674,66,44.91,2.51667,47.8833,114,173),
(45,new String'("Viglain"),45600,897,835,22,39.99,2.3,47.7333,114,150),
(45,new String'("Tivernon"),45170,238,224,18,12.61,1.93333,48.15,125,139),
(45,new String'("Saint-Cyr-en-Val"),45590,3107,3249,70,44.23,1.96667,47.8333,92,126),
(45,new String'("Attray"),45170,214,195,12,16.74,2.11667,48.1167,105,137),
(45,new String'("Germigny-des-Prés"),45110,730,589,74,9.78,2.26667,47.85,102,112),
(45,new String'("Guigneville"),45300,527,484,16,32.01,2.16667,48.2,117,141),
(45,new String'("Ousson-sur-Loire"),45250,743,684,138,5.35,2.78333,47.5833,127,182),
(45,new String'("Cléry-Saint-André"),45370,3255,2720,179,18.13,1.75,47.8167,84,107),
(45,new String'("Césarville-Dossainville"),45300,220,251,11,19.06,2.27639,48.2612,106,142),
(45,new String'("Férolles"),45150,1175,1078,68,17.05,2.11667,47.8333,99,107),
(45,new String'("Saint-Martin-d'Abbat"),45110,1643,1223,42,38.97,2.26667,47.85,106,139),
(45,new String'("Conflans-sur-Loing"),45700,359,359,39,9.14,2.78333,47.95,90,134),
(45,new String'("Chantecoq"),45320,524,405,32,15.93,2.96667,48.05,115,167),
(45,new String'("Triguères"),45220,1355,1158,37,35.78,2.98333,47.9333,112,192),
(45,new String'("Boulay-les-Barres"),45140,1120,551,89,12.45,1.78333,47.9833,118,131),
(45,new String'("Ingrannes"),45450,521,395,13,38.98,2.2,47.9833,109,147),
(45,new String'("Combleux"),45800,475,424,431,1.1,1.98333,47.9,95,110),
(45,new String'("Manchecourt"),45300,641,588,39,16.23,2.33333,48.2333,107,138),
(45,new String'("Nancray-sur-Rimarde"),45340,554,430,47,11.58,2.33333,48.0667,102,131),
(45,new String'("Yèvre-la-Ville"),45300,699,701,26,26.77,2.31667,48.1333,92,127),
(45,new String'("Chailly-en-Gâtinais"),45260,675,560,36,18.37,2.55,47.95,95,121),
(45,new String'("Chécy"),45430,8208,7225,530,15.47,2.01667,47.9,95,116),
(45,new String'("Saint-Michel"),45340,125,143,24,5.14,2.36667,48.0667,110,129),
(45,new String'("Mézières-lez-Cléry"),45370,793,602,29,27.01,1.80417,47.8187,91,108),
(45,new String'("Thorailles"),45210,158,83,45,3.45,2.9,48.0167,128,144),
(45,new String'("Marcilly-en-Villette"),45240,1999,1899,31,62.66,2.01667,47.7667,97,136),
(45,new String'("Bucy-le-Roi"),45410,191,177,41,4.58,1.91667,48.0667,121,128),
(45,new String'("Montbouy"),45230,745,688,27,26.73,2.81667,47.8667,102,154),
(45,new String'("Poilly-lez-Gien"),45500,2341,2189,70,33.29,2.6,47.6833,117,182),
(45,new String'("Autruy-sur-Juine"),45480,728,810,26,27.11,2.1,48.2667,92,137),
(45,new String'("Huêtre"),45520,252,199,19,13.15,1.8,48.0167,116,134),
(45,new String'("Ménestreau-en-Villette"),45240,1467,1382,27,53.62,2.01667,47.7,104,139),
(45,new String'("Erceville"),45480,323,277,25,12.72,2.03333,48.2333,110,137),
(45,new String'("Breteau"),45250,73,82,4,16.45,2.9,47.6833,157,189),
(45,new String'("Rozoy-le-Vieil"),45210,391,305,48,8.14,2.94556,48.1245,118,147),
(45,new String'("Chaussy"),45480,341,275,26,12.94,1.98333,48.1667,126,135),
(45,new String'("Boismorand"),45290,863,593,34,25.15,2.71667,47.7833,128,176),
(45,new String'("Estouy"),45300,519,496,28,18.07,2.31667,48.1833,87,131),
(45,new String'("Ormes"),45140,3435,3051,189,18.15,1.8,47.9333,106,131),
(45,new String'("Nogent-sur-Vernisson"),45290,2594,2448,77,33.27,2.75,47.85,109,150),
(45,new String'("Villemoutiers"),45270,492,483,30,16.18,2.55,48.0,91,106),
(45,new String'("Andonville"),45480,196,217,16,11.94,2.01667,48.2667,112,139),
(45,new String'("Chevillon-sur-Huillard"),45700,1308,1141,67,19.34,2.63333,47.9667,86,106),
(45,new String'("Malesherbes"),45330,6190,5988,351,17.61,2.41667,48.3,67,140),
(45,new String'("Saran"),45770,15120,14801,769,19.65,1.88333,47.95,108,137),
(45,new String'("Trinay"),45410,214,192,12,17.22,1.95,48.0833,120,132),
(45,new String'("Desmonts"),45390,172,165,36,4.76,2.5,48.2333,102,141),
(45,new String'("Vimory"),45700,1123,1105,42,26.22,2.68333,47.95,89,104),
(45,new String'("Loury"),45470,2519,1990,73,34.36,2.08333,48.0,108,152),
(45,new String'("Boiscommun"),45340,1147,1043,71,16.06,2.38333,48.0333,108,147),
(45,new String'("Sigloy"),45110,664,532,70,9.46,2.23333,47.8333,102,110),
(45,new String'("Le Bignon-Mirabeau"),45210,282,261,21,12.83,2.91667,48.15,112,141),
(45,new String'("Bromeilles"),45390,318,292,21,14.75,2.5,48.1833,89,131),
(45,new String'("Saint-Sigismond"),45310,295,241,19,14.93,1.68333,47.9833,117,125),
(45,new String'("Villorceau"),45190,1158,902,121,9.5,1.6,47.8,104,121),
(45,new String'("Vrigny"),45300,778,597,48,16.14,2.23333,48.0833,108,168),
(45,new String'("Dry"),45370,1391,1191,61,22.64,1.71667,47.8,82,105),
(45,new String'("Dampierre-en-Burly"),45570,1260,1110,26,47.44,2.51667,47.7667,117,161),
(45,new String'("Vienne-en-Val"),45510,1887,1550,52,35.94,2.13333,47.8,99,142),
(45,new String'("Bray-en-Val"),45460,1366,1045,61,22.32,2.36667,47.8333,107,147),
(45,new String'("Gondreville"),45490,371,364,45,8.07,2.65472,48.0509,85,97),
(45,new String'("Châtenoy"),45260,420,367,16,25.84,2.4,47.9167,109,139),
(45,new String'("Ferrières-en-Gâtinais"),45210,3395,3045,124,27.32,2.78333,48.0833,72,121),
(45,new String'("Noyers"),45260,722,672,39,18.06,2.51667,47.9167,98,134),
(45,new String'("Villereau"),45170,402,327,44,9.12,1.98333,48.0667,120,132),
(45,new String'("Langesse"),45290,79,66,8,8.97,2.66667,47.8167,119,151),
(45,new String'("Montigny"),45170,250,221,46,5.36,2.11667,48.1167,115,134),
(45,new String'("Saint-Hilaire-sur-Puiseaux"),45700,166,163,14,11.34,2.7,47.9,96,110),
(45,new String'("Mézières-en-Gâtinais"),45270,260,183,26,9.86,2.48333,48.0333,92,111),
(45,new String'("Ligny-le-Ribault"),45240,1305,1121,22,59.21,1.78333,47.6833,84,117),
(45,new String'("Lion-en-Sullias"),45600,393,336,16,24.49,2.48333,47.7333,113,152),
(45,new String'("Courtenay"),45320,3976,3444,79,50.13,3.05,48.0333,137,186),
(45,new String'("Charmont-en-Beauce"),45480,402,330,22,18.05,2.1,48.2333,106,134),
(45,new String'("Cravant"),45190,949,833,27,33.91,1.56667,47.8333,108,131),
(45,new String'("Saint-Hilaire-Saint-Mesmin"),45160,2847,2351,201,14.12,1.83333,47.8667,87,105),
(45,new String'("Boynes"),45300,1266,1014,82,15.43,2.35,48.1167,105,123),
(45,new String'("La Chapelle-Onzerain"),45310,115,90,16,7.06,1.61667,48.0333,121,134),
(45,new String'("Mignerette"),45490,357,298,57,6.21,2.6,48.05,81,93),
(45,new String'("Vennecy"),45760,1408,1304,131,10.71,2.05,47.95,106,135),
(45,new String'("Huisseau-sur-Mauves"),45130,1638,1649,44,37.16,1.7,47.9,95,121),
(45,new String'("Mareau-aux-Bois"),45300,608,468,52,11.61,2.18333,48.1,107,122),
(45,new String'("Pers-en-Gâtinais"),45210,225,202,21,10.69,2.9,48.1167,105,137),
(45,new String'("Boigny-sur-Bionne"),45760,2164,1888,287,7.53,2.01667,47.9333,98,121),
(45,new String'("Saint-Firmin-des-Bois"),45220,489,420,25,19.05,2.91667,47.9667,118,179),
(45,new String'("Beauchamps-sur-Huillard"),45270,413,334,22,18.09,2.45306,47.9384,96,130),
(45,new String'("Saint-Hilaire-les-Andrésis"),45320,976,750,37,25.71,3.01667,48.05,123,177),
(45,new String'("Chevannes"),45210,343,290,28,11.99,2.85833,48.1333,91,126),
(45,new String'("Combreux"),45530,241,202,19,12.67,2.3,47.95,115,147),
(45,new String'("Orveau-Bellesauve"),45330,381,316,24,15.8,2.33333,48.2833,103,139),
(45,new String'("Nargis"),45210,1394,1104,62,22.27,2.75,48.1,67,109),
(45,new String'("Pithiviers-le-Vieil"),45300,1828,1824,54,33.68,2.21667,48.1667,98,132),
(45,new String'("Courtempierre"),45490,243,203,18,13.3,2.61667,48.1,77,98),
(45,new String'("Mignères"),45490,317,323,61,5.12,2.63333,48.05,83,95),
(45,new String'("Solterre"),45700,500,470,51,9.8,2.75,47.9,96,115),
(45,new String'("Labrosse"),45330,79,81,19,4.09,2.38333,48.2333,106,134),
(45,new String'("Santeau"),45170,367,287,42,8.71,2.15,48.0833,111,125),
(45,new String'("La Chapelle-sur-Aveyron"),45230,550,393,28,19.03,2.86667,47.8667,114,182),
(45,new String'("Lorcy"),45490,546,483,32,16.75,2.53333,48.05,85,99),
(45,new String'("Saint-Ay"),45130,3161,2967,313,10.07,1.75,47.85,82,108),
(45,new String'("Ouvrouer-les-Champs"),45150,521,380,49,10.54,2.17861,47.8323,100,108),
(45,new String'("Saint-Aignan-des-Gués"),45460,342,285,89,3.84,2.31667,47.85,108,130),
(45,new String'("Patay"),45310,2080,2027,150,13.8,1.7,48.05,114,132),
(45,new String'("Auxy"),45340,994,861,49,20.28,2.46667,48.1167,81,117),
(45,new String'("Artenay"),45410,1827,1940,89,20.5,1.88333,48.0833,117,129),
(45,new String'("Saint-Loup-des-Vignes"),45340,441,407,49,8.86,2.41667,48.0333,97,141),
(45,new String'("Mormant-sur-Vernisson"),45700,125,117,11,10.92,2.73333,47.95,89,107),
(45,new String'("Pannecières"),45300,118,116,16,7.02,2.15,48.2833,120,136),
(45,new String'("Saint-Maurice-sur-Aveyron"),45230,873,769,16,53.76,2.93333,47.85,127,203),
(45,new String'("Boësses"),45390,390,351,29,13.13,2.45,48.15,91,128),
(45,new String'("Lailly-en-Val"),45740,2639,2252,57,45.61,1.68333,47.7667,78,115),
(45,new String'("Bellegarde"),45270,1759,1559,356,4.93,2.44278,47.9892,105,136),
(45,new String'("Coulmiers"),45130,535,559,37,14.28,1.66667,47.9333,108,121),
(45,new String'("Pressigny-les-Pins"),45290,454,383,38,11.91,2.75,47.8833,106,125),
(45,new String'("Melleroy"),45220,519,500,21,24.23,2.95,47.9,133,191),
(45,new String'("Aillant-sur-Milleron"),45230,389,357,14,26.93,2.93333,47.8,138,196),
(45,new String'("La Cour-Marigny"),45260,349,300,25,13.43,2.6,47.9,99,131),
(45,new String'("Bordeaux-en-Gâtinais"),45340,117,122,12,9.46,2.51667,48.1,79,96),
(45,new String'("Bondaroy"),45300,393,361,56,6.94,2.28333,48.1667,95,129),
(45,new String'("Sully-sur-Loire"),45600,5443,5903,124,43.6,2.36667,47.7667,107,151),
(45,new String'("Darvoy"),45150,1869,1731,217,8.58,2.1,47.8667,98,103),
(45,new String'("Saint-Jean-de-la-Ruelle"),45140,16631,16560,2726,6.1,1.86667,47.9167,90,121),
(45,new String'("Feins-en-Gâtinais"),45230,50,44,4,11.89,2.85,47.75,150,179),
(45,new String'("Saint-Pryvé-Saint-Mesmin"),45750,5188,5609,584,8.87,1.86667,47.8833,87,99),
(45,new String'("Saint-Jean-le-Blanc"),45650,8185,8485,1068,7.66,1.91667,47.9,91,100),
(45,new String'("Châtillon-sur-Loire"),45360,3132,2963,77,40.67,2.75,47.5833,126,246),
(45,new String'("Saint-Péravy-la-Colombe"),45310,688,581,36,18.96,1.7,48.0,114,131),
(45,new String'("Villevoques"),45700,205,214,40,5.06,2.63333,48.0333,88,114),
(45,new String'("Ingré"),45140,7899,7450,379,20.82,1.81667,47.9167,103,133),
(45,new String'("Saint-Denis-en-Val"),45560,7162,7207,418,17.11,1.95,47.8833,93,99),
(45,new String'("Le Charme"),45230,151,109,10,13.82,3.0,47.8,164,198),
(45,new String'("Aulnay-la-Rivière"),45390,507,489,31,16.14,2.38333,48.2,82,137),
(45,new String'("Orléans"),45000,114167,113089,4154,27.48,1.9,47.9167,90,124),
(45,new String'("Villemurlin"),45600,584,537,11,48.95,2.33333,47.6833,120,160),
(45,new String'("Châteauneuf-sur-Loire"),45110,8005,7036,200,40.01,2.23333,47.8667,100,131),
(45,new String'("Ondreville-sur-Essonne"),45390,389,333,59,6.57,2.4,48.2,82,127),
(45,new String'("Olivet"),45160,19583,19209,837,23.39,1.9,47.8667,89,109),
(45,new String'("Messas"),45190,875,944,167,5.21,1.63333,47.8,100,116),
(45,new String'("Fay-aux-Loges"),45450,3349,3023,126,26.48,2.13333,47.9333,102,126),
(45,new String'("Gaubertin"),45340,268,194,36,7.29,2.41667,48.1167,91,121),
(46,new String'("Cornac"),46130,355,328,25,13.76,1.88333,44.9167,142,528),
(46,new String'("Rouffilhac"),46300,161,142,24,6.5,1.41667,44.7833,128,265),
(46,new String'("Loubressac"),46130,520,431,21,23.75,1.8,44.8833,120,424),
(46,new String'("Crégols"),46330,78,69,4,18.35,1.7,44.4667,129,368),
(46,new String'("Arques"),46250,207,158,13,15.05,1.26667,44.6,145,325),
(46,new String'("Lavercantière"),46340,273,183,18,14.99,1.3,44.6333,192,355),
(46,new String'("Montbrun"),46160,116,101,13,8.34,1.91667,44.5,141,395),
(46,new String'("Saint-Michel-Loubéjou"),46130,383,364,72,5.25,1.85,44.9,136,293),
(46,new String'("Parnac"),46140,390,371,67,5.77,1.3,44.5,100,296),
(46,new String'("Puyjourdes"),46260,70,49,8,7.83,1.86667,44.4167,251,401),
(46,new String'("Pontcirq"),46150,158,151,17,8.94,1.28333,44.55,120,305),
(46,new String'("Trespoux-Rassiels"),46090,765,662,36,20.7,1.36667,44.4167,132,343),
(46,new String'("Lauresses"),46210,283,296,11,23.73,2.13333,44.7667,473,718),
(46,new String'("Bretenoux"),46130,1355,1230,238,5.69,1.83333,44.9167,129,245),
(46,new String'("Mauroux"),46700,539,419,33,16.2,1.04639,44.4553,65,271),
(46,new String'("Sainte-Alauzie"),46170,137,109,11,12.22,1.3,44.3167,156,283),
(46,new String'("Cézac"),46170,180,139,10,17.34,1.35,44.3333,174,288),
(46,new String'("Gintrac"),46130,112,85,16,6.79,1.76667,44.9,119,368),
(46,new String'("Le Bastit"),46500,147,106,5,28.25,1.66667,44.7167,258,406),
(46,new String'("Saint-Matré"),46800,117,122,18,6.41,1.13333,44.4,155,276),
(46,new String'("Esclauzels"),46090,218,155,12,17.73,1.61667,44.4333,120,369),
(46,new String'("Estal"),46130,124,111,20,6.04,1.85,44.9167,193,480),
(46,new String'("Pescadoires"),46220,135,130,41,3.28,1.16667,44.5,80,120),
(46,new String'("Autoire"),46400,342,312,47,7.15,1.83333,44.85,134,396),
(46,new String'("Belfort-du-Quercy"),46230,523,463,14,36.19,1.55,44.25,153,307),
(46,new String'("Lauzès"),46360,167,147,26,6.39,1.58333,44.5667,197,394),
(46,new String'("Pinsac"),46200,742,707,37,19.69,1.51667,44.85,80,329),
(46,new String'("Labastide-Marnhac"),46090,1139,845,39,28.87,1.38333,44.4,137,320),
(46,new String'("Livernon"),46320,633,464,24,25.86,1.85,44.65,275,358),
(46,new String'("Montredon"),46270,285,285,24,11.78,2.18333,44.6167,240,505),
(46,new String'("Castelfranc"),46140,409,413,71,5.71,1.21667,44.5,80,270),
(46,new String'("Larroque-Toirac"),46160,143,135,21,6.56,1.95,44.5167,145,386),
(46,new String'("Quatre-Routes-du-Lot"),46110,672,584,240,2.8,1.64528,44.9973,118,209),
(46,new String'("Laramière"),46260,320,264,14,22.08,1.88333,44.3333,323,415),
(46,new String'("Mayrac"),46200,268,207,34,7.86,1.56667,44.9,120,287),
(46,new String'("Cuzac"),46270,238,194,47,5.02,2.15,44.5833,170,423),
(46,new String'("Saint-Jean-de-Laur"),46260,208,177,9,21.57,1.85,44.4333,141,402),
(46,new String'("Figeac"),46100,9810,9592,279,35.16,2.03333,44.6,170,451),
(46,new String'("Gagnac-sur-Cère"),46130,736,666,57,12.83,1.87722,44.9389,138,412),
(46,new String'("Promilhanes"),46260,214,182,14,14.55,1.81667,44.3833,334,403),
(46,new String'("Comiac"),46190,234,253,7,29.27,2.0,44.9333,171,621),
(46,new String'("Saillac"),46260,143,118,8,16.28,1.76667,44.3333,258,400),
(46,new String'("Creysse"),46600,293,257,30,9.51,1.6,44.8833,95,316),
(46,new String'("Aynac"),46120,590,531,27,21.55,1.85,44.7833,324,607),
(46,new String'("Montlauzun"),46800,128,117,19,6.48,1.21667,44.3,124,250),
(46,new String'("Saint-Germain-du-Bel-Air"),46310,528,496,24,21.47,1.43333,44.65,188,394),
(46,new String'("Lhospitalet"),46170,449,373,30,14.65,1.40806,44.3612,217,330),
(46,new String'("Lherm"),46150,242,222,17,13.47,1.24167,44.5667,114,306),
(46,new String'("Milhac"),46300,199,196,36,5.42,1.33333,44.8,90,200),
(46,new String'("Soturac"),46700,661,673,33,19.55,1.01667,44.5,65,234),
(46,new String'("Labastide-du-Haut-Mont"),46210,45,62,4,9.85,2.12084,44.8348,577,776),
(46,new String'("Linac"),46270,215,218,17,12.3,2.13333,44.6667,210,467),
(46,new String'("Saint-Médard-de-Presque"),46400,200,203,37,5.29,1.85,44.8667,140,400),
(46,new String'("Glanes"),46130,286,247,105,2.72,1.88333,44.9167,148,353),
(46,new String'("Bio"),46500,310,255,28,10.79,1.78333,44.7833,296,421),
(46,new String'("Labastide-du-Vert"),46150,235,215,22,10.44,1.28333,44.5167,102,283),
(46,new String'("Saint-Cirq-Madelon"),46300,145,123,19,7.49,1.3,44.7833,90,188),
(46,new String'("Saint-Médard"),46150,164,153,13,11.78,1.29417,44.5384,120,298),
(46,new String'("Cardaillac"),46100,566,498,31,18.1,2.0,44.6833,226,575),
(46,new String'("Sérignac"),46700,302,312,16,18.44,1.10472,44.4342,160,274),
(46,new String'("Saint-Laurent-les-Tours"),46400,913,900,84,10.84,1.9,44.8667,152,465),
(46,new String'("Meyronne"),46200,300,269,37,8.04,1.58333,44.8833,90,285),
(46,new String'("Saint-Céré"),46400,3545,3517,312,11.33,1.9,44.8667,141,523),
(46,new String'("Touzac"),46700,355,333,72,4.89,1.05,44.5,65,143),
(46,new String'("Montet-et-Bouxal"),46210,229,208,19,11.51,2.06667,44.7333,415,643),
(46,new String'("Cressensac"),46600,637,570,27,23.04,1.51667,45.0167,239,330),
(46,new String'("Rignac"),46500,267,258,27,9.64,1.69556,44.8064,270,423),
(46,new String'("Latouille-Lentillac"),46400,239,216,20,11.71,1.98333,44.85,184,573),
(46,new String'("Sauliac-sur-Célé"),46330,110,92,4,25.13,1.71667,44.5167,130,379),
(46,new String'("Bagnac-sur-Célé"),46270,1556,1521,69,22.29,2.15834,44.6664,210,478),
(46,new String'("Lalbenque"),46230,1619,1068,30,52.24,1.55,44.3333,197,332),
(46,new String'("Théminettes"),46120,169,145,19,8.71,1.86667,44.7167,312,411),
(46,new String'("Gigouzac"),46150,231,175,23,9.91,1.43333,44.5833,210,376),
(46,new String'("Montamel"),46310,96,98,9,9.61,1.44889,44.6062,258,427),
(46,new String'("Condat"),46110,414,331,67,6.12,1.66667,44.9917,116,249),
(46,new String'("Lissac-et-Mouret"),46100,939,780,60,15.55,1.98778,44.6264,182,366),
(46,new String'("Saint-Bressou"),46120,118,128,11,10.03,1.98333,44.7,274,619),
(46,new String'("Lagardelle"),46220,139,102,45,3.07,1.18333,44.4833,80,224),
(46,new String'("Soulomès"),46240,120,107,15,7.67,1.6,44.6333,271,450),
(46,new String'("Saint-Daunès"),46800,216,205,21,10.11,1.25,44.3667,156,284),
(46,new String'("Saint-Cyprien"),46800,308,315,20,15.07,1.25,44.3167,145,277),
(46,new String'("Issendolus"),46500,528,452,27,18.91,1.8,44.7333,300,373),
(46,new String'("Lacave"),46200,285,293,13,21.19,1.56667,44.85,80,349),
(46,new String'("Saint-Sulpice"),46160,132,109,10,13.19,1.79083,44.5695,145,363),
(46,new String'("Saignes"),46500,74,52,20,3.55,1.81667,44.7833,325,441),
(46,new String'("Sénaillac-Lauzès"),46360,133,156,5,25.78,1.65,44.6,288,449),
(46,new String'("Fontanes-du-Causse"),46240,75,72,4,15.01,1.65,44.6667,337,442),
(46,new String'("Saint-Pantaléon"),46800,246,223,12,19.37,1.28333,44.3667,175,305),
(46,new String'("Montvalent"),46600,302,267,10,27.61,1.61667,44.8833,95,322),
(46,new String'("Frayssinet"),46310,318,280,18,16.83,1.48333,44.6667,221,413),
(46,new String'("Lacapelle-Cabanac"),46700,163,145,20,8.04,1.06667,44.4667,74,266),
(46,new String'("Crayssac"),46150,737,442,49,14.95,1.31667,44.5,100,303),
(46,new String'("Boussac"),46100,168,178,21,7.77,1.93333,44.6,170,340),
(46,new String'("Albas"),46140,516,530,23,21.84,1.23333,44.4667,85,332),
(46,new String'("Saint-Jean-Mirabel"),46270,236,212,25,9.2,2.10834,44.6212,210,422),
(46,new String'("Cadrieu"),46160,158,141,30,5.24,1.88333,44.4833,140,394),
(46,new String'("Sénaillac-Latronquière"),46210,141,145,12,11.26,2.08333,44.8167,516,725),
(46,new String'("Saint-Martin-de-Vers"),46360,122,108,12,9.93,1.55,44.55,190,423),
(46,new String'("Cajarc"),46160,1119,1114,44,25.1,1.85,44.4833,140,394),
(46,new String'("Le Bouyssou"),46120,122,111,21,5.62,1.95,44.6833,291,594),
(46,new String'("Montgesty"),46150,310,268,26,11.88,1.28333,44.5667,170,313),
(46,new String'("Quissac"),46320,117,106,4,25.17,1.73333,44.6333,269,455),
(46,new String'("Montcuq"),46800,1273,1263,39,32.22,1.21667,44.3333,135,291),
(46,new String'("Thédirac"),46150,310,274,18,16.51,1.31667,44.6,205,332),
(46,new String'("Anglars-Juillac"),46140,349,332,63,5.48,1.21667,44.4833,81,240),
(46,new String'("Carlucet"),46500,231,169,6,33.7,1.61667,44.7167,171,385),
(46,new String'("Soucirac"),46300,103,118,9,11.31,1.5,44.7,247,434),
(46,new String'("Saint-Clair"),46300,144,134,13,11.0,1.4,44.7,167,365),
(46,new String'("Saint-Cirq-Souillaguet"),46300,146,127,17,8.54,1.45,44.7,220,380),
(46,new String'("Blars"),46330,126,117,4,25.68,1.71667,44.5667,200,380),
(46,new String'("Larnagol"),46160,133,157,5,24.36,1.78333,44.4833,130,385),
(46,new String'("Mayrinhac-Lentour"),46500,519,439,33,15.57,1.8,44.8167,310,448),
(46,new String'("Saint-Michel-de-Bannières"),46110,303,329,39,7.74,1.68333,44.9833,112,277),
(46,new String'("Martel"),46600,1650,1464,46,35.28,1.60889,44.937,92,336),
(46,new String'("Carnac-Rouffiac"),46140,249,204,18,13.57,1.25,44.4167,130,300),
(46,new String'("Beaumat"),46240,76,63,9,8.1,1.51667,44.65,238,426),
(46,new String'("Cabrerets"),46330,231,203,5,43.38,1.65,44.5,130,367),
(46,new String'("Le Montat"),46090,972,778,43,22.54,1.45,44.3833,132,303),
(46,new String'("Saint-Cirq-Lapopie"),46330,217,207,12,17.89,1.66667,44.4667,120,389),
(46,new String'("Frontenac"),46160,76,71,26,2.84,1.98333,44.55,150,370),
(46,new String'("Laroque-des-Arcs"),46090,503,472,65,7.69,1.46667,44.4833,110,331),
(46,new String'("Sainte-Croix"),46800,85,69,10,7.77,1.16667,44.3417,164,280),
(46,new String'("Reilhaguet"),46350,120,103,7,15.96,1.5,44.7667,131,390),
(46,new String'("Vergne"),46500,433,408,49,8.82,1.76667,44.8,295,424),
(46,new String'("Ginouillac"),46300,171,165,18,9.42,1.53833,44.7259,215,446),
(46,new String'("Viazac"),46100,300,284,16,17.74,1.83333,44.6667,200,502),
(46,new String'("Cavagnac"),46110,444,427,42,10.34,1.64,45.0087,123,256),
(46,new String'("Rampoux"),46340,101,88,17,5.83,1.3,44.6333,176,306),
(46,new String'("Albiac"),46500,87,66,22,3.83,1.81667,44.7667,324,430),
(46,new String'("Cahus"),46130,189,179,18,10.01,1.93333,44.95,139,505),
(46,new String'("Flaugnac"),46170,430,380,13,30.96,1.38333,44.2833,143,299),
(46,new String'("Lunan"),46100,528,363,85,6.15,2.1,44.6167,174,426),
(46,new String'("Cazals"),46250,617,573,58,10.57,1.22639,44.6434,157,324),
(46,new String'("Léobard"),46300,207,181,20,10.3,1.3,44.7167,130,263),
(46,new String'("Vaylats"),46230,270,251,10,26.37,1.65,44.3333,210,326),
(46,new String'("Camboulit"),46100,251,206,48,5.19,1.96667,44.6,177,312),
(46,new String'("Brengues"),46320,206,175,10,20.56,1.83333,44.5667,150,392),
(46,new String'("Carayac"),46160,79,82,11,6.87,1.93333,44.5333,271,409),
(46,new String'("Saint-Géry"),46330,458,350,33,13.58,1.58333,44.4833,120,348),
(46,new String'("Anglars-Nozac"),46300,307,257,31,9.83,1.41667,44.7833,117,303),
(46,new String'("Faycelles"),46100,630,531,44,14.08,1.98333,44.5667,150,373),
(46,new String'("Escamps"),46230,169,114,13,12.11,1.58333,44.4,235,302),
(46,new String'("Prayssac"),46220,2469,2300,102,24.05,1.18806,44.5039,80,284),
(46,new String'("Cremps"),46230,328,272,16,19.66,1.61667,44.4,173,283),
(46,new String'("Cieurac"),46230,426,287,22,18.7,1.51667,44.3833,189,292),
(46,new String'("Fourmagnac"),46100,155,106,41,3.78,2.0,44.65,213,364),
(46,new String'("Lascabanes"),46800,189,170,11,16.58,1.3,44.35,162,298),
(46,new String'("Sauzet"),46140,516,409,46,11.09,1.25,44.4167,176,312),
(46,new String'("Lunegarde"),46240,90,73,8,10.43,1.68333,44.6833,329,422),
(46,new String'("Fargues"),46800,159,149,10,14.79,1.21667,44.4167,155,289),
(46,new String'("Bagat-en-Quercy"),46800,196,193,11,16.63,1.24195,44.372,173,302),
(46,new String'("Couzou"),46500,107,107,4,21.72,1.61667,44.7667,138,376),
(46,new String'("Ladirat"),46400,114,118,12,8.93,1.98333,44.8167,191,492),
(46,new String'("Bach"),46230,170,143,8,21.02,1.68333,44.35,220,337),
(46,new String'("Saux"),46800,121,133,14,8.31,1.08333,44.3833,173,275),
(46,new String'("Masclat"),46350,347,292,34,10.02,1.4,44.8333,112,206),
(46,new String'("Girac"),46130,369,341,83,4.4,1.81667,44.9167,128,144),
(46,new String'("Lanzac"),46200,592,487,40,14.62,1.48333,44.8667,80,340),
(46,new String'("Concorès"),46310,287,300,15,19.0,1.4,44.6667,150,365),
(46,new String'("Lugagnac"),46260,118,104,7,15.81,1.73333,44.4167,173,339),
(46,new String'("Prendeignes"),46270,214,200,13,15.76,2.11667,44.6833,230,552),
(46,new String'("Thémines"),46120,222,218,16,13.35,1.83333,44.7333,306,423),
(46,new String'("Laburgade"),46230,314,222,24,12.57,1.55,44.3833,159,278),
(46,new String'("Sarrazac"),46600,571,464,31,18.38,1.58333,45.0167,132,342),
(46,new String'("Vers"),46090,422,398,23,17.94,1.56667,44.4833,110,351),
(46,new String'("Saint-Chamarand"),46310,206,173,15,13.09,1.46667,44.6833,213,384),
(46,new String'("Payrac"),46350,653,564,33,19.5,1.46667,44.8,125,364),
(46,new String'("Saint-Paul-de-Vern"),46400,194,183,17,10.84,1.95,44.8333,167,473),
(46,new String'("Lamativie"),46190,65,83,5,12.82,2.03333,44.95,267,643),
(46,new String'("Montcabrier"),46700,351,376,16,21.75,1.07417,44.5417,103,271),
(46,new String'("Pern"),46170,477,352,18,25.66,1.4,44.3167,198,325),
(46,new String'("Saint-Denis-lès-Martel"),46600,355,361,44,7.93,1.65,44.9333,93,323),
(46,new String'("Le Bourg"),46120,296,247,22,13.15,1.91667,44.7167,336,565),
(46,new String'("Rueyres"),46120,230,196,24,9.31,1.84639,44.7481,309,428),
(46,new String'("Francoulès"),46090,217,212,15,13.61,1.48333,44.55,203,410),
(46,new String'("Rudelle"),46120,191,153,27,6.83,1.88333,44.7167,326,435),
(46,new String'("Bouziès"),46330,78,70,9,8.2,1.63333,44.4833,120,348),
(46,new String'("Caillac"),46140,575,533,77,7.44,1.35,44.4833,100,271),
(46,new String'("Cassagnes"),46700,207,192,17,11.62,1.15,44.55,148,300),
(46,new String'("Gramat"),46500,3537,3549,61,57.07,1.71667,44.7833,220,404),
(46,new String'("Saint-Simon"),46320,160,122,17,9.26,1.86667,44.7,309,392),
(46,new String'("Le Boulvé"),46800,179,181,9,19.51,1.16667,44.4333,108,292),
(46,new String'("Corn"),46100,198,157,12,15.26,1.91667,44.6,163,424),
(46,new String'("Beauregard"),46260,241,188,15,15.3,1.8,44.3333,298,396),
(46,new String'("Nadillac"),46360,74,62,10,7.35,1.51667,44.55,191,405),
(46,new String'("Capdenac"),46100,1092,990,100,10.9,2.06917,44.5809,155,369),
(46,new String'("Duravel"),46700,960,885,64,14.97,1.08333,44.5167,65,271),
(46,new String'("Miers"),46500,437,397,17,25.28,1.7,44.85,218,430),
(46,new String'("Baladou"),46600,409,325,25,15.74,1.56667,44.9167,160,301),
(46,new String'("Nadaillac-de-Rouge"),46350,190,101,24,7.73,1.43333,44.85,86,273),
(46,new String'("Lamagdelaine"),46090,751,741,70,10.58,1.48333,44.4667,110,331),
(46,new String'("Vidaillac"),46260,167,159,17,9.49,1.83333,44.35,338,406),
(46,new String'("Bessonies"),46210,101,120,13,7.41,2.15,44.8,510,682),
(46,new String'("Peyrilles"),46310,366,313,12,28.41,1.41667,44.6167,188,384),
(46,new String'("Latronquière"),46210,544,530,52,10.37,2.08333,44.8,549,694),
(46,new String'("Saint-Sozy"),46200,503,474,58,8.59,1.56667,44.8833,80,298),
(46,new String'("Vire-sur-Lot"),46700,380,323,48,7.77,1.08695,44.4909,67,269),
(46,new String'("Villesèque"),46090,392,306,16,23.56,1.3,44.4,199,339),
(46,new String'("Durbans"),46320,129,127,4,27.81,1.76667,44.6667,287,393),
(46,new String'("Bétaille"),46110,1072,827,76,13.99,1.73333,44.95,111,228),
(46,new String'("Salviac"),46340,1263,1069,42,29.61,1.26667,44.6833,124,307),
(46,new String'("Saint-Maurice-en-Quercy"),46120,230,239,17,13.0,1.95,44.75,368,601),
(46,new String'("Castelnau-Montratier"),46170,1847,1851,25,72.54,1.35306,44.2689,108,295),
(46,new String'("Sainte-Colombe"),46120,191,163,16,11.35,2.01667,44.7167,361,612),
(46,new String'("Belmont-Sainte-Foi"),46230,109,105,12,9.01,1.65,44.2833,215,339),
(46,new String'("Reyrevignes"),46320,296,272,23,12.44,1.91667,44.65,282,388),
(46,new String'("Molières"),46120,368,364,28,12.77,1.93528,44.7939,316,603),
(46,new String'("Thégra"),46500,496,418,38,12.82,1.75,44.8167,319,426),
(46,new String'("Floirac"),46600,275,276,14,19.02,1.65,44.9167,90,345),
(46,new String'("Alvignac"),46500,733,572,56,13.05,1.7,44.8333,249,419),
(46,new String'("Issepts"),46320,179,158,19,9.15,1.93333,44.6667,267,444),
(46,new String'("Calamane"),46150,465,383,61,7.6,1.38333,44.5167,139,324),
(46,new String'("Camburat"),46100,446,244,55,8.03,2.01667,44.6333,192,400),
(46,new String'("Reilhac"),46500,172,143,13,12.98,1.71667,44.7,312,396),
(46,new String'("Saint-Sauveur-la-Vallée"),46240,47,43,7,6.7,1.55,44.6,236,435),
(46,new String'("Sonac"),46320,79,80,10,7.34,1.88333,44.7,305,421),
(46,new String'("Saint-Perdoux"),46100,199,198,15,12.53,2.06667,44.6667,260,526),
(46,new String'("Frayssinhes"),46400,198,190,16,12.15,1.95,44.8667,170,542),
(46,new String'("Saint-Caprais"),46250,80,80,9,8.85,1.15833,44.6083,193,299),
(46,new String'("Saint-Jean-Lagineste"),46400,318,250,25,12.66,1.86083,44.8234,251,605),
(46,new String'("Ussel"),46240,76,66,11,6.74,1.5,44.5833,292,421),
(46,new String'("Biars-sur-Cère"),46130,1906,1988,525,3.63,1.86667,44.9333,125,265),
(46,new String'("Saint-Pierre-Lafeuille"),46090,355,292,41,8.52,1.43333,44.5167,154,361),
(46,new String'("Saint-Médard-Nicourby"),46210,88,84,11,7.77,2.05,44.7667,347,608),
(46,new String'("Saint-Vincent-Rive-d'Olt"),46140,491,429,24,19.9,1.28333,44.4667,97,323),
(46,new String'("Saint-Vincent-du-Pendit"),46400,164,186,17,9.24,1.91667,44.8333,170,628),
(46,new String'("Lacam-d'Ourcet"),46190,124,123,8,14.08,2.0,44.85,306,624),
(46,new String'("Lacapelle-Marival"),46120,1328,1251,114,11.61,1.93333,44.7167,353,596),
(46,new String'("Labastide-Murat"),46240,659,689,24,27.27,1.56667,44.65,265,449),
(46,new String'("Flaujac-Gare"),46320,92,70,11,8.09,1.8,44.7167,308,351),
(46,new String'("Saint-Hilaire"),46210,76,88,9,7.93,2.15528,44.775,469,693),
(46,new String'("Gourdon"),46300,4640,4888,101,45.56,1.38333,44.7333,130,323),
(46,new String'("Marminiac"),46250,383,318,16,22.88,1.21667,44.6667,177,343),
(46,new String'("Uzech"),46310,220,196,18,12.21,1.38333,44.5833,213,373),
(46,new String'("Sabadel-Lauzès"),46360,92,114,10,8.79,1.61667,44.5667,198,357),
(46,new String'("Mechmont"),46150,115,104,17,6.71,1.48333,44.5667,236,383),
(46,new String'("Puybrun"),46130,904,726,207,4.36,1.8,44.9167,125,266),
(46,new String'("Maxou"),46090,291,230,23,12.59,1.44167,44.5417,168,382),
(46,new String'("Saint-Cirgues"),46210,379,355,11,32.5,2.11667,44.7333,283,657),
(46,new String'("Saint-Martin-le-Redon"),46700,209,192,19,10.6,1.05,44.5333,86,257),
(46,new String'("Frayssinet-le-Gélat"),46250,383,385,16,23.14,1.16667,44.5833,160,286),
(46,new String'("Laval-de-Cère"),46130,342,324,42,7.98,1.93333,44.95,139,522),
(46,new String'("Cuzance"),46600,547,372,18,29.74,1.55,44.9667,195,326),
(46,new String'("Gindou"),46250,310,265,19,15.65,1.26667,44.6333,163,331),
(46,new String'("Le Vigan"),46300,1476,1077,42,34.4,1.43333,44.75,202,391),
(46,new String'("Calvignac"),46160,202,191,11,17.89,1.8,44.4667,130,351),
(46,new String'("Assier"),46320,684,535,41,16.49,1.88333,44.6667,294,420),
(46,new String'("Prudhomat"),46130,716,643,57,12.39,1.83333,44.9,120,267),
(46,new String'("Grèzes"),46320,162,133,14,11.02,1.81667,44.6167,268,443),
(46,new String'("Saint-Jean-Lespinasse"),46400,434,373,72,5.99,1.86667,44.8667,141,407),
(46,new String'("Nuzéjouls"),46150,335,262,70,4.74,1.36667,44.5333,149,309),
(46,new String'("Saint-Projet"),46300,397,355,25,15.83,1.49056,44.7448,184,407),
(46,new String'("Espère"),46090,1004,873,159,6.31,1.36667,44.5,120,282),
(46,new String'("Saint-Chels"),46160,158,139,8,17.86,1.8,44.5167,157,394),
(46,new String'("Pradines"),46090,3490,3125,211,16.49,1.4,44.4833,100,300),
(46,new String'("Arcambal"),46090,997,737,43,23.11,1.51667,44.45,110,342),
(46,new String'("Cambayrac"),46140,143,119,19,7.39,1.26667,44.4333,140,322),
(46,new String'("Lebreil"),46800,154,131,15,10.2,1.18333,44.3333,127,278),
(46,new String'("Valprionde"),46800,129,152,8,15.92,1.11667,44.3667,167,285),
(46,new String'("Saint-Paul-de-Loubressac"),46170,562,430,27,20.19,1.44833,44.2973,134,285),
(46,new String'("Souillac"),46200,3817,3673,147,25.92,1.48333,44.9,80,314),
(46,new String'("Junies"),46150,251,264,19,13.06,1.25,44.5333,100,296),
(46,new String'("Loupiac"),46350,270,267,21,12.65,1.46083,44.8178,99,294),
(46,new String'("Payrignac"),46300,696,595,32,21.64,1.35,44.75,95,232),
(46,new String'("Espeyroux"),46120,96,106,12,7.64,1.93333,44.7667,395,627),
(46,new String'("Cambes"),46100,331,286,50,6.57,1.95,44.6167,236,365),
(46,new String'("Fons"),46100,393,342,26,14.95,1.96667,44.65,212,425),
(46,new String'("Luzech"),46140,1679,1640,75,22.13,1.28333,44.4833,84,323),
(46,new String'("Caniac-du-Causse"),46240,339,246,9,35.0,1.63333,44.6167,309,465),
(46,new String'("Montfaucon"),46240,526,403,20,26.18,1.56667,44.6833,260,423),
(46,new String'("Séniergues"),46240,133,112,7,18.17,1.55,44.7,223,425),
(46,new String'("Lentillac-du-Causse"),46330,110,91,8,13.68,1.63333,44.55,160,353),
(46,new String'("Dégagnac"),46340,607,507,16,37.9,1.31667,44.6667,140,306),
(46,new String'("Espagnac-Sainte-Eulalie"),46320,85,73,8,9.75,1.88333,44.5833,161,426),
(46,new String'("Lentillac-Saint-Blaise"),46100,138,136,24,5.75,2.13333,44.6,175,381),
(46,new String'("Aujols"),46090,307,243,18,16.43,1.56667,44.4167,131,270),
(46,new String'("Varaire"),46260,306,268,11,25.52,1.73333,44.35,220,404),
(46,new String'("Calviac"),46190,165,202,6,26.49,2.06667,44.9167,515,691),
(46,new String'("Douelle"),46140,823,733,93,8.77,1.36667,44.4667,100,310),
(46,new String'("Lamothe-Fénelon"),46350,338,320,24,13.99,1.41667,44.8333,109,262),
(46,new String'("Pomarède"),46250,186,144,26,7.04,1.18333,44.5667,154,285),
(46,new String'("Rocamadour"),46500,675,614,13,49.42,1.63333,44.8,110,364),
(46,new String'("Sousceyrac"),46190,907,988,15,57.64,2.03333,44.8667,399,745),
(46,new String'("Padirac"),46500,189,169,21,8.86,1.75,44.8333,318,426),
(46,new String'("Terrou"),46120,189,202,19,9.94,2.0,44.7833,273,570),
(46,new String'("Teyssieu"),46190,187,196,13,13.63,1.96667,44.9167,233,566),
(46,new String'("Montcléra"),46250,273,291,13,20.91,1.23333,44.6167,154,311),
(46,new String'("Bélaye"),46140,218,216,11,18.69,1.2,44.4667,80,274),
(46,new String'("Saint-Denis-Catus"),46150,205,193,19,10.78,1.38333,44.5667,170,337),
(46,new String'("Belmont-Bretenoux"),46130,354,323,53,6.65,1.88333,44.8833,146,406),
(46,new String'("Cahors"),46000,20194,20022,312,64.72,1.43333,44.4333,105,332),
(46,new String'("Espédaillac"),46320,261,241,7,34.93,1.78333,44.6333,255,444),
(46,new String'("Puy-l'Évêque"),46700,2106,2159,79,26.38,1.13333,44.5,80,284),
(46,new String'("Planioles"),46100,488,385,83,5.85,2.05,44.6333,217,490),
(46,new String'("Marcilhac-sur-Célé"),46160,197,194,7,27.35,1.76667,44.55,140,391),
(46,new String'("Boissières"),46150,372,312,28,13.03,1.4,44.5333,150,331),
(46,new String'("Cazillac"),46600,422,345,22,19.02,1.61667,45.0,126,313),
(46,new String'("Lachapelle-Auzac"),46200,764,803,24,31.34,1.48333,44.9333,100,312),
(46,new String'("Valroufié"),46090,425,352,31,13.48,1.49167,44.5167,140,361),
(46,new String'("Mercuès"),46090,1054,736,145,7.24,1.38333,44.5,101,303),
(46,new String'("Cénevières"),46330,179,161,11,15.69,1.75,44.4667,129,351),
(46,new String'("Catus"),46150,920,909,43,21.32,1.33333,44.55,130,341),
(46,new String'("Berganty"),46090,102,93,14,6.98,1.65,44.45,274,377),
(46,new String'("Gréalou"),46160,254,224,14,17.5,1.9,44.5333,197,402),
(46,new String'("Saint-Pierre-Toirac"),46160,149,122,25,5.83,1.96667,44.5333,153,375),
(46,new String'("Saint-Martin-Labouval"),46330,178,180,13,13.49,1.73333,44.4667,129,384),
(46,new String'("Belmontet"),46800,147,140,12,12.12,1.16667,44.3667,181,300),
(46,new String'("Vayrac"),46110,1333,1188,81,16.33,1.7,44.95,110,312),
(46,new String'("Fajoles"),46300,262,211,29,8.98,1.38333,44.8,118,213),
(46,new String'("Concots"),46260,418,372,16,26.02,1.63333,44.4167,195,368),
(46,new String'("Carennac"),46110,389,373,20,19.0,1.73333,44.9167,110,340),
(46,new String'("Labathude"),46120,189,175,18,10.05,2.0,44.75,370,613),
(46,new String'("Gorses"),46210,344,357,9,35.6,2.05,44.7833,234,692),
(46,new String'("Béduer"),46100,740,623,29,24.78,1.96667,44.5833,176,405),
(46,new String'("Saint-Félix"),46100,475,280,61,7.73,2.11667,44.6167,182,393),
(46,new String'("Bannes"),46400,137,166,13,10.11,1.91667,44.8,272,595),
(46,new String'("Grézels"),46700,243,265,22,10.79,1.16667,44.4667,80,256),
(46,new String'("Goujounac"),46250,229,197,22,10.38,1.21667,44.5667,130,306),
(46,new String'("Lamothe-Cassel"),46240,97,105,8,11.35,1.51667,44.6167,269,444),
(46,new String'("Gignac"),46600,640,564,15,40.66,1.45,45.0,153,356),
(46,new String'("Orniac"),46330,86,90,5,16.79,1.66667,44.5333,130,364),
(46,new String'("Calès"),46350,168,150,4,34.23,1.55,44.8,99,295),
(46,new String'("Vaillac"),46240,96,107,7,13.68,1.53333,44.6667,239,422),
(46,new String'("Cras"),46360,93,75,9,10.22,1.53333,44.5667,170,383),
(46,new String'("Anglars"),46120,176,161,17,9.99,1.91667,44.7333,328,561),
(46,new String'("Felzins"),46270,387,300,25,15.0,2.13333,44.6167,216,423),
(46,new String'("Tauriac"),46130,387,330,47,8.23,1.77583,44.9064,114,169),
(46,new String'("Saint-Cernin"),46360,194,160,11,16.28,1.58333,44.5833,227,464),
(46,new String'("Leyme"),46120,961,941,94,10.16,1.91667,44.7833,407,616),
(46,new String'("Limogne-en-Quercy"),46260,796,724,24,32.31,1.77028,44.3975,214,403),
(46,new String'("Floressas"),46700,154,140,11,13.84,1.13333,44.45,95,286),
(46,new String'("Tour-de-Faure"),46330,400,350,45,8.77,1.7,44.4667,127,375),
(46,new String'("Saint-Laurent-Lolmie"),46800,195,202,18,10.81,1.22833,44.292,127,270),
(46,new String'("Montdoumerc"),46230,437,355,32,13.62,1.51667,44.2833,176,282),
(46,new String'("Fontanès"),46230,456,371,27,16.44,1.5,44.3167,199,296),
(46,new String'("Flaujac-Poujols"),46090,698,584,55,12.64,1.5,44.4167,144,295),
(46,new String'("Cours"),46090,300,233,17,17.05,1.55,44.5167,140,364),
(46,new String'("Le Roc"),46200,230,202,33,6.95,1.43333,44.8667,84,324),
(46,new String'("Strenquels"),46110,273,222,30,9.01,1.65,44.9833,114,336),
(46,new String'("Sabadel-Latronquière"),46210,87,89,7,12.29,2.08333,44.7333,329,633),
(47,new String'("Roumagne"),47800,553,525,52,10.54,0.333333,44.6167,35,115),
(47,new String'("Cocumont"),47250,974,888,38,25.44,0.033333,44.45,33,148),
(47,new String'("Argenton"),47250,335,268,27,12.14,0.1,44.3833,45,169),
(47,new String'("Granges-sur-Lot"),47260,580,540,138,4.19,0.466667,44.3833,32,64),
(47,new String'("Engayrac"),47470,144,158,14,10.03,0.9,44.2667,110,227),
(47,new String'("Saint-Géraud"),47120,80,66,14,5.68,0.166667,44.6167,47,132),
(47,new String'("Port-Sainte-Marie"),47130,1963,1749,103,18.94,0.4,44.25,27,216),
(47,new String'("Birac-sur-Trec"),47200,801,672,55,14.34,0.266667,44.5,28,129),
(47,new String'("Sauvagnas"),47340,471,417,34,13.57,0.75,44.25,86,209),
(47,new String'("Pompiey"),47230,227,201,11,19.61,0.216667,44.1833,73,191),
(47,new String'("Montesquieu"),47130,780,713,30,25.53,0.45,44.2,30,163),
(47,new String'("Castelnaud-de-Gratecambe"),47290,554,517,32,17.23,0.666667,44.5,80,214),
(47,new String'("Caubon-Saint-Sauveur"),47120,234,241,20,11.34,0.2,44.5833,42,132),
(47,new String'("Allemans-du-Dropt"),47800,481,447,75,6.4,0.283333,44.6333,33,89),
(47,new String'("Sauveterre-Saint-Denis"),47220,450,421,54,8.25,0.7,44.1667,45,53),
(47,new String'("Sainte-Maure-de-Peyriac"),47170,337,326,14,23.06,0.15,44.0,64,164),
(47,new String'("Clermont-Dessous"),47130,797,725,52,15.08,0.416667,44.25,30,190),
(47,new String'("Romestaing"),47250,147,154,9,15.46,0.00305556,44.4167,56,167),
(47,new String'("Cuzorn"),47500,878,870,37,23.34,0.95,44.55,76,242),
(47,new String'("Allez-et-Cazeneuve"),47110,666,579,62,10.69,0.616667,44.4,59,202),
(47,new String'("Virazeil"),47200,1669,1586,83,19.87,0.216667,44.5,31,127),
(47,new String'("Nicole"),47190,273,295,57,4.78,0.35,44.3333,22,163),
(47,new String'("Montpezat"),47360,582,594,24,24.19,0.516667,44.35,37,200),
(47,new String'("Saint-Jean-de-Duras"),47120,243,226,14,16.56,0.3,44.6833,60,173),
(47,new String'("Monclar"),47380,838,860,34,24.02,0.525833,44.447,54,191),
(47,new String'("Paulhiac"),47150,318,225,14,21.89,0.633333,44.4333,83,183),
(47,new String'("Sainte-Gemme-Martaillac"),47250,343,279,24,14.0,0.15,44.3667,58,156),
(47,new String'("Bon-Encontre"),47240,6093,5758,296,20.56,0.683333,44.1833,48,209),
(47,new String'("Couthures-sur-Garonne"),47200,390,399,55,6.98,0.083333,44.5167,12,22),
(47,new String'("Fals"),47220,355,290,37,9.4,0.666667,44.1,49,176),
(47,new String'("Saint-Vite"),47500,1219,1230,222,5.47,0.966667,44.4833,57,105),
(47,new String'("Sauveterre-la-Lémance"),47500,586,623,24,23.46,1.01667,44.5833,115,284),
(47,new String'("Saint-Pierre-de-Buzet"),47160,270,218,31,8.52,0.266667,44.25,32,160),
(47,new String'("Andiran"),47170,223,226,22,9.89,0.266667,44.1,43,123),
(47,new String'("Ambrus"),47160,99,71,8,12.35,0.233333,44.2167,68,175),
(47,new String'("Dévillac"),47210,133,121,14,9.25,0.8,44.6,96,191),
(47,new String'("Houeillès"),47420,633,643,9,67.63,0.033333,44.2,97,153),
(47,new String'("Esclottes"),47120,156,172,16,9.24,0.166667,44.7,38,117),
(47,new String'("Lavardac"),47230,2285,2265,151,15.1,0.3,44.1833,30,168),
(47,new String'("Moirax"),47310,1147,999,70,16.2,0.6,44.15,41,183),
(47,new String'("Lalandusse"),47330,197,184,21,9.37,0.533333,44.65,56,143),
(47,new String'("Saint-Avit"),47350,167,152,18,8.95,0.216667,44.5667,45,123),
(47,new String'("Saint-Sernin"),47120,429,396,20,21.07,0.233333,44.7,42,127),
(47,new String'("Ruffiac"),47700,176,0,13,12.84,0.033333,44.3667,59,168),
(47,new String'("Saint-Étienne-de-Villeréal"),47210,292,267,19,14.62,0.766667,44.6167,88,191),
(47,new String'("Fieux"),47600,339,274,22,14.85,0.416667,44.1,58,189),
(47,new String'("Jusix"),47200,113,114,15,7.5,0.066667,44.5333,12,19),
(47,new String'("Caumont-sur-Garonne"),47430,627,544,54,11.61,0.2,44.45,17,86),
(47,new String'("Chapelle"),47350,87,92,19,4.53,0.266667,44.5667,52,132),
(47,new String'("Vergne"),47800,603,545,30,19.96,0.4,44.5833,47,127),
(47,new String'("Saint-Martin-de-Villeréal"),47210,126,93,15,8.22,0.833333,44.6333,94,201),
(47,new String'("La Sauvetat-sur-Lède"),47150,646,452,45,14.14,0.733333,44.4667,60,184),
(47,new String'("Foulayronnes"),47510,5024,4597,174,28.86,0.666667,44.2333,44,206),
(47,new String'("Marmont-Pachas"),47220,130,91,16,7.96,0.583333,44.1,103,196),
(47,new String'("Auriac-sur-Dropt"),47120,208,186,39,5.28,0.233333,44.65,29,110),
(47,new String'("Cancon"),47290,1334,1287,54,24.49,0.616667,44.5333,90,217),
(47,new String'("Sainte-Marthe"),47430,498,382,51,9.65,0.166667,44.4,28,94),
(47,new String'("Tonneins"),47400,8965,9041,257,34.78,0.316667,44.3833,21,166),
(47,new String'("Thouars-sur-Garonne"),47230,210,179,52,4.03,0.333333,44.2333,27,39),
(47,new String'("Mauvezin-sur-Gupie"),47200,504,0,31,15.8,0.15,44.55,31,122),
(47,new String'("Allons"),47420,176,172,2,76.33,-0.05,44.2,98,156),
(47,new String'("Saint-Pastour"),47290,393,361,27,14.52,0.6,44.4833,62,196),
(47,new String'("Fargues-sur-Ourbise"),47700,366,287,8,44.16,0.15,44.2333,89,175),
(47,new String'("Saint-Barthélemy-d'Agenais"),47350,517,491,33,15.28,0.366667,44.5167,52,131),
(47,new String'("La Croix-Blanche"),47340,843,746,64,13.05,0.683333,44.3,97,236),
(47,new String'("Loubès-Bernac"),47120,369,310,19,19.31,0.283333,44.7167,74,187),
(47,new String'("Moncaut"),47310,558,422,35,15.76,0.5,44.15,63,202),
(47,new String'("Gaujac"),47200,283,303,38,7.33,0.116667,44.5,13,22),
(47,new String'("Pardaillan"),47120,331,312,16,19.71,0.283333,44.65,34,134),
(47,new String'("Montastruc"),47380,277,276,11,24.88,0.516667,44.4833,62,195),
(47,new String'("Montaut"),47210,237,207,16,14.19,0.670556,44.6039,79,190),
(47,new String'("Massoulès"),47140,208,177,26,7.86,0.883333,44.35,117,234),
(47,new String'("Saint-Antoine-de-Ficalba"),47340,674,556,61,10.93,0.716667,44.3333,108,231),
(47,new String'("Saint-Pardoux-du-Breuil"),47200,591,576,80,7.3,0.216667,44.4833,19,35),
(47,new String'("Leyritz-Moncassin"),47700,217,218,10,20.24,0.183333,44.3167,45,175),
(47,new String'("Brugnac"),47260,203,167,13,14.74,0.433333,44.45,49,172),
(47,new String'("Massels"),47140,112,91,18,6.17,0.866667,44.3167,97,229),
(47,new String'("Puch-d'Agenais"),47160,719,652,31,23.0,0.25,44.3167,27,123),
(47,new String'("Sembas"),47360,134,149,10,12.51,0.65,44.3333,124,224),
(47,new String'("Frespech"),47140,290,271,24,11.7,0.833333,44.3167,88,230),
(47,new String'("Anthé"),47370,189,208,13,13.93,0.95,44.3833,92,252),
(47,new String'("Clairac"),47320,2451,2385,72,33.78,0.383333,44.35,27,185),
(47,new String'("Saint-Martin-Curton"),47700,298,266,7,41.48,0.016667,44.3167,95,156),
(47,new String'("Douzains"),47330,279,244,22,12.66,0.533333,44.6333,65,151),
(47,new String'("Doudrac"),47210,104,101,12,8.61,0.683333,44.65,70,115),
(47,new String'("Razimet"),47160,243,214,33,7.18,0.233333,44.35,36,101),
(47,new String'("Montauriol"),47330,202,223,20,9.92,0.566667,44.6167,74,152),
(47,new String'("Brax"),47310,1827,1623,207,8.8,0.533333,44.2,35,60),
(47,new String'("Pujols"),47300,3626,3546,145,24.98,0.683333,44.4,65,211),
(47,new String'("Colayrac-Saint-Cirq"),47450,2863,2717,134,21.36,0.566667,44.2167,32,187),
(47,new String'("Lacépède"),47360,295,246,26,11.33,0.466667,44.3333,53,207),
(47,new String'("Cavarc"),47330,137,147,11,11.99,0.633333,44.6833,67,143),
(47,new String'("Lagarrigue"),47190,282,269,64,4.38,0.383333,44.3,48,175),
(47,new String'("Penne-d'Agenais"),47140,2402,2331,51,46.71,0.833333,44.3833,52,231),
(47,new String'("Cuq"),47220,283,254,16,16.89,0.7,44.0833,63,180),
(47,new String'("Pont-du-Casse"),47480,4351,4256,227,19.1,0.683333,44.2333,53,204),
(47,new String'("Savignac-de-Duras"),47120,227,217,15,14.89,0.2,44.7,35,126),
(47,new String'("Bourran"),47320,591,578,32,18.16,0.4,44.3333,27,145),
(47,new String'("Gavaudun"),47150,305,316,14,21.33,0.9,44.5667,105,243),
(47,new String'("Monviel"),47290,85,77,13,6.23,0.533333,44.5667,76,162),
(47,new String'("Lamontjoie"),47310,501,456,28,17.75,0.533333,44.0667,87,201),
(47,new String'("Tombebœuf"),47380,453,424,24,18.38,0.45,44.5,57,162),
(47,new String'("Sérignac-Péboudou"),47410,175,169,14,12.12,0.55,44.6,69,185),
(47,new String'("Agen"),47000,33981,30199,2957,11.49,0.633333,44.2,37,162),
(47,new String'("Saint-Vincent-de-Lamontjoie"),47310,257,197,16,15.29,0.5,44.0833,69,195),
(47,new String'("Bourgougnague"),47410,277,233,23,11.73,0.416667,44.6167,53,131),
(47,new String'("Fauillet"),47400,859,815,60,14.23,0.283333,44.4167,23,88),
(47,new String'("Saint-Romain-le-Noble"),47270,394,416,46,8.5,0.783333,44.1667,45,181),
(47,new String'("Monbalen"),47340,412,346,31,13.0,0.716667,44.3167,93,230),
(47,new String'("Lannes"),47170,409,428,12,32.4,0.283333,44.0333,58,171),
(47,new String'("Fauguerolles"),47400,653,560,94,6.93,0.25,44.4333,21,36),
(47,new String'("Layrac"),47390,3552,3146,93,38.11,0.666667,44.1333,43,182),
(47,new String'("Bias"),47300,3186,2955,259,12.29,0.683333,44.4167,42,76),
(47,new String'("Hautesvignes"),47400,163,141,18,8.85,0.35,44.4667,48,142),
(47,new String'("Villebramar"),47380,103,96,10,10.06,0.483333,44.5167,62,147),
(47,new String'("Casseneuil"),47440,2335,2296,129,18.09,0.616667,44.45,38,204),
(47,new String'("Villeneuve-sur-Lot"),47300,23513,22801,289,81.32,0.716667,44.4,42,209),
(47,new String'("Cauzac"),47470,385,365,26,14.52,0.85,44.2833,75,221),
(47,new String'("Calonges"),47430,589,521,36,15.99,0.233333,44.3667,26,94),
(47,new String'("Caudecoste"),47220,933,911,54,17.13,0.733333,44.1167,46,120),
(47,new String'("La Sauvetat-de-Savères"),47270,527,349,76,6.86,0.833333,44.2333,64,194),
(47,new String'("Dolmayrac"),47110,647,525,33,19.4,0.583333,44.3667,50,219),
(47,new String'("Bruch"),47130,773,725,48,15.89,0.416667,44.2167,35,159),
(47,new String'("Castillonnès"),47330,1404,1324,72,19.4,0.6,44.65,62,145),
(47,new String'("Montagnac-sur-Auvignon"),47600,599,498,26,22.69,0.466667,44.15,48,196),
(47,new String'("Puysserampion"),47800,246,243,22,10.72,0.3,44.6,44,116),
(47,new String'("Sauméjan"),47420,80,68,4,19.5,-0.00388889,44.2333,103,147),
(47,new String'("Casteljaloux"),47700,4761,4763,155,30.59,0.1,44.3167,55,168),
(47,new String'("Astaffort"),47220,2077,1881,59,35.17,0.666667,44.0667,52,215),
(47,new String'("Tourliac"),47210,146,97,14,9.83,0.816667,44.6833,97,211),
(47,new String'("Laplume"),47310,1402,1204,42,32.64,0.533333,44.1167,69,218),
(47,new String'("Roquefort"),47310,1767,1197,234,7.53,0.55,44.1833,53,156),
(47,new String'("Boé"),47550,5421,4504,328,16.5,0.633333,44.1667,37,59),
(47,new String'("Nomdieu"),47600,221,200,17,12.59,0.483333,44.1,64,142),
(47,new String'("Ferrensac"),47330,222,163,18,12.32,0.616667,44.6333,65,151),
(47,new String'("Réaup-Lisse"),47170,587,523,8,70.89,0.186944,44.0906,43,174),
(47,new String'("Soumensac"),47120,244,215,21,11.42,0.316667,44.6833,42,175),
(47,new String'("Barbaste"),47230,1500,1415,38,38.7,0.283333,44.1667,38,146),
(47,new String'("Gontaud-de-Nogaret"),47400,1634,1537,55,29.51,0.295,44.4564,26,132),
(47,new String'("Villeréal"),47210,1314,1186,94,13.92,0.75,44.6333,78,168),
(47,new String'("Savignac-sur-Leyze"),47150,279,273,24,11.38,0.8,44.4833,70,153),
(47,new String'("Villefranche-du-Queyran"),47160,405,360,24,16.55,0.2,44.3,45,182),
(47,new String'("Lédat"),47300,1260,895,101,12.43,0.667778,44.4542,42,180),
(47,new String'("Grateloup-Saint-Gayrand"),47400,439,414,21,20.67,0.383333,44.4167,42,172),
(47,new String'("Marcellus"),47200,802,699,68,11.77,0.083333,44.4833,15,82),
(47,new String'("Vianne"),47230,1128,1224,114,9.82,0.316667,44.2,28,134),
(47,new String'("Dondas"),47470,207,231,14,14.37,0.85,44.25,75,222),
(47,new String'("Sainte-Bazeille"),47200,3044,2656,147,20.67,0.1,44.5333,12,87),
(47,new String'("Durance"),47420,281,270,7,38.6,0.166667,44.1667,111,166),
(47,new String'("Cahuzac"),47330,294,281,36,8.04,0.55,44.6667,58,144),
(47,new String'("Mézin"),47170,1504,1464,47,31.58,0.266667,44.05,49,166),
(47,new String'("Duras"),47120,1316,1215,65,20.17,0.183333,44.6667,28,128),
(47,new String'("Calignac"),47600,480,373,26,18.38,0.433333,44.1333,51,187),
(47,new String'("Meilhan-sur-Garonne"),47200,1327,1253,46,28.62,0.033333,44.5167,12,90),
(47,new String'("Clermont-Soubiran"),47270,367,333,35,10.39,0.831944,44.1406,45,188),
(47,new String'("Saint-Georges"),47370,533,560,33,15.96,0.933889,44.442,55,158),
(47,new String'("Castelmoron-sur-Lot"),47260,1754,1663,75,23.25,0.5,44.4,32,195),
(47,new String'("Saint-Maurice-de-Lestapel"),47290,112,102,14,7.79,0.566667,44.5667,84,170),
(47,new String'("Trentels"),47140,820,825,42,19.47,0.866667,44.4333,52,222),
(47,new String'("Le Passage"),47520,9395,8811,728,12.89,0.616667,44.2,36,110),
(47,new String'("Samazan"),47250,852,748,49,17.25,0.116667,44.4333,24,133),
(47,new String'("Varès"),47400,647,691,38,16.79,0.366667,44.45,35,137),
(47,new String'("Xaintrailles"),47230,413,397,40,10.26,0.25,44.2,80,196),
(47,new String'("Montignac-Toupinerie"),47350,138,111,16,8.31,0.35,44.55,60,137),
(47,new String'("La Sauvetat-du-Dropt"),47800,566,465,54,10.37,0.333333,44.65,36,123),
(47,new String'("Cambes"),47350,166,162,18,9.2,0.283333,44.5833,44,132),
(47,new String'("Moulinet"),47290,195,216,13,14.57,0.566667,44.5333,83,170),
(47,new String'("Saint-Étienne-de-Fougères"),47380,843,732,85,9.9,0.55,44.4167,37,90),
(47,new String'("Blanquefort-sur-Briolance"),47500,515,491,12,41.93,0.966667,44.6,104,274),
(47,new String'("Marmande"),47200,18400,17194,408,45.06,0.166667,44.5,12,132),
(47,new String'("Cazideroque"),47370,239,264,20,11.94,0.933333,44.4,80,237),
(47,new String'("Boussès"),47420,42,41,0,47.14,0.1,44.1333,115,161),
(47,new String'("Sérignac-sur-Garonne"),47310,1122,868,125,8.91,0.5,44.2167,32,117),
(47,new String'("Poussignac"),47700,294,213,22,13.02,0.05,44.35,51,151),
(47,new String'("Anzex"),47700,285,254,12,23.24,0.166667,44.2833,58,172),
(47,new String'("Fourques-sur-Garonne"),47200,1238,1178,88,13.96,0.183333,44.45,18,77),
(47,new String'("Frégimont"),47360,270,189,35,7.59,0.466667,44.2833,57,200),
(47,new String'("Le Mas-d'Agenais"),47430,1427,1330,67,21.18,0.216667,44.4,17,120),
(47,new String'("Saint-Colomb-de-Lauzun"),47410,502,434,21,23.19,0.466667,44.6,67,136),
(47,new String'("Lévignac-de-Guyenne"),47120,609,650,24,25.02,0.2,44.6333,32,122),
(47,new String'("Moustier"),47800,336,302,40,8.33,0.3,44.6333,35,113),
(47,new String'("La Réunion"),47700,457,443,16,28.06,0.117778,44.2975,78,172),
(47,new String'("Saint-Hilaire-de-Lusignan"),47450,1404,1300,83,16.77,0.5125,44.2264,32,196),
(47,new String'("Tournon-d'Agenais"),47370,771,753,36,21.26,1.0,44.4,103,261),
(47,new String'("Galapian"),47190,326,285,35,9.25,0.416667,44.3,44,180),
(47,new String'("Saint-Sardos"),47360,334,242,23,14.46,0.483333,44.35,42,187),
(47,new String'("Pindères"),47700,231,202,5,40.76,0.033333,44.2667,73,143),
(47,new String'("Sainte-Colombe-en-Bruilhois"),47310,1656,1345,78,21.15,0.516667,44.1833,35,168),
(47,new String'("Saint-Laurent"),47130,486,503,110,4.4,0.4,44.247,30,40),
(47,new String'("Aubiac"),47310,1014,907,73,13.86,0.583333,44.1333,69,180),
(47,new String'("Monbahus"),47290,629,642,19,31.97,0.533333,44.55,67,190),
(47,new String'("Bournel"),47210,261,250,17,14.7,0.666667,44.6167,72,161),
(47,new String'("Laussou"),47150,278,234,16,17.15,0.816667,44.5833,75,200),
(47,new String'("Saint-Martin-de-Beauville"),47270,173,123,22,7.54,0.818056,44.227,70,201),
(47,new String'("Monflanquin"),47150,2373,2259,38,62.21,0.766667,44.5333,64,207),
(47,new String'("Buzet-sur-Baïse"),47160,1276,1236,60,21.15,0.299167,44.2581,22,143),
(47,new String'("Verteuil-d'Agenais"),47260,558,544,24,22.42,0.416667,44.4667,43,137),
(47,new String'("Puymiclan"),47350,570,568,22,25.74,0.316667,44.5167,42,126),
(47,new String'("Saint-Aubin"),47150,429,420,23,18.51,0.8525,44.4762,74,219),
(47,new String'("Sainte-Livrade-sur-Lot"),47110,6290,5866,203,30.94,0.6,44.4,37,194),
(47,new String'("Pailloles"),47440,338,281,36,9.16,0.633333,44.4667,54,180),
(47,new String'("Puymirol"),47270,965,864,49,19.54,0.783333,44.1833,57,191),
(47,new String'("Antagnac"),47700,221,333,23,9.31,0.016667,44.35,106,152),
(47,new String'("Moncrabeau"),47600,825,780,16,49.94,0.366667,44.0333,52,185),
(47,new String'("Courbiac"),47370,110,112,12,9.05,1.05,44.3833,136,272),
(47,new String'("Agnac"),47800,441,388,31,13.84,0.366667,44.65,39,125),
(47,new String'("Rives"),47210,240,216,18,12.79,0.75,44.65,79,123),
(47,new String'("Lafox"),47240,1163,817,222,5.23,0.7,44.1667,45,146),
(47,new String'("Castelnau-sur-Gupie"),47200,827,681,54,15.23,0.15,44.55,28,129),
(47,new String'("Salles"),47150,318,257,14,21.58,0.871111,44.5492,84,196),
(47,new String'("Saint-Urcisse"),47270,230,161,21,10.93,0.833333,44.1667,59,186),
(47,new String'("Fumel"),47500,5162,5413,227,22.66,0.966667,44.5,56,207),
(47,new String'("Lacapelle-Biron"),47150,457,429,32,13.96,0.9,44.6,145,243),
(47,new String'("Montpouillan"),47200,672,557,55,12.07,0.116667,44.4833,18,133),
(47,new String'("Saint-Caprais-de-Lerm"),47270,602,476,44,13.6,0.75,44.2167,58,195),
(47,new String'("Masquières"),47370,185,126,15,12.31,1.05,44.4167,149,263),
(47,new String'("Thézac"),47370,196,162,17,11.21,1.01667,44.4333,120,257),
(47,new String'("Estillac"),47310,1904,1307,239,7.94,0.55,44.1667,54,164),
(47,new String'("Laparade"),47260,445,408,27,16.22,0.45,44.3833,32,192),
(47,new String'("Mongaillard"),47230,187,171,21,8.53,0.283333,44.2,50,163),
(47,new String'("Aiguillon"),47190,4320,4220,152,28.28,0.35,44.3,22,168),
(47,new String'("Beaugas"),47290,345,349,15,22.48,0.583333,44.5,81,220),
(47,new String'("Montignac-de-Lauzun"),47800,281,282,13,20.46,0.466667,44.5667,61,147),
(47,new String'("Castella"),47340,334,314,26,12.52,0.683333,44.3167,109,232),
(47,new String'("Hautefage-la-Tour"),47340,812,655,39,20.75,0.8,44.3167,70,217),
(47,new String'("Auradou"),47140,383,258,34,11.17,0.816667,44.35,69,222),
(47,new String'("Saint-Léon"),47160,298,258,31,9.6,0.233333,44.2833,52,157),
(47,new String'("Parranquet"),47210,123,121,12,9.62,0.816667,44.65,96,210),
(47,new String'("Lougratte"),47290,449,393,21,20.45,0.616667,44.5833,82,183),
(47,new String'("Ségalas"),47410,167,169,13,12.84,0.533333,44.5833,77,153),
(47,new String'("Tourtrès"),47380,142,121,12,11.71,0.433333,44.5,59,171),
(47,new String'("Miramont-de-Guyenne"),47800,3276,3357,196,16.66,0.366667,44.6,42,120),
(47,new String'("Saint-Salvy"),47360,176,187,19,9.26,0.433333,44.3,63,184),
(47,new String'("Monheurt"),47160,223,251,19,11.44,0.3,44.3333,22,32),
(47,new String'("Agmé"),47350,141,102,28,5.01,0.333333,44.4833,48,116),
(47,new String'("Seyches"),47350,1017,868,41,24.69,0.3,44.55,46,133),
(47,new String'("Monsempron-Libos"),47500,2051,2135,226,9.05,0.933333,44.4833,59,155),
(47,new String'("Prayssas"),47360,948,919,35,26.48,0.5,44.2833,66,207),
(47,new String'("Coulx"),47260,243,248,14,16.32,0.483333,44.4667,50,182),
(47,new String'("Condezaygues"),47500,857,837,79,10.81,0.916667,44.4833,56,172),
(47,new String'("Montayral"),47500,2876,2935,117,24.54,0.983333,44.4833,57,227),
(47,new String'("Saint-Robert"),47340,188,175,27,6.74,0.8,44.25,82,213),
(47,new String'("Saint-Léger"),47160,169,162,29,5.79,0.316667,44.2833,22,34),
(47,new String'("Saint-Sauveur-de-Meilhan"),47200,314,245,44,7.03,-0.00222222,44.475,23,132),
(47,new String'("Grayssas"),47270,127,118,13,9.37,0.883333,44.1667,64,195),
(47,new String'("Bourlens"),47370,357,353,23,15.44,0.966667,44.4167,96,235),
(47,new String'("Armillac"),47800,193,141,24,7.77,0.383333,44.55,60,139),
(47,new String'("Castelculier"),47240,2315,1697,154,14.95,0.716667,44.1833,49,177),
(47,new String'("Pompogne"),47420,194,138,5,35.96,0.05,44.25,77,147),
(47,new String'("Damazan"),47160,1281,1237,78,16.37,0.283333,44.2833,28,147),
(47,new String'("Dausse"),47140,501,431,72,6.94,0.9,44.3833,73,225),
(47,new String'("Laugnac"),47360,633,545,36,17.35,0.6,44.3167,90,246),
(47,new String'("Tayrac"),47270,329,320,25,12.89,0.85,44.2,62,193),
(47,new String'("Grézet-Cavagnan"),47250,352,256,28,12.55,0.133333,44.3833,39,157),
(47,new String'("Labretonie"),47350,175,159,14,11.8,0.366667,44.4833,49,138),
(47,new String'("Saint-Jean-de-Thurac"),47270,502,408,98,5.12,0.75,44.1667,45,186),
(47,new String'("Le Temple-sur-Lot"),47110,971,969,57,16.91,0.533333,44.3667,32,190),
(47,new String'("Sos"),47170,713,643,13,52.89,0.15,44.0333,63,162),
(47,new String'("Saint-Sixte"),47220,329,282,55,5.92,0.783333,44.1284,45,71),
(47,new String'("Nérac"),47600,7125,6786,113,62.68,0.35,44.1333,38,191),
(47,new String'("Saint-Pierre-de-Clairac"),47270,831,721,63,13.15,0.766667,44.1833,52,177),
(47,new String'("Laroque-Timbaut"),47340,1516,1322,70,21.64,0.766667,44.2833,87,222),
(47,new String'("Beaupuy"),47200,1480,1028,181,8.17,0.166667,44.5333,28,103),
(47,new String'("Lagupie"),47200,655,489,75,8.69,0.133333,44.55,20,121),
(47,new String'("Lasserre"),47600,77,82,11,6.49,0.391389,44.0648,52,152),
(47,new String'("Pinel-Hauterive"),47380,525,461,24,21.77,0.566667,44.4333,37,204),
(47,new String'("Bazens"),47130,530,480,43,12.21,0.416667,44.2667,30,200),
(47,new String'("Villeton"),47400,527,519,51,10.24,0.266667,44.35,22,43),
(47,new String'("Madaillan"),47360,614,501,25,24.39,0.573889,44.277,61,225),
(47,new String'("Peyrière"),47350,279,242,34,8.14,0.316667,44.5667,63,132),
(47,new String'("Montagnac-sur-Lède"),47150,252,267,12,19.55,0.85,44.55,85,231),
(47,new String'("Guérin"),47250,246,234,23,10.43,0.083333,44.4,57,146),
(47,new String'("Sénestis"),47430,201,200,17,11.31,0.233333,44.4167,17,28),
(47,new String'("Fréchou"),47600,207,249,17,11.97,0.316667,44.0833,52,142),
(47,new String'("Poudenas"),47170,247,252,14,17.24,0.216667,44.05,59,162),
(47,new String'("Saint-Pé-Saint-Simon"),47170,222,210,12,17.46,0.101667,44.0025,73,161),
(47,new String'("Saint-Martin-Petit"),47200,433,357,67,6.39,0.1,44.55,15,114),
(47,new String'("Bouglon"),47250,613,528,44,13.92,0.1,44.3833,35,143),
(47,new String'("Lagruère"),47400,341,319,34,9.86,0.233333,44.3833,22,44),
(47,new String'("Saint-Sylvestre-sur-Lot"),47140,2269,2062,106,21.27,0.816667,44.4,52,218),
(47,new String'("Trémons"),47140,377,340,27,13.49,0.916667,44.4167,52,230),
(47,new String'("Saint-Astier"),47120,198,170,20,9.56,0.25,44.725,57,165),
(47,new String'("Sainte-Colombe-de-Duras"),47120,99,77,14,6.97,0.133333,44.6833,32,115),
(47,new String'("Mazières-Naresse"),47210,133,137,14,8.93,0.716667,44.6667,75,116),
(47,new String'("Saint-Maurin"),47270,465,449,21,21.74,0.9,44.2,72,220),
(47,new String'("Sainte-Colombe-de-Villeneuve"),47300,452,354,23,18.92,0.65,44.3667,70,224),
(47,new String'("Perche"),47800,133,125,15,8.42,0.416667,44.55,62,141),
(47,new String'("Monteton"),47120,277,238,20,13.81,0.25,44.6167,33,128),
(47,new String'("Lauzun"),47410,729,778,30,24.09,0.466667,44.6333,53,122),
(47,new String'("Espiens"),47600,393,312,22,17.48,0.366667,44.1667,46,196),
(47,new String'("Monségur"),47150,379,377,34,10.99,0.879167,44.4839,80,238),
(47,new String'("Baleyssagues"),47120,182,176,22,8.18,0.166667,44.6833,25,108),
(47,new String'("Feugarolles"),47230,926,865,38,23.82,0.35,44.2167,27,172),
(47,new String'("Lacaussade"),47150,211,168,20,10.28,0.833333,44.5167,78,172),
(47,new String'("Saint-Nicolas-de-la-Balerme"),47220,397,354,84,4.72,0.766667,44.15,45,73),
(47,new String'("Saint-Pardoux-Isaac"),47800,1183,1217,162,7.26,0.383333,44.6,44,122),
(47,new String'("Saint-Pierre-sur-Dropt"),47120,278,226,33,8.18,0.2,44.6333,28,70),
(47,new String'("Saint-Quentin-du-Dropt"),47330,174,175,14,11.9,0.583333,44.6833,61,127),
(47,new String'("Saint-Eutrope-de-Born"),47210,694,609,18,38.28,0.683333,44.5667,83,185),
(47,new String'("Lusignan-Petit"),47360,370,273,50,7.35,0.533333,44.2833,46,198),
(47,new String'("Longueville"),47200,351,260,73,4.79,0.233333,44.4667,20,35),
(47,new String'("Rayet"),47210,168,155,16,10.02,0.783333,44.65,87,167),
(47,new String'("Escassefort"),47350,632,556,45,13.92,0.233333,44.55,42,141),
(47,new String'("Bajamont"),47480,929,931,76,12.2,0.706111,44.2656,64,211),
(47,new String'("Lafitte-sur-Lot"),47320,791,694,49,15.99,0.431389,44.3517,27,67),
(47,new String'("Francescas"),47600,695,714,32,21.23,0.433333,44.0667,63,171),
(47,new String'("Caubeyres"),47160,222,135,15,14.39,0.2,44.25,85,183),
(47,new String'("Villeneuve-de-Duras"),47120,317,254,26,11.81,0.233333,44.7333,54,131),
(47,new String'("Saint-Front-sur-Lémance"),47500,562,576,28,19.58,0.966667,44.5667,99,276),
(47,new String'("Boudy-de-Beauregard"),47290,402,356,39,10.07,0.689167,44.5387,82,156),
(47,new String'("Saumont"),47600,235,158,34,6.74,0.45,44.1333,56,152),
(47,new String'("Taillebourg"),47200,85,92,11,7.11,0.233333,44.45,17,25),
(47,new String'("Beauville"),47470,578,553,24,23.17,0.883333,44.2667,84,231),
(47,new String'("Cours"),47360,206,193,18,11.43,0.583333,44.3333,81,227),
(47,new String'("Labastide-Castel-Amouroux"),47250,321,291,26,11.95,0.116667,44.35,51,172),
(47,new String'("Fongrave"),47260,612,565,64,9.46,0.4,44.5333,38,177),
(47,new String'("Beauziac"),47700,254,215,16,15.34,0.05,44.3333,77,163),
(47,new String'("Blaymont"),47470,226,196,16,13.56,0.966667,44.3167,85,228),
(47,new String'("Cassignas"),47340,120,135,15,7.86,0.8,44.3,106,221),
(48,new String'("Albaret-Sainte-Marie"),48200,564,452,35,15.98,3.26667,44.8833,767,1139),
(48,new String'("Recoules-de-Fumas"),48100,95,91,9,9.77,3.35,44.6333,879,1144),
(48,new String'("Saint-Léger-du-Malzieu"),48140,207,190,10,18.92,3.31667,44.8833,797,1184),
(48,new String'("La Malène"),48210,166,171,4,40.68,3.31667,44.3,438,1012),
(48,new String'("Monts-Verts"),48200,341,336,11,29.13,3.20528,44.8578,916,1164),
(48,new String'("Antrenas"),48100,325,303,18,17.55,3.26667,44.5833,720,1183),
(48,new String'("Gabrias"),48100,138,125,6,20.65,3.38333,44.55,717,1200),
(48,new String'("La Salle-Prunet"),48400,179,129,9,18.5,3.61334,44.3164,552,1179),
(48,new String'("Malbouzon"),48270,146,160,10,14.26,3.13333,44.7,1143,1264),
(48,new String'("Saint-Laurent-de-Muret"),48100,177,164,3,46.04,3.2,44.6,976,1381),
(48,new String'("Villefort"),48800,608,620,82,7.35,3.93278,44.4403,509,960),
(48,new String'("Chasseradès"),48250,158,151,2,61.93,3.81667,44.55,951,1482),
(48,new String'("Florac"),48400,1942,1993,64,29.89,3.6,44.3167,522,1141),
(48,new String'("Rousses"),48400,102,87,4,22.38,3.6,44.2,660,1343),
(48,new String'("Le Pont-de-Montvert"),48220,276,270,3,90.25,3.75,44.3667,665,1699),
(48,new String'("Gabriac"),48110,109,97,12,8.44,3.73333,44.1833,353,864),
(48,new String'("Saint-Julien-du-Tournel"),48190,110,109,3,36.57,3.66667,44.4833,912,1542),
(48,new String'("Sainte-Hélène"),48190,71,52,10,6.73,3.60278,44.5192,793,1212),
(48,new String'("Sainte-Enimie"),48210,527,509,6,87.34,3.41667,44.3667,444,1096),
(48,new String'("Fontanès"),48300,118,110,10,11.28,3.78333,44.7667,791,1075),
(48,new String'("Vignes"),48210,107,118,3,28.84,3.23333,44.2833,400,1022),
(48,new String'("Saint-Léger-de-Peyre"),48100,169,176,6,27.35,3.3,44.6,670,1154),
(48,new String'("Chaulhac"),48140,72,79,7,9.47,3.25,44.9167,740,1024),
(48,new String'("Brenoux"),48000,361,304,32,11.25,3.53333,44.4833,729,1082),
(48,new String'("Estables"),48700,174,171,5,32.89,3.41667,44.6667,1090,1553),
(48,new String'("Chambon-le-Château"),48600,292,260,35,8.12,3.66667,44.85,891,1153),
(48,new String'("Langogne"),48300,3014,3097,96,31.37,3.85,44.7167,886,1097),
(48,new String'("Marvejols"),48100,5053,5504,405,12.45,3.28333,44.55,632,918),
(48,new String'("Brion"),48310,98,111,4,22.11,3.08333,44.75,980,1272),
(48,new String'("Canilhac"),48500,139,102,19,7.27,3.15,44.4167,499,940),
(48,new String'("La Villedieu"),48700,40,53,1,22.79,3.5,44.7,1217,1506),
(48,new String'("Fraissinet-de-Lozère"),48220,226,190,5,38.58,3.7,44.3833,669,1699),
(48,new String'("Saint-Juéry"),48310,67,60,40,1.65,3.1,44.8333,910,1064),
(48,new String'("Fournels"),48310,368,325,23,15.76,3.11667,44.8167,909,1240),
(48,new String'("Montrodat"),48100,1134,983,54,20.65,3.33333,44.55,640,1103),
(48,new String'("Le Born"),48000,150,147,4,30.21,3.55,44.5667,918,1437),
(48,new String'("Luc"),48250,227,209,4,46.1,3.88333,44.65,925,1386),
(48,new String'("Pied-de-Borne"),48800,217,195,7,27.89,3.98473,44.4756,276,960),
(48,new String'("Salces"),48100,95,82,2,45.78,3.15,44.5333,789,1452),
(48,new String'("Saint-Étienne-du-Valdonnez"),48000,638,469,11,56.09,3.56667,44.45,754,1557),
(48,new String'("Pierrefiche"),48300,164,153,9,16.82,3.73333,44.6833,1074,1285),
(48,new String'("Pourcharesses"),48800,121,108,3,31.79,3.93278,44.4387,600,1662),
(48,new String'("Grandrieu"),48600,760,772,11,65.37,3.63333,44.7833,867,1317),
(48,new String'("Saint-André-de-Lancize"),48240,126,112,5,22.78,3.81667,44.2667,376,1351),
(48,new String'("Belvézet"),48170,92,81,7,12.39,3.75,44.55,1156,1497),
(48,new String'("Saint-Germain-de-Calberte"),48370,455,484,11,38.6,3.8,44.2167,275,1147),
(48,new String'("Paulhac-en-Margeride"),48140,105,120,6,15.79,3.38333,44.8667,1056,1496),
(48,new String'("Saint-Pierre-le-Vieux"),48200,286,241,18,15.55,3.30861,44.8473,840,1090),
(48,new String'("Le Collet-de-Dèze"),48160,668,710,25,26.47,3.91667,44.25,260,900),
(48,new String'("Saint-Paul-le-Froid"),48600,146,188,3,44.17,3.56667,44.7833,1154,1469),
(48,new String'("Saint-Denis-en-Margeride"),48700,182,207,4,38.67,3.4725,44.7364,995,1485),
(48,new String'("Le Malzieu-Ville"),48140,881,971,112,7.8,3.35,44.85,826,1063),
(48,new String'("Chastel-Nouvel"),48000,736,625,23,31.5,3.51667,44.5667,759,1302),
(48,new String'("Hermaux"),48340,115,111,6,17.59,3.11667,44.5167,589,1361),
(48,new String'("Laval-du-Tarn"),48500,108,109,2,36.85,3.35,44.35,449,1021),
(48,new String'("Le Rozier"),48150,150,153,73,2.03,3.21667,44.1833,387,849),
(48,new String'("Saint-Privat-du-Fau"),48140,133,118,6,22.16,3.35,44.9167,879,1417),
(48,new String'("Saint-Chély-d'Apcher"),48200,4323,4319,152,28.26,3.28333,44.8,935,1126),
(48,new String'("Ribennes"),48700,166,172,6,24.97,3.4,44.6333,917,1203),
(48,new String'("Le Monastier-Pin-Moriès"),48100,904,725,46,19.3,3.25445,44.5148,570,1053),
(48,new String'("Saint-Laurent-de-Trèves"),48400,179,136,7,23.09,3.6,44.2667,568,1166),
(48,new String'("Altier"),48800,207,207,3,54.45,3.86667,44.4667,616,1678),
(48,new String'("Marchastel"),48260,77,73,2,34.87,3.11667,44.65,1139,1304),
(48,new String'("Rimeize"),48200,605,517,18,32.3,3.31667,44.7667,890,1125),
(48,new String'("Saint-Andéol-de-Clerguemort"),48160,103,73,15,6.86,3.9,44.2833,379,970),
(48,new String'("Saint-Michel-de-Dèze"),48160,209,191,14,14.19,3.9,44.2333,309,975),
(48,new String'("Saint-Bonnet-de-Chirac"),48100,53,57,6,7.68,3.26667,44.5167,579,960),
(48,new String'("Saint-Maurice-de-Ventalon"),48220,75,81,1,38.51,3.83333,44.3167,640,1493),
(48,new String'("Prinsuéjols"),48100,158,162,3,42.96,3.18333,44.6667,1084,1286),
(48,new String'("Rocles"),48300,216,197,10,19.84,3.78333,44.7,976,1243),
(48,new String'("Bessons"),48200,449,362,19,23.49,3.25,44.7667,972,1274),
(48,new String'("Saint-Pierre-de-Nogaret"),48340,164,158,9,16.44,3.13333,44.4833,509,1251),
(48,new String'("Esclanèdes"),48230,319,250,25,12.51,3.36667,44.4833,627,1001),
(48,new String'("Julianges"),48140,73,71,7,9.42,3.31667,44.9333,891,1340),
(48,new String'("La Canourgue"),48500,2120,1923,20,104.29,3.21667,44.4167,521,1008),
(48,new String'("Saint-Bauzile"),48000,609,504,20,29.33,3.50223,44.482,687,1110),
(48,new String'("Saint-Julien-d'Arpaon"),48400,119,134,5,20.72,3.66667,44.3,580,1421),
(48,new String'("Naussac"),48300,205,190,15,13.52,3.78333,44.75,869,1064),
(48,new String'("Saint-Germain-du-Teil"),48340,798,802,35,22.58,3.16667,44.4833,520,1122),
(48,new String'("Allenc"),48190,253,189,6,38.58,3.66667,44.5333,926,1326),
(48,new String'("Saint-Flour-de-Mercoire"),48300,184,121,15,12.17,3.83333,44.7,954,1229),
(48,new String'("La Fage-Saint-Julien"),48200,284,237,15,18.06,3.2,44.8,1032,1234),
(48,new String'("Le Buisson"),48100,225,210,9,24.45,3.23333,44.6333,880,1288),
(48,new String'("Vialas"),48220,433,425,8,49.77,3.9,44.3333,335,1509),
(48,new String'("Saint-Julien-des-Points"),48160,111,91,28,3.83,3.96667,44.2667,248,725),
(48,new String'("Saint-Frézal-de-Ventalon"),48240,158,143,9,16.89,3.86667,44.2833,378,1128),
(48,new String'("Cheylard-l'Évêque"),48300,63,54,2,29.64,3.8,44.65,1055,1491),
(48,new String'("Le Pompidou"),48110,183,154,8,22.8,3.65,44.2,379,1047),
(48,new String'("Le Malzieu-Forain"),48140,470,357,9,48.65,3.32834,44.8545,855,1486),
(48,new String'("Saint-Jean-la-Fouillouse"),48170,166,148,5,29.27,3.66667,44.7,1086,1348),
(48,new String'("Molezon"),48110,90,85,6,14.76,3.66667,44.2167,389,1011),
(48,new String'("Salelles"),48230,150,118,14,10.62,3.28333,44.4833,580,940),
(48,new String'("Saint-Pierre-des-Tripiers"),48150,77,78,2,34.74,3.28333,44.2333,392,1065),
(48,new String'("Palhers"),48100,200,172,23,8.59,3.3,44.5333,668,1022),
(48,new String'("Balsièges"),48000,517,508,15,32.88,3.46667,44.4833,652,1093),
(48,new String'("Lajo"),48120,108,136,5,18.58,3.43333,44.8333,1064,1436),
(48,new String'("Lachamp"),48100,177,142,6,25.89,3.38333,44.6167,840,1187),
(48,new String'("Sainte-Colombe-de-Peyre"),48130,199,203,9,21.9,3.23333,44.6833,1018,1258),
(48,new String'("Cubiérettes"),48190,54,50,4,11.34,3.78333,44.45,960,1625),
(48,new String'("Mas-d'Orcières"),48190,124,131,3,36.56,3.7,44.4667,1000,1699),
(48,new String'("La Fage-Montivernoux"),48310,168,167,4,37.77,3.18333,44.75,1030,1292),
(48,new String'("Chaudeyrac"),48170,308,263,6,44.1,3.75,44.65,1119,1436),
(48,new String'("Auroux"),48600,420,379,11,35.09,3.73333,44.75,909,1271),
(48,new String'("Cocurès"),48400,196,173,55,3.55,3.61667,44.35,561,980),
(48,new String'("Saint-Amans"),48700,147,133,14,9.98,3.45,44.6583,1050,1264),
(48,new String'("Saint-Martin-de-Lansuscle"),48110,186,140,10,18.05,3.75,44.2167,376,1147),
(48,new String'("Saint-Frézal-d'Albuges"),48170,53,42,3,17.2,3.76667,44.55,1120,1496),
(48,new String'("Banassac"),48500,866,813,49,17.41,3.2,44.4333,504,927),
(48,new String'("Saint-Hilaire-de-Lavit"),48160,108,86,10,10.31,3.86667,44.25,333,927),
(48,new String'("Saint-Gal"),48700,111,56,11,9.88,3.43333,44.6667,993,1143),
(48,new String'("Châteauneuf-de-Randon"),48170,531,531,21,24.49,3.66667,44.65,1116,1339),
(48,new String'("Montbel"),48170,132,139,5,22.87,3.71667,44.5833,1186,1436),
(48,new String'("La Tieule"),48500,106,68,4,24.0,3.15,44.3833,660,1018),
(48,new String'("La Bastide-Puylaurent"),48250,172,157,7,24.19,3.9,44.6,751,1328),
(48,new String'("Cubières"),48190,175,197,3,48.88,3.76667,44.4667,756,1633),
(48,new String'("Albaret-le-Comtal"),48310,194,196,6,29.56,3.15,44.8667,740,1161),
(48,new String'("Chirac"),48100,1172,1005,34,33.79,3.26667,44.5333,605,1254),
(48,new String'("Saint-Rome-de-Dolan"),48500,80,73,2,32.63,3.21667,44.2667,387,1001),
(48,new String'("Barre-des-Cévennes"),48400,204,179,5,34.29,3.65,44.25,500,1064),
(48,new String'("Quézac"),48320,348,246,12,26.91,3.53333,44.3667,479,1080),
(48,new String'("Vebron"),48400,201,196,2,69.66,3.56667,44.2333,611,1246),
(48,new String'("Serverette"),48700,284,289,16,17.35,3.38333,44.7,959,1106),
(48,new String'("Bédouès"),48400,289,299,10,26.8,3.6,44.35,540,1170),
(48,new String'("Noalhac"),48310,98,82,7,13.51,3.13333,44.8167,913,1255),
(48,new String'("Saint-Laurent-de-Veyrès"),48310,43,37,4,9.11,3.15,44.7667,1030,1271),
(48,new String'("Hures-la-Parade"),48150,234,181,2,88.59,3.3525,44.2448,501,1204),
(48,new String'("Aumont-Aubrac"),48130,1111,1029,41,26.53,3.28333,44.7167,970,1165),
(48,new String'("Mas-Saint-Chély"),48210,140,111,2,56.81,3.4,44.3167,800,1156),
(48,new String'("Saint-Étienne-Vallée-Française"),48330,534,487,10,50.99,3.84195,44.1667,194,925),
(48,new String'("Fontans"),48700,212,196,6,33.9,3.4,44.7333,910,1123),
(48,new String'("Trélans"),48340,101,113,4,23.35,3.08333,44.5,714,1469),
(48,new String'("Saint-Alban-sur-Limagnole"),48120,1505,1600,29,51.23,3.38333,44.7833,872,1305),
(48,new String'("Fraissinet-de-Fourques"),48400,63,67,2,24.3,3.53333,44.2167,660,1343),
(48,new String'("Montbrun"),48210,86,72,2,29.97,3.5,44.3333,479,1105),
(48,new String'("Pelouse"),48000,225,151,6,32.98,3.61667,44.5687,859,1431),
(48,new String'("Arzenc-de-Randon"),48170,201,195,2,69.2,3.61667,44.65,1146,1542),
(48,new String'("Saint-Sauveur-de-Peyre"),48130,276,251,9,27.61,3.28333,44.65,852,1180),
(48,new String'("Chanac"),48230,1399,1155,19,71.14,3.33333,44.4667,612,1004),
(48,new String'("Moissac-Vallée-Française"),48110,223,228,8,27.05,3.78445,44.1631,256,768),
(48,new String'("Cultures"),48230,133,106,33,3.96,3.38333,44.5,650,1000),
(48,new String'("Bassurels"),48400,43,47,0,46.34,3.61667,44.1833,553,1562),
(48,new String'("Saint-Saturnin"),48500,63,73,6,9.14,3.19167,44.4083,563,967),
(48,new String'("Fau-de-Peyre"),48130,182,182,6,26.72,3.21667,44.7333,992,1247),
(48,new String'("Saint-André-Capcèze"),48800,168,146,17,9.85,3.95,44.4167,423,1087),
(48,new String'("Saint-Bonnet-de-Montauroux"),48600,124,128,5,21.33,3.71667,44.8167,729,1180),
(48,new String'("Prunières"),48200,253,175,19,13.09,3.35,44.8167,868,1121),
(48,new String'("Chastanier"),48300,92,88,8,10.41,3.75,44.7167,952,1169),
(48,new String'("Barjac"),48000,660,597,22,29.92,3.4,44.5,650,1212),
(48,new String'("Saint-Sauveur-de-Ginestoux"),48170,62,68,2,22.14,3.6,44.7,1217,1488),
(48,new String'("Sainte-Croix-Vallée-Française"),48110,319,281,17,18.57,3.74223,44.1798,320,924),
(48,new String'("Ispagnac"),48320,856,759,15,53.71,3.53333,44.3667,499,1233),
(48,new String'("Javols"),48130,331,277,10,31.21,3.35,44.6833,931,1117),
(48,new String'("Chadenet"),48190,120,97,9,12.96,3.61667,44.5,859,1345),
(48,new String'("Mende"),48000,12140,11792,332,36.56,3.5,44.5167,691,1236),
(48,new String'("Saint-Privat-de-Vallongue"),48240,272,249,11,23.87,3.83333,44.2833,354,1353),
(48,new String'("Lanuéjols"),48000,317,208,9,32.67,3.56667,44.5,778,1421),
(48,new String'("Badaroux"),48000,907,848,43,20.72,3.55,44.5333,736,1220),
(48,new String'("Arzenc-d'Apcher"),48310,49,58,6,7.88,3.11667,44.85,760,1137),
(48,new String'("Cassagnas"),48400,118,134,3,35.19,3.75,44.2667,667,1398),
(48,new String'("Le Recoux"),48500,125,110,5,23.69,3.15,44.3333,788,1016),
(48,new String'("Grandvals"),48260,83,91,6,12.84,3.05,44.7333,1018,1235),
(48,new String'("Meyrueis"),48150,825,851,7,104.68,3.43333,44.1667,611,1562),
(48,new String'("Gatuzières"),48150,42,56,1,29.4,3.48333,44.2,759,1562),
(48,new String'("Laubert"),48170,102,133,7,14.28,3.63333,44.55,1186,1428),
(48,new String'("Prévenchères"),48800,260,215,4,62.75,3.91667,44.5167,337,1294),
(48,new String'("Chauchailles"),48310,97,97,5,17.4,3.1,44.7833,918,1257),
(48,new String'("La Panouse"),48600,77,99,2,37.83,3.58333,44.7333,1177,1506),
(48,new String'("La Chaze-de-Peyre"),48130,269,207,13,19.33,3.25,44.7,1010,1217),
(48,new String'("Nasbinals"),48260,500,505,7,63.34,3.05,44.6667,1080,1386),
(48,new String'("Sainte-Eulalie"),48120,46,64,2,21.31,3.45,44.7833,1153,1454),
(48,new String'("Rieutort-de-Randon"),48700,756,646,12,62.34,3.47917,44.6353,1034,1550),
(48,new String'("Saint-Georges-de-Lévéjac"),48500,259,247,4,56.26,3.23333,44.3167,420,1005),
(48,new String'("Saint-Symphorien"),48600,249,258,7,33.28,3.61667,44.8333,948,1237),
(48,new String'("Laval-Atger"),48600,166,190,15,10.67,3.68333,44.8,828,1175),
(48,new String'("Recoules-d'Aubrac"),48260,241,272,9,26.55,3.03333,44.6833,1049,1374),
(48,new String'("Saint-Martin-de-Boubaux"),48160,172,163,5,31.41,3.91667,44.2,200,925),
(48,new String'("Termes"),48310,217,202,12,17.65,3.16667,44.8131,1015,1223),
(48,new String'("Le Massegros"),48500,350,323,19,17.94,3.18333,44.3,815,1005),
(48,new String'("Le Bleymard"),48190,356,446,21,16.36,3.73333,44.4833,1037,1482),
(48,new String'("Servières"),48000,182,152,9,19.38,3.41667,44.5833,840,1265),
(48,new String'("Bondons"),48400,142,150,3,45.54,3.61667,44.3833,600,1569),
(48,new String'("Bagnols-les-Bains"),48190,238,244,99,2.4,3.66667,44.5,898,1145),
(48,new String'("Grèzes"),48100,225,245,13,16.21,3.33333,44.5167,709,1032),
(48,new String'("Blavignac"),48200,236,226,17,13.83,3.28333,44.8833,793,1106),
(48,new String'("Laubies"),48700,171,148,7,22.8,3.43333,44.6833,1010,1388),
(49,new String'("Châtelais"),49520,634,576,26,23.68,-0.916667,47.7667,26,102),
(49,new String'("Nueil-sur-Layon"),49560,1357,1319,22,61.23,-0.366667,47.1167,57,123),
(49,new String'("Armaillé"),49420,284,289,16,16.78,-1.13333,47.7167,39,100),
(49,new String'("Saint-Just-sur-Dive"),49260,404,346,55,7.24,-0.083333,47.1833,26,39),
(49,new String'("Fontaine-Milon"),49140,487,354,57,8.46,-0.25,47.5,31,88),
(49,new String'("Pontigné"),49150,257,218,10,24.17,-0.033333,47.55,47,92),
(49,new String'("Brigné"),49700,407,316,27,14.63,-0.383333,47.2333,40,90),
(49,new String'("Mozé-sur-Louet"),49610,2063,2001,80,25.53,-0.55,47.35,12,94),
(49,new String'("Saint-Clément-des-Levées"),49350,1149,1005,112,10.22,-0.183333,47.3333,20,27),
(49,new String'("Saint-Sauveur-de-Landemont"),49270,870,653,74,11.69,0.74389,47.2842,13,91),
(49,new String'("Chemillé"),49120,7028,6182,142,49.2,-0.716667,47.2167,42,114),
(49,new String'("La Varenne"),49270,1762,1372,122,14.35,-1.31667,47.3167,1,82),
(49,new String'("Saint-Philbert-en-Mauges"),49600,376,325,51,7.25,-1.01667,47.15,54,114),
(49,new String'("Vaulandry"),49150,313,271,11,27.65,-0.05,47.6,46,87),
(49,new String'("Cholet"),49280,54098,54215,618,87.47,-0.883333,47.0667,63,184),
(49,new String'("Saint-Georges-des-Gardes"),49120,1590,1448,48,32.49,-0.759167,47.15,77,211),
(49,new String'("Cernusson"),49310,310,279,36,8.45,-0.483333,47.1833,69,116),
(49,new String'("Vernantes"),49390,1982,1855,48,40.77,0.05,47.4,33,111),
(49,new String'("La Chapelle-sur-Oudon"),49500,586,482,46,12.62,-0.816667,47.6833,19,68),
(49,new String'("Tigné"),49540,765,718,45,16.78,-0.433333,47.2,37,98),
(49,new String'("Saint-Clément-de-la-Place"),49370,1911,1391,57,33.23,-0.75,47.5333,40,102),
(49,new String'("Cheviré-le-Rouge"),49150,923,724,25,35.96,-0.183333,47.6,30,104),
(49,new String'("Verchers-sur-Layon"),49700,902,814,29,30.7,-0.3,47.15,48,109),
(49,new String'("Champtoceaux"),49270,2373,1748,152,15.54,-1.26667,47.3333,2,86),
(49,new String'("Le Puy-Notre-Dame"),49260,1267,1236,78,16.04,-0.233333,47.1167,32,106),
(49,new String'("La Pouëze"),49370,1804,1423,81,22.15,-0.8,47.55,51,97),
(49,new String'("Le Plessis-Macé"),49220,1259,950,157,7.99,-0.666667,47.55,21,96),
(49,new String'("Beausse"),49410,392,360,73,5.36,-0.916667,47.3167,83,156),
(49,new String'("Toutlemonde"),49360,1138,956,90,12.63,-0.766667,47.05,93,176),
(49,new String'("Beaupréau"),49600,6784,6217,189,35.79,-1.0,47.2,32,117),
(49,new String'("La Prévière"),49420,254,288,35,7.24,-1.18333,47.7167,47,100),
(49,new String'("Candé"),49440,2861,2593,582,4.91,-1.03333,47.5667,32,67),
(49,new String'("Sermaise"),49140,331,227,46,7.19,-0.216667,47.5167,30,70),
(49,new String'("Pruillé"),49220,635,531,50,12.68,-0.65,47.5833,12,83),
(49,new String'("Meigné"),49700,354,314,26,13.19,-0.216667,47.2333,59,100),
(49,new String'("Rairies"),49430,970,866,115,8.41,-0.2,47.65,22,43),
(49,new String'("Rou-Marson"),49400,683,599,53,12.66,-0.15,47.2333,32,87),
(49,new String'("Saint-Laurent-des-Autels"),49270,2152,1497,116,18.55,-1.18333,47.2833,25,106),
(49,new String'("Cerqueux-sous-Passavant"),49310,496,444,21,23.24,-0.465833,47.1081,84,127),
(49,new String'("Chavaignes"),49490,101,113,13,7.42,0.033333,47.5333,74,89),
(49,new String'("Beauvau"),49140,253,209,31,7.98,-0.25,47.5833,33,90),
(49,new String'("Noyant"),49490,1896,1844,69,27.41,0.133333,47.5167,51,89),
(49,new String'("Bouillé-Ménard"),49520,738,638,46,15.79,-0.966667,47.7333,32,104),
(49,new String'("La Meignanne"),49220,2129,2054,91,23.39,-0.666667,47.5167,22,99),
(49,new String'("Chalonnes-sous-le-Lude"),49490,137,134,8,16.49,0.166667,47.55,52,101),
(49,new String'("Saint-Lambert-du-Lattay"),49750,1894,1466,131,14.44,-0.633333,47.3,16,96),
(49,new String'("Saint-Martin-de-la-Place"),49160,1156,1116,77,14.84,-0.133333,47.3167,20,29),
(49,new String'("Saint-Macaire-du-Bois"),49260,436,387,33,13.06,-0.266667,47.1167,43,86),
(49,new String'("Brézé"),49260,1308,1300,65,20.05,-0.066667,47.1667,26,104),
(49,new String'("Nuaillé"),49340,1379,1356,104,13.23,-0.8,47.1,109,187),
(49,new String'("Ambillou-Château"),49700,958,807,47,19.99,-0.35,47.2667,47,101),
(49,new String'("Le Coudray-Macouard"),49260,906,867,67,13.4,-0.116667,47.2,27,67),
(49,new String'("La Lande-Chasles"),49150,105,86,20,5.08,-0.066667,47.4667,39,75),
(49,new String'("Saint-Sauveur-de-Flée"),49500,287,250,22,12.87,-0.783333,47.75,42,86),
(49,new String'("Beaucouzé"),49070,4938,4869,255,19.34,-0.633333,47.4667,21,88),
(49,new String'("Yzernay"),49360,1791,1577,44,40.66,-0.7,47.0167,122,184),
(49,new String'("Champtocé-sur-Loire"),49123,1792,1533,48,36.76,-0.866667,47.4167,11,83),
(49,new String'("Chavagnes"),49380,1057,777,65,16.21,-0.466667,47.2667,41,98),
(49,new String'("La Chapelle-Rousselin"),49120,729,597,58,12.54,-0.783333,47.2167,94,123),
(49,new String'("Angers"),49000,147571,151322,3455,42.7,-0.55,47.4667,12,64),
(49,new String'("Gesté"),49600,2579,2339,72,35.55,-1.11667,47.1833,48,104),
(49,new String'("Champ-sur-Layon"),49380,989,803,51,19.19,-0.583333,47.2667,22,92),
(49,new String'("Vihiers"),49310,4271,3991,71,59.7,-0.533333,47.15,52,211),
(49,new String'("La Daguenière"),49800,1282,1246,107,11.92,-0.433333,47.4167,16,21),
(49,new String'("La Jumellière"),49120,1368,1065,47,29.09,-0.716667,47.2833,20,104),
(49,new String'("La Poitevinière"),49510,1065,976,39,26.73,-0.8975,47.2278,57,126),
(49,new String'("Saint-Michel-et-Chanveaux"),49420,368,364,13,27.67,-1.13333,47.6833,39,105),
(49,new String'("La Romagne"),49740,1763,1587,110,15.93,-1.01667,47.0667,48,133),
(49,new String'("Briollay"),49125,2668,2284,186,14.28,-0.5,47.5667,13,64),
(49,new String'("Le May-sur-Èvre"),49122,3970,3892,125,31.62,-0.9,47.1333,72,128),
(49,new String'("Corzé"),49140,1672,1519,53,31.49,-0.383333,47.55,15,68),
(49,new String'("Beaufort-en-Vallée"),49250,6380,5384,178,35.66,-0.216667,47.4333,17,51),
(49,new String'("Châteauneuf-sur-Sarthe"),49330,3016,2408,209,14.39,-0.483333,47.6833,16,72),
(49,new String'("Saint-Paul-du-Bois"),49310,612,563,23,26.58,-0.55,47.0833,103,214),
(49,new String'("Durtal"),49430,3349,3237,55,60.58,-0.25,47.6667,21,94),
(49,new String'("La Boissière-sur-Èvre"),49110,418,367,69,6.02,-1.08333,47.3,17,102),
(49,new String'("Trémentines"),49340,2813,2817,82,34.06,-0.783333,47.1167,82,180),
(49,new String'("Distré"),49400,1673,1217,113,14.72,-0.116667,47.2333,25,77),
(49,new String'("Montreuil-Juigné"),49460,7107,6669,514,13.81,-0.611944,47.5284,12,72),
(49,new String'("La Jubaudière"),49510,1218,1134,111,10.9,-0.9,47.1667,65,118),
(49,new String'("Parçay-les-Pins"),49390,915,1022,32,27.85,0.166667,47.4333,48,119),
(49,new String'("La Chapelle-du-Genêt"),49600,1196,1002,131,9.1,-1.01667,47.1833,42,114),
(49,new String'("Brissarthe"),49330,630,528,37,16.99,-0.45,47.7,17,78),
(49,new String'("La Chapelle-Saint-Laud"),49140,646,422,60,10.63,-0.3,47.6167,28,98),
(49,new String'("Soulaines-sur-Aubance"),49610,1156,1187,90,12.72,-0.516667,47.3667,17,96),
(49,new String'("Marigné"),49330,640,523,26,24.41,-0.616667,47.7167,20,83),
(49,new String'("Saint-Laurent-de-la-Plaine"),49290,1699,1537,92,18.44,-0.8,47.3167,29,113),
(49,new String'("Soucelles"),49140,2620,1865,136,19.2,-0.416667,47.5667,12,60),
(49,new String'("Villebernier"),49400,1449,1350,146,9.91,-0.033333,47.25,23,32),
(49,new String'("Carbay"),49420,244,208,31,7.63,-1.21667,47.7333,54,101),
(49,new String'("Thouarcé"),49380,1838,1682,98,18.74,-0.5,47.2667,23,98),
(49,new String'("Juvardeil"),49330,811,766,42,18.95,-0.5,47.65,16,77),
(49,new String'("Fontaine-Guérin"),49250,955,723,42,22.51,-0.183333,47.4833,21,90),
(49,new String'("Le Puiset-Doré"),49600,1143,930,50,22.62,-1.1,47.2333,68,109),
(49,new String'("Saint-Cyr-en-Bourg"),49260,982,1070,113,8.63,-0.05,47.2,30,104),
(49,new String'("Montigné-lès-Rairies"),49430,366,351,40,9.01,-0.2,47.6167,28,76),
(49,new String'("Pouancé"),49420,3110,3308,63,48.97,-1.16667,47.75,48,108),
(49,new String'("Melay"),49120,1608,1419,70,22.7,-0.7,47.1833,75,212),
(49,new String'("Baugé"),49150,3681,3661,430,8.55,-0.1,47.5417,41,102),
(49,new String'("Noyant-la-Gravoyère"),49520,1836,1761,154,11.91,-0.966667,47.7,32,102),
(49,new String'("Saint-Rémy-la-Varenne"),49250,976,842,62,15.67,-0.316667,47.4,18,77),
(49,new String'("Vaudelnay"),49260,1228,1058,48,25.48,-0.2,47.15,31,104),
(49,new String'("Chanzeaux"),49750,1160,944,36,31.47,-0.65,47.2667,19,104),
(49,new String'("Chemellier"),49320,728,458,66,10.99,-0.35,47.3333,31,92),
(49,new String'("Saint-Léger-sous-Cholet"),49280,2492,2604,259,9.6,-0.916667,47.1,93,132),
(49,new String'("Meigné-le-Vicomte"),49490,301,322,13,23.13,0.2,47.5167,71,96),
(49,new String'("Mazières-en-Mauges"),49280,1000,955,112,8.9,-0.816667,47.05,88,163),
(49,new String'("Nyoiseau"),49500,1281,1275,82,15.55,-0.916667,47.7167,22,97),
(49,new String'("Grugé-l'Hôpital"),49520,299,286,19,15.71,-1.03333,47.75,41,108),
(49,new String'("Faveraye-Mâchelles"),49380,647,495,34,18.6,-0.5,47.25,27,91),
(49,new String'("Gené"),49220,456,259,49,9.25,-0.8,47.6333,36,54),
(49,new String'("Challain-la-Potherie"),49440,827,774,17,47.87,-1.05,47.6333,42,106),
(49,new String'("Chartrené"),49150,54,54,14,3.79,-0.116667,47.5,33,97),
(49,new String'("Champigné"),49330,2068,1504,91,22.7,-0.566667,47.6667,21,80),
(49,new String'("Pellouailles-les-Vignes"),49112,2486,2164,696,3.57,-0.433333,47.5333,32,53),
(49,new String'("Saint-Georges-sur-Loire"),49170,3335,3010,99,33.36,-0.766667,47.4167,11,81),
(49,new String'("Chênehutte-Trèves-Cunault"),49350,1038,1104,37,27.61,-0.153889,47.3084,20,96),
(49,new String'("Passavant-sur-Layon"),49560,130,135,26,4.91,-0.383333,47.1167,62,112),
(49,new String'("Cheffes"),49125,912,821,52,17.35,-0.5075,47.6212,14,53),
(49,new String'("Chazé-Henry"),49860,858,943,43,19.87,-1.11667,47.75,52,107),
(49,new String'("Saint-Germain-des-Prés"),49170,1364,1138,69,19.76,-0.833333,47.4167,10,71),
(49,new String'("Saint-Jean-de-Linières"),49070,1734,1400,200,8.66,-0.6575,47.4581,29,79),
(49,new String'("Cléré-sur-Layon"),49560,326,350,14,21.74,-0.416667,47.0833,67,116),
(49,new String'("Sceaux-d'Anjou"),49330,972,721,56,17.18,-0.6,47.6167,32,71),
(49,new String'("Drain"),49530,1938,1665,101,19.05,-1.2,47.35,5,92),
(49,new String'("Saint-Laurent-du-Mottay"),49410,779,703,53,14.63,-0.95,47.35,8,137),
(49,new String'("Saint-Lambert-la-Potherie"),49070,2472,2218,179,13.81,-0.683333,47.4833,39,76),
(49,new String'("Savennières"),49170,1375,1156,65,21.01,-0.65,47.3833,12,77),
(49,new String'("La Cornuaille"),49440,985,791,22,43.92,-0.983333,47.5167,38,89),
(49,new String'("Morannes"),49640,1790,1600,43,40.73,-0.416667,47.75,17,66),
(49,new String'("Miré"),49330,1024,969,57,17.73,-0.483333,47.7667,24,81),
(49,new String'("Saint-Aubin-de-Luigné"),49190,1190,858,78,15.19,-0.666667,47.3333,12,104),
(49,new String'("Contigné"),49330,761,597,32,23.31,-0.516667,47.7333,19,77),
(49,new String'("Étriché"),49330,1541,1163,78,19.6,-0.433333,47.65,16,53),
(49,new String'("Daumeray"),49640,1529,1313,37,40.53,-0.366667,47.7,17,67),
(49,new String'("Aubigné-sur-Layon"),49540,359,334,67,5.32,-0.461111,47.212,36,80),
(49,new String'("Montreuil-sur-Maine"),49220,689,557,61,11.13,-0.7,47.65,17,61),
(49,new String'("Neuvy-en-Mauges"),49120,822,709,45,18.13,-0.833333,47.2667,45,126),
(49,new String'("Trélazé"),49800,12384,11026,1015,12.2,-0.466667,47.45,0,45),
(49,new String'("Mazé"),49250,4811,3870,144,33.33,-0.266667,47.45,18,53),
(49,new String'("Bourgneuf-en-Mauges"),49290,679,687,58,11.64,-0.833333,47.3167,80,152),
(49,new String'("Le Fief-Sauvin"),49600,1656,1455,54,30.29,-1.03333,47.2167,28,109),
(49,new String'("La Salle-de-Vihiers"),49310,1063,896,61,17.27,-0.633333,47.15,89,204),
(49,new String'("Cerqueux"),49360,821,642,59,13.86,-0.640556,47.0003,139,186),
(49,new String'("La Plaine"),49360,964,811,43,22.16,-0.616667,47.0667,124,213),
(49,new String'("Le Vieil-Baugé"),49150,1266,1217,44,28.63,-0.116667,47.5333,27,89),
(49,new String'("Roussay"),49450,1167,966,106,10.99,-1.06667,47.0833,37,119),
(49,new String'("Cizay-la-Madeleine"),49700,498,412,25,19.29,-0.183333,47.1833,39,109),
(49,new String'("Saint-Barthélemy-d'Anjou"),49124,8702,9832,596,14.58,-0.5,47.4667,22,49),
(49,new String'("Bocé"),49150,603,501,37,16.01,-0.083333,47.5,39,97),
(49,new String'("Montjean-sur-Loire"),49570,2939,2648,152,19.33,-0.866667,47.3833,8,78),
(49,new String'("Lué-en-Baugeois"),49140,342,288,46,7.42,-0.283333,47.5167,27,89),
(49,new String'("Cherré"),49330,532,397,38,13.91,-0.566667,47.7167,35,74),
(49,new String'("Béhuard"),49170,127,110,57,2.21,-0.65,47.3833,12,16),
(49,new String'("Montpollin"),49150,214,129,47,4.49,-0.1,47.5833,56,103),
(49,new String'("Alleuds"),49320,890,636,85,10.47,-0.4,47.3167,49,73),
(49,new String'("Broc"),49490,336,315,15,21.23,0.166667,47.5833,40,117),
(49,new String'("Angrie"),49440,951,678,23,40.97,-0.966667,47.5667,36,88),
(49,new String'("Blaison-Gohier"),49320,1096,951,51,21.45,-0.371389,47.3998,18,91),
(49,new String'("Sainte-Gemmes-sur-Loire"),49130,3957,3684,266,14.83,-0.5575,47.4256,12,45),
(49,new String'("Marcé"),49140,859,637,40,21.09,-0.316667,47.5833,32,97),
(49,new String'("Concourson-sur-Layon"),49700,543,546,29,18.21,-0.333333,47.1833,46,95),
(49,new String'("Montguillon"),49500,196,165,16,11.91,-0.733333,47.7333,46,87),
(49,new String'("Le Thoureil"),49350,436,360,39,11.02,-0.266667,47.3667,17,84),
(49,new String'("Auverse"),49490,450,390,14,30.74,0.05,47.5167,55,102),
(49,new String'("Soulaire-et-Bourg"),49460,1408,1188,77,18.08,-0.55,47.5833,14,59),
(49,new String'("Louvaines"),49500,539,442,35,15.07,-0.8,47.7,18,78),
(49,new String'("La Ménitré"),49250,2194,1901,126,17.37,-0.266667,47.4,17,25),
(49,new String'("Grézillé"),49320,551,391,31,17.62,-0.35,47.3333,44,100),
(49,new String'("Chanteloup-les-Bois"),49340,681,633,24,27.47,-0.683333,47.1,128,191),
(49,new String'("Rablay-sur-Layon"),49750,732,636,98,7.44,-0.583333,47.2833,20,89),
(49,new String'("Saint-Sylvain-d'Anjou"),49480,4440,4541,208,21.26,-0.466667,47.5167,17,53),
(49,new String'("Saint-Crespin-sur-Moine"),49230,1565,1410,77,20.11,-1.18333,47.1,17,96),
(49,new String'("Saint-Florent-le-Vieil"),49410,2677,2625,108,24.7,-1.01667,47.3667,7,130),
(49,new String'("Bécon-les-Granits"),49370,2687,2325,58,46.17,-0.8,47.5,18,88),
(49,new String'("Lézigné"),49430,719,634,77,9.3,-0.283333,47.6333,17,63),
(49,new String'("Avrillé"),49240,12639,12994,797,15.85,-0.583333,47.5,17,62),
(49,new String'("Fougeré"),49150,756,737,31,24.18,-0.148056,47.6273,27,102),
(49,new String'("Louerre"),49700,438,372,30,14.44,-0.333333,47.3,49,103),
(49,new String'("Brain-sur-Longuenée"),49220,1008,769,44,22.43,-0.766667,47.5833,41,102),
(49,new String'("La Membrolle-sur-Longuenée"),49770,1872,1454,198,9.44,-0.673889,47.5612,12,102),
(49,new String'("Saint-Sigismond"),49123,374,313,29,12.72,-0.942778,47.4537,24,86),
(49,new String'("Saint-Sulpice"),49320,179,180,61,2.9,-0.417222,47.4,18,80),
(49,new String'("Le Longeron"),49710,2078,1945,94,22.08,-1.06667,47.0167,49,139),
(49,new String'("Le Louroux-Béconnais"),49370,2861,2066,43,65.57,-0.883333,47.5167,27,91),
(49,new String'("Baracé"),49430,471,317,34,13.46,-0.35,47.6333,17,62),
(49,new String'("Montsoreau"),49730,480,540,92,5.19,0.066667,47.2167,27,88),
(49,new String'("Mouliherne"),49390,917,854,22,40.79,0.016667,47.4667,33,99),
(49,new String'("Cossé-d'Anjou"),49120,431,407,32,13.29,-0.683333,47.1667,84,211),
(49,new String'("Bouzillé"),49530,1473,1275,80,18.39,-1.11667,47.3333,7,102),
(49,new String'("Saint-Saturnin-sur-Loire"),49320,1323,1207,110,11.94,-0.433333,47.4,18,84),
(49,new String'("Genneteil"),49490,348,294,9,35.95,0.05,47.6,49,89),
(49,new String'("Saint-Léger-des-Bois"),49170,1527,1307,99,15.42,-0.716667,47.4667,38,79),
(49,new String'("Noëllet"),49520,445,393,28,15.4,-1.08333,47.7,33,104),
(49,new String'("Seiches-sur-le-Loir"),49140,2960,2410,102,28.83,-0.366667,47.5833,15,64),
(49,new String'("Saulgé-l'Hôpital"),49320,550,365,83,6.6,-0.366667,47.3,48,72),
(49,new String'("Torfou"),49660,2090,1922,64,32.35,-1.11667,47.0333,39,133),
(49,new String'("L'Hôtellerie-de-Flée"),49500,487,375,32,14.77,-0.883333,47.75,26,92),
(49,new String'("La Séguinière"),49280,3765,3507,120,31.15,-0.933333,47.0667,48,139),
(49,new String'("Parnay"),49730,482,460,73,6.54,0.016667,47.2333,26,101),
(49,new String'("Andrezé"),49600,1830,1798,86,21.2,-0.966667,47.1667,52,117),
(49,new String'("Dénezé-sous-le-Lude"),49490,310,262,20,15.05,0.133333,47.5333,58,86),
(49,new String'("Brion"),49250,1115,1027,39,28.29,-0.15,47.45,21,88),
(49,new String'("Saint-Georges-sur-Layon"),49700,785,592,34,22.5,-0.366667,47.2,39,86),
(49,new String'("La Chapelle-Hullin"),49860,136,140,13,9.79,-1.06667,47.7667,46,105),
(49,new String'("Vivy"),49680,2413,1873,104,23.17,-0.066667,47.3333,20,47),
(49,new String'("Brain-sur-l'Authion"),49800,3291,2803,143,22.92,-0.416667,47.45,15,43),
(49,new String'("Coron"),49690,1550,1301,49,31.49,-0.65,47.1333,84,188),
(49,new String'("Chemiré-sur-Sarthe"),49640,272,244,41,6.62,-0.433333,47.75,18,69),
(49,new String'("Tillières"),49230,1738,1268,72,24.13,-1.16667,47.15,28,101),
(49,new String'("Blou"),49160,1022,825,47,21.46,-0.033333,47.3667,23,111),
(49,new String'("Saint-André-de-la-Marche"),49450,2817,2417,255,11.03,-1.0,47.1,42,114),
(49,new String'("Échemiré"),49150,604,466,35,16.98,-0.166667,47.55,33,101),
(49,new String'("Montfort"),49700,111,111,25,4.41,-0.216667,47.2,55,97),
(49,new String'("Chigné"),49490,303,275,12,25.22,0.083333,47.5833,47,86),
(49,new String'("Linières-Bouton"),49490,86,93,8,9.89,0.083333,47.4667,44,78),
(49,new String'("Chaudron-en-Mauges"),49110,1446,1409,56,25.71,-0.983333,47.2833,25,146),
(49,new String'("Saint-Melaine-sur-Aubance"),49610,2100,1943,410,5.11,-0.5,47.3667,17,63),
(49,new String'("Le Lion-d'Angers"),49220,3687,3347,89,41.11,-0.716667,47.6333,17,78),
(49,new String'("Artannes-sur-Thouet"),49260,434,395,65,6.61,-0.083333,47.2,25,55),
(49,new String'("Rochefort-sur-Loire"),49190,2232,1989,80,27.8,-0.65,47.35,12,104),
(49,new String'("La Jaille-Yvon"),49220,309,248,24,12.55,-0.666667,47.7333,20,87),
(49,new String'("Vern-d'Anjou"),49220,2219,1560,61,36.11,-0.833333,47.6,33,87),
(49,new String'("Loiré"),49440,881,754,26,33.73,-0.983333,47.6167,32,90),
(49,new String'("Vauchrétien"),49320,1478,1395,74,19.73,-0.483333,47.3333,29,92),
(49,new String'("Grez-Neuville"),49220,1491,1305,55,26.9,-0.683333,47.6,16,97),
(49,new String'("Le Marillais"),49410,1084,676,114,9.47,-1.06667,47.35,6,36),
(49,new String'("Segré"),49500,6801,6404,425,15.99,-0.866667,47.6833,22,92),
(49,new String'("Courléon"),49390,167,126,12,13.77,0.15,47.3833,57,119),
(49,new String'("Feneu"),49460,2159,1799,84,25.52,-0.583333,47.5667,12,67),
(49,new String'("Montfaucon-Montigné"),49230,1970,518,117,16.8,-1.11667,47.1,27,122),
(49,new String'("Marans"),49500,523,429,54,9.59,-0.85,47.6333,26,51),
(49,new String'("Faye-d'Anjou"),49380,1289,1034,42,30.4,-0.516667,47.2833,22,104),
(49,new String'("Clefs"),49150,979,869,37,25.92,-0.066667,47.6167,30,97),
(49,new String'("Sainte-Christine"),49120,784,590,82,9.52,-0.849444,47.2864,53,124),
(49,new String'("Brossay"),49700,324,243,67,4.79,-0.211389,47.1642,55,94),
(49,new String'("Gennes"),49350,2086,1945,64,32.52,-0.233333,47.3333,22,98),
(49,new String'("Trémont"),49310,397,350,49,8.1,-0.45,47.15,65,116),
(49,new String'("La Possonnière"),49170,2342,2124,127,18.36,-0.683333,47.3833,12,67),
(49,new String'("Saint-Germain-sur-Moine"),49230,2789,2481,104,26.79,-1.13333,47.1167,27,111),
(49,new String'("Saint-Mathurin-sur-Loire"),49250,2374,2236,119,19.85,-0.318889,47.4131,18,22),
(49,new String'("Saint-Jean-de-la-Croix"),49130,239,237,130,1.83,-0.6,47.4167,12,19),
(49,new String'("Dénezé-sous-Doué"),49700,452,405,19,23.77,-0.266667,47.25,54,101),
(49,new String'("La Pellerine"),49490,160,134,30,5.3,0.123056,47.4614,54,97),
(49,new String'("Le Tremblay"),49520,349,365,15,22.97,-1.01667,47.6833,32,105),
(49,new String'("Corné"),49250,2866,2573,172,16.64,-0.35,47.4667,16,60),
(49,new String'("Montreuil-Bellay"),49260,4014,4111,81,48.96,-0.15,47.1333,29,73),
(49,new String'("Cantenay-Épinard"),49460,2070,1865,128,16.1,-0.566667,47.5333,12,49),
(49,new String'("Antoigné"),49260,485,414,27,17.87,-0.112778,47.0842,36,74),
(49,new String'("Ulmes"),49700,571,478,70,8.1,-0.183333,47.2167,39,97),
(49,new String'("Villevêque"),49140,2851,2608,101,28.03,-0.416667,47.55,14,51),
(49,new String'("Saint-Jean-des-Mauvrets"),49320,1744,1450,136,12.76,-0.45,47.4,16,81),
(49,new String'("Verrie"),49400,436,388,26,16.49,-0.183333,47.2667,61,94),
(49,new String'("Neuillé"),49680,945,870,69,13.56,-0.033333,47.35,27,111),
(49,new String'("Varennes-sur-Loire"),49730,1891,1800,83,22.66,0.05,47.2333,23,32),
(49,new String'("Martigné-Briand"),49540,1872,1705,68,27.21,-0.416667,47.2333,26,94),
(49,new String'("Combrée"),49520,2767,2410,114,24.16,-1.03333,47.7,32,106),
(49,new String'("Saint-Georges-du-Bois"),49250,412,343,43,9.42,-0.216667,47.5,26,82),
(49,new String'("Chaumont-d'Anjou"),49140,289,252,24,11.98,-0.283333,47.5333,26,70),
(49,new String'("Lasse"),49490,281,247,9,28.94,0.016667,47.5333,64,101),
(49,new String'("Saint-Martin-d'Arcé"),49150,794,650,60,13.18,-0.083333,47.5667,52,95),
(49,new String'("Varrains"),49400,1207,1146,354,3.4,-0.066667,47.2167,25,81),
(49,new String'("Villedieu-la-Blouère"),49450,2432,2102,170,14.24,-1.06667,47.15,47,109),
(49,new String'("Breil"),49490,277,309,18,15.09,0.15,47.4833,60,119),
(49,new String'("Saint-Rémy-en-Mauges"),49110,1436,1218,66,21.56,-1.06667,47.2667,17,109),
(49,new String'("Notre-Dame-d'Allençon"),49380,608,416,44,13.63,-0.466667,47.3,43,94),
(49,new String'("Fontevraud-l'Abbaye"),49590,1554,1188,104,14.82,0.0497222,47.1823,37,114),
(49,new String'("Louresse-Rochemenier"),49700,837,615,32,25.82,-0.316667,47.25,45,103),
(49,new String'("Tancoigné"),49310,338,221,79,4.25,-0.416667,47.1667,53,91),
(49,new String'("Chalonnes-sur-Loire"),49290,6492,5592,168,38.56,-0.766667,47.35,10,99),
(49,new String'("Montreuil-sur-Loir"),49140,494,297,41,11.99,-0.4,47.6167,15,54),
(49,new String'("Courchamps"),49260,464,432,66,6.99,-0.166667,47.2,34,80),
(49,new String'("Botz-en-Mauges"),49110,811,665,51,15.74,-1.0,47.3,11,141),
(49,new String'("Coutures"),49320,532,479,57,9.31,-0.35,47.3667,30,89),
(49,new String'("Sarrigné"),49800,818,743,275,2.97,-0.383333,47.5,22,57),
(49,new String'("Liré"),49530,2427,2164,76,31.81,-1.16667,47.35,5,105),
(49,new String'("Tiercé"),49125,4254,3607,126,33.7,-0.466667,47.6167,13,73),
(49,new String'("Brain-sur-Allonnes"),49650,2012,1798,60,33.32,0.066667,47.3,23,111),
(49,new String'("Méon"),49490,264,247,17,15.04,0.116667,47.5,49,89),
(49,new String'("Allonnes"),49650,3013,2556,82,36.33,0.0233333,47.2931,23,110),
(49,new String'("Landemont"),49270,1635,1483,87,18.67,-1.25,47.2667,18,104),
(49,new String'("Chambellay"),49220,344,299,26,12.86,-0.683333,47.6833,17,76),
(49,new String'("La Salle-et-Chapelle-Aubry"),49110,1266,1026,67,18.76,-0.985833,47.2553,43,121),
(49,new String'("Saint-Martin-du-Bois"),49500,896,686,41,21.73,-0.75,47.7,17,83),
(49,new String'("Ingrandes"),49123,1645,1420,247,6.65,-0.916667,47.4,7,69),
(49,new String'("Huillé"),49430,524,407,41,12.53,-0.3,47.65,17,78),
(49,new String'("Chaudefonds-sur-Layon"),49290,957,791,64,14.77,-0.7,47.3333,12,95),
(49,new String'("La Tessoualle"),49280,3059,2940,144,21.21,-0.85,47.0,72,164),
(49,new String'("Chenillé-Changé"),49220,149,148,28,5.3,-0.666667,47.7,17,72),
(49,new String'("La Renaudière"),49450,924,791,43,21.46,-1.05,47.1167,37,111),
(49,new String'("Écouflant"),49000,3748,3703,220,17.02,-0.533333,47.5333,12,50),
(49,new String'("Saint-Georges-des-Sept-Voies"),49350,695,576,45,15.22,-0.283333,47.35,31,93),
(49,new String'("Saint-Quentin-lès-Beaurepaire"),49150,300,211,39,7.51,-0.107778,47.6273,31,66),
(49,new String'("Bouchemaine"),49080,6175,6155,311,19.81,-0.6,47.4167,11,73),
(49,new String'("Saint-Martin-du-Fouilloux"),49170,1621,1368,109,14.82,-0.7,47.4333,28,81),
(49,new String'("Saint-Philbert-du-Peuple"),49160,1313,1117,80,16.38,-0.05,47.4,24,58),
(49,new String'("Andard"),49800,2504,2188,208,11.99,-0.4,47.45,16,38),
(49,new String'("Montilliers"),49310,1153,1120,43,26.36,-0.5,47.1833,42,119),
(49,new String'("Saint-Lézin"),49120,765,678,58,13.08,-0.766667,47.25,69,119),
(49,new String'("Le Pin-en-Mauges"),49110,1332,1214,78,16.88,-0.9,47.25,79,129),
(49,new String'("Beaulieu-sur-Layon"),49750,1449,1069,113,12.78,-0.583333,47.3167,17,104),
(49,new String'("Le Fuilet"),49270,1865,1807,120,15.43,-1.11667,47.2833,30,107),
(49,new String'("La Chapelle-Saint-Florent"),49410,1314,1065,82,15.84,-1.05,47.3333,7,102),
(49,new String'("Juigné-sur-Loire"),49610,2499,2273,200,12.49,-0.483333,47.4,16,66),
(49,new String'("Jallais"),49510,3208,3152,60,52.81,-0.866667,47.2,57,121),
(49,new String'("Freigné"),49440,1149,984,17,65.26,-1.1,47.55,27,85),
(49,new String'("Le Guédeniau"),49150,340,292,18,18.1,-0.05,47.5,48,102),
(49,new String'("La Ferrière-de-Flée"),49500,358,263,27,13.12,-0.85,47.7333,48,90),
(49,new String'("Souzay-Champigny"),49400,753,677,84,8.92,-0.016667,47.2333,26,93),
(49,new String'("Le Plessis-Grammoire"),49124,2283,2016,249,9.14,-0.433333,47.5,25,42),
(49,new String'("Saint-Christophe-la-Couperie"),49270,783,455,94,8.29,0.818612,47.2542,74,104),
(49,new String'("Brissac-Quincé"),49320,2931,2294,300,9.76,-0.448889,47.355,33,78),
(49,new String'("Doué-la-Fontaine"),49700,7518,7448,209,35.9,-0.283333,47.2,48,105),
(49,new String'("Forges"),49700,258,197,28,9.01,-0.25,47.2167,54,109),
(49,new String'("La Bohalle"),49800,1208,1245,129,9.35,-0.4,47.4167,16,21),
(49,new String'("Saint-Augustin-des-Bois"),49170,1020,826,37,27.28,-0.783333,47.4667,12,84),
(49,new String'("Ponts-de-Cé"),49130,11696,11391,598,19.55,-0.516667,47.4167,15,36),
(49,new String'("Somloire"),49360,940,790,29,31.83,-0.6,47.0333,107,184),
(49,new String'("Charcé-Saint-Ellier-sur-Aubance"),49320,776,629,46,16.84,-0.410278,47.3559,36,90),
(49,new String'("Vernoil-le-Fourrier"),49390,1251,1219,37,33.1,0.083333,47.3833,45,120),
(49,new String'("Bauné"),49140,1596,1290,76,20.99,-0.316667,47.5,22,76),
(49,new String'("Le Mesnil-en-Vallée"),49410,1468,1290,82,17.72,-0.933333,47.3667,7,127),
(49,new String'("Cornillé-les-Caves"),49140,431,437,41,10.38,-0.3,47.5,19,80),
(49,new String'("Thorigné-d'Anjou"),49220,1138,753,69,16.45,-0.666667,47.6333,17,66),
(49,new String'("Cuon"),49150,608,480,46,13.13,-0.1,47.4833,36,91),
(49,new String'("Valanjou"),49670,2228,1916,39,55.86,-0.595278,47.2139,44,116),
(49,new String'("Longué-Jumelles"),49160,6826,6944,70,96.2,-0.108056,47.3781,20,78),
(49,new String'("Gée"),49250,405,287,63,6.38,-0.233333,47.45,19,33),
(49,new String'("Saint-Quentin-en-Mauges"),49110,1036,996,48,21.31,-0.916667,47.2833,78,165),
(49,new String'("Bégrolles-en-Mauges"),49122,1877,1531,128,14.62,-0.933333,47.15,74,117),
(49,new String'("La Chaussaire"),49600,786,610,64,12.2,-1.15,47.2,52,106),
(49,new String'("La Breille-les-Pins"),49390,595,445,21,27.57,0.083333,47.3333,55,118),
(49,new String'("Maulévrier"),49360,3180,2827,95,33.42,-0.75,47.0167,87,176),
(49,new String'("La Tourlandry"),49120,1286,1199,66,19.34,-0.7,47.15,120,216),
(49,new String'("Sainte-Gemmes-d'Andigné"),49500,1486,1310,58,25.34,-0.884722,47.6748,22,62),
(49,new String'("Vezins"),49340,1634,1585,90,18.02,-0.716667,47.1167,113,184),
(49,new String'("Denée"),49190,1403,1390,89,15.6,-0.6,47.3833,12,90),
(49,new String'("Épieds"),49260,709,546,26,26.99,-0.05,47.15,29,111),
(49,new String'("Noyant-la-Plaine"),49700,324,180,64,4.99,-0.366667,47.2667,57,87),
(49,new String'("Saumur"),49400,27283,29916,411,66.25,-0.083333,47.2667,20,95),
(49,new String'("Andigné"),49220,357,262,53,6.63,-0.783333,47.6667,18,61),
(49,new String'("La Fosse-de-Tigné"),49540,210,184,37,5.54,-0.433333,47.1833,52,112),
(49,new String'("Montrevault"),49110,1281,1180,481,2.66,-1.05,47.2667,23,106),
(49,new String'("Saint-Christophe-du-Bois"),49280,2624,2500,120,21.75,-0.95,47.0333,53,141),
(49,new String'("Querré"),49330,319,240,25,12.41,-0.616667,47.6833,37,80),
(49,new String'("Rosiers-sur-Loire"),49350,2357,2247,90,26.11,-0.225278,47.3514,18,26),
(49,new String'("Chacé"),49400,1266,1309,197,6.42,-0.07179,47.2144,25,73),
(49,new String'("Bourg-l'Évêque"),49520,221,214,41,5.29,-1.01667,47.7333,54,103),
(49,new String'("Luigné"),49320,265,184,27,9.58,-0.383333,47.2833,56,82),
(49,new String'("Le Bourg-d'Iré"),49520,830,724,36,23.03,-0.967222,47.6803,27,96),
(49,new String'("Mûrs-Erigné"),49130,5326,5122,308,17.29,-0.55,47.4,12,80),
(49,new String'("Écuillé"),49460,600,462,47,12.55,-0.566667,47.6167,18,68),
(49,new String'("Saint-Macaire-en-Mauges"),49450,6829,5689,249,27.33,-1.0,47.1167,37,114),
(49,new String'("Chazé-sur-Argos"),49500,1023,841,33,30.82,-0.883333,47.6167,27,83),
(49,new String'("Jarzé"),49140,1691,1406,51,33.12,-0.233333,47.55,34,101),
(49,new String'("Saint-Pierre-Montlimart"),49110,3299,3053,148,22.29,-1.03333,47.2667,12,106),
(49,new String'("Turquant"),49730,563,448,71,7.86,0.033333,47.2167,26,103),
(49,new String'("La Pommeraye"),49620,3966,3626,101,39.0,-0.85,47.35,12,174),
(49,new String'("Champteussé-sur-Baconne"),49220,227,187,19,11.48,-0.65,47.6667,24,77),
(49,new String'("Villemoisan"),49370,619,495,29,20.75,-0.883333,47.4667,12,90),
(49,new String'("Vergonnes"),49420,319,288,30,10.38,-1.08333,47.7333,42,105),
(49,new String'("Aviré"),49500,454,424,31,14.36,-0.783333,47.7,28,87),
(49,new String'("Sœurdres"),49330,342,247,22,15.24,-0.566667,47.7333,39,79),
(50,new String'("Beauficel"),50150,167,163,18,9.13,-0.95,48.7333,113,357),
(50,new String'("Mortain"),50140,1733,2193,232,7.44,-0.933333,48.65,102,327),
(50,new String'("Sacey"),50170,545,516,35,15.27,-1.45,48.5,6,74),
(50,new String'("Vernix"),50370,171,133,29,5.84,-1.23333,48.7167,17,83),
(50,new String'("Champrepus"),50800,303,237,33,9.12,-1.31667,48.8333,57,156),
(50,new String'("Rouffigny"),50800,320,287,47,6.72,-1.25,48.8,125,206),
(50,new String'("Azeville"),50310,77,78,25,3.0,-1.31667,49.4667,6,34),
(50,new String'("Catz"),50500,121,109,43,2.78,-1.18333,49.3167,0,32),
(50,new String'("Équeurdreville-Hainneville"),50120,17339,18146,1351,12.83,0.345279,49.6484,0,173),
(50,new String'("Le Mesnil-Rogues"),50450,168,143,35,4.78,-1.38333,48.8667,32,129),
(50,new String'("Hamelin"),50730,111,123,45,2.46,-1.21667,48.55,88,161),
(50,new String'("Sainte-Colombe"),50390,215,157,43,4.99,-1.51667,49.4167,2,37),
(50,new String'("La Croix-Avranchin"),50240,477,431,44,10.79,-1.38333,48.55,33,92),
(50,new String'("Le Perron"),50160,188,142,40,4.66,-0.9,49.05,92,180),
(50,new String'("Saint-Brice-de-Landelles"),50730,664,617,44,14.77,-1.15,48.5333,59,202),
(50,new String'("Besneville"),50390,668,516,36,18.27,-1.63333,49.3667,10,116),
(50,new String'("Fleury"),50800,921,760,73,12.6,-1.28333,48.85,109,201),
(50,new String'("La Feuillie"),50190,296,263,23,12.46,-1.48333,49.1833,11,37),
(50,new String'("Ferrières"),50640,57,66,16,3.51,-0.9575,48.5439,109,234),
(50,new String'("Saint-Joseph"),50700,805,734,82,9.78,-1.53333,49.5333,32,122),
(50,new String'("Carnet"),50240,476,433,46,10.18,-1.35,48.5167,40,138),
(50,new String'("Saint-Martin-de-Varreville"),50480,217,155,25,8.36,-1.23333,49.4333,0,41),
(50,new String'("Teurthéville-Bocage"),50630,615,537,28,21.47,-1.38333,49.5833,32,116),
(50,new String'("Aucey-la-Plaine"),50170,456,363,48,9.39,-1.48333,48.5333,5,61),
(50,new String'("Huberville"),50700,354,282,61,5.76,-1.41667,49.5167,29,118),
(50,new String'("Liesville-sur-Douve"),50480,224,153,42,5.24,-1.33333,49.35,2,18),
(50,new String'("Bérigny"),50810,387,366,31,12.15,-0.933333,49.15,73,159),
(50,new String'("Montmartin-sur-Mer"),50590,1309,1094,133,9.81,-1.51667,48.9833,2,60),
(50,new String'("Dangy"),50750,651,603,65,9.93,-1.21667,49.05,70,161),
(50,new String'("Agon-Coutainville"),50230,2834,2724,229,12.35,-1.575,49.0417,0,49),
(50,new String'("Sénoville"),50270,214,179,29,7.22,-1.76667,49.4333,34,121),
(50,new String'("Glatigny"),50250,144,144,28,4.99,-1.63333,49.2833,5,34),
(50,new String'("Beaucoudray"),50420,154,129,32,4.7,-1.13333,48.9667,84,204),
(50,new String'("La Haye-d'Ectot"),50270,245,195,33,7.32,-1.73333,49.3833,12,125),
(50,new String'("Montbray"),50410,362,407,25,14.04,-1.1,48.8833,79,266),
(50,new String'("Le Tanu"),50320,353,274,34,10.12,-1.35,48.8167,68,166),
(50,new String'("Saint-Hilaire-Petitville"),50500,1362,1389,136,9.99,-1.23333,49.3,0,31),
(50,new String'("Saint-Patrice-de-Claids"),50190,157,163,28,5.58,-1.43333,49.2333,9,34),
(50,new String'("Jobourg"),50440,501,377,49,10.15,-1.90375,49.6833,0,181),
(50,new String'("Hauteville-sur-Mer"),50590,656,619,198,3.31,-1.53333,48.9833,0,48),
(50,new String'("Picauville"),50360,1934,1986,101,19.1,-1.4,49.3833,2,30),
(50,new String'("Saint-Martin-de-Cenilly"),50210,202,206,29,6.76,-1.28333,48.9833,74,136),
(50,new String'("Mobecq"),50250,251,208,31,7.99,-1.51667,49.2667,32,110),
(50,new String'("Guilberville"),50160,994,821,44,22.15,-0.95,48.9833,70,262),
(50,new String'("La Meauffe"),50880,1081,1035,105,10.22,-1.11667,49.1833,4,87),
(50,new String'("Ouville"),50210,463,399,41,11.2,-1.36667,49.0167,29,121),
(50,new String'("Saint-Martin-d'Aubigny"),50190,538,472,35,15.16,-1.35,49.1667,10,89),
(50,new String'("Placy-Montaigu"),50160,219,179,24,8.99,-0.9,49.0333,109,228),
(50,new String'("Saint-Laurent-de-Terregatte"),50111,566,572,34,16.35,-1.25,48.5667,14,159),
(50,new String'("Amigny"),50620,144,123,39,3.69,-1.18333,49.15,13,57),
(50,new String'("Milly"),50600,342,330,35,9.65,-1.01667,48.6,65,128),
(50,new String'("Coudeville-sur-Mer"),50290,878,738,100,8.7,-1.51667,48.8833,3,69),
(50,new String'("La Barre-de-Semilly"),50810,945,792,122,7.74,-1.03333,49.1167,48,166),
(50,new String'("La Chapelle-Cécelin"),50800,214,215,40,5.22,-1.16667,48.8167,160,242),
(50,new String'("Villechien"),50140,192,206,17,10.83,-0.983333,48.5833,70,165),
(50,new String'("Loges-Marchis"),50600,1022,871,51,19.78,-1.1,48.55,69,208),
(50,new String'("Hiesville"),50480,74,69,18,4.03,-1.26667,49.3667,2,38),
(50,new String'("La Bloutière"),50800,402,417,43,9.31,-1.23333,48.8667,80,172),
(50,new String'("Taillepied"),50390,29,25,13,2.15,0.417779,49.3725,7,48),
(50,new String'("Moon-sur-Elle"),50680,835,813,84,9.84,-1.05,49.2,3,48),
(50,new String'("Fervaches"),50420,383,285,78,4.89,-1.08333,49.0,31,119),
(50,new String'("Hambye"),50450,1192,1120,40,29.57,-1.26667,48.95,47,166),
(50,new String'("Montaigu-les-Bois"),50450,238,209,35,6.67,-1.28333,48.9,68,169),
(50,new String'("Morigny"),50410,87,83,20,4.35,-1.06667,48.8833,77,163),
(50,new String'("Moitiers-d'Allonne"),50270,685,612,39,17.21,-1.78333,49.4,0,127),
(50,new String'("Fourneaux"),50420,96,90,28,3.34,-1.03333,48.9667,37,147),
(50,new String'("Anctoville-sur-Boscq"),50400,498,418,231,2.15,0.467779,48.8439,22,69),
(50,new String'("Chèvreville"),50600,203,198,45,4.45,-1.05,48.6167,71,122),
(50,new String'("Coulouvray-Boisbenâtre"),50670,540,538,31,17.25,-1.1,48.7833,130,315),
(50,new String'("Lengronne"),50510,449,429,37,12.07,-1.38333,48.9333,35,119),
(50,new String'("Saint-Pois"),50670,494,529,63,7.78,-1.06667,48.75,73,289),
(50,new String'("Moyon"),50860,1129,894,47,23.74,-1.11667,49.0,50,145),
(50,new String'("Saint-Sébastien-de-Raids"),50190,362,281,68,5.27,-1.36667,49.1833,7,25),
(50,new String'("Herqueville"),50440,159,145,54,2.91,-1.88333,49.6667,0,178),
(50,new String'("Chaulieu"),50150,284,271,26,10.64,-0.861944,48.7356,243,366),
(50,new String'("Hocquigny"),50320,192,144,62,3.05,-1.41667,48.8167,67,126),
(50,new String'("Le Ham"),50310,346,349,89,3.86,-1.41667,49.45,3,26),
(50,new String'("Le Mesnil-Vigot"),50570,261,214,80,3.26,-1.28333,49.15,2,37),
(50,new String'("Saint-Jean-des-Baisants"),50810,1203,994,89,13.37,-0.966667,49.1,50,217),
(50,new String'("Saint-Nicolas-de-Pierrepont"),50250,262,250,32,8.13,-1.58333,49.3167,7,123),
(50,new String'("Plomb"),50870,403,367,49,8.16,-1.3,48.7333,14,148),
(50,new String'("Saint-Jean-de-Savigny"),50680,381,278,50,7.58,-0.983333,49.2,17,101),
(50,new String'("Fierville-les-Mines"),50580,311,252,41,7.44,-1.66667,49.3833,22,108),
(50,new String'("Omonville-la-Rogue"),50440,524,522,122,4.29,-1.85,49.7,0,133),
(50,new String'("Vindefontaine"),50250,312,273,38,8.13,-1.41667,49.3333,2,41),
(50,new String'("Videcosville"),50630,87,80,34,2.51,-1.36667,49.5667,39,87),
(50,new String'("Annoville"),50660,632,547,74,8.47,-1.53333,48.9667,4,58),
(50,new String'("Cavigny"),50620,204,243,30,6.78,-1.1,49.2,2,66),
(50,new String'("Neufmesnil"),50250,190,175,35,5.33,-1.53333,49.3167,17,90),
(50,new String'("Champs-de-Losque"),50620,199,203,21,9.31,-1.23333,49.1833,0,35),
(50,new String'("Lithaire"),50250,551,518,38,14.21,-1.48333,49.3,15,123),
(50,new String'("Couvains"),50680,444,387,29,15.03,0.993057,49.1659,59,147),
(50,new String'("Saint-Martin-le-Hébert"),50260,136,169,63,2.13,0.391668,49.5109,53,147),
(50,new String'("Tirepied"),50870,777,694,41,18.77,-1.26667,48.7167,8,149),
(50,new String'("Sottevast"),50260,1353,1197,125,10.82,-1.6,49.5167,30,147),
(50,new String'("Genêts"),50530,417,440,60,6.89,-1.48333,48.6833,6,38),
(50,new String'("Saint-Germain-le-Gaillard"),50340,703,624,50,13.83,-1.78333,49.4833,14,127),
(50,new String'("Contrières"),50660,392,333,42,9.12,-1.43333,48.9833,8,101),
(50,new String'("Écausseville"),50310,101,88,19,5.27,-1.36667,49.4667,3,31),
(50,new String'("La Mancellière-sur-Vire"),50750,487,486,71,6.8,-1.06667,49.0667,17,109),
(50,new String'("Brévands"),50500,347,317,25,13.87,-1.18333,49.3333,0,29),
(50,new String'("Feugères"),50190,339,274,40,8.31,-1.31667,49.15,4,112),
(50,new String'("Baudreville"),50250,82,84,17,4.67,-1.63333,49.3,7,41),
(50,new String'("Heussé"),50640,237,267,16,14.57,-0.9,48.5,155,228),
(50,new String'("Néville-sur-Mer"),50330,187,169,54,3.46,-1.33333,49.6833,0,52),
(50,new String'("Saint-André-de-l'Épine"),50680,538,464,74,7.24,-1.0,49.1333,64,171),
(50,new String'("Vidouville"),50810,130,116,29,4.46,-0.9,49.1,77,192),
(50,new String'("Perques"),50260,161,161,33,4.85,-1.66667,49.45,13,122),
(50,new String'("Courcy"),50200,568,470,49,11.45,-1.4,49.05,18,143),
(50,new String'("Beslon"),50800,536,498,31,17.24,-1.15,48.85,118,237),
(50,new String'("Saint-Denis-le-Gast"),50450,557,488,33,16.73,-1.33333,48.95,29,123),
(50,new String'("Margueray"),50410,135,128,29,4.64,-1.13333,48.9,169,257),
(50,new String'("Brillevast"),50330,323,299,35,9.07,-1.4,49.6333,37,132),
(50,new String'("Le Mesnil-Villeman"),50450,224,243,20,10.8,-1.33333,48.8667,42,164),
(50,new String'("Flottemanville-Hague"),50690,885,731,77,11.39,-1.71667,49.6167,45,179),
(50,new String'("Tollevast"),50470,1198,1160,96,12.36,-1.63333,49.5667,68,176),
(50,new String'("Le Mesnil-Ozenne"),50220,245,138,53,4.59,-1.23333,48.6667,39,197),
(50,new String'("Sideville"),50690,566,488,74,7.63,-1.68333,49.5833,18,171),
(50,new String'("Saint-Pierre-Langers"),50530,552,386,65,8.4,-1.5,48.7833,7,121),
(50,new String'("Bricqueville-sur-Mer"),50290,1165,906,90,12.88,-1.51667,48.9167,3,73),
(50,new String'("Champcervon"),50320,217,157,38,5.63,-1.4,48.7833,81,132),
(50,new String'("Joganville"),50310,89,84,31,2.87,-1.35,49.4667,13,34),
(50,new String'("Saint-Brice"),50300,136,115,53,2.55,0.692223,48.6984,9,115),
(50,new String'("Belval"),50210,301,274,52,5.72,-1.36667,49.0333,32,145),
(50,new String'("Champcey"),50530,205,149,63,3.24,-1.45,48.7333,20,105),
(50,new String'("La Trinité"),50800,398,312,43,9.16,-1.23333,48.7833,130,217),
(50,new String'("La Mouche"),50320,200,148,45,4.43,-1.35,48.8,97,153),
(50,new String'("Sainte-Pience"),50870,298,238,34,8.68,-1.3,48.75,105,201),
(50,new String'("Saint-Floxel"),50310,473,417,55,8.45,-1.35,49.5,15,73),
(50,new String'("Saint-Jean-du-Corail-des-Bois"),50370,77,76,21,3.63,0.79889,48.7675,80,217),
(50,new String'("La Pernelle"),50630,249,303,34,7.23,-1.3,49.6167,1,121),
(50,new String'("Saint-Aubin-des-Préaux"),50380,413,379,50,8.24,-1.5,48.8,11,94),
(50,new String'("Saint-Martin-de-Landelles"),50730,1190,1226,59,19.91,-1.18333,48.55,57,192),
(50,new String'("Sainte-Mère-Église"),50480,1632,1586,92,17.68,-1.31667,49.4167,1,41),
(50,new String'("Saint-Cyr-du-Bailleul"),50720,406,443,17,23.41,-0.8,48.5667,92,226),
(50,new String'("Brainville"),50200,208,120,65,3.19,-1.5,49.0833,50,99),
(50,new String'("Saint-Martin-de-Bonfossé"),50750,543,499,42,12.68,-1.16667,49.05,64,168),
(50,new String'("Saint-Quentin-sur-le-Homme"),50220,1251,1090,74,16.84,-1.31667,48.65,6,95),
(50,new String'("Braffais"),50870,190,163,32,5.79,-1.26667,48.75,56,182),
(50,new String'("Avranches"),50300,8020,8509,1782,4.5,-1.36667,48.6833,7,108),
(50,new String'("Montanel"),50240,369,368,23,15.4,-1.41667,48.5,19,124),
(50,new String'("Courtils"),50220,237,260,43,5.39,-1.43333,48.6333,4,28),
(50,new String'("Folligny"),50320,1005,779,85,11.8,-1.41667,48.8167,59,128),
(50,new String'("Neuville-au-Plain"),50480,108,94,22,4.7,-1.33333,49.4333,2,36),
(50,new String'("Saint-Jean-du-Corail"),50140,265,282,18,14.04,-0.908333,48.6083,77,311),
(50,new String'("Baupte"),50500,458,430,200,2.29,-1.35,49.3,2,26),
(50,new String'("Tourlaville"),50110,15910,17556,925,17.19,-1.56667,49.6333,0,132),
(50,new String'("Chavoy"),50870,152,77,41,3.7,-1.33333,48.7333,20,127),
(50,new String'("Grosville"),50340,711,623,54,13.15,-1.75,49.5,56,137),
(50,new String'("Perriers-en-Beauficel"),50150,226,218,24,9.3,-1.0,48.7333,75,331),
(50,new String'("Colomby"),50700,482,429,43,11.16,-1.48333,49.45,7,44),
(50,new String'("Saint-Laurent-de-Cuves"),50670,488,481,32,14.8,-1.11667,48.75,32,226),
(50,new String'("Saint-Jean-de-la-Rivière"),50270,355,278,99,3.57,-1.7,49.3667,4,75),
(50,new String'("Yquelon"),50400,1014,959,473,2.14,-1.55,48.85,17,67),
(50,new String'("La Chapelle-Urée"),50370,128,122,27,4.6,-1.15,48.6667,140,237),
(50,new String'("Virey"),50600,1028,900,60,16.94,-1.13333,48.5833,56,146),
(50,new String'("Saint-Sauveur-de-Pierrepont"),50250,132,143,16,8.18,-1.58333,49.3333,7,42),
(50,new String'("Chevry"),50420,79,82,21,3.62,-1.11667,48.9667,54,175),
(50,new String'("Auvers"),50500,671,589,35,18.76,-1.31667,49.3,0,26),
(50,new String'("Cosqueville"),50330,580,495,53,10.9,-1.4,49.7,0,85),
(50,new String'("Bricquebosq"),50340,510,447,63,8.05,-1.71667,49.5333,59,128),
(50,new String'("Bacilly"),50530,872,670,54,15.88,-1.43333,48.7,7,75),
(50,new String'("Éroudeville"),50310,243,220,49,4.86,-1.38333,49.4833,6,59),
(50,new String'("Bréville-sur-Mer"),50290,819,610,119,6.86,-1.55,48.8667,0,69),
(50,new String'("Saint-Martin-le-Bouillant"),50800,291,305,23,12.37,-1.18333,48.7833,90,252),
(50,new String'("Chanteloup"),50510,331,240,79,4.17,-1.48333,48.9,24,72),
(50,new String'("Turqueville"),50480,144,117,27,5.21,-1.28333,49.4167,3,42),
(50,new String'("Saint-Loup"),50300,697,477,108,6.45,-1.3,48.6667,16,124),
(50,new String'("Golleville"),50390,179,168,27,6.46,-1.51667,49.4333,6,45),
(50,new String'("Éculleville"),50440,37,42,15,2.33,-1.81667,49.6833,0,152),
(50,new String'("Jullouville"),50610,2345,2414,107,21.88,0.434168,48.7748,5,115),
(50,new String'("Lingreville"),50660,920,917,101,9.04,-1.53333,48.95,2,61),
(50,new String'("Montjoie-Saint-Martin"),50240,272,265,36,7.49,-1.3,48.5333,75,188),
(50,new String'("Savigny"),50210,412,335,40,10.16,-1.33333,49.05,35,135),
(50,new String'("Bellefontaine"),50520,159,160,23,6.73,-0.966667,48.6833,100,292),
(50,new String'("Condé-sur-Vire"),50890,3331,2983,134,24.85,-1.03333,49.05,17,153),
(50,new String'("Lapenty"),50600,429,434,28,14.89,-1.0,48.5833,65,198),
(50,new String'("Flamanville"),50340,1725,1683,238,7.22,-1.86667,49.5333,0,90),
(50,new String'("Angoville-sur-Ay"),50430,256,230,38,6.72,-1.55,49.25,5,54),
(50,new String'("Saint-Ébremond-de-Bonfossé"),50750,768,650,64,11.9,-1.15,49.0667,12,115),
(50,new String'("Saint-Senier-de-Beuvron"),50240,309,306,27,11.21,-1.31667,48.5833,17,170),
(50,new String'("Cresnays"),50370,254,271,25,9.78,-1.13333,48.7167,32,131),
(50,new String'("Saint-Jean-le-Thomas"),50530,430,396,180,2.38,-1.51667,48.7333,5,90),
(50,new String'("Brécey"),50670,2177,2115,103,20.96,-1.16667,48.7333,22,111),
(50,new String'("Saint-Malo-de-la-Lande"),50200,461,305,114,4.01,-1.53333,49.0667,14,71),
(50,new String'("Le Mesnil-Herman"),50750,148,123,77,1.91,-1.15,49.0333,90,150),
(50,new String'("Saint-Louet-sur-Vire"),50420,199,172,27,7.33,-0.983333,48.9833,60,172),
(50,new String'("Buais"),50640,559,652,31,17.92,-0.966667,48.5167,115,238),
(50,new String'("Émondeville"),50310,359,291,67,5.33,-1.33333,49.4667,7,37),
(50,new String'("Surtainville"),50270,1235,1072,84,14.61,-1.81667,49.4667,3,81),
(50,new String'("Granville"),50400,12969,12688,1310,9.9,-1.6,48.8333,0,67),
(50,new String'("Coutances"),50200,9355,9546,747,12.51,-1.43333,49.05,12,150),
(50,new String'("Rauville-la-Bigot"),50260,1188,861,69,17.16,-1.68333,49.5167,52,151),
(50,new String'("Saint-Samson-de-Bonfossé"),50750,901,728,143,6.28,-1.13333,49.05,28,159),
(50,new String'("Le Valdécie"),50260,118,137,29,4.0,-1.65,49.4167,13,122),
(50,new String'("Le Mesnil-Garnier"),50450,230,233,22,10.41,-1.3,48.8667,73,166),
(50,new String'("Donville-les-Bains"),50350,3242,3358,1178,2.75,-1.56667,48.85,4,68),
(50,new String'("Cerisy-la-Forêt"),50680,937,839,39,23.81,-0.933333,49.2,34,131),
(50,new String'("Baudre"),50000,536,357,140,3.81,-1.06667,49.0833,14,93),
(50,new String'("Saint-André-de-Bohon"),50500,313,264,30,10.43,-1.25,49.2333,0,21),
(50,new String'("Saint-Germain-de-Tournebut"),50700,394,355,28,13.91,-1.38333,49.5333,22,101),
(50,new String'("Le Mesnil-Véneron"),50620,109,94,38,2.86,-1.16667,49.2333,9,44),
(50,new String'("Saint-Marcouf"),50310,331,376,24,13.38,0.709168,49.4731,0,36),
(50,new String'("La Bonneville"),50360,173,143,27,6.31,-1.45,49.4,3,32),
(50,new String'("Néhou"),50390,553,440,34,15.98,-1.53333,49.4167,3,74),
(50,new String'("Le Grand-Celland"),50370,568,448,45,12.45,-1.18333,48.6833,50,225),
(50,new String'("Saint-Germain-sur-Sèves"),50190,199,213,24,8.19,-1.36667,49.2167,3,19),
(50,new String'("Percy"),50410,2281,2127,61,37.04,-1.18333,48.9167,60,275),
(50,new String'("Sortosville-en-Beaumont"),50270,312,317,30,10.24,-1.71667,49.4333,18,144),
(50,new String'("Saint-Georges-de-Livoye"),50370,209,181,37,5.53,-1.21667,48.7333,22,120),
(50,new String'("Sébeville"),50480,32,25,11,2.88,-1.28333,49.3833,3,38),
(50,new String'("Le Fresne-Poret"),50850,228,241,22,10.08,-0.833333,48.7,204,316),
(50,new String'("Saint-Georges-de-la-Rivière"),50270,280,212,73,3.79,0.270834,49.3642,5,78),
(50,new String'("Saint-Pierre-Église"),50840,1785,1796,221,8.06,-1.4,49.6667,4,138),
(50,new String'("Carentan"),50500,6063,6371,387,15.66,-1.23333,49.3,0,30),
(50,new String'("Aumeville-Lestre"),50630,142,139,58,2.44,-1.31667,49.5333,2,41),
(50,new String'("Sainte-Suzanne-sur-Vire"),50750,552,509,109,5.05,-1.06667,49.0667,17,110),
(50,new String'("Bretteville"),50110,1067,1076,184,5.78,0.479445,49.6562,0,156),
(50,new String'("Marchésieux"),50190,716,665,35,19.89,-1.28333,49.1833,0,22),
(50,new String'("Saint-Ovin"),50300,769,674,59,12.93,0.738612,48.6814,36,193),
(50,new String'("Chasseguey"),50520,77,88,25,3.06,-1.08333,48.65,92,210),
(50,new String'("Biville"),50440,553,414,63,8.7,-1.81667,49.6167,2,179),
(50,new String'("Le Mesnil-Eury"),50570,187,150,54,3.46,-1.23333,49.15,2,33),
(50,new String'("Magneville"),50260,293,282,30,9.49,-1.55,49.45,6,51),
(50,new String'("Boisroger"),50200,194,153,36,5.3,-1.55,49.0833,28,78),
(50,new String'("Saint-Martin-le-Gréard"),50690,434,264,151,2.86,-1.65,49.55,62,126),
(50,new String'("Digosville"),50110,1532,1451,165,9.27,-1.53333,49.6333,0,142),
(50,new String'("Lestre"),50310,259,224,34,7.57,-1.33333,49.5167,1,45),
(50,new String'("Anneville-sur-Mer"),50560,238,191,63,3.73,-1.58333,49.1167,0,16),
(50,new String'("Teurthéville-Hague"),50690,915,747,71,12.73,-1.73333,49.5833,32,142),
(50,new String'("Saint-Jean-des-Champs"),50320,1328,1116,68,19.4,-1.46667,48.8333,21,122),
(50,new String'("La Haye-Bellefond"),50410,78,69,27,2.82,0.815834,48.9837,92,137),
(50,new String'("Tréauville"),50340,723,632,56,12.84,-1.81667,49.5167,4,130),
(50,new String'("Moitiers-en-Bauptois"),50360,334,283,41,8.04,-1.43333,49.3667,1,37),
(50,new String'("Gouberville"),50330,115,137,41,2.79,-1.31667,49.6833,0,38),
(50,new String'("Ravenoville"),50480,263,252,22,11.65,-1.26667,49.4667,1,32),
(50,new String'("Heugueville-sur-Sienne"),50200,535,486,90,5.88,-1.51667,49.0333,5,89),
(50,new String'("Crosville-sur-Douve"),50360,62,58,15,4.06,-1.48333,49.3833,3,33),
(50,new String'("Flottemanville"),50700,200,176,41,4.85,-1.45,49.4833,7,43),
(50,new String'("Carolles"),50740,788,0,204,3.85,-1.55,48.75,0,77),
(50,new String'("Lozon"),50570,307,308,34,8.86,-1.26667,49.1333,4,94),
(50,new String'("Angey"),50530,238,140,96,2.47,-1.5,48.75,85,121),
(50,new String'("Équilly"),50320,162,128,28,5.65,-1.38333,48.8333,54,134),
(50,new String'("Tanis"),50170,315,260,42,7.49,-1.45,48.5833,7,51),
(50,new String'("Le Mesnil-Tôve"),50520,234,207,19,11.74,-1.01667,48.7,60,291),
(50,new String'("Catteville"),50390,118,105,25,4.57,-1.56667,49.35,7,40),
(50,new String'("Le Mesnil-Raoult"),50420,386,320,96,3.98,-1.06667,49.0333,19,122),
(50,new String'("La Lande-d'Airou"),50800,500,482,33,15.1,-1.28333,48.8167,75,215),
(50,new String'("Ger"),50850,851,953,21,39.78,-0.8,48.6833,162,341),
(50,new String'("Branville-Hague"),50440,178,108,83,2.12,-1.78333,49.65,98,164),
(50,new String'("Saint-Georges-d'Elle"),50680,384,364,42,8.96,-0.966667,49.15,71,192),
(50,new String'("Subligny"),50870,344,310,43,8.0,-1.36667,48.75,45,140),
(50,new String'("Muneville-le-Bingard"),50490,684,539,34,19.81,-1.48333,49.1333,23,80),
(50,new String'("Saint-Pellerin"),50500,394,315,90,4.37,-1.18333,49.3,0,35),
(50,new String'("Saint-Clément-Rancoudray"),50140,536,581,16,32.1,-0.886667,48.6745,225,321),
(50,new String'("Reigneville-Bocage"),50390,30,28,13,2.27,-1.46667,49.4,13,37),
(50,new String'("Sainte-Marie-du-Mont"),50480,750,803,27,26.98,-1.21667,49.3833,1,42),
(50,new String'("Marcilly"),50220,372,332,41,8.86,0.748057,48.6481,17,163),
(50,new String'("Saint-Nicolas-des-Bois"),50370,111,105,31,3.57,0.806112,48.7559,55,180),
(50,new String'("Bréhal"),50290,3045,2599,239,12.71,-1.51667,48.9,4,71),
(50,new String'("Vasteville"),50440,1108,872,66,16.72,-1.76667,49.6,3,175),
(50,new String'("Saint-Jean-de-Daye"),50880,601,614,141,4.24,-1.13333,49.2333,0,47),
(50,new String'("Le Mesnil-Gilbert"),50670,150,154,19,7.85,-1.06667,48.7167,47,205),
(50,new String'("Notre-Dame-de-Livoye"),50370,127,121,35,3.54,-1.2,48.75,31,120),
(50,new String'("Cuves"),50670,349,360,36,9.69,-1.11667,48.7167,32,128),
(50,new String'("Montreuil-sur-Lozon"),50570,306,241,47,6.45,-1.23333,49.1333,15,107),
(50,new String'("Vaudreville"),50310,80,80,26,3.03,-1.36667,49.5167,12,72),
(50,new String'("Raids"),50500,192,217,28,6.8,-1.35,49.2167,2,19),
(50,new String'("Héauville"),50340,500,373,46,10.83,-1.8,49.5833,4,142),
(50,new String'("Le Petit-Celland"),50370,183,161,27,6.57,-1.21667,48.7,22,193),
(50,new String'("Quettehou"),50630,1586,1475,98,16.17,-1.3,49.6,1,104),
(50,new String'("Crasville"),50630,250,255,34,7.18,-1.33333,49.55,2,87),
(50,new String'("Montaigu-la-Brisette"),50700,506,428,34,14.71,0.580279,49.565,37,131),
(50,new String'("Bretteville-sur-Ay"),50430,385,317,39,9.75,-1.63333,49.2667,4,38),
(50,new String'("L'Étang-Bertrand"),50260,365,280,41,8.74,-1.55833,49.4667,9,81),
(50,new String'("Le Vast"),50630,304,298,23,13.04,-1.35,49.6167,21,121),
(50,new String'("Foucarville"),50480,130,108,25,5.06,-1.25,49.45,1,32),
(50,new String'("Prétot-Sainte-Suzanne"),50250,315,355,27,11.64,-1.41667,49.3167,4,44),
(50,new String'("Saint-Lô-d'Ourville"),50580,530,481,49,10.7,-1.66667,49.3333,3,38),
(50,new String'("Notre-Dame-du-Touchet"),50140,641,658,36,17.65,-0.95,48.5833,71,152),
(50,new String'("Hyenville"),50660,321,269,94,3.39,-1.46667,49.0,7,53),
(50,new String'("La Chaise-Baudouin"),50370,448,396,37,12.06,-1.23333,48.7667,55,205),
(50,new String'("Vaudrimesnil"),50490,393,386,64,6.05,-1.41667,49.15,16,40),
(50,new String'("Saint-Barthélemy"),50140,348,361,51,6.81,-0.95,48.6833,165,308),
(50,new String'("Cametours"),50570,414,381,57,7.22,-1.28333,49.0667,64,126),
(50,new String'("Muneville-sur-Mer"),50290,392,314,52,7.42,-1.48333,48.9333,19,74),
(50,new String'("Morsalines"),50630,204,206,55,3.65,-1.3,49.5667,3,88),
(50,new String'("Saint-Symphorien-le-Valois"),50250,822,716,141,5.8,-1.55,49.3,23,81),
(50,new String'("Husson"),50640,231,260,16,13.59,-0.883333,48.5667,78,133),
(50,new String'("Tamerville"),50700,644,583,35,18.2,-1.45,49.5333,33,126),
(50,new String'("Saint-Michel-de-Montjoie"),50670,313,371,21,14.46,-1.03333,48.7333,185,358),
(50,new String'("Tourville-sur-Sienne"),50200,776,588,103,7.5,-1.55,49.05,5,103),
(50,new String'("Méautis"),50500,651,642,38,16.98,-1.3,49.2833,0,29),
(50,new String'("Saint-Aubin-de-Terregatte"),50111,711,562,33,20.96,-1.3,48.5833,12,181),
(50,new String'("Laulne"),50430,157,183,17,9.06,-1.46667,49.25,13,103),
(50,new String'("Le Rozel"),50340,282,261,51,5.52,-1.83333,49.4833,0,102),
(50,new String'("Gavray"),50450,1388,1482,67,20.6,-1.35,48.9167,24,186),
(50,new String'("Lolif"),50530,546,523,43,12.5,-1.38333,48.7333,9,120),
(50,new String'("Négreville"),50260,829,734,72,11.48,-1.55,49.4833,14,79),
(50,new String'("Breuville"),50260,378,351,44,8.41,-1.68333,49.5333,58,138),
(50,new String'("Saint-Germain-des-Vaux"),50440,414,463,65,6.36,-1.92054,49.7127,0,123),
(50,new String'("Pierreville"),50340,702,586,69,10.11,-1.78333,49.4833,35,117),
(50,new String'("Le Mesnil-Amand"),50450,162,145,23,6.78,-1.36667,48.8833,30,131),
(50,new String'("Huisnes-sur-Mer"),50170,208,151,30,6.75,-1.45,48.6,6,38),
(50,new String'("Amfreville"),50480,293,290,29,10.1,-1.38333,49.4167,1,31),
(50,new String'("Omonville-la-Petite"),50440,137,132,22,6.16,-1.88333,49.7,0,181),
(50,new String'("Troisgots"),50420,283,302,37,7.53,-1.06667,49.0167,25,133),
(50,new String'("Périers"),50190,2390,2558,163,14.62,-1.41667,49.1833,6,36),
(50,new String'("La Rochelle-Normande"),50530,316,254,41,7.53,-1.43333,48.7667,44,126),
(50,new String'("Surville"),50250,196,134,26,7.4,-1.65,49.2833,4,41),
(50,new String'("Morville"),50700,260,262,36,7.08,-1.5,49.4833,12,47),
(50,new String'("Lieusaint"),50700,376,333,72,5.22,-1.46667,49.4667,9,44),
(50,new String'("Montpinchon"),50210,560,494,33,16.94,-1.31667,49.0167,37,148),
(50,new String'("Saint-Gilles"),50180,903,783,115,7.84,-1.16667,49.1,12,104),
(50,new String'("Montmartin-en-Graignes"),50620,560,522,18,30.34,-1.15,49.2833,0,38),
(50,new String'("Monthuchon"),50200,607,590,79,7.66,-1.41667,49.0833,69,176),
(50,new String'("Querqueville"),50460,5244,5147,943,5.56,-1.7,49.6667,0,115),
(50,new String'("Valcanville"),50760,372,387,57,6.45,-1.31667,49.6333,8,86),
(50,new String'("Clitourps"),50330,201,138,31,6.3,-1.36667,49.65,53,137),
(50,new String'("Saint-James"),50240,2678,2918,149,17.96,-1.31667,48.5333,28,151),
(50,new String'("Villedieu-les-Poêles"),50800,3871,4104,480,8.05,-1.21667,48.8333,98,217),
(50,new String'("Saint-Hilaire-du-Harcouët"),50600,3959,4363,391,10.12,-1.1,48.5833,58,119),
(50,new String'("Fontenay"),50140,316,292,46,6.85,-1.01667,48.6167,78,139),
(50,new String'("Moulines"),50600,302,290,40,7.41,-1.03333,48.5417,74,183),
(50,new String'("Sortosville"),50310,103,72,41,2.48,-1.43333,49.4833,15,53),
(50,new String'("Doville"),50250,293,257,26,11.09,-1.53333,49.3333,2,128),
(50,new String'("Le Mesnillard"),50600,281,271,28,9.75,-1.08333,48.6333,72,205),
(50,new String'("Loges-sur-Brécey"),50370,156,147,29,5.27,-1.16667,48.7667,53,165),
(50,new String'("Hardinvast"),50690,896,804,122,7.3,-1.65,49.5833,67,172),
(50,new String'("Bolleville"),50250,380,368,62,6.09,-1.56667,49.3,7,44),
(50,new String'("Boisyvon"),50800,110,106,28,3.85,-1.13333,48.8,170,270),
(50,new String'("Gathemo"),50150,287,292,27,10.41,-0.966667,48.7667,230,367),
(50,new String'("Chambres"),50320,121,92,28,4.18,-1.38333,48.7667,68,133),
(50,new String'("Saint-Sauveur-le-Vicomte"),50390,2082,2211,60,34.27,-1.53333,49.3833,2,91),
(50,new String'("Juvigny-le-Tertre"),50520,610,675,81,7.5,-1.01667,48.6833,135,283),
(50,new String'("Brectouville"),50160,167,157,44,3.74,-1.01667,49.0167,29,137),
(50,new String'("Le Chefresne"),50410,311,279,27,11.28,-1.15,48.9,115,228),
(50,new String'("Saint-Denis-le-Vêtu"),50210,608,590,43,14.08,-1.4,48.9833,20,121),
(50,new String'("Le Neufbourg"),50140,488,534,216,2.25,-0.95,48.65,160,286),
(50,new String'("Saint-Michel-de-la-Pierre"),50490,205,183,48,4.25,-1.38333,49.1333,25,109),
(50,new String'("Bourguenolles"),50800,324,243,42,7.65,-1.3,48.8,91,184),
(50,new String'("Barfleur"),50760,643,642,1071,0.6,-1.25,49.6667,0,8),
(50,new String'("Saint-Fromond"),50620,763,665,49,15.52,-1.1,49.2167,0,53),
(50,new String'("Longueville"),50290,620,529,152,4.07,-1.55,48.85,20,68),
(50,new String'("Giéville"),50160,683,589,66,10.33,-0.983333,49.0167,53,150),
(50,new String'("Cherbourg-Octeville"),50100,38433,25337,2695,14.26,-1.65,49.65,0,139),
(50,new String'("Roncey"),50210,826,799,67,12.15,-1.33333,48.9833,33,131),
(50,new String'("Vauville"),50440,383,368,23,16.35,0.153612,49.6376,3,182),
(50,new String'("Saint-Georges-de-Rouelley"),50720,542,519,26,20.52,-0.77024,48.6029,119,283),
(50,new String'("La Colombe"),50800,633,564,44,14.37,-1.18333,48.8667,88,247),
(50,new String'("Martinvast"),50690,1189,1116,115,10.31,-1.66667,49.6,17,155),
(50,new String'("Virandeville"),50690,804,763,97,8.22,-1.75,49.5667,31,95),
(50,new String'("Neuville-en-Beaumont"),50250,38,45,22,1.69,-1.6,49.35,7,41),
(50,new String'("Coigny"),50250,206,204,45,4.5,-1.38333,49.3167,4,36),
(50,new String'("Saint-Christophe-du-Foc"),50340,398,276,111,3.58,-1.75,49.55,44,99),
(50,new String'("Quettetot"),50260,728,562,58,12.43,-1.66667,49.4833,34,159),
(50,new String'("Helleville"),50340,438,324,74,5.88,-1.78333,49.55,60,138),
(50,new String'("Tonneville"),50460,658,594,171,3.84,-1.71667,49.6333,19,171),
(50,new String'("Biniville"),50390,103,89,34,2.98,-1.48333,49.4333,14,40),
(50,new String'("Houtteville"),50250,93,81,20,4.51,-1.36667,49.3333,1,37),
(50,new String'("Fresville"),50310,373,326,26,13.94,-1.35,49.4333,1,36),
(50,new String'("Pontaubault"),50220,472,445,243,1.94,-1.35,48.6333,7,72),
(50,new String'("Benoîtville"),50340,592,458,71,8.29,-1.78333,49.5333,35,131),
(50,new String'("Varenguebec"),50250,361,292,17,21.19,-1.5,49.3333,2,131),
(50,new String'("Saint-Pierre-de-Semilly"),50810,420,378,91,4.59,-1.0,49.1167,78,174),
(50,new String'("Saint-Vaast-la-Hougue"),50550,2028,2128,322,6.28,-1.26667,49.6,0,10),
(50,new String'("Saint-Lô"),50000,18718,20081,807,23.19,-1.08333,49.1167,7,134),
(50,new String'("Chef-du-Pont"),50480,743,749,196,3.78,-1.33333,49.3833,0,18),
(50,new String'("Rampan"),50000,218,212,53,4.09,-1.15,49.1333,7,78),
(50,new String'("Barneville-Carteret"),50270,2283,2431,221,10.29,0.247223,49.3812,0,100),
(50,new String'("Cambernon"),50200,719,699,42,17.01,-1.38333,49.0833,57,177),
(50,new String'("Fontenay-sur-Mer"),50310,168,176,20,8.18,-1.31667,49.4833,1,43),
(50,new String'("Saint-Romphaire"),50750,744,595,74,9.97,-1.1,49.0333,18,155),
(50,new String'("Le Dézert"),50620,548,505,37,14.58,-1.16667,49.2,8,52),
(50,new String'("Le Mesnil-Amey"),50570,272,254,96,2.81,-1.2,49.1,43,109),
(50,new String'("Chéris"),50220,266,235,45,5.87,-1.25,48.6333,12,140),
(50,new String'("Savigny-le-Vieux"),50640,422,494,24,17.16,-1.05,48.5167,87,220),
(50,new String'("Saussemesnil"),50700,920,914,42,21.45,-1.46667,49.5667,60,175),
(50,new String'("Notre-Dame-de-Cenilly"),50210,704,689,27,25.23,-1.25,49.0,50,141),
(50,new String'("Champeaux"),50530,358,321,83,4.29,-1.53333,48.7333,0,103),
(50,new String'("Ponts"),50300,592,443,88,6.7,-1.35,48.7,7,72),
(50,new String'("Saint-Aubin-du-Perron"),50490,238,219,31,7.62,-1.36667,49.15,15,88),
(50,new String'("Rauville-la-Place"),50390,388,436,32,11.88,-1.5,49.3833,2,46),
(50,new String'("Théville"),50330,304,243,39,7.77,-1.41667,49.65,59,136),
(50,new String'("Barenton"),50720,1255,1348,35,34.88,-0.833333,48.6,88,297),
(50,new String'("Soulles"),50750,468,395,31,14.86,-1.18333,49.0167,81,180),
(50,new String'("Marcey-les-Grèves"),50300,1271,1093,188,6.73,-1.38333,48.7,6,46),
(50,new String'("Saint-Pair-sur-Mer"),50380,3842,3623,266,14.42,-1.56667,48.8167,2,72),
(50,new String'("Canville-la-Rocque"),50580,130,130,24,5.35,-1.63333,49.35,7,43),
(50,new String'("Hémevez"),50700,173,148,40,4.3,-1.43333,49.4667,6,28),
(50,new String'("Étienville"),50360,330,344,44,7.36,-1.41667,49.3833,2,30),
(50,new String'("Le Plessis-Lastelle"),50250,258,281,17,14.99,0.573612,49.2812,2,130),
(50,new String'("Marigny"),50570,2141,1874,207,10.31,-1.25,49.1,32,112),
(50,new String'("Lessay"),50430,2025,1768,91,22.23,-1.53333,49.2167,5,42),
(50,new String'("Saint-Cyr"),50310,210,178,36,5.7,-1.41667,49.4833,7,84),
(50,new String'("Saint-Germain-d'Elle"),50810,204,198,22,8.87,-0.916667,49.1167,90,196),
(50,new String'("Beuzeville-la-Bastille"),50360,150,161,34,4.34,-1.36667,49.35,2,37),
(50,new String'("Montsurvent"),50200,344,279,41,8.33,-1.5,49.1167,31,88),
(50,new String'("Gatteville-le-Phare"),50760,497,566,51,9.7,-1.28333,49.6833,0,36),
(50,new String'("Bion"),50140,401,431,31,12.67,-0.916667,48.6167,76,305),
(50,new String'("La Gohannière"),50300,127,86,33,3.78,-1.25,48.7,12,137),
(50,new String'("Pont-Hébert"),50880,1780,1712,118,14.99,-1.13333,49.1667,5,83),
(50,new String'("Ozeville"),50310,148,124,31,4.7,-1.33333,49.5,20,72),
(50,new String'("Sainte-Marie-du-Bois"),50640,58,55,12,4.77,-0.9,48.5667,100,210),
(50,new String'("Précey"),50220,488,339,63,7.73,-1.38333,48.6,13,73),
(50,new String'("Auderville"),50440,267,284,61,4.33,-1.93104,49.7136,0,133),
(50,new String'("Reffuveille"),50520,476,498,20,23.34,-1.11667,48.6667,69,244),
(50,new String'("Ducey"),50220,2478,2179,221,11.21,-1.3,48.6167,6,113),
(50,new String'("Brouains"),50150,194,213,51,3.79,-0.967778,48.7214,105,263),
(50,new String'("Domjean"),50420,1023,820,61,16.57,-1.03333,48.9833,30,178),
(50,new String'("Varouville"),50330,267,274,63,4.19,-1.36667,49.6667,22,108),
(50,new String'("Le Vicel"),50760,146,113,30,4.74,-1.31667,49.6333,8,122),
(50,new String'("Urville"),50700,194,185,37,5.15,-1.43333,49.45,6,33),
(50,new String'("Romagny"),50140,1030,1013,34,29.46,-0.966667,48.65,70,287),
(50,new String'("Argouges"),50240,549,541,33,16.41,-1.4,48.5,25,133),
(50,new String'("Valognes"),50700,7190,7538,460,15.63,-1.46667,49.5167,19,87),
(50,new String'("Gréville-Hague"),50440,767,721,76,10.03,-1.8,49.6667,0,167),
(50,new String'("Créances"),50710,2182,2014,107,20.32,-1.56667,49.2,0,35),
(50,new String'("Réthoville"),50330,134,124,39,3.43,-1.35,49.7,0,45),
(50,new String'("Sourdeval-les-Bois"),50450,176,181,30,5.86,-1.26667,48.9167,55,184),
(50,new String'("Vengeons"),50150,481,517,30,15.75,-0.916667,48.75,160,352),
(50,new String'("Gratot"),50200,663,611,61,10.73,-1.48333,49.0667,33,147),
(50,new String'("Le Mesnil"),50580,198,162,57,3.45,-1.69167,49.3667,20,76),
(50,new String'("Canisy"),50860,1028,934,164,6.25,-1.16667,49.0833,39,116),
(50,new String'("Montebourg"),50310,2105,2024,357,5.89,-1.38333,49.4833,21,116),
(50,new String'("Yvetot-Bocage"),50700,1139,1025,91,12.46,-1.5,49.4833,13,75),
(50,new String'("Saint-Jean-de-la-Haize"),50300,500,400,55,8.95,-1.36667,48.7,7,128),
(50,new String'("Baubigny"),50270,156,166,24,6.41,-1.8,49.4333,0,80),
(50,new String'("Saint-Clair-sur-l'Elle"),50680,911,865,114,7.99,-1.03333,49.2,12,95),
(50,new String'("La Haye-Pesnel"),50320,1367,1320,217,6.29,-1.4,48.8,62,134),
(50,new String'("Sourdeval"),50150,2782,3032,77,36.12,-0.933333,48.7333,155,354),
(50,new String'("Rouxeville"),50810,337,299,57,5.83,-0.95,49.1,99,199),
(50,new String'("Anneville-en-Saire"),50760,386,324,64,6.0,-1.28333,49.6333,1,111),
(50,new String'("Auxais"),50500,180,136,23,7.76,-1.28333,49.2167,2,19),
(50,new String'("Tocqueville"),50330,260,280,44,5.9,-1.33333,49.6667,8,71),
(50,new String'("Rocheville"),50260,649,559,64,10.07,-1.6,49.5,22,135),
(50,new String'("Ver"),50450,375,286,28,13.27,-1.38333,48.9,20,118),
(50,new String'("Écoquenéauville"),50480,69,68,19,3.52,-1.28333,49.4,5,37),
(50,new String'("Isigny-le-Buat"),50540,3282,3058,44,73.31,-1.16667,48.6167,23,215),
(50,new String'("Octeville-l'Avenel"),50630,193,167,28,6.86,0.645834,49.5437,20,82),
(50,new String'("Pieux"),50340,3558,3474,233,15.25,-1.8,49.5167,5,132),
(50,new String'("Ancteville"),50200,246,204,31,7.74,-1.48333,49.1,44,128),
(50,new String'("Montgardon"),50250,414,418,31,13.32,-1.56667,49.2833,9,88),
(50,new String'("Saint-Jores"),50250,361,462,28,12.73,-1.41667,49.3,1,44),
(50,new String'("Pirou"),50770,1589,1319,54,29.11,-1.58333,49.1833,0,40),
(50,new String'("Saint-Sauveur-la-Pommeraye"),50510,308,272,58,5.27,-1.45,48.85,64,131),
(50,new String'("Cretteville"),50250,230,220,33,6.83,-1.38333,49.35,2,37),
(50,new String'("Digulleville"),50440,291,247,36,7.89,-1.86667,49.7,0,182),
(50,new String'("La Meurdraquière"),50510,157,144,20,7.6,-1.4,48.85,32,126),
(50,new String'("Carneville"),50330,228,222,33,6.88,-1.45,49.6667,30,139),
(50,new String'("Bricquebec"),50260,4256,4366,130,32.66,-1.63333,49.4667,7,161),
(50,new String'("Saint-Amand"),50160,2257,2004,77,29.2,-0.966667,49.05,43,218),
(50,new String'("Crollon"),50220,242,213,51,4.68,-1.38333,48.5833,24,80),
(50,new String'("Le Mont-Saint-Michel"),50170,43,46,10,3.97,0.489723,48.6359,5,57),
(50,new String'("Veys"),50500,401,358,26,14.88,-1.15,49.3167,0,32),
(50,new String'("Gonfreville"),50190,160,153,17,9.04,-1.4,49.2333,3,33),
(50,new String'("Servon"),50170,255,250,27,9.23,-1.41667,48.6,6,48),
(50,new String'("Denneville"),50580,553,480,67,8.24,-1.65,49.3167,4,38),
(50,new String'("Sainteny"),50500,811,785,37,21.63,-1.31667,49.2333,2,26),
(50,new String'("La Godefroy"),50300,224,155,61,3.65,-1.3,48.6833,40,137),
(50,new String'("Beuzeville-au-Plain"),50480,47,46,23,2.04,-1.3,49.4333,14,41),
(50,new String'("Hérenguerville"),50660,182,128,67,2.71,-1.5,48.9833,25,56),
(50,new String'("Saint-Germain-de-Varreville"),50480,119,119,20,5.81,-1.25,49.4333,1,40),
(50,new String'("Bricqueville-la-Blouette"),50200,547,543,87,6.25,-1.48333,49.0333,5,96),
(50,new String'("Saint-Planchers"),50400,1347,1119,112,11.96,-1.51667,48.8167,17,98),
(50,new String'("Gouvets"),50420,268,265,24,11.01,-1.1,48.9333,74,277),
(50,new String'("Trelly"),50660,668,498,56,11.77,-1.43333,48.9667,11,112),
(50,new String'("Regnéville-sur-Mer"),50590,831,794,97,8.5,-1.55,49.0167,5,43),
(50,new String'("Graignes-Mesnil-Angot"),50620,793,618,43,18.35,-1.2,49.25,0,37),
(50,new String'("Tribehou"),50620,496,519,49,9.97,-1.23333,49.2167,0,24),
(50,new String'("Vesly"),50430,659,541,29,22.48,-1.5,49.25,6,123),
(50,new String'("Villebaudon"),50410,299,283,52,5.69,-1.16667,48.9667,99,183),
(50,new String'("Le Mesnil-Rainfray"),50520,244,237,21,11.47,-1.05,48.6667,125,252),
(50,new String'("Quinéville"),50310,298,294,64,4.6,-1.3,49.5167,1,67),
(50,new String'("Sartilly"),50530,1535,1265,133,11.53,-1.45,48.75,35,119),
(50,new String'("Dragey-Ronthon"),50530,799,615,52,15.17,0.502779,48.7117,6,115),
(50,new String'("Saint-Sauveur-Lendelin"),50490,1692,1336,103,16.39,-1.41667,49.1333,23,123),
(50,new String'("Beuvrigny"),50420,139,95,20,6.77,-1.0,48.9667,60,216),
(50,new String'("Carantilly"),50570,609,530,56,10.7,-1.23333,49.0667,67,119),
(50,new String'("Le Mesnil-Adelée"),50520,189,167,27,6.82,-1.06667,48.7,47,231),
(50,new String'("Le Vrétot"),50260,585,522,28,20.56,-1.71667,49.45,18,127),
(50,new String'("Geffosses"),50560,417,406,27,15.07,-1.55,49.1333,2,39),
(50,new String'("Biéville"),50160,173,146,31,5.56,-0.883333,49.0833,82,160),
(50,new String'("La Lucerne-d'Outremer"),50320,833,736,57,14.48,-1.43333,48.7833,31,146),
(50,new String'("Lamberville"),50160,171,169,24,7.12,-0.9,49.0833,95,181),
(50,new String'("Siouville-Hague"),50340,1104,994,173,6.37,0.160557,49.5581,5,99),
(50,new String'("Gourfaleur"),50750,452,433,53,8.45,-1.11667,49.0833,12,100),
(50,new String'("Appeville"),50500,205,222,15,13.2,-1.33333,49.3167,0,34),
(50,new String'("Le Hommet-d'Arthenay"),50620,433,327,29,14.85,-1.18333,49.1833,0,54),
(50,new String'("Orval"),50660,864,812,68,12.54,-1.46667,49.0167,4,88),
(50,new String'("Montviron"),50530,344,265,58,5.91,-1.41667,48.7333,27,121),
(50,new String'("Montcuit"),50490,197,175,41,4.79,-1.33333,49.1167,40,142),
(50,new String'("Nay"),50190,80,73,31,2.51,-1.36667,49.2333,2,13),
(50,new String'("Guéhébert"),50210,115,135,18,6.29,0.626668,48.97,25,121),
(50,new String'("Tessy-sur-Vire"),50420,1454,1433,91,15.9,-1.06667,48.9667,34,210),
(50,new String'("La Vendelée"),50200,431,374,85,5.04,-1.46667,49.0833,60,139),
(50,new String'("Le Lorey"),50570,605,556,41,14.57,-1.3,49.1,38,147),
(50,new String'("Montrabot"),50810,80,87,20,3.86,-0.883333,49.1167,77,191),
(50,new String'("Blainville-sur-Mer"),50560,1576,1315,135,11.6,-1.58333,49.0667,1,67),
(50,new String'("Montabot"),50410,291,272,25,11.56,-1.11667,48.9333,85,272),
(50,new String'("La Chapelle-en-Juger"),50570,655,628,43,15.0,-1.21667,49.1333,17,112),
(50,new String'("Hauteville-la-Guichard"),50570,454,373,37,11.98,0.698057,49.1264,11,111),
(50,new String'("Montchaton"),50660,333,333,51,6.5,-1.5,49.0167,5,61),
(50,new String'("La Ronde-Haye"),50490,347,274,52,6.67,-1.45,49.1333,33,93),
(50,new String'("Saint-Georges-Montcocq"),50000,829,896,92,8.94,-1.08333,49.1333,7,126),
(50,new String'("Hautteville-Bocage"),50390,130,88,30,4.22,-1.46667,49.4333,10,39),
(50,new String'("Villiers-Fossard"),50680,558,465,65,8.52,-1.06667,49.1667,20,133),
(50,new String'("Torigni-sur-Vire"),50160,2377,2579,789,3.01,-0.983333,49.0333,53,139),
(50,new String'("Le Theil"),50330,671,558,48,13.81,0.527779,49.6092,47,132),
(50,new String'("Servigny"),50200,211,165,53,3.95,-1.46667,49.1,49,98),
(50,new String'("Saint-Rémy-des-Landes"),50580,208,217,25,8.3,-1.63333,49.2833,4,39),
(50,new String'("Canteloup"),50330,195,174,45,4.28,0.647779,49.6456,55,124),
(50,new String'("La Baleine"),50450,94,118,22,4.13,-1.31667,48.9167,37,171),
(50,new String'("Gouville-sur-Mer"),50560,2042,1685,154,13.24,-1.58333,49.1,0,46),
(50,new String'("Gorges"),50190,360,356,15,22.67,-1.4,49.2667,1,38),
(50,new String'("Saint-Maurice-en-Cotentin"),50270,288,231,38,7.46,-1.7,49.3833,34,126),
(50,new String'("Poilley"),50220,869,668,68,12.65,-1.31667,48.6167,5,72),
(50,new String'("Le Mesnilbus"),50490,286,261,57,4.98,-1.35,49.1333,32,121),
(50,new String'("Sainte-Croix-Hague"),50440,752,608,76,9.84,-1.76667,49.6333,60,182),
(50,new String'("Saint-Georges-de-Bohon"),50500,407,427,29,13.96,-1.25,49.25,0,25),
(50,new String'("Maupertuis"),50410,135,127,24,5.41,-1.2,48.95,104,171),
(50,new String'("La Luzerne"),50680,48,47,24,1.94,-1.05,49.1333,60,137),
(50,new String'("Sotteville"),50340,464,347,75,6.13,-1.75,49.5333,55,138),
(50,new String'("Parigny"),50600,1832,1708,157,11.62,-1.08333,48.6,59,117),
(50,new String'("Beauchamps"),50320,382,354,93,4.1,-1.36667,48.8333,52,136),
(50,new String'("Houesville"),50480,310,223,57,5.38,-1.28333,49.35,2,26),
(50,new String'("La Bazoge"),50520,163,161,28,5.8,-1.03333,48.65,92,212),
(50,new String'("Sainte-Geneviève"),50760,313,293,63,4.95,-1.31667,49.65,9,60),
(50,new String'("Quibou"),50750,918,817,53,17.15,-1.2,49.0667,46,114),
(50,new String'("Juilley"),50220,598,474,53,11.23,-1.35,48.6,25,86),
(50,new String'("Céaux"),50220,444,379,52,8.39,-1.38333,48.6333,5,71),
(50,new String'("Le Luot"),50870,224,176,26,8.5,-1.31667,48.75,80,182),
(50,new String'("Camprond"),50210,386,318,61,6.27,-1.35,49.0833,70,178),
(50,new String'("Macey"),50170,114,98,19,5.87,-1.43333,48.5667,16,74),
(50,new String'("Chérencé-le-Roussel"),50520,307,330,28,10.95,-1.01667,48.7,61,290),
(50,new String'("Brucheville"),50480,143,147,10,13.33,-1.2,49.3667,0,21),
(50,new String'("Cerisy-la-Salle"),50210,1018,936,60,16.86,-1.28333,49.0333,58,169),
(50,new String'("Saussey"),50200,502,509,56,8.89,-1.43333,49.0167,10,108),
(50,new String'("Millières"),50190,736,562,36,20.27,-1.46667,49.1833,7,53),
(50,new String'("Urville-Nacqueville"),50460,2183,2228,188,11.58,-1.73333,49.6833,0,148),
(50,new String'("La Haye-du-Puits"),50250,1662,1878,316,5.25,-1.55,49.3,29,94),
(50,new String'("Pontorson"),50170,4114,4109,95,43.01,-1.51667,48.55,5,73),
(50,new String'("Airel"),50680,531,485,52,10.17,-1.08333,49.2167,1,44),
(50,new String'("Acqueville"),50440,650,650,112,5.79,-1.75,49.6083,72,178),
(50,new String'("Sainte-Cécile"),50800,814,728,72,11.29,-1.18333,48.8333,112,226),
(50,new String'("Carquebut"),50480,301,296,35,8.54,-1.33333,49.3667,2,34),
(50,new String'("Agneaux"),50180,4020,4468,618,6.5,-1.1,49.1167,7,86),
(50,new String'("Réville"),50760,1179,1174,111,10.55,-1.25,49.6167,0,16),
(50,new String'("Portbail"),50580,1656,1675,84,19.56,-1.7,49.3333,2,90),
(50,new String'("La Glacerie"),50470,5501,5403,294,18.7,-1.56667,49.6,5,178),
(50,new String'("Saint-Vigor-des-Monts"),50420,295,285,18,15.74,-1.08333,48.9167,50,277),
(50,new String'("Vierville"),50480,39,41,9,4.1,-1.25,49.3667,2,23),
(50,new String'("Vains"),50300,724,668,84,8.58,-1.41667,48.6833,5,39),
(50,new String'("Saint-Martin-des-Champs"),50300,2223,2095,342,6.49,-1.33333,48.6667,8,111),
(50,new String'("Le Mesnil-au-Val"),50110,676,556,50,13.34,-1.53333,49.6,73,178),
(50,new String'("Beaumont-Hague"),50440,1484,1384,187,7.9,-1.85,49.6667,5,179),
(50,new String'("Cérences"),50510,1804,1758,69,26.04,-1.43333,48.9167,14,115),
(50,new String'("Orglandes"),50390,338,310,36,9.26,-1.45,49.4167,5,38),
(50,new String'("Le Val-Saint-Père"),50300,1853,1574,166,11.1,-1.35,48.6667,4,111),
(50,new String'("Saint-Côme-du-Mont"),50500,534,462,41,12.91,-1.26667,49.3333,0,32),
(50,new String'("Blosville"),50480,268,206,63,4.22,-1.28333,49.3667,2,38),
(50,new String'("Hébécrevon"),50180,1138,969,84,13.39,-1.16667,49.1333,7,108),
(50,new String'("Saint-Pierre-de-Coutances"),50200,410,318,101,4.04,0.550834,49.0359,11,125),
(50,new String'("Vessey"),50170,411,398,32,12.59,-1.43333,48.5167,19,87),
(50,new String'("Saint-Martin-d'Audouville"),50310,125,130,34,3.64,-1.33333,49.5333,15,56),
(50,new String'("Saint-Jacques-de-Néhou"),50390,534,412,24,21.49,-1.61667,49.4167,7,100),
(50,new String'("Le Guislain"),50410,117,122,21,5.39,-1.23333,48.9667,100,141),
(50,new String'("Boutteville"),50480,57,62,31,1.82,-1.25,49.3833,3,38),
(50,new String'("Le Mesnil-Opac"),50860,266,214,47,5.58,-1.1,49.0167,65,161),
(50,new String'("Saint-Pierre-d'Arthéglise"),50270,151,128,28,5.36,-1.68333,49.4167,29,141),
(50,new String'("Quettreville-sur-Sienne"),50660,1438,1234,89,16.14,-1.46667,48.9667,8,68),
(50,new String'("Précorbin"),50810,522,428,72,7.21,-0.95,49.0833,49,216),
(50,new String'("Hudimesnil"),50510,866,713,46,18.68,-1.48333,48.8667,28,117),
(50,new String'("Le Mesnil-Rouxelin"),50000,506,441,106,4.74,-1.08333,49.15,65,137),
(50,new String'("Gonneville"),50330,874,852,56,15.36,-1.46667,49.6333,52,156),
(50,new String'("Notre-Dame-d'Elle"),50810,130,122,45,2.85,-0.966667,49.1167,114,195),
(50,new String'("Gourbesville"),50480,173,156,21,8.18,-1.41667,49.4167,3,31),
(50,new String'("Nouainville"),50690,448,528,117,3.81,-1.68333,49.6167,45,150),
(50,new String'("Chérencé-le-Héron"),50800,378,409,39,9.54,0.803334,48.802,129,226),
(50,new String'("Brix"),50700,2067,1927,64,32.16,-1.58333,49.55,39,176),
(50,new String'("Nicorps"),50200,422,377,74,5.63,-1.41667,49.0333,15,108),
(50,new String'("Lingeard"),50670,85,86,23,3.65,-1.03333,48.7333,110,287),
(50,new String'("Angoville-au-Plain"),50480,51,53,8,5.68,-1.25,49.35,2,32),
(50,new String'("Martigny"),50600,317,318,35,8.89,-1.11667,48.6167,69,131),
(50,new String'("Le Teilleul"),50640,1284,1376,42,30.45,-0.883333,48.55,103,222),
(50,new String'("Couville"),50690,970,820,112,8.6,-1.68333,49.55,45,130),
(50,new String'("Saint-Germain-sur-Ay"),50430,897,797,61,14.52,-1.6,49.2333,0,39),
(50,new String'("Saint-Symphorien-des-Monts"),50640,142,153,20,6.81,-1.0,48.55,117,222),
(50,new String'("Beauvoir"),50170,423,427,29,14.29,-1.5,48.6,5,40),
(50,new String'("Remilly-sur-Lozon"),50570,660,557,69,9.56,-1.25,49.1833,1,45),
(50,new String'("Saint-Senier-sous-Avranches"),50300,1282,967,148,8.62,-1.33333,48.6833,7,126),
(50,new String'("Maupertus-sur-Mer"),50330,256,270,74,3.42,-1.48333,49.6667,0,152),
(50,new String'("Villiers-le-Pré"),50240,192,196,24,7.94,-1.4,48.55,48,92),
(50,new String'("Le Mesnil-Aubert"),50510,155,152,26,5.96,-1.41667,48.95,14,117),
(50,new String'("Grimesnil"),50450,63,51,24,2.61,-1.35,48.95,45,118),
(50,new String'("Le Loreur"),50510,228,177,70,3.23,-1.43333,48.8667,54,121),
(50,new String'("Montfarville"),50760,800,859,148,5.4,-1.26667,49.65,0,28),
(50,new String'("Vergoncey"),50240,211,210,27,7.73,-1.4,48.5667,16,87),
(50,new String'("Audouville-la-Hubert"),50480,57,83,8,6.4,-1.23333,49.4167,1,22),
(50,new String'("Fermanville"),50840,1401,1418,120,11.6,-1.45,49.6833,0,136),
(50,new String'("Saint-Maur-des-Bois"),50800,131,138,26,4.97,-1.15,48.8167,129,239)
);
   
   function Nb_Villes return Integer is
   begin
      Compte_Appel ;
      return Objects'Length ;
   end Nb_Villes ;
   
   procedure Check_Range (No : Integer ; Msg : String) is
   begin
      Compte_Appel ;
      if No not in Objects'Range then
         -- CHANGE (message d'erreur)
         GAda.Core.Put_Err("ERREUR : Appel de " & Msg & " avec un numéro de ville égal à " & Integer'Image(No) &
			     " alors que les villes sont numérotées de 1 à " & Integer'Image(Nb_Villes)) ;
         raise Program_Error ;
      end if ;
   end Check_Range ;
   
   function Denomination(No : Integer) return String is
   begin
      Check_Range(No, "Denomination") ;
      return Objects(No).V2.all ;
   end Denomination ;
   
   function Fiche_Ville(No : Integer) return T_Fiche is
      Obj : T_Info ;
   begin
      Check_Range(No, "Fiche_Ville") ;
      Obj := Objects(No) ;
      
      return
	( Departement => Obj.V1,
	  Code_Postal => Obj.V3,
	  Pop2010     => Obj.V4,
	  Pop1999     => Obj.V5,
	  Surface     => Obj.V7,
	  Longitude   => Obj.V8,
	  Latitude    => Obj.V9,
	  Alt_Bas     => Obj.V10,
	  Alt_Haute   => Obj.V11 ) ;
      
   end Fiche_Ville ;
   
end Villes ;

