//
// En 2013, la gestion des cookies se fait apparemment encore à la main...
// Pitoyable.
//
function createCookie(name,value,days) {
    if (days) {
	var date = new Date();
	date.setTime(date.getTime()+(days*24*60*60*1000));
	var expires = "; expires="+date.toGMTString();
    }
    else var expires = "";

    var nPage = window.location.pathname;
        nPage = nPage.substring(nPage.lastIndexOf('/') + 1);


    document.cookie = name+"="+value+expires+"; path="+nPage;
}

function readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
	var c = ca[i];
	while (c.charAt(0)==' ') c = c.substring(1,c.length);
	if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}

function toggleFold(nodeImg, img1, img2)
{
    
    // Get the parent
    var node = nodeImg.parentNode ;

    // Look for the first div inside this node.
    var sibling = node ;

    do {
	sibling = sibling.nextSibling ;
    } while (sibling.nodeName.toLowerCase() != "div") ;

    var expand = (sibling.classList.contains("hidden")) ;
    var cookiename = (sibling.getAttribute('id')) + "-isshown" ;

    if (expand) {
	sibling.classList.remove("hidden") ;
	sibling.classList.add("shown") ;
	nodeImg.src = img1 ;
	createCookie(cookiename,"true", 100) ;
    }
    else {
	sibling.classList.remove("shown") ;
	sibling.classList.add("hidden") ;
	nodeImg.src = img2 ;
	createCookie(cookiename,"false", 100) ;
    }

}


// Au chargement, init
window.onload = function () {

    var collapsibles = document.getElementsByClassName('collapsible') ;

    for(var i=0; i<collapsibles.length; i++) {
	var adiv = collapsibles[i] ;
	var cookiename = (adiv.getAttribute('id')) + "-isshown" ;
	var cookieval  = readCookie(cookiename) ;
	var cookieshow = cookieval == "true" ;

	var defaultval = "" ;

	// No cookie. Get a default value.
	if (cookieval == null) {
	    // Should this node be hidden by default ?
	    cookieval = "" ;
	    if (adiv.classList.contains("hidden_default")) {
		cookieshow = false ;
	    }
	    else {
		// Visible by default.
		cookieshow = true ;
	    }
	}

	if (cookieval != null) {
	
	    var shown = (adiv.classList.contains("shown")) ;

	    // Look for the H2 tag previous to this node.
	    var sibling = adiv ;
	    
	    do {
		sibling = sibling.previousSibling ;
	    } while (sibling.nodeName.toLowerCase() != "h2") ;

	    var childs = sibling.childNodes;
	    var index = 0 ;
	    
	    // Then, look for the first IMG inside this node
	    do {
		child = childs[index++] ;
	    } while (child.nodeName.toLowerCase() != "img") ;	
	    
	    if ((shown && !cookieshow) || (cookieshow && !shown)) {
		child.onclick.apply(child);
	    }
	}
    }
}

