#include <stdio.h>
#include <stdarg.h>
#include "log.h"

static int lvl = LOG_LEVEL_ERROR;

FILE **file_error;
FILE **file_note;
FILE **file_debug;

void log_init(void) {
  file_error = &stderr;
  file_note = &stdout;
  file_debug = &stdout;
}

void log_level(int l) {
  lvl = l;
}

int log_log(FILE **stream, int l, const char *prefix, const char *file, const
    char *func, int line, const char *fmt, ...) {
  va_list arg;
  va_start(arg, fmt);
  int ret;
  if (lvl >= l) {
    fprintf(*stream, "%s%s:%d in %s(): ", prefix, file, line, func);
    ret = vfprintf(*stream, fmt, arg);
  }
  va_end(arg);
  return ret;
}

int log_raw(FILE **stream, int l, const char *fmt, ...) {
  va_list arg;
  va_start(arg, fmt);
  int ret;
  if (lvl >= l) {
    ret = vfprintf(*stream, fmt, arg);
  }
  va_end(arg);
  return ret;
}

void hexdump(void *ptr, int buflen) {
  unsigned char *buf = (unsigned char*)ptr;
  int i, j;
  for (i=0; i<buflen; i+=16) {
    printf("%06x: ", i);
    for (j=0; j<16; j++)
      if (i+j < buflen)
        printf("%02x ", buf[i+j]);
      else
        printf("   ");
    printf(" ");
    for (j = 0; j < 16; j++) {
      if (i+j < buflen){
        printf("%c", isprint(buf[i+j]) ? buf[i+j] : '.');
      }
    }
    printf("\n");
  }
}
