#ifndef __LOG_PROTOCOL_H__
#define __LOG_PROTOCOL_H__

#define _LOG_MAX_FILE_SIZE 0x100

// Log descriptor
struct log_desc {
  int type;
  int data_length;
  union {
    // Context packet
    struct {
      // Sets the maximum log fil size to generate
      int maximum_log_file_size;
      // Byte wise order revese applied to the buffer before file dump
      int reverse_order;
    };
    // Data packet
    int end_of_file;
  };
};

enum log_desc_type {
  LOG_DESC_CONTEXT,
  LOG_DESC_DATA,
  LOG_DESC_END
};

#endif//__LOG_PROTOCOL_H__
